/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BatchPredictionJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BATCH_PREDICTION_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/batchPredictionJobs/{batch_prediction_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String batchPredictionJob;

    @Deprecated
    protected BatchPredictionJobName() {
        this.project = null;
        this.location = null;
        this.batchPredictionJob = null;
    }

    private BatchPredictionJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.batchPredictionJob = (String)Preconditions.checkNotNull((Object)builder.getBatchPredictionJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBatchPredictionJob() {
        return this.batchPredictionJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BatchPredictionJobName of(String project, String location, String batchPredictionJob) {
        return BatchPredictionJobName.newBuilder().setProject(project).setLocation(location).setBatchPredictionJob(batchPredictionJob).build();
    }

    public static String format(String project, String location, String batchPredictionJob) {
        return BatchPredictionJobName.newBuilder().setProject(project).setLocation(location).setBatchPredictionJob(batchPredictionJob).build().toString();
    }

    public static BatchPredictionJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_BATCH_PREDICTION_JOB.validatedMatch(formattedString, "BatchPredictionJobName.parse: formattedString not in valid format");
        return BatchPredictionJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("batch_prediction_job"));
    }

    public static List<BatchPredictionJobName> parseList(List<String> formattedStrings) {
        ArrayList<BatchPredictionJobName> list = new ArrayList<BatchPredictionJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BatchPredictionJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BatchPredictionJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BatchPredictionJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BATCH_PREDICTION_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BatchPredictionJobName batchPredictionJobName = this;
            synchronized (batchPredictionJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.batchPredictionJob != null) {
                        fieldMapBuilder.put((Object)"batch_prediction_job", (Object)this.batchPredictionJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_BATCH_PREDICTION_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "batch_prediction_job", this.batchPredictionJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BatchPredictionJobName that = (BatchPredictionJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.batchPredictionJob, that.batchPredictionJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.batchPredictionJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String batchPredictionJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBatchPredictionJob() {
            return this.batchPredictionJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBatchPredictionJob(String batchPredictionJob) {
            this.batchPredictionJob = batchPredictionJob;
            return this;
        }

        private Builder(BatchPredictionJobName batchPredictionJobName) {
            this.project = batchPredictionJobName.project;
            this.location = batchPredictionJobName.location;
            this.batchPredictionJob = batchPredictionJobName.batchPredictionJob;
        }

        public BatchPredictionJobName build() {
            return new BatchPredictionJobName(this);
        }
    }
}

