/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotebookExecutionJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NOTEBOOK_EXECUTION_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/notebookExecutionJobs/{notebook_execution_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String notebookExecutionJob;

    @Deprecated
    protected NotebookExecutionJobName() {
        this.project = null;
        this.location = null;
        this.notebookExecutionJob = null;
    }

    private NotebookExecutionJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.notebookExecutionJob = (String)Preconditions.checkNotNull((Object)builder.getNotebookExecutionJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNotebookExecutionJob() {
        return this.notebookExecutionJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotebookExecutionJobName of(String project, String location, String notebookExecutionJob) {
        return NotebookExecutionJobName.newBuilder().setProject(project).setLocation(location).setNotebookExecutionJob(notebookExecutionJob).build();
    }

    public static String format(String project, String location, String notebookExecutionJob) {
        return NotebookExecutionJobName.newBuilder().setProject(project).setLocation(location).setNotebookExecutionJob(notebookExecutionJob).build().toString();
    }

    public static NotebookExecutionJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NOTEBOOK_EXECUTION_JOB.validatedMatch(formattedString, "NotebookExecutionJobName.parse: formattedString not in valid format");
        return NotebookExecutionJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("notebook_execution_job"));
    }

    public static List<NotebookExecutionJobName> parseList(List<String> formattedStrings) {
        ArrayList<NotebookExecutionJobName> list = new ArrayList<NotebookExecutionJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotebookExecutionJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotebookExecutionJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotebookExecutionJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NOTEBOOK_EXECUTION_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotebookExecutionJobName notebookExecutionJobName = this;
            synchronized (notebookExecutionJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.notebookExecutionJob != null) {
                        fieldMapBuilder.put((Object)"notebook_execution_job", (Object)this.notebookExecutionJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NOTEBOOK_EXECUTION_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "notebook_execution_job", this.notebookExecutionJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NotebookExecutionJobName that = (NotebookExecutionJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.notebookExecutionJob, that.notebookExecutionJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.notebookExecutionJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String notebookExecutionJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNotebookExecutionJob() {
            return this.notebookExecutionJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNotebookExecutionJob(String notebookExecutionJob) {
            this.notebookExecutionJob = notebookExecutionJob;
            return this;
        }

        private Builder(NotebookExecutionJobName notebookExecutionJobName) {
            this.project = notebookExecutionJobName.project;
            this.location = notebookExecutionJobName.location;
            this.notebookExecutionJob = notebookExecutionJobName.notebookExecutionJob;
        }

        public NotebookExecutionJobName build() {
            return new NotebookExecutionJobName(this);
        }
    }
}

