/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeatureOnlineStoreName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FEATURE_ONLINE_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String featureOnlineStore;

    @Deprecated
    protected FeatureOnlineStoreName() {
        this.project = null;
        this.location = null;
        this.featureOnlineStore = null;
    }

    private FeatureOnlineStoreName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.featureOnlineStore = (String)Preconditions.checkNotNull((Object)builder.getFeatureOnlineStore());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFeatureOnlineStore() {
        return this.featureOnlineStore;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeatureOnlineStoreName of(String project, String location, String featureOnlineStore) {
        return FeatureOnlineStoreName.newBuilder().setProject(project).setLocation(location).setFeatureOnlineStore(featureOnlineStore).build();
    }

    public static String format(String project, String location, String featureOnlineStore) {
        return FeatureOnlineStoreName.newBuilder().setProject(project).setLocation(location).setFeatureOnlineStore(featureOnlineStore).build().toString();
    }

    public static FeatureOnlineStoreName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FEATURE_ONLINE_STORE.validatedMatch(formattedString, "FeatureOnlineStoreName.parse: formattedString not in valid format");
        return FeatureOnlineStoreName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("feature_online_store"));
    }

    public static List<FeatureOnlineStoreName> parseList(List<String> formattedStrings) {
        ArrayList<FeatureOnlineStoreName> list = new ArrayList<FeatureOnlineStoreName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeatureOnlineStoreName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeatureOnlineStoreName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeatureOnlineStoreName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FEATURE_ONLINE_STORE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeatureOnlineStoreName featureOnlineStoreName = this;
            synchronized (featureOnlineStoreName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.featureOnlineStore != null) {
                        fieldMapBuilder.put((Object)"feature_online_store", (Object)this.featureOnlineStore);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FEATURE_ONLINE_STORE.instantiate(new String[]{"project", this.project, "location", this.location, "feature_online_store", this.featureOnlineStore});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FeatureOnlineStoreName that = (FeatureOnlineStoreName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.featureOnlineStore, that.featureOnlineStore);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.featureOnlineStore);
    }

    public static class Builder {
        private String project;
        private String location;
        private String featureOnlineStore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFeatureOnlineStore() {
            return this.featureOnlineStore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFeatureOnlineStore(String featureOnlineStore) {
            this.featureOnlineStore = featureOnlineStore;
            return this;
        }

        private Builder(FeatureOnlineStoreName featureOnlineStoreName) {
            this.project = featureOnlineStoreName.project;
            this.location = featureOnlineStoreName.location;
            this.featureOnlineStore = featureOnlineStoreName.featureOnlineStore;
        }

        public FeatureOnlineStoreName build() {
            return new FeatureOnlineStoreName(this);
        }
    }
}

