/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/dataset_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A container for a single DataItem and Annotations on it.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.DataItemView}
 */
public final class DataItemView extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DataItemView)
    DataItemViewOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DataItemView.newBuilder() to construct.
  private DataItemView(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataItemView() {
    annotations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataItemView();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.DatasetServiceProto
        .internal_static_google_cloud_aiplatform_v1_DataItemView_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.DatasetServiceProto
        .internal_static_google_cloud_aiplatform_v1_DataItemView_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.DataItemView.class,
            com.google.cloud.aiplatform.v1.DataItemView.Builder.class);
  }

  private int bitField0_;
  public static final int DATA_ITEM_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1.DataItem dataItem_;

  /**
   *
   *
   * <pre>
   * The DataItem.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
   *
   * @return Whether the dataItem field is set.
   */
  @java.lang.Override
  public boolean hasDataItem() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The DataItem.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
   *
   * @return The dataItem.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DataItem getDataItem() {
    return dataItem_ == null
        ? com.google.cloud.aiplatform.v1.DataItem.getDefaultInstance()
        : dataItem_;
  }

  /**
   *
   *
   * <pre>
   * The DataItem.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DataItemOrBuilder getDataItemOrBuilder() {
    return dataItem_ == null
        ? com.google.cloud.aiplatform.v1.DataItem.getDefaultInstance()
        : dataItem_;
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.Annotation> annotations_;

  /**
   *
   *
   * <pre>
   * The Annotations on the DataItem. If too many Annotations should be returned
   * for the DataItem, this field will be truncated per annotations_limit in
   * request. If it was, then the has_truncated_annotations will be set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Annotation> getAnnotationsList() {
    return annotations_;
  }

  /**
   *
   *
   * <pre>
   * The Annotations on the DataItem. If too many Annotations should be returned
   * for the DataItem, this field will be truncated per annotations_limit in
   * request. If it was, then the has_truncated_annotations will be set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.AnnotationOrBuilder>
      getAnnotationsOrBuilderList() {
    return annotations_;
  }

  /**
   *
   *
   * <pre>
   * The Annotations on the DataItem. If too many Annotations should be returned
   * for the DataItem, this field will be truncated per annotations_limit in
   * request. If it was, then the has_truncated_annotations will be set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
   */
  @java.lang.Override
  public int getAnnotationsCount() {
    return annotations_.size();
  }

  /**
   *
   *
   * <pre>
   * The Annotations on the DataItem. If too many Annotations should be returned
   * for the DataItem, this field will be truncated per annotations_limit in
   * request. If it was, then the has_truncated_annotations will be set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Annotation getAnnotations(int index) {
    return annotations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The Annotations on the DataItem. If too many Annotations should be returned
   * for the DataItem, this field will be truncated per annotations_limit in
   * request. If it was, then the has_truncated_annotations will be set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.AnnotationOrBuilder getAnnotationsOrBuilder(int index) {
    return annotations_.get(index);
  }

  public static final int HAS_TRUNCATED_ANNOTATIONS_FIELD_NUMBER = 3;
  private boolean hasTruncatedAnnotations_ = false;

  /**
   *
   *
   * <pre>
   * True if and only if the Annotations field has been truncated. It happens if
   * more Annotations for this DataItem met the request's annotation_filter than
   * are allowed to be returned by annotations_limit.
   * Note that if Annotations field is not being returned due to field mask,
   * then this field will not be set to true no matter how many Annotations are
   * there.
   * </pre>
   *
   * <code>bool has_truncated_annotations = 3;</code>
   *
   * @return The hasTruncatedAnnotations.
   */
  @java.lang.Override
  public boolean getHasTruncatedAnnotations() {
    return hasTruncatedAnnotations_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getDataItem());
    }
    for (int i = 0; i < annotations_.size(); i++) {
      output.writeMessage(2, annotations_.get(i));
    }
    if (hasTruncatedAnnotations_ != false) {
      output.writeBool(3, hasTruncatedAnnotations_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDataItem());
    }
    for (int i = 0; i < annotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, annotations_.get(i));
    }
    if (hasTruncatedAnnotations_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, hasTruncatedAnnotations_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.DataItemView)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.DataItemView other =
        (com.google.cloud.aiplatform.v1.DataItemView) obj;

    if (hasDataItem() != other.hasDataItem()) return false;
    if (hasDataItem()) {
      if (!getDataItem().equals(other.getDataItem())) return false;
    }
    if (!getAnnotationsList().equals(other.getAnnotationsList())) return false;
    if (getHasTruncatedAnnotations() != other.getHasTruncatedAnnotations()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDataItem()) {
      hash = (37 * hash) + DATA_ITEM_FIELD_NUMBER;
      hash = (53 * hash) + getDataItem().hashCode();
    }
    if (getAnnotationsCount() > 0) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationsList().hashCode();
    }
    hash = (37 * hash) + HAS_TRUNCATED_ANNOTATIONS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasTruncatedAnnotations());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DataItemView parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.DataItemView prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A container for a single DataItem and Annotations on it.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DataItemView}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DataItemView)
      com.google.cloud.aiplatform.v1.DataItemViewOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1_DataItemView_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1_DataItemView_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DataItemView.class,
              com.google.cloud.aiplatform.v1.DataItemView.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.DataItemView.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDataItemFieldBuilder();
        getAnnotationsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      dataItem_ = null;
      if (dataItemBuilder_ != null) {
        dataItemBuilder_.dispose();
        dataItemBuilder_ = null;
      }
      if (annotationsBuilder_ == null) {
        annotations_ = java.util.Collections.emptyList();
      } else {
        annotations_ = null;
        annotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      hasTruncatedAnnotations_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1_DataItemView_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DataItemView getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.DataItemView.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DataItemView build() {
      com.google.cloud.aiplatform.v1.DataItemView result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DataItemView buildPartial() {
      com.google.cloud.aiplatform.v1.DataItemView result =
          new com.google.cloud.aiplatform.v1.DataItemView(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.DataItemView result) {
      if (annotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          annotations_ = java.util.Collections.unmodifiableList(annotations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.annotations_ = annotations_;
      } else {
        result.annotations_ = annotationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.DataItemView result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dataItem_ = dataItemBuilder_ == null ? dataItem_ : dataItemBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.hasTruncatedAnnotations_ = hasTruncatedAnnotations_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.DataItemView) {
        return mergeFrom((com.google.cloud.aiplatform.v1.DataItemView) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.DataItemView other) {
      if (other == com.google.cloud.aiplatform.v1.DataItemView.getDefaultInstance()) return this;
      if (other.hasDataItem()) {
        mergeDataItem(other.getDataItem());
      }
      if (annotationsBuilder_ == null) {
        if (!other.annotations_.isEmpty()) {
          if (annotations_.isEmpty()) {
            annotations_ = other.annotations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAnnotationsIsMutable();
            annotations_.addAll(other.annotations_);
          }
          onChanged();
        }
      } else {
        if (!other.annotations_.isEmpty()) {
          if (annotationsBuilder_.isEmpty()) {
            annotationsBuilder_.dispose();
            annotationsBuilder_ = null;
            annotations_ = other.annotations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            annotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnnotationsFieldBuilder()
                    : null;
          } else {
            annotationsBuilder_.addAllMessages(other.annotations_);
          }
        }
      }
      if (other.getHasTruncatedAnnotations() != false) {
        setHasTruncatedAnnotations(other.getHasTruncatedAnnotations());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDataItemFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1.Annotation m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.Annotation.parser(), extensionRegistry);
                if (annotationsBuilder_ == null) {
                  ensureAnnotationsIsMutable();
                  annotations_.add(m);
                } else {
                  annotationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                hasTruncatedAnnotations_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1.DataItem dataItem_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DataItem,
            com.google.cloud.aiplatform.v1.DataItem.Builder,
            com.google.cloud.aiplatform.v1.DataItemOrBuilder>
        dataItemBuilder_;

    /**
     *
     *
     * <pre>
     * The DataItem.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
     *
     * @return Whether the dataItem field is set.
     */
    public boolean hasDataItem() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The DataItem.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
     *
     * @return The dataItem.
     */
    public com.google.cloud.aiplatform.v1.DataItem getDataItem() {
      if (dataItemBuilder_ == null) {
        return dataItem_ == null
            ? com.google.cloud.aiplatform.v1.DataItem.getDefaultInstance()
            : dataItem_;
      } else {
        return dataItemBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The DataItem.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
     */
    public Builder setDataItem(com.google.cloud.aiplatform.v1.DataItem value) {
      if (dataItemBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataItem_ = value;
      } else {
        dataItemBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The DataItem.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
     */
    public Builder setDataItem(com.google.cloud.aiplatform.v1.DataItem.Builder builderForValue) {
      if (dataItemBuilder_ == null) {
        dataItem_ = builderForValue.build();
      } else {
        dataItemBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The DataItem.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
     */
    public Builder mergeDataItem(com.google.cloud.aiplatform.v1.DataItem value) {
      if (dataItemBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && dataItem_ != null
            && dataItem_ != com.google.cloud.aiplatform.v1.DataItem.getDefaultInstance()) {
          getDataItemBuilder().mergeFrom(value);
        } else {
          dataItem_ = value;
        }
      } else {
        dataItemBuilder_.mergeFrom(value);
      }
      if (dataItem_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The DataItem.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
     */
    public Builder clearDataItem() {
      bitField0_ = (bitField0_ & ~0x00000001);
      dataItem_ = null;
      if (dataItemBuilder_ != null) {
        dataItemBuilder_.dispose();
        dataItemBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The DataItem.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.DataItem.Builder getDataItemBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDataItemFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The DataItem.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.DataItemOrBuilder getDataItemOrBuilder() {
      if (dataItemBuilder_ != null) {
        return dataItemBuilder_.getMessageOrBuilder();
      } else {
        return dataItem_ == null
            ? com.google.cloud.aiplatform.v1.DataItem.getDefaultInstance()
            : dataItem_;
      }
    }

    /**
     *
     *
     * <pre>
     * The DataItem.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DataItem data_item = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DataItem,
            com.google.cloud.aiplatform.v1.DataItem.Builder,
            com.google.cloud.aiplatform.v1.DataItemOrBuilder>
        getDataItemFieldBuilder() {
      if (dataItemBuilder_ == null) {
        dataItemBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DataItem,
                com.google.cloud.aiplatform.v1.DataItem.Builder,
                com.google.cloud.aiplatform.v1.DataItemOrBuilder>(
                getDataItem(), getParentForChildren(), isClean());
        dataItem_ = null;
      }
      return dataItemBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.Annotation> annotations_ =
        java.util.Collections.emptyList();

    private void ensureAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        annotations_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.Annotation>(annotations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Annotation,
            com.google.cloud.aiplatform.v1.Annotation.Builder,
            com.google.cloud.aiplatform.v1.AnnotationOrBuilder>
        annotationsBuilder_;

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Annotation> getAnnotationsList() {
      if (annotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(annotations_);
      } else {
        return annotationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public int getAnnotationsCount() {
      if (annotationsBuilder_ == null) {
        return annotations_.size();
      } else {
        return annotationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.Annotation getAnnotations(int index) {
      if (annotationsBuilder_ == null) {
        return annotations_.get(index);
      } else {
        return annotationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public Builder setAnnotations(int index, com.google.cloud.aiplatform.v1.Annotation value) {
      if (annotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationsIsMutable();
        annotations_.set(index, value);
        onChanged();
      } else {
        annotationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public Builder setAnnotations(
        int index, com.google.cloud.aiplatform.v1.Annotation.Builder builderForValue) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        annotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public Builder addAnnotations(com.google.cloud.aiplatform.v1.Annotation value) {
      if (annotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationsIsMutable();
        annotations_.add(value);
        onChanged();
      } else {
        annotationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public Builder addAnnotations(int index, com.google.cloud.aiplatform.v1.Annotation value) {
      if (annotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationsIsMutable();
        annotations_.add(index, value);
        onChanged();
      } else {
        annotationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public Builder addAnnotations(
        com.google.cloud.aiplatform.v1.Annotation.Builder builderForValue) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.add(builderForValue.build());
        onChanged();
      } else {
        annotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public Builder addAnnotations(
        int index, com.google.cloud.aiplatform.v1.Annotation.Builder builderForValue) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        annotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public Builder addAllAnnotations(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Annotation> values) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, annotations_);
        onChanged();
      } else {
        annotationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public Builder clearAnnotations() {
      if (annotationsBuilder_ == null) {
        annotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        annotationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public Builder removeAnnotations(int index) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.remove(index);
        onChanged();
      } else {
        annotationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.Annotation.Builder getAnnotationsBuilder(int index) {
      return getAnnotationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.AnnotationOrBuilder getAnnotationsOrBuilder(int index) {
      if (annotationsBuilder_ == null) {
        return annotations_.get(index);
      } else {
        return annotationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.AnnotationOrBuilder>
        getAnnotationsOrBuilderList() {
      if (annotationsBuilder_ != null) {
        return annotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(annotations_);
      }
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.Annotation.Builder addAnnotationsBuilder() {
      return getAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.Annotation.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.Annotation.Builder addAnnotationsBuilder(int index) {
      return getAnnotationsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.Annotation.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The Annotations on the DataItem. If too many Annotations should be returned
     * for the DataItem, this field will be truncated per annotations_limit in
     * request. If it was, then the has_truncated_annotations will be set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Annotation annotations = 2;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Annotation.Builder>
        getAnnotationsBuilderList() {
      return getAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Annotation,
            com.google.cloud.aiplatform.v1.Annotation.Builder,
            com.google.cloud.aiplatform.v1.AnnotationOrBuilder>
        getAnnotationsFieldBuilder() {
      if (annotationsBuilder_ == null) {
        annotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Annotation,
                com.google.cloud.aiplatform.v1.Annotation.Builder,
                com.google.cloud.aiplatform.v1.AnnotationOrBuilder>(
                annotations_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        annotations_ = null;
      }
      return annotationsBuilder_;
    }

    private boolean hasTruncatedAnnotations_;

    /**
     *
     *
     * <pre>
     * True if and only if the Annotations field has been truncated. It happens if
     * more Annotations for this DataItem met the request's annotation_filter than
     * are allowed to be returned by annotations_limit.
     * Note that if Annotations field is not being returned due to field mask,
     * then this field will not be set to true no matter how many Annotations are
     * there.
     * </pre>
     *
     * <code>bool has_truncated_annotations = 3;</code>
     *
     * @return The hasTruncatedAnnotations.
     */
    @java.lang.Override
    public boolean getHasTruncatedAnnotations() {
      return hasTruncatedAnnotations_;
    }

    /**
     *
     *
     * <pre>
     * True if and only if the Annotations field has been truncated. It happens if
     * more Annotations for this DataItem met the request's annotation_filter than
     * are allowed to be returned by annotations_limit.
     * Note that if Annotations field is not being returned due to field mask,
     * then this field will not be set to true no matter how many Annotations are
     * there.
     * </pre>
     *
     * <code>bool has_truncated_annotations = 3;</code>
     *
     * @param value The hasTruncatedAnnotations to set.
     * @return This builder for chaining.
     */
    public Builder setHasTruncatedAnnotations(boolean value) {

      hasTruncatedAnnotations_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * True if and only if the Annotations field has been truncated. It happens if
     * more Annotations for this DataItem met the request's annotation_filter than
     * are allowed to be returned by annotations_limit.
     * Note that if Annotations field is not being returned due to field mask,
     * then this field will not be set to true no matter how many Annotations are
     * there.
     * </pre>
     *
     * <code>bool has_truncated_annotations = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHasTruncatedAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000004);
      hasTruncatedAnnotations_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DataItemView)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DataItemView)
  private static final com.google.cloud.aiplatform.v1.DataItemView DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.DataItemView();
  }

  public static com.google.cloud.aiplatform.v1.DataItemView getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataItemView> PARSER =
      new com.google.protobuf.AbstractParser<DataItemView>() {
        @java.lang.Override
        public DataItemView parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataItemView> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataItemView> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DataItemView getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
