/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/explanation.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Noise sigma by features. Noise sigma represents the standard deviation of the
 * gaussian kernel that will be used to add noise to interpolated inputs prior
 * to computing gradients.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.FeatureNoiseSigma}
 */
public final class FeatureNoiseSigma extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureNoiseSigma)
    FeatureNoiseSigmaOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FeatureNoiseSigma.newBuilder() to construct.
  private FeatureNoiseSigma(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureNoiseSigma() {
    noiseSigma_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureNoiseSigma();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1_FeatureNoiseSigma_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1_FeatureNoiseSigma_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.FeatureNoiseSigma.class,
            com.google.cloud.aiplatform.v1.FeatureNoiseSigma.Builder.class);
  }

  public interface NoiseSigmaForFeatureOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the input feature for which noise sigma is provided. The
     * features are defined in
     * [explanation metadata
     * inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();

    /**
     *
     *
     * <pre>
     * The name of the input feature for which noise sigma is provided. The
     * features are defined in
     * [explanation metadata
     * inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * This represents the standard deviation of the Gaussian kernel that will
     * be used to add noise to the feature prior to computing gradients. Similar
     * to [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
     * but represents the noise added to the current feature. Defaults to 0.1.
     * </pre>
     *
     * <code>float sigma = 2;</code>
     *
     * @return The sigma.
     */
    float getSigma();
  }

  /**
   *
   *
   * <pre>
   * Noise sigma for a single feature.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature}
   */
  public static final class NoiseSigmaForFeature extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature)
      NoiseSigmaForFeatureOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use NoiseSigmaForFeature.newBuilder() to construct.
    private NoiseSigmaForFeature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NoiseSigmaForFeature() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NoiseSigmaForFeature();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1_FeatureNoiseSigma_NoiseSigmaForFeature_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1_FeatureNoiseSigma_NoiseSigmaForFeature_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.class,
              com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The name of the input feature for which noise sigma is provided. The
     * features are defined in
     * [explanation metadata
     * inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the input feature for which noise sigma is provided. The
     * features are defined in
     * [explanation metadata
     * inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SIGMA_FIELD_NUMBER = 2;
    private float sigma_ = 0F;

    /**
     *
     *
     * <pre>
     * This represents the standard deviation of the Gaussian kernel that will
     * be used to add noise to the feature prior to computing gradients. Similar
     * to [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
     * but represents the noise added to the current feature. Defaults to 0.1.
     * </pre>
     *
     * <code>float sigma = 2;</code>
     *
     * @return The sigma.
     */
    @java.lang.Override
    public float getSigma() {
      return sigma_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (java.lang.Float.floatToRawIntBits(sigma_) != 0) {
        output.writeFloat(2, sigma_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (java.lang.Float.floatToRawIntBits(sigma_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, sigma_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature other =
          (com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature) obj;

      if (!getName().equals(other.getName())) return false;
      if (java.lang.Float.floatToIntBits(getSigma())
          != java.lang.Float.floatToIntBits(other.getSigma())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + SIGMA_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getSigma());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Noise sigma for a single feature.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature)
        com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeatureOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ExplanationProto
            .internal_static_google_cloud_aiplatform_v1_FeatureNoiseSigma_NoiseSigmaForFeature_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ExplanationProto
            .internal_static_google_cloud_aiplatform_v1_FeatureNoiseSigma_NoiseSigmaForFeature_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.class,
                com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        sigma_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ExplanationProto
            .internal_static_google_cloud_aiplatform_v1_FeatureNoiseSigma_NoiseSigmaForFeature_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature build() {
        com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature buildPartial() {
        com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature result =
            new com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.sigma_ = sigma_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature other) {
        if (other
            == com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getSigma() != 0F) {
          setSigma(other.getSigma());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 21:
                {
                  sigma_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";

      /**
       *
       *
       * <pre>
       * The name of the input feature for which noise sigma is provided. The
       * features are defined in
       * [explanation metadata
       * inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the input feature for which noise sigma is provided. The
       * features are defined in
       * [explanation metadata
       * inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the input feature for which noise sigma is provided. The
       * features are defined in
       * [explanation metadata
       * inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the input feature for which noise sigma is provided. The
       * features are defined in
       * [explanation metadata
       * inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the input feature for which noise sigma is provided. The
       * features are defined in
       * [explanation metadata
       * inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private float sigma_;

      /**
       *
       *
       * <pre>
       * This represents the standard deviation of the Gaussian kernel that will
       * be used to add noise to the feature prior to computing gradients. Similar
       * to [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
       * but represents the noise added to the current feature. Defaults to 0.1.
       * </pre>
       *
       * <code>float sigma = 2;</code>
       *
       * @return The sigma.
       */
      @java.lang.Override
      public float getSigma() {
        return sigma_;
      }

      /**
       *
       *
       * <pre>
       * This represents the standard deviation of the Gaussian kernel that will
       * be used to add noise to the feature prior to computing gradients. Similar
       * to [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
       * but represents the noise added to the current feature. Defaults to 0.1.
       * </pre>
       *
       * <code>float sigma = 2;</code>
       *
       * @param value The sigma to set.
       * @return This builder for chaining.
       */
      public Builder setSigma(float value) {

        sigma_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * This represents the standard deviation of the Gaussian kernel that will
       * be used to add noise to the feature prior to computing gradients. Similar
       * to [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
       * but represents the noise added to the current feature. Defaults to 0.1.
       * </pre>
       *
       * <code>float sigma = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSigma() {
        bitField0_ = (bitField0_ & ~0x00000002);
        sigma_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature)
    private static final com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature();
    }

    public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NoiseSigmaForFeature> PARSER =
        new com.google.protobuf.AbstractParser<NoiseSigmaForFeature>() {
          @java.lang.Override
          public NoiseSigmaForFeature parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NoiseSigmaForFeature> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NoiseSigmaForFeature> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NOISE_SIGMA_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature>
      noiseSigma_;

  /**
   *
   *
   * <pre>
   * Noise sigma per feature. No noise is added to features that are not set.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature>
      getNoiseSigmaList() {
    return noiseSigma_;
  }

  /**
   *
   *
   * <pre>
   * Noise sigma per feature. No noise is added to features that are not set.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeatureOrBuilder>
      getNoiseSigmaOrBuilderList() {
    return noiseSigma_;
  }

  /**
   *
   *
   * <pre>
   * Noise sigma per feature. No noise is added to features that are not set.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
   * </code>
   */
  @java.lang.Override
  public int getNoiseSigmaCount() {
    return noiseSigma_.size();
  }

  /**
   *
   *
   * <pre>
   * Noise sigma per feature. No noise is added to features that are not set.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature getNoiseSigma(
      int index) {
    return noiseSigma_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Noise sigma per feature. No noise is added to features that are not set.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeatureOrBuilder
      getNoiseSigmaOrBuilder(int index) {
    return noiseSigma_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < noiseSigma_.size(); i++) {
      output.writeMessage(1, noiseSigma_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < noiseSigma_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, noiseSigma_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.FeatureNoiseSigma)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.FeatureNoiseSigma other =
        (com.google.cloud.aiplatform.v1.FeatureNoiseSigma) obj;

    if (!getNoiseSigmaList().equals(other.getNoiseSigmaList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getNoiseSigmaCount() > 0) {
      hash = (37 * hash) + NOISE_SIGMA_FIELD_NUMBER;
      hash = (53 * hash) + getNoiseSigmaList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.FeatureNoiseSigma prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Noise sigma by features. Noise sigma represents the standard deviation of the
   * gaussian kernel that will be used to add noise to interpolated inputs prior
   * to computing gradients.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeatureNoiseSigma}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureNoiseSigma)
      com.google.cloud.aiplatform.v1.FeatureNoiseSigmaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1_FeatureNoiseSigma_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1_FeatureNoiseSigma_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeatureNoiseSigma.class,
              com.google.cloud.aiplatform.v1.FeatureNoiseSigma.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.FeatureNoiseSigma.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (noiseSigmaBuilder_ == null) {
        noiseSigma_ = java.util.Collections.emptyList();
      } else {
        noiseSigma_ = null;
        noiseSigmaBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1_FeatureNoiseSigma_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureNoiseSigma getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.FeatureNoiseSigma.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureNoiseSigma build() {
      com.google.cloud.aiplatform.v1.FeatureNoiseSigma result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureNoiseSigma buildPartial() {
      com.google.cloud.aiplatform.v1.FeatureNoiseSigma result =
          new com.google.cloud.aiplatform.v1.FeatureNoiseSigma(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.FeatureNoiseSigma result) {
      if (noiseSigmaBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          noiseSigma_ = java.util.Collections.unmodifiableList(noiseSigma_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.noiseSigma_ = noiseSigma_;
      } else {
        result.noiseSigma_ = noiseSigmaBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.FeatureNoiseSigma result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.FeatureNoiseSigma) {
        return mergeFrom((com.google.cloud.aiplatform.v1.FeatureNoiseSigma) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.FeatureNoiseSigma other) {
      if (other == com.google.cloud.aiplatform.v1.FeatureNoiseSigma.getDefaultInstance())
        return this;
      if (noiseSigmaBuilder_ == null) {
        if (!other.noiseSigma_.isEmpty()) {
          if (noiseSigma_.isEmpty()) {
            noiseSigma_ = other.noiseSigma_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureNoiseSigmaIsMutable();
            noiseSigma_.addAll(other.noiseSigma_);
          }
          onChanged();
        }
      } else {
        if (!other.noiseSigma_.isEmpty()) {
          if (noiseSigmaBuilder_.isEmpty()) {
            noiseSigmaBuilder_.dispose();
            noiseSigmaBuilder_ = null;
            noiseSigma_ = other.noiseSigma_;
            bitField0_ = (bitField0_ & ~0x00000001);
            noiseSigmaBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNoiseSigmaFieldBuilder()
                    : null;
          } else {
            noiseSigmaBuilder_.addAllMessages(other.noiseSigma_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
                            .parser(),
                        extensionRegistry);
                if (noiseSigmaBuilder_ == null) {
                  ensureNoiseSigmaIsMutable();
                  noiseSigma_.add(m);
                } else {
                  noiseSigmaBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature>
        noiseSigma_ = java.util.Collections.emptyList();

    private void ensureNoiseSigmaIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        noiseSigma_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature>(noiseSigma_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature,
            com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder,
            com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeatureOrBuilder>
        noiseSigmaBuilder_;

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature>
        getNoiseSigmaList() {
      if (noiseSigmaBuilder_ == null) {
        return java.util.Collections.unmodifiableList(noiseSigma_);
      } else {
        return noiseSigmaBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public int getNoiseSigmaCount() {
      if (noiseSigmaBuilder_ == null) {
        return noiseSigma_.size();
      } else {
        return noiseSigmaBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature getNoiseSigma(
        int index) {
      if (noiseSigmaBuilder_ == null) {
        return noiseSigma_.get(index);
      } else {
        return noiseSigmaBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public Builder setNoiseSigma(
        int index, com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature value) {
      if (noiseSigmaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNoiseSigmaIsMutable();
        noiseSigma_.set(index, value);
        onChanged();
      } else {
        noiseSigmaBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public Builder setNoiseSigma(
        int index,
        com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder
            builderForValue) {
      if (noiseSigmaBuilder_ == null) {
        ensureNoiseSigmaIsMutable();
        noiseSigma_.set(index, builderForValue.build());
        onChanged();
      } else {
        noiseSigmaBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public Builder addNoiseSigma(
        com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature value) {
      if (noiseSigmaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNoiseSigmaIsMutable();
        noiseSigma_.add(value);
        onChanged();
      } else {
        noiseSigmaBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public Builder addNoiseSigma(
        int index, com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature value) {
      if (noiseSigmaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNoiseSigmaIsMutable();
        noiseSigma_.add(index, value);
        onChanged();
      } else {
        noiseSigmaBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public Builder addNoiseSigma(
        com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder
            builderForValue) {
      if (noiseSigmaBuilder_ == null) {
        ensureNoiseSigmaIsMutable();
        noiseSigma_.add(builderForValue.build());
        onChanged();
      } else {
        noiseSigmaBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public Builder addNoiseSigma(
        int index,
        com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder
            builderForValue) {
      if (noiseSigmaBuilder_ == null) {
        ensureNoiseSigmaIsMutable();
        noiseSigma_.add(index, builderForValue.build());
        onChanged();
      } else {
        noiseSigmaBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public Builder addAllNoiseSigma(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature>
            values) {
      if (noiseSigmaBuilder_ == null) {
        ensureNoiseSigmaIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, noiseSigma_);
        onChanged();
      } else {
        noiseSigmaBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public Builder clearNoiseSigma() {
      if (noiseSigmaBuilder_ == null) {
        noiseSigma_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        noiseSigmaBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public Builder removeNoiseSigma(int index) {
      if (noiseSigmaBuilder_ == null) {
        ensureNoiseSigmaIsMutable();
        noiseSigma_.remove(index);
        onChanged();
      } else {
        noiseSigmaBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder
        getNoiseSigmaBuilder(int index) {
      return getNoiseSigmaFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeatureOrBuilder
        getNoiseSigmaOrBuilder(int index) {
      if (noiseSigmaBuilder_ == null) {
        return noiseSigma_.get(index);
      } else {
        return noiseSigmaBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeatureOrBuilder>
        getNoiseSigmaOrBuilderList() {
      if (noiseSigmaBuilder_ != null) {
        return noiseSigmaBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(noiseSigma_);
      }
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder
        addNoiseSigmaBuilder() {
      return getNoiseSigmaFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder
        addNoiseSigmaBuilder(int index) {
      return getNoiseSigmaFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Noise sigma per feature. No noise is added to features that are not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature noise_sigma = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder>
        getNoiseSigmaBuilderList() {
      return getNoiseSigmaFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature,
            com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder,
            com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeatureOrBuilder>
        getNoiseSigmaFieldBuilder() {
      if (noiseSigmaBuilder_ == null) {
        noiseSigmaBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature,
                com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature.Builder,
                com.google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeatureOrBuilder>(
                noiseSigma_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        noiseSigma_ = null;
      }
      return noiseSigmaBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureNoiseSigma)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureNoiseSigma)
  private static final com.google.cloud.aiplatform.v1.FeatureNoiseSigma DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.FeatureNoiseSigma();
  }

  public static com.google.cloud.aiplatform.v1.FeatureNoiseSigma getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureNoiseSigma> PARSER =
      new com.google.protobuf.AbstractParser<FeatureNoiseSigma>() {
        @java.lang.Override
        public FeatureNoiseSigma parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureNoiseSigma> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureNoiseSigma> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureNoiseSigma getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
