/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/data_foundry_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Defines a specification for a single output field.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.OutputFieldSpec}
 */
public final class OutputFieldSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.OutputFieldSpec)
    OutputFieldSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use OutputFieldSpec.newBuilder() to construct.
  private OutputFieldSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OutputFieldSpec() {
    fieldName_ = "";
    guidance_ = "";
    fieldType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OutputFieldSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.DataFoundryServiceProto
        .internal_static_google_cloud_aiplatform_v1_OutputFieldSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.DataFoundryServiceProto
        .internal_static_google_cloud_aiplatform_v1_OutputFieldSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.OutputFieldSpec.class,
            com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The data type of the field.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.OutputFieldSpec.FieldType}
   */
  public enum FieldType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Field type is unspecified.
     * </pre>
     *
     * <code>FIELD_TYPE_UNSPECIFIED = 0;</code>
     */
    FIELD_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Arbitrary content field type.
     * </pre>
     *
     * <code>CONTENT = 1;</code>
     */
    CONTENT(1),
    /**
     *
     *
     * <pre>
     * Text field type.
     * </pre>
     *
     * <code>TEXT = 2;</code>
     */
    TEXT(2),
    /**
     *
     *
     * <pre>
     * Image field type.
     * </pre>
     *
     * <code>IMAGE = 3;</code>
     */
    IMAGE(3),
    /**
     *
     *
     * <pre>
     * Audio field type.
     * </pre>
     *
     * <code>AUDIO = 4;</code>
     */
    AUDIO(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Field type is unspecified.
     * </pre>
     *
     * <code>FIELD_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int FIELD_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Arbitrary content field type.
     * </pre>
     *
     * <code>CONTENT = 1;</code>
     */
    public static final int CONTENT_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Text field type.
     * </pre>
     *
     * <code>TEXT = 2;</code>
     */
    public static final int TEXT_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Image field type.
     * </pre>
     *
     * <code>IMAGE = 3;</code>
     */
    public static final int IMAGE_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Audio field type.
     * </pre>
     *
     * <code>AUDIO = 4;</code>
     */
    public static final int AUDIO_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FieldType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FieldType forNumber(int value) {
      switch (value) {
        case 0:
          return FIELD_TYPE_UNSPECIFIED;
        case 1:
          return CONTENT;
        case 2:
          return TEXT;
        case 3:
          return IMAGE;
        case 4:
          return AUDIO;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FieldType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FieldType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<FieldType>() {
          public FieldType findValueByNumber(int number) {
            return FieldType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.OutputFieldSpec.getDescriptor().getEnumTypes().get(0);
    }

    private static final FieldType[] VALUES = values();

    public static FieldType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FieldType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.OutputFieldSpec.FieldType)
  }

  public static final int FIELD_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fieldName_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the output field.
   * </pre>
   *
   * <code>string field_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The fieldName.
   */
  @java.lang.Override
  public java.lang.String getFieldName() {
    java.lang.Object ref = fieldName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fieldName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the output field.
   * </pre>
   *
   * <code>string field_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for fieldName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFieldNameBytes() {
    java.lang.Object ref = fieldName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fieldName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GUIDANCE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object guidance_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Optional, but recommended. Additional guidance specific to this
   * field to provide targeted instructions for the LLM to generate the content
   * of a single output field. While the LLM can sometimes infer content from
   * the field name, providing explicit guidance is preferred.
   * </pre>
   *
   * <code>string guidance = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The guidance.
   */
  @java.lang.Override
  public java.lang.String getGuidance() {
    java.lang.Object ref = guidance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      guidance_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional, but recommended. Additional guidance specific to this
   * field to provide targeted instructions for the LLM to generate the content
   * of a single output field. While the LLM can sometimes infer content from
   * the field name, providing explicit guidance is preferred.
   * </pre>
   *
   * <code>string guidance = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for guidance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGuidanceBytes() {
    java.lang.Object ref = guidance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      guidance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIELD_TYPE_FIELD_NUMBER = 3;
  private int fieldType_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The data type of the field. Defaults to CONTENT if not set.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.OutputFieldSpec.FieldType field_type = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for fieldType.
   */
  @java.lang.Override
  public int getFieldTypeValue() {
    return fieldType_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The data type of the field. Defaults to CONTENT if not set.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.OutputFieldSpec.FieldType field_type = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The fieldType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.OutputFieldSpec.FieldType getFieldType() {
    com.google.cloud.aiplatform.v1.OutputFieldSpec.FieldType result =
        com.google.cloud.aiplatform.v1.OutputFieldSpec.FieldType.forNumber(fieldType_);
    return result == null
        ? com.google.cloud.aiplatform.v1.OutputFieldSpec.FieldType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(guidance_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, guidance_);
    }
    if (fieldType_
        != com.google.cloud.aiplatform.v1.OutputFieldSpec.FieldType.FIELD_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, fieldType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(guidance_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, guidance_);
    }
    if (fieldType_
        != com.google.cloud.aiplatform.v1.OutputFieldSpec.FieldType.FIELD_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, fieldType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.OutputFieldSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.OutputFieldSpec other =
        (com.google.cloud.aiplatform.v1.OutputFieldSpec) obj;

    if (!getFieldName().equals(other.getFieldName())) return false;
    if (!getGuidance().equals(other.getGuidance())) return false;
    if (fieldType_ != other.fieldType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFieldName().hashCode();
    hash = (37 * hash) + GUIDANCE_FIELD_NUMBER;
    hash = (53 * hash) + getGuidance().hashCode();
    hash = (37 * hash) + FIELD_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + fieldType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.OutputFieldSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Defines a specification for a single output field.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.OutputFieldSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.OutputFieldSpec)
      com.google.cloud.aiplatform.v1.OutputFieldSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.DataFoundryServiceProto
          .internal_static_google_cloud_aiplatform_v1_OutputFieldSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.DataFoundryServiceProto
          .internal_static_google_cloud_aiplatform_v1_OutputFieldSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.OutputFieldSpec.class,
              com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.OutputFieldSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      fieldName_ = "";
      guidance_ = "";
      fieldType_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.DataFoundryServiceProto
          .internal_static_google_cloud_aiplatform_v1_OutputFieldSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.OutputFieldSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.OutputFieldSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.OutputFieldSpec build() {
      com.google.cloud.aiplatform.v1.OutputFieldSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.OutputFieldSpec buildPartial() {
      com.google.cloud.aiplatform.v1.OutputFieldSpec result =
          new com.google.cloud.aiplatform.v1.OutputFieldSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.OutputFieldSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.fieldName_ = fieldName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.guidance_ = guidance_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.fieldType_ = fieldType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.OutputFieldSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1.OutputFieldSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.OutputFieldSpec other) {
      if (other == com.google.cloud.aiplatform.v1.OutputFieldSpec.getDefaultInstance()) return this;
      if (!other.getFieldName().isEmpty()) {
        fieldName_ = other.fieldName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getGuidance().isEmpty()) {
        guidance_ = other.guidance_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.fieldType_ != 0) {
        setFieldTypeValue(other.getFieldTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                fieldName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                guidance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                fieldType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object fieldName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the output field.
     * </pre>
     *
     * <code>string field_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The fieldName.
     */
    public java.lang.String getFieldName() {
      java.lang.Object ref = fieldName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fieldName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the output field.
     * </pre>
     *
     * <code>string field_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for fieldName.
     */
    public com.google.protobuf.ByteString getFieldNameBytes() {
      java.lang.Object ref = fieldName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fieldName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the output field.
     * </pre>
     *
     * <code>string field_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The fieldName to set.
     * @return This builder for chaining.
     */
    public Builder setFieldName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fieldName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the output field.
     * </pre>
     *
     * <code>string field_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFieldName() {
      fieldName_ = getDefaultInstance().getFieldName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the output field.
     * </pre>
     *
     * <code>string field_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for fieldName to set.
     * @return This builder for chaining.
     */
    public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fieldName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object guidance_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Optional, but recommended. Additional guidance specific to this
     * field to provide targeted instructions for the LLM to generate the content
     * of a single output field. While the LLM can sometimes infer content from
     * the field name, providing explicit guidance is preferred.
     * </pre>
     *
     * <code>string guidance = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The guidance.
     */
    public java.lang.String getGuidance() {
      java.lang.Object ref = guidance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        guidance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional, but recommended. Additional guidance specific to this
     * field to provide targeted instructions for the LLM to generate the content
     * of a single output field. While the LLM can sometimes infer content from
     * the field name, providing explicit guidance is preferred.
     * </pre>
     *
     * <code>string guidance = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for guidance.
     */
    public com.google.protobuf.ByteString getGuidanceBytes() {
      java.lang.Object ref = guidance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        guidance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional, but recommended. Additional guidance specific to this
     * field to provide targeted instructions for the LLM to generate the content
     * of a single output field. While the LLM can sometimes infer content from
     * the field name, providing explicit guidance is preferred.
     * </pre>
     *
     * <code>string guidance = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The guidance to set.
     * @return This builder for chaining.
     */
    public Builder setGuidance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      guidance_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional, but recommended. Additional guidance specific to this
     * field to provide targeted instructions for the LLM to generate the content
     * of a single output field. While the LLM can sometimes infer content from
     * the field name, providing explicit guidance is preferred.
     * </pre>
     *
     * <code>string guidance = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGuidance() {
      guidance_ = getDefaultInstance().getGuidance();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional, but recommended. Additional guidance specific to this
     * field to provide targeted instructions for the LLM to generate the content
     * of a single output field. While the LLM can sometimes infer content from
     * the field name, providing explicit guidance is preferred.
     * </pre>
     *
     * <code>string guidance = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for guidance to set.
     * @return This builder for chaining.
     */
    public Builder setGuidanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      guidance_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int fieldType_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The data type of the field. Defaults to CONTENT if not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.OutputFieldSpec.FieldType field_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for fieldType.
     */
    @java.lang.Override
    public int getFieldTypeValue() {
      return fieldType_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The data type of the field. Defaults to CONTENT if not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.OutputFieldSpec.FieldType field_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for fieldType to set.
     * @return This builder for chaining.
     */
    public Builder setFieldTypeValue(int value) {
      fieldType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The data type of the field. Defaults to CONTENT if not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.OutputFieldSpec.FieldType field_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The fieldType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.OutputFieldSpec.FieldType getFieldType() {
      com.google.cloud.aiplatform.v1.OutputFieldSpec.FieldType result =
          com.google.cloud.aiplatform.v1.OutputFieldSpec.FieldType.forNumber(fieldType_);
      return result == null
          ? com.google.cloud.aiplatform.v1.OutputFieldSpec.FieldType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. The data type of the field. Defaults to CONTENT if not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.OutputFieldSpec.FieldType field_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The fieldType to set.
     * @return This builder for chaining.
     */
    public Builder setFieldType(com.google.cloud.aiplatform.v1.OutputFieldSpec.FieldType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      fieldType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The data type of the field. Defaults to CONTENT if not set.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.OutputFieldSpec.FieldType field_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFieldType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      fieldType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.OutputFieldSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.OutputFieldSpec)
  private static final com.google.cloud.aiplatform.v1.OutputFieldSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.OutputFieldSpec();
  }

  public static com.google.cloud.aiplatform.v1.OutputFieldSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OutputFieldSpec> PARSER =
      new com.google.protobuf.AbstractParser<OutputFieldSpec>() {
        @java.lang.Override
        public OutputFieldSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OutputFieldSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OutputFieldSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.OutputFieldSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
