/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/prediction_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [PredictionService.EmbedContent][google.cloud.aiplatform.v1.PredictionService.EmbedContent].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.EmbedContentRequest}
 */
public final class EmbedContentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.EmbedContentRequest)
    EmbedContentRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use EmbedContentRequest.newBuilder() to construct.
  private EmbedContentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EmbedContentRequest() {
    model_ = "";
    title_ = "";
    taskType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EmbedContentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1_EmbedContentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1_EmbedContentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.EmbedContentRequest.class,
            com.google.cloud.aiplatform.v1.EmbedContentRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents a downstream task the embeddings will be used for.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType}
   */
  public enum EmbeddingTaskType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unset value, which will default to one of the other enum values.
     * </pre>
     *
     * <code>UNSPECIFIED = 0;</code>
     */
    UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Specifies the given text is a query in a search/retrieval setting.
     * </pre>
     *
     * <code>RETRIEVAL_QUERY = 2;</code>
     */
    RETRIEVAL_QUERY(2),
    /**
     *
     *
     * <pre>
     * Specifies the given text is a document from the corpus being searched.
     * </pre>
     *
     * <code>RETRIEVAL_DOCUMENT = 3;</code>
     */
    RETRIEVAL_DOCUMENT(3),
    /**
     *
     *
     * <pre>
     * Specifies the given text will be used for STS.
     * </pre>
     *
     * <code>SEMANTIC_SIMILARITY = 4;</code>
     */
    SEMANTIC_SIMILARITY(4),
    /**
     *
     *
     * <pre>
     * Specifies that the given text will be classified.
     * </pre>
     *
     * <code>CLASSIFICATION = 5;</code>
     */
    CLASSIFICATION(5),
    /**
     *
     *
     * <pre>
     * Specifies that the embeddings will be used for clustering.
     * </pre>
     *
     * <code>CLUSTERING = 6;</code>
     */
    CLUSTERING(6),
    /**
     *
     *
     * <pre>
     * Specifies that the embeddings will be used for question answering.
     * </pre>
     *
     * <code>QUESTION_ANSWERING = 7;</code>
     */
    QUESTION_ANSWERING(7),
    /**
     *
     *
     * <pre>
     * Specifies that the embeddings will be used for fact verification.
     * </pre>
     *
     * <code>FACT_VERIFICATION = 8;</code>
     */
    FACT_VERIFICATION(8),
    /**
     *
     *
     * <pre>
     * Specifies that the embeddings will be used for code retrieval.
     * </pre>
     *
     * <code>CODE_RETRIEVAL_QUERY = 9;</code>
     */
    CODE_RETRIEVAL_QUERY(9),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unset value, which will default to one of the other enum values.
     * </pre>
     *
     * <code>UNSPECIFIED = 0;</code>
     */
    public static final int UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Specifies the given text is a query in a search/retrieval setting.
     * </pre>
     *
     * <code>RETRIEVAL_QUERY = 2;</code>
     */
    public static final int RETRIEVAL_QUERY_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Specifies the given text is a document from the corpus being searched.
     * </pre>
     *
     * <code>RETRIEVAL_DOCUMENT = 3;</code>
     */
    public static final int RETRIEVAL_DOCUMENT_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Specifies the given text will be used for STS.
     * </pre>
     *
     * <code>SEMANTIC_SIMILARITY = 4;</code>
     */
    public static final int SEMANTIC_SIMILARITY_VALUE = 4;

    /**
     *
     *
     * <pre>
     * Specifies that the given text will be classified.
     * </pre>
     *
     * <code>CLASSIFICATION = 5;</code>
     */
    public static final int CLASSIFICATION_VALUE = 5;

    /**
     *
     *
     * <pre>
     * Specifies that the embeddings will be used for clustering.
     * </pre>
     *
     * <code>CLUSTERING = 6;</code>
     */
    public static final int CLUSTERING_VALUE = 6;

    /**
     *
     *
     * <pre>
     * Specifies that the embeddings will be used for question answering.
     * </pre>
     *
     * <code>QUESTION_ANSWERING = 7;</code>
     */
    public static final int QUESTION_ANSWERING_VALUE = 7;

    /**
     *
     *
     * <pre>
     * Specifies that the embeddings will be used for fact verification.
     * </pre>
     *
     * <code>FACT_VERIFICATION = 8;</code>
     */
    public static final int FACT_VERIFICATION_VALUE = 8;

    /**
     *
     *
     * <pre>
     * Specifies that the embeddings will be used for code retrieval.
     * </pre>
     *
     * <code>CODE_RETRIEVAL_QUERY = 9;</code>
     */
    public static final int CODE_RETRIEVAL_QUERY_VALUE = 9;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EmbeddingTaskType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EmbeddingTaskType forNumber(int value) {
      switch (value) {
        case 0:
          return UNSPECIFIED;
        case 2:
          return RETRIEVAL_QUERY;
        case 3:
          return RETRIEVAL_DOCUMENT;
        case 4:
          return SEMANTIC_SIMILARITY;
        case 5:
          return CLASSIFICATION;
        case 6:
          return CLUSTERING;
        case 7:
          return QUESTION_ANSWERING;
        case 8:
          return FACT_VERIFICATION;
        case 9:
          return CODE_RETRIEVAL_QUERY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EmbeddingTaskType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EmbeddingTaskType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<EmbeddingTaskType>() {
              public EmbeddingTaskType findValueByNumber(int number) {
                return EmbeddingTaskType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EmbedContentRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final EmbeddingTaskType[] VALUES = values();

    public static EmbeddingTaskType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EmbeddingTaskType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType)
  }

  private int bitField0_;
  public static final int MODEL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the publisher model requested to serve the
   * prediction. Format:
   * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
   * </pre>
   *
   * <code>optional string model = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the model field is set.
   */
  @java.lang.Override
  public boolean hasModel() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the publisher model requested to serve the
   * prediction. Format:
   * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
   * </pre>
   *
   * <code>optional string model = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the publisher model requested to serve the
   * prediction. Format:
   * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
   * </pre>
   *
   * <code>optional string model = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1.Content content_;

  /**
   *
   *
   * <pre>
   * Required. Input content to be embedded. Required.
   * </pre>
   *
   * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
   *
   * @return Whether the content field is set.
   */
  @java.lang.Override
  public boolean hasContent() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Input content to be embedded. Required.
   * </pre>
   *
   * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
   *
   * @return The content.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Content getContent() {
    return content_ == null
        ? com.google.cloud.aiplatform.v1.Content.getDefaultInstance()
        : content_;
  }

  /**
   *
   *
   * <pre>
   * Required. Input content to be embedded. Required.
   * </pre>
   *
   * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ContentOrBuilder getContentOrBuilder() {
    return content_ == null
        ? com.google.cloud.aiplatform.v1.Content.getDefaultInstance()
        : content_;
  }

  public static final int TITLE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object title_ = "";

  /**
   *
   *
   * <pre>
   * Optional. An optional title for the text.
   * </pre>
   *
   * <code>optional string title = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the title field is set.
   */
  @java.lang.Override
  public boolean hasTitle() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. An optional title for the text.
   * </pre>
   *
   * <code>optional string title = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. An optional title for the text.
   * </pre>
   *
   * <code>optional string title = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TASK_TYPE_FIELD_NUMBER = 5;
  private int taskType_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The task type of the embedding.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType task_type = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the taskType field is set.
   */
  @java.lang.Override
  public boolean hasTaskType() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The task type of the embedding.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType task_type = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for taskType.
   */
  @java.lang.Override
  public int getTaskTypeValue() {
    return taskType_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The task type of the embedding.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType task_type = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The taskType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType getTaskType() {
    com.google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType result =
        com.google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType.forNumber(taskType_);
    return result == null
        ? com.google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType.UNRECOGNIZED
        : result;
  }

  public static final int OUTPUT_DIMENSIONALITY_FIELD_NUMBER = 6;
  private int outputDimensionality_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Optional reduced dimension for the output embedding. If set,
   * excessive values in the output embedding are truncated from the end.
   * </pre>
   *
   * <code>optional int32 output_dimensionality = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the outputDimensionality field is set.
   */
  @java.lang.Override
  public boolean hasOutputDimensionality() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional reduced dimension for the output embedding. If set,
   * excessive values in the output embedding are truncated from the end.
   * </pre>
   *
   * <code>optional int32 output_dimensionality = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The outputDimensionality.
   */
  @java.lang.Override
  public int getOutputDimensionality() {
    return outputDimensionality_;
  }

  public static final int AUTO_TRUNCATE_FIELD_NUMBER = 7;
  private boolean autoTruncate_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Whether to silently truncate the input content if it's longer
   * than the maximum sequence length.
   * </pre>
   *
   * <code>optional bool auto_truncate = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the autoTruncate field is set.
   */
  @java.lang.Override
  public boolean hasAutoTruncate() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Whether to silently truncate the input content if it's longer
   * than the maximum sequence length.
   * </pre>
   *
   * <code>optional bool auto_truncate = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The autoTruncate.
   */
  @java.lang.Override
  public boolean getAutoTruncate() {
    return autoTruncate_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, model_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getContent());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, title_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeEnum(5, taskType_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(6, outputDimensionality_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeBool(7, autoTruncate_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, model_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getContent());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, title_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, taskType_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, outputDimensionality_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, autoTruncate_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.EmbedContentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.EmbedContentRequest other =
        (com.google.cloud.aiplatform.v1.EmbedContentRequest) obj;

    if (hasModel() != other.hasModel()) return false;
    if (hasModel()) {
      if (!getModel().equals(other.getModel())) return false;
    }
    if (hasContent() != other.hasContent()) return false;
    if (hasContent()) {
      if (!getContent().equals(other.getContent())) return false;
    }
    if (hasTitle() != other.hasTitle()) return false;
    if (hasTitle()) {
      if (!getTitle().equals(other.getTitle())) return false;
    }
    if (hasTaskType() != other.hasTaskType()) return false;
    if (hasTaskType()) {
      if (taskType_ != other.taskType_) return false;
    }
    if (hasOutputDimensionality() != other.hasOutputDimensionality()) return false;
    if (hasOutputDimensionality()) {
      if (getOutputDimensionality() != other.getOutputDimensionality()) return false;
    }
    if (hasAutoTruncate() != other.hasAutoTruncate()) return false;
    if (hasAutoTruncate()) {
      if (getAutoTruncate() != other.getAutoTruncate()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasModel()) {
      hash = (37 * hash) + MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getModel().hashCode();
    }
    if (hasContent()) {
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
    }
    if (hasTitle()) {
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
    }
    if (hasTaskType()) {
      hash = (37 * hash) + TASK_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + taskType_;
    }
    if (hasOutputDimensionality()) {
      hash = (37 * hash) + OUTPUT_DIMENSIONALITY_FIELD_NUMBER;
      hash = (53 * hash) + getOutputDimensionality();
    }
    if (hasAutoTruncate()) {
      hash = (37 * hash) + AUTO_TRUNCATE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoTruncate());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.EmbedContentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [PredictionService.EmbedContent][google.cloud.aiplatform.v1.PredictionService.EmbedContent].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.EmbedContentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.EmbedContentRequest)
      com.google.cloud.aiplatform.v1.EmbedContentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1_EmbedContentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1_EmbedContentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.EmbedContentRequest.class,
              com.google.cloud.aiplatform.v1.EmbedContentRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.EmbedContentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getContentFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      model_ = "";
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      title_ = "";
      taskType_ = 0;
      outputDimensionality_ = 0;
      autoTruncate_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1_EmbedContentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EmbedContentRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.EmbedContentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EmbedContentRequest build() {
      com.google.cloud.aiplatform.v1.EmbedContentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EmbedContentRequest buildPartial() {
      com.google.cloud.aiplatform.v1.EmbedContentRequest result =
          new com.google.cloud.aiplatform.v1.EmbedContentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.EmbedContentRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.model_ = model_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.content_ = contentBuilder_ == null ? content_ : contentBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.title_ = title_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.taskType_ = taskType_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.outputDimensionality_ = outputDimensionality_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.autoTruncate_ = autoTruncate_;
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.EmbedContentRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.EmbedContentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.EmbedContentRequest other) {
      if (other == com.google.cloud.aiplatform.v1.EmbedContentRequest.getDefaultInstance())
        return this;
      if (other.hasModel()) {
        model_ = other.model_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasContent()) {
        mergeContent(other.getContent());
      }
      if (other.hasTitle()) {
        title_ = other.title_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasTaskType()) {
        setTaskType(other.getTaskType());
      }
      if (other.hasOutputDimensionality()) {
        setOutputDimensionality(other.getOutputDimensionality());
      }
      if (other.hasAutoTruncate()) {
        setAutoTruncate(other.getAutoTruncate());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getContentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                title_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 40:
              {
                taskType_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 48:
              {
                outputDimensionality_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 56:
              {
                autoTruncate_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object model_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the publisher model requested to serve the
     * prediction. Format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     * </pre>
     *
     * <code>optional string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the model field is set.
     */
    public boolean hasModel() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the publisher model requested to serve the
     * prediction. Format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     * </pre>
     *
     * <code>optional string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the publisher model requested to serve the
     * prediction. Format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     * </pre>
     *
     * <code>optional string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the publisher model requested to serve the
     * prediction. Format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     * </pre>
     *
     * <code>optional string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the publisher model requested to serve the
     * prediction. Format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     * </pre>
     *
     * <code>optional string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the publisher model requested to serve the
     * prediction. Format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     * </pre>
     *
     * <code>optional string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.Content content_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Content,
            com.google.cloud.aiplatform.v1.Content.Builder,
            com.google.cloud.aiplatform.v1.ContentOrBuilder>
        contentBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Input content to be embedded. Required.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
     *
     * @return Whether the content field is set.
     */
    public boolean hasContent() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Input content to be embedded. Required.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
     *
     * @return The content.
     */
    public com.google.cloud.aiplatform.v1.Content getContent() {
      if (contentBuilder_ == null) {
        return content_ == null
            ? com.google.cloud.aiplatform.v1.Content.getDefaultInstance()
            : content_;
      } else {
        return contentBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Input content to be embedded. Required.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
     */
    public Builder setContent(com.google.cloud.aiplatform.v1.Content value) {
      if (contentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
      } else {
        contentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Input content to be embedded. Required.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
     */
    public Builder setContent(com.google.cloud.aiplatform.v1.Content.Builder builderForValue) {
      if (contentBuilder_ == null) {
        content_ = builderForValue.build();
      } else {
        contentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Input content to be embedded. Required.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
     */
    public Builder mergeContent(com.google.cloud.aiplatform.v1.Content value) {
      if (contentBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && content_ != null
            && content_ != com.google.cloud.aiplatform.v1.Content.getDefaultInstance()) {
          getContentBuilder().mergeFrom(value);
        } else {
          content_ = value;
        }
      } else {
        contentBuilder_.mergeFrom(value);
      }
      if (content_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Input content to be embedded. Required.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
     */
    public Builder clearContent() {
      bitField0_ = (bitField0_ & ~0x00000002);
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Input content to be embedded. Required.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.Content.Builder getContentBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getContentFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Input content to be embedded. Required.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.ContentOrBuilder getContentOrBuilder() {
      if (contentBuilder_ != null) {
        return contentBuilder_.getMessageOrBuilder();
      } else {
        return content_ == null
            ? com.google.cloud.aiplatform.v1.Content.getDefaultInstance()
            : content_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Input content to be embedded. Required.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.Content content = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Content,
            com.google.cloud.aiplatform.v1.Content.Builder,
            com.google.cloud.aiplatform.v1.ContentOrBuilder>
        getContentFieldBuilder() {
      if (contentBuilder_ == null) {
        contentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Content,
                com.google.cloud.aiplatform.v1.Content.Builder,
                com.google.cloud.aiplatform.v1.ContentOrBuilder>(
                getContent(), getParentForChildren(), isClean());
        content_ = null;
      }
      return contentBuilder_;
    }

    private java.lang.Object title_ = "";

    /**
     *
     *
     * <pre>
     * Optional. An optional title for the text.
     * </pre>
     *
     * <code>optional string title = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the title field is set.
     */
    public boolean hasTitle() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional title for the text.
     * </pre>
     *
     * <code>optional string title = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional title for the text.
     * </pre>
     *
     * <code>optional string title = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for title.
     */
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional title for the text.
     * </pre>
     *
     * <code>optional string title = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      title_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional title for the text.
     * </pre>
     *
     * <code>optional string title = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTitle() {
      title_ = getDefaultInstance().getTitle();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional title for the text.
     * </pre>
     *
     * <code>optional string title = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      title_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int taskType_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The task type of the embedding.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType task_type = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the taskType field is set.
     */
    @java.lang.Override
    public boolean hasTaskType() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The task type of the embedding.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType task_type = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for taskType.
     */
    @java.lang.Override
    public int getTaskTypeValue() {
      return taskType_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The task type of the embedding.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType task_type = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for taskType to set.
     * @return This builder for chaining.
     */
    public Builder setTaskTypeValue(int value) {
      taskType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The task type of the embedding.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType task_type = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The taskType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType getTaskType() {
      com.google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType result =
          com.google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType.forNumber(taskType_);
      return result == null
          ? com.google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. The task type of the embedding.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType task_type = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The taskType to set.
     * @return This builder for chaining.
     */
    public Builder setTaskType(
        com.google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      taskType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The task type of the embedding.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.EmbedContentRequest.EmbeddingTaskType task_type = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTaskType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      taskType_ = 0;
      onChanged();
      return this;
    }

    private int outputDimensionality_;

    /**
     *
     *
     * <pre>
     * Optional. Optional reduced dimension for the output embedding. If set,
     * excessive values in the output embedding are truncated from the end.
     * </pre>
     *
     * <code>optional int32 output_dimensionality = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the outputDimensionality field is set.
     */
    @java.lang.Override
    public boolean hasOutputDimensionality() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional reduced dimension for the output embedding. If set,
     * excessive values in the output embedding are truncated from the end.
     * </pre>
     *
     * <code>optional int32 output_dimensionality = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The outputDimensionality.
     */
    @java.lang.Override
    public int getOutputDimensionality() {
      return outputDimensionality_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional reduced dimension for the output embedding. If set,
     * excessive values in the output embedding are truncated from the end.
     * </pre>
     *
     * <code>optional int32 output_dimensionality = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The outputDimensionality to set.
     * @return This builder for chaining.
     */
    public Builder setOutputDimensionality(int value) {

      outputDimensionality_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional reduced dimension for the output embedding. If set,
     * excessive values in the output embedding are truncated from the end.
     * </pre>
     *
     * <code>optional int32 output_dimensionality = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputDimensionality() {
      bitField0_ = (bitField0_ & ~0x00000010);
      outputDimensionality_ = 0;
      onChanged();
      return this;
    }

    private boolean autoTruncate_;

    /**
     *
     *
     * <pre>
     * Optional. Whether to silently truncate the input content if it's longer
     * than the maximum sequence length.
     * </pre>
     *
     * <code>optional bool auto_truncate = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the autoTruncate field is set.
     */
    @java.lang.Override
    public boolean hasAutoTruncate() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether to silently truncate the input content if it's longer
     * than the maximum sequence length.
     * </pre>
     *
     * <code>optional bool auto_truncate = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The autoTruncate.
     */
    @java.lang.Override
    public boolean getAutoTruncate() {
      return autoTruncate_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether to silently truncate the input content if it's longer
     * than the maximum sequence length.
     * </pre>
     *
     * <code>optional bool auto_truncate = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The autoTruncate to set.
     * @return This builder for chaining.
     */
    public Builder setAutoTruncate(boolean value) {

      autoTruncate_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether to silently truncate the input content if it's longer
     * than the maximum sequence length.
     * </pre>
     *
     * <code>optional bool auto_truncate = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoTruncate() {
      bitField0_ = (bitField0_ & ~0x00000020);
      autoTruncate_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.EmbedContentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.EmbedContentRequest)
  private static final com.google.cloud.aiplatform.v1.EmbedContentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.EmbedContentRequest();
  }

  public static com.google.cloud.aiplatform.v1.EmbedContentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EmbedContentRequest> PARSER =
      new com.google.protobuf.AbstractParser<EmbedContentRequest>() {
        @java.lang.Override
        public EmbedContentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EmbedContentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EmbedContentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EmbedContentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
