/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/feature_online_store_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [FeatureOnlineStoreService.FeatureViewDirectWrite][google.cloud.aiplatform.v1.FeatureOnlineStoreService.FeatureViewDirectWrite].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest}
 */
public final class FeatureViewDirectWriteRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest)
    FeatureViewDirectWriteRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FeatureViewDirectWriteRequest.newBuilder() to construct.
  private FeatureViewDirectWriteRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureViewDirectWriteRequest() {
    featureView_ = "";
    dataKeyAndFeatureValues_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureViewDirectWriteRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.class,
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.Builder.class);
  }

  public interface DataKeyAndFeatureValuesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The data key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     *
     * @return Whether the dataKey field is set.
     */
    boolean hasDataKey();

    /**
     *
     *
     * <pre>
     * The data key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     *
     * @return The dataKey.
     */
    com.google.cloud.aiplatform.v1.FeatureViewDataKey getDataKey();

    /**
     *
     *
     * <pre>
     * The data key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     */
    com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder getDataKeyOrBuilder();

    /**
     *
     *
     * <pre>
     * List of features to write.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
     * </code>
     */
    java.util.List<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .Feature>
        getFeaturesList();

    /**
     *
     *
     * <pre>
     * List of features to write.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature
        getFeatures(int index);

    /**
     *
     *
     * <pre>
     * List of features to write.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
     * </code>
     */
    int getFeaturesCount();

    /**
     *
     *
     * <pre>
     * List of features to write.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .FeatureOrBuilder>
        getFeaturesOrBuilderList();

    /**
     *
     *
     * <pre>
     * List of features to write.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            .FeatureOrBuilder
        getFeaturesOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * A data key and associated feature values to write to the feature view.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues}
   */
  public static final class DataKeyAndFeatureValues extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues)
      DataKeyAndFeatureValuesOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DataKeyAndFeatureValues.newBuilder() to construct.
    private DataKeyAndFeatureValues(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataKeyAndFeatureValues() {
      features_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataKeyAndFeatureValues();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_DataKeyAndFeatureValues_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_DataKeyAndFeatureValues_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .class,
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Builder.class);
    }

    public interface FeatureOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Feature value. A user provided timestamp may be set in the
       * `FeatureValue.metadata.generate_time` field.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
       *
       * @return Whether the value field is set.
       */
      boolean hasValue();

      /**
       *
       *
       * <pre>
       * Feature value. A user provided timestamp may be set in the
       * `FeatureValue.metadata.generate_time` field.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
       *
       * @return The value.
       */
      com.google.cloud.aiplatform.v1.FeatureValue getValue();

      /**
       *
       *
       * <pre>
       * Feature value. A user provided timestamp may be set in the
       * `FeatureValue.metadata.generate_time` field.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
       */
      com.google.cloud.aiplatform.v1.FeatureValueOrBuilder getValueOrBuilder();

      /**
       *
       *
       * <pre>
       * Feature short name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      java.lang.String getName();

      /**
       *
       *
       * <pre>
       * Feature short name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();

      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature
              .DataOneofCase
          getDataOneofCase();
    }

    /**
     *
     *
     * <pre>
     * Feature name &amp; value pair.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature}
     */
    public static final class Feature extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature)
        FeatureOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use Feature.newBuilder() to construct.
      private Feature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Feature() {
        name_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Feature();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_DataKeyAndFeatureValues_Feature_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_DataKeyAndFeatureValues_Feature_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .Feature.class,
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .Feature.Builder.class);
      }

      private int dataOneofCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object dataOneof_;

      public enum DataOneofCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        VALUE(3),
        DATAONEOF_NOT_SET(0);
        private final int value;

        private DataOneofCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static DataOneofCase valueOf(int value) {
          return forNumber(value);
        }

        public static DataOneofCase forNumber(int value) {
          switch (value) {
            case 3:
              return VALUE;
            case 0:
              return DATAONEOF_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public DataOneofCase getDataOneofCase() {
        return DataOneofCase.forNumber(dataOneofCase_);
      }

      public static final int VALUE_FIELD_NUMBER = 3;

      /**
       *
       *
       * <pre>
       * Feature value. A user provided timestamp may be set in the
       * `FeatureValue.metadata.generate_time` field.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
       *
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return dataOneofCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Feature value. A user provided timestamp may be set in the
       * `FeatureValue.metadata.generate_time` field.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureValue getValue() {
        if (dataOneofCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.FeatureValue) dataOneof_;
        }
        return com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Feature value. A user provided timestamp may be set in the
       * `FeatureValue.metadata.generate_time` field.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureValueOrBuilder getValueOrBuilder() {
        if (dataOneofCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.FeatureValue) dataOneof_;
        }
        return com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
      }

      public static final int NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";

      /**
       *
       *
       * <pre>
       * Feature short name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Feature short name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (dataOneofCase_ == 3) {
          output.writeMessage(3, (com.google.cloud.aiplatform.v1.FeatureValue) dataOneof_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (dataOneofCase_ == 3) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3, (com.google.cloud.aiplatform.v1.FeatureValue) dataOneof_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .Feature)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature
            other =
                (com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                        .DataKeyAndFeatureValues.Feature)
                    obj;

        if (!getName().equals(other.getName())) return false;
        if (!getDataOneofCase().equals(other.getDataOneofCase())) return false;
        switch (dataOneofCase_) {
          case 3:
            if (!getValue().equals(other.getValue())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        switch (dataOneofCase_) {
          case 3:
            hash = (37 * hash) + VALUE_FIELD_NUMBER;
            hash = (53 * hash) + getValue().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Feature name &amp; value pair.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature)
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
              .FeatureOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
              .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_DataKeyAndFeatureValues_Feature_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
              .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_DataKeyAndFeatureValues_Feature_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                      .DataKeyAndFeatureValues.Feature.class,
                  com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                      .DataKeyAndFeatureValues.Feature.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (valueBuilder_ != null) {
            valueBuilder_.clear();
          }
          name_ = "";
          dataOneofCase_ = 0;
          dataOneof_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
              .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_DataKeyAndFeatureValues_Feature_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .Feature
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .Feature
            build() {
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .Feature
            buildPartial() {
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature
              result =
                  new com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                      .DataKeyAndFeatureValues.Feature(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .Feature
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.name_ = name_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .Feature
                result) {
          result.dataOneofCase_ = dataOneofCase_;
          result.dataOneof_ = this.dataOneof_;
          if (dataOneofCase_ == 3 && valueBuilder_ != null) {
            result.dataOneof_ = valueBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                        .DataKeyAndFeatureValues.Feature)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .Feature
                other) {
          if (other
              == com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                  .DataKeyAndFeatureValues.Feature.getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          switch (other.getDataOneofCase()) {
            case VALUE:
              {
                mergeValue(other.getValue());
                break;
              }
            case DATAONEOF_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 10
                case 26:
                  {
                    input.readMessage(getValueFieldBuilder().getBuilder(), extensionRegistry);
                    dataOneofCase_ = 3;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int dataOneofCase_ = 0;
        private java.lang.Object dataOneof_;

        public DataOneofCase getDataOneofCase() {
          return DataOneofCase.forNumber(dataOneofCase_);
        }

        public Builder clearDataOneof() {
          dataOneofCase_ = 0;
          dataOneof_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureValue,
                com.google.cloud.aiplatform.v1.FeatureValue.Builder,
                com.google.cloud.aiplatform.v1.FeatureValueOrBuilder>
            valueBuilder_;

        /**
         *
         *
         * <pre>
         * Feature value. A user provided timestamp may be set in the
         * `FeatureValue.metadata.generate_time` field.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
         *
         * @return Whether the value field is set.
         */
        @java.lang.Override
        public boolean hasValue() {
          return dataOneofCase_ == 3;
        }

        /**
         *
         *
         * <pre>
         * Feature value. A user provided timestamp may be set in the
         * `FeatureValue.metadata.generate_time` field.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
         *
         * @return The value.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.FeatureValue getValue() {
          if (valueBuilder_ == null) {
            if (dataOneofCase_ == 3) {
              return (com.google.cloud.aiplatform.v1.FeatureValue) dataOneof_;
            }
            return com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
          } else {
            if (dataOneofCase_ == 3) {
              return valueBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Feature value. A user provided timestamp may be set in the
         * `FeatureValue.metadata.generate_time` field.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
         */
        public Builder setValue(com.google.cloud.aiplatform.v1.FeatureValue value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            dataOneof_ = value;
            onChanged();
          } else {
            valueBuilder_.setMessage(value);
          }
          dataOneofCase_ = 3;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Feature value. A user provided timestamp may be set in the
         * `FeatureValue.metadata.generate_time` field.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
         */
        public Builder setValue(
            com.google.cloud.aiplatform.v1.FeatureValue.Builder builderForValue) {
          if (valueBuilder_ == null) {
            dataOneof_ = builderForValue.build();
            onChanged();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          dataOneofCase_ = 3;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Feature value. A user provided timestamp may be set in the
         * `FeatureValue.metadata.generate_time` field.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
         */
        public Builder mergeValue(com.google.cloud.aiplatform.v1.FeatureValue value) {
          if (valueBuilder_ == null) {
            if (dataOneofCase_ == 3
                && dataOneof_ != com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance()) {
              dataOneof_ =
                  com.google.cloud.aiplatform.v1.FeatureValue.newBuilder(
                          (com.google.cloud.aiplatform.v1.FeatureValue) dataOneof_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              dataOneof_ = value;
            }
            onChanged();
          } else {
            if (dataOneofCase_ == 3) {
              valueBuilder_.mergeFrom(value);
            } else {
              valueBuilder_.setMessage(value);
            }
          }
          dataOneofCase_ = 3;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Feature value. A user provided timestamp may be set in the
         * `FeatureValue.metadata.generate_time` field.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
         */
        public Builder clearValue() {
          if (valueBuilder_ == null) {
            if (dataOneofCase_ == 3) {
              dataOneofCase_ = 0;
              dataOneof_ = null;
              onChanged();
            }
          } else {
            if (dataOneofCase_ == 3) {
              dataOneofCase_ = 0;
              dataOneof_ = null;
            }
            valueBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Feature value. A user provided timestamp may be set in the
         * `FeatureValue.metadata.generate_time` field.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
         */
        public com.google.cloud.aiplatform.v1.FeatureValue.Builder getValueBuilder() {
          return getValueFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Feature value. A user provided timestamp may be set in the
         * `FeatureValue.metadata.generate_time` field.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.FeatureValueOrBuilder getValueOrBuilder() {
          if ((dataOneofCase_ == 3) && (valueBuilder_ != null)) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            if (dataOneofCase_ == 3) {
              return (com.google.cloud.aiplatform.v1.FeatureValue) dataOneof_;
            }
            return com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Feature value. A user provided timestamp may be set in the
         * `FeatureValue.metadata.generate_time` field.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureValue,
                com.google.cloud.aiplatform.v1.FeatureValue.Builder,
                com.google.cloud.aiplatform.v1.FeatureValueOrBuilder>
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            if (!(dataOneofCase_ == 3)) {
              dataOneof_ = com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
            }
            valueBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1.FeatureValue,
                    com.google.cloud.aiplatform.v1.FeatureValue.Builder,
                    com.google.cloud.aiplatform.v1.FeatureValueOrBuilder>(
                    (com.google.cloud.aiplatform.v1.FeatureValue) dataOneof_,
                    getParentForChildren(),
                    isClean());
            dataOneof_ = null;
          }
          dataOneofCase_ = 3;
          onChanged();
          return valueBuilder_;
        }

        private java.lang.Object name_ = "";

        /**
         *
         *
         * <pre>
         * Feature short name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Feature short name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Feature short name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Feature short name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Feature short name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature)
      private static final com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .Feature();
      }

      public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues.Feature
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Feature> PARSER =
          new com.google.protobuf.AbstractParser<Feature>() {
            @java.lang.Override
            public Feature parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Feature> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Feature> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
              .Feature
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int DATA_KEY_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1.FeatureViewDataKey dataKey_;

    /**
     *
     *
     * <pre>
     * The data key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     *
     * @return Whether the dataKey field is set.
     */
    @java.lang.Override
    public boolean hasDataKey() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The data key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     *
     * @return The dataKey.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDataKey getDataKey() {
      return dataKey_ == null
          ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
          : dataKey_;
    }

    /**
     *
     *
     * <pre>
     * The data key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder getDataKeyOrBuilder() {
      return dataKey_ == null
          ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
          : dataKey_;
    }

    public static final int FEATURES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .Feature>
        features_;

    /**
     *
     *
     * <pre>
     * List of features to write.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .Feature>
        getFeaturesList() {
      return features_;
    }

    /**
     *
     *
     * <pre>
     * List of features to write.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .FeatureOrBuilder>
        getFeaturesOrBuilderList() {
      return features_;
    }

    /**
     *
     *
     * <pre>
     * List of features to write.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
     * </code>
     */
    @java.lang.Override
    public int getFeaturesCount() {
      return features_.size();
    }

    /**
     *
     *
     * <pre>
     * List of features to write.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            .Feature
        getFeatures(int index) {
      return features_.get(index);
    }

    /**
     *
     *
     * <pre>
     * List of features to write.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            .FeatureOrBuilder
        getFeaturesOrBuilder(int index) {
      return features_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getDataKey());
      }
      for (int i = 0; i < features_.size(); i++) {
        output.writeMessage(2, features_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDataKey());
      }
      for (int i = 0; i < features_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, features_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues other =
          (com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues)
              obj;

      if (hasDataKey() != other.hasDataKey()) return false;
      if (hasDataKey()) {
        if (!getDataKey().equals(other.getDataKey())) return false;
      }
      if (!getFeaturesList().equals(other.getFeaturesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDataKey()) {
        hash = (37 * hash) + DATA_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getDataKey().hashCode();
      }
      if (getFeaturesCount() > 0) {
        hash = (37 * hash) + FEATURES_FIELD_NUMBER;
        hash = (53 * hash) + getFeaturesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A data key and associated feature values to write to the feature view.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues)
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValuesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_DataKeyAndFeatureValues_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_DataKeyAndFeatureValues_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .class,
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDataKeyFieldBuilder();
          getFeaturesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataKey_ = null;
        if (dataKeyBuilder_ != null) {
          dataKeyBuilder_.dispose();
          dataKeyBuilder_ = null;
        }
        if (featuresBuilder_ == null) {
          features_ = java.util.Collections.emptyList();
        } else {
          features_ = null;
          featuresBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_DataKeyAndFeatureValues_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
          build() {
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
          buildPartial() {
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            result =
                new com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                    .DataKeyAndFeatureValues(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
              result) {
        if (featuresBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            features_ = java.util.Collections.unmodifiableList(features_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.features_ = features_;
        } else {
          result.features_ = featuresBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dataKey_ = dataKeyBuilder_ == null ? dataKey_ : dataKeyBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
              other) {
        if (other
            == com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .getDefaultInstance()) return this;
        if (other.hasDataKey()) {
          mergeDataKey(other.getDataKey());
        }
        if (featuresBuilder_ == null) {
          if (!other.features_.isEmpty()) {
            if (features_.isEmpty()) {
              features_ = other.features_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureFeaturesIsMutable();
              features_.addAll(other.features_);
            }
            onChanged();
          }
        } else {
          if (!other.features_.isEmpty()) {
            if (featuresBuilder_.isEmpty()) {
              featuresBuilder_.dispose();
              featuresBuilder_ = null;
              features_ = other.features_;
              bitField0_ = (bitField0_ & ~0x00000002);
              featuresBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFeaturesFieldBuilder()
                      : null;
            } else {
              featuresBuilder_.addAllMessages(other.features_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getDataKeyFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                          .DataKeyAndFeatureValues.Feature
                      m =
                          input.readMessage(
                              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                                  .DataKeyAndFeatureValues.Feature.parser(),
                              extensionRegistry);
                  if (featuresBuilder_ == null) {
                    ensureFeaturesIsMutable();
                    features_.add(m);
                  } else {
                    featuresBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1.FeatureViewDataKey dataKey_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.FeatureViewDataKey,
              com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder,
              com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder>
          dataKeyBuilder_;

      /**
       *
       *
       * <pre>
       * The data key.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       *
       * @return Whether the dataKey field is set.
       */
      public boolean hasDataKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The data key.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       *
       * @return The dataKey.
       */
      public com.google.cloud.aiplatform.v1.FeatureViewDataKey getDataKey() {
        if (dataKeyBuilder_ == null) {
          return dataKey_ == null
              ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
              : dataKey_;
        } else {
          return dataKeyBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The data key.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public Builder setDataKey(com.google.cloud.aiplatform.v1.FeatureViewDataKey value) {
        if (dataKeyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataKey_ = value;
        } else {
          dataKeyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The data key.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public Builder setDataKey(
          com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder builderForValue) {
        if (dataKeyBuilder_ == null) {
          dataKey_ = builderForValue.build();
        } else {
          dataKeyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The data key.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public Builder mergeDataKey(com.google.cloud.aiplatform.v1.FeatureViewDataKey value) {
        if (dataKeyBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && dataKey_ != null
              && dataKey_
                  != com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()) {
            getDataKeyBuilder().mergeFrom(value);
          } else {
            dataKey_ = value;
          }
        } else {
          dataKeyBuilder_.mergeFrom(value);
        }
        if (dataKey_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The data key.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public Builder clearDataKey() {
        bitField0_ = (bitField0_ & ~0x00000001);
        dataKey_ = null;
        if (dataKeyBuilder_ != null) {
          dataKeyBuilder_.dispose();
          dataKeyBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The data key.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder getDataKeyBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDataKeyFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The data key.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder getDataKeyOrBuilder() {
        if (dataKeyBuilder_ != null) {
          return dataKeyBuilder_.getMessageOrBuilder();
        } else {
          return dataKey_ == null
              ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
              : dataKey_;
        }
      }

      /**
       *
       *
       * <pre>
       * The data key.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.FeatureViewDataKey,
              com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder,
              com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder>
          getDataKeyFieldBuilder() {
        if (dataKeyBuilder_ == null) {
          dataKeyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.FeatureViewDataKey,
                  com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder,
                  com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder>(
                  getDataKey(), getParentForChildren(), isClean());
          dataKey_ = null;
        }
        return dataKeyBuilder_;
      }

      private java.util.List<
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature>
          features_ = java.util.Collections.emptyList();

      private void ensureFeaturesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          features_ =
              new java.util.ArrayList<
                  com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                      .DataKeyAndFeatureValues.Feature>(features_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature,
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature.Builder,
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .FeatureOrBuilder>
          featuresBuilder_;

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature>
          getFeaturesList() {
        if (featuresBuilder_ == null) {
          return java.util.Collections.unmodifiableList(features_);
        } else {
          return featuresBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public int getFeaturesCount() {
        if (featuresBuilder_ == null) {
          return features_.size();
        } else {
          return featuresBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
              .Feature
          getFeatures(int index) {
        if (featuresBuilder_ == null) {
          return features_.get(index);
        } else {
          return featuresBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public Builder setFeatures(
          int index,
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature
              value) {
        if (featuresBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeaturesIsMutable();
          features_.set(index, value);
          onChanged();
        } else {
          featuresBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public Builder setFeatures(
          int index,
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature.Builder
              builderForValue) {
        if (featuresBuilder_ == null) {
          ensureFeaturesIsMutable();
          features_.set(index, builderForValue.build());
          onChanged();
        } else {
          featuresBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public Builder addFeatures(
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature
              value) {
        if (featuresBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeaturesIsMutable();
          features_.add(value);
          onChanged();
        } else {
          featuresBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public Builder addFeatures(
          int index,
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature
              value) {
        if (featuresBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeaturesIsMutable();
          features_.add(index, value);
          onChanged();
        } else {
          featuresBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public Builder addFeatures(
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature.Builder
              builderForValue) {
        if (featuresBuilder_ == null) {
          ensureFeaturesIsMutable();
          features_.add(builderForValue.build());
          onChanged();
        } else {
          featuresBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public Builder addFeatures(
          int index,
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature.Builder
              builderForValue) {
        if (featuresBuilder_ == null) {
          ensureFeaturesIsMutable();
          features_.add(index, builderForValue.build());
          onChanged();
        } else {
          featuresBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public Builder addAllFeatures(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                          .DataKeyAndFeatureValues.Feature>
              values) {
        if (featuresBuilder_ == null) {
          ensureFeaturesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, features_);
          onChanged();
        } else {
          featuresBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public Builder clearFeatures() {
        if (featuresBuilder_ == null) {
          features_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          featuresBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public Builder removeFeatures(int index) {
        if (featuresBuilder_ == null) {
          ensureFeaturesIsMutable();
          features_.remove(index);
          onChanged();
        } else {
          featuresBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
              .Feature.Builder
          getFeaturesBuilder(int index) {
        return getFeaturesFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
              .FeatureOrBuilder
          getFeaturesOrBuilder(int index) {
        if (featuresBuilder_ == null) {
          return features_.get(index);
        } else {
          return featuresBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                      .DataKeyAndFeatureValues.FeatureOrBuilder>
          getFeaturesOrBuilderList() {
        if (featuresBuilder_ != null) {
          return featuresBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(features_);
        }
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
              .Feature.Builder
          addFeaturesBuilder() {
        return getFeaturesFieldBuilder()
            .addBuilder(
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .Feature.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
              .Feature.Builder
          addFeaturesBuilder(int index) {
        return getFeaturesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .Feature.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * List of features to write.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Feature features = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature.Builder>
          getFeaturesBuilderList() {
        return getFeaturesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature,
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .Feature.Builder,
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .FeatureOrBuilder>
          getFeaturesFieldBuilder() {
        if (featuresBuilder_ == null) {
          featuresBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                      .DataKeyAndFeatureValues.Feature,
                  com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                      .DataKeyAndFeatureValues.Feature.Builder,
                  com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                      .DataKeyAndFeatureValues.FeatureOrBuilder>(
                  features_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          features_ = null;
        }
        return featuresBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues)
    private static final com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
              .DataKeyAndFeatureValues();
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValues
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataKeyAndFeatureValues> PARSER =
        new com.google.protobuf.AbstractParser<DataKeyAndFeatureValues>() {
          @java.lang.Override
          public DataKeyAndFeatureValues parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataKeyAndFeatureValues> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataKeyAndFeatureValues> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int FEATURE_VIEW_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object featureView_ = "";

  /**
   *
   *
   * <pre>
   * FeatureView resource format
   * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
   * </pre>
   *
   * <code>string feature_view = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The featureView.
   */
  @java.lang.Override
  public java.lang.String getFeatureView() {
    java.lang.Object ref = featureView_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      featureView_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * FeatureView resource format
   * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
   * </pre>
   *
   * <code>string feature_view = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for featureView.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFeatureViewBytes() {
    java.lang.Object ref = featureView_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      featureView_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_KEY_AND_FEATURE_VALUES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues>
      dataKeyAndFeatureValues_;

  /**
   *
   *
   * <pre>
   * Required. The data keys and associated feature values.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues>
      getDataKeyAndFeatureValuesList() {
    return dataKeyAndFeatureValues_;
  }

  /**
   *
   *
   * <pre>
   * Required. The data keys and associated feature values.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                  .DataKeyAndFeatureValuesOrBuilder>
      getDataKeyAndFeatureValuesOrBuilderList() {
    return dataKeyAndFeatureValues_;
  }

  /**
   *
   *
   * <pre>
   * Required. The data keys and associated feature values.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getDataKeyAndFeatureValuesCount() {
    return dataKeyAndFeatureValues_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The data keys and associated feature values.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
      getDataKeyAndFeatureValues(int index) {
    return dataKeyAndFeatureValues_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The data keys and associated feature values.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
          .DataKeyAndFeatureValuesOrBuilder
      getDataKeyAndFeatureValuesOrBuilder(int index) {
    return dataKeyAndFeatureValues_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureView_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, featureView_);
    }
    for (int i = 0; i < dataKeyAndFeatureValues_.size(); i++) {
      output.writeMessage(2, dataKeyAndFeatureValues_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureView_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, featureView_);
    }
    for (int i = 0; i < dataKeyAndFeatureValues_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, dataKeyAndFeatureValues_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest other =
        (com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest) obj;

    if (!getFeatureView().equals(other.getFeatureView())) return false;
    if (!getDataKeyAndFeatureValuesList().equals(other.getDataKeyAndFeatureValuesList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FEATURE_VIEW_FIELD_NUMBER;
    hash = (53 * hash) + getFeatureView().hashCode();
    if (getDataKeyAndFeatureValuesCount() > 0) {
      hash = (37 * hash) + DATA_KEY_AND_FEATURE_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getDataKeyAndFeatureValuesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [FeatureOnlineStoreService.FeatureViewDirectWrite][google.cloud.aiplatform.v1.FeatureOnlineStoreService.FeatureViewDirectWrite].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest)
      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.class,
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      featureView_ = "";
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        dataKeyAndFeatureValues_ = java.util.Collections.emptyList();
      } else {
        dataKeyAndFeatureValues_ = null;
        dataKeyAndFeatureValuesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest build() {
      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest buildPartial() {
      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest result =
          new com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest result) {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          dataKeyAndFeatureValues_ =
              java.util.Collections.unmodifiableList(dataKeyAndFeatureValues_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.dataKeyAndFeatureValues_ = dataKeyAndFeatureValues_;
      } else {
        result.dataKeyAndFeatureValues_ = dataKeyAndFeatureValuesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.featureView_ = featureView_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest other) {
      if (other
          == com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.getDefaultInstance())
        return this;
      if (!other.getFeatureView().isEmpty()) {
        featureView_ = other.featureView_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        if (!other.dataKeyAndFeatureValues_.isEmpty()) {
          if (dataKeyAndFeatureValues_.isEmpty()) {
            dataKeyAndFeatureValues_ = other.dataKeyAndFeatureValues_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDataKeyAndFeatureValuesIsMutable();
            dataKeyAndFeatureValues_.addAll(other.dataKeyAndFeatureValues_);
          }
          onChanged();
        }
      } else {
        if (!other.dataKeyAndFeatureValues_.isEmpty()) {
          if (dataKeyAndFeatureValuesBuilder_.isEmpty()) {
            dataKeyAndFeatureValuesBuilder_.dispose();
            dataKeyAndFeatureValuesBuilder_ = null;
            dataKeyAndFeatureValues_ = other.dataKeyAndFeatureValues_;
            bitField0_ = (bitField0_ & ~0x00000002);
            dataKeyAndFeatureValuesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDataKeyAndFeatureValuesFieldBuilder()
                    : null;
          } else {
            dataKeyAndFeatureValuesBuilder_.addAllMessages(other.dataKeyAndFeatureValues_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                featureView_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                                .DataKeyAndFeatureValues.parser(),
                            extensionRegistry);
                if (dataKeyAndFeatureValuesBuilder_ == null) {
                  ensureDataKeyAndFeatureValuesIsMutable();
                  dataKeyAndFeatureValues_.add(m);
                } else {
                  dataKeyAndFeatureValuesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object featureView_ = "";

    /**
     *
     *
     * <pre>
     * FeatureView resource format
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
     * </pre>
     *
     * <code>string feature_view = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The featureView.
     */
    public java.lang.String getFeatureView() {
      java.lang.Object ref = featureView_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        featureView_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * FeatureView resource format
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
     * </pre>
     *
     * <code>string feature_view = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for featureView.
     */
    public com.google.protobuf.ByteString getFeatureViewBytes() {
      java.lang.Object ref = featureView_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        featureView_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * FeatureView resource format
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
     * </pre>
     *
     * <code>string feature_view = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The featureView to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureView(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      featureView_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * FeatureView resource format
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
     * </pre>
     *
     * <code>string feature_view = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeatureView() {
      featureView_ = getDefaultInstance().getFeatureView();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * FeatureView resource format
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
     * </pre>
     *
     * <code>string feature_view = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for featureView to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureViewBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      featureView_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues>
        dataKeyAndFeatureValues_ = java.util.Collections.emptyList();

    private void ensureDataKeyAndFeatureValuesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        dataKeyAndFeatureValues_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                    .DataKeyAndFeatureValues>(dataKeyAndFeatureValues_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues,
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .Builder,
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                .DataKeyAndFeatureValuesOrBuilder>
        dataKeyAndFeatureValuesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues>
        getDataKeyAndFeatureValuesList() {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dataKeyAndFeatureValues_);
      } else {
        return dataKeyAndFeatureValuesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getDataKeyAndFeatureValuesCount() {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        return dataKeyAndFeatureValues_.size();
      } else {
        return dataKeyAndFeatureValuesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
        getDataKeyAndFeatureValues(int index) {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        return dataKeyAndFeatureValues_.get(index);
      } else {
        return dataKeyAndFeatureValuesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDataKeyAndFeatureValues(
        int index,
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            value) {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataKeyAndFeatureValuesIsMutable();
        dataKeyAndFeatureValues_.set(index, value);
        onChanged();
      } else {
        dataKeyAndFeatureValuesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDataKeyAndFeatureValues(
        int index,
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Builder
            builderForValue) {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        ensureDataKeyAndFeatureValuesIsMutable();
        dataKeyAndFeatureValues_.set(index, builderForValue.build());
        onChanged();
      } else {
        dataKeyAndFeatureValuesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDataKeyAndFeatureValues(
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            value) {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataKeyAndFeatureValuesIsMutable();
        dataKeyAndFeatureValues_.add(value);
        onChanged();
      } else {
        dataKeyAndFeatureValuesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDataKeyAndFeatureValues(
        int index,
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            value) {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataKeyAndFeatureValuesIsMutable();
        dataKeyAndFeatureValues_.add(index, value);
        onChanged();
      } else {
        dataKeyAndFeatureValuesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDataKeyAndFeatureValues(
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Builder
            builderForValue) {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        ensureDataKeyAndFeatureValuesIsMutable();
        dataKeyAndFeatureValues_.add(builderForValue.build());
        onChanged();
      } else {
        dataKeyAndFeatureValuesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDataKeyAndFeatureValues(
        int index,
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues.Builder
            builderForValue) {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        ensureDataKeyAndFeatureValuesIsMutable();
        dataKeyAndFeatureValues_.add(index, builderForValue.build());
        onChanged();
      } else {
        dataKeyAndFeatureValuesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllDataKeyAndFeatureValues(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                        .DataKeyAndFeatureValues>
            values) {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        ensureDataKeyAndFeatureValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataKeyAndFeatureValues_);
        onChanged();
      } else {
        dataKeyAndFeatureValuesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDataKeyAndFeatureValues() {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        dataKeyAndFeatureValues_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        dataKeyAndFeatureValuesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeDataKeyAndFeatureValues(int index) {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        ensureDataKeyAndFeatureValuesIsMutable();
        dataKeyAndFeatureValues_.remove(index);
        onChanged();
      } else {
        dataKeyAndFeatureValuesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            .Builder
        getDataKeyAndFeatureValuesBuilder(int index) {
      return getDataKeyAndFeatureValuesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
            .DataKeyAndFeatureValuesOrBuilder
        getDataKeyAndFeatureValuesOrBuilder(int index) {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        return dataKeyAndFeatureValues_.get(index);
      } else {
        return dataKeyAndFeatureValuesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                    .DataKeyAndFeatureValuesOrBuilder>
        getDataKeyAndFeatureValuesOrBuilderList() {
      if (dataKeyAndFeatureValuesBuilder_ != null) {
        return dataKeyAndFeatureValuesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dataKeyAndFeatureValues_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            .Builder
        addDataKeyAndFeatureValuesBuilder() {
      return getDataKeyAndFeatureValuesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
            .Builder
        addDataKeyAndFeatureValuesBuilder(int index) {
      return getDataKeyAndFeatureValuesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The data keys and associated feature values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues data_key_and_feature_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .Builder>
        getDataKeyAndFeatureValuesBuilderList() {
      return getDataKeyAndFeatureValuesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues,
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                .Builder,
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                .DataKeyAndFeatureValuesOrBuilder>
        getDataKeyAndFeatureValuesFieldBuilder() {
      if (dataKeyAndFeatureValuesBuilder_ == null) {
        dataKeyAndFeatureValuesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                    .DataKeyAndFeatureValues,
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest.DataKeyAndFeatureValues
                    .Builder,
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
                    .DataKeyAndFeatureValuesOrBuilder>(
                dataKeyAndFeatureValues_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        dataKeyAndFeatureValues_ = null;
      }
      return dataKeyAndFeatureValuesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest)
  private static final com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest();
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureViewDirectWriteRequest> PARSER =
      new com.google.protobuf.AbstractParser<FeatureViewDirectWriteRequest>() {
        @java.lang.Override
        public FeatureViewDirectWriteRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureViewDirectWriteRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureViewDirectWriteRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
