/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/study.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A message representing a Measurement of a Trial. A Measurement contains
 * the Metrics got by executing a Trial using suggested hyperparameter
 * values.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Measurement}
 */
public final class Measurement extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Measurement)
    MeasurementOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Measurement.newBuilder() to construct.
  private Measurement(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Measurement() {
    metrics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Measurement();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.StudyProto
        .internal_static_google_cloud_aiplatform_v1beta1_Measurement_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.StudyProto
        .internal_static_google_cloud_aiplatform_v1beta1_Measurement_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Measurement.class,
            com.google.cloud.aiplatform.v1beta1.Measurement.Builder.class);
  }

  public interface MetricOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.Measurement.Metric)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The ID of the Metric. The Metric should be defined in
     * [StudySpec's Metrics][google.cloud.aiplatform.v1beta1.StudySpec.metrics].
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The metricId.
     */
    java.lang.String getMetricId();
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Metric. The Metric should be defined in
     * [StudySpec's Metrics][google.cloud.aiplatform.v1beta1.StudySpec.metrics].
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for metricId.
     */
    com.google.protobuf.ByteString getMetricIdBytes();

    /**
     *
     *
     * <pre>
     * Output only. The value for this metric.
     * </pre>
     *
     * <code>double value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The value.
     */
    double getValue();
  }
  /**
   *
   *
   * <pre>
   * A message representing a metric in the measurement.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Measurement.Metric}
   */
  public static final class Metric extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Measurement.Metric)
      MetricOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Metric.newBuilder() to construct.
    private Metric(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Metric() {
      metricId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Metric();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_Measurement_Metric_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_Measurement_Metric_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Measurement.Metric.class,
              com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder.class);
    }

    public static final int METRIC_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object metricId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Metric. The Metric should be defined in
     * [StudySpec's Metrics][google.cloud.aiplatform.v1beta1.StudySpec.metrics].
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The metricId.
     */
    @java.lang.Override
    public java.lang.String getMetricId() {
      java.lang.Object ref = metricId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metricId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Metric. The Metric should be defined in
     * [StudySpec's Metrics][google.cloud.aiplatform.v1beta1.StudySpec.metrics].
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for metricId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMetricIdBytes() {
      java.lang.Object ref = metricId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metricId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private double value_ = 0D;
    /**
     *
     *
     * <pre>
     * Output only. The value for this metric.
     * </pre>
     *
     * <code>double value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public double getValue() {
      return value_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, metricId_);
      }
      if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
        output.writeDouble(2, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, metricId_);
      }
      if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Measurement.Metric)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.Measurement.Metric other =
          (com.google.cloud.aiplatform.v1beta1.Measurement.Metric) obj;

      if (!getMetricId().equals(other.getMetricId())) return false;
      if (java.lang.Double.doubleToLongBits(getValue())
          != java.lang.Double.doubleToLongBits(other.getValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + METRIC_ID_FIELD_NUMBER;
      hash = (53 * hash) + getMetricId().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getValue()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.Measurement.Metric prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A message representing a metric in the measurement.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.Measurement.Metric}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Measurement.Metric)
        com.google.cloud.aiplatform.v1beta1.Measurement.MetricOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_Measurement_Metric_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_Measurement_Metric_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.Measurement.Metric.class,
                com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.Measurement.Metric.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        metricId_ = "";
        value_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_Measurement_Metric_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Measurement.Metric getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.Measurement.Metric.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Measurement.Metric build() {
        com.google.cloud.aiplatform.v1beta1.Measurement.Metric result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Measurement.Metric buildPartial() {
        com.google.cloud.aiplatform.v1beta1.Measurement.Metric result =
            new com.google.cloud.aiplatform.v1beta1.Measurement.Metric(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Measurement.Metric result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.metricId_ = metricId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.value_ = value_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.Measurement.Metric) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.Measurement.Metric) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Measurement.Metric other) {
        if (other == com.google.cloud.aiplatform.v1beta1.Measurement.Metric.getDefaultInstance())
          return this;
        if (!other.getMetricId().isEmpty()) {
          metricId_ = other.metricId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getValue() != 0D) {
          setValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  metricId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 17:
                {
                  value_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object metricId_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The ID of the Metric. The Metric should be defined in
       * [StudySpec's Metrics][google.cloud.aiplatform.v1beta1.StudySpec.metrics].
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The metricId.
       */
      public java.lang.String getMetricId() {
        java.lang.Object ref = metricId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          metricId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the Metric. The Metric should be defined in
       * [StudySpec's Metrics][google.cloud.aiplatform.v1beta1.StudySpec.metrics].
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for metricId.
       */
      public com.google.protobuf.ByteString getMetricIdBytes() {
        java.lang.Object ref = metricId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          metricId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the Metric. The Metric should be defined in
       * [StudySpec's Metrics][google.cloud.aiplatform.v1beta1.StudySpec.metrics].
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The metricId to set.
       * @return This builder for chaining.
       */
      public Builder setMetricId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the Metric. The Metric should be defined in
       * [StudySpec's Metrics][google.cloud.aiplatform.v1beta1.StudySpec.metrics].
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetricId() {
        metricId_ = getDefaultInstance().getMetricId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the Metric. The Metric should be defined in
       * [StudySpec's Metrics][google.cloud.aiplatform.v1beta1.StudySpec.metrics].
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for metricId to set.
       * @return This builder for chaining.
       */
      public Builder setMetricIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        metricId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private double value_;
      /**
       *
       *
       * <pre>
       * Output only. The value for this metric.
       * </pre>
       *
       * <code>double value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public double getValue() {
        return value_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The value for this metric.
       * </pre>
       *
       * <code>double value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(double value) {

        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The value for this metric.
       * </pre>
       *
       * <code>double value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000002);
        value_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Measurement.Metric)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Measurement.Metric)
    private static final com.google.cloud.aiplatform.v1beta1.Measurement.Metric DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Measurement.Metric();
    }

    public static com.google.cloud.aiplatform.v1beta1.Measurement.Metric getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Metric> PARSER =
        new com.google.protobuf.AbstractParser<Metric>() {
          @java.lang.Override
          public Metric parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Metric> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Metric> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Measurement.Metric getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ELAPSED_DURATION_FIELD_NUMBER = 1;
  private com.google.protobuf.Duration elapsedDuration_;
  /**
   *
   *
   * <pre>
   * Output only. Time that the Trial has been running at the point of this
   * Measurement.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the elapsedDuration field is set.
   */
  @java.lang.Override
  public boolean hasElapsedDuration() {
    return elapsedDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time that the Trial has been running at the point of this
   * Measurement.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The elapsedDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getElapsedDuration() {
    return elapsedDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : elapsedDuration_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time that the Trial has been running at the point of this
   * Measurement.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getElapsedDurationOrBuilder() {
    return elapsedDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : elapsedDuration_;
  }

  public static final int STEP_COUNT_FIELD_NUMBER = 2;
  private long stepCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The number of steps the machine learning model has been
   * trained for. Must be non-negative.
   * </pre>
   *
   * <code>int64 step_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stepCount.
   */
  @java.lang.Override
  public long getStepCount() {
    return stepCount_;
  }

  public static final int METRICS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Measurement.Metric> metrics_;
  /**
   *
   *
   * <pre>
   * Output only. A list of metrics got by evaluating the objective functions
   * using suggested Parameter values.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Measurement.Metric> getMetricsList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of metrics got by evaluating the objective functions
   * using suggested Parameter values.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.Measurement.MetricOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of metrics got by evaluating the objective functions
   * using suggested Parameter values.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of metrics got by evaluating the objective functions
   * using suggested Parameter values.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Measurement.Metric getMetrics(int index) {
    return metrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of metrics got by evaluating the objective functions
   * using suggested Parameter values.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Measurement.MetricOrBuilder getMetricsOrBuilder(
      int index) {
    return metrics_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (elapsedDuration_ != null) {
      output.writeMessage(1, getElapsedDuration());
    }
    if (stepCount_ != 0L) {
      output.writeInt64(2, stepCount_);
    }
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(3, metrics_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (elapsedDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getElapsedDuration());
    }
    if (stepCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, stepCount_);
    }
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, metrics_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Measurement)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Measurement other =
        (com.google.cloud.aiplatform.v1beta1.Measurement) obj;

    if (hasElapsedDuration() != other.hasElapsedDuration()) return false;
    if (hasElapsedDuration()) {
      if (!getElapsedDuration().equals(other.getElapsedDuration())) return false;
    }
    if (getStepCount() != other.getStepCount()) return false;
    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasElapsedDuration()) {
      hash = (37 * hash) + ELAPSED_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getElapsedDuration().hashCode();
    }
    hash = (37 * hash) + STEP_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStepCount());
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Measurement prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A message representing a Measurement of a Trial. A Measurement contains
   * the Metrics got by executing a Trial using suggested hyperparameter
   * values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Measurement}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Measurement)
      com.google.cloud.aiplatform.v1beta1.MeasurementOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_Measurement_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_Measurement_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Measurement.class,
              com.google.cloud.aiplatform.v1beta1.Measurement.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Measurement.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      elapsedDuration_ = null;
      if (elapsedDurationBuilder_ != null) {
        elapsedDurationBuilder_.dispose();
        elapsedDurationBuilder_ = null;
      }
      stepCount_ = 0L;
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
      } else {
        metrics_ = null;
        metricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_Measurement_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Measurement getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Measurement.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Measurement build() {
      com.google.cloud.aiplatform.v1beta1.Measurement result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Measurement buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Measurement result =
          new com.google.cloud.aiplatform.v1beta1.Measurement(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.Measurement result) {
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Measurement result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.elapsedDuration_ =
            elapsedDurationBuilder_ == null ? elapsedDuration_ : elapsedDurationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.stepCount_ = stepCount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Measurement) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Measurement) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Measurement other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Measurement.getDefaultInstance())
        return this;
      if (other.hasElapsedDuration()) {
        mergeElapsedDuration(other.getElapsedDuration());
      }
      if (other.getStepCount() != 0L) {
        setStepCount(other.getStepCount());
      }
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getElapsedDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                stepCount_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.Measurement.Metric m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Measurement.Metric.parser(),
                        extensionRegistry);
                if (metricsBuilder_ == null) {
                  ensureMetricsIsMutable();
                  metrics_.add(m);
                } else {
                  metricsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Duration elapsedDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        elapsedDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time that the Trial has been running at the point of this
     * Measurement.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the elapsedDuration field is set.
     */
    public boolean hasElapsedDuration() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time that the Trial has been running at the point of this
     * Measurement.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The elapsedDuration.
     */
    public com.google.protobuf.Duration getElapsedDuration() {
      if (elapsedDurationBuilder_ == null) {
        return elapsedDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : elapsedDuration_;
      } else {
        return elapsedDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time that the Trial has been running at the point of this
     * Measurement.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setElapsedDuration(com.google.protobuf.Duration value) {
      if (elapsedDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        elapsedDuration_ = value;
      } else {
        elapsedDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time that the Trial has been running at the point of this
     * Measurement.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setElapsedDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (elapsedDurationBuilder_ == null) {
        elapsedDuration_ = builderForValue.build();
      } else {
        elapsedDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time that the Trial has been running at the point of this
     * Measurement.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeElapsedDuration(com.google.protobuf.Duration value) {
      if (elapsedDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && elapsedDuration_ != null
            && elapsedDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getElapsedDurationBuilder().mergeFrom(value);
        } else {
          elapsedDuration_ = value;
        }
      } else {
        elapsedDurationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time that the Trial has been running at the point of this
     * Measurement.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearElapsedDuration() {
      bitField0_ = (bitField0_ & ~0x00000001);
      elapsedDuration_ = null;
      if (elapsedDurationBuilder_ != null) {
        elapsedDurationBuilder_.dispose();
        elapsedDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time that the Trial has been running at the point of this
     * Measurement.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getElapsedDurationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getElapsedDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time that the Trial has been running at the point of this
     * Measurement.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getElapsedDurationOrBuilder() {
      if (elapsedDurationBuilder_ != null) {
        return elapsedDurationBuilder_.getMessageOrBuilder();
      } else {
        return elapsedDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : elapsedDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time that the Trial has been running at the point of this
     * Measurement.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration elapsed_duration = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getElapsedDurationFieldBuilder() {
      if (elapsedDurationBuilder_ == null) {
        elapsedDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getElapsedDuration(), getParentForChildren(), isClean());
        elapsedDuration_ = null;
      }
      return elapsedDurationBuilder_;
    }

    private long stepCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of steps the machine learning model has been
     * trained for. Must be non-negative.
     * </pre>
     *
     * <code>int64 step_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stepCount.
     */
    @java.lang.Override
    public long getStepCount() {
      return stepCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of steps the machine learning model has been
     * trained for. Must be non-negative.
     * </pre>
     *
     * <code>int64 step_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stepCount to set.
     * @return This builder for chaining.
     */
    public Builder setStepCount(long value) {

      stepCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of steps the machine learning model has been
     * trained for. Must be non-negative.
     * </pre>
     *
     * <code>int64 step_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStepCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      stepCount_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Measurement.Metric> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        metrics_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Measurement.Metric>(
                metrics_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Measurement.Metric,
            com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder,
            com.google.cloud.aiplatform.v1beta1.Measurement.MetricOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Measurement.Metric> getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Measurement.Metric getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetrics(
        int index, com.google.cloud.aiplatform.v1beta1.Measurement.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetrics(
        int index, com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMetrics(com.google.cloud.aiplatform.v1beta1.Measurement.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMetrics(
        int index, com.google.cloud.aiplatform.v1beta1.Measurement.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMetrics(
        com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMetrics(
        int index, com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Measurement.Metric>
            values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder getMetricsBuilder(
        int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Measurement.MetricOrBuilder getMetricsOrBuilder(
        int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.Measurement.MetricOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Measurement.Metric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder addMetricsBuilder(
        int index) {
      return getMetricsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.Measurement.Metric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of metrics got by evaluating the objective functions
     * using suggested Parameter values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Measurement.Metric metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder>
        getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Measurement.Metric,
            com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder,
            com.google.cloud.aiplatform.v1beta1.Measurement.MetricOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Measurement.Metric,
                com.google.cloud.aiplatform.v1beta1.Measurement.Metric.Builder,
                com.google.cloud.aiplatform.v1beta1.Measurement.MetricOrBuilder>(
                metrics_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Measurement)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Measurement)
  private static final com.google.cloud.aiplatform.v1beta1.Measurement DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Measurement();
  }

  public static com.google.cloud.aiplatform.v1beta1.Measurement getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Measurement> PARSER =
      new com.google.protobuf.AbstractParser<Measurement>() {
        @java.lang.Override
        public Measurement parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Measurement> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Measurement> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Measurement getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
