/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The objective configuration for model monitoring, including the information
 * needed to detect anomalies for one particular model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig}
 */
public final class ModelMonitoringObjectiveConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig)
    ModelMonitoringObjectiveConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelMonitoringObjectiveConfig.newBuilder() to construct.
  private ModelMonitoringObjectiveConfig(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringObjectiveConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringObjectiveConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder.class);
  }

  public interface TrainingDatasetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The resource name of the Dataset used to train this Model.
     * </pre>
     *
     * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the dataset field is set.
     */
    boolean hasDataset();
    /**
     *
     *
     * <pre>
     * The resource name of the Dataset used to train this Model.
     * </pre>
     *
     * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataset.
     */
    java.lang.String getDataset();
    /**
     *
     *
     * <pre>
     * The resource name of the Dataset used to train this Model.
     * </pre>
     *
     * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataset.
     */
    com.google.protobuf.ByteString getDatasetBytes();

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage uri of the unmanaged Dataset used to train
     * this Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    boolean hasGcsSource();
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage uri of the unmanaged Dataset used to train
     * this Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
     *
     * @return The gcsSource.
     */
    com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource();
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage uri of the unmanaged Dataset used to train
     * this Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
     */
    com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * The BigQuery table of the unmanaged Dataset used to train this
     * Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    boolean hasBigquerySource();
    /**
     *
     *
     * <pre>
     * The BigQuery table of the unmanaged Dataset used to train this
     * Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
     *
     * @return The bigquerySource.
     */
    com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigquerySource();
    /**
     *
     *
     * <pre>
     * The BigQuery table of the unmanaged Dataset used to train this
     * Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
     */
    com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder getBigquerySourceOrBuilder();

    /**
     *
     *
     * <pre>
     * Data format of the dataset, only applicable if the input is from
     * Google Cloud Storage.
     * The possible formats are:
     *
     * "tf-record"
     * The source file is a TFRecord file.
     *
     * "csv"
     * The source file is a CSV file.
     * "jsonl"
     * The source file is a JSONL file.
     * </pre>
     *
     * <code>string data_format = 2;</code>
     *
     * @return The dataFormat.
     */
    java.lang.String getDataFormat();
    /**
     *
     *
     * <pre>
     * Data format of the dataset, only applicable if the input is from
     * Google Cloud Storage.
     * The possible formats are:
     *
     * "tf-record"
     * The source file is a TFRecord file.
     *
     * "csv"
     * The source file is a CSV file.
     * "jsonl"
     * The source file is a JSONL file.
     * </pre>
     *
     * <code>string data_format = 2;</code>
     *
     * @return The bytes for dataFormat.
     */
    com.google.protobuf.ByteString getDataFormatBytes();

    /**
     *
     *
     * <pre>
     * The target field name the model is to predict.
     * This field will be excluded when doing Predict and (or) Explain for the
     * training data.
     * </pre>
     *
     * <code>string target_field = 6;</code>
     *
     * @return The targetField.
     */
    java.lang.String getTargetField();
    /**
     *
     *
     * <pre>
     * The target field name the model is to predict.
     * This field will be excluded when doing Predict and (or) Explain for the
     * training data.
     * </pre>
     *
     * <code>string target_field = 6;</code>
     *
     * @return The bytes for targetField.
     */
    com.google.protobuf.ByteString getTargetFieldBytes();

    /**
     *
     *
     * <pre>
     * Strategy to sample data from Training Dataset.
     * If not set, we process the whole dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;</code>
     *
     * @return Whether the loggingSamplingStrategy field is set.
     */
    boolean hasLoggingSamplingStrategy();
    /**
     *
     *
     * <pre>
     * Strategy to sample data from Training Dataset.
     * If not set, we process the whole dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;</code>
     *
     * @return The loggingSamplingStrategy.
     */
    com.google.cloud.aiplatform.v1beta1.SamplingStrategy getLoggingSamplingStrategy();
    /**
     *
     *
     * <pre>
     * Strategy to sample data from Training Dataset.
     * If not set, we process the whole dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;</code>
     */
    com.google.cloud.aiplatform.v1beta1.SamplingStrategyOrBuilder
        getLoggingSamplingStrategyOrBuilder();

    com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
            .DataSourceCase
        getDataSourceCase();
  }
  /**
   *
   *
   * <pre>
   * Training Dataset information.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset}
   */
  public static final class TrainingDataset extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset)
      TrainingDatasetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TrainingDataset.newBuilder() to construct.
    private TrainingDataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TrainingDataset() {
      dataFormat_ = "";
      targetField_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TrainingDataset();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingDataset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingDataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
                  .class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
                  .Builder.class);
    }

    private int dataSourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object dataSource_;

    public enum DataSourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      DATASET(3),
      GCS_SOURCE(4),
      BIGQUERY_SOURCE(5),
      DATASOURCE_NOT_SET(0);
      private final int value;

      private DataSourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DataSourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static DataSourceCase forNumber(int value) {
        switch (value) {
          case 3:
            return DATASET;
          case 4:
            return GCS_SOURCE;
          case 5:
            return BIGQUERY_SOURCE;
          case 0:
            return DATASOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DataSourceCase getDataSourceCase() {
      return DataSourceCase.forNumber(dataSourceCase_);
    }

    public static final int DATASET_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * The resource name of the Dataset used to train this Model.
     * </pre>
     *
     * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the dataset field is set.
     */
    public boolean hasDataset() {
      return dataSourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Dataset used to train this Model.
     * </pre>
     *
     * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataset.
     */
    public java.lang.String getDataset() {
      java.lang.Object ref = "";
      if (dataSourceCase_ == 3) {
        ref = dataSource_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (dataSourceCase_ == 3) {
          dataSource_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Dataset used to train this Model.
     * </pre>
     *
     * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataset.
     */
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = "";
      if (dataSourceCase_ == 3) {
        ref = dataSource_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (dataSourceCase_ == 3) {
          dataSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GCS_SOURCE_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage uri of the unmanaged Dataset used to train
     * this Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return dataSourceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage uri of the unmanaged Dataset used to train
     * this Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
      if (dataSourceCase_ == 4) {
        return (com.google.cloud.aiplatform.v1beta1.GcsSource) dataSource_;
      }
      return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage uri of the unmanaged Dataset used to train
     * this Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if (dataSourceCase_ == 4) {
        return (com.google.cloud.aiplatform.v1beta1.GcsSource) dataSource_;
      }
      return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
    }

    public static final int BIGQUERY_SOURCE_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * The BigQuery table of the unmanaged Dataset used to train this
     * Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigquerySource() {
      return dataSourceCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery table of the unmanaged Dataset used to train this
     * Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
     *
     * @return The bigquerySource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigquerySource() {
      if (dataSourceCase_ == 5) {
        return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) dataSource_;
      }
      return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The BigQuery table of the unmanaged Dataset used to train this
     * Model.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder
        getBigquerySourceOrBuilder() {
      if (dataSourceCase_ == 5) {
        return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) dataSource_;
      }
      return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
    }

    public static final int DATA_FORMAT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataFormat_ = "";
    /**
     *
     *
     * <pre>
     * Data format of the dataset, only applicable if the input is from
     * Google Cloud Storage.
     * The possible formats are:
     *
     * "tf-record"
     * The source file is a TFRecord file.
     *
     * "csv"
     * The source file is a CSV file.
     * "jsonl"
     * The source file is a JSONL file.
     * </pre>
     *
     * <code>string data_format = 2;</code>
     *
     * @return The dataFormat.
     */
    @java.lang.Override
    public java.lang.String getDataFormat() {
      java.lang.Object ref = dataFormat_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataFormat_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Data format of the dataset, only applicable if the input is from
     * Google Cloud Storage.
     * The possible formats are:
     *
     * "tf-record"
     * The source file is a TFRecord file.
     *
     * "csv"
     * The source file is a CSV file.
     * "jsonl"
     * The source file is a JSONL file.
     * </pre>
     *
     * <code>string data_format = 2;</code>
     *
     * @return The bytes for dataFormat.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataFormatBytes() {
      java.lang.Object ref = dataFormat_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TARGET_FIELD_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object targetField_ = "";
    /**
     *
     *
     * <pre>
     * The target field name the model is to predict.
     * This field will be excluded when doing Predict and (or) Explain for the
     * training data.
     * </pre>
     *
     * <code>string target_field = 6;</code>
     *
     * @return The targetField.
     */
    @java.lang.Override
    public java.lang.String getTargetField() {
      java.lang.Object ref = targetField_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetField_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The target field name the model is to predict.
     * This field will be excluded when doing Predict and (or) Explain for the
     * training data.
     * </pre>
     *
     * <code>string target_field = 6;</code>
     *
     * @return The bytes for targetField.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetFieldBytes() {
      java.lang.Object ref = targetField_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetField_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOGGING_SAMPLING_STRATEGY_FIELD_NUMBER = 7;
    private com.google.cloud.aiplatform.v1beta1.SamplingStrategy loggingSamplingStrategy_;
    /**
     *
     *
     * <pre>
     * Strategy to sample data from Training Dataset.
     * If not set, we process the whole dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;</code>
     *
     * @return Whether the loggingSamplingStrategy field is set.
     */
    @java.lang.Override
    public boolean hasLoggingSamplingStrategy() {
      return loggingSamplingStrategy_ != null;
    }
    /**
     *
     *
     * <pre>
     * Strategy to sample data from Training Dataset.
     * If not set, we process the whole dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;</code>
     *
     * @return The loggingSamplingStrategy.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SamplingStrategy getLoggingSamplingStrategy() {
      return loggingSamplingStrategy_ == null
          ? com.google.cloud.aiplatform.v1beta1.SamplingStrategy.getDefaultInstance()
          : loggingSamplingStrategy_;
    }
    /**
     *
     *
     * <pre>
     * Strategy to sample data from Training Dataset.
     * If not set, we process the whole dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SamplingStrategyOrBuilder
        getLoggingSamplingStrategyOrBuilder() {
      return loggingSamplingStrategy_ == null
          ? com.google.cloud.aiplatform.v1beta1.SamplingStrategy.getDefaultInstance()
          : loggingSamplingStrategy_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataFormat_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dataFormat_);
      }
      if (dataSourceCase_ == 3) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, dataSource_);
      }
      if (dataSourceCase_ == 4) {
        output.writeMessage(4, (com.google.cloud.aiplatform.v1beta1.GcsSource) dataSource_);
      }
      if (dataSourceCase_ == 5) {
        output.writeMessage(5, (com.google.cloud.aiplatform.v1beta1.BigQuerySource) dataSource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetField_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, targetField_);
      }
      if (loggingSamplingStrategy_ != null) {
        output.writeMessage(7, getLoggingSamplingStrategy());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataFormat_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dataFormat_);
      }
      if (dataSourceCase_ == 3) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, dataSource_);
      }
      if (dataSourceCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, (com.google.cloud.aiplatform.v1beta1.GcsSource) dataSource_);
      }
      if (dataSourceCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, (com.google.cloud.aiplatform.v1beta1.BigQuerySource) dataSource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetField_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, targetField_);
      }
      if (loggingSamplingStrategy_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7, getLoggingSamplingStrategy());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset) obj;

      if (!getDataFormat().equals(other.getDataFormat())) return false;
      if (!getTargetField().equals(other.getTargetField())) return false;
      if (hasLoggingSamplingStrategy() != other.hasLoggingSamplingStrategy()) return false;
      if (hasLoggingSamplingStrategy()) {
        if (!getLoggingSamplingStrategy().equals(other.getLoggingSamplingStrategy())) return false;
      }
      if (!getDataSourceCase().equals(other.getDataSourceCase())) return false;
      switch (dataSourceCase_) {
        case 3:
          if (!getDataset().equals(other.getDataset())) return false;
          break;
        case 4:
          if (!getGcsSource().equals(other.getGcsSource())) return false;
          break;
        case 5:
          if (!getBigquerySource().equals(other.getBigquerySource())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATA_FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + getDataFormat().hashCode();
      hash = (37 * hash) + TARGET_FIELD_FIELD_NUMBER;
      hash = (53 * hash) + getTargetField().hashCode();
      if (hasLoggingSamplingStrategy()) {
        hash = (37 * hash) + LOGGING_SAMPLING_STRATEGY_FIELD_NUMBER;
        hash = (53 * hash) + getLoggingSamplingStrategy().hashCode();
      }
      switch (dataSourceCase_) {
        case 3:
          hash = (37 * hash) + DATASET_FIELD_NUMBER;
          hash = (53 * hash) + getDataset().hashCode();
          break;
        case 4:
          hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getGcsSource().hashCode();
          break;
        case 5:
          hash = (37 * hash) + BIGQUERY_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getBigquerySource().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Training Dataset information.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingDatasetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingDataset_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingDataset_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
                    .class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (gcsSourceBuilder_ != null) {
          gcsSourceBuilder_.clear();
        }
        if (bigquerySourceBuilder_ != null) {
          bigquerySourceBuilder_.clear();
        }
        dataFormat_ = "";
        targetField_ = "";
        loggingSamplingStrategy_ = null;
        if (loggingSamplingStrategyBuilder_ != null) {
          loggingSamplingStrategyBuilder_.dispose();
          loggingSamplingStrategyBuilder_ = null;
        }
        dataSourceCase_ = 0;
        dataSource_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingDataset_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset result =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.dataFormat_ = dataFormat_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.targetField_ = targetField_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.loggingSamplingStrategy_ =
              loggingSamplingStrategyBuilder_ == null
                  ? loggingSamplingStrategy_
                  : loggingSamplingStrategyBuilder_.build();
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
              result) {
        result.dataSourceCase_ = dataSourceCase_;
        result.dataSource_ = this.dataSource_;
        if (dataSourceCase_ == 4 && gcsSourceBuilder_ != null) {
          result.dataSource_ = gcsSourceBuilder_.build();
        }
        if (dataSourceCase_ == 5 && bigquerySourceBuilder_ != null) {
          result.dataSource_ = bigquerySourceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
                .getDefaultInstance()) return this;
        if (!other.getDataFormat().isEmpty()) {
          dataFormat_ = other.dataFormat_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getTargetField().isEmpty()) {
          targetField_ = other.targetField_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.hasLoggingSamplingStrategy()) {
          mergeLoggingSamplingStrategy(other.getLoggingSamplingStrategy());
        }
        switch (other.getDataSourceCase()) {
          case DATASET:
            {
              dataSourceCase_ = 3;
              dataSource_ = other.dataSource_;
              onChanged();
              break;
            }
          case GCS_SOURCE:
            {
              mergeGcsSource(other.getGcsSource());
              break;
            }
          case BIGQUERY_SOURCE:
            {
              mergeBigquerySource(other.getBigquerySource());
              break;
            }
          case DATASOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  dataFormat_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  dataSourceCase_ = 3;
                  dataSource_ = s;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                  dataSourceCase_ = 4;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getBigquerySourceFieldBuilder().getBuilder(), extensionRegistry);
                  dataSourceCase_ = 5;
                  break;
                } // case 42
              case 50:
                {
                  targetField_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getLoggingSamplingStrategyFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int dataSourceCase_ = 0;
      private java.lang.Object dataSource_;

      public DataSourceCase getDataSourceCase() {
        return DataSourceCase.forNumber(dataSourceCase_);
      }

      public Builder clearDataSource() {
        dataSourceCase_ = 0;
        dataSource_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The resource name of the Dataset used to train this Model.
       * </pre>
       *
       * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return Whether the dataset field is set.
       */
      @java.lang.Override
      public boolean hasDataset() {
        return dataSourceCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Dataset used to train this Model.
       * </pre>
       *
       * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The dataset.
       */
      @java.lang.Override
      public java.lang.String getDataset() {
        java.lang.Object ref = "";
        if (dataSourceCase_ == 3) {
          ref = dataSource_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (dataSourceCase_ == 3) {
            dataSource_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Dataset used to train this Model.
       * </pre>
       *
       * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for dataset.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDatasetBytes() {
        java.lang.Object ref = "";
        if (dataSourceCase_ == 3) {
          ref = dataSource_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (dataSourceCase_ == 3) {
            dataSource_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Dataset used to train this Model.
       * </pre>
       *
       * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataSourceCase_ = 3;
        dataSource_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Dataset used to train this Model.
       * </pre>
       *
       * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataset() {
        if (dataSourceCase_ == 3) {
          dataSourceCase_ = 0;
          dataSource_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Dataset used to train this Model.
       * </pre>
       *
       * <code>string dataset = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataSourceCase_ = 3;
        dataSource_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsSource,
              com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
          gcsSourceBuilder_;
      /**
       *
       *
       * <pre>
       * The Google Cloud Storage uri of the unmanaged Dataset used to train
       * this Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
       *
       * @return Whether the gcsSource field is set.
       */
      @java.lang.Override
      public boolean hasGcsSource() {
        return dataSourceCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * The Google Cloud Storage uri of the unmanaged Dataset used to train
       * this Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
       *
       * @return The gcsSource.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (dataSourceCase_ == 4) {
            return (com.google.cloud.aiplatform.v1beta1.GcsSource) dataSource_;
          }
          return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        } else {
          if (dataSourceCase_ == 4) {
            return gcsSourceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The Google Cloud Storage uri of the unmanaged Dataset used to train
       * this Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
       */
      public Builder setGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
        if (gcsSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataSource_ = value;
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
        dataSourceCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Google Cloud Storage uri of the unmanaged Dataset used to train
       * this Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
       */
      public Builder setGcsSource(
          com.google.cloud.aiplatform.v1beta1.GcsSource.Builder builderForValue) {
        if (gcsSourceBuilder_ == null) {
          dataSource_ = builderForValue.build();
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(builderForValue.build());
        }
        dataSourceCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Google Cloud Storage uri of the unmanaged Dataset used to train
       * this Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
       */
      public Builder mergeGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
        if (gcsSourceBuilder_ == null) {
          if (dataSourceCase_ == 4
              && dataSource_
                  != com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance()) {
            dataSource_ =
                com.google.cloud.aiplatform.v1beta1.GcsSource.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.GcsSource) dataSource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataSource_ = value;
          }
          onChanged();
        } else {
          if (dataSourceCase_ == 4) {
            gcsSourceBuilder_.mergeFrom(value);
          } else {
            gcsSourceBuilder_.setMessage(value);
          }
        }
        dataSourceCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Google Cloud Storage uri of the unmanaged Dataset used to train
       * this Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
       */
      public Builder clearGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (dataSourceCase_ == 4) {
            dataSourceCase_ = 0;
            dataSource_ = null;
            onChanged();
          }
        } else {
          if (dataSourceCase_ == 4) {
            dataSourceCase_ = 0;
            dataSource_ = null;
          }
          gcsSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Google Cloud Storage uri of the unmanaged Dataset used to train
       * this Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.GcsSource.Builder getGcsSourceBuilder() {
        return getGcsSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The Google Cloud Storage uri of the unmanaged Dataset used to train
       * this Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
        if ((dataSourceCase_ == 4) && (gcsSourceBuilder_ != null)) {
          return gcsSourceBuilder_.getMessageOrBuilder();
        } else {
          if (dataSourceCase_ == 4) {
            return (com.google.cloud.aiplatform.v1beta1.GcsSource) dataSource_;
          }
          return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The Google Cloud Storage uri of the unmanaged Dataset used to train
       * this Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsSource,
              com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
          getGcsSourceFieldBuilder() {
        if (gcsSourceBuilder_ == null) {
          if (!(dataSourceCase_ == 4)) {
            dataSource_ = com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
          }
          gcsSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.GcsSource,
                  com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
                  com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.GcsSource) dataSource_,
                  getParentForChildren(),
                  isClean());
          dataSource_ = null;
        }
        dataSourceCase_ = 4;
        onChanged();
        return gcsSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQuerySource,
              com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>
          bigquerySourceBuilder_;
      /**
       *
       *
       * <pre>
       * The BigQuery table of the unmanaged Dataset used to train this
       * Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
       *
       * @return Whether the bigquerySource field is set.
       */
      @java.lang.Override
      public boolean hasBigquerySource() {
        return dataSourceCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table of the unmanaged Dataset used to train this
       * Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
       *
       * @return The bigquerySource.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigquerySource() {
        if (bigquerySourceBuilder_ == null) {
          if (dataSourceCase_ == 5) {
            return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) dataSource_;
          }
          return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
        } else {
          if (dataSourceCase_ == 5) {
            return bigquerySourceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table of the unmanaged Dataset used to train this
       * Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
       */
      public Builder setBigquerySource(com.google.cloud.aiplatform.v1beta1.BigQuerySource value) {
        if (bigquerySourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataSource_ = value;
          onChanged();
        } else {
          bigquerySourceBuilder_.setMessage(value);
        }
        dataSourceCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table of the unmanaged Dataset used to train this
       * Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
       */
      public Builder setBigquerySource(
          com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder builderForValue) {
        if (bigquerySourceBuilder_ == null) {
          dataSource_ = builderForValue.build();
          onChanged();
        } else {
          bigquerySourceBuilder_.setMessage(builderForValue.build());
        }
        dataSourceCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table of the unmanaged Dataset used to train this
       * Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
       */
      public Builder mergeBigquerySource(com.google.cloud.aiplatform.v1beta1.BigQuerySource value) {
        if (bigquerySourceBuilder_ == null) {
          if (dataSourceCase_ == 5
              && dataSource_
                  != com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance()) {
            dataSource_ =
                com.google.cloud.aiplatform.v1beta1.BigQuerySource.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.BigQuerySource) dataSource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataSource_ = value;
          }
          onChanged();
        } else {
          if (dataSourceCase_ == 5) {
            bigquerySourceBuilder_.mergeFrom(value);
          } else {
            bigquerySourceBuilder_.setMessage(value);
          }
        }
        dataSourceCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table of the unmanaged Dataset used to train this
       * Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
       */
      public Builder clearBigquerySource() {
        if (bigquerySourceBuilder_ == null) {
          if (dataSourceCase_ == 5) {
            dataSourceCase_ = 0;
            dataSource_ = null;
            onChanged();
          }
        } else {
          if (dataSourceCase_ == 5) {
            dataSourceCase_ = 0;
            dataSource_ = null;
          }
          bigquerySourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table of the unmanaged Dataset used to train this
       * Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder getBigquerySourceBuilder() {
        return getBigquerySourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table of the unmanaged Dataset used to train this
       * Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder
          getBigquerySourceOrBuilder() {
        if ((dataSourceCase_ == 5) && (bigquerySourceBuilder_ != null)) {
          return bigquerySourceBuilder_.getMessageOrBuilder();
        } else {
          if (dataSourceCase_ == 5) {
            return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) dataSource_;
          }
          return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table of the unmanaged Dataset used to train this
       * Model.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQuerySource,
              com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>
          getBigquerySourceFieldBuilder() {
        if (bigquerySourceBuilder_ == null) {
          if (!(dataSourceCase_ == 5)) {
            dataSource_ = com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
          }
          bigquerySourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.BigQuerySource,
                  com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
                  com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.BigQuerySource) dataSource_,
                  getParentForChildren(),
                  isClean());
          dataSource_ = null;
        }
        dataSourceCase_ = 5;
        onChanged();
        return bigquerySourceBuilder_;
      }

      private java.lang.Object dataFormat_ = "";
      /**
       *
       *
       * <pre>
       * Data format of the dataset, only applicable if the input is from
       * Google Cloud Storage.
       * The possible formats are:
       *
       * "tf-record"
       * The source file is a TFRecord file.
       *
       * "csv"
       * The source file is a CSV file.
       * "jsonl"
       * The source file is a JSONL file.
       * </pre>
       *
       * <code>string data_format = 2;</code>
       *
       * @return The dataFormat.
       */
      public java.lang.String getDataFormat() {
        java.lang.Object ref = dataFormat_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataFormat_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Data format of the dataset, only applicable if the input is from
       * Google Cloud Storage.
       * The possible formats are:
       *
       * "tf-record"
       * The source file is a TFRecord file.
       *
       * "csv"
       * The source file is a CSV file.
       * "jsonl"
       * The source file is a JSONL file.
       * </pre>
       *
       * <code>string data_format = 2;</code>
       *
       * @return The bytes for dataFormat.
       */
      public com.google.protobuf.ByteString getDataFormatBytes() {
        java.lang.Object ref = dataFormat_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataFormat_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Data format of the dataset, only applicable if the input is from
       * Google Cloud Storage.
       * The possible formats are:
       *
       * "tf-record"
       * The source file is a TFRecord file.
       *
       * "csv"
       * The source file is a CSV file.
       * "jsonl"
       * The source file is a JSONL file.
       * </pre>
       *
       * <code>string data_format = 2;</code>
       *
       * @param value The dataFormat to set.
       * @return This builder for chaining.
       */
      public Builder setDataFormat(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataFormat_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data format of the dataset, only applicable if the input is from
       * Google Cloud Storage.
       * The possible formats are:
       *
       * "tf-record"
       * The source file is a TFRecord file.
       *
       * "csv"
       * The source file is a CSV file.
       * "jsonl"
       * The source file is a JSONL file.
       * </pre>
       *
       * <code>string data_format = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataFormat() {
        dataFormat_ = getDefaultInstance().getDataFormat();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data format of the dataset, only applicable if the input is from
       * Google Cloud Storage.
       * The possible formats are:
       *
       * "tf-record"
       * The source file is a TFRecord file.
       *
       * "csv"
       * The source file is a CSV file.
       * "jsonl"
       * The source file is a JSONL file.
       * </pre>
       *
       * <code>string data_format = 2;</code>
       *
       * @param value The bytes for dataFormat to set.
       * @return This builder for chaining.
       */
      public Builder setDataFormatBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataFormat_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object targetField_ = "";
      /**
       *
       *
       * <pre>
       * The target field name the model is to predict.
       * This field will be excluded when doing Predict and (or) Explain for the
       * training data.
       * </pre>
       *
       * <code>string target_field = 6;</code>
       *
       * @return The targetField.
       */
      public java.lang.String getTargetField() {
        java.lang.Object ref = targetField_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          targetField_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The target field name the model is to predict.
       * This field will be excluded when doing Predict and (or) Explain for the
       * training data.
       * </pre>
       *
       * <code>string target_field = 6;</code>
       *
       * @return The bytes for targetField.
       */
      public com.google.protobuf.ByteString getTargetFieldBytes() {
        java.lang.Object ref = targetField_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          targetField_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The target field name the model is to predict.
       * This field will be excluded when doing Predict and (or) Explain for the
       * training data.
       * </pre>
       *
       * <code>string target_field = 6;</code>
       *
       * @param value The targetField to set.
       * @return This builder for chaining.
       */
      public Builder setTargetField(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetField_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The target field name the model is to predict.
       * This field will be excluded when doing Predict and (or) Explain for the
       * training data.
       * </pre>
       *
       * <code>string target_field = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTargetField() {
        targetField_ = getDefaultInstance().getTargetField();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The target field name the model is to predict.
       * This field will be excluded when doing Predict and (or) Explain for the
       * training data.
       * </pre>
       *
       * <code>string target_field = 6;</code>
       *
       * @param value The bytes for targetField to set.
       * @return This builder for chaining.
       */
      public Builder setTargetFieldBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        targetField_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.SamplingStrategy loggingSamplingStrategy_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.SamplingStrategy,
              com.google.cloud.aiplatform.v1beta1.SamplingStrategy.Builder,
              com.google.cloud.aiplatform.v1beta1.SamplingStrategyOrBuilder>
          loggingSamplingStrategyBuilder_;
      /**
       *
       *
       * <pre>
       * Strategy to sample data from Training Dataset.
       * If not set, we process the whole dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;
       * </code>
       *
       * @return Whether the loggingSamplingStrategy field is set.
       */
      public boolean hasLoggingSamplingStrategy() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Strategy to sample data from Training Dataset.
       * If not set, we process the whole dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;
       * </code>
       *
       * @return The loggingSamplingStrategy.
       */
      public com.google.cloud.aiplatform.v1beta1.SamplingStrategy getLoggingSamplingStrategy() {
        if (loggingSamplingStrategyBuilder_ == null) {
          return loggingSamplingStrategy_ == null
              ? com.google.cloud.aiplatform.v1beta1.SamplingStrategy.getDefaultInstance()
              : loggingSamplingStrategy_;
        } else {
          return loggingSamplingStrategyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Strategy to sample data from Training Dataset.
       * If not set, we process the whole dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;
       * </code>
       */
      public Builder setLoggingSamplingStrategy(
          com.google.cloud.aiplatform.v1beta1.SamplingStrategy value) {
        if (loggingSamplingStrategyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          loggingSamplingStrategy_ = value;
        } else {
          loggingSamplingStrategyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Strategy to sample data from Training Dataset.
       * If not set, we process the whole dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;
       * </code>
       */
      public Builder setLoggingSamplingStrategy(
          com.google.cloud.aiplatform.v1beta1.SamplingStrategy.Builder builderForValue) {
        if (loggingSamplingStrategyBuilder_ == null) {
          loggingSamplingStrategy_ = builderForValue.build();
        } else {
          loggingSamplingStrategyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Strategy to sample data from Training Dataset.
       * If not set, we process the whole dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;
       * </code>
       */
      public Builder mergeLoggingSamplingStrategy(
          com.google.cloud.aiplatform.v1beta1.SamplingStrategy value) {
        if (loggingSamplingStrategyBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && loggingSamplingStrategy_ != null
              && loggingSamplingStrategy_
                  != com.google.cloud.aiplatform.v1beta1.SamplingStrategy.getDefaultInstance()) {
            getLoggingSamplingStrategyBuilder().mergeFrom(value);
          } else {
            loggingSamplingStrategy_ = value;
          }
        } else {
          loggingSamplingStrategyBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Strategy to sample data from Training Dataset.
       * If not set, we process the whole dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;
       * </code>
       */
      public Builder clearLoggingSamplingStrategy() {
        bitField0_ = (bitField0_ & ~0x00000020);
        loggingSamplingStrategy_ = null;
        if (loggingSamplingStrategyBuilder_ != null) {
          loggingSamplingStrategyBuilder_.dispose();
          loggingSamplingStrategyBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Strategy to sample data from Training Dataset.
       * If not set, we process the whole dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SamplingStrategy.Builder
          getLoggingSamplingStrategyBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getLoggingSamplingStrategyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Strategy to sample data from Training Dataset.
       * If not set, we process the whole dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SamplingStrategyOrBuilder
          getLoggingSamplingStrategyOrBuilder() {
        if (loggingSamplingStrategyBuilder_ != null) {
          return loggingSamplingStrategyBuilder_.getMessageOrBuilder();
        } else {
          return loggingSamplingStrategy_ == null
              ? com.google.cloud.aiplatform.v1beta1.SamplingStrategy.getDefaultInstance()
              : loggingSamplingStrategy_;
        }
      }
      /**
       *
       *
       * <pre>
       * Strategy to sample data from Training Dataset.
       * If not set, we process the whole dataset.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 7;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.SamplingStrategy,
              com.google.cloud.aiplatform.v1beta1.SamplingStrategy.Builder,
              com.google.cloud.aiplatform.v1beta1.SamplingStrategyOrBuilder>
          getLoggingSamplingStrategyFieldBuilder() {
        if (loggingSamplingStrategyBuilder_ == null) {
          loggingSamplingStrategyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.SamplingStrategy,
                  com.google.cloud.aiplatform.v1beta1.SamplingStrategy.Builder,
                  com.google.cloud.aiplatform.v1beta1.SamplingStrategyOrBuilder>(
                  getLoggingSamplingStrategy(), getParentForChildren(), isClean());
          loggingSamplingStrategy_ = null;
        }
        return loggingSamplingStrategyBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingDataset
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TrainingDataset> PARSER =
        new com.google.protobuf.AbstractParser<TrainingDataset>() {
          @java.lang.Override
          public TrainingDataset parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TrainingDataset> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TrainingDataset> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TrainingPredictionSkewDetectionConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for skew, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between the training and prediction feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
     * </code>
     */
    int getSkewThresholdsCount();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for skew, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between the training and prediction feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
     * </code>
     */
    boolean containsSkewThresholds(java.lang.String key);
    /** Use {@link #getSkewThresholdsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getSkewThresholds();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for skew, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between the training and prediction feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
     * </code>
     */
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getSkewThresholdsMap();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for skew, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between the training and prediction feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
     * </code>
     */
    /* nullable */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfig getSkewThresholdsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue);
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for skew, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between the training and prediction feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfig getSkewThresholdsOrThrow(
        java.lang.String key);

    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between the training and prediction
     * feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
     * </code>
     */
    int getAttributionScoreSkewThresholdsCount();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between the training and prediction
     * feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
     * </code>
     */
    boolean containsAttributionScoreSkewThresholds(java.lang.String key);
    /** Use {@link #getAttributionScoreSkewThresholdsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getAttributionScoreSkewThresholds();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between the training and prediction
     * feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
     * </code>
     */
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getAttributionScoreSkewThresholdsMap();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between the training and prediction
     * feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
     * </code>
     */
    /* nullable */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfig getAttributionScoreSkewThresholdsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue);
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between the training and prediction
     * feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfig getAttributionScoreSkewThresholdsOrThrow(
        java.lang.String key);

    /**
     *
     *
     * <pre>
     * Skew anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
     *
     * @return Whether the defaultSkewThreshold field is set.
     */
    boolean hasDefaultSkewThreshold();
    /**
     *
     *
     * <pre>
     * Skew anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
     *
     * @return The defaultSkewThreshold.
     */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfig getDefaultSkewThreshold();
    /**
     *
     *
     * <pre>
     * Skew anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
     */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder getDefaultSkewThresholdOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The config for Training &amp; Prediction data skew detection. It specifies the
   * training dataset sources and the skew detection parameters.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig}
   */
  public static final class TrainingPredictionSkewDetectionConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig)
      TrainingPredictionSkewDetectionConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TrainingPredictionSkewDetectionConfig.newBuilder() to construct.
    private TrainingPredictionSkewDetectionConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TrainingPredictionSkewDetectionConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TrainingPredictionSkewDetectionConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetSkewThresholds();
        case 2:
          return internalGetAttributionScoreSkewThresholds();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                  .TrainingPredictionSkewDetectionConfig.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                  .TrainingPredictionSkewDetectionConfig.Builder.class);
    }

    public static final int SKEW_THRESHOLDS_FIELD_NUMBER = 1;

    private static final class SkewThresholdsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
                      newDefaultInstance(
                          com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
                              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig_SkewThresholdsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        skewThresholds_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        internalGetSkewThresholds() {
      if (skewThresholds_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SkewThresholdsDefaultEntryHolder.defaultEntry);
      }
      return skewThresholds_;
    }

    public int getSkewThresholdsCount() {
      return internalGetSkewThresholds().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for skew, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between the training and prediction feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
     * </code>
     */
    @java.lang.Override
    public boolean containsSkewThresholds(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSkewThresholds().getMap().containsKey(key);
    }
    /** Use {@link #getSkewThresholdsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getSkewThresholds() {
      return getSkewThresholdsMap();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for skew, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between the training and prediction feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getSkewThresholdsMap() {
      return internalGetSkewThresholds().getMap();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for skew, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between the training and prediction feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.ThresholdConfig
        getSkewThresholdsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
          internalGetSkewThresholds().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for skew, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between the training and prediction feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ThresholdConfig getSkewThresholdsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
          internalGetSkewThresholds().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int ATTRIBUTION_SCORE_SKEW_THRESHOLDS_FIELD_NUMBER = 2;

    private static final class AttributionScoreSkewThresholdsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
                      newDefaultInstance(
                          com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
                              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig_AttributionScoreSkewThresholdsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        attributionScoreSkewThresholds_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        internalGetAttributionScoreSkewThresholds() {
      if (attributionScoreSkewThresholds_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AttributionScoreSkewThresholdsDefaultEntryHolder.defaultEntry);
      }
      return attributionScoreSkewThresholds_;
    }

    public int getAttributionScoreSkewThresholdsCount() {
      return internalGetAttributionScoreSkewThresholds().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between the training and prediction
     * feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
     * </code>
     */
    @java.lang.Override
    public boolean containsAttributionScoreSkewThresholds(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttributionScoreSkewThresholds().getMap().containsKey(key);
    }
    /** Use {@link #getAttributionScoreSkewThresholdsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getAttributionScoreSkewThresholds() {
      return getAttributionScoreSkewThresholdsMap();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between the training and prediction
     * feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getAttributionScoreSkewThresholdsMap() {
      return internalGetAttributionScoreSkewThresholds().getMap();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between the training and prediction
     * feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.ThresholdConfig
        getAttributionScoreSkewThresholdsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
          internalGetAttributionScoreSkewThresholds().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between the training and prediction
     * feature.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ThresholdConfig
        getAttributionScoreSkewThresholdsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
          internalGetAttributionScoreSkewThresholds().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int DEFAULT_SKEW_THRESHOLD_FIELD_NUMBER = 6;
    private com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultSkewThreshold_;
    /**
     *
     *
     * <pre>
     * Skew anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
     *
     * @return Whether the defaultSkewThreshold field is set.
     */
    @java.lang.Override
    public boolean hasDefaultSkewThreshold() {
      return defaultSkewThreshold_ != null;
    }
    /**
     *
     *
     * <pre>
     * Skew anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
     *
     * @return The defaultSkewThreshold.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ThresholdConfig getDefaultSkewThreshold() {
      return defaultSkewThreshold_ == null
          ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
          : defaultSkewThreshold_;
    }
    /**
     *
     *
     * <pre>
     * Skew anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder
        getDefaultSkewThresholdOrBuilder() {
      return defaultSkewThreshold_ == null
          ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
          : defaultSkewThreshold_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetSkewThresholds(), SkewThresholdsDefaultEntryHolder.defaultEntry, 1);
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetAttributionScoreSkewThresholds(),
          AttributionScoreSkewThresholdsDefaultEntryHolder.defaultEntry,
          2);
      if (defaultSkewThreshold_ != null) {
        output.writeMessage(6, getDefaultSkewThreshold());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          entry : internalGetSkewThresholds().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
            skewThresholds__ =
                SkewThresholdsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, skewThresholds__);
      }
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          entry : internalGetAttributionScoreSkewThresholds().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
            attributionScoreSkewThresholds__ =
                AttributionScoreSkewThresholdsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, attributionScoreSkewThresholds__);
      }
      if (defaultSkewThreshold_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDefaultSkewThreshold());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .TrainingPredictionSkewDetectionConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .TrainingPredictionSkewDetectionConfig
          other =
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .TrainingPredictionSkewDetectionConfig)
                  obj;

      if (!internalGetSkewThresholds().equals(other.internalGetSkewThresholds())) return false;
      if (!internalGetAttributionScoreSkewThresholds()
          .equals(other.internalGetAttributionScoreSkewThresholds())) return false;
      if (hasDefaultSkewThreshold() != other.hasDefaultSkewThreshold()) return false;
      if (hasDefaultSkewThreshold()) {
        if (!getDefaultSkewThreshold().equals(other.getDefaultSkewThreshold())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (!internalGetSkewThresholds().getMap().isEmpty()) {
        hash = (37 * hash) + SKEW_THRESHOLDS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetSkewThresholds().hashCode();
      }
      if (!internalGetAttributionScoreSkewThresholds().getMap().isEmpty()) {
        hash = (37 * hash) + ATTRIBUTION_SCORE_SKEW_THRESHOLDS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetAttributionScoreSkewThresholds().hashCode();
      }
      if (hasDefaultSkewThreshold()) {
        hash = (37 * hash) + DEFAULT_SKEW_THRESHOLD_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultSkewThreshold().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The config for Training &amp; Prediction data skew detection. It specifies the
     * training dataset sources and the skew detection parameters.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 1:
            return internalGetSkewThresholds();
          case 2:
            return internalGetAttributionScoreSkewThresholds();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 1:
            return internalGetMutableSkewThresholds();
          case 2:
            return internalGetMutableAttributionScoreSkewThresholds();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .TrainingPredictionSkewDetectionConfig.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .TrainingPredictionSkewDetectionConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        internalGetMutableSkewThresholds().clear();
        internalGetMutableAttributionScoreSkewThresholds().clear();
        defaultSkewThreshold_ = null;
        if (defaultSkewThresholdBuilder_ != null) {
          defaultSkewThresholdBuilder_.dispose();
          defaultSkewThresholdBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .TrainingPredictionSkewDetectionConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .TrainingPredictionSkewDetectionConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .TrainingPredictionSkewDetectionConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig
            result =
                new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .TrainingPredictionSkewDetectionConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                  .TrainingPredictionSkewDetectionConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.skewThresholds_ = internalGetSkewThresholds();
          result.skewThresholds_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.attributionScoreSkewThresholds_ = internalGetAttributionScoreSkewThresholds();
          result.attributionScoreSkewThresholds_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.defaultSkewThreshold_ =
              defaultSkewThresholdBuilder_ == null
                  ? defaultSkewThreshold_
                  : defaultSkewThresholdBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .TrainingPredictionSkewDetectionConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                  .TrainingPredictionSkewDetectionConfig
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig.getDefaultInstance()) return this;
        internalGetMutableSkewThresholds().mergeFrom(other.internalGetSkewThresholds());
        bitField0_ |= 0x00000001;
        internalGetMutableAttributionScoreSkewThresholds()
            .mergeFrom(other.internalGetAttributionScoreSkewThresholds());
        bitField0_ |= 0x00000002;
        if (other.hasDefaultSkewThreshold()) {
          mergeDefaultSkewThreshold(other.getDefaultSkewThreshold());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
                      skewThresholds__ =
                          input.readMessage(
                              SkewThresholdsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableSkewThresholds()
                      .getMutableMap()
                      .put(skewThresholds__.getKey(), skewThresholds__.getValue());
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
                      attributionScoreSkewThresholds__ =
                          input.readMessage(
                              AttributionScoreSkewThresholdsDefaultEntryHolder.defaultEntry
                                  .getParserForType(),
                              extensionRegistry);
                  internalGetMutableAttributionScoreSkewThresholds()
                      .getMutableMap()
                      .put(
                          attributionScoreSkewThresholds__.getKey(),
                          attributionScoreSkewThresholds__.getValue());
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 50:
                {
                  input.readMessage(
                      getDefaultSkewThresholdFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          skewThresholds_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          internalGetSkewThresholds() {
        if (skewThresholds_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              SkewThresholdsDefaultEntryHolder.defaultEntry);
        }
        return skewThresholds_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          internalGetMutableSkewThresholds() {
        if (skewThresholds_ == null) {
          skewThresholds_ =
              com.google.protobuf.MapField.newMapField(
                  SkewThresholdsDefaultEntryHolder.defaultEntry);
        }
        if (!skewThresholds_.isMutable()) {
          skewThresholds_ = skewThresholds_.copy();
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return skewThresholds_;
      }

      public int getSkewThresholdsCount() {
        return internalGetSkewThresholds().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for skew, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between the training and prediction feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
       * </code>
       */
      @java.lang.Override
      public boolean containsSkewThresholds(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetSkewThresholds().getMap().containsKey(key);
      }
      /** Use {@link #getSkewThresholdsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getSkewThresholds() {
        return getSkewThresholdsMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for skew, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between the training and prediction feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getSkewThresholdsMap() {
        return internalGetSkewThresholds().getMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for skew, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between the training and prediction feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1beta1.ThresholdConfig
          getSkewThresholdsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
            internalGetSkewThresholds().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for skew, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between the training and prediction feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfig getSkewThresholdsOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
            internalGetSkewThresholds().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearSkewThresholds() {
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutableSkewThresholds().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for skew, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between the training and prediction feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
       * </code>
       */
      public Builder removeSkewThresholds(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableSkewThresholds().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getMutableSkewThresholds() {
        bitField0_ |= 0x00000001;
        return internalGetMutableSkewThresholds().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for skew, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between the training and prediction feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
       * </code>
       */
      public Builder putSkewThresholds(
          java.lang.String key, com.google.cloud.aiplatform.v1beta1.ThresholdConfig value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableSkewThresholds().getMutableMap().put(key, value);
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for skew, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between the training and prediction feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; skew_thresholds = 1;
       * </code>
       */
      public Builder putAllSkewThresholds(
          java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
              values) {
        internalGetMutableSkewThresholds().getMutableMap().putAll(values);
        bitField0_ |= 0x00000001;
        return this;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          attributionScoreSkewThresholds_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          internalGetAttributionScoreSkewThresholds() {
        if (attributionScoreSkewThresholds_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              AttributionScoreSkewThresholdsDefaultEntryHolder.defaultEntry);
        }
        return attributionScoreSkewThresholds_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          internalGetMutableAttributionScoreSkewThresholds() {
        if (attributionScoreSkewThresholds_ == null) {
          attributionScoreSkewThresholds_ =
              com.google.protobuf.MapField.newMapField(
                  AttributionScoreSkewThresholdsDefaultEntryHolder.defaultEntry);
        }
        if (!attributionScoreSkewThresholds_.isMutable()) {
          attributionScoreSkewThresholds_ = attributionScoreSkewThresholds_.copy();
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return attributionScoreSkewThresholds_;
      }

      public int getAttributionScoreSkewThresholdsCount() {
        return internalGetAttributionScoreSkewThresholds().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between the training and prediction
       * feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
       * </code>
       */
      @java.lang.Override
      public boolean containsAttributionScoreSkewThresholds(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetAttributionScoreSkewThresholds().getMap().containsKey(key);
      }
      /** Use {@link #getAttributionScoreSkewThresholdsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getAttributionScoreSkewThresholds() {
        return getAttributionScoreSkewThresholdsMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between the training and prediction
       * feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getAttributionScoreSkewThresholdsMap() {
        return internalGetAttributionScoreSkewThresholds().getMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between the training and prediction
       * feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1beta1.ThresholdConfig
          getAttributionScoreSkewThresholdsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
            internalGetAttributionScoreSkewThresholds().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between the training and prediction
       * feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfig
          getAttributionScoreSkewThresholdsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
            internalGetAttributionScoreSkewThresholds().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearAttributionScoreSkewThresholds() {
        bitField0_ = (bitField0_ & ~0x00000002);
        internalGetMutableAttributionScoreSkewThresholds().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between the training and prediction
       * feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
       * </code>
       */
      public Builder removeAttributionScoreSkewThresholds(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableAttributionScoreSkewThresholds().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getMutableAttributionScoreSkewThresholds() {
        bitField0_ |= 0x00000002;
        return internalGetMutableAttributionScoreSkewThresholds().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between the training and prediction
       * feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
       * </code>
       */
      public Builder putAttributionScoreSkewThresholds(
          java.lang.String key, com.google.cloud.aiplatform.v1beta1.ThresholdConfig value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableAttributionScoreSkewThresholds().getMutableMap().put(key, value);
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between the training and prediction
       * feature.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_skew_thresholds = 2;
       * </code>
       */
      public Builder putAllAttributionScoreSkewThresholds(
          java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
              values) {
        internalGetMutableAttributionScoreSkewThresholds().getMutableMap().putAll(values);
        bitField0_ |= 0x00000002;
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultSkewThreshold_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder>
          defaultSkewThresholdBuilder_;
      /**
       *
       *
       * <pre>
       * Skew anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
       *
       * @return Whether the defaultSkewThreshold field is set.
       */
      public boolean hasDefaultSkewThreshold() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Skew anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
       *
       * @return The defaultSkewThreshold.
       */
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfig getDefaultSkewThreshold() {
        if (defaultSkewThresholdBuilder_ == null) {
          return defaultSkewThreshold_ == null
              ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
              : defaultSkewThreshold_;
        } else {
          return defaultSkewThresholdBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Skew anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
       */
      public Builder setDefaultSkewThreshold(
          com.google.cloud.aiplatform.v1beta1.ThresholdConfig value) {
        if (defaultSkewThresholdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultSkewThreshold_ = value;
        } else {
          defaultSkewThresholdBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Skew anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
       */
      public Builder setDefaultSkewThreshold(
          com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder builderForValue) {
        if (defaultSkewThresholdBuilder_ == null) {
          defaultSkewThreshold_ = builderForValue.build();
        } else {
          defaultSkewThresholdBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Skew anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
       */
      public Builder mergeDefaultSkewThreshold(
          com.google.cloud.aiplatform.v1beta1.ThresholdConfig value) {
        if (defaultSkewThresholdBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && defaultSkewThreshold_ != null
              && defaultSkewThreshold_
                  != com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()) {
            getDefaultSkewThresholdBuilder().mergeFrom(value);
          } else {
            defaultSkewThreshold_ = value;
          }
        } else {
          defaultSkewThresholdBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Skew anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
       */
      public Builder clearDefaultSkewThreshold() {
        bitField0_ = (bitField0_ & ~0x00000004);
        defaultSkewThreshold_ = null;
        if (defaultSkewThresholdBuilder_ != null) {
          defaultSkewThresholdBuilder_.dispose();
          defaultSkewThresholdBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Skew anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder
          getDefaultSkewThresholdBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getDefaultSkewThresholdFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Skew anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder
          getDefaultSkewThresholdOrBuilder() {
        if (defaultSkewThresholdBuilder_ != null) {
          return defaultSkewThresholdBuilder_.getMessageOrBuilder();
        } else {
          return defaultSkewThreshold_ == null
              ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
              : defaultSkewThreshold_;
        }
      }
      /**
       *
       *
       * <pre>
       * Skew anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_skew_threshold = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder>
          getDefaultSkewThresholdFieldBuilder() {
        if (defaultSkewThresholdBuilder_ == null) {
          defaultSkewThresholdBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ThresholdConfig,
                  com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder,
                  com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder>(
                  getDefaultSkewThreshold(), getParentForChildren(), isClean());
          defaultSkewThreshold_ = null;
        }
        return defaultSkewThresholdBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .TrainingPredictionSkewDetectionConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TrainingPredictionSkewDetectionConfig> PARSER =
        new com.google.protobuf.AbstractParser<TrainingPredictionSkewDetectionConfig>() {
          @java.lang.Override
          public TrainingPredictionSkewDetectionConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TrainingPredictionSkewDetectionConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TrainingPredictionSkewDetectionConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PredictionDriftDetectionConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for drift, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between different time windws.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
     * </code>
     */
    int getDriftThresholdsCount();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for drift, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between different time windws.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
     * </code>
     */
    boolean containsDriftThresholds(java.lang.String key);
    /** Use {@link #getDriftThresholdsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getDriftThresholds();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for drift, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between different time windws.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
     * </code>
     */
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getDriftThresholdsMap();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for drift, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between different time windws.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
     * </code>
     */
    /* nullable */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfig getDriftThresholdsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue);
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for drift, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between different time windws.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfig getDriftThresholdsOrThrow(
        java.lang.String key);

    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between different time windows.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
     * </code>
     */
    int getAttributionScoreDriftThresholdsCount();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between different time windows.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
     * </code>
     */
    boolean containsAttributionScoreDriftThresholds(java.lang.String key);
    /** Use {@link #getAttributionScoreDriftThresholdsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getAttributionScoreDriftThresholds();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between different time windows.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
     * </code>
     */
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getAttributionScoreDriftThresholdsMap();
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between different time windows.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
     * </code>
     */
    /* nullable */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfig getAttributionScoreDriftThresholdsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue);
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between different time windows.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfig getAttributionScoreDriftThresholdsOrThrow(
        java.lang.String key);

    /**
     *
     *
     * <pre>
     * Drift anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
     *
     * @return Whether the defaultDriftThreshold field is set.
     */
    boolean hasDefaultDriftThreshold();
    /**
     *
     *
     * <pre>
     * Drift anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
     *
     * @return The defaultDriftThreshold.
     */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfig getDefaultDriftThreshold();
    /**
     *
     *
     * <pre>
     * Drift anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
     */
    com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder
        getDefaultDriftThresholdOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The config for Prediction data drift detection.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig}
   */
  public static final class PredictionDriftDetectionConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig)
      PredictionDriftDetectionConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PredictionDriftDetectionConfig.newBuilder() to construct.
    private PredictionDriftDetectionConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PredictionDriftDetectionConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PredictionDriftDetectionConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetDriftThresholds();
        case 2:
          return internalGetAttributionScoreDriftThresholds();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                  .PredictionDriftDetectionConfig.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                  .PredictionDriftDetectionConfig.Builder.class);
    }

    public static final int DRIFT_THRESHOLDS_FIELD_NUMBER = 1;

    private static final class DriftThresholdsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
                      newDefaultInstance(
                          com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
                              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig_DriftThresholdsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        driftThresholds_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        internalGetDriftThresholds() {
      if (driftThresholds_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DriftThresholdsDefaultEntryHolder.defaultEntry);
      }
      return driftThresholds_;
    }

    public int getDriftThresholdsCount() {
      return internalGetDriftThresholds().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for drift, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between different time windws.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
     * </code>
     */
    @java.lang.Override
    public boolean containsDriftThresholds(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDriftThresholds().getMap().containsKey(key);
    }
    /** Use {@link #getDriftThresholdsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getDriftThresholds() {
      return getDriftThresholdsMap();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for drift, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between different time windws.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getDriftThresholdsMap() {
      return internalGetDriftThresholds().getMap();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for drift, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between different time windws.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.ThresholdConfig
        getDriftThresholdsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
          internalGetDriftThresholds().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. If a feature needs to
     * be monitored for drift, a value threshold must be configured for that
     * feature. The threshold here is against feature distribution distance
     * between different time windws.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ThresholdConfig getDriftThresholdsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
          internalGetDriftThresholds().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int ATTRIBUTION_SCORE_DRIFT_THRESHOLDS_FIELD_NUMBER = 2;

    private static final class AttributionScoreDriftThresholdsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
                      newDefaultInstance(
                          com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
                              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig_AttributionScoreDriftThresholdsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        attributionScoreDriftThresholds_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        internalGetAttributionScoreDriftThresholds() {
      if (attributionScoreDriftThresholds_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AttributionScoreDriftThresholdsDefaultEntryHolder.defaultEntry);
      }
      return attributionScoreDriftThresholds_;
    }

    public int getAttributionScoreDriftThresholdsCount() {
      return internalGetAttributionScoreDriftThresholds().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between different time windows.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
     * </code>
     */
    @java.lang.Override
    public boolean containsAttributionScoreDriftThresholds(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttributionScoreDriftThresholds().getMap().containsKey(key);
    }
    /** Use {@link #getAttributionScoreDriftThresholdsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getAttributionScoreDriftThresholds() {
      return getAttributionScoreDriftThresholdsMap();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between different time windows.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
        getAttributionScoreDriftThresholdsMap() {
      return internalGetAttributionScoreDriftThresholds().getMap();
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between different time windows.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.ThresholdConfig
        getAttributionScoreDriftThresholdsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
          internalGetAttributionScoreDriftThresholds().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Key is the feature name and value is the threshold. The threshold here is
     * against attribution score distance between different time windows.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ThresholdConfig
        getAttributionScoreDriftThresholdsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
          internalGetAttributionScoreDriftThresholds().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int DEFAULT_DRIFT_THRESHOLD_FIELD_NUMBER = 5;
    private com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultDriftThreshold_;
    /**
     *
     *
     * <pre>
     * Drift anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
     *
     * @return Whether the defaultDriftThreshold field is set.
     */
    @java.lang.Override
    public boolean hasDefaultDriftThreshold() {
      return defaultDriftThreshold_ != null;
    }
    /**
     *
     *
     * <pre>
     * Drift anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
     *
     * @return The defaultDriftThreshold.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ThresholdConfig getDefaultDriftThreshold() {
      return defaultDriftThreshold_ == null
          ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
          : defaultDriftThreshold_;
    }
    /**
     *
     *
     * <pre>
     * Drift anomaly detection threshold used by all features.
     * When the per-feature thresholds are not set, this field can be used to
     * specify a threshold for all features.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder
        getDefaultDriftThresholdOrBuilder() {
      return defaultDriftThreshold_ == null
          ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
          : defaultDriftThreshold_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetDriftThresholds(), DriftThresholdsDefaultEntryHolder.defaultEntry, 1);
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetAttributionScoreDriftThresholds(),
          AttributionScoreDriftThresholdsDefaultEntryHolder.defaultEntry,
          2);
      if (defaultDriftThreshold_ != null) {
        output.writeMessage(5, getDefaultDriftThreshold());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          entry : internalGetDriftThresholds().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
            driftThresholds__ =
                DriftThresholdsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, driftThresholds__);
      }
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          entry : internalGetAttributionScoreDriftThresholds().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
            attributionScoreDriftThresholds__ =
                AttributionScoreDriftThresholdsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, attributionScoreDriftThresholds__);
      }
      if (defaultDriftThreshold_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDefaultDriftThreshold());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .PredictionDriftDetectionConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .PredictionDriftDetectionConfig
          other =
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .PredictionDriftDetectionConfig)
                  obj;

      if (!internalGetDriftThresholds().equals(other.internalGetDriftThresholds())) return false;
      if (!internalGetAttributionScoreDriftThresholds()
          .equals(other.internalGetAttributionScoreDriftThresholds())) return false;
      if (hasDefaultDriftThreshold() != other.hasDefaultDriftThreshold()) return false;
      if (hasDefaultDriftThreshold()) {
        if (!getDefaultDriftThreshold().equals(other.getDefaultDriftThreshold())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (!internalGetDriftThresholds().getMap().isEmpty()) {
        hash = (37 * hash) + DRIFT_THRESHOLDS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetDriftThresholds().hashCode();
      }
      if (!internalGetAttributionScoreDriftThresholds().getMap().isEmpty()) {
        hash = (37 * hash) + ATTRIBUTION_SCORE_DRIFT_THRESHOLDS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetAttributionScoreDriftThresholds().hashCode();
      }
      if (hasDefaultDriftThreshold()) {
        hash = (37 * hash) + DEFAULT_DRIFT_THRESHOLD_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultDriftThreshold().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The config for Prediction data drift detection.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 1:
            return internalGetDriftThresholds();
          case 2:
            return internalGetAttributionScoreDriftThresholds();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 1:
            return internalGetMutableDriftThresholds();
          case 2:
            return internalGetMutableAttributionScoreDriftThresholds();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .PredictionDriftDetectionConfig.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .PredictionDriftDetectionConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        internalGetMutableDriftThresholds().clear();
        internalGetMutableAttributionScoreDriftThresholds().clear();
        defaultDriftThreshold_ = null;
        if (defaultDriftThresholdBuilder_ != null) {
          defaultDriftThresholdBuilder_.dispose();
          defaultDriftThresholdBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .PredictionDriftDetectionConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .PredictionDriftDetectionConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .PredictionDriftDetectionConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig
            result =
                new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .PredictionDriftDetectionConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                  .PredictionDriftDetectionConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.driftThresholds_ = internalGetDriftThresholds();
          result.driftThresholds_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.attributionScoreDriftThresholds_ = internalGetAttributionScoreDriftThresholds();
          result.attributionScoreDriftThresholds_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.defaultDriftThreshold_ =
              defaultDriftThresholdBuilder_ == null
                  ? defaultDriftThreshold_
                  : defaultDriftThresholdBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .PredictionDriftDetectionConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                  .PredictionDriftDetectionConfig
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig.getDefaultInstance()) return this;
        internalGetMutableDriftThresholds().mergeFrom(other.internalGetDriftThresholds());
        bitField0_ |= 0x00000001;
        internalGetMutableAttributionScoreDriftThresholds()
            .mergeFrom(other.internalGetAttributionScoreDriftThresholds());
        bitField0_ |= 0x00000002;
        if (other.hasDefaultDriftThreshold()) {
          mergeDefaultDriftThreshold(other.getDefaultDriftThreshold());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
                      driftThresholds__ =
                          input.readMessage(
                              DriftThresholdsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableDriftThresholds()
                      .getMutableMap()
                      .put(driftThresholds__.getKey(), driftThresholds__.getValue());
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
                      attributionScoreDriftThresholds__ =
                          input.readMessage(
                              AttributionScoreDriftThresholdsDefaultEntryHolder.defaultEntry
                                  .getParserForType(),
                              extensionRegistry);
                  internalGetMutableAttributionScoreDriftThresholds()
                      .getMutableMap()
                      .put(
                          attributionScoreDriftThresholds__.getKey(),
                          attributionScoreDriftThresholds__.getValue());
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 42:
                {
                  input.readMessage(
                      getDefaultDriftThresholdFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          driftThresholds_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          internalGetDriftThresholds() {
        if (driftThresholds_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              DriftThresholdsDefaultEntryHolder.defaultEntry);
        }
        return driftThresholds_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          internalGetMutableDriftThresholds() {
        if (driftThresholds_ == null) {
          driftThresholds_ =
              com.google.protobuf.MapField.newMapField(
                  DriftThresholdsDefaultEntryHolder.defaultEntry);
        }
        if (!driftThresholds_.isMutable()) {
          driftThresholds_ = driftThresholds_.copy();
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return driftThresholds_;
      }

      public int getDriftThresholdsCount() {
        return internalGetDriftThresholds().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for drift, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between different time windws.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
       * </code>
       */
      @java.lang.Override
      public boolean containsDriftThresholds(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetDriftThresholds().getMap().containsKey(key);
      }
      /** Use {@link #getDriftThresholdsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getDriftThresholds() {
        return getDriftThresholdsMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for drift, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between different time windws.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getDriftThresholdsMap() {
        return internalGetDriftThresholds().getMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for drift, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between different time windws.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1beta1.ThresholdConfig
          getDriftThresholdsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
            internalGetDriftThresholds().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for drift, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between different time windws.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfig getDriftThresholdsOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
            internalGetDriftThresholds().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearDriftThresholds() {
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutableDriftThresholds().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for drift, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between different time windws.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
       * </code>
       */
      public Builder removeDriftThresholds(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableDriftThresholds().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getMutableDriftThresholds() {
        bitField0_ |= 0x00000001;
        return internalGetMutableDriftThresholds().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for drift, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between different time windws.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
       * </code>
       */
      public Builder putDriftThresholds(
          java.lang.String key, com.google.cloud.aiplatform.v1beta1.ThresholdConfig value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableDriftThresholds().getMutableMap().put(key, value);
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. If a feature needs to
       * be monitored for drift, a value threshold must be configured for that
       * feature. The threshold here is against feature distribution distance
       * between different time windws.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; drift_thresholds = 1;
       * </code>
       */
      public Builder putAllDriftThresholds(
          java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
              values) {
        internalGetMutableDriftThresholds().getMutableMap().putAll(values);
        bitField0_ |= 0x00000001;
        return this;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          attributionScoreDriftThresholds_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          internalGetAttributionScoreDriftThresholds() {
        if (attributionScoreDriftThresholds_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              AttributionScoreDriftThresholdsDefaultEntryHolder.defaultEntry);
        }
        return attributionScoreDriftThresholds_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          internalGetMutableAttributionScoreDriftThresholds() {
        if (attributionScoreDriftThresholds_ == null) {
          attributionScoreDriftThresholds_ =
              com.google.protobuf.MapField.newMapField(
                  AttributionScoreDriftThresholdsDefaultEntryHolder.defaultEntry);
        }
        if (!attributionScoreDriftThresholds_.isMutable()) {
          attributionScoreDriftThresholds_ = attributionScoreDriftThresholds_.copy();
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return attributionScoreDriftThresholds_;
      }

      public int getAttributionScoreDriftThresholdsCount() {
        return internalGetAttributionScoreDriftThresholds().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between different time windows.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
       * </code>
       */
      @java.lang.Override
      public boolean containsAttributionScoreDriftThresholds(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetAttributionScoreDriftThresholds().getMap().containsKey(key);
      }
      /** Use {@link #getAttributionScoreDriftThresholdsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getAttributionScoreDriftThresholds() {
        return getAttributionScoreDriftThresholdsMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between different time windows.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getAttributionScoreDriftThresholdsMap() {
        return internalGetAttributionScoreDriftThresholds().getMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between different time windows.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1beta1.ThresholdConfig
          getAttributionScoreDriftThresholdsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
            internalGetAttributionScoreDriftThresholds().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between different time windows.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfig
          getAttributionScoreDriftThresholdsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig> map =
            internalGetAttributionScoreDriftThresholds().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearAttributionScoreDriftThresholds() {
        bitField0_ = (bitField0_ & ~0x00000002);
        internalGetMutableAttributionScoreDriftThresholds().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between different time windows.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
       * </code>
       */
      public Builder removeAttributionScoreDriftThresholds(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableAttributionScoreDriftThresholds().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
          getMutableAttributionScoreDriftThresholds() {
        bitField0_ |= 0x00000002;
        return internalGetMutableAttributionScoreDriftThresholds().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between different time windows.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
       * </code>
       */
      public Builder putAttributionScoreDriftThresholds(
          java.lang.String key, com.google.cloud.aiplatform.v1beta1.ThresholdConfig value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableAttributionScoreDriftThresholds().getMutableMap().put(key, value);
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key is the feature name and value is the threshold. The threshold here is
       * against attribution score distance between different time windows.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.ThresholdConfig&gt; attribution_score_drift_thresholds = 2;
       * </code>
       */
      public Builder putAllAttributionScoreDriftThresholds(
          java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ThresholdConfig>
              values) {
        internalGetMutableAttributionScoreDriftThresholds().getMutableMap().putAll(values);
        bitField0_ |= 0x00000002;
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.ThresholdConfig defaultDriftThreshold_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder>
          defaultDriftThresholdBuilder_;
      /**
       *
       *
       * <pre>
       * Drift anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
       *
       * @return Whether the defaultDriftThreshold field is set.
       */
      public boolean hasDefaultDriftThreshold() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Drift anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
       *
       * @return The defaultDriftThreshold.
       */
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfig getDefaultDriftThreshold() {
        if (defaultDriftThresholdBuilder_ == null) {
          return defaultDriftThreshold_ == null
              ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
              : defaultDriftThreshold_;
        } else {
          return defaultDriftThresholdBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Drift anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
       */
      public Builder setDefaultDriftThreshold(
          com.google.cloud.aiplatform.v1beta1.ThresholdConfig value) {
        if (defaultDriftThresholdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultDriftThreshold_ = value;
        } else {
          defaultDriftThresholdBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Drift anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
       */
      public Builder setDefaultDriftThreshold(
          com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder builderForValue) {
        if (defaultDriftThresholdBuilder_ == null) {
          defaultDriftThreshold_ = builderForValue.build();
        } else {
          defaultDriftThresholdBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Drift anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
       */
      public Builder mergeDefaultDriftThreshold(
          com.google.cloud.aiplatform.v1beta1.ThresholdConfig value) {
        if (defaultDriftThresholdBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && defaultDriftThreshold_ != null
              && defaultDriftThreshold_
                  != com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()) {
            getDefaultDriftThresholdBuilder().mergeFrom(value);
          } else {
            defaultDriftThreshold_ = value;
          }
        } else {
          defaultDriftThresholdBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Drift anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
       */
      public Builder clearDefaultDriftThreshold() {
        bitField0_ = (bitField0_ & ~0x00000004);
        defaultDriftThreshold_ = null;
        if (defaultDriftThresholdBuilder_ != null) {
          defaultDriftThresholdBuilder_.dispose();
          defaultDriftThresholdBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Drift anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder
          getDefaultDriftThresholdBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getDefaultDriftThresholdFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Drift anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder
          getDefaultDriftThresholdOrBuilder() {
        if (defaultDriftThresholdBuilder_ != null) {
          return defaultDriftThresholdBuilder_.getMessageOrBuilder();
        } else {
          return defaultDriftThreshold_ == null
              ? com.google.cloud.aiplatform.v1beta1.ThresholdConfig.getDefaultInstance()
              : defaultDriftThreshold_;
        }
      }
      /**
       *
       *
       * <pre>
       * Drift anomaly detection threshold used by all features.
       * When the per-feature thresholds are not set, this field can be used to
       * specify a threshold for all features.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ThresholdConfig default_drift_threshold = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder>
          getDefaultDriftThresholdFieldBuilder() {
        if (defaultDriftThresholdBuilder_ == null) {
          defaultDriftThresholdBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ThresholdConfig,
                  com.google.cloud.aiplatform.v1beta1.ThresholdConfig.Builder,
                  com.google.cloud.aiplatform.v1beta1.ThresholdConfigOrBuilder>(
                  getDefaultDriftThreshold(), getParentForChildren(), isClean());
          defaultDriftThreshold_ = null;
        }
        return defaultDriftThresholdBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .PredictionDriftDetectionConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PredictionDriftDetectionConfig> PARSER =
        new com.google.protobuf.AbstractParser<PredictionDriftDetectionConfig>() {
          @java.lang.Override
          public PredictionDriftDetectionConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PredictionDriftDetectionConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PredictionDriftDetectionConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ExplanationConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If want to analyze the Vertex Explainable AI feature attribute scores or
     * not. If set to true, Vertex AI will log the feature attributions from
     * explain response and do the skew/drift detection for them.
     * </pre>
     *
     * <code>bool enable_feature_attributes = 1;</code>
     *
     * @return The enableFeatureAttributes.
     */
    boolean getEnableFeatureAttributes();

    /**
     *
     *
     * <pre>
     * Predictions generated by the BatchPredictionJob using baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
     * </code>
     *
     * @return Whether the explanationBaseline field is set.
     */
    boolean hasExplanationBaseline();
    /**
     *
     *
     * <pre>
     * Predictions generated by the BatchPredictionJob using baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
     * </code>
     *
     * @return The explanationBaseline.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            .ExplanationBaseline
        getExplanationBaseline();
    /**
     *
     *
     * <pre>
     * Predictions generated by the BatchPredictionJob using baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            .ExplanationBaselineOrBuilder
        getExplanationBaselineOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The config for integrating with Vertex Explainable AI. Only applicable if
   * the Model has explanation_spec populated.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig}
   */
  public static final class ExplanationConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig)
      ExplanationConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExplanationConfig.newBuilder() to construct.
    private ExplanationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExplanationConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExplanationConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_ExplanationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_ExplanationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .Builder.class);
    }

    public interface ExplanationBaselineOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Cloud Storage location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
       *
       * @return Whether the gcs field is set.
       */
      boolean hasGcs();
      /**
       *
       *
       * <pre>
       * Cloud Storage location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
       *
       * @return The gcs.
       */
      com.google.cloud.aiplatform.v1beta1.GcsDestination getGcs();
      /**
       *
       *
       * <pre>
       * Cloud Storage location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
       */
      com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder getGcsOrBuilder();

      /**
       *
       *
       * <pre>
       * BigQuery location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
       *
       * @return Whether the bigquery field is set.
       */
      boolean hasBigquery();
      /**
       *
       *
       * <pre>
       * BigQuery location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
       *
       * @return The bigquery.
       */
      com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigquery();
      /**
       *
       *
       * <pre>
       * BigQuery location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
       */
      com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder getBigqueryOrBuilder();

      /**
       *
       *
       * <pre>
       * The storage format of the predictions generated BatchPrediction job.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.PredictionFormat prediction_format = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for predictionFormat.
       */
      int getPredictionFormatValue();
      /**
       *
       *
       * <pre>
       * The storage format of the predictions generated BatchPrediction job.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.PredictionFormat prediction_format = 1;
       * </code>
       *
       * @return The predictionFormat.
       */
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              .ExplanationBaseline.PredictionFormat
          getPredictionFormat();

      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              .ExplanationBaseline.DestinationCase
          getDestinationCase();
    }
    /**
     *
     *
     * <pre>
     * Output from
     * [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob]
     * for Model Monitoring baseline dataset, which can be used to generate
     * baseline attribution scores.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline}
     */
    public static final class ExplanationBaseline extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline)
        ExplanationBaselineOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ExplanationBaseline.newBuilder() to construct.
      private ExplanationBaseline(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ExplanationBaseline() {
        predictionFormat_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ExplanationBaseline();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_ExplanationConfig_ExplanationBaseline_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_ExplanationConfig_ExplanationBaseline_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                    .ExplanationBaseline.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                    .ExplanationBaseline.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * The storage format of the predictions generated BatchPrediction job.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.PredictionFormat}
       */
      public enum PredictionFormat implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Should not be set.
         * </pre>
         *
         * <code>PREDICTION_FORMAT_UNSPECIFIED = 0;</code>
         */
        PREDICTION_FORMAT_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Predictions are in JSONL files.
         * </pre>
         *
         * <code>JSONL = 2;</code>
         */
        JSONL(2),
        /**
         *
         *
         * <pre>
         * Predictions are in BigQuery.
         * </pre>
         *
         * <code>BIGQUERY = 3;</code>
         */
        BIGQUERY(3),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Should not be set.
         * </pre>
         *
         * <code>PREDICTION_FORMAT_UNSPECIFIED = 0;</code>
         */
        public static final int PREDICTION_FORMAT_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Predictions are in JSONL files.
         * </pre>
         *
         * <code>JSONL = 2;</code>
         */
        public static final int JSONL_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Predictions are in BigQuery.
         * </pre>
         *
         * <code>BIGQUERY = 3;</code>
         */
        public static final int BIGQUERY_VALUE = 3;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static PredictionFormat valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static PredictionFormat forNumber(int value) {
          switch (value) {
            case 0:
              return PREDICTION_FORMAT_UNSPECIFIED;
            case 2:
              return JSONL;
            case 3:
              return BIGQUERY;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<PredictionFormat>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<PredictionFormat>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<PredictionFormat>() {
                  public PredictionFormat findValueByNumber(int number) {
                    return PredictionFormat.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final PredictionFormat[] VALUES = values();

        public static PredictionFormat valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private PredictionFormat(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.PredictionFormat)
      }

      private int destinationCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object destination_;

      public enum DestinationCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        GCS(2),
        BIGQUERY(3),
        DESTINATION_NOT_SET(0);
        private final int value;

        private DestinationCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static DestinationCase valueOf(int value) {
          return forNumber(value);
        }

        public static DestinationCase forNumber(int value) {
          switch (value) {
            case 2:
              return GCS;
            case 3:
              return BIGQUERY;
            case 0:
              return DESTINATION_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public DestinationCase getDestinationCase() {
        return DestinationCase.forNumber(destinationCase_);
      }

      public static final int GCS_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * Cloud Storage location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
       *
       * @return Whether the gcs field is set.
       */
      @java.lang.Override
      public boolean hasGcs() {
        return destinationCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
       *
       * @return The gcs.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsDestination getGcs() {
        if (destinationCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder getGcsOrBuilder() {
        if (destinationCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      }

      public static final int BIGQUERY_FIELD_NUMBER = 3;
      /**
       *
       *
       * <pre>
       * BigQuery location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
       *
       * @return Whether the bigquery field is set.
       */
      @java.lang.Override
      public boolean hasBigquery() {
        return destinationCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * BigQuery location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
       *
       * @return The bigquery.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigquery() {
        if (destinationCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * BigQuery location for BatchExplain output.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
          getBigqueryOrBuilder() {
        if (destinationCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      }

      public static final int PREDICTION_FORMAT_FIELD_NUMBER = 1;
      private int predictionFormat_ = 0;
      /**
       *
       *
       * <pre>
       * The storage format of the predictions generated BatchPrediction job.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.PredictionFormat prediction_format = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for predictionFormat.
       */
      @java.lang.Override
      public int getPredictionFormatValue() {
        return predictionFormat_;
      }
      /**
       *
       *
       * <pre>
       * The storage format of the predictions generated BatchPrediction job.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.PredictionFormat prediction_format = 1;
       * </code>
       *
       * @return The predictionFormat.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              .ExplanationBaseline.PredictionFormat
          getPredictionFormat() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .ExplanationBaseline.PredictionFormat
            result =
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                    .ExplanationBaseline.PredictionFormat.forNumber(predictionFormat_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .ExplanationBaseline.PredictionFormat.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (predictionFormat_
            != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .ExplanationBaseline.PredictionFormat.PREDICTION_FORMAT_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, predictionFormat_);
        }
        if (destinationCase_ == 2) {
          output.writeMessage(2, (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
        }
        if (destinationCase_ == 3) {
          output.writeMessage(
              3, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (predictionFormat_
            != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .ExplanationBaseline.PredictionFormat.PREDICTION_FORMAT_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, predictionFormat_);
        }
        if (destinationCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
        }
        if (destinationCase_ == 3) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .ExplanationBaseline)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .ExplanationBaseline
            other =
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                        .ExplanationConfig.ExplanationBaseline)
                    obj;

        if (predictionFormat_ != other.predictionFormat_) return false;
        if (!getDestinationCase().equals(other.getDestinationCase())) return false;
        switch (destinationCase_) {
          case 2:
            if (!getGcs().equals(other.getGcs())) return false;
            break;
          case 3:
            if (!getBigquery().equals(other.getBigquery())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + PREDICTION_FORMAT_FIELD_NUMBER;
        hash = (53 * hash) + predictionFormat_;
        switch (destinationCase_) {
          case 2:
            hash = (37 * hash) + GCS_FIELD_NUMBER;
            hash = (53 * hash) + getGcs().hashCode();
            break;
          case 3:
            hash = (37 * hash) + BIGQUERY_FIELD_NUMBER;
            hash = (53 * hash) + getBigquery().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Output from
       * [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob]
       * for Model Monitoring baseline dataset, which can be used to generate
       * baseline attribution scores.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline)
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              .ExplanationBaselineOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_ExplanationConfig_ExplanationBaseline_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_ExplanationConfig_ExplanationBaseline_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .ExplanationConfig.ExplanationBaseline.class,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .ExplanationConfig.ExplanationBaseline.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (gcsBuilder_ != null) {
            gcsBuilder_.clear();
          }
          if (bigqueryBuilder_ != null) {
            bigqueryBuilder_.clear();
          }
          predictionFormat_ = 0;
          destinationCase_ = 0;
          destination_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_ExplanationConfig_ExplanationBaseline_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .ExplanationBaseline
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .ExplanationBaseline
            build() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .ExplanationBaseline
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline
              result =
                  new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .ExplanationConfig.ExplanationBaseline(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                    .ExplanationBaseline
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.predictionFormat_ = predictionFormat_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                    .ExplanationBaseline
                result) {
          result.destinationCase_ = destinationCase_;
          result.destination_ = this.destination_;
          if (destinationCase_ == 2 && gcsBuilder_ != null) {
            result.destination_ = gcsBuilder_.build();
          }
          if (destinationCase_ == 3 && bigqueryBuilder_ != null) {
            result.destination_ = bigqueryBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                        .ExplanationConfig.ExplanationBaseline)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                    .ExplanationBaseline
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                  .ExplanationConfig.ExplanationBaseline.getDefaultInstance()) return this;
          if (other.predictionFormat_ != 0) {
            setPredictionFormatValue(other.getPredictionFormatValue());
          }
          switch (other.getDestinationCase()) {
            case GCS:
              {
                mergeGcs(other.getGcs());
                break;
              }
            case BIGQUERY:
              {
                mergeBigquery(other.getBigquery());
                break;
              }
            case DESTINATION_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    predictionFormat_ = input.readEnum();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 8
                case 18:
                  {
                    input.readMessage(getGcsFieldBuilder().getBuilder(), extensionRegistry);
                    destinationCase_ = 2;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getBigqueryFieldBuilder().getBuilder(), extensionRegistry);
                    destinationCase_ = 3;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int destinationCase_ = 0;
        private java.lang.Object destination_;

        public DestinationCase getDestinationCase() {
          return DestinationCase.forNumber(destinationCase_);
        }

        public Builder clearDestination() {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsDestination,
                com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
            gcsBuilder_;
        /**
         *
         *
         * <pre>
         * Cloud Storage location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
         *
         * @return Whether the gcs field is set.
         */
        @java.lang.Override
        public boolean hasGcs() {
          return destinationCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
         *
         * @return The gcs.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GcsDestination getGcs() {
          if (gcsBuilder_ == null) {
            if (destinationCase_ == 2) {
              return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
            }
            return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
          } else {
            if (destinationCase_ == 2) {
              return gcsBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
         */
        public Builder setGcs(com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
          if (gcsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            destination_ = value;
            onChanged();
          } else {
            gcsBuilder_.setMessage(value);
          }
          destinationCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
         */
        public Builder setGcs(
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
          if (gcsBuilder_ == null) {
            destination_ = builderForValue.build();
            onChanged();
          } else {
            gcsBuilder_.setMessage(builderForValue.build());
          }
          destinationCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
         */
        public Builder mergeGcs(com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
          if (gcsBuilder_ == null) {
            if (destinationCase_ == 2
                && destination_
                    != com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()) {
              destination_ =
                  com.google.cloud.aiplatform.v1beta1.GcsDestination.newBuilder(
                          (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              destination_ = value;
            }
            onChanged();
          } else {
            if (destinationCase_ == 2) {
              gcsBuilder_.mergeFrom(value);
            } else {
              gcsBuilder_.setMessage(value);
            }
          }
          destinationCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
         */
        public Builder clearGcs() {
          if (gcsBuilder_ == null) {
            if (destinationCase_ == 2) {
              destinationCase_ = 0;
              destination_ = null;
              onChanged();
            }
          } else {
            if (destinationCase_ == 2) {
              destinationCase_ = 0;
              destination_ = null;
            }
            gcsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
         */
        public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder getGcsBuilder() {
          return getGcsFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder getGcsOrBuilder() {
          if ((destinationCase_ == 2) && (gcsBuilder_ != null)) {
            return gcsBuilder_.getMessageOrBuilder();
          } else {
            if (destinationCase_ == 2) {
              return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
            }
            return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsDestination,
                com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
            getGcsFieldBuilder() {
          if (gcsBuilder_ == null) {
            if (!(destinationCase_ == 2)) {
              destination_ =
                  com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
            }
            gcsBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.GcsDestination,
                    com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                    com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                    (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_,
                    getParentForChildren(),
                    isClean());
            destination_ = null;
          }
          destinationCase_ = 2;
          onChanged();
          return gcsBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
            bigqueryBuilder_;
        /**
         *
         *
         * <pre>
         * BigQuery location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
         *
         * @return Whether the bigquery field is set.
         */
        @java.lang.Override
        public boolean hasBigquery() {
          return destinationCase_ == 3;
        }
        /**
         *
         *
         * <pre>
         * BigQuery location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
         *
         * @return The bigquery.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigquery() {
          if (bigqueryBuilder_ == null) {
            if (destinationCase_ == 3) {
              return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
            }
            return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
          } else {
            if (destinationCase_ == 3) {
              return bigqueryBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * BigQuery location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
         */
        public Builder setBigquery(com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
          if (bigqueryBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            destination_ = value;
            onChanged();
          } else {
            bigqueryBuilder_.setMessage(value);
          }
          destinationCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * BigQuery location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
         */
        public Builder setBigquery(
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder builderForValue) {
          if (bigqueryBuilder_ == null) {
            destination_ = builderForValue.build();
            onChanged();
          } else {
            bigqueryBuilder_.setMessage(builderForValue.build());
          }
          destinationCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * BigQuery location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
         */
        public Builder mergeBigquery(
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
          if (bigqueryBuilder_ == null) {
            if (destinationCase_ == 3
                && destination_
                    != com.google.cloud.aiplatform.v1beta1.BigQueryDestination
                        .getDefaultInstance()) {
              destination_ =
                  com.google.cloud.aiplatform.v1beta1.BigQueryDestination.newBuilder(
                          (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              destination_ = value;
            }
            onChanged();
          } else {
            if (destinationCase_ == 3) {
              bigqueryBuilder_.mergeFrom(value);
            } else {
              bigqueryBuilder_.setMessage(value);
            }
          }
          destinationCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * BigQuery location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
         */
        public Builder clearBigquery() {
          if (bigqueryBuilder_ == null) {
            if (destinationCase_ == 3) {
              destinationCase_ = 0;
              destination_ = null;
              onChanged();
            }
          } else {
            if (destinationCase_ == 3) {
              destinationCase_ = 0;
              destination_ = null;
            }
            bigqueryBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * BigQuery location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
         */
        public com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder
            getBigqueryBuilder() {
          return getBigqueryFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * BigQuery location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
            getBigqueryOrBuilder() {
          if ((destinationCase_ == 3) && (bigqueryBuilder_ != null)) {
            return bigqueryBuilder_.getMessageOrBuilder();
          } else {
            if (destinationCase_ == 3) {
              return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
            }
            return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * BigQuery location for BatchExplain output.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
            getBigqueryFieldBuilder() {
          if (bigqueryBuilder_ == null) {
            if (!(destinationCase_ == 3)) {
              destination_ =
                  com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
            }
            bigqueryBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
                    com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
                    com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>(
                    (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_,
                    getParentForChildren(),
                    isClean());
            destination_ = null;
          }
          destinationCase_ = 3;
          onChanged();
          return bigqueryBuilder_;
        }

        private int predictionFormat_ = 0;
        /**
         *
         *
         * <pre>
         * The storage format of the predictions generated BatchPrediction job.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.PredictionFormat prediction_format = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for predictionFormat.
         */
        @java.lang.Override
        public int getPredictionFormatValue() {
          return predictionFormat_;
        }
        /**
         *
         *
         * <pre>
         * The storage format of the predictions generated BatchPrediction job.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.PredictionFormat prediction_format = 1;
         * </code>
         *
         * @param value The enum numeric value on the wire for predictionFormat to set.
         * @return This builder for chaining.
         */
        public Builder setPredictionFormatValue(int value) {
          predictionFormat_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The storage format of the predictions generated BatchPrediction job.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.PredictionFormat prediction_format = 1;
         * </code>
         *
         * @return The predictionFormat.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .ExplanationBaseline.PredictionFormat
            getPredictionFormat() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline.PredictionFormat
              result =
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .ExplanationConfig.ExplanationBaseline.PredictionFormat.forNumber(
                      predictionFormat_);
          return result == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline.PredictionFormat.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * The storage format of the predictions generated BatchPrediction job.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.PredictionFormat prediction_format = 1;
         * </code>
         *
         * @param value The predictionFormat to set.
         * @return This builder for chaining.
         */
        public Builder setPredictionFormat(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                    .ExplanationBaseline.PredictionFormat
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000004;
          predictionFormat_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The storage format of the predictions generated BatchPrediction job.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline.PredictionFormat prediction_format = 1;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPredictionFormat() {
          bitField0_ = (bitField0_ & ~0x00000004);
          predictionFormat_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline)
      private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .ExplanationBaseline();
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig.ExplanationBaseline
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ExplanationBaseline> PARSER =
          new com.google.protobuf.AbstractParser<ExplanationBaseline>() {
            @java.lang.Override
            public ExplanationBaseline parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ExplanationBaseline> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ExplanationBaseline> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              .ExplanationBaseline
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int ENABLE_FEATURE_ATTRIBUTES_FIELD_NUMBER = 1;
    private boolean enableFeatureAttributes_ = false;
    /**
     *
     *
     * <pre>
     * If want to analyze the Vertex Explainable AI feature attribute scores or
     * not. If set to true, Vertex AI will log the feature attributions from
     * explain response and do the skew/drift detection for them.
     * </pre>
     *
     * <code>bool enable_feature_attributes = 1;</code>
     *
     * @return The enableFeatureAttributes.
     */
    @java.lang.Override
    public boolean getEnableFeatureAttributes() {
      return enableFeatureAttributes_;
    }

    public static final int EXPLANATION_BASELINE_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            .ExplanationBaseline
        explanationBaseline_;
    /**
     *
     *
     * <pre>
     * Predictions generated by the BatchPredictionJob using baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
     * </code>
     *
     * @return Whether the explanationBaseline field is set.
     */
    @java.lang.Override
    public boolean hasExplanationBaseline() {
      return explanationBaseline_ != null;
    }
    /**
     *
     *
     * <pre>
     * Predictions generated by the BatchPredictionJob using baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
     * </code>
     *
     * @return The explanationBaseline.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            .ExplanationBaseline
        getExplanationBaseline() {
      return explanationBaseline_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              .ExplanationBaseline.getDefaultInstance()
          : explanationBaseline_;
    }
    /**
     *
     *
     * <pre>
     * Predictions generated by the BatchPredictionJob using baseline dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            .ExplanationBaselineOrBuilder
        getExplanationBaselineOrBuilder() {
      return explanationBaseline_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              .ExplanationBaseline.getDefaultInstance()
          : explanationBaseline_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enableFeatureAttributes_ != false) {
        output.writeBool(1, enableFeatureAttributes_);
      }
      if (explanationBaseline_ != null) {
        output.writeMessage(2, getExplanationBaseline());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enableFeatureAttributes_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enableFeatureAttributes_);
      }
      if (explanationBaseline_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExplanationBaseline());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig)
              obj;

      if (getEnableFeatureAttributes() != other.getEnableFeatureAttributes()) return false;
      if (hasExplanationBaseline() != other.hasExplanationBaseline()) return false;
      if (hasExplanationBaseline()) {
        if (!getExplanationBaseline().equals(other.getExplanationBaseline())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLE_FEATURE_ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableFeatureAttributes());
      if (hasExplanationBaseline()) {
        hash = (37 * hash) + EXPLANATION_BASELINE_FIELD_NUMBER;
        hash = (53 * hash) + getExplanationBaseline().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The config for integrating with Vertex Explainable AI. Only applicable if
     * the Model has explanation_spec populated.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_ExplanationConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_ExplanationConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                    .class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enableFeatureAttributes_ = false;
        explanationBaseline_ = null;
        if (explanationBaselineBuilder_ != null) {
          explanationBaselineBuilder_.dispose();
          explanationBaselineBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_ExplanationConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            result =
                new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .ExplanationConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enableFeatureAttributes_ = enableFeatureAttributes_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.explanationBaseline_ =
              explanationBaselineBuilder_ == null
                  ? explanationBaseline_
                  : explanationBaselineBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .getDefaultInstance()) return this;
        if (other.getEnableFeatureAttributes() != false) {
          setEnableFeatureAttributes(other.getEnableFeatureAttributes());
        }
        if (other.hasExplanationBaseline()) {
          mergeExplanationBaseline(other.getExplanationBaseline());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enableFeatureAttributes_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(
                      getExplanationBaselineFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enableFeatureAttributes_;
      /**
       *
       *
       * <pre>
       * If want to analyze the Vertex Explainable AI feature attribute scores or
       * not. If set to true, Vertex AI will log the feature attributions from
       * explain response and do the skew/drift detection for them.
       * </pre>
       *
       * <code>bool enable_feature_attributes = 1;</code>
       *
       * @return The enableFeatureAttributes.
       */
      @java.lang.Override
      public boolean getEnableFeatureAttributes() {
        return enableFeatureAttributes_;
      }
      /**
       *
       *
       * <pre>
       * If want to analyze the Vertex Explainable AI feature attribute scores or
       * not. If set to true, Vertex AI will log the feature attributions from
       * explain response and do the skew/drift detection for them.
       * </pre>
       *
       * <code>bool enable_feature_attributes = 1;</code>
       *
       * @param value The enableFeatureAttributes to set.
       * @return This builder for chaining.
       */
      public Builder setEnableFeatureAttributes(boolean value) {

        enableFeatureAttributes_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If want to analyze the Vertex Explainable AI feature attribute scores or
       * not. If set to true, Vertex AI will log the feature attributions from
       * explain response and do the skew/drift detection for them.
       * </pre>
       *
       * <code>bool enable_feature_attributes = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableFeatureAttributes() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enableFeatureAttributes_ = false;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              .ExplanationBaseline
          explanationBaseline_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaselineOrBuilder>
          explanationBaselineBuilder_;
      /**
       *
       *
       * <pre>
       * Predictions generated by the BatchPredictionJob using baseline dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
       * </code>
       *
       * @return Whether the explanationBaseline field is set.
       */
      public boolean hasExplanationBaseline() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Predictions generated by the BatchPredictionJob using baseline dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
       * </code>
       *
       * @return The explanationBaseline.
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              .ExplanationBaseline
          getExplanationBaseline() {
        if (explanationBaselineBuilder_ == null) {
          return explanationBaseline_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline.getDefaultInstance()
              : explanationBaseline_;
        } else {
          return explanationBaselineBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Predictions generated by the BatchPredictionJob using baseline dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
       * </code>
       */
      public Builder setExplanationBaseline(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline
              value) {
        if (explanationBaselineBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          explanationBaseline_ = value;
        } else {
          explanationBaselineBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Predictions generated by the BatchPredictionJob using baseline dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
       * </code>
       */
      public Builder setExplanationBaseline(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline.Builder
              builderForValue) {
        if (explanationBaselineBuilder_ == null) {
          explanationBaseline_ = builderForValue.build();
        } else {
          explanationBaselineBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Predictions generated by the BatchPredictionJob using baseline dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
       * </code>
       */
      public Builder mergeExplanationBaseline(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline
              value) {
        if (explanationBaselineBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && explanationBaseline_ != null
              && explanationBaseline_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .ExplanationConfig.ExplanationBaseline.getDefaultInstance()) {
            getExplanationBaselineBuilder().mergeFrom(value);
          } else {
            explanationBaseline_ = value;
          }
        } else {
          explanationBaselineBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Predictions generated by the BatchPredictionJob using baseline dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
       * </code>
       */
      public Builder clearExplanationBaseline() {
        bitField0_ = (bitField0_ & ~0x00000002);
        explanationBaseline_ = null;
        if (explanationBaselineBuilder_ != null) {
          explanationBaselineBuilder_.dispose();
          explanationBaselineBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Predictions generated by the BatchPredictionJob using baseline dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              .ExplanationBaseline.Builder
          getExplanationBaselineBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getExplanationBaselineFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Predictions generated by the BatchPredictionJob using baseline dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
              .ExplanationBaselineOrBuilder
          getExplanationBaselineOrBuilder() {
        if (explanationBaselineBuilder_ != null) {
          return explanationBaselineBuilder_.getMessageOrBuilder();
        } else {
          return explanationBaseline_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline.getDefaultInstance()
              : explanationBaseline_;
        }
      }
      /**
       *
       *
       * <pre>
       * Predictions generated by the BatchPredictionJob using baseline dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.ExplanationBaseline explanation_baseline = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaseline.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                  .ExplanationBaselineOrBuilder>
          getExplanationBaselineFieldBuilder() {
        if (explanationBaselineBuilder_ == null) {
          explanationBaselineBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .ExplanationConfig.ExplanationBaseline,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .ExplanationConfig.ExplanationBaseline.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                      .ExplanationConfig.ExplanationBaselineOrBuilder>(
                  getExplanationBaseline(), getParentForChildren(), isClean());
          explanationBaseline_ = null;
        }
        return explanationBaselineBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .ExplanationConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExplanationConfig> PARSER =
        new com.google.protobuf.AbstractParser<ExplanationConfig>() {
          @java.lang.Override
          public ExplanationConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExplanationConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExplanationConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int TRAINING_DATASET_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
      trainingDataset_;
  /**
   *
   *
   * <pre>
   * Training dataset for models. This field has to be set only if
   * TrainingPredictionSkewDetectionConfig is specified.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
   * </code>
   *
   * @return Whether the trainingDataset field is set.
   */
  @java.lang.Override
  public boolean hasTrainingDataset() {
    return trainingDataset_ != null;
  }
  /**
   *
   *
   * <pre>
   * Training dataset for models. This field has to be set only if
   * TrainingPredictionSkewDetectionConfig is specified.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
   * </code>
   *
   * @return The trainingDataset.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
      getTrainingDataset() {
    return trainingDataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
            .getDefaultInstance()
        : trainingDataset_;
  }
  /**
   *
   *
   * <pre>
   * Training dataset for models. This field has to be set only if
   * TrainingPredictionSkewDetectionConfig is specified.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDatasetOrBuilder
      getTrainingDatasetOrBuilder() {
    return trainingDataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
            .getDefaultInstance()
        : trainingDataset_;
  }

  public static final int TRAINING_PREDICTION_SKEW_DETECTION_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
          .TrainingPredictionSkewDetectionConfig
      trainingPredictionSkewDetectionConfig_;
  /**
   *
   *
   * <pre>
   * The config for skew between training data and prediction data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
   * </code>
   *
   * @return Whether the trainingPredictionSkewDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasTrainingPredictionSkewDetectionConfig() {
    return trainingPredictionSkewDetectionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The config for skew between training data and prediction data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
   * </code>
   *
   * @return The trainingPredictionSkewDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
          .TrainingPredictionSkewDetectionConfig
      getTrainingPredictionSkewDetectionConfig() {
    return trainingPredictionSkewDetectionConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig.getDefaultInstance()
        : trainingPredictionSkewDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * The config for skew between training data and prediction data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
          .TrainingPredictionSkewDetectionConfigOrBuilder
      getTrainingPredictionSkewDetectionConfigOrBuilder() {
    return trainingPredictionSkewDetectionConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig.getDefaultInstance()
        : trainingPredictionSkewDetectionConfig_;
  }

  public static final int PREDICTION_DRIFT_DETECTION_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
          .PredictionDriftDetectionConfig
      predictionDriftDetectionConfig_;
  /**
   *
   *
   * <pre>
   * The config for drift of prediction data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
   * </code>
   *
   * @return Whether the predictionDriftDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasPredictionDriftDetectionConfig() {
    return predictionDriftDetectionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The config for drift of prediction data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
   * </code>
   *
   * @return The predictionDriftDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
          .PredictionDriftDetectionConfig
      getPredictionDriftDetectionConfig() {
    return predictionDriftDetectionConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig.getDefaultInstance()
        : predictionDriftDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * The config for drift of prediction data.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
          .PredictionDriftDetectionConfigOrBuilder
      getPredictionDriftDetectionConfigOrBuilder() {
    return predictionDriftDetectionConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig.getDefaultInstance()
        : predictionDriftDetectionConfig_;
  }

  public static final int EXPLANATION_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
      explanationConfig_;
  /**
   *
   *
   * <pre>
   * The config for integrating with Vertex Explainable AI.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
   * </code>
   *
   * @return Whether the explanationConfig field is set.
   */
  @java.lang.Override
  public boolean hasExplanationConfig() {
    return explanationConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The config for integrating with Vertex Explainable AI.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
   * </code>
   *
   * @return The explanationConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
      getExplanationConfig() {
    return explanationConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            .getDefaultInstance()
        : explanationConfig_;
  }
  /**
   *
   *
   * <pre>
   * The config for integrating with Vertex Explainable AI.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
          .ExplanationConfigOrBuilder
      getExplanationConfigOrBuilder() {
    return explanationConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            .getDefaultInstance()
        : explanationConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (trainingDataset_ != null) {
      output.writeMessage(1, getTrainingDataset());
    }
    if (trainingPredictionSkewDetectionConfig_ != null) {
      output.writeMessage(2, getTrainingPredictionSkewDetectionConfig());
    }
    if (predictionDriftDetectionConfig_ != null) {
      output.writeMessage(3, getPredictionDriftDetectionConfig());
    }
    if (explanationConfig_ != null) {
      output.writeMessage(5, getExplanationConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (trainingDataset_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTrainingDataset());
    }
    if (trainingPredictionSkewDetectionConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, getTrainingPredictionSkewDetectionConfig());
    }
    if (predictionDriftDetectionConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getPredictionDriftDetectionConfig());
    }
    if (explanationConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getExplanationConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig) obj;

    if (hasTrainingDataset() != other.hasTrainingDataset()) return false;
    if (hasTrainingDataset()) {
      if (!getTrainingDataset().equals(other.getTrainingDataset())) return false;
    }
    if (hasTrainingPredictionSkewDetectionConfig()
        != other.hasTrainingPredictionSkewDetectionConfig()) return false;
    if (hasTrainingPredictionSkewDetectionConfig()) {
      if (!getTrainingPredictionSkewDetectionConfig()
          .equals(other.getTrainingPredictionSkewDetectionConfig())) return false;
    }
    if (hasPredictionDriftDetectionConfig() != other.hasPredictionDriftDetectionConfig())
      return false;
    if (hasPredictionDriftDetectionConfig()) {
      if (!getPredictionDriftDetectionConfig().equals(other.getPredictionDriftDetectionConfig()))
        return false;
    }
    if (hasExplanationConfig() != other.hasExplanationConfig()) return false;
    if (hasExplanationConfig()) {
      if (!getExplanationConfig().equals(other.getExplanationConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTrainingDataset()) {
      hash = (37 * hash) + TRAINING_DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getTrainingDataset().hashCode();
    }
    if (hasTrainingPredictionSkewDetectionConfig()) {
      hash = (37 * hash) + TRAINING_PREDICTION_SKEW_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getTrainingPredictionSkewDetectionConfig().hashCode();
    }
    if (hasPredictionDriftDetectionConfig()) {
      hash = (37 * hash) + PREDICTION_DRIFT_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPredictionDriftDetectionConfig().hashCode();
    }
    if (hasExplanationConfig()) {
      hash = (37 * hash) + EXPLANATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The objective configuration for model monitoring, including the information
   * needed to detect anomalies for one particular model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig)
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      trainingDataset_ = null;
      if (trainingDatasetBuilder_ != null) {
        trainingDatasetBuilder_.dispose();
        trainingDatasetBuilder_ = null;
      }
      trainingPredictionSkewDetectionConfig_ = null;
      if (trainingPredictionSkewDetectionConfigBuilder_ != null) {
        trainingPredictionSkewDetectionConfigBuilder_.dispose();
        trainingPredictionSkewDetectionConfigBuilder_ = null;
      }
      predictionDriftDetectionConfig_ = null;
      if (predictionDriftDetectionConfigBuilder_ != null) {
        predictionDriftDetectionConfigBuilder_.dispose();
        predictionDriftDetectionConfigBuilder_ = null;
      }
      explanationConfig_ = null;
      if (explanationConfigBuilder_ != null) {
        explanationConfigBuilder_.dispose();
        explanationConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringObjectiveConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.trainingDataset_ =
            trainingDatasetBuilder_ == null ? trainingDataset_ : trainingDatasetBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.trainingPredictionSkewDetectionConfig_ =
            trainingPredictionSkewDetectionConfigBuilder_ == null
                ? trainingPredictionSkewDetectionConfig_
                : trainingPredictionSkewDetectionConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.predictionDriftDetectionConfig_ =
            predictionDriftDetectionConfigBuilder_ == null
                ? predictionDriftDetectionConfig_
                : predictionDriftDetectionConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.explanationConfig_ =
            explanationConfigBuilder_ == null
                ? explanationConfig_
                : explanationConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
              .getDefaultInstance()) return this;
      if (other.hasTrainingDataset()) {
        mergeTrainingDataset(other.getTrainingDataset());
      }
      if (other.hasTrainingPredictionSkewDetectionConfig()) {
        mergeTrainingPredictionSkewDetectionConfig(
            other.getTrainingPredictionSkewDetectionConfig());
      }
      if (other.hasPredictionDriftDetectionConfig()) {
        mergePredictionDriftDetectionConfig(other.getPredictionDriftDetectionConfig());
      }
      if (other.hasExplanationConfig()) {
        mergeExplanationConfig(other.getExplanationConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTrainingDatasetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getTrainingPredictionSkewDetectionConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getPredictionDriftDetectionConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(
                    getExplanationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        trainingDataset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingDatasetOrBuilder>
        trainingDatasetBuilder_;
    /**
     *
     *
     * <pre>
     * Training dataset for models. This field has to be set only if
     * TrainingPredictionSkewDetectionConfig is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
     * </code>
     *
     * @return Whether the trainingDataset field is set.
     */
    public boolean hasTrainingDataset() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Training dataset for models. This field has to be set only if
     * TrainingPredictionSkewDetectionConfig is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
     * </code>
     *
     * @return The trainingDataset.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
        getTrainingDataset() {
      if (trainingDatasetBuilder_ == null) {
        return trainingDataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
                .getDefaultInstance()
            : trainingDataset_;
      } else {
        return trainingDatasetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Training dataset for models. This field has to be set only if
     * TrainingPredictionSkewDetectionConfig is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
     * </code>
     */
    public Builder setTrainingDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset value) {
      if (trainingDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainingDataset_ = value;
      } else {
        trainingDatasetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Training dataset for models. This field has to be set only if
     * TrainingPredictionSkewDetectionConfig is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
     * </code>
     */
    public Builder setTrainingDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset.Builder
            builderForValue) {
      if (trainingDatasetBuilder_ == null) {
        trainingDataset_ = builderForValue.build();
      } else {
        trainingDatasetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Training dataset for models. This field has to be set only if
     * TrainingPredictionSkewDetectionConfig is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
     * </code>
     */
    public Builder mergeTrainingDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset value) {
      if (trainingDatasetBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && trainingDataset_ != null
            && trainingDataset_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .TrainingDataset.getDefaultInstance()) {
          getTrainingDatasetBuilder().mergeFrom(value);
        } else {
          trainingDataset_ = value;
        }
      } else {
        trainingDatasetBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Training dataset for models. This field has to be set only if
     * TrainingPredictionSkewDetectionConfig is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
     * </code>
     */
    public Builder clearTrainingDataset() {
      bitField0_ = (bitField0_ & ~0x00000001);
      trainingDataset_ = null;
      if (trainingDatasetBuilder_ != null) {
        trainingDatasetBuilder_.dispose();
        trainingDatasetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Training dataset for models. This field has to be set only if
     * TrainingPredictionSkewDetectionConfig is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
            .Builder
        getTrainingDatasetBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getTrainingDatasetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Training dataset for models. This field has to be set only if
     * TrainingPredictionSkewDetectionConfig is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingDatasetOrBuilder
        getTrainingDatasetOrBuilder() {
      if (trainingDatasetBuilder_ != null) {
        return trainingDatasetBuilder_.getMessageOrBuilder();
      } else {
        return trainingDataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
                .getDefaultInstance()
            : trainingDataset_;
      }
    }
    /**
     *
     *
     * <pre>
     * Training dataset for models. This field has to be set only if
     * TrainingPredictionSkewDetectionConfig is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset training_dataset = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingDatasetOrBuilder>
        getTrainingDatasetFieldBuilder() {
      if (trainingDatasetBuilder_ == null) {
        trainingDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .TrainingDatasetOrBuilder>(
                getTrainingDataset(), getParentForChildren(), isClean());
        trainingDataset_ = null;
      }
      return trainingDatasetBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        trainingPredictionSkewDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfigOrBuilder>
        trainingPredictionSkewDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The config for skew between training data and prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
     * </code>
     *
     * @return Whether the trainingPredictionSkewDetectionConfig field is set.
     */
    public boolean hasTrainingPredictionSkewDetectionConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The config for skew between training data and prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
     * </code>
     *
     * @return The trainingPredictionSkewDetectionConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig
        getTrainingPredictionSkewDetectionConfig() {
      if (trainingPredictionSkewDetectionConfigBuilder_ == null) {
        return trainingPredictionSkewDetectionConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig.getDefaultInstance()
            : trainingPredictionSkewDetectionConfig_;
      } else {
        return trainingPredictionSkewDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The config for skew between training data and prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
     * </code>
     */
    public Builder setTrainingPredictionSkewDetectionConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig
            value) {
      if (trainingPredictionSkewDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainingPredictionSkewDetectionConfig_ = value;
      } else {
        trainingPredictionSkewDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for skew between training data and prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
     * </code>
     */
    public Builder setTrainingPredictionSkewDetectionConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig.Builder
            builderForValue) {
      if (trainingPredictionSkewDetectionConfigBuilder_ == null) {
        trainingPredictionSkewDetectionConfig_ = builderForValue.build();
      } else {
        trainingPredictionSkewDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for skew between training data and prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
     * </code>
     */
    public Builder mergeTrainingPredictionSkewDetectionConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig
            value) {
      if (trainingPredictionSkewDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && trainingPredictionSkewDetectionConfig_ != null
            && trainingPredictionSkewDetectionConfig_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .TrainingPredictionSkewDetectionConfig.getDefaultInstance()) {
          getTrainingPredictionSkewDetectionConfigBuilder().mergeFrom(value);
        } else {
          trainingPredictionSkewDetectionConfig_ = value;
        }
      } else {
        trainingPredictionSkewDetectionConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for skew between training data and prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
     * </code>
     */
    public Builder clearTrainingPredictionSkewDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      trainingPredictionSkewDetectionConfig_ = null;
      if (trainingPredictionSkewDetectionConfigBuilder_ != null) {
        trainingPredictionSkewDetectionConfigBuilder_.dispose();
        trainingPredictionSkewDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for skew between training data and prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfig.Builder
        getTrainingPredictionSkewDetectionConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTrainingPredictionSkewDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config for skew between training data and prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .TrainingPredictionSkewDetectionConfigOrBuilder
        getTrainingPredictionSkewDetectionConfigOrBuilder() {
      if (trainingPredictionSkewDetectionConfigBuilder_ != null) {
        return trainingPredictionSkewDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return trainingPredictionSkewDetectionConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig.getDefaultInstance()
            : trainingPredictionSkewDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The config for skew between training data and prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig training_prediction_skew_detection_config = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .TrainingPredictionSkewDetectionConfigOrBuilder>
        getTrainingPredictionSkewDetectionConfigFieldBuilder() {
      if (trainingPredictionSkewDetectionConfigBuilder_ == null) {
        trainingPredictionSkewDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .TrainingPredictionSkewDetectionConfig,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .TrainingPredictionSkewDetectionConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .TrainingPredictionSkewDetectionConfigOrBuilder>(
                getTrainingPredictionSkewDetectionConfig(), getParentForChildren(), isClean());
        trainingPredictionSkewDetectionConfig_ = null;
      }
      return trainingPredictionSkewDetectionConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        predictionDriftDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfigOrBuilder>
        predictionDriftDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The config for drift of prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
     * </code>
     *
     * @return Whether the predictionDriftDetectionConfig field is set.
     */
    public boolean hasPredictionDriftDetectionConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The config for drift of prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
     * </code>
     *
     * @return The predictionDriftDetectionConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig
        getPredictionDriftDetectionConfig() {
      if (predictionDriftDetectionConfigBuilder_ == null) {
        return predictionDriftDetectionConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig.getDefaultInstance()
            : predictionDriftDetectionConfig_;
      } else {
        return predictionDriftDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The config for drift of prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
     * </code>
     */
    public Builder setPredictionDriftDetectionConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig
            value) {
      if (predictionDriftDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictionDriftDetectionConfig_ = value;
      } else {
        predictionDriftDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for drift of prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
     * </code>
     */
    public Builder setPredictionDriftDetectionConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig.Builder
            builderForValue) {
      if (predictionDriftDetectionConfigBuilder_ == null) {
        predictionDriftDetectionConfig_ = builderForValue.build();
      } else {
        predictionDriftDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for drift of prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
     * </code>
     */
    public Builder mergePredictionDriftDetectionConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig
            value) {
      if (predictionDriftDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && predictionDriftDetectionConfig_ != null
            && predictionDriftDetectionConfig_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .PredictionDriftDetectionConfig.getDefaultInstance()) {
          getPredictionDriftDetectionConfigBuilder().mergeFrom(value);
        } else {
          predictionDriftDetectionConfig_ = value;
        }
      } else {
        predictionDriftDetectionConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for drift of prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
     * </code>
     */
    public Builder clearPredictionDriftDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      predictionDriftDetectionConfig_ = null;
      if (predictionDriftDetectionConfigBuilder_ != null) {
        predictionDriftDetectionConfigBuilder_.dispose();
        predictionDriftDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for drift of prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfig.Builder
        getPredictionDriftDetectionConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPredictionDriftDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config for drift of prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .PredictionDriftDetectionConfigOrBuilder
        getPredictionDriftDetectionConfigOrBuilder() {
      if (predictionDriftDetectionConfigBuilder_ != null) {
        return predictionDriftDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return predictionDriftDetectionConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig.getDefaultInstance()
            : predictionDriftDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The config for drift of prediction data.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig prediction_drift_detection_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .PredictionDriftDetectionConfigOrBuilder>
        getPredictionDriftDetectionConfigFieldBuilder() {
      if (predictionDriftDetectionConfigBuilder_ == null) {
        predictionDriftDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .PredictionDriftDetectionConfig,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .PredictionDriftDetectionConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .PredictionDriftDetectionConfigOrBuilder>(
                getPredictionDriftDetectionConfig(), getParentForChildren(), isClean());
        predictionDriftDetectionConfig_ = null;
      }
      return predictionDriftDetectionConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
        explanationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .ExplanationConfigOrBuilder>
        explanationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The config for integrating with Vertex Explainable AI.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
     * </code>
     *
     * @return Whether the explanationConfig field is set.
     */
    public boolean hasExplanationConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The config for integrating with Vertex Explainable AI.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
     * </code>
     *
     * @return The explanationConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
        getExplanationConfig() {
      if (explanationConfigBuilder_ == null) {
        return explanationConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .getDefaultInstance()
            : explanationConfig_;
      } else {
        return explanationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The config for integrating with Vertex Explainable AI.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
     * </code>
     */
    public Builder setExplanationConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            value) {
      if (explanationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explanationConfig_ = value;
      } else {
        explanationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for integrating with Vertex Explainable AI.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
     * </code>
     */
    public Builder setExplanationConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig.Builder
            builderForValue) {
      if (explanationConfigBuilder_ == null) {
        explanationConfig_ = builderForValue.build();
      } else {
        explanationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for integrating with Vertex Explainable AI.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
     * </code>
     */
    public Builder mergeExplanationConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            value) {
      if (explanationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && explanationConfig_ != null
            && explanationConfig_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .ExplanationConfig.getDefaultInstance()) {
          getExplanationConfigBuilder().mergeFrom(value);
        } else {
          explanationConfig_ = value;
        }
      } else {
        explanationConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for integrating with Vertex Explainable AI.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
     * </code>
     */
    public Builder clearExplanationConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      explanationConfig_ = null;
      if (explanationConfigBuilder_ != null) {
        explanationConfigBuilder_.dispose();
        explanationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for integrating with Vertex Explainable AI.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
            .Builder
        getExplanationConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getExplanationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config for integrating with Vertex Explainable AI.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
            .ExplanationConfigOrBuilder
        getExplanationConfigOrBuilder() {
      if (explanationConfigBuilder_ != null) {
        return explanationConfigBuilder_.getMessageOrBuilder();
      } else {
        return explanationConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .getDefaultInstance()
            : explanationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The config for integrating with Vertex Explainable AI.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig explanation_config = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                .ExplanationConfigOrBuilder>
        getExplanationConfigFieldBuilder() {
      if (explanationConfigBuilder_ == null) {
        explanationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .ExplanationConfig,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.ExplanationConfig
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                    .ExplanationConfigOrBuilder>(
                getExplanationConfig(), getParentForChildren(), isClean());
        explanationConfig_ = null;
      }
      return explanationConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringObjectiveConfig> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringObjectiveConfig>() {
        @java.lang.Override
        public ModelMonitoringObjectiveConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringObjectiveConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringObjectiveConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
