/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TensorboardName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TENSORBOARD = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tensorboards/{tensorboard}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tensorboard;

    @Deprecated
    protected TensorboardName() {
        this.project = null;
        this.location = null;
        this.tensorboard = null;
    }

    private TensorboardName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tensorboard = (String)Preconditions.checkNotNull((Object)builder.getTensorboard());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTensorboard() {
        return this.tensorboard;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TensorboardName of(String project, String location, String tensorboard) {
        return TensorboardName.newBuilder().setProject(project).setLocation(location).setTensorboard(tensorboard).build();
    }

    public static String format(String project, String location, String tensorboard) {
        return TensorboardName.newBuilder().setProject(project).setLocation(location).setTensorboard(tensorboard).build().toString();
    }

    public static TensorboardName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TENSORBOARD.validatedMatch(formattedString, "TensorboardName.parse: formattedString not in valid format");
        return TensorboardName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tensorboard"));
    }

    public static List<TensorboardName> parseList(List<String> formattedStrings) {
        ArrayList<TensorboardName> list = new ArrayList<TensorboardName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TensorboardName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TensorboardName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TensorboardName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TENSORBOARD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TensorboardName tensorboardName = this;
            synchronized (tensorboardName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.tensorboard != null) {
                        fieldMapBuilder.put((Object)"tensorboard", (Object)this.tensorboard);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TENSORBOARD.instantiate(new String[]{"project", this.project, "location", this.location, "tensorboard", this.tensorboard});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TensorboardName that = (TensorboardName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.tensorboard, that.tensorboard);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tensorboard);
    }

    public static class Builder {
        private String project;
        private String location;
        private String tensorboard;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTensorboard() {
            return this.tensorboard;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTensorboard(String tensorboard) {
            this.tensorboard = tensorboard;
            return this;
        }

        private Builder(TensorboardName tensorboardName) {
            this.project = tensorboardName.project;
            this.location = tensorboardName.location;
            this.tensorboard = tensorboardName.tensorboard;
        }

        public TensorboardName build() {
            return new TensorboardName(this);
        }
    }
}

