/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/vertex_rag_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Claim that is extracted from the input text and facts that support it.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Claim}
 */
public final class Claim extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Claim)
    ClaimOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Claim.newBuilder() to construct.
  private Claim(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Claim() {
    factIndexes_ = emptyIntList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Claim();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_Claim_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_Claim_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Claim.class,
            com.google.cloud.aiplatform.v1beta1.Claim.Builder.class);
  }

  private int bitField0_;
  public static final int START_INDEX_FIELD_NUMBER = 1;
  private int startIndex_ = 0;

  /**
   *
   *
   * <pre>
   * Index in the input text where the claim starts (inclusive).
   * </pre>
   *
   * <code>optional int32 start_index = 1;</code>
   *
   * @return Whether the startIndex field is set.
   */
  @java.lang.Override
  public boolean hasStartIndex() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Index in the input text where the claim starts (inclusive).
   * </pre>
   *
   * <code>optional int32 start_index = 1;</code>
   *
   * @return The startIndex.
   */
  @java.lang.Override
  public int getStartIndex() {
    return startIndex_;
  }

  public static final int END_INDEX_FIELD_NUMBER = 2;
  private int endIndex_ = 0;

  /**
   *
   *
   * <pre>
   * Index in the input text where the claim ends (exclusive).
   * </pre>
   *
   * <code>optional int32 end_index = 2;</code>
   *
   * @return Whether the endIndex field is set.
   */
  @java.lang.Override
  public boolean hasEndIndex() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Index in the input text where the claim ends (exclusive).
   * </pre>
   *
   * <code>optional int32 end_index = 2;</code>
   *
   * @return The endIndex.
   */
  @java.lang.Override
  public int getEndIndex() {
    return endIndex_;
  }

  public static final int FACT_INDEXES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList factIndexes_ = emptyIntList();

  /**
   *
   *
   * <pre>
   * Indexes of the facts supporting this claim.
   * </pre>
   *
   * <code>repeated int32 fact_indexes = 3;</code>
   *
   * @return A list containing the factIndexes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getFactIndexesList() {
    return factIndexes_;
  }

  /**
   *
   *
   * <pre>
   * Indexes of the facts supporting this claim.
   * </pre>
   *
   * <code>repeated int32 fact_indexes = 3;</code>
   *
   * @return The count of factIndexes.
   */
  public int getFactIndexesCount() {
    return factIndexes_.size();
  }

  /**
   *
   *
   * <pre>
   * Indexes of the facts supporting this claim.
   * </pre>
   *
   * <code>repeated int32 fact_indexes = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The factIndexes at the given index.
   */
  public int getFactIndexes(int index) {
    return factIndexes_.getInt(index);
  }

  private int factIndexesMemoizedSerializedSize = -1;

  public static final int SCORE_FIELD_NUMBER = 4;
  private float score_ = 0F;

  /**
   *
   *
   * <pre>
   * Confidence score of this corroboration.
   * </pre>
   *
   * <code>optional float score = 4;</code>
   *
   * @return Whether the score field is set.
   */
  @java.lang.Override
  public boolean hasScore() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Confidence score of this corroboration.
   * </pre>
   *
   * <code>optional float score = 4;</code>
   *
   * @return The score.
   */
  @java.lang.Override
  public float getScore() {
    return score_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(1, startIndex_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(2, endIndex_);
    }
    if (getFactIndexesList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(factIndexesMemoizedSerializedSize);
    }
    for (int i = 0; i < factIndexes_.size(); i++) {
      output.writeInt32NoTag(factIndexes_.getInt(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeFloat(4, score_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, startIndex_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, endIndex_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < factIndexes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(factIndexes_.getInt(i));
      }
      size += dataSize;
      if (!getFactIndexesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      factIndexesMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, score_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Claim)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Claim other =
        (com.google.cloud.aiplatform.v1beta1.Claim) obj;

    if (hasStartIndex() != other.hasStartIndex()) return false;
    if (hasStartIndex()) {
      if (getStartIndex() != other.getStartIndex()) return false;
    }
    if (hasEndIndex() != other.hasEndIndex()) return false;
    if (hasEndIndex()) {
      if (getEndIndex() != other.getEndIndex()) return false;
    }
    if (!getFactIndexesList().equals(other.getFactIndexesList())) return false;
    if (hasScore() != other.hasScore()) return false;
    if (hasScore()) {
      if (java.lang.Float.floatToIntBits(getScore())
          != java.lang.Float.floatToIntBits(other.getScore())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartIndex()) {
      hash = (37 * hash) + START_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getStartIndex();
    }
    if (hasEndIndex()) {
      hash = (37 * hash) + END_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getEndIndex();
    }
    if (getFactIndexesCount() > 0) {
      hash = (37 * hash) + FACT_INDEXES_FIELD_NUMBER;
      hash = (53 * hash) + getFactIndexesList().hashCode();
    }
    if (hasScore()) {
      hash = (37 * hash) + SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Claim prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Claim that is extracted from the input text and facts that support it.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Claim}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Claim)
      com.google.cloud.aiplatform.v1beta1.ClaimOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_Claim_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_Claim_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Claim.class,
              com.google.cloud.aiplatform.v1beta1.Claim.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Claim.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      startIndex_ = 0;
      endIndex_ = 0;
      factIndexes_ = emptyIntList();
      score_ = 0F;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_Claim_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Claim getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Claim.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Claim build() {
      com.google.cloud.aiplatform.v1beta1.Claim result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Claim buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Claim result =
          new com.google.cloud.aiplatform.v1beta1.Claim(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Claim result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.startIndex_ = startIndex_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endIndex_ = endIndex_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        factIndexes_.makeImmutable();
        result.factIndexes_ = factIndexes_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.score_ = score_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Claim) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Claim) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Claim other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Claim.getDefaultInstance()) return this;
      if (other.hasStartIndex()) {
        setStartIndex(other.getStartIndex());
      }
      if (other.hasEndIndex()) {
        setEndIndex(other.getEndIndex());
      }
      if (!other.factIndexes_.isEmpty()) {
        if (factIndexes_.isEmpty()) {
          factIndexes_ = other.factIndexes_;
          factIndexes_.makeImmutable();
          bitField0_ |= 0x00000004;
        } else {
          ensureFactIndexesIsMutable();
          factIndexes_.addAll(other.factIndexes_);
        }
        onChanged();
      }
      if (other.hasScore()) {
        setScore(other.getScore());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                startIndex_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                endIndex_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                int v = input.readInt32();
                ensureFactIndexesIsMutable();
                factIndexes_.addInt(v);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureFactIndexesIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  factIndexes_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 26
            case 37:
              {
                score_ = input.readFloat();
                bitField0_ |= 0x00000008;
                break;
              } // case 37
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int startIndex_;

    /**
     *
     *
     * <pre>
     * Index in the input text where the claim starts (inclusive).
     * </pre>
     *
     * <code>optional int32 start_index = 1;</code>
     *
     * @return Whether the startIndex field is set.
     */
    @java.lang.Override
    public boolean hasStartIndex() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Index in the input text where the claim starts (inclusive).
     * </pre>
     *
     * <code>optional int32 start_index = 1;</code>
     *
     * @return The startIndex.
     */
    @java.lang.Override
    public int getStartIndex() {
      return startIndex_;
    }

    /**
     *
     *
     * <pre>
     * Index in the input text where the claim starts (inclusive).
     * </pre>
     *
     * <code>optional int32 start_index = 1;</code>
     *
     * @param value The startIndex to set.
     * @return This builder for chaining.
     */
    public Builder setStartIndex(int value) {

      startIndex_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Index in the input text where the claim starts (inclusive).
     * </pre>
     *
     * <code>optional int32 start_index = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartIndex() {
      bitField0_ = (bitField0_ & ~0x00000001);
      startIndex_ = 0;
      onChanged();
      return this;
    }

    private int endIndex_;

    /**
     *
     *
     * <pre>
     * Index in the input text where the claim ends (exclusive).
     * </pre>
     *
     * <code>optional int32 end_index = 2;</code>
     *
     * @return Whether the endIndex field is set.
     */
    @java.lang.Override
    public boolean hasEndIndex() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Index in the input text where the claim ends (exclusive).
     * </pre>
     *
     * <code>optional int32 end_index = 2;</code>
     *
     * @return The endIndex.
     */
    @java.lang.Override
    public int getEndIndex() {
      return endIndex_;
    }

    /**
     *
     *
     * <pre>
     * Index in the input text where the claim ends (exclusive).
     * </pre>
     *
     * <code>optional int32 end_index = 2;</code>
     *
     * @param value The endIndex to set.
     * @return This builder for chaining.
     */
    public Builder setEndIndex(int value) {

      endIndex_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Index in the input text where the claim ends (exclusive).
     * </pre>
     *
     * <code>optional int32 end_index = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndIndex() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endIndex_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList factIndexes_ = emptyIntList();

    private void ensureFactIndexesIsMutable() {
      if (!factIndexes_.isModifiable()) {
        factIndexes_ = makeMutableCopy(factIndexes_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Indexes of the facts supporting this claim.
     * </pre>
     *
     * <code>repeated int32 fact_indexes = 3;</code>
     *
     * @return A list containing the factIndexes.
     */
    public java.util.List<java.lang.Integer> getFactIndexesList() {
      factIndexes_.makeImmutable();
      return factIndexes_;
    }

    /**
     *
     *
     * <pre>
     * Indexes of the facts supporting this claim.
     * </pre>
     *
     * <code>repeated int32 fact_indexes = 3;</code>
     *
     * @return The count of factIndexes.
     */
    public int getFactIndexesCount() {
      return factIndexes_.size();
    }

    /**
     *
     *
     * <pre>
     * Indexes of the facts supporting this claim.
     * </pre>
     *
     * <code>repeated int32 fact_indexes = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The factIndexes at the given index.
     */
    public int getFactIndexes(int index) {
      return factIndexes_.getInt(index);
    }

    /**
     *
     *
     * <pre>
     * Indexes of the facts supporting this claim.
     * </pre>
     *
     * <code>repeated int32 fact_indexes = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The factIndexes to set.
     * @return This builder for chaining.
     */
    public Builder setFactIndexes(int index, int value) {

      ensureFactIndexesIsMutable();
      factIndexes_.setInt(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indexes of the facts supporting this claim.
     * </pre>
     *
     * <code>repeated int32 fact_indexes = 3;</code>
     *
     * @param value The factIndexes to add.
     * @return This builder for chaining.
     */
    public Builder addFactIndexes(int value) {

      ensureFactIndexesIsMutable();
      factIndexes_.addInt(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indexes of the facts supporting this claim.
     * </pre>
     *
     * <code>repeated int32 fact_indexes = 3;</code>
     *
     * @param values The factIndexes to add.
     * @return This builder for chaining.
     */
    public Builder addAllFactIndexes(java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureFactIndexesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, factIndexes_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indexes of the facts supporting this claim.
     * </pre>
     *
     * <code>repeated int32 fact_indexes = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFactIndexes() {
      factIndexes_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    private float score_;

    /**
     *
     *
     * <pre>
     * Confidence score of this corroboration.
     * </pre>
     *
     * <code>optional float score = 4;</code>
     *
     * @return Whether the score field is set.
     */
    @java.lang.Override
    public boolean hasScore() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Confidence score of this corroboration.
     * </pre>
     *
     * <code>optional float score = 4;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public float getScore() {
      return score_;
    }

    /**
     *
     *
     * <pre>
     * Confidence score of this corroboration.
     * </pre>
     *
     * <code>optional float score = 4;</code>
     *
     * @param value The score to set.
     * @return This builder for chaining.
     */
    public Builder setScore(float value) {

      score_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Confidence score of this corroboration.
     * </pre>
     *
     * <code>optional float score = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScore() {
      bitField0_ = (bitField0_ & ~0x00000008);
      score_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Claim)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Claim)
  private static final com.google.cloud.aiplatform.v1beta1.Claim DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Claim();
  }

  public static com.google.cloud.aiplatform.v1beta1.Claim getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Claim> PARSER =
      new com.google.protobuf.AbstractParser<Claim>() {
        @java.lang.Override
        public Claim parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Claim> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Claim> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Claim getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
