/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/content.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Generation config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerationConfig}
 */
public final class GenerationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerationConfig)
    GenerationConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GenerationConfig.newBuilder() to construct.
  private GenerationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerationConfig() {
    stopSequences_ = com.google.protobuf.LazyStringArrayList.emptyList();
    responseMimeType_ = "";
    responseModalities_ = java.util.Collections.emptyList();
    mediaResolution_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerationConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ContentProto
        .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ContentProto
        .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.class,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The modalities of the response.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.GenerationConfig.Modality}
   */
  public enum Modality implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified modality. Will be processed as text.
     * </pre>
     *
     * <code>MODALITY_UNSPECIFIED = 0;</code>
     */
    MODALITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Text modality.
     * </pre>
     *
     * <code>TEXT = 1;</code>
     */
    TEXT(1),
    /**
     *
     *
     * <pre>
     * Image modality.
     * </pre>
     *
     * <code>IMAGE = 2;</code>
     */
    IMAGE(2),
    /**
     *
     *
     * <pre>
     * Audio modality.
     * </pre>
     *
     * <code>AUDIO = 3;</code>
     */
    AUDIO(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified modality. Will be processed as text.
     * </pre>
     *
     * <code>MODALITY_UNSPECIFIED = 0;</code>
     */
    public static final int MODALITY_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Text modality.
     * </pre>
     *
     * <code>TEXT = 1;</code>
     */
    public static final int TEXT_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Image modality.
     * </pre>
     *
     * <code>IMAGE = 2;</code>
     */
    public static final int IMAGE_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Audio modality.
     * </pre>
     *
     * <code>AUDIO = 3;</code>
     */
    public static final int AUDIO_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Modality valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Modality forNumber(int value) {
      switch (value) {
        case 0:
          return MODALITY_UNSPECIFIED;
        case 1:
          return TEXT;
        case 2:
          return IMAGE;
        case 3:
          return AUDIO;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Modality> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Modality> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Modality>() {
          public Modality findValueByNumber(int number) {
            return Modality.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Modality[] VALUES = values();

    public static Modality valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Modality(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.Modality)
  }

  /**
   *
   *
   * <pre>
   * Media resolution for the input media.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution}
   */
  public enum MediaResolution implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Media resolution has not been set.
     * </pre>
     *
     * <code>MEDIA_RESOLUTION_UNSPECIFIED = 0;</code>
     */
    MEDIA_RESOLUTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Media resolution set to low (64 tokens).
     * </pre>
     *
     * <code>MEDIA_RESOLUTION_LOW = 1;</code>
     */
    MEDIA_RESOLUTION_LOW(1),
    /**
     *
     *
     * <pre>
     * Media resolution set to medium (256 tokens).
     * </pre>
     *
     * <code>MEDIA_RESOLUTION_MEDIUM = 2;</code>
     */
    MEDIA_RESOLUTION_MEDIUM(2),
    /**
     *
     *
     * <pre>
     * Media resolution set to high (zoomed reframing with 256 tokens).
     * </pre>
     *
     * <code>MEDIA_RESOLUTION_HIGH = 3;</code>
     */
    MEDIA_RESOLUTION_HIGH(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Media resolution has not been set.
     * </pre>
     *
     * <code>MEDIA_RESOLUTION_UNSPECIFIED = 0;</code>
     */
    public static final int MEDIA_RESOLUTION_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Media resolution set to low (64 tokens).
     * </pre>
     *
     * <code>MEDIA_RESOLUTION_LOW = 1;</code>
     */
    public static final int MEDIA_RESOLUTION_LOW_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Media resolution set to medium (256 tokens).
     * </pre>
     *
     * <code>MEDIA_RESOLUTION_MEDIUM = 2;</code>
     */
    public static final int MEDIA_RESOLUTION_MEDIUM_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Media resolution set to high (zoomed reframing with 256 tokens).
     * </pre>
     *
     * <code>MEDIA_RESOLUTION_HIGH = 3;</code>
     */
    public static final int MEDIA_RESOLUTION_HIGH_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MediaResolution valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MediaResolution forNumber(int value) {
      switch (value) {
        case 0:
          return MEDIA_RESOLUTION_UNSPECIFIED;
        case 1:
          return MEDIA_RESOLUTION_LOW;
        case 2:
          return MEDIA_RESOLUTION_MEDIUM;
        case 3:
          return MEDIA_RESOLUTION_HIGH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MediaResolution> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MediaResolution>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MediaResolution>() {
              public MediaResolution findValueByNumber(int number) {
                return MediaResolution.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final MediaResolution[] VALUES = values();

    public static MediaResolution valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MediaResolution(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution)
  }

  public interface RoutingConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Automated routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
     * </code>
     *
     * @return Whether the autoMode field is set.
     */
    boolean hasAutoMode();

    /**
     *
     *
     * <pre>
     * Automated routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
     * </code>
     *
     * @return The autoMode.
     */
    com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
        getAutoMode();

    /**
     *
     *
     * <pre>
     * Automated routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingModeOrBuilder
        getAutoModeOrBuilder();

    /**
     *
     *
     * <pre>
     * Manual routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
     * </code>
     *
     * @return Whether the manualMode field is set.
     */
    boolean hasManualMode();

    /**
     *
     *
     * <pre>
     * Manual routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
     * </code>
     *
     * @return The manualMode.
     */
    com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
        getManualMode();

    /**
     *
     *
     * <pre>
     * Manual routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingModeOrBuilder
        getManualModeOrBuilder();

    com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.RoutingConfigCase
        getRoutingConfigCase();
  }

  /**
   *
   *
   * <pre>
   * The configuration for routing the request to a specific model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig}
   */
  public static final class RoutingConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig)
      RoutingConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use RoutingConfig.newBuilder() to construct.
    private RoutingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RoutingConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RoutingConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.class,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.Builder.class);
    }

    public interface AutoRoutingModeOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The model routing preference.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
       * </code>
       *
       * @return Whether the modelRoutingPreference field is set.
       */
      boolean hasModelRoutingPreference();

      /**
       *
       *
       * <pre>
       * The model routing preference.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for modelRoutingPreference.
       */
      int getModelRoutingPreferenceValue();

      /**
       *
       *
       * <pre>
       * The model routing preference.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
       * </code>
       *
       * @return The modelRoutingPreference.
       */
      com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              .ModelRoutingPreference
          getModelRoutingPreference();
    }

    /**
     *
     *
     * <pre>
     * When automated routing is specified, the routing will be determined by
     * the pretrained routing model and customer provided model routing
     * preference.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode}
     */
    public static final class AutoRoutingMode extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)
        AutoRoutingModeOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use AutoRoutingMode.newBuilder() to construct.
      private AutoRoutingMode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AutoRoutingMode() {
        modelRoutingPreference_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AutoRoutingMode();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_AutoRoutingMode_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_AutoRoutingMode_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                    .class,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                    .Builder.class);
      }

      /**
       *
       *
       * <pre>
       * The model routing preference.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference}
       */
      public enum ModelRoutingPreference implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified model routing preference.
         * </pre>
         *
         * <code>UNKNOWN = 0;</code>
         */
        UNKNOWN(0),
        /**
         *
         *
         * <pre>
         * Prefer higher quality over low cost.
         * </pre>
         *
         * <code>PRIORITIZE_QUALITY = 1;</code>
         */
        PRIORITIZE_QUALITY(1),
        /**
         *
         *
         * <pre>
         * Balanced model routing preference.
         * </pre>
         *
         * <code>BALANCED = 2;</code>
         */
        BALANCED(2),
        /**
         *
         *
         * <pre>
         * Prefer lower cost over higher quality.
         * </pre>
         *
         * <code>PRIORITIZE_COST = 3;</code>
         */
        PRIORITIZE_COST(3),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified model routing preference.
         * </pre>
         *
         * <code>UNKNOWN = 0;</code>
         */
        public static final int UNKNOWN_VALUE = 0;

        /**
         *
         *
         * <pre>
         * Prefer higher quality over low cost.
         * </pre>
         *
         * <code>PRIORITIZE_QUALITY = 1;</code>
         */
        public static final int PRIORITIZE_QUALITY_VALUE = 1;

        /**
         *
         *
         * <pre>
         * Balanced model routing preference.
         * </pre>
         *
         * <code>BALANCED = 2;</code>
         */
        public static final int BALANCED_VALUE = 2;

        /**
         *
         *
         * <pre>
         * Prefer lower cost over higher quality.
         * </pre>
         *
         * <code>PRIORITIZE_COST = 3;</code>
         */
        public static final int PRIORITIZE_COST_VALUE = 3;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ModelRoutingPreference valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static ModelRoutingPreference forNumber(int value) {
          switch (value) {
            case 0:
              return UNKNOWN;
            case 1:
              return PRIORITIZE_QUALITY;
            case 2:
              return BALANCED;
            case 3:
              return PRIORITIZE_COST;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ModelRoutingPreference>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<ModelRoutingPreference>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<ModelRoutingPreference>() {
                  public ModelRoutingPreference findValueByNumber(int number) {
                    return ModelRoutingPreference.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              .getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final ModelRoutingPreference[] VALUES = values();

        public static ModelRoutingPreference valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private ModelRoutingPreference(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference)
      }

      private int bitField0_;
      public static final int MODEL_ROUTING_PREFERENCE_FIELD_NUMBER = 1;
      private int modelRoutingPreference_ = 0;

      /**
       *
       *
       * <pre>
       * The model routing preference.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
       * </code>
       *
       * @return Whether the modelRoutingPreference field is set.
       */
      @java.lang.Override
      public boolean hasModelRoutingPreference() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The model routing preference.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for modelRoutingPreference.
       */
      @java.lang.Override
      public int getModelRoutingPreferenceValue() {
        return modelRoutingPreference_;
      }

      /**
       *
       *
       * <pre>
       * The model routing preference.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
       * </code>
       *
       * @return The modelRoutingPreference.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              .ModelRoutingPreference
          getModelRoutingPreference() {
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                .ModelRoutingPreference
            result =
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                    .ModelRoutingPreference.forNumber(modelRoutingPreference_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                .ModelRoutingPreference.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeEnum(1, modelRoutingPreference_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, modelRoutingPreference_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode other =
            (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)
                obj;

        if (hasModelRoutingPreference() != other.hasModelRoutingPreference()) return false;
        if (hasModelRoutingPreference()) {
          if (modelRoutingPreference_ != other.modelRoutingPreference_) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasModelRoutingPreference()) {
          hash = (37 * hash) + MODEL_ROUTING_PREFERENCE_FIELD_NUMBER;
          hash = (53 * hash) + modelRoutingPreference_;
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * When automated routing is specified, the routing will be determined by
       * the pretrained routing model and customer provided model routing
       * preference.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingModeOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ContentProto
              .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_AutoRoutingMode_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.ContentProto
              .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_AutoRoutingMode_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                      .class,
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          modelRoutingPreference_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.ContentProto
              .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_AutoRoutingMode_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
            build() {
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              result =
                  new com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                      .AutoRoutingMode(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.modelRoutingPreference_ = modelRoutingPreference_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                  .getDefaultInstance()) return this;
          if (other.hasModelRoutingPreference()) {
            setModelRoutingPreference(other.getModelRoutingPreference());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    modelRoutingPreference_ = input.readEnum();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int modelRoutingPreference_ = 0;

        /**
         *
         *
         * <pre>
         * The model routing preference.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
         * </code>
         *
         * @return Whether the modelRoutingPreference field is set.
         */
        @java.lang.Override
        public boolean hasModelRoutingPreference() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * The model routing preference.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for modelRoutingPreference.
         */
        @java.lang.Override
        public int getModelRoutingPreferenceValue() {
          return modelRoutingPreference_;
        }

        /**
         *
         *
         * <pre>
         * The model routing preference.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
         * </code>
         *
         * @param value The enum numeric value on the wire for modelRoutingPreference to set.
         * @return This builder for chaining.
         */
        public Builder setModelRoutingPreferenceValue(int value) {
          modelRoutingPreference_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The model routing preference.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
         * </code>
         *
         * @return The modelRoutingPreference.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                .ModelRoutingPreference
            getModelRoutingPreference() {
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                  .ModelRoutingPreference
              result =
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                      .ModelRoutingPreference.forNumber(modelRoutingPreference_);
          return result == null
              ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                  .ModelRoutingPreference.UNRECOGNIZED
              : result;
        }

        /**
         *
         *
         * <pre>
         * The model routing preference.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
         * </code>
         *
         * @param value The modelRoutingPreference to set.
         * @return This builder for chaining.
         */
        public Builder setModelRoutingPreference(
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                    .ModelRoutingPreference
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          modelRoutingPreference_ = value.getNumber();
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The model routing preference.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference model_routing_preference = 1;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearModelRoutingPreference() {
          bitField0_ = (bitField0_ & ~0x00000001);
          modelRoutingPreference_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)
      private static final com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                .AutoRoutingMode();
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingMode
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AutoRoutingMode> PARSER =
          new com.google.protobuf.AbstractParser<AutoRoutingMode>() {
            @java.lang.Override
            public AutoRoutingMode parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AutoRoutingMode> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AutoRoutingMode> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ManualRoutingModeOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The model name to use. Only the public LLM models are accepted. e.g.
       * 'gemini-1.5-pro-001'.
       * </pre>
       *
       * <code>optional string model_name = 1;</code>
       *
       * @return Whether the modelName field is set.
       */
      boolean hasModelName();

      /**
       *
       *
       * <pre>
       * The model name to use. Only the public LLM models are accepted. e.g.
       * 'gemini-1.5-pro-001'.
       * </pre>
       *
       * <code>optional string model_name = 1;</code>
       *
       * @return The modelName.
       */
      java.lang.String getModelName();

      /**
       *
       *
       * <pre>
       * The model name to use. Only the public LLM models are accepted. e.g.
       * 'gemini-1.5-pro-001'.
       * </pre>
       *
       * <code>optional string model_name = 1;</code>
       *
       * @return The bytes for modelName.
       */
      com.google.protobuf.ByteString getModelNameBytes();
    }

    /**
     *
     *
     * <pre>
     * When manual routing is set, the specified model will be used directly.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode}
     */
    public static final class ManualRoutingMode extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode)
        ManualRoutingModeOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ManualRoutingMode.newBuilder() to construct.
      private ManualRoutingMode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ManualRoutingMode() {
        modelName_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ManualRoutingMode();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_ManualRoutingMode_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_ManualRoutingMode_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
                    .class,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
                    .Builder.class);
      }

      private int bitField0_;
      public static final int MODEL_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object modelName_ = "";

      /**
       *
       *
       * <pre>
       * The model name to use. Only the public LLM models are accepted. e.g.
       * 'gemini-1.5-pro-001'.
       * </pre>
       *
       * <code>optional string model_name = 1;</code>
       *
       * @return Whether the modelName field is set.
       */
      @java.lang.Override
      public boolean hasModelName() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The model name to use. Only the public LLM models are accepted. e.g.
       * 'gemini-1.5-pro-001'.
       * </pre>
       *
       * <code>optional string model_name = 1;</code>
       *
       * @return The modelName.
       */
      @java.lang.Override
      public java.lang.String getModelName() {
        java.lang.Object ref = modelName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelName_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * The model name to use. Only the public LLM models are accepted. e.g.
       * 'gemini-1.5-pro-001'.
       * </pre>
       *
       * <code>optional string model_name = 1;</code>
       *
       * @return The bytes for modelName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getModelNameBytes() {
        java.lang.Object ref = modelName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelName_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelName_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode other =
            (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode)
                obj;

        if (hasModelName() != other.hasModelName()) return false;
        if (hasModelName()) {
          if (!getModelName().equals(other.getModelName())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasModelName()) {
          hash = (37 * hash) + MODEL_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getModelName().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * When manual routing is set, the specified model will be used directly.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode)
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingModeOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ContentProto
              .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_ManualRoutingMode_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.ContentProto
              .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_ManualRoutingMode_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                      .ManualRoutingMode.class,
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                      .ManualRoutingMode.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          modelName_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.ContentProto
              .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_ManualRoutingMode_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
            build() {
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
              result =
                  new com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                      .ManualRoutingMode(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.modelName_ = modelName_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                  .ManualRoutingMode) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                        .ManualRoutingMode)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                  .ManualRoutingMode.getDefaultInstance()) return this;
          if (other.hasModelName()) {
            modelName_ = other.modelName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    modelName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object modelName_ = "";

        /**
         *
         *
         * <pre>
         * The model name to use. Only the public LLM models are accepted. e.g.
         * 'gemini-1.5-pro-001'.
         * </pre>
         *
         * <code>optional string model_name = 1;</code>
         *
         * @return Whether the modelName field is set.
         */
        public boolean hasModelName() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * The model name to use. Only the public LLM models are accepted. e.g.
         * 'gemini-1.5-pro-001'.
         * </pre>
         *
         * <code>optional string model_name = 1;</code>
         *
         * @return The modelName.
         */
        public java.lang.String getModelName() {
          java.lang.Object ref = modelName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            modelName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The model name to use. Only the public LLM models are accepted. e.g.
         * 'gemini-1.5-pro-001'.
         * </pre>
         *
         * <code>optional string model_name = 1;</code>
         *
         * @return The bytes for modelName.
         */
        public com.google.protobuf.ByteString getModelNameBytes() {
          java.lang.Object ref = modelName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            modelName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The model name to use. Only the public LLM models are accepted. e.g.
         * 'gemini-1.5-pro-001'.
         * </pre>
         *
         * <code>optional string model_name = 1;</code>
         *
         * @param value The modelName to set.
         * @return This builder for chaining.
         */
        public Builder setModelName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          modelName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The model name to use. Only the public LLM models are accepted. e.g.
         * 'gemini-1.5-pro-001'.
         * </pre>
         *
         * <code>optional string model_name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearModelName() {
          modelName_ = getDefaultInstance().getModelName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The model name to use. Only the public LLM models are accepted. e.g.
         * 'gemini-1.5-pro-001'.
         * </pre>
         *
         * <code>optional string model_name = 1;</code>
         *
         * @param value The bytes for modelName to set.
         * @return This builder for chaining.
         */
        public Builder setModelNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          modelName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode)
      private static final com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                .ManualRoutingMode();
      }

      public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ManualRoutingMode> PARSER =
          new com.google.protobuf.AbstractParser<ManualRoutingMode>() {
            @java.lang.Override
            public ManualRoutingMode parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ManualRoutingMode> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ManualRoutingMode> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int routingConfigCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object routingConfig_;

    public enum RoutingConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      AUTO_MODE(1),
      MANUAL_MODE(2),
      ROUTINGCONFIG_NOT_SET(0);
      private final int value;

      private RoutingConfigCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RoutingConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static RoutingConfigCase forNumber(int value) {
        switch (value) {
          case 1:
            return AUTO_MODE;
          case 2:
            return MANUAL_MODE;
          case 0:
            return ROUTINGCONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public RoutingConfigCase getRoutingConfigCase() {
      return RoutingConfigCase.forNumber(routingConfigCase_);
    }

    public static final int AUTO_MODE_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Automated routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
     * </code>
     *
     * @return Whether the autoMode field is set.
     */
    @java.lang.Override
    public boolean hasAutoMode() {
      return routingConfigCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Automated routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
     * </code>
     *
     * @return The autoMode.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
        getAutoMode() {
      if (routingConfigCase_ == 1) {
        return (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)
            routingConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Automated routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
            .AutoRoutingModeOrBuilder
        getAutoModeOrBuilder() {
      if (routingConfigCase_ == 1) {
        return (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)
            routingConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
          .getDefaultInstance();
    }

    public static final int MANUAL_MODE_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Manual routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
     * </code>
     *
     * @return Whether the manualMode field is set.
     */
    @java.lang.Override
    public boolean hasManualMode() {
      return routingConfigCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Manual routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
     * </code>
     *
     * @return The manualMode.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
        getManualMode() {
      if (routingConfigCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                .ManualRoutingMode)
            routingConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Manual routing.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
            .ManualRoutingModeOrBuilder
        getManualModeOrBuilder() {
      if (routingConfigCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                .ManualRoutingMode)
            routingConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (routingConfigCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)
                routingConfig_);
      }
      if (routingConfigCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode)
                routingConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (routingConfigCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode)
                    routingConfig_);
      }
      if (routingConfigCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                        .ManualRoutingMode)
                    routingConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig other =
          (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig) obj;

      if (!getRoutingConfigCase().equals(other.getRoutingConfigCase())) return false;
      switch (routingConfigCase_) {
        case 1:
          if (!getAutoMode().equals(other.getAutoMode())) return false;
          break;
        case 2:
          if (!getManualMode().equals(other.getManualMode())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (routingConfigCase_) {
        case 1:
          hash = (37 * hash) + AUTO_MODE_FIELD_NUMBER;
          hash = (53 * hash) + getAutoMode().hashCode();
          break;
        case 2:
          hash = (37 * hash) + MANUAL_MODE_FIELD_NUMBER;
          hash = (53 * hash) + getManualMode().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The configuration for routing the request to a specific model.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig)
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.class,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (autoModeBuilder_ != null) {
          autoModeBuilder_.clear();
        }
        if (manualModeBuilder_ != null) {
          manualModeBuilder_.clear();
        }
        routingConfigCase_ = 0;
        routingConfig_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_RoutingConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig build() {
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig result =
            new com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig result) {
        result.routingConfigCase_ = routingConfigCase_;
        result.routingConfig_ = this.routingConfig_;
        if (routingConfigCase_ == 1 && autoModeBuilder_ != null) {
          result.routingConfig_ = autoModeBuilder_.build();
        }
        if (routingConfigCase_ == 2 && manualModeBuilder_ != null) {
          result.routingConfig_ = manualModeBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                .getDefaultInstance()) return this;
        switch (other.getRoutingConfigCase()) {
          case AUTO_MODE:
            {
              mergeAutoMode(other.getAutoMode());
              break;
            }
          case MANUAL_MODE:
            {
              mergeManualMode(other.getManualMode());
              break;
            }
          case ROUTINGCONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getAutoModeFieldBuilder().getBuilder(), extensionRegistry);
                  routingConfigCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getManualModeFieldBuilder().getBuilder(), extensionRegistry);
                  routingConfigCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int routingConfigCase_ = 0;
      private java.lang.Object routingConfig_;

      public RoutingConfigCase getRoutingConfigCase() {
        return RoutingConfigCase.forNumber(routingConfigCase_);
      }

      public Builder clearRoutingConfig() {
        routingConfigCase_ = 0;
        routingConfig_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                  .AutoRoutingModeOrBuilder>
          autoModeBuilder_;

      /**
       *
       *
       * <pre>
       * Automated routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
       * </code>
       *
       * @return Whether the autoMode field is set.
       */
      @java.lang.Override
      public boolean hasAutoMode() {
        return routingConfigCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Automated routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
       * </code>
       *
       * @return The autoMode.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
          getAutoMode() {
        if (autoModeBuilder_ == null) {
          if (routingConfigCase_ == 1) {
            return (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                    .AutoRoutingMode)
                routingConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              .getDefaultInstance();
        } else {
          if (routingConfigCase_ == 1) {
            return autoModeBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Automated routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
       * </code>
       */
      public Builder setAutoMode(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              value) {
        if (autoModeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          routingConfig_ = value;
          onChanged();
        } else {
          autoModeBuilder_.setMessage(value);
        }
        routingConfigCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Automated routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
       * </code>
       */
      public Builder setAutoMode(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.Builder
              builderForValue) {
        if (autoModeBuilder_ == null) {
          routingConfig_ = builderForValue.build();
          onChanged();
        } else {
          autoModeBuilder_.setMessage(builderForValue.build());
        }
        routingConfigCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Automated routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
       * </code>
       */
      public Builder mergeAutoMode(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              value) {
        if (autoModeBuilder_ == null) {
          if (routingConfigCase_ == 1
              && routingConfig_
                  != com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                      .AutoRoutingMode.getDefaultInstance()) {
            routingConfig_ =
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                                .AutoRoutingMode)
                            routingConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            routingConfig_ = value;
          }
          onChanged();
        } else {
          if (routingConfigCase_ == 1) {
            autoModeBuilder_.mergeFrom(value);
          } else {
            autoModeBuilder_.setMessage(value);
          }
        }
        routingConfigCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Automated routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
       * </code>
       */
      public Builder clearAutoMode() {
        if (autoModeBuilder_ == null) {
          if (routingConfigCase_ == 1) {
            routingConfigCase_ = 0;
            routingConfig_ = null;
            onChanged();
          }
        } else {
          if (routingConfigCase_ == 1) {
            routingConfigCase_ = 0;
            routingConfig_ = null;
          }
          autoModeBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Automated routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              .Builder
          getAutoModeBuilder() {
        return getAutoModeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Automated routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .AutoRoutingModeOrBuilder
          getAutoModeOrBuilder() {
        if ((routingConfigCase_ == 1) && (autoModeBuilder_ != null)) {
          return autoModeBuilder_.getMessageOrBuilder();
        } else {
          if (routingConfigCase_ == 1) {
            return (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                    .AutoRoutingMode)
                routingConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Automated routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode auto_mode = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                  .AutoRoutingModeOrBuilder>
          getAutoModeFieldBuilder() {
        if (autoModeBuilder_ == null) {
          if (!(routingConfigCase_ == 1)) {
            routingConfig_ =
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                    .getDefaultInstance();
          }
          autoModeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                      .AutoRoutingMode,
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                      .AutoRoutingModeOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                          .AutoRoutingMode)
                      routingConfig_,
                  getParentForChildren(),
                  isClean());
          routingConfig_ = null;
        }
        routingConfigCase_ = 1;
        onChanged();
        return autoModeBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                  .ManualRoutingModeOrBuilder>
          manualModeBuilder_;

      /**
       *
       *
       * <pre>
       * Manual routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
       * </code>
       *
       * @return Whether the manualMode field is set.
       */
      @java.lang.Override
      public boolean hasManualMode() {
        return routingConfigCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Manual routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
       * </code>
       *
       * @return The manualMode.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
          getManualMode() {
        if (manualModeBuilder_ == null) {
          if (routingConfigCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                    .ManualRoutingMode)
                routingConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode.getDefaultInstance();
        } else {
          if (routingConfigCase_ == 2) {
            return manualModeBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Manual routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
       * </code>
       */
      public Builder setManualMode(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
              value) {
        if (manualModeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          routingConfig_ = value;
          onChanged();
        } else {
          manualModeBuilder_.setMessage(value);
        }
        routingConfigCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Manual routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
       * </code>
       */
      public Builder setManualMode(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
                  .Builder
              builderForValue) {
        if (manualModeBuilder_ == null) {
          routingConfig_ = builderForValue.build();
          onChanged();
        } else {
          manualModeBuilder_.setMessage(builderForValue.build());
        }
        routingConfigCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Manual routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
       * </code>
       */
      public Builder mergeManualMode(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
              value) {
        if (manualModeBuilder_ == null) {
          if (routingConfigCase_ == 2
              && routingConfig_
                  != com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                      .ManualRoutingMode.getDefaultInstance()) {
            routingConfig_ =
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                                .ManualRoutingMode)
                            routingConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            routingConfig_ = value;
          }
          onChanged();
        } else {
          if (routingConfigCase_ == 2) {
            manualModeBuilder_.mergeFrom(value);
          } else {
            manualModeBuilder_.setMessage(value);
          }
        }
        routingConfigCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Manual routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
       * </code>
       */
      public Builder clearManualMode() {
        if (manualModeBuilder_ == null) {
          if (routingConfigCase_ == 2) {
            routingConfigCase_ = 0;
            routingConfig_ = null;
            onChanged();
          }
        } else {
          if (routingConfigCase_ == 2) {
            routingConfigCase_ = 0;
            routingConfig_ = null;
          }
          manualModeBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Manual routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
              .Builder
          getManualModeBuilder() {
        return getManualModeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Manual routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingModeOrBuilder
          getManualModeOrBuilder() {
        if ((routingConfigCase_ == 2) && (manualModeBuilder_ != null)) {
          return manualModeBuilder_.getMessageOrBuilder();
        } else {
          if (routingConfigCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                    .ManualRoutingMode)
                routingConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
              .ManualRoutingMode.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Manual routing.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode manual_mode = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                  .ManualRoutingModeOrBuilder>
          getManualModeFieldBuilder() {
        if (manualModeBuilder_ == null) {
          if (!(routingConfigCase_ == 2)) {
            routingConfig_ =
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
                    .getDefaultInstance();
          }
          manualModeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                      .ManualRoutingMode,
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                      .ManualRoutingMode.Builder,
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                      .ManualRoutingModeOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                          .ManualRoutingMode)
                      routingConfig_,
                  getParentForChildren(),
                  isClean());
          routingConfig_ = null;
        }
        routingConfigCase_ = 2;
        onChanged();
        return manualModeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig)
    private static final com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RoutingConfig> PARSER =
        new com.google.protobuf.AbstractParser<RoutingConfig>() {
          @java.lang.Override
          public RoutingConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RoutingConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RoutingConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ThinkingConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Indicates whether to include thoughts in the response.
     * If true, thoughts are returned only when available.
     * </pre>
     *
     * <code>optional bool include_thoughts = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the includeThoughts field is set.
     */
    boolean hasIncludeThoughts();

    /**
     *
     *
     * <pre>
     * Indicates whether to include thoughts in the response.
     * If true, thoughts are returned only when available.
     * </pre>
     *
     * <code>optional bool include_thoughts = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The includeThoughts.
     */
    boolean getIncludeThoughts();

    /**
     *
     *
     * <pre>
     * Optional. Indicates the thinking budget in tokens.
     * This is only applied when enable_thinking is true.
     * </pre>
     *
     * <code>optional int32 thinking_budget = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the thinkingBudget field is set.
     */
    boolean hasThinkingBudget();

    /**
     *
     *
     * <pre>
     * Optional. Indicates the thinking budget in tokens.
     * This is only applied when enable_thinking is true.
     * </pre>
     *
     * <code>optional int32 thinking_budget = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The thinkingBudget.
     */
    int getThinkingBudget();
  }

  /**
   *
   *
   * <pre>
   * Config for thinking features.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig}
   */
  public static final class ThinkingConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig)
      ThinkingConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ThinkingConfig.newBuilder() to construct.
    private ThinkingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ThinkingConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ThinkingConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_ThinkingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_ThinkingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.class,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.Builder.class);
    }

    private int bitField0_;
    public static final int INCLUDE_THOUGHTS_FIELD_NUMBER = 1;
    private boolean includeThoughts_ = false;

    /**
     *
     *
     * <pre>
     * Indicates whether to include thoughts in the response.
     * If true, thoughts are returned only when available.
     * </pre>
     *
     * <code>optional bool include_thoughts = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the includeThoughts field is set.
     */
    @java.lang.Override
    public boolean hasIncludeThoughts() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates whether to include thoughts in the response.
     * If true, thoughts are returned only when available.
     * </pre>
     *
     * <code>optional bool include_thoughts = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The includeThoughts.
     */
    @java.lang.Override
    public boolean getIncludeThoughts() {
      return includeThoughts_;
    }

    public static final int THINKING_BUDGET_FIELD_NUMBER = 3;
    private int thinkingBudget_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Indicates the thinking budget in tokens.
     * This is only applied when enable_thinking is true.
     * </pre>
     *
     * <code>optional int32 thinking_budget = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the thinkingBudget field is set.
     */
    @java.lang.Override
    public boolean hasThinkingBudget() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates the thinking budget in tokens.
     * This is only applied when enable_thinking is true.
     * </pre>
     *
     * <code>optional int32 thinking_budget = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The thinkingBudget.
     */
    @java.lang.Override
    public int getThinkingBudget() {
      return thinkingBudget_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBool(1, includeThoughts_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt32(3, thinkingBudget_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, includeThoughts_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, thinkingBudget_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig other =
          (com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig) obj;

      if (hasIncludeThoughts() != other.hasIncludeThoughts()) return false;
      if (hasIncludeThoughts()) {
        if (getIncludeThoughts() != other.getIncludeThoughts()) return false;
      }
      if (hasThinkingBudget() != other.hasThinkingBudget()) return false;
      if (hasThinkingBudget()) {
        if (getThinkingBudget() != other.getThinkingBudget()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasIncludeThoughts()) {
        hash = (37 * hash) + INCLUDE_THOUGHTS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeThoughts());
      }
      if (hasThinkingBudget()) {
        hash = (37 * hash) + THINKING_BUDGET_FIELD_NUMBER;
        hash = (53 * hash) + getThinkingBudget();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Config for thinking features.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig)
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_ThinkingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_ThinkingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.class,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        includeThoughts_ = false;
        thinkingBudget_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_ThinkingConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig build() {
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig result =
            new com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.includeThoughts_ = includeThoughts_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.thinkingBudget_ = thinkingBudget_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
                .getDefaultInstance()) return this;
        if (other.hasIncludeThoughts()) {
          setIncludeThoughts(other.getIncludeThoughts());
        }
        if (other.hasThinkingBudget()) {
          setThinkingBudget(other.getThinkingBudget());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  includeThoughts_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 24:
                {
                  thinkingBudget_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean includeThoughts_;

      /**
       *
       *
       * <pre>
       * Indicates whether to include thoughts in the response.
       * If true, thoughts are returned only when available.
       * </pre>
       *
       * <code>optional bool include_thoughts = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the includeThoughts field is set.
       */
      @java.lang.Override
      public boolean hasIncludeThoughts() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Indicates whether to include thoughts in the response.
       * If true, thoughts are returned only when available.
       * </pre>
       *
       * <code>optional bool include_thoughts = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The includeThoughts.
       */
      @java.lang.Override
      public boolean getIncludeThoughts() {
        return includeThoughts_;
      }

      /**
       *
       *
       * <pre>
       * Indicates whether to include thoughts in the response.
       * If true, thoughts are returned only when available.
       * </pre>
       *
       * <code>optional bool include_thoughts = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The includeThoughts to set.
       * @return This builder for chaining.
       */
      public Builder setIncludeThoughts(boolean value) {

        includeThoughts_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates whether to include thoughts in the response.
       * If true, thoughts are returned only when available.
       * </pre>
       *
       * <code>optional bool include_thoughts = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIncludeThoughts() {
        bitField0_ = (bitField0_ & ~0x00000001);
        includeThoughts_ = false;
        onChanged();
        return this;
      }

      private int thinkingBudget_;

      /**
       *
       *
       * <pre>
       * Optional. Indicates the thinking budget in tokens.
       * This is only applied when enable_thinking is true.
       * </pre>
       *
       * <code>optional int32 thinking_budget = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the thinkingBudget field is set.
       */
      @java.lang.Override
      public boolean hasThinkingBudget() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Indicates the thinking budget in tokens.
       * This is only applied when enable_thinking is true.
       * </pre>
       *
       * <code>optional int32 thinking_budget = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The thinkingBudget.
       */
      @java.lang.Override
      public int getThinkingBudget() {
        return thinkingBudget_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Indicates the thinking budget in tokens.
       * This is only applied when enable_thinking is true.
       * </pre>
       *
       * <code>optional int32 thinking_budget = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The thinkingBudget to set.
       * @return This builder for chaining.
       */
      public Builder setThinkingBudget(int value) {

        thinkingBudget_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Indicates the thinking budget in tokens.
       * This is only applied when enable_thinking is true.
       * </pre>
       *
       * <code>optional int32 thinking_budget = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearThinkingBudget() {
        bitField0_ = (bitField0_ & ~0x00000002);
        thinkingBudget_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig)
    private static final com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ThinkingConfig> PARSER =
        new com.google.protobuf.AbstractParser<ThinkingConfig>() {
          @java.lang.Override
          public ThinkingConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ThinkingConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ThinkingConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ModelConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Feature selection preference.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference feature_selection_preference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for featureSelectionPreference.
     */
    int getFeatureSelectionPreferenceValue();

    /**
     *
     *
     * <pre>
     * Required. Feature selection preference.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference feature_selection_preference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The featureSelectionPreference.
     */
    com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference
        getFeatureSelectionPreference();
  }

  /**
   *
   *
   * <pre>
   * Config for model selection.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig}
   */
  public static final class ModelConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig)
      ModelConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ModelConfig.newBuilder() to construct.
    private ModelConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ModelConfig() {
      featureSelectionPreference_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ModelConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_ModelConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_ModelConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.class,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Options for feature selection preference.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference}
     */
    public enum FeatureSelectionPreference implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified feature selection preference.
       * </pre>
       *
       * <code>FEATURE_SELECTION_PREFERENCE_UNSPECIFIED = 0;</code>
       */
      FEATURE_SELECTION_PREFERENCE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Prefer higher quality over lower cost.
       * </pre>
       *
       * <code>PRIORITIZE_QUALITY = 1;</code>
       */
      PRIORITIZE_QUALITY(1),
      /**
       *
       *
       * <pre>
       * Balanced feature selection preference.
       * </pre>
       *
       * <code>BALANCED = 2;</code>
       */
      BALANCED(2),
      /**
       *
       *
       * <pre>
       * Prefer lower cost over higher quality.
       * </pre>
       *
       * <code>PRIORITIZE_COST = 3;</code>
       */
      PRIORITIZE_COST(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified feature selection preference.
       * </pre>
       *
       * <code>FEATURE_SELECTION_PREFERENCE_UNSPECIFIED = 0;</code>
       */
      public static final int FEATURE_SELECTION_PREFERENCE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Prefer higher quality over lower cost.
       * </pre>
       *
       * <code>PRIORITIZE_QUALITY = 1;</code>
       */
      public static final int PRIORITIZE_QUALITY_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Balanced feature selection preference.
       * </pre>
       *
       * <code>BALANCED = 2;</code>
       */
      public static final int BALANCED_VALUE = 2;

      /**
       *
       *
       * <pre>
       * Prefer lower cost over higher quality.
       * </pre>
       *
       * <code>PRIORITIZE_COST = 3;</code>
       */
      public static final int PRIORITIZE_COST_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static FeatureSelectionPreference valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static FeatureSelectionPreference forNumber(int value) {
        switch (value) {
          case 0:
            return FEATURE_SELECTION_PREFERENCE_UNSPECIFIED;
          case 1:
            return PRIORITIZE_QUALITY;
          case 2:
            return BALANCED;
          case 3:
            return PRIORITIZE_COST;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<FeatureSelectionPreference>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<FeatureSelectionPreference>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<FeatureSelectionPreference>() {
                public FeatureSelectionPreference findValueByNumber(int number) {
                  return FeatureSelectionPreference.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final FeatureSelectionPreference[] VALUES = values();

      public static FeatureSelectionPreference valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private FeatureSelectionPreference(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference)
    }

    public static final int FEATURE_SELECTION_PREFERENCE_FIELD_NUMBER = 1;
    private int featureSelectionPreference_ = 0;

    /**
     *
     *
     * <pre>
     * Required. Feature selection preference.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference feature_selection_preference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for featureSelectionPreference.
     */
    @java.lang.Override
    public int getFeatureSelectionPreferenceValue() {
      return featureSelectionPreference_;
    }

    /**
     *
     *
     * <pre>
     * Required. Feature selection preference.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference feature_selection_preference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The featureSelectionPreference.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
            .FeatureSelectionPreference
        getFeatureSelectionPreference() {
      com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference
          result =
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
                  .FeatureSelectionPreference.forNumber(featureSelectionPreference_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
              .FeatureSelectionPreference.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (featureSelectionPreference_
          != com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
              .FeatureSelectionPreference.FEATURE_SELECTION_PREFERENCE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, featureSelectionPreference_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (featureSelectionPreference_
          != com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
              .FeatureSelectionPreference.FEATURE_SELECTION_PREFERENCE_UNSPECIFIED
              .getNumber()) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(1, featureSelectionPreference_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig other =
          (com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig) obj;

      if (featureSelectionPreference_ != other.featureSelectionPreference_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FEATURE_SELECTION_PREFERENCE_FIELD_NUMBER;
      hash = (53 * hash) + featureSelectionPreference_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Config for model selection.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig)
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_ModelConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_ModelConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.class,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        featureSelectionPreference_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ContentProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_ModelConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig build() {
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig result =
            new com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.featureSelectionPreference_ = featureSelectionPreference_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
                .getDefaultInstance()) return this;
        if (other.featureSelectionPreference_ != 0) {
          setFeatureSelectionPreferenceValue(other.getFeatureSelectionPreferenceValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  featureSelectionPreference_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int featureSelectionPreference_ = 0;

      /**
       *
       *
       * <pre>
       * Required. Feature selection preference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference feature_selection_preference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for featureSelectionPreference.
       */
      @java.lang.Override
      public int getFeatureSelectionPreferenceValue() {
        return featureSelectionPreference_;
      }

      /**
       *
       *
       * <pre>
       * Required. Feature selection preference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference feature_selection_preference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for featureSelectionPreference to set.
       * @return This builder for chaining.
       */
      public Builder setFeatureSelectionPreferenceValue(int value) {
        featureSelectionPreference_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Feature selection preference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference feature_selection_preference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The featureSelectionPreference.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
              .FeatureSelectionPreference
          getFeatureSelectionPreference() {
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference
            result =
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
                    .FeatureSelectionPreference.forNumber(featureSelectionPreference_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
                .FeatureSelectionPreference.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Required. Feature selection preference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference feature_selection_preference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The featureSelectionPreference to set.
       * @return This builder for chaining.
       */
      public Builder setFeatureSelectionPreference(
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
                  .FeatureSelectionPreference
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        featureSelectionPreference_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Feature selection preference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference feature_selection_preference = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFeatureSelectionPreference() {
        bitField0_ = (bitField0_ & ~0x00000001);
        featureSelectionPreference_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig)
    private static final com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelConfig> PARSER =
        new com.google.protobuf.AbstractParser<ModelConfig>() {
          @java.lang.Override
          public ModelConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ModelConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TEMPERATURE_FIELD_NUMBER = 1;
  private float temperature_ = 0F;

  /**
   *
   *
   * <pre>
   * Optional. Controls the randomness of predictions.
   * </pre>
   *
   * <code>optional float temperature = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the temperature field is set.
   */
  @java.lang.Override
  public boolean hasTemperature() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Controls the randomness of predictions.
   * </pre>
   *
   * <code>optional float temperature = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The temperature.
   */
  @java.lang.Override
  public float getTemperature() {
    return temperature_;
  }

  public static final int TOP_P_FIELD_NUMBER = 2;
  private float topP_ = 0F;

  /**
   *
   *
   * <pre>
   * Optional. If specified, nucleus sampling will be used.
   * </pre>
   *
   * <code>optional float top_p = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the topP field is set.
   */
  @java.lang.Override
  public boolean hasTopP() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If specified, nucleus sampling will be used.
   * </pre>
   *
   * <code>optional float top_p = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The topP.
   */
  @java.lang.Override
  public float getTopP() {
    return topP_;
  }

  public static final int TOP_K_FIELD_NUMBER = 3;
  private float topK_ = 0F;

  /**
   *
   *
   * <pre>
   * Optional. If specified, top-k sampling will be used.
   * </pre>
   *
   * <code>optional float top_k = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the topK field is set.
   */
  @java.lang.Override
  public boolean hasTopK() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If specified, top-k sampling will be used.
   * </pre>
   *
   * <code>optional float top_k = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The topK.
   */
  @java.lang.Override
  public float getTopK() {
    return topK_;
  }

  public static final int CANDIDATE_COUNT_FIELD_NUMBER = 4;
  private int candidateCount_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Number of candidates to generate.
   * </pre>
   *
   * <code>optional int32 candidate_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the candidateCount field is set.
   */
  @java.lang.Override
  public boolean hasCandidateCount() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Number of candidates to generate.
   * </pre>
   *
   * <code>optional int32 candidate_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The candidateCount.
   */
  @java.lang.Override
  public int getCandidateCount() {
    return candidateCount_;
  }

  public static final int MAX_OUTPUT_TOKENS_FIELD_NUMBER = 5;
  private int maxOutputTokens_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The maximum number of output tokens to generate per message.
   * </pre>
   *
   * <code>optional int32 max_output_tokens = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the maxOutputTokens field is set.
   */
  @java.lang.Override
  public boolean hasMaxOutputTokens() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The maximum number of output tokens to generate per message.
   * </pre>
   *
   * <code>optional int32 max_output_tokens = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxOutputTokens.
   */
  @java.lang.Override
  public int getMaxOutputTokens() {
    return maxOutputTokens_;
  }

  public static final int STOP_SEQUENCES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList stopSequences_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. Stop sequences.
   * </pre>
   *
   * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the stopSequences.
   */
  public com.google.protobuf.ProtocolStringList getStopSequencesList() {
    return stopSequences_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Stop sequences.
   * </pre>
   *
   * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of stopSequences.
   */
  public int getStopSequencesCount() {
    return stopSequences_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Stop sequences.
   * </pre>
   *
   * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The stopSequences at the given index.
   */
  public java.lang.String getStopSequences(int index) {
    return stopSequences_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Stop sequences.
   * </pre>
   *
   * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the stopSequences at the given index.
   */
  public com.google.protobuf.ByteString getStopSequencesBytes(int index) {
    return stopSequences_.getByteString(index);
  }

  public static final int RESPONSE_LOGPROBS_FIELD_NUMBER = 18;
  private boolean responseLogprobs_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If true, export the logprobs results in response.
   * </pre>
   *
   * <code>optional bool response_logprobs = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the responseLogprobs field is set.
   */
  @java.lang.Override
  public boolean hasResponseLogprobs() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If true, export the logprobs results in response.
   * </pre>
   *
   * <code>optional bool response_logprobs = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The responseLogprobs.
   */
  @java.lang.Override
  public boolean getResponseLogprobs() {
    return responseLogprobs_;
  }

  public static final int LOGPROBS_FIELD_NUMBER = 7;
  private int logprobs_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Logit probabilities.
   * </pre>
   *
   * <code>optional int32 logprobs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the logprobs field is set.
   */
  @java.lang.Override
  public boolean hasLogprobs() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Logit probabilities.
   * </pre>
   *
   * <code>optional int32 logprobs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The logprobs.
   */
  @java.lang.Override
  public int getLogprobs() {
    return logprobs_;
  }

  public static final int PRESENCE_PENALTY_FIELD_NUMBER = 8;
  private float presencePenalty_ = 0F;

  /**
   *
   *
   * <pre>
   * Optional. Positive penalties.
   * </pre>
   *
   * <code>optional float presence_penalty = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the presencePenalty field is set.
   */
  @java.lang.Override
  public boolean hasPresencePenalty() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Positive penalties.
   * </pre>
   *
   * <code>optional float presence_penalty = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The presencePenalty.
   */
  @java.lang.Override
  public float getPresencePenalty() {
    return presencePenalty_;
  }

  public static final int FREQUENCY_PENALTY_FIELD_NUMBER = 9;
  private float frequencyPenalty_ = 0F;

  /**
   *
   *
   * <pre>
   * Optional. Frequency penalties.
   * </pre>
   *
   * <code>optional float frequency_penalty = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the frequencyPenalty field is set.
   */
  @java.lang.Override
  public boolean hasFrequencyPenalty() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Frequency penalties.
   * </pre>
   *
   * <code>optional float frequency_penalty = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The frequencyPenalty.
   */
  @java.lang.Override
  public float getFrequencyPenalty() {
    return frequencyPenalty_;
  }

  public static final int SEED_FIELD_NUMBER = 12;
  private int seed_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Seed.
   * </pre>
   *
   * <code>optional int32 seed = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the seed field is set.
   */
  @java.lang.Override
  public boolean hasSeed() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Seed.
   * </pre>
   *
   * <code>optional int32 seed = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The seed.
   */
  @java.lang.Override
  public int getSeed() {
    return seed_;
  }

  public static final int RESPONSE_MIME_TYPE_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object responseMimeType_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Output response mimetype of the generated candidate text.
   * Supported mimetype:
   * - `text/plain`: (default) Text output.
   * - `application/json`: JSON response in the candidates.
   * The model needs to be prompted to output the appropriate response type,
   * otherwise the behavior is undefined.
   * This is a preview feature.
   * </pre>
   *
   * <code>string response_mime_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The responseMimeType.
   */
  @java.lang.Override
  public java.lang.String getResponseMimeType() {
    java.lang.Object ref = responseMimeType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      responseMimeType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Output response mimetype of the generated candidate text.
   * Supported mimetype:
   * - `text/plain`: (default) Text output.
   * - `application/json`: JSON response in the candidates.
   * The model needs to be prompted to output the appropriate response type,
   * otherwise the behavior is undefined.
   * This is a preview feature.
   * </pre>
   *
   * <code>string response_mime_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for responseMimeType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResponseMimeTypeBytes() {
    java.lang.Object ref = responseMimeType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      responseMimeType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESPONSE_SCHEMA_FIELD_NUMBER = 16;
  private com.google.cloud.aiplatform.v1beta1.Schema responseSchema_;

  /**
   *
   *
   * <pre>
   * Optional. The `Schema` object allows the definition of input and output
   * data types. These types can be objects, but also primitives and arrays.
   * Represents a select subset of an [OpenAPI 3.0 schema
   * object](https://spec.openapis.org/oas/v3.0.3#schema).
   * If set, a compatible response_mime_type must also be set.
   * Compatible mimetypes:
   * `application/json`: Schema for JSON response.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the responseSchema field is set.
   */
  @java.lang.Override
  public boolean hasResponseSchema() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The `Schema` object allows the definition of input and output
   * data types. These types can be objects, but also primitives and arrays.
   * Represents a select subset of an [OpenAPI 3.0 schema
   * object](https://spec.openapis.org/oas/v3.0.3#schema).
   * If set, a compatible response_mime_type must also be set.
   * Compatible mimetypes:
   * `application/json`: Schema for JSON response.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The responseSchema.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Schema getResponseSchema() {
    return responseSchema_ == null
        ? com.google.cloud.aiplatform.v1beta1.Schema.getDefaultInstance()
        : responseSchema_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The `Schema` object allows the definition of input and output
   * data types. These types can be objects, but also primitives and arrays.
   * Represents a select subset of an [OpenAPI 3.0 schema
   * object](https://spec.openapis.org/oas/v3.0.3#schema).
   * If set, a compatible response_mime_type must also be set.
   * Compatible mimetypes:
   * `application/json`: Schema for JSON response.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SchemaOrBuilder getResponseSchemaOrBuilder() {
    return responseSchema_ == null
        ? com.google.cloud.aiplatform.v1beta1.Schema.getDefaultInstance()
        : responseSchema_;
  }

  public static final int RESPONSE_JSON_SCHEMA_FIELD_NUMBER = 28;
  private com.google.protobuf.Value responseJsonSchema_;

  /**
   *
   *
   * <pre>
   * Optional. Output schema of the generated response. This is an alternative
   * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
   *
   * If set, `response_schema` must be omitted, but `response_mime_type` is
   * required.
   *
   * While the full JSON Schema may be sent, not all features are supported.
   * Specifically, only the following properties are supported:
   *
   * - `$id`
   * - `$defs`
   * - `$ref`
   * - `$anchor`
   * - `type`
   * - `format`
   * - `title`
   * - `description`
   * - `enum` (for strings and numbers)
   * - `items`
   * - `prefixItems`
   * - `minItems`
   * - `maxItems`
   * - `minimum`
   * - `maximum`
   * - `anyOf`
   * - `oneOf` (interpreted the same as `anyOf`)
   * - `properties`
   * - `additionalProperties`
   * - `required`
   *
   * The non-standard `propertyOrdering` property may also be set.
   *
   * Cyclic references are unrolled to a limited degree and, as such, may only
   * be used within non-required properties. (Nullable properties are not
   * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
   * for than those starting as a `$`, may be set.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the responseJsonSchema field is set.
   */
  @java.lang.Override
  public boolean hasResponseJsonSchema() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Output schema of the generated response. This is an alternative
   * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
   *
   * If set, `response_schema` must be omitted, but `response_mime_type` is
   * required.
   *
   * While the full JSON Schema may be sent, not all features are supported.
   * Specifically, only the following properties are supported:
   *
   * - `$id`
   * - `$defs`
   * - `$ref`
   * - `$anchor`
   * - `type`
   * - `format`
   * - `title`
   * - `description`
   * - `enum` (for strings and numbers)
   * - `items`
   * - `prefixItems`
   * - `minItems`
   * - `maxItems`
   * - `minimum`
   * - `maximum`
   * - `anyOf`
   * - `oneOf` (interpreted the same as `anyOf`)
   * - `properties`
   * - `additionalProperties`
   * - `required`
   *
   * The non-standard `propertyOrdering` property may also be set.
   *
   * Cyclic references are unrolled to a limited degree and, as such, may only
   * be used within non-required properties. (Nullable properties are not
   * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
   * for than those starting as a `$`, may be set.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The responseJsonSchema.
   */
  @java.lang.Override
  public com.google.protobuf.Value getResponseJsonSchema() {
    return responseJsonSchema_ == null
        ? com.google.protobuf.Value.getDefaultInstance()
        : responseJsonSchema_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Output schema of the generated response. This is an alternative
   * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
   *
   * If set, `response_schema` must be omitted, but `response_mime_type` is
   * required.
   *
   * While the full JSON Schema may be sent, not all features are supported.
   * Specifically, only the following properties are supported:
   *
   * - `$id`
   * - `$defs`
   * - `$ref`
   * - `$anchor`
   * - `type`
   * - `format`
   * - `title`
   * - `description`
   * - `enum` (for strings and numbers)
   * - `items`
   * - `prefixItems`
   * - `minItems`
   * - `maxItems`
   * - `minimum`
   * - `maximum`
   * - `anyOf`
   * - `oneOf` (interpreted the same as `anyOf`)
   * - `properties`
   * - `additionalProperties`
   * - `required`
   *
   * The non-standard `propertyOrdering` property may also be set.
   *
   * Cyclic references are unrolled to a limited degree and, as such, may only
   * be used within non-required properties. (Nullable properties are not
   * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
   * for than those starting as a `$`, may be set.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getResponseJsonSchemaOrBuilder() {
    return responseJsonSchema_ == null
        ? com.google.protobuf.Value.getDefaultInstance()
        : responseJsonSchema_;
  }

  public static final int ROUTING_CONFIG_FIELD_NUMBER = 17;
  private com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routingConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Routing configuration.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the routingConfig field is set.
   */
  @java.lang.Override
  public boolean hasRoutingConfig() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Routing configuration.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The routingConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig getRoutingConfig() {
    return routingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.getDefaultInstance()
        : routingConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Routing configuration.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfigOrBuilder
      getRoutingConfigOrBuilder() {
    return routingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.getDefaultInstance()
        : routingConfig_;
  }

  public static final int AUDIO_TIMESTAMP_FIELD_NUMBER = 20;
  private boolean audioTimestamp_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If enabled, audio timestamp will be included in the request to
   * the model.
   * </pre>
   *
   * <code>optional bool audio_timestamp = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the audioTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasAudioTimestamp() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If enabled, audio timestamp will be included in the request to
   * the model.
   * </pre>
   *
   * <code>optional bool audio_timestamp = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The audioTimestamp.
   */
  @java.lang.Override
  public boolean getAudioTimestamp() {
    return audioTimestamp_;
  }

  public static final int RESPONSE_MODALITIES_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> responseModalities_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality>
      responseModalities_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality>() {
            public com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality convert(
                java.lang.Integer from) {
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality result =
                  com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality.forNumber(from);
              return result == null
                  ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Optional. The modalities of the response.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the responseModalities.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality>
      getResponseModalitiesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality>(
        responseModalities_, responseModalities_converter_);
  }

  /**
   *
   *
   * <pre>
   * Optional. The modalities of the response.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of responseModalities.
   */
  @java.lang.Override
  public int getResponseModalitiesCount() {
    return responseModalities_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The modalities of the response.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The responseModalities at the given index.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality getResponseModalities(
      int index) {
    return responseModalities_converter_.convert(responseModalities_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Optional. The modalities of the response.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for responseModalities.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getResponseModalitiesValueList() {
    return responseModalities_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The modalities of the response.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of responseModalities at the given index.
   */
  @java.lang.Override
  public int getResponseModalitiesValue(int index) {
    return responseModalities_.get(index);
  }

  private int responseModalitiesMemoizedSerializedSize;

  public static final int MEDIA_RESOLUTION_FIELD_NUMBER = 22;
  private int mediaResolution_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. If specified, the media resolution specified will be used.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution media_resolution = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the mediaResolution field is set.
   */
  @java.lang.Override
  public boolean hasMediaResolution() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If specified, the media resolution specified will be used.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution media_resolution = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for mediaResolution.
   */
  @java.lang.Override
  public int getMediaResolutionValue() {
    return mediaResolution_;
  }

  /**
   *
   *
   * <pre>
   * Optional. If specified, the media resolution specified will be used.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution media_resolution = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The mediaResolution.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution getMediaResolution() {
    com.google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution result =
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution.forNumber(
            mediaResolution_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution.UNRECOGNIZED
        : result;
  }

  public static final int SPEECH_CONFIG_FIELD_NUMBER = 23;
  private com.google.cloud.aiplatform.v1beta1.SpeechConfig speechConfig_;

  /**
   *
   *
   * <pre>
   * Optional. The speech generation config.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the speechConfig field is set.
   */
  @java.lang.Override
  public boolean hasSpeechConfig() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The speech generation config.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The speechConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SpeechConfig getSpeechConfig() {
    return speechConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.SpeechConfig.getDefaultInstance()
        : speechConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The speech generation config.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SpeechConfigOrBuilder getSpeechConfigOrBuilder() {
    return speechConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.SpeechConfig.getDefaultInstance()
        : speechConfig_;
  }

  public static final int THINKING_CONFIG_FIELD_NUMBER = 25;
  private com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinkingConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Config for thinking features.
   * An error will be returned if this field is set for models that don't
   * support thinking.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the thinkingConfig field is set.
   */
  @java.lang.Override
  public boolean hasThinkingConfig() {
    return ((bitField0_ & 0x00010000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for thinking features.
   * An error will be returned if this field is set for models that don't
   * support thinking.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The thinkingConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig getThinkingConfig() {
    return thinkingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.getDefaultInstance()
        : thinkingConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for thinking features.
   * An error will be returned if this field is set for models that don't
   * support thinking.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfigOrBuilder
      getThinkingConfigOrBuilder() {
    return thinkingConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.getDefaultInstance()
        : thinkingConfig_;
  }

  public static final int MODEL_CONFIG_FIELD_NUMBER = 27;
  private com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig modelConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Config for model selection.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the modelConfig field is set.
   */
  @java.lang.Override
  public boolean hasModelConfig() {
    return ((bitField0_ & 0x00020000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for model selection.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The modelConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig getModelConfig() {
    return modelConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.getDefaultInstance()
        : modelConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for model selection.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfigOrBuilder
      getModelConfigOrBuilder() {
    return modelConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.getDefaultInstance()
        : modelConfig_;
  }

  public static final int IMAGE_CONFIG_FIELD_NUMBER = 30;
  private com.google.cloud.aiplatform.v1beta1.ImageConfig imageConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Config for image generation features.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the imageConfig field is set.
   */
  @java.lang.Override
  public boolean hasImageConfig() {
    return ((bitField0_ & 0x00040000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for image generation features.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The imageConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ImageConfig getImageConfig() {
    return imageConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ImageConfig.getDefaultInstance()
        : imageConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Config for image generation features.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ImageConfigOrBuilder getImageConfigOrBuilder() {
    return imageConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ImageConfig.getDefaultInstance()
        : imageConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeFloat(1, temperature_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeFloat(2, topP_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeFloat(3, topK_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt32(4, candidateCount_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(5, maxOutputTokens_);
    }
    for (int i = 0; i < stopSequences_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, stopSequences_.getRaw(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt32(7, logprobs_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeFloat(8, presencePenalty_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeFloat(9, frequencyPenalty_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeInt32(12, seed_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseMimeType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, responseMimeType_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(16, getResponseSchema());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(17, getRoutingConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeBool(18, responseLogprobs_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeBool(20, audioTimestamp_);
    }
    if (getResponseModalitiesList().size() > 0) {
      output.writeUInt32NoTag(170);
      output.writeUInt32NoTag(responseModalitiesMemoizedSerializedSize);
    }
    for (int i = 0; i < responseModalities_.size(); i++) {
      output.writeEnumNoTag(responseModalities_.get(i));
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeEnum(22, mediaResolution_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeMessage(23, getSpeechConfig());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeMessage(25, getThinkingConfig());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeMessage(27, getModelConfig());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(28, getResponseJsonSchema());
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeMessage(30, getImageConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, temperature_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, topP_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, topK_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, candidateCount_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, maxOutputTokens_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < stopSequences_.size(); i++) {
        dataSize += computeStringSizeNoTag(stopSequences_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getStopSequencesList().size();
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, logprobs_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(8, presencePenalty_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(9, frequencyPenalty_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(12, seed_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseMimeType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, responseMimeType_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getResponseSchema());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getRoutingConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(18, responseLogprobs_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(20, audioTimestamp_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < responseModalities_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(responseModalities_.get(i));
      }
      size += dataSize;
      if (!getResponseModalitiesList().isEmpty()) {
        size += 2;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      responseModalitiesMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(22, mediaResolution_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getSpeechConfig());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, getThinkingConfig());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(27, getModelConfig());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(28, getResponseJsonSchema());
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(30, getImageConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GenerationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.GenerationConfig other =
        (com.google.cloud.aiplatform.v1beta1.GenerationConfig) obj;

    if (hasTemperature() != other.hasTemperature()) return false;
    if (hasTemperature()) {
      if (java.lang.Float.floatToIntBits(getTemperature())
          != java.lang.Float.floatToIntBits(other.getTemperature())) return false;
    }
    if (hasTopP() != other.hasTopP()) return false;
    if (hasTopP()) {
      if (java.lang.Float.floatToIntBits(getTopP())
          != java.lang.Float.floatToIntBits(other.getTopP())) return false;
    }
    if (hasTopK() != other.hasTopK()) return false;
    if (hasTopK()) {
      if (java.lang.Float.floatToIntBits(getTopK())
          != java.lang.Float.floatToIntBits(other.getTopK())) return false;
    }
    if (hasCandidateCount() != other.hasCandidateCount()) return false;
    if (hasCandidateCount()) {
      if (getCandidateCount() != other.getCandidateCount()) return false;
    }
    if (hasMaxOutputTokens() != other.hasMaxOutputTokens()) return false;
    if (hasMaxOutputTokens()) {
      if (getMaxOutputTokens() != other.getMaxOutputTokens()) return false;
    }
    if (!getStopSequencesList().equals(other.getStopSequencesList())) return false;
    if (hasResponseLogprobs() != other.hasResponseLogprobs()) return false;
    if (hasResponseLogprobs()) {
      if (getResponseLogprobs() != other.getResponseLogprobs()) return false;
    }
    if (hasLogprobs() != other.hasLogprobs()) return false;
    if (hasLogprobs()) {
      if (getLogprobs() != other.getLogprobs()) return false;
    }
    if (hasPresencePenalty() != other.hasPresencePenalty()) return false;
    if (hasPresencePenalty()) {
      if (java.lang.Float.floatToIntBits(getPresencePenalty())
          != java.lang.Float.floatToIntBits(other.getPresencePenalty())) return false;
    }
    if (hasFrequencyPenalty() != other.hasFrequencyPenalty()) return false;
    if (hasFrequencyPenalty()) {
      if (java.lang.Float.floatToIntBits(getFrequencyPenalty())
          != java.lang.Float.floatToIntBits(other.getFrequencyPenalty())) return false;
    }
    if (hasSeed() != other.hasSeed()) return false;
    if (hasSeed()) {
      if (getSeed() != other.getSeed()) return false;
    }
    if (!getResponseMimeType().equals(other.getResponseMimeType())) return false;
    if (hasResponseSchema() != other.hasResponseSchema()) return false;
    if (hasResponseSchema()) {
      if (!getResponseSchema().equals(other.getResponseSchema())) return false;
    }
    if (hasResponseJsonSchema() != other.hasResponseJsonSchema()) return false;
    if (hasResponseJsonSchema()) {
      if (!getResponseJsonSchema().equals(other.getResponseJsonSchema())) return false;
    }
    if (hasRoutingConfig() != other.hasRoutingConfig()) return false;
    if (hasRoutingConfig()) {
      if (!getRoutingConfig().equals(other.getRoutingConfig())) return false;
    }
    if (hasAudioTimestamp() != other.hasAudioTimestamp()) return false;
    if (hasAudioTimestamp()) {
      if (getAudioTimestamp() != other.getAudioTimestamp()) return false;
    }
    if (!responseModalities_.equals(other.responseModalities_)) return false;
    if (hasMediaResolution() != other.hasMediaResolution()) return false;
    if (hasMediaResolution()) {
      if (mediaResolution_ != other.mediaResolution_) return false;
    }
    if (hasSpeechConfig() != other.hasSpeechConfig()) return false;
    if (hasSpeechConfig()) {
      if (!getSpeechConfig().equals(other.getSpeechConfig())) return false;
    }
    if (hasThinkingConfig() != other.hasThinkingConfig()) return false;
    if (hasThinkingConfig()) {
      if (!getThinkingConfig().equals(other.getThinkingConfig())) return false;
    }
    if (hasModelConfig() != other.hasModelConfig()) return false;
    if (hasModelConfig()) {
      if (!getModelConfig().equals(other.getModelConfig())) return false;
    }
    if (hasImageConfig() != other.hasImageConfig()) return false;
    if (hasImageConfig()) {
      if (!getImageConfig().equals(other.getImageConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTemperature()) {
      hash = (37 * hash) + TEMPERATURE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getTemperature());
    }
    if (hasTopP()) {
      hash = (37 * hash) + TOP_P_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getTopP());
    }
    if (hasTopK()) {
      hash = (37 * hash) + TOP_K_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getTopK());
    }
    if (hasCandidateCount()) {
      hash = (37 * hash) + CANDIDATE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getCandidateCount();
    }
    if (hasMaxOutputTokens()) {
      hash = (37 * hash) + MAX_OUTPUT_TOKENS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxOutputTokens();
    }
    if (getStopSequencesCount() > 0) {
      hash = (37 * hash) + STOP_SEQUENCES_FIELD_NUMBER;
      hash = (53 * hash) + getStopSequencesList().hashCode();
    }
    if (hasResponseLogprobs()) {
      hash = (37 * hash) + RESPONSE_LOGPROBS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getResponseLogprobs());
    }
    if (hasLogprobs()) {
      hash = (37 * hash) + LOGPROBS_FIELD_NUMBER;
      hash = (53 * hash) + getLogprobs();
    }
    if (hasPresencePenalty()) {
      hash = (37 * hash) + PRESENCE_PENALTY_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getPresencePenalty());
    }
    if (hasFrequencyPenalty()) {
      hash = (37 * hash) + FREQUENCY_PENALTY_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getFrequencyPenalty());
    }
    if (hasSeed()) {
      hash = (37 * hash) + SEED_FIELD_NUMBER;
      hash = (53 * hash) + getSeed();
    }
    hash = (37 * hash) + RESPONSE_MIME_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getResponseMimeType().hashCode();
    if (hasResponseSchema()) {
      hash = (37 * hash) + RESPONSE_SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getResponseSchema().hashCode();
    }
    if (hasResponseJsonSchema()) {
      hash = (37 * hash) + RESPONSE_JSON_SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getResponseJsonSchema().hashCode();
    }
    if (hasRoutingConfig()) {
      hash = (37 * hash) + ROUTING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRoutingConfig().hashCode();
    }
    if (hasAudioTimestamp()) {
      hash = (37 * hash) + AUDIO_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAudioTimestamp());
    }
    if (getResponseModalitiesCount() > 0) {
      hash = (37 * hash) + RESPONSE_MODALITIES_FIELD_NUMBER;
      hash = (53 * hash) + responseModalities_.hashCode();
    }
    if (hasMediaResolution()) {
      hash = (37 * hash) + MEDIA_RESOLUTION_FIELD_NUMBER;
      hash = (53 * hash) + mediaResolution_;
    }
    if (hasSpeechConfig()) {
      hash = (37 * hash) + SPEECH_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechConfig().hashCode();
    }
    if (hasThinkingConfig()) {
      hash = (37 * hash) + THINKING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getThinkingConfig().hashCode();
    }
    if (hasModelConfig()) {
      hash = (37 * hash) + MODEL_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getModelConfig().hashCode();
    }
    if (hasImageConfig()) {
      hash = (37 * hash) + IMAGE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getImageConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.GenerationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Generation config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerationConfig)
      com.google.cloud.aiplatform.v1beta1.GenerationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.class,
              com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.GenerationConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResponseSchemaFieldBuilder();
        getResponseJsonSchemaFieldBuilder();
        getRoutingConfigFieldBuilder();
        getSpeechConfigFieldBuilder();
        getThinkingConfigFieldBuilder();
        getModelConfigFieldBuilder();
        getImageConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      temperature_ = 0F;
      topP_ = 0F;
      topK_ = 0F;
      candidateCount_ = 0;
      maxOutputTokens_ = 0;
      stopSequences_ = com.google.protobuf.LazyStringArrayList.emptyList();
      responseLogprobs_ = false;
      logprobs_ = 0;
      presencePenalty_ = 0F;
      frequencyPenalty_ = 0F;
      seed_ = 0;
      responseMimeType_ = "";
      responseSchema_ = null;
      if (responseSchemaBuilder_ != null) {
        responseSchemaBuilder_.dispose();
        responseSchemaBuilder_ = null;
      }
      responseJsonSchema_ = null;
      if (responseJsonSchemaBuilder_ != null) {
        responseJsonSchemaBuilder_.dispose();
        responseJsonSchemaBuilder_ = null;
      }
      routingConfig_ = null;
      if (routingConfigBuilder_ != null) {
        routingConfigBuilder_.dispose();
        routingConfigBuilder_ = null;
      }
      audioTimestamp_ = false;
      responseModalities_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      mediaResolution_ = 0;
      speechConfig_ = null;
      if (speechConfigBuilder_ != null) {
        speechConfigBuilder_.dispose();
        speechConfigBuilder_ = null;
      }
      thinkingConfig_ = null;
      if (thinkingConfigBuilder_ != null) {
        thinkingConfigBuilder_.dispose();
        thinkingConfigBuilder_ = null;
      }
      modelConfig_ = null;
      if (modelConfigBuilder_ != null) {
        modelConfigBuilder_.dispose();
        modelConfigBuilder_ = null;
      }
      imageConfig_ = null;
      if (imageConfigBuilder_ != null) {
        imageConfigBuilder_.dispose();
        imageConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig build() {
      com.google.cloud.aiplatform.v1beta1.GenerationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.GenerationConfig result =
          new com.google.cloud.aiplatform.v1beta1.GenerationConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig result) {
      if (((bitField0_ & 0x00010000) != 0)) {
        responseModalities_ = java.util.Collections.unmodifiableList(responseModalities_);
        bitField0_ = (bitField0_ & ~0x00010000);
      }
      result.responseModalities_ = responseModalities_;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.GenerationConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.temperature_ = temperature_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.topP_ = topP_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.topK_ = topK_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.candidateCount_ = candidateCount_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.maxOutputTokens_ = maxOutputTokens_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        stopSequences_.makeImmutable();
        result.stopSequences_ = stopSequences_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.responseLogprobs_ = responseLogprobs_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.logprobs_ = logprobs_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.presencePenalty_ = presencePenalty_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.frequencyPenalty_ = frequencyPenalty_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.seed_ = seed_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.responseMimeType_ = responseMimeType_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.responseSchema_ =
            responseSchemaBuilder_ == null ? responseSchema_ : responseSchemaBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.responseJsonSchema_ =
            responseJsonSchemaBuilder_ == null
                ? responseJsonSchema_
                : responseJsonSchemaBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.routingConfig_ =
            routingConfigBuilder_ == null ? routingConfig_ : routingConfigBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.audioTimestamp_ = audioTimestamp_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.mediaResolution_ = mediaResolution_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.speechConfig_ =
            speechConfigBuilder_ == null ? speechConfig_ : speechConfigBuilder_.build();
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.thinkingConfig_ =
            thinkingConfigBuilder_ == null ? thinkingConfig_ : thinkingConfigBuilder_.build();
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.modelConfig_ =
            modelConfigBuilder_ == null ? modelConfig_ : modelConfigBuilder_.build();
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.imageConfig_ =
            imageConfigBuilder_ == null ? imageConfig_ : imageConfigBuilder_.build();
        to_bitField0_ |= 0x00040000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.GenerationConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.GenerationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.GenerationConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance())
        return this;
      if (other.hasTemperature()) {
        setTemperature(other.getTemperature());
      }
      if (other.hasTopP()) {
        setTopP(other.getTopP());
      }
      if (other.hasTopK()) {
        setTopK(other.getTopK());
      }
      if (other.hasCandidateCount()) {
        setCandidateCount(other.getCandidateCount());
      }
      if (other.hasMaxOutputTokens()) {
        setMaxOutputTokens(other.getMaxOutputTokens());
      }
      if (!other.stopSequences_.isEmpty()) {
        if (stopSequences_.isEmpty()) {
          stopSequences_ = other.stopSequences_;
          bitField0_ |= 0x00000020;
        } else {
          ensureStopSequencesIsMutable();
          stopSequences_.addAll(other.stopSequences_);
        }
        onChanged();
      }
      if (other.hasResponseLogprobs()) {
        setResponseLogprobs(other.getResponseLogprobs());
      }
      if (other.hasLogprobs()) {
        setLogprobs(other.getLogprobs());
      }
      if (other.hasPresencePenalty()) {
        setPresencePenalty(other.getPresencePenalty());
      }
      if (other.hasFrequencyPenalty()) {
        setFrequencyPenalty(other.getFrequencyPenalty());
      }
      if (other.hasSeed()) {
        setSeed(other.getSeed());
      }
      if (!other.getResponseMimeType().isEmpty()) {
        responseMimeType_ = other.responseMimeType_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasResponseSchema()) {
        mergeResponseSchema(other.getResponseSchema());
      }
      if (other.hasResponseJsonSchema()) {
        mergeResponseJsonSchema(other.getResponseJsonSchema());
      }
      if (other.hasRoutingConfig()) {
        mergeRoutingConfig(other.getRoutingConfig());
      }
      if (other.hasAudioTimestamp()) {
        setAudioTimestamp(other.getAudioTimestamp());
      }
      if (!other.responseModalities_.isEmpty()) {
        if (responseModalities_.isEmpty()) {
          responseModalities_ = other.responseModalities_;
          bitField0_ = (bitField0_ & ~0x00010000);
        } else {
          ensureResponseModalitiesIsMutable();
          responseModalities_.addAll(other.responseModalities_);
        }
        onChanged();
      }
      if (other.hasMediaResolution()) {
        setMediaResolution(other.getMediaResolution());
      }
      if (other.hasSpeechConfig()) {
        mergeSpeechConfig(other.getSpeechConfig());
      }
      if (other.hasThinkingConfig()) {
        mergeThinkingConfig(other.getThinkingConfig());
      }
      if (other.hasModelConfig()) {
        mergeModelConfig(other.getModelConfig());
      }
      if (other.hasImageConfig()) {
        mergeImageConfig(other.getImageConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13:
              {
                temperature_ = input.readFloat();
                bitField0_ |= 0x00000001;
                break;
              } // case 13
            case 21:
              {
                topP_ = input.readFloat();
                bitField0_ |= 0x00000002;
                break;
              } // case 21
            case 29:
              {
                topK_ = input.readFloat();
                bitField0_ |= 0x00000004;
                break;
              } // case 29
            case 32:
              {
                candidateCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                maxOutputTokens_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureStopSequencesIsMutable();
                stopSequences_.add(s);
                break;
              } // case 50
            case 56:
              {
                logprobs_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 69:
              {
                presencePenalty_ = input.readFloat();
                bitField0_ |= 0x00000100;
                break;
              } // case 69
            case 77:
              {
                frequencyPenalty_ = input.readFloat();
                bitField0_ |= 0x00000200;
                break;
              } // case 77
            case 96:
              {
                seed_ = input.readInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case 96
            case 106:
              {
                responseMimeType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 106
            case 130:
              {
                input.readMessage(getResponseSchemaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getRoutingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 138
            case 144:
              {
                responseLogprobs_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 144
            case 160:
              {
                audioTimestamp_ = input.readBool();
                bitField0_ |= 0x00008000;
                break;
              } // case 160
            case 168:
              {
                int tmpRaw = input.readEnum();
                ensureResponseModalitiesIsMutable();
                responseModalities_.add(tmpRaw);
                break;
              } // case 168
            case 170:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureResponseModalitiesIsMutable();
                  responseModalities_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 170
            case 176:
              {
                mediaResolution_ = input.readEnum();
                bitField0_ |= 0x00020000;
                break;
              } // case 176
            case 186:
              {
                input.readMessage(getSpeechConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 186
            case 202:
              {
                input.readMessage(getThinkingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 202
            case 218:
              {
                input.readMessage(getModelConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(
                    getResponseJsonSchemaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 226
            case 242:
              {
                input.readMessage(getImageConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 242
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private float temperature_;

    /**
     *
     *
     * <pre>
     * Optional. Controls the randomness of predictions.
     * </pre>
     *
     * <code>optional float temperature = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the temperature field is set.
     */
    @java.lang.Override
    public boolean hasTemperature() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Controls the randomness of predictions.
     * </pre>
     *
     * <code>optional float temperature = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The temperature.
     */
    @java.lang.Override
    public float getTemperature() {
      return temperature_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Controls the randomness of predictions.
     * </pre>
     *
     * <code>optional float temperature = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The temperature to set.
     * @return This builder for chaining.
     */
    public Builder setTemperature(float value) {

      temperature_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Controls the randomness of predictions.
     * </pre>
     *
     * <code>optional float temperature = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTemperature() {
      bitField0_ = (bitField0_ & ~0x00000001);
      temperature_ = 0F;
      onChanged();
      return this;
    }

    private float topP_;

    /**
     *
     *
     * <pre>
     * Optional. If specified, nucleus sampling will be used.
     * </pre>
     *
     * <code>optional float top_p = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the topP field is set.
     */
    @java.lang.Override
    public boolean hasTopP() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, nucleus sampling will be used.
     * </pre>
     *
     * <code>optional float top_p = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The topP.
     */
    @java.lang.Override
    public float getTopP() {
      return topP_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, nucleus sampling will be used.
     * </pre>
     *
     * <code>optional float top_p = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The topP to set.
     * @return This builder for chaining.
     */
    public Builder setTopP(float value) {

      topP_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, nucleus sampling will be used.
     * </pre>
     *
     * <code>optional float top_p = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopP() {
      bitField0_ = (bitField0_ & ~0x00000002);
      topP_ = 0F;
      onChanged();
      return this;
    }

    private float topK_;

    /**
     *
     *
     * <pre>
     * Optional. If specified, top-k sampling will be used.
     * </pre>
     *
     * <code>optional float top_k = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the topK field is set.
     */
    @java.lang.Override
    public boolean hasTopK() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, top-k sampling will be used.
     * </pre>
     *
     * <code>optional float top_k = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The topK.
     */
    @java.lang.Override
    public float getTopK() {
      return topK_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, top-k sampling will be used.
     * </pre>
     *
     * <code>optional float top_k = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The topK to set.
     * @return This builder for chaining.
     */
    public Builder setTopK(float value) {

      topK_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, top-k sampling will be used.
     * </pre>
     *
     * <code>optional float top_k = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopK() {
      bitField0_ = (bitField0_ & ~0x00000004);
      topK_ = 0F;
      onChanged();
      return this;
    }

    private int candidateCount_;

    /**
     *
     *
     * <pre>
     * Optional. Number of candidates to generate.
     * </pre>
     *
     * <code>optional int32 candidate_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the candidateCount field is set.
     */
    @java.lang.Override
    public boolean hasCandidateCount() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of candidates to generate.
     * </pre>
     *
     * <code>optional int32 candidate_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The candidateCount.
     */
    @java.lang.Override
    public int getCandidateCount() {
      return candidateCount_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of candidates to generate.
     * </pre>
     *
     * <code>optional int32 candidate_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The candidateCount to set.
     * @return This builder for chaining.
     */
    public Builder setCandidateCount(int value) {

      candidateCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of candidates to generate.
     * </pre>
     *
     * <code>optional int32 candidate_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCandidateCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      candidateCount_ = 0;
      onChanged();
      return this;
    }

    private int maxOutputTokens_;

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of output tokens to generate per message.
     * </pre>
     *
     * <code>optional int32 max_output_tokens = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the maxOutputTokens field is set.
     */
    @java.lang.Override
    public boolean hasMaxOutputTokens() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of output tokens to generate per message.
     * </pre>
     *
     * <code>optional int32 max_output_tokens = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxOutputTokens.
     */
    @java.lang.Override
    public int getMaxOutputTokens() {
      return maxOutputTokens_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of output tokens to generate per message.
     * </pre>
     *
     * <code>optional int32 max_output_tokens = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxOutputTokens to set.
     * @return This builder for chaining.
     */
    public Builder setMaxOutputTokens(int value) {

      maxOutputTokens_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of output tokens to generate per message.
     * </pre>
     *
     * <code>optional int32 max_output_tokens = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxOutputTokens() {
      bitField0_ = (bitField0_ & ~0x00000010);
      maxOutputTokens_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList stopSequences_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureStopSequencesIsMutable() {
      if (!stopSequences_.isModifiable()) {
        stopSequences_ = new com.google.protobuf.LazyStringArrayList(stopSequences_);
      }
      bitField0_ |= 0x00000020;
    }

    /**
     *
     *
     * <pre>
     * Optional. Stop sequences.
     * </pre>
     *
     * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the stopSequences.
     */
    public com.google.protobuf.ProtocolStringList getStopSequencesList() {
      stopSequences_.makeImmutable();
      return stopSequences_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Stop sequences.
     * </pre>
     *
     * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of stopSequences.
     */
    public int getStopSequencesCount() {
      return stopSequences_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Stop sequences.
     * </pre>
     *
     * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The stopSequences at the given index.
     */
    public java.lang.String getStopSequences(int index) {
      return stopSequences_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Stop sequences.
     * </pre>
     *
     * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the stopSequences at the given index.
     */
    public com.google.protobuf.ByteString getStopSequencesBytes(int index) {
      return stopSequences_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Stop sequences.
     * </pre>
     *
     * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The stopSequences to set.
     * @return This builder for chaining.
     */
    public Builder setStopSequences(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStopSequencesIsMutable();
      stopSequences_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Stop sequences.
     * </pre>
     *
     * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The stopSequences to add.
     * @return This builder for chaining.
     */
    public Builder addStopSequences(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStopSequencesIsMutable();
      stopSequences_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Stop sequences.
     * </pre>
     *
     * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The stopSequences to add.
     * @return This builder for chaining.
     */
    public Builder addAllStopSequences(java.lang.Iterable<java.lang.String> values) {
      ensureStopSequencesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stopSequences_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Stop sequences.
     * </pre>
     *
     * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStopSequences() {
      stopSequences_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Stop sequences.
     * </pre>
     *
     * <code>repeated string stop_sequences = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the stopSequences to add.
     * @return This builder for chaining.
     */
    public Builder addStopSequencesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStopSequencesIsMutable();
      stopSequences_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private boolean responseLogprobs_;

    /**
     *
     *
     * <pre>
     * Optional. If true, export the logprobs results in response.
     * </pre>
     *
     * <code>optional bool response_logprobs = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the responseLogprobs field is set.
     */
    @java.lang.Override
    public boolean hasResponseLogprobs() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, export the logprobs results in response.
     * </pre>
     *
     * <code>optional bool response_logprobs = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The responseLogprobs.
     */
    @java.lang.Override
    public boolean getResponseLogprobs() {
      return responseLogprobs_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, export the logprobs results in response.
     * </pre>
     *
     * <code>optional bool response_logprobs = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The responseLogprobs to set.
     * @return This builder for chaining.
     */
    public Builder setResponseLogprobs(boolean value) {

      responseLogprobs_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, export the logprobs results in response.
     * </pre>
     *
     * <code>optional bool response_logprobs = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseLogprobs() {
      bitField0_ = (bitField0_ & ~0x00000040);
      responseLogprobs_ = false;
      onChanged();
      return this;
    }

    private int logprobs_;

    /**
     *
     *
     * <pre>
     * Optional. Logit probabilities.
     * </pre>
     *
     * <code>optional int32 logprobs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the logprobs field is set.
     */
    @java.lang.Override
    public boolean hasLogprobs() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Logit probabilities.
     * </pre>
     *
     * <code>optional int32 logprobs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The logprobs.
     */
    @java.lang.Override
    public int getLogprobs() {
      return logprobs_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Logit probabilities.
     * </pre>
     *
     * <code>optional int32 logprobs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The logprobs to set.
     * @return This builder for chaining.
     */
    public Builder setLogprobs(int value) {

      logprobs_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Logit probabilities.
     * </pre>
     *
     * <code>optional int32 logprobs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogprobs() {
      bitField0_ = (bitField0_ & ~0x00000080);
      logprobs_ = 0;
      onChanged();
      return this;
    }

    private float presencePenalty_;

    /**
     *
     *
     * <pre>
     * Optional. Positive penalties.
     * </pre>
     *
     * <code>optional float presence_penalty = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the presencePenalty field is set.
     */
    @java.lang.Override
    public boolean hasPresencePenalty() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Positive penalties.
     * </pre>
     *
     * <code>optional float presence_penalty = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The presencePenalty.
     */
    @java.lang.Override
    public float getPresencePenalty() {
      return presencePenalty_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Positive penalties.
     * </pre>
     *
     * <code>optional float presence_penalty = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The presencePenalty to set.
     * @return This builder for chaining.
     */
    public Builder setPresencePenalty(float value) {

      presencePenalty_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Positive penalties.
     * </pre>
     *
     * <code>optional float presence_penalty = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPresencePenalty() {
      bitField0_ = (bitField0_ & ~0x00000100);
      presencePenalty_ = 0F;
      onChanged();
      return this;
    }

    private float frequencyPenalty_;

    /**
     *
     *
     * <pre>
     * Optional. Frequency penalties.
     * </pre>
     *
     * <code>optional float frequency_penalty = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the frequencyPenalty field is set.
     */
    @java.lang.Override
    public boolean hasFrequencyPenalty() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Frequency penalties.
     * </pre>
     *
     * <code>optional float frequency_penalty = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The frequencyPenalty.
     */
    @java.lang.Override
    public float getFrequencyPenalty() {
      return frequencyPenalty_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Frequency penalties.
     * </pre>
     *
     * <code>optional float frequency_penalty = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The frequencyPenalty to set.
     * @return This builder for chaining.
     */
    public Builder setFrequencyPenalty(float value) {

      frequencyPenalty_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Frequency penalties.
     * </pre>
     *
     * <code>optional float frequency_penalty = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFrequencyPenalty() {
      bitField0_ = (bitField0_ & ~0x00000200);
      frequencyPenalty_ = 0F;
      onChanged();
      return this;
    }

    private int seed_;

    /**
     *
     *
     * <pre>
     * Optional. Seed.
     * </pre>
     *
     * <code>optional int32 seed = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the seed field is set.
     */
    @java.lang.Override
    public boolean hasSeed() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Seed.
     * </pre>
     *
     * <code>optional int32 seed = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The seed.
     */
    @java.lang.Override
    public int getSeed() {
      return seed_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Seed.
     * </pre>
     *
     * <code>optional int32 seed = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The seed to set.
     * @return This builder for chaining.
     */
    public Builder setSeed(int value) {

      seed_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Seed.
     * </pre>
     *
     * <code>optional int32 seed = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeed() {
      bitField0_ = (bitField0_ & ~0x00000400);
      seed_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object responseMimeType_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Output response mimetype of the generated candidate text.
     * Supported mimetype:
     * - `text/plain`: (default) Text output.
     * - `application/json`: JSON response in the candidates.
     * The model needs to be prompted to output the appropriate response type,
     * otherwise the behavior is undefined.
     * This is a preview feature.
     * </pre>
     *
     * <code>string response_mime_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The responseMimeType.
     */
    public java.lang.String getResponseMimeType() {
      java.lang.Object ref = responseMimeType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        responseMimeType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Output response mimetype of the generated candidate text.
     * Supported mimetype:
     * - `text/plain`: (default) Text output.
     * - `application/json`: JSON response in the candidates.
     * The model needs to be prompted to output the appropriate response type,
     * otherwise the behavior is undefined.
     * This is a preview feature.
     * </pre>
     *
     * <code>string response_mime_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for responseMimeType.
     */
    public com.google.protobuf.ByteString getResponseMimeTypeBytes() {
      java.lang.Object ref = responseMimeType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        responseMimeType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Output response mimetype of the generated candidate text.
     * Supported mimetype:
     * - `text/plain`: (default) Text output.
     * - `application/json`: JSON response in the candidates.
     * The model needs to be prompted to output the appropriate response type,
     * otherwise the behavior is undefined.
     * This is a preview feature.
     * </pre>
     *
     * <code>string response_mime_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The responseMimeType to set.
     * @return This builder for chaining.
     */
    public Builder setResponseMimeType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      responseMimeType_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Output response mimetype of the generated candidate text.
     * Supported mimetype:
     * - `text/plain`: (default) Text output.
     * - `application/json`: JSON response in the candidates.
     * The model needs to be prompted to output the appropriate response type,
     * otherwise the behavior is undefined.
     * This is a preview feature.
     * </pre>
     *
     * <code>string response_mime_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseMimeType() {
      responseMimeType_ = getDefaultInstance().getResponseMimeType();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Output response mimetype of the generated candidate text.
     * Supported mimetype:
     * - `text/plain`: (default) Text output.
     * - `application/json`: JSON response in the candidates.
     * The model needs to be prompted to output the appropriate response type,
     * otherwise the behavior is undefined.
     * This is a preview feature.
     * </pre>
     *
     * <code>string response_mime_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for responseMimeType to set.
     * @return This builder for chaining.
     */
    public Builder setResponseMimeTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      responseMimeType_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.Schema responseSchema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Schema,
            com.google.cloud.aiplatform.v1beta1.Schema.Builder,
            com.google.cloud.aiplatform.v1beta1.SchemaOrBuilder>
        responseSchemaBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The `Schema` object allows the definition of input and output
     * data types. These types can be objects, but also primitives and arrays.
     * Represents a select subset of an [OpenAPI 3.0 schema
     * object](https://spec.openapis.org/oas/v3.0.3#schema).
     * If set, a compatible response_mime_type must also be set.
     * Compatible mimetypes:
     * `application/json`: Schema for JSON response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the responseSchema field is set.
     */
    public boolean hasResponseSchema() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The `Schema` object allows the definition of input and output
     * data types. These types can be objects, but also primitives and arrays.
     * Represents a select subset of an [OpenAPI 3.0 schema
     * object](https://spec.openapis.org/oas/v3.0.3#schema).
     * If set, a compatible response_mime_type must also be set.
     * Compatible mimetypes:
     * `application/json`: Schema for JSON response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The responseSchema.
     */
    public com.google.cloud.aiplatform.v1beta1.Schema getResponseSchema() {
      if (responseSchemaBuilder_ == null) {
        return responseSchema_ == null
            ? com.google.cloud.aiplatform.v1beta1.Schema.getDefaultInstance()
            : responseSchema_;
      } else {
        return responseSchemaBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The `Schema` object allows the definition of input and output
     * data types. These types can be objects, but also primitives and arrays.
     * Represents a select subset of an [OpenAPI 3.0 schema
     * object](https://spec.openapis.org/oas/v3.0.3#schema).
     * If set, a compatible response_mime_type must also be set.
     * Compatible mimetypes:
     * `application/json`: Schema for JSON response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setResponseSchema(com.google.cloud.aiplatform.v1beta1.Schema value) {
      if (responseSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        responseSchema_ = value;
      } else {
        responseSchemaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The `Schema` object allows the definition of input and output
     * data types. These types can be objects, but also primitives and arrays.
     * Represents a select subset of an [OpenAPI 3.0 schema
     * object](https://spec.openapis.org/oas/v3.0.3#schema).
     * If set, a compatible response_mime_type must also be set.
     * Compatible mimetypes:
     * `application/json`: Schema for JSON response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setResponseSchema(
        com.google.cloud.aiplatform.v1beta1.Schema.Builder builderForValue) {
      if (responseSchemaBuilder_ == null) {
        responseSchema_ = builderForValue.build();
      } else {
        responseSchemaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The `Schema` object allows the definition of input and output
     * data types. These types can be objects, but also primitives and arrays.
     * Represents a select subset of an [OpenAPI 3.0 schema
     * object](https://spec.openapis.org/oas/v3.0.3#schema).
     * If set, a compatible response_mime_type must also be set.
     * Compatible mimetypes:
     * `application/json`: Schema for JSON response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeResponseSchema(com.google.cloud.aiplatform.v1beta1.Schema value) {
      if (responseSchemaBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && responseSchema_ != null
            && responseSchema_ != com.google.cloud.aiplatform.v1beta1.Schema.getDefaultInstance()) {
          getResponseSchemaBuilder().mergeFrom(value);
        } else {
          responseSchema_ = value;
        }
      } else {
        responseSchemaBuilder_.mergeFrom(value);
      }
      if (responseSchema_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The `Schema` object allows the definition of input and output
     * data types. These types can be objects, but also primitives and arrays.
     * Represents a select subset of an [OpenAPI 3.0 schema
     * object](https://spec.openapis.org/oas/v3.0.3#schema).
     * If set, a compatible response_mime_type must also be set.
     * Compatible mimetypes:
     * `application/json`: Schema for JSON response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearResponseSchema() {
      bitField0_ = (bitField0_ & ~0x00001000);
      responseSchema_ = null;
      if (responseSchemaBuilder_ != null) {
        responseSchemaBuilder_.dispose();
        responseSchemaBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The `Schema` object allows the definition of input and output
     * data types. These types can be objects, but also primitives and arrays.
     * Represents a select subset of an [OpenAPI 3.0 schema
     * object](https://spec.openapis.org/oas/v3.0.3#schema).
     * If set, a compatible response_mime_type must also be set.
     * Compatible mimetypes:
     * `application/json`: Schema for JSON response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Schema.Builder getResponseSchemaBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getResponseSchemaFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The `Schema` object allows the definition of input and output
     * data types. These types can be objects, but also primitives and arrays.
     * Represents a select subset of an [OpenAPI 3.0 schema
     * object](https://spec.openapis.org/oas/v3.0.3#schema).
     * If set, a compatible response_mime_type must also be set.
     * Compatible mimetypes:
     * `application/json`: Schema for JSON response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SchemaOrBuilder getResponseSchemaOrBuilder() {
      if (responseSchemaBuilder_ != null) {
        return responseSchemaBuilder_.getMessageOrBuilder();
      } else {
        return responseSchema_ == null
            ? com.google.cloud.aiplatform.v1beta1.Schema.getDefaultInstance()
            : responseSchema_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The `Schema` object allows the definition of input and output
     * data types. These types can be objects, but also primitives and arrays.
     * Represents a select subset of an [OpenAPI 3.0 schema
     * object](https://spec.openapis.org/oas/v3.0.3#schema).
     * If set, a compatible response_mime_type must also be set.
     * Compatible mimetypes:
     * `application/json`: Schema for JSON response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Schema response_schema = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Schema,
            com.google.cloud.aiplatform.v1beta1.Schema.Builder,
            com.google.cloud.aiplatform.v1beta1.SchemaOrBuilder>
        getResponseSchemaFieldBuilder() {
      if (responseSchemaBuilder_ == null) {
        responseSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Schema,
                com.google.cloud.aiplatform.v1beta1.Schema.Builder,
                com.google.cloud.aiplatform.v1beta1.SchemaOrBuilder>(
                getResponseSchema(), getParentForChildren(), isClean());
        responseSchema_ = null;
      }
      return responseSchemaBuilder_;
    }

    private com.google.protobuf.Value responseJsonSchema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        responseJsonSchemaBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Output schema of the generated response. This is an alternative
     * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
     *
     * If set, `response_schema` must be omitted, but `response_mime_type` is
     * required.
     *
     * While the full JSON Schema may be sent, not all features are supported.
     * Specifically, only the following properties are supported:
     *
     * - `$id`
     * - `$defs`
     * - `$ref`
     * - `$anchor`
     * - `type`
     * - `format`
     * - `title`
     * - `description`
     * - `enum` (for strings and numbers)
     * - `items`
     * - `prefixItems`
     * - `minItems`
     * - `maxItems`
     * - `minimum`
     * - `maximum`
     * - `anyOf`
     * - `oneOf` (interpreted the same as `anyOf`)
     * - `properties`
     * - `additionalProperties`
     * - `required`
     *
     * The non-standard `propertyOrdering` property may also be set.
     *
     * Cyclic references are unrolled to a limited degree and, as such, may only
     * be used within non-required properties. (Nullable properties are not
     * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
     * for than those starting as a `$`, may be set.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the responseJsonSchema field is set.
     */
    public boolean hasResponseJsonSchema() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Output schema of the generated response. This is an alternative
     * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
     *
     * If set, `response_schema` must be omitted, but `response_mime_type` is
     * required.
     *
     * While the full JSON Schema may be sent, not all features are supported.
     * Specifically, only the following properties are supported:
     *
     * - `$id`
     * - `$defs`
     * - `$ref`
     * - `$anchor`
     * - `type`
     * - `format`
     * - `title`
     * - `description`
     * - `enum` (for strings and numbers)
     * - `items`
     * - `prefixItems`
     * - `minItems`
     * - `maxItems`
     * - `minimum`
     * - `maximum`
     * - `anyOf`
     * - `oneOf` (interpreted the same as `anyOf`)
     * - `properties`
     * - `additionalProperties`
     * - `required`
     *
     * The non-standard `propertyOrdering` property may also be set.
     *
     * Cyclic references are unrolled to a limited degree and, as such, may only
     * be used within non-required properties. (Nullable properties are not
     * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
     * for than those starting as a `$`, may be set.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The responseJsonSchema.
     */
    public com.google.protobuf.Value getResponseJsonSchema() {
      if (responseJsonSchemaBuilder_ == null) {
        return responseJsonSchema_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : responseJsonSchema_;
      } else {
        return responseJsonSchemaBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Output schema of the generated response. This is an alternative
     * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
     *
     * If set, `response_schema` must be omitted, but `response_mime_type` is
     * required.
     *
     * While the full JSON Schema may be sent, not all features are supported.
     * Specifically, only the following properties are supported:
     *
     * - `$id`
     * - `$defs`
     * - `$ref`
     * - `$anchor`
     * - `type`
     * - `format`
     * - `title`
     * - `description`
     * - `enum` (for strings and numbers)
     * - `items`
     * - `prefixItems`
     * - `minItems`
     * - `maxItems`
     * - `minimum`
     * - `maximum`
     * - `anyOf`
     * - `oneOf` (interpreted the same as `anyOf`)
     * - `properties`
     * - `additionalProperties`
     * - `required`
     *
     * The non-standard `propertyOrdering` property may also be set.
     *
     * Cyclic references are unrolled to a limited degree and, as such, may only
     * be used within non-required properties. (Nullable properties are not
     * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
     * for than those starting as a `$`, may be set.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setResponseJsonSchema(com.google.protobuf.Value value) {
      if (responseJsonSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        responseJsonSchema_ = value;
      } else {
        responseJsonSchemaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Output schema of the generated response. This is an alternative
     * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
     *
     * If set, `response_schema` must be omitted, but `response_mime_type` is
     * required.
     *
     * While the full JSON Schema may be sent, not all features are supported.
     * Specifically, only the following properties are supported:
     *
     * - `$id`
     * - `$defs`
     * - `$ref`
     * - `$anchor`
     * - `type`
     * - `format`
     * - `title`
     * - `description`
     * - `enum` (for strings and numbers)
     * - `items`
     * - `prefixItems`
     * - `minItems`
     * - `maxItems`
     * - `minimum`
     * - `maximum`
     * - `anyOf`
     * - `oneOf` (interpreted the same as `anyOf`)
     * - `properties`
     * - `additionalProperties`
     * - `required`
     *
     * The non-standard `propertyOrdering` property may also be set.
     *
     * Cyclic references are unrolled to a limited degree and, as such, may only
     * be used within non-required properties. (Nullable properties are not
     * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
     * for than those starting as a `$`, may be set.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setResponseJsonSchema(com.google.protobuf.Value.Builder builderForValue) {
      if (responseJsonSchemaBuilder_ == null) {
        responseJsonSchema_ = builderForValue.build();
      } else {
        responseJsonSchemaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Output schema of the generated response. This is an alternative
     * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
     *
     * If set, `response_schema` must be omitted, but `response_mime_type` is
     * required.
     *
     * While the full JSON Schema may be sent, not all features are supported.
     * Specifically, only the following properties are supported:
     *
     * - `$id`
     * - `$defs`
     * - `$ref`
     * - `$anchor`
     * - `type`
     * - `format`
     * - `title`
     * - `description`
     * - `enum` (for strings and numbers)
     * - `items`
     * - `prefixItems`
     * - `minItems`
     * - `maxItems`
     * - `minimum`
     * - `maximum`
     * - `anyOf`
     * - `oneOf` (interpreted the same as `anyOf`)
     * - `properties`
     * - `additionalProperties`
     * - `required`
     *
     * The non-standard `propertyOrdering` property may also be set.
     *
     * Cyclic references are unrolled to a limited degree and, as such, may only
     * be used within non-required properties. (Nullable properties are not
     * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
     * for than those starting as a `$`, may be set.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeResponseJsonSchema(com.google.protobuf.Value value) {
      if (responseJsonSchemaBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && responseJsonSchema_ != null
            && responseJsonSchema_ != com.google.protobuf.Value.getDefaultInstance()) {
          getResponseJsonSchemaBuilder().mergeFrom(value);
        } else {
          responseJsonSchema_ = value;
        }
      } else {
        responseJsonSchemaBuilder_.mergeFrom(value);
      }
      if (responseJsonSchema_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Output schema of the generated response. This is an alternative
     * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
     *
     * If set, `response_schema` must be omitted, but `response_mime_type` is
     * required.
     *
     * While the full JSON Schema may be sent, not all features are supported.
     * Specifically, only the following properties are supported:
     *
     * - `$id`
     * - `$defs`
     * - `$ref`
     * - `$anchor`
     * - `type`
     * - `format`
     * - `title`
     * - `description`
     * - `enum` (for strings and numbers)
     * - `items`
     * - `prefixItems`
     * - `minItems`
     * - `maxItems`
     * - `minimum`
     * - `maximum`
     * - `anyOf`
     * - `oneOf` (interpreted the same as `anyOf`)
     * - `properties`
     * - `additionalProperties`
     * - `required`
     *
     * The non-standard `propertyOrdering` property may also be set.
     *
     * Cyclic references are unrolled to a limited degree and, as such, may only
     * be used within non-required properties. (Nullable properties are not
     * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
     * for than those starting as a `$`, may be set.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearResponseJsonSchema() {
      bitField0_ = (bitField0_ & ~0x00002000);
      responseJsonSchema_ = null;
      if (responseJsonSchemaBuilder_ != null) {
        responseJsonSchemaBuilder_.dispose();
        responseJsonSchemaBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Output schema of the generated response. This is an alternative
     * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
     *
     * If set, `response_schema` must be omitted, but `response_mime_type` is
     * required.
     *
     * While the full JSON Schema may be sent, not all features are supported.
     * Specifically, only the following properties are supported:
     *
     * - `$id`
     * - `$defs`
     * - `$ref`
     * - `$anchor`
     * - `type`
     * - `format`
     * - `title`
     * - `description`
     * - `enum` (for strings and numbers)
     * - `items`
     * - `prefixItems`
     * - `minItems`
     * - `maxItems`
     * - `minimum`
     * - `maximum`
     * - `anyOf`
     * - `oneOf` (interpreted the same as `anyOf`)
     * - `properties`
     * - `additionalProperties`
     * - `required`
     *
     * The non-standard `propertyOrdering` property may also be set.
     *
     * Cyclic references are unrolled to a limited degree and, as such, may only
     * be used within non-required properties. (Nullable properties are not
     * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
     * for than those starting as a `$`, may be set.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Value.Builder getResponseJsonSchemaBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getResponseJsonSchemaFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Output schema of the generated response. This is an alternative
     * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
     *
     * If set, `response_schema` must be omitted, but `response_mime_type` is
     * required.
     *
     * While the full JSON Schema may be sent, not all features are supported.
     * Specifically, only the following properties are supported:
     *
     * - `$id`
     * - `$defs`
     * - `$ref`
     * - `$anchor`
     * - `type`
     * - `format`
     * - `title`
     * - `description`
     * - `enum` (for strings and numbers)
     * - `items`
     * - `prefixItems`
     * - `minItems`
     * - `maxItems`
     * - `minimum`
     * - `maximum`
     * - `anyOf`
     * - `oneOf` (interpreted the same as `anyOf`)
     * - `properties`
     * - `additionalProperties`
     * - `required`
     *
     * The non-standard `propertyOrdering` property may also be set.
     *
     * Cyclic references are unrolled to a limited degree and, as such, may only
     * be used within non-required properties. (Nullable properties are not
     * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
     * for than those starting as a `$`, may be set.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.ValueOrBuilder getResponseJsonSchemaOrBuilder() {
      if (responseJsonSchemaBuilder_ != null) {
        return responseJsonSchemaBuilder_.getMessageOrBuilder();
      } else {
        return responseJsonSchema_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : responseJsonSchema_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Output schema of the generated response. This is an alternative
     * to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
     *
     * If set, `response_schema` must be omitted, but `response_mime_type` is
     * required.
     *
     * While the full JSON Schema may be sent, not all features are supported.
     * Specifically, only the following properties are supported:
     *
     * - `$id`
     * - `$defs`
     * - `$ref`
     * - `$anchor`
     * - `type`
     * - `format`
     * - `title`
     * - `description`
     * - `enum` (for strings and numbers)
     * - `items`
     * - `prefixItems`
     * - `minItems`
     * - `maxItems`
     * - `minimum`
     * - `maximum`
     * - `anyOf`
     * - `oneOf` (interpreted the same as `anyOf`)
     * - `properties`
     * - `additionalProperties`
     * - `required`
     *
     * The non-standard `propertyOrdering` property may also be set.
     *
     * Cyclic references are unrolled to a limited degree and, as such, may only
     * be used within non-required properties. (Nullable properties are not
     * sufficient.) If `$ref` is set on a sub-schema, no other properties, except
     * for than those starting as a `$`, may be set.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Value response_json_schema = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getResponseJsonSchemaFieldBuilder() {
      if (responseJsonSchemaBuilder_ == null) {
        responseJsonSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getResponseJsonSchema(), getParentForChildren(), isClean());
        responseJsonSchema_ = null;
      }
      return responseJsonSchemaBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfigOrBuilder>
        routingConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Routing configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the routingConfig field is set.
     */
    public boolean hasRoutingConfig() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Routing configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The routingConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig getRoutingConfig() {
      if (routingConfigBuilder_ == null) {
        return routingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                .getDefaultInstance()
            : routingConfig_;
      } else {
        return routingConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Routing configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRoutingConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig value) {
      if (routingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        routingConfig_ = value;
      } else {
        routingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Routing configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRoutingConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.Builder
            builderForValue) {
      if (routingConfigBuilder_ == null) {
        routingConfig_ = builderForValue.build();
      } else {
        routingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Routing configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRoutingConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig value) {
      if (routingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && routingConfig_ != null
            && routingConfig_
                != com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                    .getDefaultInstance()) {
          getRoutingConfigBuilder().mergeFrom(value);
        } else {
          routingConfig_ = value;
        }
      } else {
        routingConfigBuilder_.mergeFrom(value);
      }
      if (routingConfig_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Routing configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRoutingConfig() {
      bitField0_ = (bitField0_ & ~0x00004000);
      routingConfig_ = null;
      if (routingConfigBuilder_ != null) {
        routingConfigBuilder_.dispose();
        routingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Routing configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.Builder
        getRoutingConfigBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getRoutingConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Routing configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfigOrBuilder
        getRoutingConfigOrBuilder() {
      if (routingConfigBuilder_ != null) {
        return routingConfigBuilder_.getMessageOrBuilder();
      } else {
        return routingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
                .getDefaultInstance()
            : routingConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Routing configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig routing_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfigOrBuilder>
        getRoutingConfigFieldBuilder() {
      if (routingConfigBuilder_ == null) {
        routingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfigOrBuilder>(
                getRoutingConfig(), getParentForChildren(), isClean());
        routingConfig_ = null;
      }
      return routingConfigBuilder_;
    }

    private boolean audioTimestamp_;

    /**
     *
     *
     * <pre>
     * Optional. If enabled, audio timestamp will be included in the request to
     * the model.
     * </pre>
     *
     * <code>optional bool audio_timestamp = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the audioTimestamp field is set.
     */
    @java.lang.Override
    public boolean hasAudioTimestamp() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If enabled, audio timestamp will be included in the request to
     * the model.
     * </pre>
     *
     * <code>optional bool audio_timestamp = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The audioTimestamp.
     */
    @java.lang.Override
    public boolean getAudioTimestamp() {
      return audioTimestamp_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If enabled, audio timestamp will be included in the request to
     * the model.
     * </pre>
     *
     * <code>optional bool audio_timestamp = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The audioTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setAudioTimestamp(boolean value) {

      audioTimestamp_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If enabled, audio timestamp will be included in the request to
     * the model.
     * </pre>
     *
     * <code>optional bool audio_timestamp = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudioTimestamp() {
      bitField0_ = (bitField0_ & ~0x00008000);
      audioTimestamp_ = false;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> responseModalities_ =
        java.util.Collections.emptyList();

    private void ensureResponseModalitiesIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        responseModalities_ = new java.util.ArrayList<java.lang.Integer>(responseModalities_);
        bitField0_ |= 0x00010000;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the responseModalities.
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality>
        getResponseModalitiesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality>(
          responseModalities_, responseModalities_converter_);
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of responseModalities.
     */
    public int getResponseModalitiesCount() {
      return responseModalities_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The responseModalities at the given index.
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality getResponseModalities(
        int index) {
      return responseModalities_converter_.convert(responseModalities_.get(index));
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The responseModalities to set.
     * @return This builder for chaining.
     */
    public Builder setResponseModalities(
        int index, com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResponseModalitiesIsMutable();
      responseModalities_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The responseModalities to add.
     * @return This builder for chaining.
     */
    public Builder addResponseModalities(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResponseModalitiesIsMutable();
      responseModalities_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The responseModalities to add.
     * @return This builder for chaining.
     */
    public Builder addAllResponseModalities(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality>
            values) {
      ensureResponseModalitiesIsMutable();
      for (com.google.cloud.aiplatform.v1beta1.GenerationConfig.Modality value : values) {
        responseModalities_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseModalities() {
      responseModalities_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for responseModalities.
     */
    public java.util.List<java.lang.Integer> getResponseModalitiesValueList() {
      return java.util.Collections.unmodifiableList(responseModalities_);
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of responseModalities at the given index.
     */
    public int getResponseModalitiesValue(int index) {
      return responseModalities_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for responseModalities to set.
     * @return This builder for chaining.
     */
    public Builder setResponseModalitiesValue(int index, int value) {
      ensureResponseModalitiesIsMutable();
      responseModalities_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for responseModalities to add.
     * @return This builder for chaining.
     */
    public Builder addResponseModalitiesValue(int value) {
      ensureResponseModalitiesIsMutable();
      responseModalities_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The modalities of the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerationConfig.Modality response_modalities = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for responseModalities to add.
     * @return This builder for chaining.
     */
    public Builder addAllResponseModalitiesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureResponseModalitiesIsMutable();
      for (int value : values) {
        responseModalities_.add(value);
      }
      onChanged();
      return this;
    }

    private int mediaResolution_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. If specified, the media resolution specified will be used.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution media_resolution = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the mediaResolution field is set.
     */
    @java.lang.Override
    public boolean hasMediaResolution() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, the media resolution specified will be used.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution media_resolution = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for mediaResolution.
     */
    @java.lang.Override
    public int getMediaResolutionValue() {
      return mediaResolution_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, the media resolution specified will be used.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution media_resolution = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for mediaResolution to set.
     * @return This builder for chaining.
     */
    public Builder setMediaResolutionValue(int value) {
      mediaResolution_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, the media resolution specified will be used.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution media_resolution = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The mediaResolution.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution
        getMediaResolution() {
      com.google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution result =
          com.google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution.forNumber(
              mediaResolution_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, the media resolution specified will be used.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution media_resolution = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The mediaResolution to set.
     * @return This builder for chaining.
     */
    public Builder setMediaResolution(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00020000;
      mediaResolution_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, the media resolution specified will be used.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution media_resolution = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMediaResolution() {
      bitField0_ = (bitField0_ & ~0x00020000);
      mediaResolution_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.SpeechConfig speechConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SpeechConfig,
            com.google.cloud.aiplatform.v1beta1.SpeechConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.SpeechConfigOrBuilder>
        speechConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The speech generation config.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the speechConfig field is set.
     */
    public boolean hasSpeechConfig() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The speech generation config.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The speechConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.SpeechConfig getSpeechConfig() {
      if (speechConfigBuilder_ == null) {
        return speechConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.SpeechConfig.getDefaultInstance()
            : speechConfig_;
      } else {
        return speechConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The speech generation config.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeechConfig(com.google.cloud.aiplatform.v1beta1.SpeechConfig value) {
      if (speechConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speechConfig_ = value;
      } else {
        speechConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The speech generation config.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeechConfig(
        com.google.cloud.aiplatform.v1beta1.SpeechConfig.Builder builderForValue) {
      if (speechConfigBuilder_ == null) {
        speechConfig_ = builderForValue.build();
      } else {
        speechConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The speech generation config.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSpeechConfig(com.google.cloud.aiplatform.v1beta1.SpeechConfig value) {
      if (speechConfigBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && speechConfig_ != null
            && speechConfig_
                != com.google.cloud.aiplatform.v1beta1.SpeechConfig.getDefaultInstance()) {
          getSpeechConfigBuilder().mergeFrom(value);
        } else {
          speechConfig_ = value;
        }
      } else {
        speechConfigBuilder_.mergeFrom(value);
      }
      if (speechConfig_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The speech generation config.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSpeechConfig() {
      bitField0_ = (bitField0_ & ~0x00040000);
      speechConfig_ = null;
      if (speechConfigBuilder_ != null) {
        speechConfigBuilder_.dispose();
        speechConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The speech generation config.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SpeechConfig.Builder getSpeechConfigBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getSpeechConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The speech generation config.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SpeechConfigOrBuilder getSpeechConfigOrBuilder() {
      if (speechConfigBuilder_ != null) {
        return speechConfigBuilder_.getMessageOrBuilder();
      } else {
        return speechConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.SpeechConfig.getDefaultInstance()
            : speechConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The speech generation config.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SpeechConfig speech_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SpeechConfig,
            com.google.cloud.aiplatform.v1beta1.SpeechConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.SpeechConfigOrBuilder>
        getSpeechConfigFieldBuilder() {
      if (speechConfigBuilder_ == null) {
        speechConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SpeechConfig,
                com.google.cloud.aiplatform.v1beta1.SpeechConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.SpeechConfigOrBuilder>(
                getSpeechConfig(), getParentForChildren(), isClean());
        speechConfig_ = null;
      }
      return speechConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinkingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfigOrBuilder>
        thinkingConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Config for thinking features.
     * An error will be returned if this field is set for models that don't
     * support thinking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the thinkingConfig field is set.
     */
    public boolean hasThinkingConfig() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for thinking features.
     * An error will be returned if this field is set for models that don't
     * support thinking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The thinkingConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig getThinkingConfig() {
      if (thinkingConfigBuilder_ == null) {
        return thinkingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
                .getDefaultInstance()
            : thinkingConfig_;
      } else {
        return thinkingConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for thinking features.
     * An error will be returned if this field is set for models that don't
     * support thinking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setThinkingConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig value) {
      if (thinkingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        thinkingConfig_ = value;
      } else {
        thinkingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for thinking features.
     * An error will be returned if this field is set for models that don't
     * support thinking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setThinkingConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.Builder
            builderForValue) {
      if (thinkingConfigBuilder_ == null) {
        thinkingConfig_ = builderForValue.build();
      } else {
        thinkingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for thinking features.
     * An error will be returned if this field is set for models that don't
     * support thinking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeThinkingConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig value) {
      if (thinkingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && thinkingConfig_ != null
            && thinkingConfig_
                != com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
                    .getDefaultInstance()) {
          getThinkingConfigBuilder().mergeFrom(value);
        } else {
          thinkingConfig_ = value;
        }
      } else {
        thinkingConfigBuilder_.mergeFrom(value);
      }
      if (thinkingConfig_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for thinking features.
     * An error will be returned if this field is set for models that don't
     * support thinking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearThinkingConfig() {
      bitField0_ = (bitField0_ & ~0x00080000);
      thinkingConfig_ = null;
      if (thinkingConfigBuilder_ != null) {
        thinkingConfigBuilder_.dispose();
        thinkingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for thinking features.
     * An error will be returned if this field is set for models that don't
     * support thinking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.Builder
        getThinkingConfigBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getThinkingConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for thinking features.
     * An error will be returned if this field is set for models that don't
     * support thinking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfigOrBuilder
        getThinkingConfigOrBuilder() {
      if (thinkingConfigBuilder_ != null) {
        return thinkingConfigBuilder_.getMessageOrBuilder();
      } else {
        return thinkingConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
                .getDefaultInstance()
            : thinkingConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for thinking features.
     * An error will be returned if this field is set for models that don't
     * support thinking.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig thinking_config = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfigOrBuilder>
        getThinkingConfigFieldBuilder() {
      if (thinkingConfigBuilder_ == null) {
        thinkingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfigOrBuilder>(
                getThinkingConfig(), getParentForChildren(), isClean());
        thinkingConfig_ = null;
      }
      return thinkingConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig modelConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfigOrBuilder>
        modelConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Config for model selection.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the modelConfig field is set.
     */
    public boolean hasModelConfig() {
      return ((bitField0_ & 0x00100000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for model selection.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The modelConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig getModelConfig() {
      if (modelConfigBuilder_ == null) {
        return modelConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.getDefaultInstance()
            : modelConfig_;
      } else {
        return modelConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for model selection.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setModelConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig value) {
      if (modelConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelConfig_ = value;
      } else {
        modelConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for model selection.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setModelConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.Builder builderForValue) {
      if (modelConfigBuilder_ == null) {
        modelConfig_ = builderForValue.build();
      } else {
        modelConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for model selection.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeModelConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig value) {
      if (modelConfigBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && modelConfig_ != null
            && modelConfig_
                != com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
                    .getDefaultInstance()) {
          getModelConfigBuilder().mergeFrom(value);
        } else {
          modelConfig_ = value;
        }
      } else {
        modelConfigBuilder_.mergeFrom(value);
      }
      if (modelConfig_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for model selection.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearModelConfig() {
      bitField0_ = (bitField0_ & ~0x00100000);
      modelConfig_ = null;
      if (modelConfigBuilder_ != null) {
        modelConfigBuilder_.dispose();
        modelConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for model selection.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.Builder
        getModelConfigBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getModelConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for model selection.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfigOrBuilder
        getModelConfigOrBuilder() {
      if (modelConfigBuilder_ != null) {
        return modelConfigBuilder_.getMessageOrBuilder();
      } else {
        return modelConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.getDefaultInstance()
            : modelConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for model selection.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig model_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfigOrBuilder>
        getModelConfigFieldBuilder() {
      if (modelConfigBuilder_ == null) {
        modelConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfigOrBuilder>(
                getModelConfig(), getParentForChildren(), isClean());
        modelConfig_ = null;
      }
      return modelConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ImageConfig imageConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ImageConfig,
            com.google.cloud.aiplatform.v1beta1.ImageConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ImageConfigOrBuilder>
        imageConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Config for image generation features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the imageConfig field is set.
     */
    public boolean hasImageConfig() {
      return ((bitField0_ & 0x00200000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for image generation features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The imageConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ImageConfig getImageConfig() {
      if (imageConfigBuilder_ == null) {
        return imageConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ImageConfig.getDefaultInstance()
            : imageConfig_;
      } else {
        return imageConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for image generation features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setImageConfig(com.google.cloud.aiplatform.v1beta1.ImageConfig value) {
      if (imageConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageConfig_ = value;
      } else {
        imageConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for image generation features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setImageConfig(
        com.google.cloud.aiplatform.v1beta1.ImageConfig.Builder builderForValue) {
      if (imageConfigBuilder_ == null) {
        imageConfig_ = builderForValue.build();
      } else {
        imageConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for image generation features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeImageConfig(com.google.cloud.aiplatform.v1beta1.ImageConfig value) {
      if (imageConfigBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && imageConfig_ != null
            && imageConfig_
                != com.google.cloud.aiplatform.v1beta1.ImageConfig.getDefaultInstance()) {
          getImageConfigBuilder().mergeFrom(value);
        } else {
          imageConfig_ = value;
        }
      } else {
        imageConfigBuilder_.mergeFrom(value);
      }
      if (imageConfig_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for image generation features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearImageConfig() {
      bitField0_ = (bitField0_ & ~0x00200000);
      imageConfig_ = null;
      if (imageConfigBuilder_ != null) {
        imageConfigBuilder_.dispose();
        imageConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for image generation features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ImageConfig.Builder getImageConfigBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getImageConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for image generation features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ImageConfigOrBuilder getImageConfigOrBuilder() {
      if (imageConfigBuilder_ != null) {
        return imageConfigBuilder_.getMessageOrBuilder();
      } else {
        return imageConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ImageConfig.getDefaultInstance()
            : imageConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Config for image generation features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.ImageConfig image_config = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ImageConfig,
            com.google.cloud.aiplatform.v1beta1.ImageConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ImageConfigOrBuilder>
        getImageConfigFieldBuilder() {
      if (imageConfigBuilder_ == null) {
        imageConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ImageConfig,
                com.google.cloud.aiplatform.v1beta1.ImageConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ImageConfigOrBuilder>(
                getImageConfig(), getParentForChildren(), isClean());
        imageConfig_ = null;
      }
      return imageConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerationConfig)
  private static final com.google.cloud.aiplatform.v1beta1.GenerationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GenerationConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerationConfig> PARSER =
      new com.google.protobuf.AbstractParser<GenerationConfig>() {
        @java.lang.Override
        public GenerationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
