/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/endpoint.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Configuration for rolling deployments.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.RolloutOptions}
 */
public final class RolloutOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RolloutOptions)
    RolloutOptionsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RolloutOptions.newBuilder() to construct.
  private RolloutOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RolloutOptions() {
    previousDeployedModel_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RolloutOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.EndpointProto
        .internal_static_google_cloud_aiplatform_v1beta1_RolloutOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.EndpointProto
        .internal_static_google_cloud_aiplatform_v1beta1_RolloutOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.RolloutOptions.class,
            com.google.cloud.aiplatform.v1beta1.RolloutOptions.Builder.class);
  }

  private int maxUnavailableCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object maxUnavailable_;

  public enum MaxUnavailableCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MAX_UNAVAILABLE_REPLICAS(3),
    MAX_UNAVAILABLE_PERCENTAGE(4),
    MAXUNAVAILABLE_NOT_SET(0);
    private final int value;

    private MaxUnavailableCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MaxUnavailableCase valueOf(int value) {
      return forNumber(value);
    }

    public static MaxUnavailableCase forNumber(int value) {
      switch (value) {
        case 3:
          return MAX_UNAVAILABLE_REPLICAS;
        case 4:
          return MAX_UNAVAILABLE_PERCENTAGE;
        case 0:
          return MAXUNAVAILABLE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MaxUnavailableCase getMaxUnavailableCase() {
    return MaxUnavailableCase.forNumber(maxUnavailableCase_);
  }

  private int maxSurgeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object maxSurge_;

  public enum MaxSurgeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MAX_SURGE_REPLICAS(5),
    MAX_SURGE_PERCENTAGE(6),
    MAXSURGE_NOT_SET(0);
    private final int value;

    private MaxSurgeCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MaxSurgeCase valueOf(int value) {
      return forNumber(value);
    }

    public static MaxSurgeCase forNumber(int value) {
      switch (value) {
        case 5:
          return MAX_SURGE_REPLICAS;
        case 6:
          return MAX_SURGE_PERCENTAGE;
        case 0:
          return MAXSURGE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MaxSurgeCase getMaxSurgeCase() {
    return MaxSurgeCase.forNumber(maxSurgeCase_);
  }

  public static final int MAX_UNAVAILABLE_REPLICAS_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Absolute count of replicas allowed to be unavailable.
   * </pre>
   *
   * <code>int32 max_unavailable_replicas = 3;</code>
   *
   * @return Whether the maxUnavailableReplicas field is set.
   */
  @java.lang.Override
  public boolean hasMaxUnavailableReplicas() {
    return maxUnavailableCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Absolute count of replicas allowed to be unavailable.
   * </pre>
   *
   * <code>int32 max_unavailable_replicas = 3;</code>
   *
   * @return The maxUnavailableReplicas.
   */
  @java.lang.Override
  public int getMaxUnavailableReplicas() {
    if (maxUnavailableCase_ == 3) {
      return (java.lang.Integer) maxUnavailable_;
    }
    return 0;
  }

  public static final int MAX_UNAVAILABLE_PERCENTAGE_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Percentage of replicas allowed to be unavailable.
   * For autoscaling deployments, this refers to the target replica count.
   * </pre>
   *
   * <code>int32 max_unavailable_percentage = 4;</code>
   *
   * @return Whether the maxUnavailablePercentage field is set.
   */
  @java.lang.Override
  public boolean hasMaxUnavailablePercentage() {
    return maxUnavailableCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Percentage of replicas allowed to be unavailable.
   * For autoscaling deployments, this refers to the target replica count.
   * </pre>
   *
   * <code>int32 max_unavailable_percentage = 4;</code>
   *
   * @return The maxUnavailablePercentage.
   */
  @java.lang.Override
  public int getMaxUnavailablePercentage() {
    if (maxUnavailableCase_ == 4) {
      return (java.lang.Integer) maxUnavailable_;
    }
    return 0;
  }

  public static final int MAX_SURGE_REPLICAS_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Absolute count of allowed additional replicas.
   * </pre>
   *
   * <code>int32 max_surge_replicas = 5;</code>
   *
   * @return Whether the maxSurgeReplicas field is set.
   */
  @java.lang.Override
  public boolean hasMaxSurgeReplicas() {
    return maxSurgeCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Absolute count of allowed additional replicas.
   * </pre>
   *
   * <code>int32 max_surge_replicas = 5;</code>
   *
   * @return The maxSurgeReplicas.
   */
  @java.lang.Override
  public int getMaxSurgeReplicas() {
    if (maxSurgeCase_ == 5) {
      return (java.lang.Integer) maxSurge_;
    }
    return 0;
  }

  public static final int MAX_SURGE_PERCENTAGE_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Percentage of allowed additional replicas.
   * For autoscaling deployments, this refers to the target replica count.
   * </pre>
   *
   * <code>int32 max_surge_percentage = 6;</code>
   *
   * @return Whether the maxSurgePercentage field is set.
   */
  @java.lang.Override
  public boolean hasMaxSurgePercentage() {
    return maxSurgeCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Percentage of allowed additional replicas.
   * For autoscaling deployments, this refers to the target replica count.
   * </pre>
   *
   * <code>int32 max_surge_percentage = 6;</code>
   *
   * @return The maxSurgePercentage.
   */
  @java.lang.Override
  public int getMaxSurgePercentage() {
    if (maxSurgeCase_ == 6) {
      return (java.lang.Integer) maxSurge_;
    }
    return 0;
  }

  public static final int PREVIOUS_DEPLOYED_MODEL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object previousDeployedModel_ = "";

  /**
   *
   *
   * <pre>
   * ID of the DeployedModel that this deployment should replace.
   * </pre>
   *
   * <code>string previous_deployed_model = 1;</code>
   *
   * @return The previousDeployedModel.
   */
  @java.lang.Override
  public java.lang.String getPreviousDeployedModel() {
    java.lang.Object ref = previousDeployedModel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      previousDeployedModel_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * ID of the DeployedModel that this deployment should replace.
   * </pre>
   *
   * <code>string previous_deployed_model = 1;</code>
   *
   * @return The bytes for previousDeployedModel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPreviousDeployedModelBytes() {
    java.lang.Object ref = previousDeployedModel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      previousDeployedModel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REVISION_NUMBER_FIELD_NUMBER = 2;
  private int revisionNumber_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Read-only. Revision number determines the relative priority of
   * DeployedModels in the same rollout. The DeployedModel with the largest
   * revision number specifies the intended state of the deployment.
   * </pre>
   *
   * <code>int32 revision_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The revisionNumber.
   */
  @java.lang.Override
  public int getRevisionNumber() {
    return revisionNumber_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(previousDeployedModel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, previousDeployedModel_);
    }
    if (revisionNumber_ != 0) {
      output.writeInt32(2, revisionNumber_);
    }
    if (maxUnavailableCase_ == 3) {
      output.writeInt32(3, (int) ((java.lang.Integer) maxUnavailable_));
    }
    if (maxUnavailableCase_ == 4) {
      output.writeInt32(4, (int) ((java.lang.Integer) maxUnavailable_));
    }
    if (maxSurgeCase_ == 5) {
      output.writeInt32(5, (int) ((java.lang.Integer) maxSurge_));
    }
    if (maxSurgeCase_ == 6) {
      output.writeInt32(6, (int) ((java.lang.Integer) maxSurge_));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(previousDeployedModel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, previousDeployedModel_);
    }
    if (revisionNumber_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, revisionNumber_);
    }
    if (maxUnavailableCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              3, (int) ((java.lang.Integer) maxUnavailable_));
    }
    if (maxUnavailableCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              4, (int) ((java.lang.Integer) maxUnavailable_));
    }
    if (maxSurgeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              5, (int) ((java.lang.Integer) maxSurge_));
    }
    if (maxSurgeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              6, (int) ((java.lang.Integer) maxSurge_));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RolloutOptions)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.RolloutOptions other =
        (com.google.cloud.aiplatform.v1beta1.RolloutOptions) obj;

    if (!getPreviousDeployedModel().equals(other.getPreviousDeployedModel())) return false;
    if (getRevisionNumber() != other.getRevisionNumber()) return false;
    if (!getMaxUnavailableCase().equals(other.getMaxUnavailableCase())) return false;
    switch (maxUnavailableCase_) {
      case 3:
        if (getMaxUnavailableReplicas() != other.getMaxUnavailableReplicas()) return false;
        break;
      case 4:
        if (getMaxUnavailablePercentage() != other.getMaxUnavailablePercentage()) return false;
        break;
      case 0:
      default:
    }
    if (!getMaxSurgeCase().equals(other.getMaxSurgeCase())) return false;
    switch (maxSurgeCase_) {
      case 5:
        if (getMaxSurgeReplicas() != other.getMaxSurgeReplicas()) return false;
        break;
      case 6:
        if (getMaxSurgePercentage() != other.getMaxSurgePercentage()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PREVIOUS_DEPLOYED_MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getPreviousDeployedModel().hashCode();
    hash = (37 * hash) + REVISION_NUMBER_FIELD_NUMBER;
    hash = (53 * hash) + getRevisionNumber();
    switch (maxUnavailableCase_) {
      case 3:
        hash = (37 * hash) + MAX_UNAVAILABLE_REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxUnavailableReplicas();
        break;
      case 4:
        hash = (37 * hash) + MAX_UNAVAILABLE_PERCENTAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMaxUnavailablePercentage();
        break;
      case 0:
      default:
    }
    switch (maxSurgeCase_) {
      case 5:
        hash = (37 * hash) + MAX_SURGE_REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxSurgeReplicas();
        break;
      case 6:
        hash = (37 * hash) + MAX_SURGE_PERCENTAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMaxSurgePercentage();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.RolloutOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configuration for rolling deployments.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RolloutOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RolloutOptions)
      com.google.cloud.aiplatform.v1beta1.RolloutOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1beta1_RolloutOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1beta1_RolloutOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RolloutOptions.class,
              com.google.cloud.aiplatform.v1beta1.RolloutOptions.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.RolloutOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      previousDeployedModel_ = "";
      revisionNumber_ = 0;
      maxUnavailableCase_ = 0;
      maxUnavailable_ = null;
      maxSurgeCase_ = 0;
      maxSurge_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1beta1_RolloutOptions_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RolloutOptions getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.RolloutOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RolloutOptions build() {
      com.google.cloud.aiplatform.v1beta1.RolloutOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RolloutOptions buildPartial() {
      com.google.cloud.aiplatform.v1beta1.RolloutOptions result =
          new com.google.cloud.aiplatform.v1beta1.RolloutOptions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RolloutOptions result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.previousDeployedModel_ = previousDeployedModel_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.revisionNumber_ = revisionNumber_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.RolloutOptions result) {
      result.maxUnavailableCase_ = maxUnavailableCase_;
      result.maxUnavailable_ = this.maxUnavailable_;
      result.maxSurgeCase_ = maxSurgeCase_;
      result.maxSurge_ = this.maxSurge_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.RolloutOptions) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.RolloutOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RolloutOptions other) {
      if (other == com.google.cloud.aiplatform.v1beta1.RolloutOptions.getDefaultInstance())
        return this;
      if (!other.getPreviousDeployedModel().isEmpty()) {
        previousDeployedModel_ = other.previousDeployedModel_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getRevisionNumber() != 0) {
        setRevisionNumber(other.getRevisionNumber());
      }
      switch (other.getMaxUnavailableCase()) {
        case MAX_UNAVAILABLE_REPLICAS:
          {
            setMaxUnavailableReplicas(other.getMaxUnavailableReplicas());
            break;
          }
        case MAX_UNAVAILABLE_PERCENTAGE:
          {
            setMaxUnavailablePercentage(other.getMaxUnavailablePercentage());
            break;
          }
        case MAXUNAVAILABLE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getMaxSurgeCase()) {
        case MAX_SURGE_REPLICAS:
          {
            setMaxSurgeReplicas(other.getMaxSurgeReplicas());
            break;
          }
        case MAX_SURGE_PERCENTAGE:
          {
            setMaxSurgePercentage(other.getMaxSurgePercentage());
            break;
          }
        case MAXSURGE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                previousDeployedModel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 10
            case 16:
              {
                revisionNumber_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 16
            case 24:
              {
                maxUnavailable_ = input.readInt32();
                maxUnavailableCase_ = 3;
                break;
              } // case 24
            case 32:
              {
                maxUnavailable_ = input.readInt32();
                maxUnavailableCase_ = 4;
                break;
              } // case 32
            case 40:
              {
                maxSurge_ = input.readInt32();
                maxSurgeCase_ = 5;
                break;
              } // case 40
            case 48:
              {
                maxSurge_ = input.readInt32();
                maxSurgeCase_ = 6;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int maxUnavailableCase_ = 0;
    private java.lang.Object maxUnavailable_;

    public MaxUnavailableCase getMaxUnavailableCase() {
      return MaxUnavailableCase.forNumber(maxUnavailableCase_);
    }

    public Builder clearMaxUnavailable() {
      maxUnavailableCase_ = 0;
      maxUnavailable_ = null;
      onChanged();
      return this;
    }

    private int maxSurgeCase_ = 0;
    private java.lang.Object maxSurge_;

    public MaxSurgeCase getMaxSurgeCase() {
      return MaxSurgeCase.forNumber(maxSurgeCase_);
    }

    public Builder clearMaxSurge() {
      maxSurgeCase_ = 0;
      maxSurge_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Absolute count of replicas allowed to be unavailable.
     * </pre>
     *
     * <code>int32 max_unavailable_replicas = 3;</code>
     *
     * @return Whether the maxUnavailableReplicas field is set.
     */
    public boolean hasMaxUnavailableReplicas() {
      return maxUnavailableCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Absolute count of replicas allowed to be unavailable.
     * </pre>
     *
     * <code>int32 max_unavailable_replicas = 3;</code>
     *
     * @return The maxUnavailableReplicas.
     */
    public int getMaxUnavailableReplicas() {
      if (maxUnavailableCase_ == 3) {
        return (java.lang.Integer) maxUnavailable_;
      }
      return 0;
    }

    /**
     *
     *
     * <pre>
     * Absolute count of replicas allowed to be unavailable.
     * </pre>
     *
     * <code>int32 max_unavailable_replicas = 3;</code>
     *
     * @param value The maxUnavailableReplicas to set.
     * @return This builder for chaining.
     */
    public Builder setMaxUnavailableReplicas(int value) {

      maxUnavailableCase_ = 3;
      maxUnavailable_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Absolute count of replicas allowed to be unavailable.
     * </pre>
     *
     * <code>int32 max_unavailable_replicas = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxUnavailableReplicas() {
      if (maxUnavailableCase_ == 3) {
        maxUnavailableCase_ = 0;
        maxUnavailable_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Percentage of replicas allowed to be unavailable.
     * For autoscaling deployments, this refers to the target replica count.
     * </pre>
     *
     * <code>int32 max_unavailable_percentage = 4;</code>
     *
     * @return Whether the maxUnavailablePercentage field is set.
     */
    public boolean hasMaxUnavailablePercentage() {
      return maxUnavailableCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Percentage of replicas allowed to be unavailable.
     * For autoscaling deployments, this refers to the target replica count.
     * </pre>
     *
     * <code>int32 max_unavailable_percentage = 4;</code>
     *
     * @return The maxUnavailablePercentage.
     */
    public int getMaxUnavailablePercentage() {
      if (maxUnavailableCase_ == 4) {
        return (java.lang.Integer) maxUnavailable_;
      }
      return 0;
    }

    /**
     *
     *
     * <pre>
     * Percentage of replicas allowed to be unavailable.
     * For autoscaling deployments, this refers to the target replica count.
     * </pre>
     *
     * <code>int32 max_unavailable_percentage = 4;</code>
     *
     * @param value The maxUnavailablePercentage to set.
     * @return This builder for chaining.
     */
    public Builder setMaxUnavailablePercentage(int value) {

      maxUnavailableCase_ = 4;
      maxUnavailable_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Percentage of replicas allowed to be unavailable.
     * For autoscaling deployments, this refers to the target replica count.
     * </pre>
     *
     * <code>int32 max_unavailable_percentage = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxUnavailablePercentage() {
      if (maxUnavailableCase_ == 4) {
        maxUnavailableCase_ = 0;
        maxUnavailable_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Absolute count of allowed additional replicas.
     * </pre>
     *
     * <code>int32 max_surge_replicas = 5;</code>
     *
     * @return Whether the maxSurgeReplicas field is set.
     */
    public boolean hasMaxSurgeReplicas() {
      return maxSurgeCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Absolute count of allowed additional replicas.
     * </pre>
     *
     * <code>int32 max_surge_replicas = 5;</code>
     *
     * @return The maxSurgeReplicas.
     */
    public int getMaxSurgeReplicas() {
      if (maxSurgeCase_ == 5) {
        return (java.lang.Integer) maxSurge_;
      }
      return 0;
    }

    /**
     *
     *
     * <pre>
     * Absolute count of allowed additional replicas.
     * </pre>
     *
     * <code>int32 max_surge_replicas = 5;</code>
     *
     * @param value The maxSurgeReplicas to set.
     * @return This builder for chaining.
     */
    public Builder setMaxSurgeReplicas(int value) {

      maxSurgeCase_ = 5;
      maxSurge_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Absolute count of allowed additional replicas.
     * </pre>
     *
     * <code>int32 max_surge_replicas = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxSurgeReplicas() {
      if (maxSurgeCase_ == 5) {
        maxSurgeCase_ = 0;
        maxSurge_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Percentage of allowed additional replicas.
     * For autoscaling deployments, this refers to the target replica count.
     * </pre>
     *
     * <code>int32 max_surge_percentage = 6;</code>
     *
     * @return Whether the maxSurgePercentage field is set.
     */
    public boolean hasMaxSurgePercentage() {
      return maxSurgeCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Percentage of allowed additional replicas.
     * For autoscaling deployments, this refers to the target replica count.
     * </pre>
     *
     * <code>int32 max_surge_percentage = 6;</code>
     *
     * @return The maxSurgePercentage.
     */
    public int getMaxSurgePercentage() {
      if (maxSurgeCase_ == 6) {
        return (java.lang.Integer) maxSurge_;
      }
      return 0;
    }

    /**
     *
     *
     * <pre>
     * Percentage of allowed additional replicas.
     * For autoscaling deployments, this refers to the target replica count.
     * </pre>
     *
     * <code>int32 max_surge_percentage = 6;</code>
     *
     * @param value The maxSurgePercentage to set.
     * @return This builder for chaining.
     */
    public Builder setMaxSurgePercentage(int value) {

      maxSurgeCase_ = 6;
      maxSurge_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Percentage of allowed additional replicas.
     * For autoscaling deployments, this refers to the target replica count.
     * </pre>
     *
     * <code>int32 max_surge_percentage = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxSurgePercentage() {
      if (maxSurgeCase_ == 6) {
        maxSurgeCase_ = 0;
        maxSurge_ = null;
        onChanged();
      }
      return this;
    }

    private java.lang.Object previousDeployedModel_ = "";

    /**
     *
     *
     * <pre>
     * ID of the DeployedModel that this deployment should replace.
     * </pre>
     *
     * <code>string previous_deployed_model = 1;</code>
     *
     * @return The previousDeployedModel.
     */
    public java.lang.String getPreviousDeployedModel() {
      java.lang.Object ref = previousDeployedModel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        previousDeployedModel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * ID of the DeployedModel that this deployment should replace.
     * </pre>
     *
     * <code>string previous_deployed_model = 1;</code>
     *
     * @return The bytes for previousDeployedModel.
     */
    public com.google.protobuf.ByteString getPreviousDeployedModelBytes() {
      java.lang.Object ref = previousDeployedModel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        previousDeployedModel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * ID of the DeployedModel that this deployment should replace.
     * </pre>
     *
     * <code>string previous_deployed_model = 1;</code>
     *
     * @param value The previousDeployedModel to set.
     * @return This builder for chaining.
     */
    public Builder setPreviousDeployedModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      previousDeployedModel_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ID of the DeployedModel that this deployment should replace.
     * </pre>
     *
     * <code>string previous_deployed_model = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreviousDeployedModel() {
      previousDeployedModel_ = getDefaultInstance().getPreviousDeployedModel();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ID of the DeployedModel that this deployment should replace.
     * </pre>
     *
     * <code>string previous_deployed_model = 1;</code>
     *
     * @param value The bytes for previousDeployedModel to set.
     * @return This builder for chaining.
     */
    public Builder setPreviousDeployedModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      previousDeployedModel_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int revisionNumber_;

    /**
     *
     *
     * <pre>
     * Output only. Read-only. Revision number determines the relative priority of
     * DeployedModels in the same rollout. The DeployedModel with the largest
     * revision number specifies the intended state of the deployment.
     * </pre>
     *
     * <code>int32 revision_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The revisionNumber.
     */
    @java.lang.Override
    public int getRevisionNumber() {
      return revisionNumber_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Read-only. Revision number determines the relative priority of
     * DeployedModels in the same rollout. The DeployedModel with the largest
     * revision number specifies the intended state of the deployment.
     * </pre>
     *
     * <code>int32 revision_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The revisionNumber to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionNumber(int value) {

      revisionNumber_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Read-only. Revision number determines the relative priority of
     * DeployedModels in the same rollout. The DeployedModel with the largest
     * revision number specifies the intended state of the deployment.
     * </pre>
     *
     * <code>int32 revision_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevisionNumber() {
      bitField0_ = (bitField0_ & ~0x00000020);
      revisionNumber_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RolloutOptions)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RolloutOptions)
  private static final com.google.cloud.aiplatform.v1beta1.RolloutOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RolloutOptions();
  }

  public static com.google.cloud.aiplatform.v1beta1.RolloutOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RolloutOptions> PARSER =
      new com.google.protobuf.AbstractParser<RolloutOptions>() {
        @java.lang.Override
        public RolloutOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RolloutOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RolloutOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RolloutOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
