/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/example_store_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ExampleStoreService.UpsertExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.UpsertExamples].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.UpsertExamplesRequest}
 */
public final class UpsertExamplesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.UpsertExamplesRequest)
    UpsertExamplesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use UpsertExamplesRequest.newBuilder() to construct.
  private UpsertExamplesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpsertExamplesRequest() {
    exampleStore_ = "";
    examples_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpsertExamplesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_UpsertExamplesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_UpsertExamplesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest.class,
            com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest.Builder.class);
  }

  public static final int EXAMPLE_STORE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object exampleStore_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the ExampleStore resource that examples are added to
   * or updated in. Format:
   * `projects/{project}/locations/{location}/exampleStores/{example_store}`
   * </pre>
   *
   * <code>
   * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The exampleStore.
   */
  @java.lang.Override
  public java.lang.String getExampleStore() {
    java.lang.Object ref = exampleStore_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      exampleStore_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the ExampleStore resource that examples are added to
   * or updated in. Format:
   * `projects/{project}/locations/{location}/exampleStores/{example_store}`
   * </pre>
   *
   * <code>
   * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for exampleStore.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExampleStoreBytes() {
    java.lang.Object ref = exampleStore_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      exampleStore_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXAMPLES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Example> examples_;

  /**
   *
   *
   * <pre>
   * Required. A list of examples to be created/updated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Example> getExamplesList() {
    return examples_;
  }

  /**
   *
   *
   * <pre>
   * Required. A list of examples to be created/updated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ExampleOrBuilder>
      getExamplesOrBuilderList() {
    return examples_;
  }

  /**
   *
   *
   * <pre>
   * Required. A list of examples to be created/updated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getExamplesCount() {
    return examples_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. A list of examples to be created/updated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Example getExamples(int index) {
    return examples_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. A list of examples to be created/updated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExampleOrBuilder getExamplesOrBuilder(int index) {
    return examples_.get(index);
  }

  public static final int OVERWRITE_FIELD_NUMBER = 4;
  private boolean overwrite_ = false;

  /**
   *
   *
   * <pre>
   * Optional. A flag indicating whether an example can be overwritten if it
   * already exists. If False (default) and the example already exists, the
   * example will not be updated. This does not affect behavior if the example
   * does not exist already.
   * </pre>
   *
   * <code>bool overwrite = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The overwrite.
   */
  @java.lang.Override
  public boolean getOverwrite() {
    return overwrite_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exampleStore_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, exampleStore_);
    }
    for (int i = 0; i < examples_.size(); i++) {
      output.writeMessage(2, examples_.get(i));
    }
    if (overwrite_ != false) {
      output.writeBool(4, overwrite_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exampleStore_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, exampleStore_);
    }
    for (int i = 0; i < examples_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, examples_.get(i));
    }
    if (overwrite_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, overwrite_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest other =
        (com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest) obj;

    if (!getExampleStore().equals(other.getExampleStore())) return false;
    if (!getExamplesList().equals(other.getExamplesList())) return false;
    if (getOverwrite() != other.getOverwrite()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EXAMPLE_STORE_FIELD_NUMBER;
    hash = (53 * hash) + getExampleStore().hashCode();
    if (getExamplesCount() > 0) {
      hash = (37 * hash) + EXAMPLES_FIELD_NUMBER;
      hash = (53 * hash) + getExamplesList().hashCode();
    }
    hash = (37 * hash) + OVERWRITE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOverwrite());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [ExampleStoreService.UpsertExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.UpsertExamples].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.UpsertExamplesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.UpsertExamplesRequest)
      com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_UpsertExamplesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_UpsertExamplesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest.class,
              com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      exampleStore_ = "";
      if (examplesBuilder_ == null) {
        examples_ = java.util.Collections.emptyList();
      } else {
        examples_ = null;
        examplesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      overwrite_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ExampleStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_UpsertExamplesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest build() {
      com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest result =
          new com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest result) {
      if (examplesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          examples_ = java.util.Collections.unmodifiableList(examples_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.examples_ = examples_;
      } else {
        result.examples_ = examplesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.exampleStore_ = exampleStore_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.overwrite_ = overwrite_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest.getDefaultInstance())
        return this;
      if (!other.getExampleStore().isEmpty()) {
        exampleStore_ = other.exampleStore_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (examplesBuilder_ == null) {
        if (!other.examples_.isEmpty()) {
          if (examples_.isEmpty()) {
            examples_ = other.examples_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureExamplesIsMutable();
            examples_.addAll(other.examples_);
          }
          onChanged();
        }
      } else {
        if (!other.examples_.isEmpty()) {
          if (examplesBuilder_.isEmpty()) {
            examplesBuilder_.dispose();
            examplesBuilder_ = null;
            examples_ = other.examples_;
            bitField0_ = (bitField0_ & ~0x00000002);
            examplesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExamplesFieldBuilder()
                    : null;
          } else {
            examplesBuilder_.addAllMessages(other.examples_);
          }
        }
      }
      if (other.getOverwrite() != false) {
        setOverwrite(other.getOverwrite());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                exampleStore_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.Example m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Example.parser(), extensionRegistry);
                if (examplesBuilder_ == null) {
                  ensureExamplesIsMutable();
                  examples_.add(m);
                } else {
                  examplesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 32:
              {
                overwrite_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object exampleStore_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the ExampleStore resource that examples are added to
     * or updated in. Format:
     * `projects/{project}/locations/{location}/exampleStores/{example_store}`
     * </pre>
     *
     * <code>
     * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The exampleStore.
     */
    public java.lang.String getExampleStore() {
      java.lang.Object ref = exampleStore_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        exampleStore_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the ExampleStore resource that examples are added to
     * or updated in. Format:
     * `projects/{project}/locations/{location}/exampleStores/{example_store}`
     * </pre>
     *
     * <code>
     * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for exampleStore.
     */
    public com.google.protobuf.ByteString getExampleStoreBytes() {
      java.lang.Object ref = exampleStore_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        exampleStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the ExampleStore resource that examples are added to
     * or updated in. Format:
     * `projects/{project}/locations/{location}/exampleStores/{example_store}`
     * </pre>
     *
     * <code>
     * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The exampleStore to set.
     * @return This builder for chaining.
     */
    public Builder setExampleStore(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      exampleStore_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the ExampleStore resource that examples are added to
     * or updated in. Format:
     * `projects/{project}/locations/{location}/exampleStores/{example_store}`
     * </pre>
     *
     * <code>
     * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExampleStore() {
      exampleStore_ = getDefaultInstance().getExampleStore();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the ExampleStore resource that examples are added to
     * or updated in. Format:
     * `projects/{project}/locations/{location}/exampleStores/{example_store}`
     * </pre>
     *
     * <code>
     * string example_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for exampleStore to set.
     * @return This builder for chaining.
     */
    public Builder setExampleStoreBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      exampleStore_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Example> examples_ =
        java.util.Collections.emptyList();

    private void ensureExamplesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        examples_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Example>(examples_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Example,
            com.google.cloud.aiplatform.v1beta1.Example.Builder,
            com.google.cloud.aiplatform.v1beta1.ExampleOrBuilder>
        examplesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Example> getExamplesList() {
      if (examplesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(examples_);
      } else {
        return examplesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getExamplesCount() {
      if (examplesBuilder_ == null) {
        return examples_.size();
      } else {
        return examplesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Example getExamples(int index) {
      if (examplesBuilder_ == null) {
        return examples_.get(index);
      } else {
        return examplesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setExamples(int index, com.google.cloud.aiplatform.v1beta1.Example value) {
      if (examplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExamplesIsMutable();
        examples_.set(index, value);
        onChanged();
      } else {
        examplesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setExamples(
        int index, com.google.cloud.aiplatform.v1beta1.Example.Builder builderForValue) {
      if (examplesBuilder_ == null) {
        ensureExamplesIsMutable();
        examples_.set(index, builderForValue.build());
        onChanged();
      } else {
        examplesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addExamples(com.google.cloud.aiplatform.v1beta1.Example value) {
      if (examplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExamplesIsMutable();
        examples_.add(value);
        onChanged();
      } else {
        examplesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addExamples(int index, com.google.cloud.aiplatform.v1beta1.Example value) {
      if (examplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExamplesIsMutable();
        examples_.add(index, value);
        onChanged();
      } else {
        examplesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addExamples(
        com.google.cloud.aiplatform.v1beta1.Example.Builder builderForValue) {
      if (examplesBuilder_ == null) {
        ensureExamplesIsMutable();
        examples_.add(builderForValue.build());
        onChanged();
      } else {
        examplesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addExamples(
        int index, com.google.cloud.aiplatform.v1beta1.Example.Builder builderForValue) {
      if (examplesBuilder_ == null) {
        ensureExamplesIsMutable();
        examples_.add(index, builderForValue.build());
        onChanged();
      } else {
        examplesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllExamples(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Example> values) {
      if (examplesBuilder_ == null) {
        ensureExamplesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, examples_);
        onChanged();
      } else {
        examplesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearExamples() {
      if (examplesBuilder_ == null) {
        examples_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        examplesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeExamples(int index) {
      if (examplesBuilder_ == null) {
        ensureExamplesIsMutable();
        examples_.remove(index);
        onChanged();
      } else {
        examplesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Example.Builder getExamplesBuilder(int index) {
      return getExamplesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExampleOrBuilder getExamplesOrBuilder(int index) {
      if (examplesBuilder_ == null) {
        return examples_.get(index);
      } else {
        return examplesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ExampleOrBuilder>
        getExamplesOrBuilderList() {
      if (examplesBuilder_ != null) {
        return examplesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(examples_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Example.Builder addExamplesBuilder() {
      return getExamplesFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Example.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Example.Builder addExamplesBuilder(int index) {
      return getExamplesFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Example.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. A list of examples to be created/updated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Example examples = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Example.Builder>
        getExamplesBuilderList() {
      return getExamplesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Example,
            com.google.cloud.aiplatform.v1beta1.Example.Builder,
            com.google.cloud.aiplatform.v1beta1.ExampleOrBuilder>
        getExamplesFieldBuilder() {
      if (examplesBuilder_ == null) {
        examplesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Example,
                com.google.cloud.aiplatform.v1beta1.Example.Builder,
                com.google.cloud.aiplatform.v1beta1.ExampleOrBuilder>(
                examples_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        examples_ = null;
      }
      return examplesBuilder_;
    }

    private boolean overwrite_;

    /**
     *
     *
     * <pre>
     * Optional. A flag indicating whether an example can be overwritten if it
     * already exists. If False (default) and the example already exists, the
     * example will not be updated. This does not affect behavior if the example
     * does not exist already.
     * </pre>
     *
     * <code>bool overwrite = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The overwrite.
     */
    @java.lang.Override
    public boolean getOverwrite() {
      return overwrite_;
    }

    /**
     *
     *
     * <pre>
     * Optional. A flag indicating whether an example can be overwritten if it
     * already exists. If False (default) and the example already exists, the
     * example will not be updated. This does not affect behavior if the example
     * does not exist already.
     * </pre>
     *
     * <code>bool overwrite = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The overwrite to set.
     * @return This builder for chaining.
     */
    public Builder setOverwrite(boolean value) {

      overwrite_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A flag indicating whether an example can be overwritten if it
     * already exists. If False (default) and the example already exists, the
     * example will not be updated. This does not affect behavior if the example
     * does not exist already.
     * </pre>
     *
     * <code>bool overwrite = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOverwrite() {
      bitField0_ = (bitField0_ & ~0x00000004);
      overwrite_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.UpsertExamplesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.UpsertExamplesRequest)
  private static final com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpsertExamplesRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpsertExamplesRequest>() {
        @java.lang.Override
        public UpsertExamplesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpsertExamplesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpsertExamplesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.UpsertExamplesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
