/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/prediction_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [PredictionService.CountTokens][google.cloud.aiplatform.v1beta1.PredictionService.CountTokens].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.CountTokensRequest}
 */
public final class CountTokensRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.CountTokensRequest)
    CountTokensRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CountTokensRequest.newBuilder() to construct.
  private CountTokensRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CountTokensRequest() {
    endpoint_ = "";
    model_ = "";
    instances_ = java.util.Collections.emptyList();
    contents_ = java.util.Collections.emptyList();
    tools_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CountTokensRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_CountTokensRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_CountTokensRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.CountTokensRequest.class,
            com.google.cloud.aiplatform.v1beta1.CountTokensRequest.Builder.class);
  }

  private int bitField0_;
  public static final int ENDPOINT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object endpoint_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the Endpoint requested to perform token counting.
   * Format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public java.lang.String getEndpoint() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpoint_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the Endpoint requested to perform token counting.
   * Format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for endpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointBytes() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The name of the publisher model requested to serve the
   * prediction. Format:
   * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
   * </pre>
   *
   * <code>string model = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The name of the publisher model requested to serve the
   * prediction. Format:
   * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
   * </pre>
   *
   * <code>string model = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Value> instances_;

  /**
   *
   *
   * <pre>
   * Optional. The instances that are the input to token counting call.
   * Schema is identical to the prediction schema of the underlying model.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Value> getInstancesList() {
    return instances_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The instances that are the input to token counting call.
   * Schema is identical to the prediction schema of the underlying model.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ValueOrBuilder> getInstancesOrBuilderList() {
    return instances_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The instances that are the input to token counting call.
   * Schema is identical to the prediction schema of the underlying model.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getInstancesCount() {
    return instances_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The instances that are the input to token counting call.
   * Schema is identical to the prediction schema of the underlying model.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getInstances(int index) {
    return instances_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. The instances that are the input to token counting call.
   * Schema is identical to the prediction schema of the underlying model.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getInstancesOrBuilder(int index) {
    return instances_.get(index);
  }

  public static final int CONTENTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Content> contents_;

  /**
   *
   *
   * <pre>
   * Optional. Input content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Content> getContentsList() {
    return contents_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Input content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
      getContentsOrBuilderList() {
    return contents_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Input content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getContentsCount() {
    return contents_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Input content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Content getContents(int index) {
    return contents_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Input content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getContentsOrBuilder(int index) {
    return contents_.get(index);
  }

  public static final int SYSTEM_INSTRUCTION_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1beta1.Content systemInstruction_;

  /**
   *
   *
   * <pre>
   * Optional. The user provided system instructions for the model.
   * Note: only text should be used in parts and content in each part will be in
   * a separate paragraph.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the systemInstruction field is set.
   */
  @java.lang.Override
  public boolean hasSystemInstruction() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The user provided system instructions for the model.
   * Note: only text should be used in parts and content in each part will be in
   * a separate paragraph.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The systemInstruction.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Content getSystemInstruction() {
    return systemInstruction_ == null
        ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
        : systemInstruction_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The user provided system instructions for the model.
   * Note: only text should be used in parts and content in each part will be in
   * a separate paragraph.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getSystemInstructionOrBuilder() {
    return systemInstruction_ == null
        ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
        : systemInstruction_;
  }

  public static final int TOOLS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> tools_;

  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> getToolsList() {
    return tools_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
      getToolsOrBuilderList() {
    return tools_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getToolsCount() {
    return tools_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Tool getTools(int index) {
    return tools_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolOrBuilder getToolsOrBuilder(int index) {
    return tools_.get(index);
  }

  public static final int GENERATION_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.GenerationConfig generationConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Generation config that the model will use to generate the
   * response.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the generationConfig field is set.
   */
  @java.lang.Override
  public boolean hasGenerationConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Generation config that the model will use to generate the
   * response.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The generationConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfig getGenerationConfig() {
    return generationConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance()
        : generationConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Generation config that the model will use to generate the
   * response.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerationConfigOrBuilder
      getGenerationConfigOrBuilder() {
    return generationConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance()
        : generationConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpoint_);
    }
    for (int i = 0; i < instances_.size(); i++) {
      output.writeMessage(2, instances_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, model_);
    }
    for (int i = 0; i < contents_.size(); i++) {
      output.writeMessage(4, contents_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getSystemInstruction());
    }
    for (int i = 0; i < tools_.size(); i++) {
      output.writeMessage(6, tools_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getGenerationConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, endpoint_);
    }
    for (int i = 0; i < instances_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, instances_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, model_);
    }
    for (int i = 0; i < contents_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, contents_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSystemInstruction());
    }
    for (int i = 0; i < tools_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, tools_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getGenerationConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.CountTokensRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.CountTokensRequest other =
        (com.google.cloud.aiplatform.v1beta1.CountTokensRequest) obj;

    if (!getEndpoint().equals(other.getEndpoint())) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (!getInstancesList().equals(other.getInstancesList())) return false;
    if (!getContentsList().equals(other.getContentsList())) return false;
    if (hasSystemInstruction() != other.hasSystemInstruction()) return false;
    if (hasSystemInstruction()) {
      if (!getSystemInstruction().equals(other.getSystemInstruction())) return false;
    }
    if (!getToolsList().equals(other.getToolsList())) return false;
    if (hasGenerationConfig() != other.hasGenerationConfig()) return false;
    if (hasGenerationConfig()) {
      if (!getGenerationConfig().equals(other.getGenerationConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getEndpoint().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    if (getInstancesCount() > 0) {
      hash = (37 * hash) + INSTANCES_FIELD_NUMBER;
      hash = (53 * hash) + getInstancesList().hashCode();
    }
    if (getContentsCount() > 0) {
      hash = (37 * hash) + CONTENTS_FIELD_NUMBER;
      hash = (53 * hash) + getContentsList().hashCode();
    }
    if (hasSystemInstruction()) {
      hash = (37 * hash) + SYSTEM_INSTRUCTION_FIELD_NUMBER;
      hash = (53 * hash) + getSystemInstruction().hashCode();
    }
    if (getToolsCount() > 0) {
      hash = (37 * hash) + TOOLS_FIELD_NUMBER;
      hash = (53 * hash) + getToolsList().hashCode();
    }
    if (hasGenerationConfig()) {
      hash = (37 * hash) + GENERATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGenerationConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.CountTokensRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [PredictionService.CountTokens][google.cloud.aiplatform.v1beta1.PredictionService.CountTokens].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.CountTokensRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.CountTokensRequest)
      com.google.cloud.aiplatform.v1beta1.CountTokensRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_CountTokensRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_CountTokensRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.CountTokensRequest.class,
              com.google.cloud.aiplatform.v1beta1.CountTokensRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.CountTokensRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInstancesFieldBuilder();
        getContentsFieldBuilder();
        getSystemInstructionFieldBuilder();
        getToolsFieldBuilder();
        getGenerationConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      endpoint_ = "";
      model_ = "";
      if (instancesBuilder_ == null) {
        instances_ = java.util.Collections.emptyList();
      } else {
        instances_ = null;
        instancesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (contentsBuilder_ == null) {
        contents_ = java.util.Collections.emptyList();
      } else {
        contents_ = null;
        contentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      systemInstruction_ = null;
      if (systemInstructionBuilder_ != null) {
        systemInstructionBuilder_.dispose();
        systemInstructionBuilder_ = null;
      }
      if (toolsBuilder_ == null) {
        tools_ = java.util.Collections.emptyList();
      } else {
        tools_ = null;
        toolsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      generationConfig_ = null;
      if (generationConfigBuilder_ != null) {
        generationConfigBuilder_.dispose();
        generationConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_CountTokensRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CountTokensRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.CountTokensRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CountTokensRequest build() {
      com.google.cloud.aiplatform.v1beta1.CountTokensRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CountTokensRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.CountTokensRequest result =
          new com.google.cloud.aiplatform.v1beta1.CountTokensRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.CountTokensRequest result) {
      if (instancesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          instances_ = java.util.Collections.unmodifiableList(instances_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.instances_ = instances_;
      } else {
        result.instances_ = instancesBuilder_.build();
      }
      if (contentsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          contents_ = java.util.Collections.unmodifiableList(contents_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.contents_ = contents_;
      } else {
        result.contents_ = contentsBuilder_.build();
      }
      if (toolsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          tools_ = java.util.Collections.unmodifiableList(tools_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.tools_ = tools_;
      } else {
        result.tools_ = toolsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.CountTokensRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.endpoint_ = endpoint_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.model_ = model_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.systemInstruction_ =
            systemInstructionBuilder_ == null
                ? systemInstruction_
                : systemInstructionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.generationConfig_ =
            generationConfigBuilder_ == null ? generationConfig_ : generationConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.CountTokensRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.CountTokensRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.CountTokensRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.CountTokensRequest.getDefaultInstance())
        return this;
      if (!other.getEndpoint().isEmpty()) {
        endpoint_ = other.endpoint_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (instancesBuilder_ == null) {
        if (!other.instances_.isEmpty()) {
          if (instances_.isEmpty()) {
            instances_ = other.instances_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureInstancesIsMutable();
            instances_.addAll(other.instances_);
          }
          onChanged();
        }
      } else {
        if (!other.instances_.isEmpty()) {
          if (instancesBuilder_.isEmpty()) {
            instancesBuilder_.dispose();
            instancesBuilder_ = null;
            instances_ = other.instances_;
            bitField0_ = (bitField0_ & ~0x00000004);
            instancesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInstancesFieldBuilder()
                    : null;
          } else {
            instancesBuilder_.addAllMessages(other.instances_);
          }
        }
      }
      if (contentsBuilder_ == null) {
        if (!other.contents_.isEmpty()) {
          if (contents_.isEmpty()) {
            contents_ = other.contents_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureContentsIsMutable();
            contents_.addAll(other.contents_);
          }
          onChanged();
        }
      } else {
        if (!other.contents_.isEmpty()) {
          if (contentsBuilder_.isEmpty()) {
            contentsBuilder_.dispose();
            contentsBuilder_ = null;
            contents_ = other.contents_;
            bitField0_ = (bitField0_ & ~0x00000008);
            contentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContentsFieldBuilder()
                    : null;
          } else {
            contentsBuilder_.addAllMessages(other.contents_);
          }
        }
      }
      if (other.hasSystemInstruction()) {
        mergeSystemInstruction(other.getSystemInstruction());
      }
      if (toolsBuilder_ == null) {
        if (!other.tools_.isEmpty()) {
          if (tools_.isEmpty()) {
            tools_ = other.tools_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureToolsIsMutable();
            tools_.addAll(other.tools_);
          }
          onChanged();
        }
      } else {
        if (!other.tools_.isEmpty()) {
          if (toolsBuilder_.isEmpty()) {
            toolsBuilder_.dispose();
            toolsBuilder_ = null;
            tools_ = other.tools_;
            bitField0_ = (bitField0_ & ~0x00000020);
            toolsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getToolsFieldBuilder()
                    : null;
          } else {
            toolsBuilder_.addAllMessages(other.tools_);
          }
        }
      }
      if (other.hasGenerationConfig()) {
        mergeGenerationConfig(other.getGenerationConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                endpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.Value m =
                    input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
                if (instancesBuilder_ == null) {
                  ensureInstancesIsMutable();
                  instances_.add(m);
                } else {
                  instancesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.aiplatform.v1beta1.Content m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Content.parser(), extensionRegistry);
                if (contentsBuilder_ == null) {
                  ensureContentsIsMutable();
                  contents_.add(m);
                } else {
                  contentsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getSystemInstructionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.aiplatform.v1beta1.Tool m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Tool.parser(), extensionRegistry);
                if (toolsBuilder_ == null) {
                  ensureToolsIsMutable();
                  tools_.add(m);
                } else {
                  toolsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getGenerationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object endpoint_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to perform token counting.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The endpoint.
     */
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to perform token counting.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for endpoint.
     */
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to perform token counting.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endpoint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to perform token counting.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpoint() {
      endpoint_ = getDefaultInstance().getEndpoint();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to perform token counting.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endpoint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object model_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The name of the publisher model requested to serve the
     * prediction. Format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     * </pre>
     *
     * <code>string model = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the publisher model requested to serve the
     * prediction. Format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     * </pre>
     *
     * <code>string model = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the publisher model requested to serve the
     * prediction. Format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     * </pre>
     *
     * <code>string model = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the publisher model requested to serve the
     * prediction. Format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     * </pre>
     *
     * <code>string model = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the publisher model requested to serve the
     * prediction. Format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     * </pre>
     *
     * <code>string model = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.Value> instances_ =
        java.util.Collections.emptyList();

    private void ensureInstancesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        instances_ = new java.util.ArrayList<com.google.protobuf.Value>(instances_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        instancesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.protobuf.Value> getInstancesList() {
      if (instancesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(instances_);
      } else {
        return instancesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getInstancesCount() {
      if (instancesBuilder_ == null) {
        return instances_.size();
      } else {
        return instancesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Value getInstances(int index) {
      if (instancesBuilder_ == null) {
        return instances_.get(index);
      } else {
        return instancesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInstances(int index, com.google.protobuf.Value value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.set(index, value);
        onChanged();
      } else {
        instancesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInstances(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.set(index, builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInstances(com.google.protobuf.Value value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.add(value);
        onChanged();
      } else {
        instancesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInstances(int index, com.google.protobuf.Value value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.add(index, value);
        onChanged();
      } else {
        instancesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInstances(com.google.protobuf.Value.Builder builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.add(builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInstances(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.add(index, builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllInstances(java.lang.Iterable<? extends com.google.protobuf.Value> values) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instances_);
        onChanged();
      } else {
        instancesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInstances() {
      if (instancesBuilder_ == null) {
        instances_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        instancesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeInstances(int index) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.remove(index);
        onChanged();
      } else {
        instancesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Value.Builder getInstancesBuilder(int index) {
      return getInstancesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.ValueOrBuilder getInstancesOrBuilder(int index) {
      if (instancesBuilder_ == null) {
        return instances_.get(index);
      } else {
        return instancesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
        getInstancesOrBuilderList() {
      if (instancesBuilder_ != null) {
        return instancesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(instances_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Value.Builder addInstancesBuilder() {
      return getInstancesFieldBuilder().addBuilder(com.google.protobuf.Value.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Value.Builder addInstancesBuilder(int index) {
      return getInstancesFieldBuilder()
          .addBuilder(index, com.google.protobuf.Value.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The instances that are the input to token counting call.
     * Schema is identical to the prediction schema of the underlying model.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.protobuf.Value.Builder> getInstancesBuilderList() {
      return getInstancesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getInstancesFieldBuilder() {
      if (instancesBuilder_ == null) {
        instancesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                instances_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        instances_ = null;
      }
      return instancesBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Content> contents_ =
        java.util.Collections.emptyList();

    private void ensureContentsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        contents_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Content>(contents_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        contentsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Content> getContentsList() {
      if (contentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contents_);
      } else {
        return contentsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getContentsCount() {
      if (contentsBuilder_ == null) {
        return contents_.size();
      } else {
        return contentsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content getContents(int index) {
      if (contentsBuilder_ == null) {
        return contents_.get(index);
      } else {
        return contentsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContents(int index, com.google.cloud.aiplatform.v1beta1.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.set(index, value);
        onChanged();
      } else {
        contentsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContents(
        int index, com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.set(index, builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addContents(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.add(value);
        onChanged();
      } else {
        contentsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addContents(int index, com.google.cloud.aiplatform.v1beta1.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.add(index, value);
        onChanged();
      } else {
        contentsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addContents(
        com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.add(builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addContents(
        int index, com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.add(index, builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllContents(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Content> values) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contents_);
        onChanged();
      } else {
        contentsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearContents() {
      if (contentsBuilder_ == null) {
        contents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        contentsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeContents(int index) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.remove(index);
        onChanged();
      } else {
        contentsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder getContentsBuilder(int index) {
      return getContentsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getContentsOrBuilder(int index) {
      if (contentsBuilder_ == null) {
        return contents_.get(index);
      } else {
        return contentsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getContentsOrBuilderList() {
      if (contentsBuilder_ != null) {
        return contentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contents_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder addContentsBuilder() {
      return getContentsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder addContentsBuilder(int index) {
      return getContentsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Content contents = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Content.Builder>
        getContentsBuilderList() {
      return getContentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getContentsFieldBuilder() {
      if (contentsBuilder_ == null) {
        contentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Content,
                com.google.cloud.aiplatform.v1beta1.Content.Builder,
                com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>(
                contents_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        contents_ = null;
      }
      return contentsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.Content systemInstruction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        systemInstructionBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the systemInstruction field is set.
     */
    public boolean hasSystemInstruction() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The systemInstruction.
     */
    public com.google.cloud.aiplatform.v1beta1.Content getSystemInstruction() {
      if (systemInstructionBuilder_ == null) {
        return systemInstruction_ == null
            ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
            : systemInstruction_;
      } else {
        return systemInstructionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSystemInstruction(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (systemInstructionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        systemInstruction_ = value;
      } else {
        systemInstructionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSystemInstruction(
        com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (systemInstructionBuilder_ == null) {
        systemInstruction_ = builderForValue.build();
      } else {
        systemInstructionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSystemInstruction(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (systemInstructionBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && systemInstruction_ != null
            && systemInstruction_
                != com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()) {
          getSystemInstructionBuilder().mergeFrom(value);
        } else {
          systemInstruction_ = value;
        }
      } else {
        systemInstructionBuilder_.mergeFrom(value);
      }
      if (systemInstruction_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSystemInstruction() {
      bitField0_ = (bitField0_ & ~0x00000010);
      systemInstruction_ = null;
      if (systemInstructionBuilder_ != null) {
        systemInstructionBuilder_.dispose();
        systemInstructionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder getSystemInstructionBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getSystemInstructionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getSystemInstructionOrBuilder() {
      if (systemInstructionBuilder_ != null) {
        return systemInstructionBuilder_.getMessageOrBuilder();
      } else {
        return systemInstruction_ == null
            ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
            : systemInstruction_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.Content system_instruction = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getSystemInstructionFieldBuilder() {
      if (systemInstructionBuilder_ == null) {
        systemInstructionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Content,
                com.google.cloud.aiplatform.v1beta1.Content.Builder,
                com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>(
                getSystemInstruction(), getParentForChildren(), isClean());
        systemInstruction_ = null;
      }
      return systemInstructionBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> tools_ =
        java.util.Collections.emptyList();

    private void ensureToolsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        tools_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Tool>(tools_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Tool,
            com.google.cloud.aiplatform.v1beta1.Tool.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
        toolsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Tool> getToolsList() {
      if (toolsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tools_);
      } else {
        return toolsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getToolsCount() {
      if (toolsBuilder_ == null) {
        return tools_.size();
      } else {
        return toolsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool getTools(int index) {
      if (toolsBuilder_ == null) {
        return tools_.get(index);
      } else {
        return toolsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTools(int index, com.google.cloud.aiplatform.v1beta1.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.set(index, value);
        onChanged();
      } else {
        toolsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTools(
        int index, com.google.cloud.aiplatform.v1beta1.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.set(index, builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(com.google.cloud.aiplatform.v1beta1.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.add(value);
        onChanged();
      } else {
        toolsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(int index, com.google.cloud.aiplatform.v1beta1.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.add(index, value);
        onChanged();
      } else {
        toolsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(com.google.cloud.aiplatform.v1beta1.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.add(builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(
        int index, com.google.cloud.aiplatform.v1beta1.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.add(index, builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllTools(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Tool> values) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tools_);
        onChanged();
      } else {
        toolsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTools() {
      if (toolsBuilder_ == null) {
        tools_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        toolsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeTools(int index) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.remove(index);
        onChanged();
      } else {
        toolsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool.Builder getToolsBuilder(int index) {
      return getToolsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolOrBuilder getToolsOrBuilder(int index) {
      if (toolsBuilder_ == null) {
        return tools_.get(index);
      } else {
        return toolsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
        getToolsOrBuilderList() {
      if (toolsBuilder_ != null) {
        return toolsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tools_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool.Builder addToolsBuilder() {
      return getToolsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Tool.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Tool.Builder addToolsBuilder(int index) {
      return getToolsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Tool.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Tool.Builder> getToolsBuilderList() {
      return getToolsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Tool,
            com.google.cloud.aiplatform.v1beta1.Tool.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>
        getToolsFieldBuilder() {
      if (toolsBuilder_ == null) {
        toolsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Tool,
                com.google.cloud.aiplatform.v1beta1.Tool.Builder,
                com.google.cloud.aiplatform.v1beta1.ToolOrBuilder>(
                tools_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        tools_ = null;
      }
      return toolsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.GenerationConfig generationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerationConfig,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerationConfigOrBuilder>
        generationConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Generation config that the model will use to generate the
     * response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the generationConfig field is set.
     */
    public boolean hasGenerationConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config that the model will use to generate the
     * response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The generationConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig getGenerationConfig() {
      if (generationConfigBuilder_ == null) {
        return generationConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance()
            : generationConfig_;
      } else {
        return generationConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config that the model will use to generate the
     * response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGenerationConfig(com.google.cloud.aiplatform.v1beta1.GenerationConfig value) {
      if (generationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        generationConfig_ = value;
      } else {
        generationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config that the model will use to generate the
     * response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGenerationConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder builderForValue) {
      if (generationConfigBuilder_ == null) {
        generationConfig_ = builderForValue.build();
      } else {
        generationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config that the model will use to generate the
     * response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGenerationConfig(
        com.google.cloud.aiplatform.v1beta1.GenerationConfig value) {
      if (generationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && generationConfig_ != null
            && generationConfig_
                != com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance()) {
          getGenerationConfigBuilder().mergeFrom(value);
        } else {
          generationConfig_ = value;
        }
      } else {
        generationConfigBuilder_.mergeFrom(value);
      }
      if (generationConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config that the model will use to generate the
     * response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGenerationConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      generationConfig_ = null;
      if (generationConfigBuilder_ != null) {
        generationConfigBuilder_.dispose();
        generationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config that the model will use to generate the
     * response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder
        getGenerationConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getGenerationConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config that the model will use to generate the
     * response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerationConfigOrBuilder
        getGenerationConfigOrBuilder() {
      if (generationConfigBuilder_ != null) {
        return generationConfigBuilder_.getMessageOrBuilder();
      } else {
        return generationConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerationConfig.getDefaultInstance()
            : generationConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Generation config that the model will use to generate the
     * response.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.GenerationConfig generation_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerationConfig,
            com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerationConfigOrBuilder>
        getGenerationConfigFieldBuilder() {
      if (generationConfigBuilder_ == null) {
        generationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenerationConfig,
                com.google.cloud.aiplatform.v1beta1.GenerationConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.GenerationConfigOrBuilder>(
                getGenerationConfig(), getParentForChildren(), isClean());
        generationConfig_ = null;
      }
      return generationConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.CountTokensRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.CountTokensRequest)
  private static final com.google.cloud.aiplatform.v1beta1.CountTokensRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.CountTokensRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.CountTokensRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CountTokensRequest> PARSER =
      new com.google.protobuf.AbstractParser<CountTokensRequest>() {
        @java.lang.Override
        public CountTokensRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CountTokensRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CountTokensRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CountTokensRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
