/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tuning_job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Evaluation Config for Tuning Job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.EvaluationConfig}
 */
public final class EvaluationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.EvaluationConfig)
    EvaluationConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use EvaluationConfig.newBuilder() to construct.
  private EvaluationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EvaluationConfig() {
    metrics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EvaluationConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_EvaluationConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_EvaluationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.EvaluationConfig.class,
            com.google.cloud.aiplatform.v1beta1.EvaluationConfig.Builder.class);
  }

  private int bitField0_;
  public static final int METRICS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Metric> metrics_;

  /**
   *
   *
   * <pre>
   * Required. The metrics used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Metric> getMetricsList() {
    return metrics_;
  }

  /**
   *
   *
   * <pre>
   * Required. The metrics used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.MetricOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }

  /**
   *
   *
   * <pre>
   * Required. The metrics used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The metrics used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Metric getMetrics(int index) {
    return metrics_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The metrics used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MetricOrBuilder getMetricsOrBuilder(int index) {
    return metrics_.get(index);
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.OutputConfig outputConfig_;

  /**
   *
   *
   * <pre>
   * Required. Config for evaluation output.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Config for evaluation output.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.OutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }

  /**
   *
   *
   * <pre>
   * Required. Config for evaluation output.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.OutputConfigOrBuilder getOutputConfigOrBuilder() {
    return outputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }

  public static final int AUTORATER_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.AutoraterConfig autoraterConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Autorater config for evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the autoraterConfig field is set.
   */
  @java.lang.Override
  public boolean hasAutoraterConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Autorater config for evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autoraterConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AutoraterConfig getAutoraterConfig() {
    return autoraterConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.AutoraterConfig.getDefaultInstance()
        : autoraterConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Autorater config for evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AutoraterConfigOrBuilder
      getAutoraterConfigOrBuilder() {
    return autoraterConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.AutoraterConfig.getDefaultInstance()
        : autoraterConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(1, metrics_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getOutputConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getAutoraterConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, metrics_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOutputConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAutoraterConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.EvaluationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.EvaluationConfig other =
        (com.google.cloud.aiplatform.v1beta1.EvaluationConfig) obj;

    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (hasAutoraterConfig() != other.hasAutoraterConfig()) return false;
    if (hasAutoraterConfig()) {
      if (!getAutoraterConfig().equals(other.getAutoraterConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    if (hasAutoraterConfig()) {
      hash = (37 * hash) + AUTORATER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAutoraterConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.EvaluationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Evaluation Config for Tuning Job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.EvaluationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.EvaluationConfig)
      com.google.cloud.aiplatform.v1beta1.EvaluationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_EvaluationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_EvaluationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.EvaluationConfig.class,
              com.google.cloud.aiplatform.v1beta1.EvaluationConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.EvaluationConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMetricsFieldBuilder();
        getOutputConfigFieldBuilder();
        getAutoraterConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
      } else {
        metrics_ = null;
        metricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      autoraterConfig_ = null;
      if (autoraterConfigBuilder_ != null) {
        autoraterConfigBuilder_.dispose();
        autoraterConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_EvaluationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EvaluationConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EvaluationConfig build() {
      com.google.cloud.aiplatform.v1beta1.EvaluationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EvaluationConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.EvaluationConfig result =
          new com.google.cloud.aiplatform.v1beta1.EvaluationConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.EvaluationConfig result) {
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.EvaluationConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.outputConfig_ =
            outputConfigBuilder_ == null ? outputConfig_ : outputConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.autoraterConfig_ =
            autoraterConfigBuilder_ == null ? autoraterConfig_ : autoraterConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.EvaluationConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.EvaluationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.EvaluationConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.EvaluationConfig.getDefaultInstance())
        return this;
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000001);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      if (other.hasAutoraterConfig()) {
        mergeAutoraterConfig(other.getAutoraterConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.Metric m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Metric.parser(), extensionRegistry);
                if (metricsBuilder_ == null) {
                  ensureMetricsIsMutable();
                  metrics_.add(m);
                } else {
                  metricsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAutoraterConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Metric> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        metrics_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Metric>(metrics_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Metric,
            com.google.cloud.aiplatform.v1beta1.Metric.Builder,
            com.google.cloud.aiplatform.v1beta1.MetricOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Metric> getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Metric getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetrics(int index, com.google.cloud.aiplatform.v1beta1.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetrics(
        int index, com.google.cloud.aiplatform.v1beta1.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(com.google.cloud.aiplatform.v1beta1.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(int index, com.google.cloud.aiplatform.v1beta1.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(com.google.cloud.aiplatform.v1beta1.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(
        int index, com.google.cloud.aiplatform.v1beta1.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Metric> values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Metric.Builder getMetricsBuilder(int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MetricOrBuilder getMetricsOrBuilder(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.MetricOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Metric.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Metric.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Metric.Builder addMetricsBuilder(int index) {
      return getMetricsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Metric.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The metrics used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Metric.Builder>
        getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Metric,
            com.google.cloud.aiplatform.v1beta1.Metric.Builder,
            com.google.cloud.aiplatform.v1beta1.MetricOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Metric,
                com.google.cloud.aiplatform.v1beta1.Metric.Builder,
                com.google.cloud.aiplatform.v1beta1.MetricOrBuilder>(
                metrics_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.OutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.OutputConfig,
            com.google.cloud.aiplatform.v1beta1.OutputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.OutputConfigOrBuilder>
        outputConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.OutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.OutputConfig.getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(com.google.cloud.aiplatform.v1beta1.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
      } else {
        outputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.aiplatform.v1beta1.OutputConfig.Builder builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOutputConfig(com.google.cloud.aiplatform.v1beta1.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && outputConfig_ != null
            && outputConfig_
                != com.google.cloud.aiplatform.v1beta1.OutputConfig.getDefaultInstance()) {
          getOutputConfigBuilder().mergeFrom(value);
        } else {
          outputConfig_ = value;
        }
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }
      if (outputConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOutputConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.OutputConfig.Builder getOutputConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.OutputConfigOrBuilder getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.OutputConfig.getDefaultInstance()
            : outputConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Config for evaluation output.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.OutputConfig,
            com.google.cloud.aiplatform.v1beta1.OutputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.OutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.OutputConfig,
                com.google.cloud.aiplatform.v1beta1.OutputConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.OutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.AutoraterConfig autoraterConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AutoraterConfig,
            com.google.cloud.aiplatform.v1beta1.AutoraterConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AutoraterConfigOrBuilder>
        autoraterConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Autorater config for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the autoraterConfig field is set.
     */
    public boolean hasAutoraterConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The autoraterConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.AutoraterConfig getAutoraterConfig() {
      if (autoraterConfigBuilder_ == null) {
        return autoraterConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.AutoraterConfig.getDefaultInstance()
            : autoraterConfig_;
      } else {
        return autoraterConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoraterConfig(com.google.cloud.aiplatform.v1beta1.AutoraterConfig value) {
      if (autoraterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoraterConfig_ = value;
      } else {
        autoraterConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoraterConfig(
        com.google.cloud.aiplatform.v1beta1.AutoraterConfig.Builder builderForValue) {
      if (autoraterConfigBuilder_ == null) {
        autoraterConfig_ = builderForValue.build();
      } else {
        autoraterConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAutoraterConfig(com.google.cloud.aiplatform.v1beta1.AutoraterConfig value) {
      if (autoraterConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && autoraterConfig_ != null
            && autoraterConfig_
                != com.google.cloud.aiplatform.v1beta1.AutoraterConfig.getDefaultInstance()) {
          getAutoraterConfigBuilder().mergeFrom(value);
        } else {
          autoraterConfig_ = value;
        }
      } else {
        autoraterConfigBuilder_.mergeFrom(value);
      }
      if (autoraterConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAutoraterConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      autoraterConfig_ = null;
      if (autoraterConfigBuilder_ != null) {
        autoraterConfigBuilder_.dispose();
        autoraterConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AutoraterConfig.Builder getAutoraterConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAutoraterConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AutoraterConfigOrBuilder
        getAutoraterConfigOrBuilder() {
      if (autoraterConfigBuilder_ != null) {
        return autoraterConfigBuilder_.getMessageOrBuilder();
      } else {
        return autoraterConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.AutoraterConfig.getDefaultInstance()
            : autoraterConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Autorater config for evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutoraterConfig autorater_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AutoraterConfig,
            com.google.cloud.aiplatform.v1beta1.AutoraterConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AutoraterConfigOrBuilder>
        getAutoraterConfigFieldBuilder() {
      if (autoraterConfigBuilder_ == null) {
        autoraterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AutoraterConfig,
                com.google.cloud.aiplatform.v1beta1.AutoraterConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AutoraterConfigOrBuilder>(
                getAutoraterConfig(), getParentForChildren(), isClean());
        autoraterConfig_ = null;
      }
      return autoraterConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.EvaluationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.EvaluationConfig)
  private static final com.google.cloud.aiplatform.v1beta1.EvaluationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.EvaluationConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.EvaluationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EvaluationConfig> PARSER =
      new com.google.protobuf.AbstractParser<EvaluationConfig>() {
        @java.lang.Override
        public EvaluationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EvaluationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EvaluationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EvaluationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
