/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/notebook_runtime.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A runtime is a virtual machine allocated to a particular user for a
 * particular Notebook file on temporary basis with lifetime. Default runtimes
 * have a lifetime of 18 hours, while custom runtimes last for 6 months from
 * their creation or last upgrade.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.NotebookRuntime}
 */
public final class NotebookRuntime extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NotebookRuntime)
    NotebookRuntimeOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use NotebookRuntime.newBuilder() to construct.
  private NotebookRuntime(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NotebookRuntime() {
    name_ = "";
    runtimeUser_ = "";
    proxyUri_ = "";
    healthState_ = 0;
    displayName_ = "";
    description_ = "";
    serviceAccount_ = "";
    runtimeState_ = 0;
    version_ = "";
    notebookRuntimeType_ = 0;
    networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NotebookRuntime();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.NotebookRuntimeProto
        .internal_static_google_cloud_aiplatform_v1beta1_NotebookRuntime_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 16:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.NotebookRuntimeProto
        .internal_static_google_cloud_aiplatform_v1beta1_NotebookRuntime_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.NotebookRuntime.class,
            com.google.cloud.aiplatform.v1beta1.NotebookRuntime.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The substate of the NotebookRuntime to display health information.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState}
   */
  public enum HealthState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified health state.
     * </pre>
     *
     * <code>HEALTH_STATE_UNSPECIFIED = 0;</code>
     */
    HEALTH_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * NotebookRuntime is in healthy state. Applies to ACTIVE state.
     * </pre>
     *
     * <code>HEALTHY = 1;</code>
     */
    HEALTHY(1),
    /**
     *
     *
     * <pre>
     * NotebookRuntime is in unhealthy state. Applies to ACTIVE state.
     * </pre>
     *
     * <code>UNHEALTHY = 2;</code>
     */
    UNHEALTHY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified health state.
     * </pre>
     *
     * <code>HEALTH_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int HEALTH_STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * NotebookRuntime is in healthy state. Applies to ACTIVE state.
     * </pre>
     *
     * <code>HEALTHY = 1;</code>
     */
    public static final int HEALTHY_VALUE = 1;

    /**
     *
     *
     * <pre>
     * NotebookRuntime is in unhealthy state. Applies to ACTIVE state.
     * </pre>
     *
     * <code>UNHEALTHY = 2;</code>
     */
    public static final int UNHEALTHY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HealthState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HealthState forNumber(int value) {
      switch (value) {
        case 0:
          return HEALTH_STATE_UNSPECIFIED;
        case 1:
          return HEALTHY;
        case 2:
          return UNHEALTHY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HealthState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<HealthState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<HealthState>() {
          public HealthState findValueByNumber(int number) {
            return HealthState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NotebookRuntime.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final HealthState[] VALUES = values();

    public static HealthState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HealthState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState)
  }

  /**
   *
   *
   * <pre>
   * The substate of the NotebookRuntime to display state of runtime.
   * The resource of NotebookRuntime is in ACTIVE state for these sub state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState}
   */
  public enum RuntimeState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified runtime state.
     * </pre>
     *
     * <code>RUNTIME_STATE_UNSPECIFIED = 0;</code>
     */
    RUNTIME_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * NotebookRuntime is in running state.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     *
     *
     * <pre>
     * NotebookRuntime is in starting state. This is when the runtime is being
     * started from a stopped state.
     * </pre>
     *
     * <code>BEING_STARTED = 2;</code>
     */
    BEING_STARTED(2),
    /**
     *
     *
     * <pre>
     * NotebookRuntime is in stopping state.
     * </pre>
     *
     * <code>BEING_STOPPED = 3;</code>
     */
    BEING_STOPPED(3),
    /**
     *
     *
     * <pre>
     * NotebookRuntime is in stopped state.
     * </pre>
     *
     * <code>STOPPED = 4;</code>
     */
    STOPPED(4),
    /**
     *
     *
     * <pre>
     * NotebookRuntime is in upgrading state. It is in the middle of upgrading
     * process.
     * </pre>
     *
     * <code>BEING_UPGRADED = 5;</code>
     */
    BEING_UPGRADED(5),
    /**
     *
     *
     * <pre>
     * NotebookRuntime was unable to start/stop properly.
     * </pre>
     *
     * <code>ERROR = 100;</code>
     */
    ERROR(100),
    /**
     *
     *
     * <pre>
     * NotebookRuntime is in invalid state. Cannot be recovered.
     * </pre>
     *
     * <code>INVALID = 101;</code>
     */
    INVALID(101),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified runtime state.
     * </pre>
     *
     * <code>RUNTIME_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int RUNTIME_STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * NotebookRuntime is in running state.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;

    /**
     *
     *
     * <pre>
     * NotebookRuntime is in starting state. This is when the runtime is being
     * started from a stopped state.
     * </pre>
     *
     * <code>BEING_STARTED = 2;</code>
     */
    public static final int BEING_STARTED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * NotebookRuntime is in stopping state.
     * </pre>
     *
     * <code>BEING_STOPPED = 3;</code>
     */
    public static final int BEING_STOPPED_VALUE = 3;

    /**
     *
     *
     * <pre>
     * NotebookRuntime is in stopped state.
     * </pre>
     *
     * <code>STOPPED = 4;</code>
     */
    public static final int STOPPED_VALUE = 4;

    /**
     *
     *
     * <pre>
     * NotebookRuntime is in upgrading state. It is in the middle of upgrading
     * process.
     * </pre>
     *
     * <code>BEING_UPGRADED = 5;</code>
     */
    public static final int BEING_UPGRADED_VALUE = 5;

    /**
     *
     *
     * <pre>
     * NotebookRuntime was unable to start/stop properly.
     * </pre>
     *
     * <code>ERROR = 100;</code>
     */
    public static final int ERROR_VALUE = 100;

    /**
     *
     *
     * <pre>
     * NotebookRuntime is in invalid state. Cannot be recovered.
     * </pre>
     *
     * <code>INVALID = 101;</code>
     */
    public static final int INVALID_VALUE = 101;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RuntimeState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RuntimeState forNumber(int value) {
      switch (value) {
        case 0:
          return RUNTIME_STATE_UNSPECIFIED;
        case 1:
          return RUNNING;
        case 2:
          return BEING_STARTED;
        case 3:
          return BEING_STOPPED;
        case 4:
          return STOPPED;
        case 5:
          return BEING_UPGRADED;
        case 100:
          return ERROR;
        case 101:
          return INVALID;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RuntimeState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RuntimeState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RuntimeState>() {
          public RuntimeState findValueByNumber(int number) {
            return RuntimeState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NotebookRuntime.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final RuntimeState[] VALUES = values();

    public static RuntimeState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RuntimeState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the NotebookRuntime.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the NotebookRuntime.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RUNTIME_USER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object runtimeUser_ = "";

  /**
   *
   *
   * <pre>
   * Required. The user email of the NotebookRuntime.
   * </pre>
   *
   * <code>string runtime_user = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The runtimeUser.
   */
  @java.lang.Override
  public java.lang.String getRuntimeUser() {
    java.lang.Object ref = runtimeUser_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      runtimeUser_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The user email of the NotebookRuntime.
   * </pre>
   *
   * <code>string runtime_user = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for runtimeUser.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRuntimeUserBytes() {
    java.lang.Object ref = runtimeUser_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      runtimeUser_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NOTEBOOK_RUNTIME_TEMPLATE_REF_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef
      notebookRuntimeTemplateRef_;

  /**
   *
   *
   * <pre>
   * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
   * created from.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the notebookRuntimeTemplateRef field is set.
   */
  @java.lang.Override
  public boolean hasNotebookRuntimeTemplateRef() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
   * created from.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The notebookRuntimeTemplateRef.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef
      getNotebookRuntimeTemplateRef() {
    return notebookRuntimeTemplateRef_ == null
        ? com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef.getDefaultInstance()
        : notebookRuntimeTemplateRef_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
   * created from.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRefOrBuilder
      getNotebookRuntimeTemplateRefOrBuilder() {
    return notebookRuntimeTemplateRef_ == null
        ? com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef.getDefaultInstance()
        : notebookRuntimeTemplateRef_;
  }

  public static final int PROXY_URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object proxyUri_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The proxy endpoint used to access the NotebookRuntime.
   * </pre>
   *
   * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The proxyUri.
   */
  @java.lang.Override
  public java.lang.String getProxyUri() {
    java.lang.Object ref = proxyUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      proxyUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The proxy endpoint used to access the NotebookRuntime.
   * </pre>
   *
   * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for proxyUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProxyUriBytes() {
    java.lang.Object ref = proxyUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      proxyUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntime was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntime was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntime was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntime was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntime was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntime was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int HEALTH_STATE_FIELD_NUMBER = 8;
  private int healthState_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The health state of the NotebookRuntime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState health_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for healthState.
   */
  @java.lang.Override
  public int getHealthStateValue() {
    return healthState_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The health state of the NotebookRuntime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState health_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The healthState.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState getHealthState() {
    com.google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState result =
        com.google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState.forNumber(healthState_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState.UNRECOGNIZED
        : result;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Required. The display name of the NotebookRuntime.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The display name of the NotebookRuntime.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * The description of the NotebookRuntime.
   * </pre>
   *
   * <code>string description = 11;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The description of the NotebookRuntime.
   * </pre>
   *
   * <code>string description = 11;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Deprecated: This field is no longer used and the "Vertex AI
   * Notebook Service Account"
   * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
   * used for the runtime workload identity.
   * See
   * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
   * for more details.
   *
   * The service account that the NotebookRuntime workload runs as.
   * </pre>
   *
   * <code>string service_account = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Deprecated: This field is no longer used and the "Vertex AI
   * Notebook Service Account"
   * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
   * used for the runtime workload identity.
   * See
   * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
   * for more details.
   *
   * The service account that the NotebookRuntime workload runs as.
   * </pre>
   *
   * <code>string service_account = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RUNTIME_STATE_FIELD_NUMBER = 14;
  private int runtimeState_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The runtime (instance) state of the NotebookRuntime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState runtime_state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for runtimeState.
   */
  @java.lang.Override
  public int getRuntimeStateValue() {
    return runtimeState_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The runtime (instance) state of the NotebookRuntime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState runtime_state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The runtimeState.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState getRuntimeState() {
    com.google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState result =
        com.google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState.forNumber(runtimeState_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState.UNRECOGNIZED
        : result;
  }

  public static final int IS_UPGRADABLE_FIELD_NUMBER = 15;
  private boolean isUpgradable_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Whether NotebookRuntime is upgradable.
   * </pre>
   *
   * <code>bool is_upgradable = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The isUpgradable.
   */
  @java.lang.Override
  public boolean getIsUpgradable() {
    return isUpgradable_;
  }

  public static final int LABELS_FIELD_NUMBER = 16;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.NotebookRuntimeProto
                .internal_static_google_cloud_aiplatform_v1beta1_NotebookRuntime_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your
   * NotebookRuntime.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * No more than 64 user labels can be associated with one NotebookRuntime
   * (System labels are excluded).
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for NotebookRuntime:
   *
   * * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
   * only, its value is the Compute Engine instance id.
   * * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
   * either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
   * describe the entry service, either BigQuery or Vertex.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your
   * NotebookRuntime.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * No more than 64 user labels can be associated with one NotebookRuntime
   * (System labels are excluded).
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for NotebookRuntime:
   *
   * * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
   * only, its value is the Compute Engine instance id.
   * * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
   * either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
   * describe the entry service, either BigQuery or Vertex.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your
   * NotebookRuntime.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * No more than 64 user labels can be associated with one NotebookRuntime
   * (System labels are excluded).
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for NotebookRuntime:
   *
   * * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
   * only, its value is the Compute Engine instance id.
   * * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
   * either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
   * describe the entry service, either BigQuery or Vertex.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your
   * NotebookRuntime.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * No more than 64 user labels can be associated with one NotebookRuntime
   * (System labels are excluded).
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for NotebookRuntime:
   *
   * * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
   * only, its value is the Compute Engine instance id.
   * * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
   * either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
   * describe the entry service, either BigQuery or Vertex.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int EXPIRATION_TIME_FIELD_NUMBER = 17;
  private com.google.protobuf.Timestamp expirationTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntime will be expired:
   * 1. System Predefined NotebookRuntime: 24 hours after creation. After
   * expiration, system predifined runtime will be deleted.
   * 2. User created NotebookRuntime: 6 months after last upgrade. After
   * expiration, user created runtime will be stopped and allowed for upgrade.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expirationTime field is set.
   */
  @java.lang.Override
  public boolean hasExpirationTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntime will be expired:
   * 1. System Predefined NotebookRuntime: 24 hours after creation. After
   * expiration, system predifined runtime will be deleted.
   * 2. User created NotebookRuntime: 6 months after last upgrade. After
   * expiration, user created runtime will be stopped and allowed for upgrade.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expirationTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpirationTime() {
    return expirationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : expirationTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntime will be expired:
   * 1. System Predefined NotebookRuntime: 24 hours after creation. After
   * expiration, system predifined runtime will be deleted.
   * 2. User created NotebookRuntime: 6 months after last upgrade. After
   * expiration, user created runtime will be stopped and allowed for upgrade.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpirationTimeOrBuilder() {
    return expirationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : expirationTime_;
  }

  public static final int VERSION_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The VM os image version of NotebookRuntime.
   * </pre>
   *
   * <code>string version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The VM os image version of NotebookRuntime.
   * </pre>
   *
   * <code>string version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NOTEBOOK_RUNTIME_TYPE_FIELD_NUMBER = 19;
  private int notebookRuntimeType_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The type of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for notebookRuntimeType.
   */
  @java.lang.Override
  public int getNotebookRuntimeTypeValue() {
    return notebookRuntimeType_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The type of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The notebookRuntimeType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookRuntimeType getNotebookRuntimeType() {
    com.google.cloud.aiplatform.v1beta1.NotebookRuntimeType result =
        com.google.cloud.aiplatform.v1beta1.NotebookRuntimeType.forNumber(notebookRuntimeType_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.NotebookRuntimeType.UNRECOGNIZED
        : result;
  }

  public static final int MACHINE_SPEC_FIELD_NUMBER = 20;
  private com.google.cloud.aiplatform.v1beta1.MachineSpec machineSpec_;

  /**
   *
   *
   * <pre>
   * Output only. The specification of a single machine used by the notebook
   * runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the machineSpec field is set.
   */
  @java.lang.Override
  public boolean hasMachineSpec() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The specification of a single machine used by the notebook
   * runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The machineSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MachineSpec getMachineSpec() {
    return machineSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
        : machineSpec_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The specification of a single machine used by the notebook
   * runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
    return machineSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
        : machineSpec_;
  }

  public static final int DATA_PERSISTENT_DISK_SPEC_FIELD_NUMBER = 21;
  private com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec dataPersistentDiskSpec_;

  /**
   *
   *
   * <pre>
   * Output only. The specification of [persistent
   * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
   * attached to the notebook runtime as data disk storage.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dataPersistentDiskSpec field is set.
   */
  @java.lang.Override
  public boolean hasDataPersistentDiskSpec() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The specification of [persistent
   * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
   * attached to the notebook runtime as data disk storage.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataPersistentDiskSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec getDataPersistentDiskSpec() {
    return dataPersistentDiskSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec.getDefaultInstance()
        : dataPersistentDiskSpec_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The specification of [persistent
   * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
   * attached to the notebook runtime as data disk storage.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PersistentDiskSpecOrBuilder
      getDataPersistentDiskSpecOrBuilder() {
    return dataPersistentDiskSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec.getDefaultInstance()
        : dataPersistentDiskSpec_;
  }

  public static final int NETWORK_SPEC_FIELD_NUMBER = 22;
  private com.google.cloud.aiplatform.v1beta1.NetworkSpec networkSpec_;

  /**
   *
   *
   * <pre>
   * Output only. Network spec of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the networkSpec field is set.
   */
  @java.lang.Override
  public boolean hasNetworkSpec() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Network spec of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The networkSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NetworkSpec getNetworkSpec() {
    return networkSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.NetworkSpec.getDefaultInstance()
        : networkSpec_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Network spec of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NetworkSpecOrBuilder getNetworkSpecOrBuilder() {
    return networkSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.NetworkSpec.getDefaultInstance()
        : networkSpec_;
  }

  public static final int IDLE_SHUTDOWN_CONFIG_FIELD_NUMBER = 23;
  private com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idleShutdownConfig_;

  /**
   *
   *
   * <pre>
   * Output only. The idle shutdown configuration of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the idleShutdownConfig field is set.
   */
  @java.lang.Override
  public boolean hasIdleShutdownConfig() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The idle shutdown configuration of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The idleShutdownConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig getIdleShutdownConfig() {
    return idleShutdownConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig.getDefaultInstance()
        : idleShutdownConfig_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The idle shutdown configuration of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfigOrBuilder
      getIdleShutdownConfigOrBuilder() {
    return idleShutdownConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig.getDefaultInstance()
        : idleShutdownConfig_;
  }

  public static final int EUC_CONFIG_FIELD_NUMBER = 24;
  private com.google.cloud.aiplatform.v1beta1.NotebookEucConfig eucConfig_;

  /**
   *
   *
   * <pre>
   * Output only. EUC configuration of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the eucConfig field is set.
   */
  @java.lang.Override
  public boolean hasEucConfig() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. EUC configuration of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The eucConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookEucConfig getEucConfig() {
    return eucConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.NotebookEucConfig.getDefaultInstance()
        : eucConfig_;
  }

  /**
   *
   *
   * <pre>
   * Output only. EUC configuration of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookEucConfigOrBuilder getEucConfigOrBuilder() {
    return eucConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.NotebookEucConfig.getDefaultInstance()
        : eucConfig_;
  }

  public static final int SHIELDED_VM_CONFIG_FIELD_NUMBER = 32;
  private com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig shieldedVmConfig_;

  /**
   *
   *
   * <pre>
   * Output only. Runtime Shielded VM spec.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the shieldedVmConfig field is set.
   */
  @java.lang.Override
  public boolean hasShieldedVmConfig() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Runtime Shielded VM spec.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The shieldedVmConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig getShieldedVmConfig() {
    return shieldedVmConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig.getDefaultInstance()
        : shieldedVmConfig_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Runtime Shielded VM spec.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ShieldedVmConfigOrBuilder
      getShieldedVmConfigOrBuilder() {
    return shieldedVmConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig.getDefaultInstance()
        : shieldedVmConfig_;
  }

  public static final int NETWORK_TAGS_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList networkTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
   * </pre>
   *
   * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the networkTags.
   */
  public com.google.protobuf.ProtocolStringList getNetworkTagsList() {
    return networkTags_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
   * </pre>
   *
   * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of networkTags.
   */
  public int getNetworkTagsCount() {
    return networkTags_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
   * </pre>
   *
   * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The networkTags at the given index.
   */
  public java.lang.String getNetworkTags(int index) {
    return networkTags_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
   * </pre>
   *
   * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the networkTags at the given index.
   */
  public com.google.protobuf.ByteString getNetworkTagsBytes(int index) {
    return networkTags_.getByteString(index);
  }

  public static final int SOFTWARE_CONFIG_FIELD_NUMBER = 31;
  private com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig softwareConfig_;

  /**
   *
   *
   * <pre>
   * Output only. Software config of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the softwareConfig field is set.
   */
  @java.lang.Override
  public boolean hasSoftwareConfig() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Software config of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The softwareConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig getSoftwareConfig() {
    return softwareConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig.getDefaultInstance()
        : softwareConfig_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Software config of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfigOrBuilder
      getSoftwareConfigOrBuilder() {
    return softwareConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig.getDefaultInstance()
        : softwareConfig_;
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 28;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;

  /**
   *
   *
   * <pre>
   * Output only. Customer-managed encryption key spec for the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Customer-managed encryption key spec for the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Customer-managed encryption key spec for the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 29;
  private boolean satisfiesPzs_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 30;
  private boolean satisfiesPzi_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(runtimeUser_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, runtimeUser_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getNotebookRuntimeTemplateRef());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(proxyUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, proxyUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    if (healthState_
        != com.google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState.HEALTH_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, healthState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, serviceAccount_);
    }
    if (runtimeState_
        != com.google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState
            .RUNTIME_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(14, runtimeState_);
    }
    if (isUpgradable_ != false) {
      output.writeBool(15, isUpgradable_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 16);
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(17, getExpirationTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, version_);
    }
    if (notebookRuntimeType_
        != com.google.cloud.aiplatform.v1beta1.NotebookRuntimeType.NOTEBOOK_RUNTIME_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(19, notebookRuntimeType_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(20, getMachineSpec());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(21, getDataPersistentDiskSpec());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(22, getNetworkSpec());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(23, getIdleShutdownConfig());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(24, getEucConfig());
    }
    for (int i = 0; i < networkTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, networkTags_.getRaw(i));
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(28, getEncryptionSpec());
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(29, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(30, satisfiesPzi_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(31, getSoftwareConfig());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(32, getShieldedVmConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(runtimeUser_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, runtimeUser_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getNotebookRuntimeTemplateRef());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(proxyUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, proxyUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (healthState_
        != com.google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState.HEALTH_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, healthState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, serviceAccount_);
    }
    if (runtimeState_
        != com.google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState
            .RUNTIME_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, runtimeState_);
    }
    if (isUpgradable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, isUpgradable_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, labels__);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getExpirationTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, version_);
    }
    if (notebookRuntimeType_
        != com.google.cloud.aiplatform.v1beta1.NotebookRuntimeType.NOTEBOOK_RUNTIME_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(19, notebookRuntimeType_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getMachineSpec());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(21, getDataPersistentDiskSpec());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getNetworkSpec());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getIdleShutdownConfig());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getEucConfig());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < networkTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(networkTags_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getNetworkTagsList().size();
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(28, getEncryptionSpec());
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(29, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(30, satisfiesPzi_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, getSoftwareConfig());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(32, getShieldedVmConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.NotebookRuntime)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.NotebookRuntime other =
        (com.google.cloud.aiplatform.v1beta1.NotebookRuntime) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getRuntimeUser().equals(other.getRuntimeUser())) return false;
    if (hasNotebookRuntimeTemplateRef() != other.hasNotebookRuntimeTemplateRef()) return false;
    if (hasNotebookRuntimeTemplateRef()) {
      if (!getNotebookRuntimeTemplateRef().equals(other.getNotebookRuntimeTemplateRef()))
        return false;
    }
    if (!getProxyUri().equals(other.getProxyUri())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (healthState_ != other.healthState_) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (runtimeState_ != other.runtimeState_) return false;
    if (getIsUpgradable() != other.getIsUpgradable()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasExpirationTime() != other.hasExpirationTime()) return false;
    if (hasExpirationTime()) {
      if (!getExpirationTime().equals(other.getExpirationTime())) return false;
    }
    if (!getVersion().equals(other.getVersion())) return false;
    if (notebookRuntimeType_ != other.notebookRuntimeType_) return false;
    if (hasMachineSpec() != other.hasMachineSpec()) return false;
    if (hasMachineSpec()) {
      if (!getMachineSpec().equals(other.getMachineSpec())) return false;
    }
    if (hasDataPersistentDiskSpec() != other.hasDataPersistentDiskSpec()) return false;
    if (hasDataPersistentDiskSpec()) {
      if (!getDataPersistentDiskSpec().equals(other.getDataPersistentDiskSpec())) return false;
    }
    if (hasNetworkSpec() != other.hasNetworkSpec()) return false;
    if (hasNetworkSpec()) {
      if (!getNetworkSpec().equals(other.getNetworkSpec())) return false;
    }
    if (hasIdleShutdownConfig() != other.hasIdleShutdownConfig()) return false;
    if (hasIdleShutdownConfig()) {
      if (!getIdleShutdownConfig().equals(other.getIdleShutdownConfig())) return false;
    }
    if (hasEucConfig() != other.hasEucConfig()) return false;
    if (hasEucConfig()) {
      if (!getEucConfig().equals(other.getEucConfig())) return false;
    }
    if (hasShieldedVmConfig() != other.hasShieldedVmConfig()) return false;
    if (hasShieldedVmConfig()) {
      if (!getShieldedVmConfig().equals(other.getShieldedVmConfig())) return false;
    }
    if (!getNetworkTagsList().equals(other.getNetworkTagsList())) return false;
    if (hasSoftwareConfig() != other.hasSoftwareConfig()) return false;
    if (hasSoftwareConfig()) {
      if (!getSoftwareConfig().equals(other.getSoftwareConfig())) return false;
    }
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + RUNTIME_USER_FIELD_NUMBER;
    hash = (53 * hash) + getRuntimeUser().hashCode();
    if (hasNotebookRuntimeTemplateRef()) {
      hash = (37 * hash) + NOTEBOOK_RUNTIME_TEMPLATE_REF_FIELD_NUMBER;
      hash = (53 * hash) + getNotebookRuntimeTemplateRef().hashCode();
    }
    hash = (37 * hash) + PROXY_URI_FIELD_NUMBER;
    hash = (53 * hash) + getProxyUri().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + HEALTH_STATE_FIELD_NUMBER;
    hash = (53 * hash) + healthState_;
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + RUNTIME_STATE_FIELD_NUMBER;
    hash = (53 * hash) + runtimeState_;
    hash = (37 * hash) + IS_UPGRADABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsUpgradable());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasExpirationTime()) {
      hash = (37 * hash) + EXPIRATION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpirationTime().hashCode();
    }
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (37 * hash) + NOTEBOOK_RUNTIME_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + notebookRuntimeType_;
    if (hasMachineSpec()) {
      hash = (37 * hash) + MACHINE_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getMachineSpec().hashCode();
    }
    if (hasDataPersistentDiskSpec()) {
      hash = (37 * hash) + DATA_PERSISTENT_DISK_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDataPersistentDiskSpec().hashCode();
    }
    if (hasNetworkSpec()) {
      hash = (37 * hash) + NETWORK_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkSpec().hashCode();
    }
    if (hasIdleShutdownConfig()) {
      hash = (37 * hash) + IDLE_SHUTDOWN_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIdleShutdownConfig().hashCode();
    }
    if (hasEucConfig()) {
      hash = (37 * hash) + EUC_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEucConfig().hashCode();
    }
    if (hasShieldedVmConfig()) {
      hash = (37 * hash) + SHIELDED_VM_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getShieldedVmConfig().hashCode();
    }
    if (getNetworkTagsCount() > 0) {
      hash = (37 * hash) + NETWORK_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkTagsList().hashCode();
    }
    if (hasSoftwareConfig()) {
      hash = (37 * hash) + SOFTWARE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSoftwareConfig().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.NotebookRuntime prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A runtime is a virtual machine allocated to a particular user for a
   * particular Notebook file on temporary basis with lifetime. Default runtimes
   * have a lifetime of 18 hours, while custom runtimes last for 6 months from
   * their creation or last upgrade.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NotebookRuntime}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NotebookRuntime)
      com.google.cloud.aiplatform.v1beta1.NotebookRuntimeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NotebookRuntimeProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookRuntime_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 16:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 16:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.NotebookRuntimeProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookRuntime_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NotebookRuntime.class,
              com.google.cloud.aiplatform.v1beta1.NotebookRuntime.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.NotebookRuntime.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getNotebookRuntimeTemplateRefFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getExpirationTimeFieldBuilder();
        getMachineSpecFieldBuilder();
        getDataPersistentDiskSpecFieldBuilder();
        getNetworkSpecFieldBuilder();
        getIdleShutdownConfigFieldBuilder();
        getEucConfigFieldBuilder();
        getShieldedVmConfigFieldBuilder();
        getSoftwareConfigFieldBuilder();
        getEncryptionSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      runtimeUser_ = "";
      notebookRuntimeTemplateRef_ = null;
      if (notebookRuntimeTemplateRefBuilder_ != null) {
        notebookRuntimeTemplateRefBuilder_.dispose();
        notebookRuntimeTemplateRefBuilder_ = null;
      }
      proxyUri_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      healthState_ = 0;
      displayName_ = "";
      description_ = "";
      serviceAccount_ = "";
      runtimeState_ = 0;
      isUpgradable_ = false;
      internalGetMutableLabels().clear();
      expirationTime_ = null;
      if (expirationTimeBuilder_ != null) {
        expirationTimeBuilder_.dispose();
        expirationTimeBuilder_ = null;
      }
      version_ = "";
      notebookRuntimeType_ = 0;
      machineSpec_ = null;
      if (machineSpecBuilder_ != null) {
        machineSpecBuilder_.dispose();
        machineSpecBuilder_ = null;
      }
      dataPersistentDiskSpec_ = null;
      if (dataPersistentDiskSpecBuilder_ != null) {
        dataPersistentDiskSpecBuilder_.dispose();
        dataPersistentDiskSpecBuilder_ = null;
      }
      networkSpec_ = null;
      if (networkSpecBuilder_ != null) {
        networkSpecBuilder_.dispose();
        networkSpecBuilder_ = null;
      }
      idleShutdownConfig_ = null;
      if (idleShutdownConfigBuilder_ != null) {
        idleShutdownConfigBuilder_.dispose();
        idleShutdownConfigBuilder_ = null;
      }
      eucConfig_ = null;
      if (eucConfigBuilder_ != null) {
        eucConfigBuilder_.dispose();
        eucConfigBuilder_ = null;
      }
      shieldedVmConfig_ = null;
      if (shieldedVmConfigBuilder_ != null) {
        shieldedVmConfigBuilder_.dispose();
        shieldedVmConfigBuilder_ = null;
      }
      networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      softwareConfig_ = null;
      if (softwareConfigBuilder_ != null) {
        softwareConfigBuilder_.dispose();
        softwareConfigBuilder_ = null;
      }
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.NotebookRuntimeProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookRuntime_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookRuntime getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.NotebookRuntime.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookRuntime build() {
      com.google.cloud.aiplatform.v1beta1.NotebookRuntime result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookRuntime buildPartial() {
      com.google.cloud.aiplatform.v1beta1.NotebookRuntime result =
          new com.google.cloud.aiplatform.v1beta1.NotebookRuntime(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.NotebookRuntime result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.runtimeUser_ = runtimeUser_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.notebookRuntimeTemplateRef_ =
            notebookRuntimeTemplateRefBuilder_ == null
                ? notebookRuntimeTemplateRef_
                : notebookRuntimeTemplateRefBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.proxyUri_ = proxyUri_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.healthState_ = healthState_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.runtimeState_ = runtimeState_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.isUpgradable_ = isUpgradable_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.expirationTime_ =
            expirationTimeBuilder_ == null ? expirationTime_ : expirationTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.notebookRuntimeType_ = notebookRuntimeType_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.machineSpec_ =
            machineSpecBuilder_ == null ? machineSpec_ : machineSpecBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.dataPersistentDiskSpec_ =
            dataPersistentDiskSpecBuilder_ == null
                ? dataPersistentDiskSpec_
                : dataPersistentDiskSpecBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.networkSpec_ =
            networkSpecBuilder_ == null ? networkSpec_ : networkSpecBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.idleShutdownConfig_ =
            idleShutdownConfigBuilder_ == null
                ? idleShutdownConfig_
                : idleShutdownConfigBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.eucConfig_ = eucConfigBuilder_ == null ? eucConfig_ : eucConfigBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.shieldedVmConfig_ =
            shieldedVmConfigBuilder_ == null ? shieldedVmConfig_ : shieldedVmConfigBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        networkTags_.makeImmutable();
        result.networkTags_ = networkTags_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.softwareConfig_ =
            softwareConfigBuilder_ == null ? softwareConfig_ : softwareConfigBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.NotebookRuntime) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.NotebookRuntime) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.NotebookRuntime other) {
      if (other == com.google.cloud.aiplatform.v1beta1.NotebookRuntime.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRuntimeUser().isEmpty()) {
        runtimeUser_ = other.runtimeUser_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasNotebookRuntimeTemplateRef()) {
        mergeNotebookRuntimeTemplateRef(other.getNotebookRuntimeTemplateRef());
      }
      if (!other.getProxyUri().isEmpty()) {
        proxyUri_ = other.proxyUri_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.healthState_ != 0) {
        setHealthStateValue(other.getHealthStateValue());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.runtimeState_ != 0) {
        setRuntimeStateValue(other.getRuntimeStateValue());
      }
      if (other.getIsUpgradable() != false) {
        setIsUpgradable(other.getIsUpgradable());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00001000;
      if (other.hasExpirationTime()) {
        mergeExpirationTime(other.getExpirationTime());
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.notebookRuntimeType_ != 0) {
        setNotebookRuntimeTypeValue(other.getNotebookRuntimeTypeValue());
      }
      if (other.hasMachineSpec()) {
        mergeMachineSpec(other.getMachineSpec());
      }
      if (other.hasDataPersistentDiskSpec()) {
        mergeDataPersistentDiskSpec(other.getDataPersistentDiskSpec());
      }
      if (other.hasNetworkSpec()) {
        mergeNetworkSpec(other.getNetworkSpec());
      }
      if (other.hasIdleShutdownConfig()) {
        mergeIdleShutdownConfig(other.getIdleShutdownConfig());
      }
      if (other.hasEucConfig()) {
        mergeEucConfig(other.getEucConfig());
      }
      if (other.hasShieldedVmConfig()) {
        mergeShieldedVmConfig(other.getShieldedVmConfig());
      }
      if (!other.networkTags_.isEmpty()) {
        if (networkTags_.isEmpty()) {
          networkTags_ = other.networkTags_;
          bitField0_ |= 0x00400000;
        } else {
          ensureNetworkTagsIsMutable();
          networkTags_.addAll(other.networkTags_);
        }
        onChanged();
      }
      if (other.hasSoftwareConfig()) {
        mergeSoftwareConfig(other.getSoftwareConfig());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                runtimeUser_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getNotebookRuntimeTemplateRefFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                proxyUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 64:
              {
                healthState_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 82:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 106:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 106
            case 112:
              {
                runtimeState_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 112
            case 120:
              {
                isUpgradable_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 120
            case 130:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00001000;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getExpirationTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 138
            case 146:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 146
            case 152:
              {
                notebookRuntimeType_ = input.readEnum();
                bitField0_ |= 0x00008000;
                break;
              } // case 152
            case 162:
              {
                input.readMessage(getMachineSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(
                    getDataPersistentDiskSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(getNetworkSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(
                    getIdleShutdownConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(getEucConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 194
            case 202:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNetworkTagsIsMutable();
                networkTags_.add(s);
                break;
              } // case 202
            case 226:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 226
            case 232:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x02000000;
                break;
              } // case 232
            case 240:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x04000000;
                break;
              } // case 240
            case 250:
              {
                input.readMessage(getSoftwareConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 250
            case 258:
              {
                input.readMessage(
                    getShieldedVmConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 258
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the NotebookRuntime.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the NotebookRuntime.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the NotebookRuntime.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the NotebookRuntime.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the NotebookRuntime.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object runtimeUser_ = "";

    /**
     *
     *
     * <pre>
     * Required. The user email of the NotebookRuntime.
     * </pre>
     *
     * <code>string runtime_user = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The runtimeUser.
     */
    public java.lang.String getRuntimeUser() {
      java.lang.Object ref = runtimeUser_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        runtimeUser_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The user email of the NotebookRuntime.
     * </pre>
     *
     * <code>string runtime_user = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for runtimeUser.
     */
    public com.google.protobuf.ByteString getRuntimeUserBytes() {
      java.lang.Object ref = runtimeUser_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        runtimeUser_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The user email of the NotebookRuntime.
     * </pre>
     *
     * <code>string runtime_user = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The runtimeUser to set.
     * @return This builder for chaining.
     */
    public Builder setRuntimeUser(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      runtimeUser_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The user email of the NotebookRuntime.
     * </pre>
     *
     * <code>string runtime_user = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuntimeUser() {
      runtimeUser_ = getDefaultInstance().getRuntimeUser();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The user email of the NotebookRuntime.
     * </pre>
     *
     * <code>string runtime_user = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for runtimeUser to set.
     * @return This builder for chaining.
     */
    public Builder setRuntimeUserBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      runtimeUser_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef
        notebookRuntimeTemplateRef_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef,
            com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRefOrBuilder>
        notebookRuntimeTemplateRefBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
     * created from.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the notebookRuntimeTemplateRef field is set.
     */
    public boolean hasNotebookRuntimeTemplateRef() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
     * created from.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The notebookRuntimeTemplateRef.
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef
        getNotebookRuntimeTemplateRef() {
      if (notebookRuntimeTemplateRefBuilder_ == null) {
        return notebookRuntimeTemplateRef_ == null
            ? com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef.getDefaultInstance()
            : notebookRuntimeTemplateRef_;
      } else {
        return notebookRuntimeTemplateRefBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
     * created from.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNotebookRuntimeTemplateRef(
        com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef value) {
      if (notebookRuntimeTemplateRefBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notebookRuntimeTemplateRef_ = value;
      } else {
        notebookRuntimeTemplateRefBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
     * created from.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNotebookRuntimeTemplateRef(
        com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef.Builder builderForValue) {
      if (notebookRuntimeTemplateRefBuilder_ == null) {
        notebookRuntimeTemplateRef_ = builderForValue.build();
      } else {
        notebookRuntimeTemplateRefBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
     * created from.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeNotebookRuntimeTemplateRef(
        com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef value) {
      if (notebookRuntimeTemplateRefBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && notebookRuntimeTemplateRef_ != null
            && notebookRuntimeTemplateRef_
                != com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef
                    .getDefaultInstance()) {
          getNotebookRuntimeTemplateRefBuilder().mergeFrom(value);
        } else {
          notebookRuntimeTemplateRef_ = value;
        }
      } else {
        notebookRuntimeTemplateRefBuilder_.mergeFrom(value);
      }
      if (notebookRuntimeTemplateRef_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
     * created from.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearNotebookRuntimeTemplateRef() {
      bitField0_ = (bitField0_ & ~0x00000004);
      notebookRuntimeTemplateRef_ = null;
      if (notebookRuntimeTemplateRefBuilder_ != null) {
        notebookRuntimeTemplateRefBuilder_.dispose();
        notebookRuntimeTemplateRefBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
     * created from.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef.Builder
        getNotebookRuntimeTemplateRefBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getNotebookRuntimeTemplateRefFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
     * created from.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRefOrBuilder
        getNotebookRuntimeTemplateRefOrBuilder() {
      if (notebookRuntimeTemplateRefBuilder_ != null) {
        return notebookRuntimeTemplateRefBuilder_.getMessageOrBuilder();
      } else {
        return notebookRuntimeTemplateRef_ == null
            ? com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef.getDefaultInstance()
            : notebookRuntimeTemplateRef_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
     * created from.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef notebook_runtime_template_ref = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef,
            com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRefOrBuilder>
        getNotebookRuntimeTemplateRefFieldBuilder() {
      if (notebookRuntimeTemplateRefBuilder_ == null) {
        notebookRuntimeTemplateRefBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef,
                com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRef.Builder,
                com.google.cloud.aiplatform.v1beta1.NotebookRuntimeTemplateRefOrBuilder>(
                getNotebookRuntimeTemplateRef(), getParentForChildren(), isClean());
        notebookRuntimeTemplateRef_ = null;
      }
      return notebookRuntimeTemplateRefBuilder_;
    }

    private java.lang.Object proxyUri_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint used to access the NotebookRuntime.
     * </pre>
     *
     * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The proxyUri.
     */
    public java.lang.String getProxyUri() {
      java.lang.Object ref = proxyUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        proxyUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint used to access the NotebookRuntime.
     * </pre>
     *
     * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for proxyUri.
     */
    public com.google.protobuf.ByteString getProxyUriBytes() {
      java.lang.Object ref = proxyUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        proxyUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint used to access the NotebookRuntime.
     * </pre>
     *
     * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The proxyUri to set.
     * @return This builder for chaining.
     */
    public Builder setProxyUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      proxyUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint used to access the NotebookRuntime.
     * </pre>
     *
     * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProxyUri() {
      proxyUri_ = getDefaultInstance().getProxyUri();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint used to access the NotebookRuntime.
     * </pre>
     *
     * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for proxyUri to set.
     * @return This builder for chaining.
     */
    public Builder setProxyUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      proxyUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int healthState_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The health state of the NotebookRuntime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState health_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for healthState.
     */
    @java.lang.Override
    public int getHealthStateValue() {
      return healthState_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The health state of the NotebookRuntime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState health_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for healthState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthStateValue(int value) {
      healthState_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The health state of the NotebookRuntime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState health_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The healthState.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState getHealthState() {
      com.google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState result =
          com.google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState.forNumber(healthState_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The health state of the NotebookRuntime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState health_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The healthState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthState(
        com.google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      healthState_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The health state of the NotebookRuntime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntime.HealthState health_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthState() {
      bitField0_ = (bitField0_ & ~0x00000040);
      healthState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The display name of the NotebookRuntime.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the NotebookRuntime.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the NotebookRuntime.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the NotebookRuntime.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the NotebookRuntime.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * The description of the NotebookRuntime.
     * </pre>
     *
     * <code>string description = 11;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The description of the NotebookRuntime.
     * </pre>
     *
     * <code>string description = 11;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The description of the NotebookRuntime.
     * </pre>
     *
     * <code>string description = 11;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The description of the NotebookRuntime.
     * </pre>
     *
     * <code>string description = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The description of the NotebookRuntime.
     * </pre>
     *
     * <code>string description = 11;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: This field is no longer used and the "Vertex AI
     * Notebook Service Account"
     * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
     * used for the runtime workload identity.
     * See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
     * for more details.
     *
     * The service account that the NotebookRuntime workload runs as.
     * </pre>
     *
     * <code>string service_account = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: This field is no longer used and the "Vertex AI
     * Notebook Service Account"
     * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
     * used for the runtime workload identity.
     * See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
     * for more details.
     *
     * The service account that the NotebookRuntime workload runs as.
     * </pre>
     *
     * <code>string service_account = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: This field is no longer used and the "Vertex AI
     * Notebook Service Account"
     * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
     * used for the runtime workload identity.
     * See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
     * for more details.
     *
     * The service account that the NotebookRuntime workload runs as.
     * </pre>
     *
     * <code>string service_account = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: This field is no longer used and the "Vertex AI
     * Notebook Service Account"
     * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
     * used for the runtime workload identity.
     * See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
     * for more details.
     *
     * The service account that the NotebookRuntime workload runs as.
     * </pre>
     *
     * <code>string service_account = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: This field is no longer used and the "Vertex AI
     * Notebook Service Account"
     * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
     * used for the runtime workload identity.
     * See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
     * for more details.
     *
     * The service account that the NotebookRuntime workload runs as.
     * </pre>
     *
     * <code>string service_account = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private int runtimeState_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The runtime (instance) state of the NotebookRuntime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState runtime_state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for runtimeState.
     */
    @java.lang.Override
    public int getRuntimeStateValue() {
      return runtimeState_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The runtime (instance) state of the NotebookRuntime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState runtime_state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for runtimeState to set.
     * @return This builder for chaining.
     */
    public Builder setRuntimeStateValue(int value) {
      runtimeState_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The runtime (instance) state of the NotebookRuntime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState runtime_state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The runtimeState.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState getRuntimeState() {
      com.google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState result =
          com.google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState.forNumber(runtimeState_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The runtime (instance) state of the NotebookRuntime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState runtime_state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The runtimeState to set.
     * @return This builder for chaining.
     */
    public Builder setRuntimeState(
        com.google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      runtimeState_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The runtime (instance) state of the NotebookRuntime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntime.RuntimeState runtime_state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuntimeState() {
      bitField0_ = (bitField0_ & ~0x00000400);
      runtimeState_ = 0;
      onChanged();
      return this;
    }

    private boolean isUpgradable_;

    /**
     *
     *
     * <pre>
     * Output only. Whether NotebookRuntime is upgradable.
     * </pre>
     *
     * <code>bool is_upgradable = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The isUpgradable.
     */
    @java.lang.Override
    public boolean getIsUpgradable() {
      return isUpgradable_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether NotebookRuntime is upgradable.
     * </pre>
     *
     * <code>bool is_upgradable = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The isUpgradable to set.
     * @return This builder for chaining.
     */
    public Builder setIsUpgradable(boolean value) {

      isUpgradable_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether NotebookRuntime is upgradable.
     * </pre>
     *
     * <code>bool is_upgradable = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsUpgradable() {
      bitField0_ = (bitField0_ & ~0x00000800);
      isUpgradable_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * NotebookRuntime.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one NotebookRuntime
     * (System labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for NotebookRuntime:
     *
     * * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
     * only, its value is the Compute Engine instance id.
     * * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
     * either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
     * describe the entry service, either BigQuery or Vertex.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * NotebookRuntime.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one NotebookRuntime
     * (System labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for NotebookRuntime:
     *
     * * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
     * only, its value is the Compute Engine instance id.
     * * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
     * either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
     * describe the entry service, either BigQuery or Vertex.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * NotebookRuntime.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one NotebookRuntime
     * (System labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for NotebookRuntime:
     *
     * * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
     * only, its value is the Compute Engine instance id.
     * * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
     * either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
     * describe the entry service, either BigQuery or Vertex.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * NotebookRuntime.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one NotebookRuntime
     * (System labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for NotebookRuntime:
     *
     * * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
     * only, its value is the Compute Engine instance id.
     * * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
     * either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
     * describe the entry service, either BigQuery or Vertex.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00001000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * NotebookRuntime.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one NotebookRuntime
     * (System labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for NotebookRuntime:
     *
     * * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
     * only, its value is the Compute Engine instance id.
     * * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
     * either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
     * describe the entry service, either BigQuery or Vertex.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00001000;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * NotebookRuntime.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one NotebookRuntime
     * (System labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for NotebookRuntime:
     *
     * * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
     * only, its value is the Compute Engine instance id.
     * * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
     * either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
     * describe the entry service, either BigQuery or Vertex.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00001000;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * NotebookRuntime.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * No more than 64 user labels can be associated with one NotebookRuntime
     * (System labels are excluded).
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for NotebookRuntime:
     *
     * * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
     * only, its value is the Compute Engine instance id.
     * * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
     * either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
     * describe the entry service, either BigQuery or Vertex.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00001000;
      return this;
    }

    private com.google.protobuf.Timestamp expirationTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expirationTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime will be expired:
     * 1. System Predefined NotebookRuntime: 24 hours after creation. After
     * expiration, system predifined runtime will be deleted.
     * 2. User created NotebookRuntime: 6 months after last upgrade. After
     * expiration, user created runtime will be stopped and allowed for upgrade.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expirationTime field is set.
     */
    public boolean hasExpirationTime() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime will be expired:
     * 1. System Predefined NotebookRuntime: 24 hours after creation. After
     * expiration, system predifined runtime will be deleted.
     * 2. User created NotebookRuntime: 6 months after last upgrade. After
     * expiration, user created runtime will be stopped and allowed for upgrade.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expirationTime.
     */
    public com.google.protobuf.Timestamp getExpirationTime() {
      if (expirationTimeBuilder_ == null) {
        return expirationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expirationTime_;
      } else {
        return expirationTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime will be expired:
     * 1. System Predefined NotebookRuntime: 24 hours after creation. After
     * expiration, system predifined runtime will be deleted.
     * 2. User created NotebookRuntime: 6 months after last upgrade. After
     * expiration, user created runtime will be stopped and allowed for upgrade.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpirationTime(com.google.protobuf.Timestamp value) {
      if (expirationTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expirationTime_ = value;
      } else {
        expirationTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime will be expired:
     * 1. System Predefined NotebookRuntime: 24 hours after creation. After
     * expiration, system predifined runtime will be deleted.
     * 2. User created NotebookRuntime: 6 months after last upgrade. After
     * expiration, user created runtime will be stopped and allowed for upgrade.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpirationTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expirationTimeBuilder_ == null) {
        expirationTime_ = builderForValue.build();
      } else {
        expirationTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime will be expired:
     * 1. System Predefined NotebookRuntime: 24 hours after creation. After
     * expiration, system predifined runtime will be deleted.
     * 2. User created NotebookRuntime: 6 months after last upgrade. After
     * expiration, user created runtime will be stopped and allowed for upgrade.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpirationTime(com.google.protobuf.Timestamp value) {
      if (expirationTimeBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && expirationTime_ != null
            && expirationTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpirationTimeBuilder().mergeFrom(value);
        } else {
          expirationTime_ = value;
        }
      } else {
        expirationTimeBuilder_.mergeFrom(value);
      }
      if (expirationTime_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime will be expired:
     * 1. System Predefined NotebookRuntime: 24 hours after creation. After
     * expiration, system predifined runtime will be deleted.
     * 2. User created NotebookRuntime: 6 months after last upgrade. After
     * expiration, user created runtime will be stopped and allowed for upgrade.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpirationTime() {
      bitField0_ = (bitField0_ & ~0x00002000);
      expirationTime_ = null;
      if (expirationTimeBuilder_ != null) {
        expirationTimeBuilder_.dispose();
        expirationTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime will be expired:
     * 1. System Predefined NotebookRuntime: 24 hours after creation. After
     * expiration, system predifined runtime will be deleted.
     * 2. User created NotebookRuntime: 6 months after last upgrade. After
     * expiration, user created runtime will be stopped and allowed for upgrade.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpirationTimeBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getExpirationTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime will be expired:
     * 1. System Predefined NotebookRuntime: 24 hours after creation. After
     * expiration, system predifined runtime will be deleted.
     * 2. User created NotebookRuntime: 6 months after last upgrade. After
     * expiration, user created runtime will be stopped and allowed for upgrade.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpirationTimeOrBuilder() {
      if (expirationTimeBuilder_ != null) {
        return expirationTimeBuilder_.getMessageOrBuilder();
      } else {
        return expirationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expirationTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntime will be expired:
     * 1. System Predefined NotebookRuntime: 24 hours after creation. After
     * expiration, system predifined runtime will be deleted.
     * 2. User created NotebookRuntime: 6 months after last upgrade. After
     * expiration, user created runtime will be stopped and allowed for upgrade.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expiration_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpirationTimeFieldBuilder() {
      if (expirationTimeBuilder_ == null) {
        expirationTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpirationTime(), getParentForChildren(), isClean());
        expirationTime_ = null;
      }
      return expirationTimeBuilder_;
    }

    private java.lang.Object version_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The VM os image version of NotebookRuntime.
     * </pre>
     *
     * <code>string version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The VM os image version of NotebookRuntime.
     * </pre>
     *
     * <code>string version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The VM os image version of NotebookRuntime.
     * </pre>
     *
     * <code>string version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The VM os image version of NotebookRuntime.
     * </pre>
     *
     * <code>string version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The VM os image version of NotebookRuntime.
     * </pre>
     *
     * <code>string version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private int notebookRuntimeType_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The type of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for notebookRuntimeType.
     */
    @java.lang.Override
    public int getNotebookRuntimeTypeValue() {
      return notebookRuntimeType_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The type of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for notebookRuntimeType to set.
     * @return This builder for chaining.
     */
    public Builder setNotebookRuntimeTypeValue(int value) {
      notebookRuntimeType_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The type of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The notebookRuntimeType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookRuntimeType getNotebookRuntimeType() {
      com.google.cloud.aiplatform.v1beta1.NotebookRuntimeType result =
          com.google.cloud.aiplatform.v1beta1.NotebookRuntimeType.forNumber(notebookRuntimeType_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.NotebookRuntimeType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The type of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The notebookRuntimeType to set.
     * @return This builder for chaining.
     */
    public Builder setNotebookRuntimeType(
        com.google.cloud.aiplatform.v1beta1.NotebookRuntimeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00008000;
      notebookRuntimeType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The type of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotebookRuntimeType() {
      bitField0_ = (bitField0_ & ~0x00008000);
      notebookRuntimeType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.MachineSpec machineSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MachineSpec,
            com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>
        machineSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The specification of a single machine used by the notebook
     * runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the machineSpec field is set.
     */
    public boolean hasMachineSpec() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of a single machine used by the notebook
     * runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The machineSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpec getMachineSpec() {
      if (machineSpecBuilder_ == null) {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      } else {
        return machineSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of a single machine used by the notebook
     * runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMachineSpec(com.google.cloud.aiplatform.v1beta1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineSpec_ = value;
      } else {
        machineSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of a single machine used by the notebook
     * runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMachineSpec(
        com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder builderForValue) {
      if (machineSpecBuilder_ == null) {
        machineSpec_ = builderForValue.build();
      } else {
        machineSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of a single machine used by the notebook
     * runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMachineSpec(com.google.cloud.aiplatform.v1beta1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && machineSpec_ != null
            && machineSpec_
                != com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()) {
          getMachineSpecBuilder().mergeFrom(value);
        } else {
          machineSpec_ = value;
        }
      } else {
        machineSpecBuilder_.mergeFrom(value);
      }
      if (machineSpec_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of a single machine used by the notebook
     * runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMachineSpec() {
      bitField0_ = (bitField0_ & ~0x00010000);
      machineSpec_ = null;
      if (machineSpecBuilder_ != null) {
        machineSpecBuilder_.dispose();
        machineSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of a single machine used by the notebook
     * runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder getMachineSpecBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getMachineSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of a single machine used by the notebook
     * runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
      if (machineSpecBuilder_ != null) {
        return machineSpecBuilder_.getMessageOrBuilder();
      } else {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of a single machine used by the notebook
     * runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MachineSpec,
            com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>
        getMachineSpecFieldBuilder() {
      if (machineSpecBuilder_ == null) {
        machineSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.MachineSpec,
                com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>(
                getMachineSpec(), getParentForChildren(), isClean());
        machineSpec_ = null;
      }
      return machineSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec dataPersistentDiskSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec,
            com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.PersistentDiskSpecOrBuilder>
        dataPersistentDiskSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the notebook runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dataPersistentDiskSpec field is set.
     */
    public boolean hasDataPersistentDiskSpec() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the notebook runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataPersistentDiskSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec getDataPersistentDiskSpec() {
      if (dataPersistentDiskSpecBuilder_ == null) {
        return dataPersistentDiskSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec.getDefaultInstance()
            : dataPersistentDiskSpec_;
      } else {
        return dataPersistentDiskSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the notebook runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataPersistentDiskSpec(
        com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec value) {
      if (dataPersistentDiskSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataPersistentDiskSpec_ = value;
      } else {
        dataPersistentDiskSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the notebook runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataPersistentDiskSpec(
        com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec.Builder builderForValue) {
      if (dataPersistentDiskSpecBuilder_ == null) {
        dataPersistentDiskSpec_ = builderForValue.build();
      } else {
        dataPersistentDiskSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the notebook runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDataPersistentDiskSpec(
        com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec value) {
      if (dataPersistentDiskSpecBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && dataPersistentDiskSpec_ != null
            && dataPersistentDiskSpec_
                != com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec.getDefaultInstance()) {
          getDataPersistentDiskSpecBuilder().mergeFrom(value);
        } else {
          dataPersistentDiskSpec_ = value;
        }
      } else {
        dataPersistentDiskSpecBuilder_.mergeFrom(value);
      }
      if (dataPersistentDiskSpec_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the notebook runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDataPersistentDiskSpec() {
      bitField0_ = (bitField0_ & ~0x00020000);
      dataPersistentDiskSpec_ = null;
      if (dataPersistentDiskSpecBuilder_ != null) {
        dataPersistentDiskSpecBuilder_.dispose();
        dataPersistentDiskSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the notebook runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec.Builder
        getDataPersistentDiskSpecBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getDataPersistentDiskSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the notebook runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PersistentDiskSpecOrBuilder
        getDataPersistentDiskSpecOrBuilder() {
      if (dataPersistentDiskSpecBuilder_ != null) {
        return dataPersistentDiskSpecBuilder_.getMessageOrBuilder();
      } else {
        return dataPersistentDiskSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec.getDefaultInstance()
            : dataPersistentDiskSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the notebook runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentDiskSpec data_persistent_disk_spec = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec,
            com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.PersistentDiskSpecOrBuilder>
        getDataPersistentDiskSpecFieldBuilder() {
      if (dataPersistentDiskSpecBuilder_ == null) {
        dataPersistentDiskSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec,
                com.google.cloud.aiplatform.v1beta1.PersistentDiskSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.PersistentDiskSpecOrBuilder>(
                getDataPersistentDiskSpec(), getParentForChildren(), isClean());
        dataPersistentDiskSpec_ = null;
      }
      return dataPersistentDiskSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.NetworkSpec networkSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NetworkSpec,
            com.google.cloud.aiplatform.v1beta1.NetworkSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.NetworkSpecOrBuilder>
        networkSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Network spec of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the networkSpec field is set.
     */
    public boolean hasNetworkSpec() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Network spec of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The networkSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.NetworkSpec getNetworkSpec() {
      if (networkSpecBuilder_ == null) {
        return networkSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.NetworkSpec.getDefaultInstance()
            : networkSpec_;
      } else {
        return networkSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Network spec of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNetworkSpec(com.google.cloud.aiplatform.v1beta1.NetworkSpec value) {
      if (networkSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkSpec_ = value;
      } else {
        networkSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Network spec of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNetworkSpec(
        com.google.cloud.aiplatform.v1beta1.NetworkSpec.Builder builderForValue) {
      if (networkSpecBuilder_ == null) {
        networkSpec_ = builderForValue.build();
      } else {
        networkSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Network spec of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeNetworkSpec(com.google.cloud.aiplatform.v1beta1.NetworkSpec value) {
      if (networkSpecBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && networkSpec_ != null
            && networkSpec_
                != com.google.cloud.aiplatform.v1beta1.NetworkSpec.getDefaultInstance()) {
          getNetworkSpecBuilder().mergeFrom(value);
        } else {
          networkSpec_ = value;
        }
      } else {
        networkSpecBuilder_.mergeFrom(value);
      }
      if (networkSpec_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Network spec of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearNetworkSpec() {
      bitField0_ = (bitField0_ & ~0x00040000);
      networkSpec_ = null;
      if (networkSpecBuilder_ != null) {
        networkSpecBuilder_.dispose();
        networkSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Network spec of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NetworkSpec.Builder getNetworkSpecBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getNetworkSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Network spec of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NetworkSpecOrBuilder getNetworkSpecOrBuilder() {
      if (networkSpecBuilder_ != null) {
        return networkSpecBuilder_.getMessageOrBuilder();
      } else {
        return networkSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.NetworkSpec.getDefaultInstance()
            : networkSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Network spec of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NetworkSpec network_spec = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NetworkSpec,
            com.google.cloud.aiplatform.v1beta1.NetworkSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.NetworkSpecOrBuilder>
        getNetworkSpecFieldBuilder() {
      if (networkSpecBuilder_ == null) {
        networkSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NetworkSpec,
                com.google.cloud.aiplatform.v1beta1.NetworkSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.NetworkSpecOrBuilder>(
                getNetworkSpec(), getParentForChildren(), isClean());
        networkSpec_ = null;
      }
      return networkSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idleShutdownConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig,
            com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfigOrBuilder>
        idleShutdownConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The idle shutdown configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the idleShutdownConfig field is set.
     */
    public boolean hasIdleShutdownConfig() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The idle shutdown configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The idleShutdownConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig getIdleShutdownConfig() {
      if (idleShutdownConfigBuilder_ == null) {
        return idleShutdownConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig.getDefaultInstance()
            : idleShutdownConfig_;
      } else {
        return idleShutdownConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The idle shutdown configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIdleShutdownConfig(
        com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig value) {
      if (idleShutdownConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        idleShutdownConfig_ = value;
      } else {
        idleShutdownConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The idle shutdown configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIdleShutdownConfig(
        com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig.Builder builderForValue) {
      if (idleShutdownConfigBuilder_ == null) {
        idleShutdownConfig_ = builderForValue.build();
      } else {
        idleShutdownConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The idle shutdown configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeIdleShutdownConfig(
        com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig value) {
      if (idleShutdownConfigBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && idleShutdownConfig_ != null
            && idleShutdownConfig_
                != com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig
                    .getDefaultInstance()) {
          getIdleShutdownConfigBuilder().mergeFrom(value);
        } else {
          idleShutdownConfig_ = value;
        }
      } else {
        idleShutdownConfigBuilder_.mergeFrom(value);
      }
      if (idleShutdownConfig_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The idle shutdown configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearIdleShutdownConfig() {
      bitField0_ = (bitField0_ & ~0x00080000);
      idleShutdownConfig_ = null;
      if (idleShutdownConfigBuilder_ != null) {
        idleShutdownConfigBuilder_.dispose();
        idleShutdownConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The idle shutdown configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig.Builder
        getIdleShutdownConfigBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getIdleShutdownConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The idle shutdown configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfigOrBuilder
        getIdleShutdownConfigOrBuilder() {
      if (idleShutdownConfigBuilder_ != null) {
        return idleShutdownConfigBuilder_.getMessageOrBuilder();
      } else {
        return idleShutdownConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig.getDefaultInstance()
            : idleShutdownConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The idle shutdown configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig idle_shutdown_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig,
            com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfigOrBuilder>
        getIdleShutdownConfigFieldBuilder() {
      if (idleShutdownConfigBuilder_ == null) {
        idleShutdownConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig,
                com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.NotebookIdleShutdownConfigOrBuilder>(
                getIdleShutdownConfig(), getParentForChildren(), isClean());
        idleShutdownConfig_ = null;
      }
      return idleShutdownConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.NotebookEucConfig eucConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookEucConfig,
            com.google.cloud.aiplatform.v1beta1.NotebookEucConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookEucConfigOrBuilder>
        eucConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. EUC configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the eucConfig field is set.
     */
    public boolean hasEucConfig() {
      return ((bitField0_ & 0x00100000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. EUC configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The eucConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookEucConfig getEucConfig() {
      if (eucConfigBuilder_ == null) {
        return eucConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.NotebookEucConfig.getDefaultInstance()
            : eucConfig_;
      } else {
        return eucConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. EUC configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEucConfig(com.google.cloud.aiplatform.v1beta1.NotebookEucConfig value) {
      if (eucConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eucConfig_ = value;
      } else {
        eucConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. EUC configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEucConfig(
        com.google.cloud.aiplatform.v1beta1.NotebookEucConfig.Builder builderForValue) {
      if (eucConfigBuilder_ == null) {
        eucConfig_ = builderForValue.build();
      } else {
        eucConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. EUC configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEucConfig(com.google.cloud.aiplatform.v1beta1.NotebookEucConfig value) {
      if (eucConfigBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && eucConfig_ != null
            && eucConfig_
                != com.google.cloud.aiplatform.v1beta1.NotebookEucConfig.getDefaultInstance()) {
          getEucConfigBuilder().mergeFrom(value);
        } else {
          eucConfig_ = value;
        }
      } else {
        eucConfigBuilder_.mergeFrom(value);
      }
      if (eucConfig_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. EUC configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEucConfig() {
      bitField0_ = (bitField0_ & ~0x00100000);
      eucConfig_ = null;
      if (eucConfigBuilder_ != null) {
        eucConfigBuilder_.dispose();
        eucConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. EUC configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookEucConfig.Builder getEucConfigBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getEucConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. EUC configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookEucConfigOrBuilder getEucConfigOrBuilder() {
      if (eucConfigBuilder_ != null) {
        return eucConfigBuilder_.getMessageOrBuilder();
      } else {
        return eucConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.NotebookEucConfig.getDefaultInstance()
            : eucConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. EUC configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookEucConfig euc_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookEucConfig,
            com.google.cloud.aiplatform.v1beta1.NotebookEucConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookEucConfigOrBuilder>
        getEucConfigFieldBuilder() {
      if (eucConfigBuilder_ == null) {
        eucConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NotebookEucConfig,
                com.google.cloud.aiplatform.v1beta1.NotebookEucConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.NotebookEucConfigOrBuilder>(
                getEucConfig(), getParentForChildren(), isClean());
        eucConfig_ = null;
      }
      return eucConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig shieldedVmConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig,
            com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ShieldedVmConfigOrBuilder>
        shieldedVmConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the shieldedVmConfig field is set.
     */
    public boolean hasShieldedVmConfig() {
      return ((bitField0_ & 0x00200000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The shieldedVmConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig getShieldedVmConfig() {
      if (shieldedVmConfigBuilder_ == null) {
        return shieldedVmConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig.getDefaultInstance()
            : shieldedVmConfig_;
      } else {
        return shieldedVmConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setShieldedVmConfig(com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig value) {
      if (shieldedVmConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shieldedVmConfig_ = value;
      } else {
        shieldedVmConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setShieldedVmConfig(
        com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig.Builder builderForValue) {
      if (shieldedVmConfigBuilder_ == null) {
        shieldedVmConfig_ = builderForValue.build();
      } else {
        shieldedVmConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeShieldedVmConfig(
        com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig value) {
      if (shieldedVmConfigBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && shieldedVmConfig_ != null
            && shieldedVmConfig_
                != com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig.getDefaultInstance()) {
          getShieldedVmConfigBuilder().mergeFrom(value);
        } else {
          shieldedVmConfig_ = value;
        }
      } else {
        shieldedVmConfigBuilder_.mergeFrom(value);
      }
      if (shieldedVmConfig_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearShieldedVmConfig() {
      bitField0_ = (bitField0_ & ~0x00200000);
      shieldedVmConfig_ = null;
      if (shieldedVmConfigBuilder_ != null) {
        shieldedVmConfigBuilder_.dispose();
        shieldedVmConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig.Builder
        getShieldedVmConfigBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getShieldedVmConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ShieldedVmConfigOrBuilder
        getShieldedVmConfigOrBuilder() {
      if (shieldedVmConfigBuilder_ != null) {
        return shieldedVmConfigBuilder_.getMessageOrBuilder();
      } else {
        return shieldedVmConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig.getDefaultInstance()
            : shieldedVmConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ShieldedVmConfig shielded_vm_config = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig,
            com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ShieldedVmConfigOrBuilder>
        getShieldedVmConfigFieldBuilder() {
      if (shieldedVmConfigBuilder_ == null) {
        shieldedVmConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig,
                com.google.cloud.aiplatform.v1beta1.ShieldedVmConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ShieldedVmConfigOrBuilder>(
                getShieldedVmConfig(), getParentForChildren(), isClean());
        shieldedVmConfig_ = null;
      }
      return shieldedVmConfigBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList networkTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNetworkTagsIsMutable() {
      if (!networkTags_.isModifiable()) {
        networkTags_ = new com.google.protobuf.LazyStringArrayList(networkTags_);
      }
      bitField0_ |= 0x00400000;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the networkTags.
     */
    public com.google.protobuf.ProtocolStringList getNetworkTagsList() {
      networkTags_.makeImmutable();
      return networkTags_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of networkTags.
     */
    public int getNetworkTagsCount() {
      return networkTags_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The networkTags at the given index.
     */
    public java.lang.String getNetworkTags(int index) {
      return networkTags_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the networkTags at the given index.
     */
    public com.google.protobuf.ByteString getNetworkTagsBytes(int index) {
      return networkTags_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The networkTags to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNetworkTagsIsMutable();
      networkTags_.set(index, value);
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addNetworkTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNetworkTagsIsMutable();
      networkTags_.add(value);
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllNetworkTags(java.lang.Iterable<java.lang.String> values) {
      ensureNetworkTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, networkTags_);
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkTags() {
      networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00400000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addNetworkTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNetworkTagsIsMutable();
      networkTags_.add(value);
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig softwareConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig,
            com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfigOrBuilder>
        softwareConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Software config of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the softwareConfig field is set.
     */
    public boolean hasSoftwareConfig() {
      return ((bitField0_ & 0x00800000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Software config of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The softwareConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig getSoftwareConfig() {
      if (softwareConfigBuilder_ == null) {
        return softwareConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig.getDefaultInstance()
            : softwareConfig_;
      } else {
        return softwareConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Software config of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSoftwareConfig(
        com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig value) {
      if (softwareConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        softwareConfig_ = value;
      } else {
        softwareConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Software config of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSoftwareConfig(
        com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig.Builder builderForValue) {
      if (softwareConfigBuilder_ == null) {
        softwareConfig_ = builderForValue.build();
      } else {
        softwareConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Software config of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSoftwareConfig(
        com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig value) {
      if (softwareConfigBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && softwareConfig_ != null
            && softwareConfig_
                != com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig
                    .getDefaultInstance()) {
          getSoftwareConfigBuilder().mergeFrom(value);
        } else {
          softwareConfig_ = value;
        }
      } else {
        softwareConfigBuilder_.mergeFrom(value);
      }
      if (softwareConfig_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Software config of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSoftwareConfig() {
      bitField0_ = (bitField0_ & ~0x00800000);
      softwareConfig_ = null;
      if (softwareConfigBuilder_ != null) {
        softwareConfigBuilder_.dispose();
        softwareConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Software config of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig.Builder
        getSoftwareConfigBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getSoftwareConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Software config of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfigOrBuilder
        getSoftwareConfigOrBuilder() {
      if (softwareConfigBuilder_ != null) {
        return softwareConfigBuilder_.getMessageOrBuilder();
      } else {
        return softwareConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig.getDefaultInstance()
            : softwareConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Software config of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig software_config = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig,
            com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfigOrBuilder>
        getSoftwareConfigFieldBuilder() {
      if (softwareConfigBuilder_ == null) {
        softwareConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig,
                com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.NotebookSoftwareConfigOrBuilder>(
                getSoftwareConfig(), getParentForChildren(), isClean());
        softwareConfig_ = null;
      }
      return softwareConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x01000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x01000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x01000000);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private boolean satisfiesPzs_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x02000000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x04000000);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NotebookRuntime)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NotebookRuntime)
  private static final com.google.cloud.aiplatform.v1beta1.NotebookRuntime DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.NotebookRuntime();
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookRuntime getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NotebookRuntime> PARSER =
      new com.google.protobuf.AbstractParser<NotebookRuntime>() {
        @java.lang.Override
        public NotebookRuntime parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NotebookRuntime> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NotebookRuntime> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookRuntime getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
