/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Response message for
 * [ModelService.RecommendSpec][google.cloud.aiplatform.v1beta1.ModelService.RecommendSpec].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.RecommendSpecResponse}
 */
public final class RecommendSpecResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RecommendSpecResponse)
    RecommendSpecResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RecommendSpecResponse.newBuilder() to construct.
  private RecommendSpecResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecommendSpecResponse() {
    baseModel_ = "";
    recommendations_ = java.util.Collections.emptyList();
    specs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecommendSpecResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.class,
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Builder.class);
  }

  public interface MachineAndModelContainerSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The machine spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the machineSpec field is set.
     */
    boolean hasMachineSpec();

    /**
     *
     *
     * <pre>
     * Output only. The machine spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The machineSpec.
     */
    com.google.cloud.aiplatform.v1beta1.MachineSpec getMachineSpec();

    /**
     *
     *
     * <pre>
     * Output only. The machine spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder getMachineSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The model container spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the containerSpec field is set.
     */
    boolean hasContainerSpec();

    /**
     *
     *
     * <pre>
     * Output only. The model container spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The containerSpec.
     */
    com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getContainerSpec();

    /**
     *
     *
     * <pre>
     * Output only. The model container spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder getContainerSpecOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A machine and model container spec.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec}
   */
  public static final class MachineAndModelContainerSpec
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec)
      MachineAndModelContainerSpecOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use MachineAndModelContainerSpec.newBuilder() to construct.
    private MachineAndModelContainerSpec(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MachineAndModelContainerSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MachineAndModelContainerSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_MachineAndModelContainerSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_MachineAndModelContainerSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                  .class,
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                  .Builder.class);
    }

    private int bitField0_;
    public static final int MACHINE_SPEC_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.MachineSpec machineSpec_;

    /**
     *
     *
     * <pre>
     * Output only. The machine spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the machineSpec field is set.
     */
    @java.lang.Override
    public boolean hasMachineSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The machineSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MachineSpec getMachineSpec() {
      return machineSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
          : machineSpec_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
      return machineSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
          : machineSpec_;
    }

    public static final int CONTAINER_SPEC_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1beta1.ModelContainerSpec containerSpec_;

    /**
     *
     *
     * <pre>
     * Output only. The model container spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the containerSpec field is set.
     */
    @java.lang.Override
    public boolean hasContainerSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The model container spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The containerSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getContainerSpec() {
      return containerSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
          : containerSpec_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The model container spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder
        getContainerSpecOrBuilder() {
      return containerSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
          : containerSpec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getMachineSpec());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getContainerSpec());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMachineSpec());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getContainerSpec());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec other =
          (com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec)
              obj;

      if (hasMachineSpec() != other.hasMachineSpec()) return false;
      if (hasMachineSpec()) {
        if (!getMachineSpec().equals(other.getMachineSpec())) return false;
      }
      if (hasContainerSpec() != other.hasContainerSpec()) return false;
      if (hasContainerSpec()) {
        if (!getContainerSpec().equals(other.getContainerSpec())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMachineSpec()) {
        hash = (37 * hash) + MACHINE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getMachineSpec().hashCode();
      }
      if (hasContainerSpec()) {
        hash = (37 * hash) + CONTAINER_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getContainerSpec().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A machine and model container spec.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec)
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_MachineAndModelContainerSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_MachineAndModelContainerSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                    .MachineAndModelContainerSpec.class,
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                    .MachineAndModelContainerSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMachineSpecFieldBuilder();
          getContainerSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        machineSpec_ = null;
        if (machineSpecBuilder_ != null) {
          machineSpecBuilder_.dispose();
          machineSpecBuilder_ = null;
        }
        containerSpec_ = null;
        if (containerSpecBuilder_ != null) {
          containerSpecBuilder_.dispose();
          containerSpecBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_MachineAndModelContainerSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
          build() {
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
            result =
                new com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                    .MachineAndModelContainerSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.machineSpec_ =
              machineSpecBuilder_ == null ? machineSpec_ : machineSpecBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.containerSpec_ =
              containerSpecBuilder_ == null ? containerSpec_ : containerSpecBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                .MachineAndModelContainerSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                      .MachineAndModelContainerSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                .MachineAndModelContainerSpec.getDefaultInstance()) return this;
        if (other.hasMachineSpec()) {
          mergeMachineSpec(other.getMachineSpec());
        }
        if (other.hasContainerSpec()) {
          mergeContainerSpec(other.getContainerSpec());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getMachineSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getContainerSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.MachineSpec machineSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.MachineSpec,
              com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>
          machineSpecBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The machine spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the machineSpec field is set.
       */
      public boolean hasMachineSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The machineSpec.
       */
      public com.google.cloud.aiplatform.v1beta1.MachineSpec getMachineSpec() {
        if (machineSpecBuilder_ == null) {
          return machineSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
              : machineSpec_;
        } else {
          return machineSpecBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setMachineSpec(com.google.cloud.aiplatform.v1beta1.MachineSpec value) {
        if (machineSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          machineSpec_ = value;
        } else {
          machineSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setMachineSpec(
          com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder builderForValue) {
        if (machineSpecBuilder_ == null) {
          machineSpec_ = builderForValue.build();
        } else {
          machineSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeMachineSpec(com.google.cloud.aiplatform.v1beta1.MachineSpec value) {
        if (machineSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && machineSpec_ != null
              && machineSpec_
                  != com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()) {
            getMachineSpecBuilder().mergeFrom(value);
          } else {
            machineSpec_ = value;
          }
        } else {
          machineSpecBuilder_.mergeFrom(value);
        }
        if (machineSpec_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearMachineSpec() {
        bitField0_ = (bitField0_ & ~0x00000001);
        machineSpec_ = null;
        if (machineSpecBuilder_ != null) {
          machineSpecBuilder_.dispose();
          machineSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder getMachineSpecBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMachineSpecFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
        if (machineSpecBuilder_ != null) {
          return machineSpecBuilder_.getMessageOrBuilder();
        } else {
          return machineSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
              : machineSpec_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.MachineSpec,
              com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>
          getMachineSpecFieldBuilder() {
        if (machineSpecBuilder_ == null) {
          machineSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.MachineSpec,
                  com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
                  com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>(
                  getMachineSpec(), getParentForChildren(), isClean());
          machineSpec_ = null;
        }
        return machineSpecBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.ModelContainerSpec containerSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec,
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder>
          containerSpecBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The model container spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the containerSpec field is set.
       */
      public boolean hasContainerSpec() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. The model container spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The containerSpec.
       */
      public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getContainerSpec() {
        if (containerSpecBuilder_ == null) {
          return containerSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
              : containerSpec_;
        } else {
          return containerSpecBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The model container spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setContainerSpec(
          com.google.cloud.aiplatform.v1beta1.ModelContainerSpec value) {
        if (containerSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          containerSpec_ = value;
        } else {
          containerSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The model container spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setContainerSpec(
          com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder builderForValue) {
        if (containerSpecBuilder_ == null) {
          containerSpec_ = builderForValue.build();
        } else {
          containerSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The model container spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeContainerSpec(
          com.google.cloud.aiplatform.v1beta1.ModelContainerSpec value) {
        if (containerSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && containerSpec_ != null
              && containerSpec_
                  != com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()) {
            getContainerSpecBuilder().mergeFrom(value);
          } else {
            containerSpec_ = value;
          }
        } else {
          containerSpecBuilder_.mergeFrom(value);
        }
        if (containerSpec_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The model container spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearContainerSpec() {
        bitField0_ = (bitField0_ & ~0x00000002);
        containerSpec_ = null;
        if (containerSpecBuilder_ != null) {
          containerSpecBuilder_.dispose();
          containerSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The model container spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder
          getContainerSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getContainerSpecFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. The model container spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder
          getContainerSpecOrBuilder() {
        if (containerSpecBuilder_ != null) {
          return containerSpecBuilder_.getMessageOrBuilder();
        } else {
          return containerSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
              : containerSpec_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The model container spec.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec,
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder>
          getContainerSpecFieldBuilder() {
        if (containerSpecBuilder_ == null) {
          containerSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelContainerSpec,
                  com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder>(
                  getContainerSpec(), getParentForChildren(), isClean());
          containerSpec_ = null;
        }
        return containerSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec)
    private static final com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
              .MachineAndModelContainerSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MachineAndModelContainerSpec> PARSER =
        new com.google.protobuf.AbstractParser<MachineAndModelContainerSpec>() {
          @java.lang.Override
          public MachineAndModelContainerSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MachineAndModelContainerSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MachineAndModelContainerSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RecommendationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The region for the deployment spec (machine).
     * </pre>
     *
     * <code>string region = 1;</code>
     *
     * @return The region.
     */
    java.lang.String getRegion();

    /**
     *
     *
     * <pre>
     * The region for the deployment spec (machine).
     * </pre>
     *
     * <code>string region = 1;</code>
     *
     * @return The bytes for region.
     */
    com.google.protobuf.ByteString getRegionBytes();

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the spec field is set.
     */
    boolean hasSpec();

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The spec.
     */
    com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
        getSpec();

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpecOrBuilder
        getSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The user accelerator quota state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState user_quota_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for userQuotaState.
     */
    int getUserQuotaStateValue();

    /**
     *
     *
     * <pre>
     * Output only. The user accelerator quota state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState user_quota_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The userQuotaState.
     */
    com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState
        getUserQuotaState();
  }

  /**
   *
   *
   * <pre>
   * Recommendation of one deployment option for the given custom weights model
   * in one region.
   * Contains the machine and container spec, and user accelerator quota state.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation}
   */
  public static final class Recommendation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation)
      RecommendationOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Recommendation.newBuilder() to construct.
    private Recommendation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Recommendation() {
      region_ = "";
      userQuotaState_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Recommendation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_Recommendation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_Recommendation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.class,
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * The user accelerator quota state.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState}
     */
    public enum QuotaState implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified quota state. Quota information not available.
       * </pre>
       *
       * <code>QUOTA_STATE_UNSPECIFIED = 0;</code>
       */
      QUOTA_STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * User has enough accelerator quota for the machine type.
       * </pre>
       *
       * <code>QUOTA_STATE_USER_HAS_QUOTA = 1;</code>
       */
      QUOTA_STATE_USER_HAS_QUOTA(1),
      /**
       *
       *
       * <pre>
       * User does not have enough accelerator quota for the machine type.
       * </pre>
       *
       * <code>QUOTA_STATE_NO_USER_QUOTA = 2;</code>
       */
      QUOTA_STATE_NO_USER_QUOTA(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified quota state. Quota information not available.
       * </pre>
       *
       * <code>QUOTA_STATE_UNSPECIFIED = 0;</code>
       */
      public static final int QUOTA_STATE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * User has enough accelerator quota for the machine type.
       * </pre>
       *
       * <code>QUOTA_STATE_USER_HAS_QUOTA = 1;</code>
       */
      public static final int QUOTA_STATE_USER_HAS_QUOTA_VALUE = 1;

      /**
       *
       *
       * <pre>
       * User does not have enough accelerator quota for the machine type.
       * </pre>
       *
       * <code>QUOTA_STATE_NO_USER_QUOTA = 2;</code>
       */
      public static final int QUOTA_STATE_NO_USER_QUOTA_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static QuotaState valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static QuotaState forNumber(int value) {
        switch (value) {
          case 0:
            return QUOTA_STATE_UNSPECIFIED;
          case 1:
            return QUOTA_STATE_USER_HAS_QUOTA;
          case 2:
            return QUOTA_STATE_NO_USER_QUOTA;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<QuotaState> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<QuotaState> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<QuotaState>() {
            public QuotaState findValueByNumber(int number) {
              return QuotaState.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final QuotaState[] VALUES = values();

      public static QuotaState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private QuotaState(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState)
    }

    private int bitField0_;
    public static final int REGION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object region_ = "";

    /**
     *
     *
     * <pre>
     * The region for the deployment spec (machine).
     * </pre>
     *
     * <code>string region = 1;</code>
     *
     * @return The region.
     */
    @java.lang.Override
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The region for the deployment spec (machine).
     * </pre>
     *
     * <code>string region = 1;</code>
     *
     * @return The bytes for region.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
        spec_;

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the spec field is set.
     */
    @java.lang.Override
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The spec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
        getSpec() {
      return spec_ == null
          ? com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
              .getDefaultInstance()
          : spec_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpecOrBuilder
        getSpecOrBuilder() {
      return spec_ == null
          ? com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
              .getDefaultInstance()
          : spec_;
    }

    public static final int USER_QUOTA_STATE_FIELD_NUMBER = 3;
    private int userQuotaState_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The user accelerator quota state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState user_quota_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for userQuotaState.
     */
    @java.lang.Override
    public int getUserQuotaStateValue() {
      return userQuotaState_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The user accelerator quota state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState user_quota_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The userQuotaState.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState
        getUserQuotaState() {
      com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState result =
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState
              .forNumber(userQuotaState_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, region_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getSpec());
      }
      if (userQuotaState_
          != com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState
              .QUOTA_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, userQuotaState_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, region_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpec());
      }
      if (userQuotaState_
          != com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState
              .QUOTA_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, userQuotaState_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation other =
          (com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation) obj;

      if (!getRegion().equals(other.getRegion())) return false;
      if (hasSpec() != other.hasSpec()) return false;
      if (hasSpec()) {
        if (!getSpec().equals(other.getSpec())) return false;
      }
      if (userQuotaState_ != other.userQuotaState_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      hash = (37 * hash) + USER_QUOTA_STATE_FIELD_NUMBER;
      hash = (53 * hash) + userQuotaState_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Recommendation of one deployment option for the given custom weights model
     * in one region.
     * Contains the machine and container spec, and user accelerator quota state.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation)
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.RecommendationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_Recommendation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_Recommendation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.class,
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        region_ = "";
        spec_ = null;
        if (specBuilder_ != null) {
          specBuilder_.dispose();
          specBuilder_ = null;
        }
        userQuotaState_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_Recommendation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation build() {
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation result =
            new com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.region_ = region_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.spec_ = specBuilder_ == null ? spec_ : specBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.userQuotaState_ = userQuotaState_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
                .getDefaultInstance()) return this;
        if (!other.getRegion().isEmpty()) {
          region_ = other.region_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (other.userQuotaState_ != 0) {
          setUserQuotaStateValue(other.getUserQuotaStateValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  region_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  userQuotaState_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object region_ = "";

      /**
       *
       *
       * <pre>
       * The region for the deployment spec (machine).
       * </pre>
       *
       * <code>string region = 1;</code>
       *
       * @return The region.
       */
      public java.lang.String getRegion() {
        java.lang.Object ref = region_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          region_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The region for the deployment spec (machine).
       * </pre>
       *
       * <code>string region = 1;</code>
       *
       * @return The bytes for region.
       */
      public com.google.protobuf.ByteString getRegionBytes() {
        java.lang.Object ref = region_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          region_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The region for the deployment spec (machine).
       * </pre>
       *
       * <code>string region = 1;</code>
       *
       * @param value The region to set.
       * @return This builder for chaining.
       */
      public Builder setRegion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        region_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The region for the deployment spec (machine).
       * </pre>
       *
       * <code>string region = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRegion() {
        region_ = getDefaultInstance().getRegion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The region for the deployment spec (machine).
       * </pre>
       *
       * <code>string region = 1;</code>
       *
       * @param value The bytes for region to set.
       * @return This builder for chaining.
       */
      public Builder setRegionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        region_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
          spec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                  .MachineAndModelContainerSpec,
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                  .MachineAndModelContainerSpecOrBuilder>
          specBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The machine and model container specs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the spec field is set.
       */
      public boolean hasSpec() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine and model container specs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The spec.
       */
      public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
          getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null
              ? com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                  .MachineAndModelContainerSpec.getDefaultInstance()
              : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine and model container specs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSpec(
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
              value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
        } else {
          specBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine and model container specs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSpec(
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                  .Builder
              builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine and model container specs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeSpec(
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
              value) {
        if (specBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && spec_ != null
              && spec_
                  != com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                      .MachineAndModelContainerSpec.getDefaultInstance()) {
            getSpecBuilder().mergeFrom(value);
          } else {
            spec_ = value;
          }
        } else {
          specBuilder_.mergeFrom(value);
        }
        if (spec_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine and model container specs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearSpec() {
        bitField0_ = (bitField0_ & ~0x00000002);
        spec_ = null;
        if (specBuilder_ != null) {
          specBuilder_.dispose();
          specBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine and model container specs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
              .Builder
          getSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine and model container specs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
              .MachineAndModelContainerSpecOrBuilder
          getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null
              ? com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                  .MachineAndModelContainerSpec.getDefaultInstance()
              : spec_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The machine and model container specs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec spec = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                  .MachineAndModelContainerSpec,
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                  .MachineAndModelContainerSpecOrBuilder>
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                      .MachineAndModelContainerSpec,
                  com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                      .MachineAndModelContainerSpec.Builder,
                  com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                      .MachineAndModelContainerSpecOrBuilder>(
                  getSpec(), getParentForChildren(), isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private int userQuotaState_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. The user accelerator quota state.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState user_quota_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for userQuotaState.
       */
      @java.lang.Override
      public int getUserQuotaStateValue() {
        return userQuotaState_;
      }

      /**
       *
       *
       * <pre>
       * Output only. The user accelerator quota state.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState user_quota_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for userQuotaState to set.
       * @return This builder for chaining.
       */
      public Builder setUserQuotaStateValue(int value) {
        userQuotaState_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The user accelerator quota state.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState user_quota_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The userQuotaState.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState
          getUserQuotaState() {
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState result =
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState
                .forNumber(userQuotaState_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState
                .UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. The user accelerator quota state.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState user_quota_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The userQuotaState to set.
       * @return This builder for chaining.
       */
      public Builder setUserQuotaState(
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        userQuotaState_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The user accelerator quota state.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.QuotaState user_quota_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUserQuotaState() {
        bitField0_ = (bitField0_ & ~0x00000004);
        userQuotaState_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation)
    private static final com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation();
    }

    public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Recommendation> PARSER =
        new com.google.protobuf.AbstractParser<Recommendation>() {
          @java.lang.Override
          public Recommendation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Recommendation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Recommendation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int BASE_MODEL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object baseModel_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The base model used to finetune the custom model.
   * </pre>
   *
   * <code>string base_model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The baseModel.
   */
  @java.lang.Override
  public java.lang.String getBaseModel() {
    java.lang.Object ref = baseModel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      baseModel_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The base model used to finetune the custom model.
   * </pre>
   *
   * <code>string base_model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for baseModel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBaseModelBytes() {
    java.lang.Object ref = baseModel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      baseModel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECOMMENDATIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation>
      recommendations_;

  /**
   *
   *
   * <pre>
   * Output only. Recommendations of deployment options for the given custom
   * weights model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation>
      getRecommendationsList() {
    return recommendations_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Recommendations of deployment options for the given custom
   * weights model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.RecommendationOrBuilder>
      getRecommendationsOrBuilderList() {
    return recommendations_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Recommendations of deployment options for the given custom
   * weights model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getRecommendationsCount() {
    return recommendations_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Recommendations of deployment options for the given custom
   * weights model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
      getRecommendations(int index) {
    return recommendations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Recommendations of deployment options for the given custom
   * weights model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.RecommendationOrBuilder
      getRecommendationsOrBuilder(int index) {
    return recommendations_.get(index);
  }

  public static final int SPECS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec>
      specs_;

  /**
   *
   *
   * <pre>
   * Output only. The machine and model container specs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec>
      getSpecsList() {
    return specs_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The machine and model container specs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                  .MachineAndModelContainerSpecOrBuilder>
      getSpecsOrBuilderList() {
    return specs_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The machine and model container specs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getSpecsCount() {
    return specs_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. The machine and model container specs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
      getSpecs(int index) {
    return specs_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. The machine and model container specs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
          .MachineAndModelContainerSpecOrBuilder
      getSpecsOrBuilder(int index) {
    return specs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseModel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, baseModel_);
    }
    for (int i = 0; i < specs_.size(); i++) {
      output.writeMessage(2, specs_.get(i));
    }
    for (int i = 0; i < recommendations_.size(); i++) {
      output.writeMessage(3, recommendations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseModel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, baseModel_);
    }
    for (int i = 0; i < specs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, specs_.get(i));
    }
    for (int i = 0; i < recommendations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, recommendations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse other =
        (com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse) obj;

    if (!getBaseModel().equals(other.getBaseModel())) return false;
    if (!getRecommendationsList().equals(other.getRecommendationsList())) return false;
    if (!getSpecsList().equals(other.getSpecsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BASE_MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getBaseModel().hashCode();
    if (getRecommendationsCount() > 0) {
      hash = (37 * hash) + RECOMMENDATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRecommendationsList().hashCode();
    }
    if (getSpecsCount() > 0) {
      hash = (37 * hash) + SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getSpecsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Response message for
   * [ModelService.RecommendSpec][google.cloud.aiplatform.v1beta1.ModelService.RecommendSpec].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RecommendSpecResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RecommendSpecResponse)
      com.google.cloud.aiplatform.v1beta1.RecommendSpecResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.class,
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      baseModel_ = "";
      if (recommendationsBuilder_ == null) {
        recommendations_ = java.util.Collections.emptyList();
      } else {
        recommendations_ = null;
        recommendationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (specsBuilder_ == null) {
        specs_ = java.util.Collections.emptyList();
      } else {
        specs_ = null;
        specsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RecommendSpecResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse build() {
      com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse buildPartial() {
      com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse result =
          new com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse result) {
      if (recommendationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          recommendations_ = java.util.Collections.unmodifiableList(recommendations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.recommendations_ = recommendations_;
      } else {
        result.recommendations_ = recommendationsBuilder_.build();
      }
      if (specsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          specs_ = java.util.Collections.unmodifiableList(specs_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.specs_ = specs_;
      } else {
        result.specs_ = specsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.baseModel_ = baseModel_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse other) {
      if (other == com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.getDefaultInstance())
        return this;
      if (!other.getBaseModel().isEmpty()) {
        baseModel_ = other.baseModel_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (recommendationsBuilder_ == null) {
        if (!other.recommendations_.isEmpty()) {
          if (recommendations_.isEmpty()) {
            recommendations_ = other.recommendations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureRecommendationsIsMutable();
            recommendations_.addAll(other.recommendations_);
          }
          onChanged();
        }
      } else {
        if (!other.recommendations_.isEmpty()) {
          if (recommendationsBuilder_.isEmpty()) {
            recommendationsBuilder_.dispose();
            recommendationsBuilder_ = null;
            recommendations_ = other.recommendations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            recommendationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRecommendationsFieldBuilder()
                    : null;
          } else {
            recommendationsBuilder_.addAllMessages(other.recommendations_);
          }
        }
      }
      if (specsBuilder_ == null) {
        if (!other.specs_.isEmpty()) {
          if (specs_.isEmpty()) {
            specs_ = other.specs_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSpecsIsMutable();
            specs_.addAll(other.specs_);
          }
          onChanged();
        }
      } else {
        if (!other.specs_.isEmpty()) {
          if (specsBuilder_.isEmpty()) {
            specsBuilder_.dispose();
            specsBuilder_ = null;
            specs_ = other.specs_;
            bitField0_ = (bitField0_ & ~0x00000004);
            specsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSpecsFieldBuilder()
                    : null;
          } else {
            specsBuilder_.addAllMessages(other.specs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                baseModel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                        .MachineAndModelContainerSpec
                    m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                                .MachineAndModelContainerSpec.parser(),
                            extensionRegistry);
                if (specsBuilder_ == null) {
                  ensureSpecsIsMutable();
                  specs_.add(m);
                } else {
                  specsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
                            .parser(),
                        extensionRegistry);
                if (recommendationsBuilder_ == null) {
                  ensureRecommendationsIsMutable();
                  recommendations_.add(m);
                } else {
                  recommendationsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object baseModel_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The base model used to finetune the custom model.
     * </pre>
     *
     * <code>string base_model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The baseModel.
     */
    public java.lang.String getBaseModel() {
      java.lang.Object ref = baseModel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        baseModel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The base model used to finetune the custom model.
     * </pre>
     *
     * <code>string base_model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for baseModel.
     */
    public com.google.protobuf.ByteString getBaseModelBytes() {
      java.lang.Object ref = baseModel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        baseModel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The base model used to finetune the custom model.
     * </pre>
     *
     * <code>string base_model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The baseModel to set.
     * @return This builder for chaining.
     */
    public Builder setBaseModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      baseModel_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The base model used to finetune the custom model.
     * </pre>
     *
     * <code>string base_model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseModel() {
      baseModel_ = getDefaultInstance().getBaseModel();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The base model used to finetune the custom model.
     * </pre>
     *
     * <code>string base_model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for baseModel to set.
     * @return This builder for chaining.
     */
    public Builder setBaseModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      baseModel_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation>
        recommendations_ = java.util.Collections.emptyList();

    private void ensureRecommendationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        recommendations_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation>(
                recommendations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation,
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder,
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.RecommendationOrBuilder>
        recommendationsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation>
        getRecommendationsList() {
      if (recommendationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(recommendations_);
      } else {
        return recommendationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getRecommendationsCount() {
      if (recommendationsBuilder_ == null) {
        return recommendations_.size();
      } else {
        return recommendationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
        getRecommendations(int index) {
      if (recommendationsBuilder_ == null) {
        return recommendations_.get(index);
      } else {
        return recommendationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRecommendations(
        int index, com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation value) {
      if (recommendationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecommendationsIsMutable();
        recommendations_.set(index, value);
        onChanged();
      } else {
        recommendationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRecommendations(
        int index,
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder
            builderForValue) {
      if (recommendationsBuilder_ == null) {
        ensureRecommendationsIsMutable();
        recommendations_.set(index, builderForValue.build());
        onChanged();
      } else {
        recommendationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecommendations(
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation value) {
      if (recommendationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecommendationsIsMutable();
        recommendations_.add(value);
        onChanged();
      } else {
        recommendationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecommendations(
        int index, com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation value) {
      if (recommendationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecommendationsIsMutable();
        recommendations_.add(index, value);
        onChanged();
      } else {
        recommendationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecommendations(
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder
            builderForValue) {
      if (recommendationsBuilder_ == null) {
        ensureRecommendationsIsMutable();
        recommendations_.add(builderForValue.build());
        onChanged();
      } else {
        recommendationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecommendations(
        int index,
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder
            builderForValue) {
      if (recommendationsBuilder_ == null) {
        ensureRecommendationsIsMutable();
        recommendations_.add(index, builderForValue.build());
        onChanged();
      } else {
        recommendationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllRecommendations(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation>
            values) {
      if (recommendationsBuilder_ == null) {
        ensureRecommendationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, recommendations_);
        onChanged();
      } else {
        recommendationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRecommendations() {
      if (recommendationsBuilder_ == null) {
        recommendations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        recommendationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeRecommendations(int index) {
      if (recommendationsBuilder_ == null) {
        ensureRecommendationsIsMutable();
        recommendations_.remove(index);
        onChanged();
      } else {
        recommendationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder
        getRecommendationsBuilder(int index) {
      return getRecommendationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.RecommendationOrBuilder
        getRecommendationsOrBuilder(int index) {
      if (recommendationsBuilder_ == null) {
        return recommendations_.get(index);
      } else {
        return recommendationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.RecommendationOrBuilder>
        getRecommendationsOrBuilderList() {
      if (recommendationsBuilder_ != null) {
        return recommendationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(recommendations_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder
        addRecommendationsBuilder() {
      return getRecommendationsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder
        addRecommendationsBuilder(int index) {
      return getRecommendationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Recommendations of deployment options for the given custom
     * weights model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation recommendations = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder>
        getRecommendationsBuilderList() {
      return getRecommendationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation,
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder,
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.RecommendationOrBuilder>
        getRecommendationsFieldBuilder() {
      if (recommendationsBuilder_ == null) {
        recommendationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation,
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.Recommendation.Builder,
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.RecommendationOrBuilder>(
                recommendations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        recommendations_ = null;
      }
      return recommendationsBuilder_;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec>
        specs_ = java.util.Collections.emptyList();

    private void ensureSpecsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        specs_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                    .MachineAndModelContainerSpec>(specs_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec,
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                .Builder,
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                .MachineAndModelContainerSpecOrBuilder>
        specsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec>
        getSpecsList() {
      if (specsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(specs_);
      } else {
        return specsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getSpecsCount() {
      if (specsBuilder_ == null) {
        return specs_.size();
      } else {
        return specsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
        getSpecs(int index) {
      if (specsBuilder_ == null) {
        return specs_.get(index);
      } else {
        return specsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
            value) {
      if (specsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpecsIsMutable();
        specs_.set(index, value);
        onChanged();
      } else {
        specsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                .Builder
            builderForValue) {
      if (specsBuilder_ == null) {
        ensureSpecsIsMutable();
        specs_.set(index, builderForValue.build());
        onChanged();
      } else {
        specsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSpecs(
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
            value) {
      if (specsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpecsIsMutable();
        specs_.add(value);
        onChanged();
      } else {
        specsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
            value) {
      if (specsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpecsIsMutable();
        specs_.add(index, value);
        onChanged();
      } else {
        specsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSpecs(
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                .Builder
            builderForValue) {
      if (specsBuilder_ == null) {
        ensureSpecsIsMutable();
        specs_.add(builderForValue.build());
        onChanged();
      } else {
        specsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                .Builder
            builderForValue) {
      if (specsBuilder_ == null) {
        ensureSpecsIsMutable();
        specs_.add(index, builderForValue.build());
        onChanged();
      } else {
        specsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllSpecs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                        .MachineAndModelContainerSpec>
            values) {
      if (specsBuilder_ == null) {
        ensureSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, specs_);
        onChanged();
      } else {
        specsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSpecs() {
      if (specsBuilder_ == null) {
        specs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        specsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeSpecs(int index) {
      if (specsBuilder_ == null) {
        ensureSpecsIsMutable();
        specs_.remove(index);
        onChanged();
      } else {
        specsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
            .Builder
        getSpecsBuilder(int index) {
      return getSpecsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
            .MachineAndModelContainerSpecOrBuilder
        getSpecsOrBuilder(int index) {
      if (specsBuilder_ == null) {
        return specs_.get(index);
      } else {
        return specsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                    .MachineAndModelContainerSpecOrBuilder>
        getSpecsOrBuilderList() {
      if (specsBuilder_ != null) {
        return specsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(specs_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
            .Builder
        addSpecsBuilder() {
      return getSpecsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
            .Builder
        addSpecsBuilder(int index) {
      return getSpecsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. The machine and model container specs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                .Builder>
        getSpecsBuilderList() {
      return getSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec,
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse.MachineAndModelContainerSpec
                .Builder,
            com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                .MachineAndModelContainerSpecOrBuilder>
        getSpecsFieldBuilder() {
      if (specsBuilder_ == null) {
        specsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                    .MachineAndModelContainerSpec,
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                    .MachineAndModelContainerSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse
                    .MachineAndModelContainerSpecOrBuilder>(
                specs_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        specs_ = null;
      }
      return specsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RecommendSpecResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RecommendSpecResponse)
  private static final com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse();
  }

  public static com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecommendSpecResponse> PARSER =
      new com.google.protobuf.AbstractParser<RecommendSpecResponse>() {
        @java.lang.Override
        public RecommendSpecResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecommendSpecResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecommendSpecResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RecommendSpecResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
