/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/session.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * An event represents a message from either the user or agent.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.SessionEvent}
 */
public final class SessionEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SessionEvent)
    SessionEventOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SessionEvent.newBuilder() to construct.
  private SessionEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SessionEvent() {
    name_ = "";
    author_ = "";
    invocationId_ = "";
    errorCode_ = "";
    errorMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SessionEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.SessionProto
        .internal_static_google_cloud_aiplatform_v1beta1_SessionEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.SessionProto
        .internal_static_google_cloud_aiplatform_v1beta1_SessionEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.SessionEvent.class,
            com.google.cloud.aiplatform.v1beta1.SessionEvent.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the event.
   * Format:`projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}/events/{event}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the event.
   * Format:`projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}/events/{event}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTHOR_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object author_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the agent that sent the event, or user.
   * </pre>
   *
   * <code>string author = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The author.
   */
  @java.lang.Override
  public java.lang.String getAuthor() {
    java.lang.Object ref = author_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      author_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the agent that sent the event, or user.
   * </pre>
   *
   * <code>string author = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for author.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAuthorBytes() {
    java.lang.Object ref = author_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      author_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.Content content_;

  /**
   *
   *
   * <pre>
   * Optional. Content of the event provided by the author.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the content field is set.
   */
  @java.lang.Override
  public boolean hasContent() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Content of the event provided by the author.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The content.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Content getContent() {
    return content_ == null
        ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
        : content_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Content of the event provided by the author.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getContentOrBuilder() {
    return content_ == null
        ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
        : content_;
  }

  public static final int INVOCATION_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object invocationId_ = "";

  /**
   *
   *
   * <pre>
   * Required. The invocation id of the event, multiple events can have the same
   * invocation id.
   * </pre>
   *
   * <code>string invocation_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The invocationId.
   */
  @java.lang.Override
  public java.lang.String getInvocationId() {
    java.lang.Object ref = invocationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      invocationId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The invocation id of the event, multiple events can have the same
   * invocation id.
   * </pre>
   *
   * <code>string invocation_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for invocationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInvocationIdBytes() {
    java.lang.Object ref = invocationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      invocationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTIONS_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1beta1.EventActions actions_;

  /**
   *
   *
   * <pre>
   * Optional. Actions executed by the agent.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the actions field is set.
   */
  @java.lang.Override
  public boolean hasActions() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Actions executed by the agent.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The actions.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EventActions getActions() {
    return actions_ == null
        ? com.google.cloud.aiplatform.v1beta1.EventActions.getDefaultInstance()
        : actions_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Actions executed by the agent.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EventActionsOrBuilder getActionsOrBuilder() {
    return actions_ == null
        ? com.google.cloud.aiplatform.v1beta1.EventActions.getDefaultInstance()
        : actions_;
  }

  public static final int TIMESTAMP_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp timestamp_;

  /**
   *
   *
   * <pre>
   * Required. Timestamp when the event was created on client side.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the timestamp field is set.
   */
  @java.lang.Override
  public boolean hasTimestamp() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Timestamp when the event was created on client side.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The timestamp.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getTimestamp() {
    return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
  }

  /**
   *
   *
   * <pre>
   * Required. Timestamp when the event was created on client side.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
    return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
  }

  public static final int ERROR_CODE_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorCode_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Error code if the response is an error. Code varies by model.
   * </pre>
   *
   * <code>string error_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The errorCode.
   */
  @java.lang.Override
  public java.lang.String getErrorCode() {
    java.lang.Object ref = errorCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorCode_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Error code if the response is an error. Code varies by model.
   * </pre>
   *
   * <code>string error_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for errorCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorCodeBytes() {
    java.lang.Object ref = errorCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_MESSAGE_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorMessage_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Error message if the response is an error.
   * </pre>
   *
   * <code>string error_message = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The errorMessage.
   */
  @java.lang.Override
  public java.lang.String getErrorMessage() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorMessage_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Error message if the response is an error.
   * </pre>
   *
   * <code>string error_message = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for errorMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorMessageBytes() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_METADATA_FIELD_NUMBER = 11;
  private com.google.cloud.aiplatform.v1beta1.EventMetadata eventMetadata_;

  /**
   *
   *
   * <pre>
   * Optional. Metadata relating to this event.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the eventMetadata field is set.
   */
  @java.lang.Override
  public boolean hasEventMetadata() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Metadata relating to this event.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The eventMetadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EventMetadata getEventMetadata() {
    return eventMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.EventMetadata.getDefaultInstance()
        : eventMetadata_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Metadata relating to this event.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EventMetadataOrBuilder getEventMetadataOrBuilder() {
    return eventMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.EventMetadata.getDefaultInstance()
        : eventMetadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(author_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, author_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getContent());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(invocationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, invocationId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getActions());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getTimestamp());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, errorCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, errorMessage_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(11, getEventMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(author_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, author_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getContent());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(invocationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, invocationId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getActions());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTimestamp());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, errorCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, errorMessage_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getEventMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.SessionEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.SessionEvent other =
        (com.google.cloud.aiplatform.v1beta1.SessionEvent) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAuthor().equals(other.getAuthor())) return false;
    if (hasContent() != other.hasContent()) return false;
    if (hasContent()) {
      if (!getContent().equals(other.getContent())) return false;
    }
    if (!getInvocationId().equals(other.getInvocationId())) return false;
    if (hasActions() != other.hasActions()) return false;
    if (hasActions()) {
      if (!getActions().equals(other.getActions())) return false;
    }
    if (hasTimestamp() != other.hasTimestamp()) return false;
    if (hasTimestamp()) {
      if (!getTimestamp().equals(other.getTimestamp())) return false;
    }
    if (!getErrorCode().equals(other.getErrorCode())) return false;
    if (!getErrorMessage().equals(other.getErrorMessage())) return false;
    if (hasEventMetadata() != other.hasEventMetadata()) return false;
    if (hasEventMetadata()) {
      if (!getEventMetadata().equals(other.getEventMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + AUTHOR_FIELD_NUMBER;
    hash = (53 * hash) + getAuthor().hashCode();
    if (hasContent()) {
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
    }
    hash = (37 * hash) + INVOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getInvocationId().hashCode();
    if (hasActions()) {
      hash = (37 * hash) + ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getActions().hashCode();
    }
    if (hasTimestamp()) {
      hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getTimestamp().hashCode();
    }
    hash = (37 * hash) + ERROR_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getErrorCode().hashCode();
    hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getErrorMessage().hashCode();
    if (hasEventMetadata()) {
      hash = (37 * hash) + EVENT_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getEventMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.SessionEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An event represents a message from either the user or agent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.SessionEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SessionEvent)
      com.google.cloud.aiplatform.v1beta1.SessionEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_SessionEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_SessionEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.SessionEvent.class,
              com.google.cloud.aiplatform.v1beta1.SessionEvent.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.SessionEvent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getContentFieldBuilder();
        getActionsFieldBuilder();
        getTimestampFieldBuilder();
        getEventMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      author_ = "";
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      invocationId_ = "";
      actions_ = null;
      if (actionsBuilder_ != null) {
        actionsBuilder_.dispose();
        actionsBuilder_ = null;
      }
      timestamp_ = null;
      if (timestampBuilder_ != null) {
        timestampBuilder_.dispose();
        timestampBuilder_ = null;
      }
      errorCode_ = "";
      errorMessage_ = "";
      eventMetadata_ = null;
      if (eventMetadataBuilder_ != null) {
        eventMetadataBuilder_.dispose();
        eventMetadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_SessionEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SessionEvent getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.SessionEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SessionEvent build() {
      com.google.cloud.aiplatform.v1beta1.SessionEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SessionEvent buildPartial() {
      com.google.cloud.aiplatform.v1beta1.SessionEvent result =
          new com.google.cloud.aiplatform.v1beta1.SessionEvent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.SessionEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.author_ = author_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.content_ = contentBuilder_ == null ? content_ : contentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.invocationId_ = invocationId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.actions_ = actionsBuilder_ == null ? actions_ : actionsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.timestamp_ = timestampBuilder_ == null ? timestamp_ : timestampBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.errorCode_ = errorCode_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.errorMessage_ = errorMessage_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.eventMetadata_ =
            eventMetadataBuilder_ == null ? eventMetadata_ : eventMetadataBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.SessionEvent) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.SessionEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.SessionEvent other) {
      if (other == com.google.cloud.aiplatform.v1beta1.SessionEvent.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAuthor().isEmpty()) {
        author_ = other.author_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasContent()) {
        mergeContent(other.getContent());
      }
      if (!other.getInvocationId().isEmpty()) {
        invocationId_ = other.invocationId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasActions()) {
        mergeActions(other.getActions());
      }
      if (other.hasTimestamp()) {
        mergeTimestamp(other.getTimestamp());
      }
      if (!other.getErrorCode().isEmpty()) {
        errorCode_ = other.errorCode_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getErrorMessage().isEmpty()) {
        errorMessage_ = other.errorMessage_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasEventMetadata()) {
        mergeEventMetadata(other.getEventMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                author_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getContentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                invocationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getActionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 66:
              {
                input.readMessage(getTimestampFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 74:
              {
                errorCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            case 82:
              {
                errorMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getEventMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the event.
     * Format:`projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}/events/{event}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the event.
     * Format:`projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}/events/{event}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the event.
     * Format:`projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}/events/{event}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the event.
     * Format:`projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}/events/{event}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the event.
     * Format:`projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}/events/{event}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object author_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the agent that sent the event, or user.
     * </pre>
     *
     * <code>string author = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The author.
     */
    public java.lang.String getAuthor() {
      java.lang.Object ref = author_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        author_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the agent that sent the event, or user.
     * </pre>
     *
     * <code>string author = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for author.
     */
    public com.google.protobuf.ByteString getAuthorBytes() {
      java.lang.Object ref = author_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        author_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the agent that sent the event, or user.
     * </pre>
     *
     * <code>string author = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The author to set.
     * @return This builder for chaining.
     */
    public Builder setAuthor(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      author_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the agent that sent the event, or user.
     * </pre>
     *
     * <code>string author = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthor() {
      author_ = getDefaultInstance().getAuthor();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the agent that sent the event, or user.
     * </pre>
     *
     * <code>string author = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for author to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      author_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.Content content_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        contentBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Content of the event provided by the author.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the content field is set.
     */
    public boolean hasContent() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Content of the event provided by the author.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The content.
     */
    public com.google.cloud.aiplatform.v1beta1.Content getContent() {
      if (contentBuilder_ == null) {
        return content_ == null
            ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
            : content_;
      } else {
        return contentBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Content of the event provided by the author.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContent(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (contentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
      } else {
        contentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content of the event provided by the author.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContent(com.google.cloud.aiplatform.v1beta1.Content.Builder builderForValue) {
      if (contentBuilder_ == null) {
        content_ = builderForValue.build();
      } else {
        contentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content of the event provided by the author.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeContent(com.google.cloud.aiplatform.v1beta1.Content value) {
      if (contentBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && content_ != null
            && content_ != com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()) {
          getContentBuilder().mergeFrom(value);
        } else {
          content_ = value;
        }
      } else {
        contentBuilder_.mergeFrom(value);
      }
      if (content_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content of the event provided by the author.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearContent() {
      bitField0_ = (bitField0_ & ~0x00000004);
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content of the event provided by the author.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Content.Builder getContentBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getContentFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Content of the event provided by the author.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ContentOrBuilder getContentOrBuilder() {
      if (contentBuilder_ != null) {
        return contentBuilder_.getMessageOrBuilder();
      } else {
        return content_ == null
            ? com.google.cloud.aiplatform.v1beta1.Content.getDefaultInstance()
            : content_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Content of the event provided by the author.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Content content = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Content,
            com.google.cloud.aiplatform.v1beta1.Content.Builder,
            com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>
        getContentFieldBuilder() {
      if (contentBuilder_ == null) {
        contentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Content,
                com.google.cloud.aiplatform.v1beta1.Content.Builder,
                com.google.cloud.aiplatform.v1beta1.ContentOrBuilder>(
                getContent(), getParentForChildren(), isClean());
        content_ = null;
      }
      return contentBuilder_;
    }

    private java.lang.Object invocationId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The invocation id of the event, multiple events can have the same
     * invocation id.
     * </pre>
     *
     * <code>string invocation_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The invocationId.
     */
    public java.lang.String getInvocationId() {
      java.lang.Object ref = invocationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        invocationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The invocation id of the event, multiple events can have the same
     * invocation id.
     * </pre>
     *
     * <code>string invocation_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for invocationId.
     */
    public com.google.protobuf.ByteString getInvocationIdBytes() {
      java.lang.Object ref = invocationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        invocationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The invocation id of the event, multiple events can have the same
     * invocation id.
     * </pre>
     *
     * <code>string invocation_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The invocationId to set.
     * @return This builder for chaining.
     */
    public Builder setInvocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      invocationId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The invocation id of the event, multiple events can have the same
     * invocation id.
     * </pre>
     *
     * <code>string invocation_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvocationId() {
      invocationId_ = getDefaultInstance().getInvocationId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The invocation id of the event, multiple events can have the same
     * invocation id.
     * </pre>
     *
     * <code>string invocation_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for invocationId to set.
     * @return This builder for chaining.
     */
    public Builder setInvocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      invocationId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.EventActions actions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EventActions,
            com.google.cloud.aiplatform.v1beta1.EventActions.Builder,
            com.google.cloud.aiplatform.v1beta1.EventActionsOrBuilder>
        actionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Actions executed by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the actions field is set.
     */
    public boolean hasActions() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Actions executed by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The actions.
     */
    public com.google.cloud.aiplatform.v1beta1.EventActions getActions() {
      if (actionsBuilder_ == null) {
        return actions_ == null
            ? com.google.cloud.aiplatform.v1beta1.EventActions.getDefaultInstance()
            : actions_;
      } else {
        return actionsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Actions executed by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setActions(com.google.cloud.aiplatform.v1beta1.EventActions value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        actions_ = value;
      } else {
        actionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Actions executed by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setActions(
        com.google.cloud.aiplatform.v1beta1.EventActions.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        actions_ = builderForValue.build();
      } else {
        actionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Actions executed by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeActions(com.google.cloud.aiplatform.v1beta1.EventActions value) {
      if (actionsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && actions_ != null
            && actions_ != com.google.cloud.aiplatform.v1beta1.EventActions.getDefaultInstance()) {
          getActionsBuilder().mergeFrom(value);
        } else {
          actions_ = value;
        }
      } else {
        actionsBuilder_.mergeFrom(value);
      }
      if (actions_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Actions executed by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearActions() {
      bitField0_ = (bitField0_ & ~0x00000010);
      actions_ = null;
      if (actionsBuilder_ != null) {
        actionsBuilder_.dispose();
        actionsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Actions executed by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EventActions.Builder getActionsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getActionsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Actions executed by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EventActionsOrBuilder getActionsOrBuilder() {
      if (actionsBuilder_ != null) {
        return actionsBuilder_.getMessageOrBuilder();
      } else {
        return actions_ == null
            ? com.google.cloud.aiplatform.v1beta1.EventActions.getDefaultInstance()
            : actions_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Actions executed by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventActions actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EventActions,
            com.google.cloud.aiplatform.v1beta1.EventActions.Builder,
            com.google.cloud.aiplatform.v1beta1.EventActionsOrBuilder>
        getActionsFieldBuilder() {
      if (actionsBuilder_ == null) {
        actionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EventActions,
                com.google.cloud.aiplatform.v1beta1.EventActions.Builder,
                com.google.cloud.aiplatform.v1beta1.EventActionsOrBuilder>(
                getActions(), getParentForChildren(), isClean());
        actions_ = null;
      }
      return actionsBuilder_;
    }

    private com.google.protobuf.Timestamp timestamp_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        timestampBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Timestamp when the event was created on client side.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the timestamp field is set.
     */
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Timestamp when the event was created on client side.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The timestamp.
     */
    public com.google.protobuf.Timestamp getTimestamp() {
      if (timestampBuilder_ == null) {
        return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
      } else {
        return timestampBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Timestamp when the event was created on client side.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTimestamp(com.google.protobuf.Timestamp value) {
      if (timestampBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timestamp_ = value;
      } else {
        timestampBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Timestamp when the event was created on client side.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (timestampBuilder_ == null) {
        timestamp_ = builderForValue.build();
      } else {
        timestampBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Timestamp when the event was created on client side.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTimestamp(com.google.protobuf.Timestamp value) {
      if (timestampBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && timestamp_ != null
            && timestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getTimestampBuilder().mergeFrom(value);
        } else {
          timestamp_ = value;
        }
      } else {
        timestampBuilder_.mergeFrom(value);
      }
      if (timestamp_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Timestamp when the event was created on client side.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTimestamp() {
      bitField0_ = (bitField0_ & ~0x00000020);
      timestamp_ = null;
      if (timestampBuilder_ != null) {
        timestampBuilder_.dispose();
        timestampBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Timestamp when the event was created on client side.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getTimestampBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getTimestampFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Timestamp when the event was created on client side.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
      if (timestampBuilder_ != null) {
        return timestampBuilder_.getMessageOrBuilder();
      } else {
        return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Timestamp when the event was created on client side.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getTimestampFieldBuilder() {
      if (timestampBuilder_ == null) {
        timestampBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getTimestamp(), getParentForChildren(), isClean());
        timestamp_ = null;
      }
      return timestampBuilder_;
    }

    private java.lang.Object errorCode_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Error code if the response is an error. Code varies by model.
     * </pre>
     *
     * <code>string error_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The errorCode.
     */
    public java.lang.String getErrorCode() {
      java.lang.Object ref = errorCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Error code if the response is an error. Code varies by model.
     * </pre>
     *
     * <code>string error_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for errorCode.
     */
    public com.google.protobuf.ByteString getErrorCodeBytes() {
      java.lang.Object ref = errorCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Error code if the response is an error. Code varies by model.
     * </pre>
     *
     * <code>string error_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The errorCode to set.
     * @return This builder for chaining.
     */
    public Builder setErrorCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorCode_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Error code if the response is an error. Code varies by model.
     * </pre>
     *
     * <code>string error_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorCode() {
      errorCode_ = getDefaultInstance().getErrorCode();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Error code if the response is an error. Code varies by model.
     * </pre>
     *
     * <code>string error_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for errorCode to set.
     * @return This builder for chaining.
     */
    public Builder setErrorCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorCode_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object errorMessage_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Error message if the response is an error.
     * </pre>
     *
     * <code>string error_message = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The errorMessage.
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Error message if the response is an error.
     * </pre>
     *
     * <code>string error_message = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for errorMessage.
     */
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Error message if the response is an error.
     * </pre>
     *
     * <code>string error_message = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorMessage_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Error message if the response is an error.
     * </pre>
     *
     * <code>string error_message = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorMessage() {
      errorMessage_ = getDefaultInstance().getErrorMessage();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Error message if the response is an error.
     * </pre>
     *
     * <code>string error_message = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorMessage_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.EventMetadata eventMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EventMetadata,
            com.google.cloud.aiplatform.v1beta1.EventMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.EventMetadataOrBuilder>
        eventMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Metadata relating to this event.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the eventMetadata field is set.
     */
    public boolean hasEventMetadata() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata relating to this event.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The eventMetadata.
     */
    public com.google.cloud.aiplatform.v1beta1.EventMetadata getEventMetadata() {
      if (eventMetadataBuilder_ == null) {
        return eventMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.EventMetadata.getDefaultInstance()
            : eventMetadata_;
      } else {
        return eventMetadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata relating to this event.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEventMetadata(com.google.cloud.aiplatform.v1beta1.EventMetadata value) {
      if (eventMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventMetadata_ = value;
      } else {
        eventMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata relating to this event.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEventMetadata(
        com.google.cloud.aiplatform.v1beta1.EventMetadata.Builder builderForValue) {
      if (eventMetadataBuilder_ == null) {
        eventMetadata_ = builderForValue.build();
      } else {
        eventMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata relating to this event.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEventMetadata(com.google.cloud.aiplatform.v1beta1.EventMetadata value) {
      if (eventMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && eventMetadata_ != null
            && eventMetadata_
                != com.google.cloud.aiplatform.v1beta1.EventMetadata.getDefaultInstance()) {
          getEventMetadataBuilder().mergeFrom(value);
        } else {
          eventMetadata_ = value;
        }
      } else {
        eventMetadataBuilder_.mergeFrom(value);
      }
      if (eventMetadata_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata relating to this event.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEventMetadata() {
      bitField0_ = (bitField0_ & ~0x00000100);
      eventMetadata_ = null;
      if (eventMetadataBuilder_ != null) {
        eventMetadataBuilder_.dispose();
        eventMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata relating to this event.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EventMetadata.Builder getEventMetadataBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getEventMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata relating to this event.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EventMetadataOrBuilder getEventMetadataOrBuilder() {
      if (eventMetadataBuilder_ != null) {
        return eventMetadataBuilder_.getMessageOrBuilder();
      } else {
        return eventMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.EventMetadata.getDefaultInstance()
            : eventMetadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata relating to this event.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EventMetadata event_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EventMetadata,
            com.google.cloud.aiplatform.v1beta1.EventMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.EventMetadataOrBuilder>
        getEventMetadataFieldBuilder() {
      if (eventMetadataBuilder_ == null) {
        eventMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EventMetadata,
                com.google.cloud.aiplatform.v1beta1.EventMetadata.Builder,
                com.google.cloud.aiplatform.v1beta1.EventMetadataOrBuilder>(
                getEventMetadata(), getParentForChildren(), isClean());
        eventMetadata_ = null;
      }
      return eventMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SessionEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SessionEvent)
  private static final com.google.cloud.aiplatform.v1beta1.SessionEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.SessionEvent();
  }

  public static com.google.cloud.aiplatform.v1beta1.SessionEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SessionEvent> PARSER =
      new com.google.protobuf.AbstractParser<SessionEvent>() {
        @java.lang.Override
        public SessionEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SessionEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SessionEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SessionEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
