/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/io.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The SharePointSources to pass to ImportRagFiles.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.SharePointSources}
 */
public final class SharePointSources extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SharePointSources)
    SharePointSourcesOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SharePointSources.newBuilder() to construct.
  private SharePointSources(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SharePointSources() {
    sharePointSources_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SharePointSources();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.IoProto
        .internal_static_google_cloud_aiplatform_v1beta1_SharePointSources_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.IoProto
        .internal_static_google_cloud_aiplatform_v1beta1_SharePointSources_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.SharePointSources.class,
            com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder.class);
  }

  public interface SharePointSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The path of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_path = 5;</code>
     *
     * @return Whether the sharepointFolderPath field is set.
     */
    boolean hasSharepointFolderPath();

    /**
     *
     *
     * <pre>
     * The path of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_path = 5;</code>
     *
     * @return The sharepointFolderPath.
     */
    java.lang.String getSharepointFolderPath();

    /**
     *
     *
     * <pre>
     * The path of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_path = 5;</code>
     *
     * @return The bytes for sharepointFolderPath.
     */
    com.google.protobuf.ByteString getSharepointFolderPathBytes();

    /**
     *
     *
     * <pre>
     * The ID of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_id = 6;</code>
     *
     * @return Whether the sharepointFolderId field is set.
     */
    boolean hasSharepointFolderId();

    /**
     *
     *
     * <pre>
     * The ID of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_id = 6;</code>
     *
     * @return The sharepointFolderId.
     */
    java.lang.String getSharepointFolderId();

    /**
     *
     *
     * <pre>
     * The ID of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_id = 6;</code>
     *
     * @return The bytes for sharepointFolderId.
     */
    com.google.protobuf.ByteString getSharepointFolderIdBytes();

    /**
     *
     *
     * <pre>
     * The name of the drive to download from.
     * </pre>
     *
     * <code>string drive_name = 7;</code>
     *
     * @return Whether the driveName field is set.
     */
    boolean hasDriveName();

    /**
     *
     *
     * <pre>
     * The name of the drive to download from.
     * </pre>
     *
     * <code>string drive_name = 7;</code>
     *
     * @return The driveName.
     */
    java.lang.String getDriveName();

    /**
     *
     *
     * <pre>
     * The name of the drive to download from.
     * </pre>
     *
     * <code>string drive_name = 7;</code>
     *
     * @return The bytes for driveName.
     */
    com.google.protobuf.ByteString getDriveNameBytes();

    /**
     *
     *
     * <pre>
     * The ID of the drive to download from.
     * </pre>
     *
     * <code>string drive_id = 8;</code>
     *
     * @return Whether the driveId field is set.
     */
    boolean hasDriveId();

    /**
     *
     *
     * <pre>
     * The ID of the drive to download from.
     * </pre>
     *
     * <code>string drive_id = 8;</code>
     *
     * @return The driveId.
     */
    java.lang.String getDriveId();

    /**
     *
     *
     * <pre>
     * The ID of the drive to download from.
     * </pre>
     *
     * <code>string drive_id = 8;</code>
     *
     * @return The bytes for driveId.
     */
    com.google.protobuf.ByteString getDriveIdBytes();

    /**
     *
     *
     * <pre>
     * The Application ID for the app registered in Microsoft Azure Portal.
     * The application must also be configured with MS Graph permissions
     * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
     * </pre>
     *
     * <code>string client_id = 1;</code>
     *
     * @return The clientId.
     */
    java.lang.String getClientId();

    /**
     *
     *
     * <pre>
     * The Application ID for the app registered in Microsoft Azure Portal.
     * The application must also be configured with MS Graph permissions
     * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
     * </pre>
     *
     * <code>string client_id = 1;</code>
     *
     * @return The bytes for clientId.
     */
    com.google.protobuf.ByteString getClientIdBytes();

    /**
     *
     *
     * <pre>
     * The application secret for the app registered in Azure.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
     *
     * @return Whether the clientSecret field is set.
     */
    boolean hasClientSecret();

    /**
     *
     *
     * <pre>
     * The application secret for the app registered in Azure.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
     *
     * @return The clientSecret.
     */
    com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig getClientSecret();

    /**
     *
     *
     * <pre>
     * The application secret for the app registered in Azure.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
     */
    com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder getClientSecretOrBuilder();

    /**
     *
     *
     * <pre>
     * Unique identifier of the Azure Active Directory Instance.
     * </pre>
     *
     * <code>string tenant_id = 3;</code>
     *
     * @return The tenantId.
     */
    java.lang.String getTenantId();

    /**
     *
     *
     * <pre>
     * Unique identifier of the Azure Active Directory Instance.
     * </pre>
     *
     * <code>string tenant_id = 3;</code>
     *
     * @return The bytes for tenantId.
     */
    com.google.protobuf.ByteString getTenantIdBytes();

    /**
     *
     *
     * <pre>
     * The name of the SharePoint site to download from. This can be the site
     * name or the site id.
     * </pre>
     *
     * <code>string sharepoint_site_name = 4;</code>
     *
     * @return The sharepointSiteName.
     */
    java.lang.String getSharepointSiteName();

    /**
     *
     *
     * <pre>
     * The name of the SharePoint site to download from. This can be the site
     * name or the site id.
     * </pre>
     *
     * <code>string sharepoint_site_name = 4;</code>
     *
     * @return The bytes for sharepointSiteName.
     */
    com.google.protobuf.ByteString getSharepointSiteNameBytes();

    /**
     *
     *
     * <pre>
     * Output only. The SharePoint file id. Output only.
     * </pre>
     *
     * <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The fileId.
     */
    java.lang.String getFileId();

    /**
     *
     *
     * <pre>
     * Output only. The SharePoint file id. Output only.
     * </pre>
     *
     * <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for fileId.
     */
    com.google.protobuf.ByteString getFileIdBytes();

    com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.FolderSourceCase
        getFolderSourceCase();

    com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.DriveSourceCase
        getDriveSourceCase();
  }

  /**
   *
   *
   * <pre>
   * An individual SharePointSource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource}
   */
  public static final class SharePointSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource)
      SharePointSourceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SharePointSource.newBuilder() to construct.
    private SharePointSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SharePointSource() {
      clientId_ = "";
      tenantId_ = "";
      sharepointSiteName_ = "";
      fileId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SharePointSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_SharePointSources_SharePointSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_SharePointSources_SharePointSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.class,
              com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder.class);
    }

    private int bitField0_;
    private int folderSourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object folderSource_;

    public enum FolderSourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SHAREPOINT_FOLDER_PATH(5),
      SHAREPOINT_FOLDER_ID(6),
      FOLDERSOURCE_NOT_SET(0);
      private final int value;

      private FolderSourceCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static FolderSourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static FolderSourceCase forNumber(int value) {
        switch (value) {
          case 5:
            return SHAREPOINT_FOLDER_PATH;
          case 6:
            return SHAREPOINT_FOLDER_ID;
          case 0:
            return FOLDERSOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public FolderSourceCase getFolderSourceCase() {
      return FolderSourceCase.forNumber(folderSourceCase_);
    }

    private int driveSourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object driveSource_;

    public enum DriveSourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      DRIVE_NAME(7),
      DRIVE_ID(8),
      DRIVESOURCE_NOT_SET(0);
      private final int value;

      private DriveSourceCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DriveSourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static DriveSourceCase forNumber(int value) {
        switch (value) {
          case 7:
            return DRIVE_NAME;
          case 8:
            return DRIVE_ID;
          case 0:
            return DRIVESOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DriveSourceCase getDriveSourceCase() {
      return DriveSourceCase.forNumber(driveSourceCase_);
    }

    public static final int SHAREPOINT_FOLDER_PATH_FIELD_NUMBER = 5;

    /**
     *
     *
     * <pre>
     * The path of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_path = 5;</code>
     *
     * @return Whether the sharepointFolderPath field is set.
     */
    public boolean hasSharepointFolderPath() {
      return folderSourceCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * The path of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_path = 5;</code>
     *
     * @return The sharepointFolderPath.
     */
    public java.lang.String getSharepointFolderPath() {
      java.lang.Object ref = "";
      if (folderSourceCase_ == 5) {
        ref = folderSource_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (folderSourceCase_ == 5) {
          folderSource_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The path of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_path = 5;</code>
     *
     * @return The bytes for sharepointFolderPath.
     */
    public com.google.protobuf.ByteString getSharepointFolderPathBytes() {
      java.lang.Object ref = "";
      if (folderSourceCase_ == 5) {
        ref = folderSource_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (folderSourceCase_ == 5) {
          folderSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SHAREPOINT_FOLDER_ID_FIELD_NUMBER = 6;

    /**
     *
     *
     * <pre>
     * The ID of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_id = 6;</code>
     *
     * @return Whether the sharepointFolderId field is set.
     */
    public boolean hasSharepointFolderId() {
      return folderSourceCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * The ID of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_id = 6;</code>
     *
     * @return The sharepointFolderId.
     */
    public java.lang.String getSharepointFolderId() {
      java.lang.Object ref = "";
      if (folderSourceCase_ == 6) {
        ref = folderSource_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (folderSourceCase_ == 6) {
          folderSource_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The ID of the SharePoint folder to download from.
     * </pre>
     *
     * <code>string sharepoint_folder_id = 6;</code>
     *
     * @return The bytes for sharepointFolderId.
     */
    public com.google.protobuf.ByteString getSharepointFolderIdBytes() {
      java.lang.Object ref = "";
      if (folderSourceCase_ == 6) {
        ref = folderSource_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (folderSourceCase_ == 6) {
          folderSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DRIVE_NAME_FIELD_NUMBER = 7;

    /**
     *
     *
     * <pre>
     * The name of the drive to download from.
     * </pre>
     *
     * <code>string drive_name = 7;</code>
     *
     * @return Whether the driveName field is set.
     */
    public boolean hasDriveName() {
      return driveSourceCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * The name of the drive to download from.
     * </pre>
     *
     * <code>string drive_name = 7;</code>
     *
     * @return The driveName.
     */
    public java.lang.String getDriveName() {
      java.lang.Object ref = "";
      if (driveSourceCase_ == 7) {
        ref = driveSource_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (driveSourceCase_ == 7) {
          driveSource_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the drive to download from.
     * </pre>
     *
     * <code>string drive_name = 7;</code>
     *
     * @return The bytes for driveName.
     */
    public com.google.protobuf.ByteString getDriveNameBytes() {
      java.lang.Object ref = "";
      if (driveSourceCase_ == 7) {
        ref = driveSource_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (driveSourceCase_ == 7) {
          driveSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DRIVE_ID_FIELD_NUMBER = 8;

    /**
     *
     *
     * <pre>
     * The ID of the drive to download from.
     * </pre>
     *
     * <code>string drive_id = 8;</code>
     *
     * @return Whether the driveId field is set.
     */
    public boolean hasDriveId() {
      return driveSourceCase_ == 8;
    }

    /**
     *
     *
     * <pre>
     * The ID of the drive to download from.
     * </pre>
     *
     * <code>string drive_id = 8;</code>
     *
     * @return The driveId.
     */
    public java.lang.String getDriveId() {
      java.lang.Object ref = "";
      if (driveSourceCase_ == 8) {
        ref = driveSource_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (driveSourceCase_ == 8) {
          driveSource_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The ID of the drive to download from.
     * </pre>
     *
     * <code>string drive_id = 8;</code>
     *
     * @return The bytes for driveId.
     */
    public com.google.protobuf.ByteString getDriveIdBytes() {
      java.lang.Object ref = "";
      if (driveSourceCase_ == 8) {
        ref = driveSource_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (driveSourceCase_ == 8) {
          driveSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLIENT_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object clientId_ = "";

    /**
     *
     *
     * <pre>
     * The Application ID for the app registered in Microsoft Azure Portal.
     * The application must also be configured with MS Graph permissions
     * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
     * </pre>
     *
     * <code>string client_id = 1;</code>
     *
     * @return The clientId.
     */
    @java.lang.Override
    public java.lang.String getClientId() {
      java.lang.Object ref = clientId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The Application ID for the app registered in Microsoft Azure Portal.
     * The application must also be configured with MS Graph permissions
     * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
     * </pre>
     *
     * <code>string client_id = 1;</code>
     *
     * @return The bytes for clientId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getClientIdBytes() {
      java.lang.Object ref = clientId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLIENT_SECRET_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig clientSecret_;

    /**
     *
     *
     * <pre>
     * The application secret for the app registered in Azure.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
     *
     * @return Whether the clientSecret field is set.
     */
    @java.lang.Override
    public boolean hasClientSecret() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The application secret for the app registered in Azure.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
     *
     * @return The clientSecret.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig getClientSecret() {
      return clientSecret_ == null
          ? com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.getDefaultInstance()
          : clientSecret_;
    }

    /**
     *
     *
     * <pre>
     * The application secret for the app registered in Azure.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder
        getClientSecretOrBuilder() {
      return clientSecret_ == null
          ? com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.getDefaultInstance()
          : clientSecret_;
    }

    public static final int TENANT_ID_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object tenantId_ = "";

    /**
     *
     *
     * <pre>
     * Unique identifier of the Azure Active Directory Instance.
     * </pre>
     *
     * <code>string tenant_id = 3;</code>
     *
     * @return The tenantId.
     */
    @java.lang.Override
    public java.lang.String getTenantId() {
      java.lang.Object ref = tenantId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tenantId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Unique identifier of the Azure Active Directory Instance.
     * </pre>
     *
     * <code>string tenant_id = 3;</code>
     *
     * @return The bytes for tenantId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTenantIdBytes() {
      java.lang.Object ref = tenantId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tenantId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SHAREPOINT_SITE_NAME_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sharepointSiteName_ = "";

    /**
     *
     *
     * <pre>
     * The name of the SharePoint site to download from. This can be the site
     * name or the site id.
     * </pre>
     *
     * <code>string sharepoint_site_name = 4;</code>
     *
     * @return The sharepointSiteName.
     */
    @java.lang.Override
    public java.lang.String getSharepointSiteName() {
      java.lang.Object ref = sharepointSiteName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sharepointSiteName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the SharePoint site to download from. This can be the site
     * name or the site id.
     * </pre>
     *
     * <code>string sharepoint_site_name = 4;</code>
     *
     * @return The bytes for sharepointSiteName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSharepointSiteNameBytes() {
      java.lang.Object ref = sharepointSiteName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sharepointSiteName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FILE_ID_FIELD_NUMBER = 9;

    @SuppressWarnings("serial")
    private volatile java.lang.Object fileId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The SharePoint file id. Output only.
     * </pre>
     *
     * <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The fileId.
     */
    @java.lang.Override
    public java.lang.String getFileId() {
      java.lang.Object ref = fileId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fileId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The SharePoint file id. Output only.
     * </pre>
     *
     * <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for fileId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFileIdBytes() {
      java.lang.Object ref = fileId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fileId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, clientId_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getClientSecret());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tenantId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tenantId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sharepointSiteName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, sharepointSiteName_);
      }
      if (folderSourceCase_ == 5) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, folderSource_);
      }
      if (folderSourceCase_ == 6) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, folderSource_);
      }
      if (driveSourceCase_ == 7) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, driveSource_);
      }
      if (driveSourceCase_ == 8) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, driveSource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fileId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, fileId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, clientId_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getClientSecret());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tenantId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tenantId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sharepointSiteName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, sharepointSiteName_);
      }
      if (folderSourceCase_ == 5) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, folderSource_);
      }
      if (folderSourceCase_ == 6) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, folderSource_);
      }
      if (driveSourceCase_ == 7) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, driveSource_);
      }
      if (driveSourceCase_ == 8) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, driveSource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fileId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, fileId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource other =
          (com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource) obj;

      if (!getClientId().equals(other.getClientId())) return false;
      if (hasClientSecret() != other.hasClientSecret()) return false;
      if (hasClientSecret()) {
        if (!getClientSecret().equals(other.getClientSecret())) return false;
      }
      if (!getTenantId().equals(other.getTenantId())) return false;
      if (!getSharepointSiteName().equals(other.getSharepointSiteName())) return false;
      if (!getFileId().equals(other.getFileId())) return false;
      if (!getFolderSourceCase().equals(other.getFolderSourceCase())) return false;
      switch (folderSourceCase_) {
        case 5:
          if (!getSharepointFolderPath().equals(other.getSharepointFolderPath())) return false;
          break;
        case 6:
          if (!getSharepointFolderId().equals(other.getSharepointFolderId())) return false;
          break;
        case 0:
        default:
      }
      if (!getDriveSourceCase().equals(other.getDriveSourceCase())) return false;
      switch (driveSourceCase_) {
        case 7:
          if (!getDriveName().equals(other.getDriveName())) return false;
          break;
        case 8:
          if (!getDriveId().equals(other.getDriveId())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CLIENT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getClientId().hashCode();
      if (hasClientSecret()) {
        hash = (37 * hash) + CLIENT_SECRET_FIELD_NUMBER;
        hash = (53 * hash) + getClientSecret().hashCode();
      }
      hash = (37 * hash) + TENANT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getTenantId().hashCode();
      hash = (37 * hash) + SHAREPOINT_SITE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getSharepointSiteName().hashCode();
      hash = (37 * hash) + FILE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getFileId().hashCode();
      switch (folderSourceCase_) {
        case 5:
          hash = (37 * hash) + SHAREPOINT_FOLDER_PATH_FIELD_NUMBER;
          hash = (53 * hash) + getSharepointFolderPath().hashCode();
          break;
        case 6:
          hash = (37 * hash) + SHAREPOINT_FOLDER_ID_FIELD_NUMBER;
          hash = (53 * hash) + getSharepointFolderId().hashCode();
          break;
        case 0:
        default:
      }
      switch (driveSourceCase_) {
        case 7:
          hash = (37 * hash) + DRIVE_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getDriveName().hashCode();
          break;
        case 8:
          hash = (37 * hash) + DRIVE_ID_FIELD_NUMBER;
          hash = (53 * hash) + getDriveId().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * An individual SharePointSource.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource)
        com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.IoProto
            .internal_static_google_cloud_aiplatform_v1beta1_SharePointSources_SharePointSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.IoProto
            .internal_static_google_cloud_aiplatform_v1beta1_SharePointSources_SharePointSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.class,
                com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getClientSecretFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        clientId_ = "";
        clientSecret_ = null;
        if (clientSecretBuilder_ != null) {
          clientSecretBuilder_.dispose();
          clientSecretBuilder_ = null;
        }
        tenantId_ = "";
        sharepointSiteName_ = "";
        fileId_ = "";
        folderSourceCase_ = 0;
        folderSource_ = null;
        driveSourceCase_ = 0;
        driveSource_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.IoProto
            .internal_static_google_cloud_aiplatform_v1beta1_SharePointSources_SharePointSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource build() {
        com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource buildPartial() {
        com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource result =
            new com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.clientId_ = clientId_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.clientSecret_ =
              clientSecretBuilder_ == null ? clientSecret_ : clientSecretBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.tenantId_ = tenantId_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.sharepointSiteName_ = sharepointSiteName_;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.fileId_ = fileId_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource result) {
        result.folderSourceCase_ = folderSourceCase_;
        result.folderSource_ = this.folderSource_;
        result.driveSourceCase_ = driveSourceCase_;
        result.driveSource_ = this.driveSource_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
                .getDefaultInstance()) return this;
        if (!other.getClientId().isEmpty()) {
          clientId_ = other.clientId_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.hasClientSecret()) {
          mergeClientSecret(other.getClientSecret());
        }
        if (!other.getTenantId().isEmpty()) {
          tenantId_ = other.tenantId_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        if (!other.getSharepointSiteName().isEmpty()) {
          sharepointSiteName_ = other.sharepointSiteName_;
          bitField0_ |= 0x00000080;
          onChanged();
        }
        if (!other.getFileId().isEmpty()) {
          fileId_ = other.fileId_;
          bitField0_ |= 0x00000100;
          onChanged();
        }
        switch (other.getFolderSourceCase()) {
          case SHAREPOINT_FOLDER_PATH:
            {
              folderSourceCase_ = 5;
              folderSource_ = other.folderSource_;
              onChanged();
              break;
            }
          case SHAREPOINT_FOLDER_ID:
            {
              folderSourceCase_ = 6;
              folderSource_ = other.folderSource_;
              onChanged();
              break;
            }
          case FOLDERSOURCE_NOT_SET:
            {
              break;
            }
        }
        switch (other.getDriveSourceCase()) {
          case DRIVE_NAME:
            {
              driveSourceCase_ = 7;
              driveSource_ = other.driveSource_;
              onChanged();
              break;
            }
          case DRIVE_ID:
            {
              driveSourceCase_ = 8;
              driveSource_ = other.driveSource_;
              onChanged();
              break;
            }
          case DRIVESOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  clientId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getClientSecretFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 18
              case 26:
                {
                  tenantId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 26
              case 34:
                {
                  sharepointSiteName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 34
              case 42:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  folderSourceCase_ = 5;
                  folderSource_ = s;
                  break;
                } // case 42
              case 50:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  folderSourceCase_ = 6;
                  folderSource_ = s;
                  break;
                } // case 50
              case 58:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  driveSourceCase_ = 7;
                  driveSource_ = s;
                  break;
                } // case 58
              case 66:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  driveSourceCase_ = 8;
                  driveSource_ = s;
                  break;
                } // case 66
              case 74:
                {
                  fileId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000100;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int folderSourceCase_ = 0;
      private java.lang.Object folderSource_;

      public FolderSourceCase getFolderSourceCase() {
        return FolderSourceCase.forNumber(folderSourceCase_);
      }

      public Builder clearFolderSource() {
        folderSourceCase_ = 0;
        folderSource_ = null;
        onChanged();
        return this;
      }

      private int driveSourceCase_ = 0;
      private java.lang.Object driveSource_;

      public DriveSourceCase getDriveSourceCase() {
        return DriveSourceCase.forNumber(driveSourceCase_);
      }

      public Builder clearDriveSource() {
        driveSourceCase_ = 0;
        driveSource_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The path of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_path = 5;</code>
       *
       * @return Whether the sharepointFolderPath field is set.
       */
      @java.lang.Override
      public boolean hasSharepointFolderPath() {
        return folderSourceCase_ == 5;
      }

      /**
       *
       *
       * <pre>
       * The path of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_path = 5;</code>
       *
       * @return The sharepointFolderPath.
       */
      @java.lang.Override
      public java.lang.String getSharepointFolderPath() {
        java.lang.Object ref = "";
        if (folderSourceCase_ == 5) {
          ref = folderSource_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (folderSourceCase_ == 5) {
            folderSource_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The path of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_path = 5;</code>
       *
       * @return The bytes for sharepointFolderPath.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSharepointFolderPathBytes() {
        java.lang.Object ref = "";
        if (folderSourceCase_ == 5) {
          ref = folderSource_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (folderSourceCase_ == 5) {
            folderSource_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The path of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_path = 5;</code>
       *
       * @param value The sharepointFolderPath to set.
       * @return This builder for chaining.
       */
      public Builder setSharepointFolderPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        folderSourceCase_ = 5;
        folderSource_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The path of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_path = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSharepointFolderPath() {
        if (folderSourceCase_ == 5) {
          folderSourceCase_ = 0;
          folderSource_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The path of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_path = 5;</code>
       *
       * @param value The bytes for sharepointFolderPath to set.
       * @return This builder for chaining.
       */
      public Builder setSharepointFolderPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        folderSourceCase_ = 5;
        folderSource_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The ID of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_id = 6;</code>
       *
       * @return Whether the sharepointFolderId field is set.
       */
      @java.lang.Override
      public boolean hasSharepointFolderId() {
        return folderSourceCase_ == 6;
      }

      /**
       *
       *
       * <pre>
       * The ID of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_id = 6;</code>
       *
       * @return The sharepointFolderId.
       */
      @java.lang.Override
      public java.lang.String getSharepointFolderId() {
        java.lang.Object ref = "";
        if (folderSourceCase_ == 6) {
          ref = folderSource_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (folderSourceCase_ == 6) {
            folderSource_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The ID of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_id = 6;</code>
       *
       * @return The bytes for sharepointFolderId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSharepointFolderIdBytes() {
        java.lang.Object ref = "";
        if (folderSourceCase_ == 6) {
          ref = folderSource_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (folderSourceCase_ == 6) {
            folderSource_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The ID of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_id = 6;</code>
       *
       * @param value The sharepointFolderId to set.
       * @return This builder for chaining.
       */
      public Builder setSharepointFolderId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        folderSourceCase_ = 6;
        folderSource_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The ID of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_id = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSharepointFolderId() {
        if (folderSourceCase_ == 6) {
          folderSourceCase_ = 0;
          folderSource_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The ID of the SharePoint folder to download from.
       * </pre>
       *
       * <code>string sharepoint_folder_id = 6;</code>
       *
       * @param value The bytes for sharepointFolderId to set.
       * @return This builder for chaining.
       */
      public Builder setSharepointFolderIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        folderSourceCase_ = 6;
        folderSource_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the drive to download from.
       * </pre>
       *
       * <code>string drive_name = 7;</code>
       *
       * @return Whether the driveName field is set.
       */
      @java.lang.Override
      public boolean hasDriveName() {
        return driveSourceCase_ == 7;
      }

      /**
       *
       *
       * <pre>
       * The name of the drive to download from.
       * </pre>
       *
       * <code>string drive_name = 7;</code>
       *
       * @return The driveName.
       */
      @java.lang.Override
      public java.lang.String getDriveName() {
        java.lang.Object ref = "";
        if (driveSourceCase_ == 7) {
          ref = driveSource_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (driveSourceCase_ == 7) {
            driveSource_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the drive to download from.
       * </pre>
       *
       * <code>string drive_name = 7;</code>
       *
       * @return The bytes for driveName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDriveNameBytes() {
        java.lang.Object ref = "";
        if (driveSourceCase_ == 7) {
          ref = driveSource_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (driveSourceCase_ == 7) {
            driveSource_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the drive to download from.
       * </pre>
       *
       * <code>string drive_name = 7;</code>
       *
       * @param value The driveName to set.
       * @return This builder for chaining.
       */
      public Builder setDriveName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        driveSourceCase_ = 7;
        driveSource_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the drive to download from.
       * </pre>
       *
       * <code>string drive_name = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDriveName() {
        if (driveSourceCase_ == 7) {
          driveSourceCase_ = 0;
          driveSource_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the drive to download from.
       * </pre>
       *
       * <code>string drive_name = 7;</code>
       *
       * @param value The bytes for driveName to set.
       * @return This builder for chaining.
       */
      public Builder setDriveNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        driveSourceCase_ = 7;
        driveSource_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The ID of the drive to download from.
       * </pre>
       *
       * <code>string drive_id = 8;</code>
       *
       * @return Whether the driveId field is set.
       */
      @java.lang.Override
      public boolean hasDriveId() {
        return driveSourceCase_ == 8;
      }

      /**
       *
       *
       * <pre>
       * The ID of the drive to download from.
       * </pre>
       *
       * <code>string drive_id = 8;</code>
       *
       * @return The driveId.
       */
      @java.lang.Override
      public java.lang.String getDriveId() {
        java.lang.Object ref = "";
        if (driveSourceCase_ == 8) {
          ref = driveSource_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (driveSourceCase_ == 8) {
            driveSource_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The ID of the drive to download from.
       * </pre>
       *
       * <code>string drive_id = 8;</code>
       *
       * @return The bytes for driveId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDriveIdBytes() {
        java.lang.Object ref = "";
        if (driveSourceCase_ == 8) {
          ref = driveSource_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (driveSourceCase_ == 8) {
            driveSource_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The ID of the drive to download from.
       * </pre>
       *
       * <code>string drive_id = 8;</code>
       *
       * @param value The driveId to set.
       * @return This builder for chaining.
       */
      public Builder setDriveId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        driveSourceCase_ = 8;
        driveSource_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The ID of the drive to download from.
       * </pre>
       *
       * <code>string drive_id = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDriveId() {
        if (driveSourceCase_ == 8) {
          driveSourceCase_ = 0;
          driveSource_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The ID of the drive to download from.
       * </pre>
       *
       * <code>string drive_id = 8;</code>
       *
       * @param value The bytes for driveId to set.
       * @return This builder for chaining.
       */
      public Builder setDriveIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        driveSourceCase_ = 8;
        driveSource_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object clientId_ = "";

      /**
       *
       *
       * <pre>
       * The Application ID for the app registered in Microsoft Azure Portal.
       * The application must also be configured with MS Graph permissions
       * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
       * </pre>
       *
       * <code>string client_id = 1;</code>
       *
       * @return The clientId.
       */
      public java.lang.String getClientId() {
        java.lang.Object ref = clientId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clientId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The Application ID for the app registered in Microsoft Azure Portal.
       * The application must also be configured with MS Graph permissions
       * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
       * </pre>
       *
       * <code>string client_id = 1;</code>
       *
       * @return The bytes for clientId.
       */
      public com.google.protobuf.ByteString getClientIdBytes() {
        java.lang.Object ref = clientId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          clientId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The Application ID for the app registered in Microsoft Azure Portal.
       * The application must also be configured with MS Graph permissions
       * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
       * </pre>
       *
       * <code>string client_id = 1;</code>
       *
       * @param value The clientId to set.
       * @return This builder for chaining.
       */
      public Builder setClientId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        clientId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Application ID for the app registered in Microsoft Azure Portal.
       * The application must also be configured with MS Graph permissions
       * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
       * </pre>
       *
       * <code>string client_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClientId() {
        clientId_ = getDefaultInstance().getClientId();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Application ID for the app registered in Microsoft Azure Portal.
       * The application must also be configured with MS Graph permissions
       * "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
       * </pre>
       *
       * <code>string client_id = 1;</code>
       *
       * @param value The bytes for clientId to set.
       * @return This builder for chaining.
       */
      public Builder setClientIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        clientId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig clientSecret_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig,
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder>
          clientSecretBuilder_;

      /**
       *
       *
       * <pre>
       * The application secret for the app registered in Azure.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
       *
       * @return Whether the clientSecret field is set.
       */
      public boolean hasClientSecret() {
        return ((bitField0_ & 0x00000020) != 0);
      }

      /**
       *
       *
       * <pre>
       * The application secret for the app registered in Azure.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
       *
       * @return The clientSecret.
       */
      public com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig getClientSecret() {
        if (clientSecretBuilder_ == null) {
          return clientSecret_ == null
              ? com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.getDefaultInstance()
              : clientSecret_;
        } else {
          return clientSecretBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The application secret for the app registered in Azure.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
       */
      public Builder setClientSecret(
          com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig value) {
        if (clientSecretBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          clientSecret_ = value;
        } else {
          clientSecretBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The application secret for the app registered in Azure.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
       */
      public Builder setClientSecret(
          com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.Builder builderForValue) {
        if (clientSecretBuilder_ == null) {
          clientSecret_ = builderForValue.build();
        } else {
          clientSecretBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The application secret for the app registered in Azure.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
       */
      public Builder mergeClientSecret(
          com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig value) {
        if (clientSecretBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && clientSecret_ != null
              && clientSecret_
                  != com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig
                      .getDefaultInstance()) {
            getClientSecretBuilder().mergeFrom(value);
          } else {
            clientSecret_ = value;
          }
        } else {
          clientSecretBuilder_.mergeFrom(value);
        }
        if (clientSecret_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The application secret for the app registered in Azure.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
       */
      public Builder clearClientSecret() {
        bitField0_ = (bitField0_ & ~0x00000020);
        clientSecret_ = null;
        if (clientSecretBuilder_ != null) {
          clientSecretBuilder_.dispose();
          clientSecretBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The application secret for the app registered in Azure.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.Builder
          getClientSecretBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getClientSecretFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The application secret for the app registered in Azure.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder
          getClientSecretOrBuilder() {
        if (clientSecretBuilder_ != null) {
          return clientSecretBuilder_.getMessageOrBuilder();
        } else {
          return clientSecret_ == null
              ? com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.getDefaultInstance()
              : clientSecret_;
        }
      }

      /**
       *
       *
       * <pre>
       * The application secret for the app registered in Azure.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig client_secret = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig,
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder>
          getClientSecretFieldBuilder() {
        if (clientSecretBuilder_ == null) {
          clientSecretBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig,
                  com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig.Builder,
                  com.google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfigOrBuilder>(
                  getClientSecret(), getParentForChildren(), isClean());
          clientSecret_ = null;
        }
        return clientSecretBuilder_;
      }

      private java.lang.Object tenantId_ = "";

      /**
       *
       *
       * <pre>
       * Unique identifier of the Azure Active Directory Instance.
       * </pre>
       *
       * <code>string tenant_id = 3;</code>
       *
       * @return The tenantId.
       */
      public java.lang.String getTenantId() {
        java.lang.Object ref = tenantId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tenantId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Unique identifier of the Azure Active Directory Instance.
       * </pre>
       *
       * <code>string tenant_id = 3;</code>
       *
       * @return The bytes for tenantId.
       */
      public com.google.protobuf.ByteString getTenantIdBytes() {
        java.lang.Object ref = tenantId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tenantId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Unique identifier of the Azure Active Directory Instance.
       * </pre>
       *
       * <code>string tenant_id = 3;</code>
       *
       * @param value The tenantId to set.
       * @return This builder for chaining.
       */
      public Builder setTenantId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        tenantId_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique identifier of the Azure Active Directory Instance.
       * </pre>
       *
       * <code>string tenant_id = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTenantId() {
        tenantId_ = getDefaultInstance().getTenantId();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique identifier of the Azure Active Directory Instance.
       * </pre>
       *
       * <code>string tenant_id = 3;</code>
       *
       * @param value The bytes for tenantId to set.
       * @return This builder for chaining.
       */
      public Builder setTenantIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        tenantId_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      private java.lang.Object sharepointSiteName_ = "";

      /**
       *
       *
       * <pre>
       * The name of the SharePoint site to download from. This can be the site
       * name or the site id.
       * </pre>
       *
       * <code>string sharepoint_site_name = 4;</code>
       *
       * @return The sharepointSiteName.
       */
      public java.lang.String getSharepointSiteName() {
        java.lang.Object ref = sharepointSiteName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sharepointSiteName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the SharePoint site to download from. This can be the site
       * name or the site id.
       * </pre>
       *
       * <code>string sharepoint_site_name = 4;</code>
       *
       * @return The bytes for sharepointSiteName.
       */
      public com.google.protobuf.ByteString getSharepointSiteNameBytes() {
        java.lang.Object ref = sharepointSiteName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sharepointSiteName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the SharePoint site to download from. This can be the site
       * name or the site id.
       * </pre>
       *
       * <code>string sharepoint_site_name = 4;</code>
       *
       * @param value The sharepointSiteName to set.
       * @return This builder for chaining.
       */
      public Builder setSharepointSiteName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sharepointSiteName_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the SharePoint site to download from. This can be the site
       * name or the site id.
       * </pre>
       *
       * <code>string sharepoint_site_name = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSharepointSiteName() {
        sharepointSiteName_ = getDefaultInstance().getSharepointSiteName();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the SharePoint site to download from. This can be the site
       * name or the site id.
       * </pre>
       *
       * <code>string sharepoint_site_name = 4;</code>
       *
       * @param value The bytes for sharepointSiteName to set.
       * @return This builder for chaining.
       */
      public Builder setSharepointSiteNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sharepointSiteName_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      private java.lang.Object fileId_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The SharePoint file id. Output only.
       * </pre>
       *
       * <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The fileId.
       */
      public java.lang.String getFileId() {
        java.lang.Object ref = fileId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fileId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The SharePoint file id. Output only.
       * </pre>
       *
       * <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for fileId.
       */
      public com.google.protobuf.ByteString getFileIdBytes() {
        java.lang.Object ref = fileId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fileId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The SharePoint file id. Output only.
       * </pre>
       *
       * <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The fileId to set.
       * @return This builder for chaining.
       */
      public Builder setFileId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        fileId_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The SharePoint file id. Output only.
       * </pre>
       *
       * <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFileId() {
        fileId_ = getDefaultInstance().getFileId();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The SharePoint file id. Output only.
       * </pre>
       *
       * <code>string file_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for fileId to set.
       * @return This builder for chaining.
       */
      public Builder setFileIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        fileId_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource)
    private static final com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource();
    }

    public static com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SharePointSource> PARSER =
        new com.google.protobuf.AbstractParser<SharePointSource>() {
          @java.lang.Override
          public SharePointSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SharePointSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SharePointSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int SHARE_POINT_SOURCES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource>
      sharePointSources_;

  /**
   *
   *
   * <pre>
   * The SharePoint sources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource>
      getSharePointSourcesList() {
    return sharePointSources_;
  }

  /**
   *
   *
   * <pre>
   * The SharePoint sources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSourceOrBuilder>
      getSharePointSourcesOrBuilderList() {
    return sharePointSources_;
  }

  /**
   *
   *
   * <pre>
   * The SharePoint sources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
   * </code>
   */
  @java.lang.Override
  public int getSharePointSourcesCount() {
    return sharePointSources_.size();
  }

  /**
   *
   *
   * <pre>
   * The SharePoint sources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
      getSharePointSources(int index) {
    return sharePointSources_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The SharePoint sources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSourceOrBuilder
      getSharePointSourcesOrBuilder(int index) {
    return sharePointSources_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < sharePointSources_.size(); i++) {
      output.writeMessage(1, sharePointSources_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < sharePointSources_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, sharePointSources_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.SharePointSources)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.SharePointSources other =
        (com.google.cloud.aiplatform.v1beta1.SharePointSources) obj;

    if (!getSharePointSourcesList().equals(other.getSharePointSourcesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSharePointSourcesCount() > 0) {
      hash = (37 * hash) + SHARE_POINT_SOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getSharePointSourcesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.SharePointSources prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The SharePointSources to pass to ImportRagFiles.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.SharePointSources}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SharePointSources)
      com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_SharePointSources_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_SharePointSources_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.SharePointSources.class,
              com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.SharePointSources.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (sharePointSourcesBuilder_ == null) {
        sharePointSources_ = java.util.Collections.emptyList();
      } else {
        sharePointSources_ = null;
        sharePointSourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.IoProto
          .internal_static_google_cloud_aiplatform_v1beta1_SharePointSources_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SharePointSources getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SharePointSources build() {
      com.google.cloud.aiplatform.v1beta1.SharePointSources result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SharePointSources buildPartial() {
      com.google.cloud.aiplatform.v1beta1.SharePointSources result =
          new com.google.cloud.aiplatform.v1beta1.SharePointSources(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.SharePointSources result) {
      if (sharePointSourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          sharePointSources_ = java.util.Collections.unmodifiableList(sharePointSources_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.sharePointSources_ = sharePointSources_;
      } else {
        result.sharePointSources_ = sharePointSourcesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.SharePointSources result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.SharePointSources) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.SharePointSources) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.SharePointSources other) {
      if (other == com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance())
        return this;
      if (sharePointSourcesBuilder_ == null) {
        if (!other.sharePointSources_.isEmpty()) {
          if (sharePointSources_.isEmpty()) {
            sharePointSources_ = other.sharePointSources_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSharePointSourcesIsMutable();
            sharePointSources_.addAll(other.sharePointSources_);
          }
          onChanged();
        }
      } else {
        if (!other.sharePointSources_.isEmpty()) {
          if (sharePointSourcesBuilder_.isEmpty()) {
            sharePointSourcesBuilder_.dispose();
            sharePointSourcesBuilder_ = null;
            sharePointSources_ = other.sharePointSources_;
            bitField0_ = (bitField0_ & ~0x00000001);
            sharePointSourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSharePointSourcesFieldBuilder()
                    : null;
          } else {
            sharePointSourcesBuilder_.addAllMessages(other.sharePointSources_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
                            .parser(),
                        extensionRegistry);
                if (sharePointSourcesBuilder_ == null) {
                  ensureSharePointSourcesIsMutable();
                  sharePointSources_.add(m);
                } else {
                  sharePointSourcesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource>
        sharePointSources_ = java.util.Collections.emptyList();

    private void ensureSharePointSourcesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        sharePointSources_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource>(
                sharePointSources_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource,
            com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder,
            com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSourceOrBuilder>
        sharePointSourcesBuilder_;

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource>
        getSharePointSourcesList() {
      if (sharePointSourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sharePointSources_);
      } else {
        return sharePointSourcesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public int getSharePointSourcesCount() {
      if (sharePointSourcesBuilder_ == null) {
        return sharePointSources_.size();
      } else {
        return sharePointSourcesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
        getSharePointSources(int index) {
      if (sharePointSourcesBuilder_ == null) {
        return sharePointSources_.get(index);
      } else {
        return sharePointSourcesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public Builder setSharePointSources(
        int index, com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource value) {
      if (sharePointSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSharePointSourcesIsMutable();
        sharePointSources_.set(index, value);
        onChanged();
      } else {
        sharePointSourcesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public Builder setSharePointSources(
        int index,
        com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder
            builderForValue) {
      if (sharePointSourcesBuilder_ == null) {
        ensureSharePointSourcesIsMutable();
        sharePointSources_.set(index, builderForValue.build());
        onChanged();
      } else {
        sharePointSourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public Builder addSharePointSources(
        com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource value) {
      if (sharePointSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSharePointSourcesIsMutable();
        sharePointSources_.add(value);
        onChanged();
      } else {
        sharePointSourcesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public Builder addSharePointSources(
        int index, com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource value) {
      if (sharePointSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSharePointSourcesIsMutable();
        sharePointSources_.add(index, value);
        onChanged();
      } else {
        sharePointSourcesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public Builder addSharePointSources(
        com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder
            builderForValue) {
      if (sharePointSourcesBuilder_ == null) {
        ensureSharePointSourcesIsMutable();
        sharePointSources_.add(builderForValue.build());
        onChanged();
      } else {
        sharePointSourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public Builder addSharePointSources(
        int index,
        com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder
            builderForValue) {
      if (sharePointSourcesBuilder_ == null) {
        ensureSharePointSourcesIsMutable();
        sharePointSources_.add(index, builderForValue.build());
        onChanged();
      } else {
        sharePointSourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public Builder addAllSharePointSources(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource>
            values) {
      if (sharePointSourcesBuilder_ == null) {
        ensureSharePointSourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sharePointSources_);
        onChanged();
      } else {
        sharePointSourcesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public Builder clearSharePointSources() {
      if (sharePointSourcesBuilder_ == null) {
        sharePointSources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        sharePointSourcesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public Builder removeSharePointSources(int index) {
      if (sharePointSourcesBuilder_ == null) {
        ensureSharePointSourcesIsMutable();
        sharePointSources_.remove(index);
        onChanged();
      } else {
        sharePointSourcesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder
        getSharePointSourcesBuilder(int index) {
      return getSharePointSourcesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSourceOrBuilder
        getSharePointSourcesOrBuilder(int index) {
      if (sharePointSourcesBuilder_ == null) {
        return sharePointSources_.get(index);
      } else {
        return sharePointSourcesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSourceOrBuilder>
        getSharePointSourcesOrBuilderList() {
      if (sharePointSourcesBuilder_ != null) {
        return sharePointSourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sharePointSources_);
      }
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder
        addSharePointSourcesBuilder() {
      return getSharePointSourcesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder
        addSharePointSourcesBuilder(int index) {
      return getSharePointSourcesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The SharePoint sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource share_point_sources = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder>
        getSharePointSourcesBuilderList() {
      return getSharePointSourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource,
            com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder,
            com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSourceOrBuilder>
        getSharePointSourcesFieldBuilder() {
      if (sharePointSourcesBuilder_ == null) {
        sharePointSourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource,
                com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.Builder,
                com.google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSourceOrBuilder>(
                sharePointSources_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        sharePointSources_ = null;
      }
      return sharePointSourcesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SharePointSources)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SharePointSources)
  private static final com.google.cloud.aiplatform.v1beta1.SharePointSources DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.SharePointSources();
  }

  public static com.google.cloud.aiplatform.v1beta1.SharePointSources getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SharePointSources> PARSER =
      new com.google.protobuf.AbstractParser<SharePointSources>() {
        @java.lang.Override
        public SharePointSources parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SharePointSources> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SharePointSources> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SharePointSources getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
