/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigeeregistry.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ArtifactName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ARTIFACT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/artifacts/{artifact}");
    private static final PathTemplate PROJECT_LOCATION_API_ARTIFACT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/apis/{api}/artifacts/{artifact}");
    private static final PathTemplate PROJECT_LOCATION_API_VERSION_ARTIFACT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/apis/{api}/versions/{version}/artifacts/{artifact}");
    private static final PathTemplate PROJECT_LOCATION_API_VERSION_SPEC_ARTIFACT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}/artifacts/{artifact}");
    private static final PathTemplate PROJECT_LOCATION_API_DEPLOYMENT_ARTIFACT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/apis/{api}/deployments/{deployment}/artifacts/{artifact}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String artifact;
    private final String api;
    private final String version;
    private final String spec;
    private final String deployment;

    @Deprecated
    protected ArtifactName() {
        this.project = null;
        this.location = null;
        this.artifact = null;
        this.api = null;
        this.version = null;
        this.spec = null;
        this.deployment = null;
    }

    private ArtifactName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.artifact = (String)Preconditions.checkNotNull((Object)builder.getArtifact());
        this.api = null;
        this.version = null;
        this.spec = null;
        this.deployment = null;
        this.pathTemplate = PROJECT_LOCATION_ARTIFACT;
    }

    private ArtifactName(ProjectLocationApiArtifactBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.api = (String)Preconditions.checkNotNull((Object)builder.getApi());
        this.artifact = (String)Preconditions.checkNotNull((Object)builder.getArtifact());
        this.version = null;
        this.spec = null;
        this.deployment = null;
        this.pathTemplate = PROJECT_LOCATION_API_ARTIFACT;
    }

    private ArtifactName(ProjectLocationApiVersionArtifactBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.api = (String)Preconditions.checkNotNull((Object)builder.getApi());
        this.version = (String)Preconditions.checkNotNull((Object)builder.getVersion());
        this.artifact = (String)Preconditions.checkNotNull((Object)builder.getArtifact());
        this.spec = null;
        this.deployment = null;
        this.pathTemplate = PROJECT_LOCATION_API_VERSION_ARTIFACT;
    }

    private ArtifactName(ProjectLocationApiVersionSpecArtifactBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.api = (String)Preconditions.checkNotNull((Object)builder.getApi());
        this.version = (String)Preconditions.checkNotNull((Object)builder.getVersion());
        this.spec = (String)Preconditions.checkNotNull((Object)builder.getSpec());
        this.artifact = (String)Preconditions.checkNotNull((Object)builder.getArtifact());
        this.deployment = null;
        this.pathTemplate = PROJECT_LOCATION_API_VERSION_SPEC_ARTIFACT;
    }

    private ArtifactName(ProjectLocationApiDeploymentArtifactBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.api = (String)Preconditions.checkNotNull((Object)builder.getApi());
        this.deployment = (String)Preconditions.checkNotNull((Object)builder.getDeployment());
        this.artifact = (String)Preconditions.checkNotNull((Object)builder.getArtifact());
        this.version = null;
        this.spec = null;
        this.pathTemplate = PROJECT_LOCATION_API_DEPLOYMENT_ARTIFACT;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getApi() {
        return this.api;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSpec() {
        return this.spec;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationArtifactBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationApiArtifactBuilder newProjectLocationApiArtifactBuilder() {
        return new ProjectLocationApiArtifactBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationApiVersionArtifactBuilder newProjectLocationApiVersionArtifactBuilder() {
        return new ProjectLocationApiVersionArtifactBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationApiVersionSpecArtifactBuilder newProjectLocationApiVersionSpecArtifactBuilder() {
        return new ProjectLocationApiVersionSpecArtifactBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationApiDeploymentArtifactBuilder newProjectLocationApiDeploymentArtifactBuilder() {
        return new ProjectLocationApiDeploymentArtifactBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ArtifactName of(String project, String location, String artifact) {
        return ArtifactName.newBuilder().setProject(project).setLocation(location).setArtifact(artifact).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ArtifactName ofProjectLocationArtifactName(String project, String location, String artifact) {
        return ArtifactName.newBuilder().setProject(project).setLocation(location).setArtifact(artifact).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ArtifactName ofProjectLocationApiArtifactName(String project, String location, String api, String artifact) {
        return ArtifactName.newProjectLocationApiArtifactBuilder().setProject(project).setLocation(location).setApi(api).setArtifact(artifact).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ArtifactName ofProjectLocationApiVersionArtifactName(String project, String location, String api, String version, String artifact) {
        return ArtifactName.newProjectLocationApiVersionArtifactBuilder().setProject(project).setLocation(location).setApi(api).setVersion(version).setArtifact(artifact).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ArtifactName ofProjectLocationApiVersionSpecArtifactName(String project, String location, String api, String version, String spec, String artifact) {
        return ArtifactName.newProjectLocationApiVersionSpecArtifactBuilder().setProject(project).setLocation(location).setApi(api).setVersion(version).setSpec(spec).setArtifact(artifact).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ArtifactName ofProjectLocationApiDeploymentArtifactName(String project, String location, String api, String deployment, String artifact) {
        return ArtifactName.newProjectLocationApiDeploymentArtifactBuilder().setProject(project).setLocation(location).setApi(api).setDeployment(deployment).setArtifact(artifact).build();
    }

    public static String format(String project, String location, String artifact) {
        return ArtifactName.newBuilder().setProject(project).setLocation(location).setArtifact(artifact).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationArtifactName(String project, String location, String artifact) {
        return ArtifactName.newBuilder().setProject(project).setLocation(location).setArtifact(artifact).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationApiArtifactName(String project, String location, String api, String artifact) {
        return ArtifactName.newProjectLocationApiArtifactBuilder().setProject(project).setLocation(location).setApi(api).setArtifact(artifact).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationApiVersionArtifactName(String project, String location, String api, String version, String artifact) {
        return ArtifactName.newProjectLocationApiVersionArtifactBuilder().setProject(project).setLocation(location).setApi(api).setVersion(version).setArtifact(artifact).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationApiVersionSpecArtifactName(String project, String location, String api, String version, String spec, String artifact) {
        return ArtifactName.newProjectLocationApiVersionSpecArtifactBuilder().setProject(project).setLocation(location).setApi(api).setVersion(version).setSpec(spec).setArtifact(artifact).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationApiDeploymentArtifactName(String project, String location, String api, String deployment, String artifact) {
        return ArtifactName.newProjectLocationApiDeploymentArtifactBuilder().setProject(project).setLocation(location).setApi(api).setDeployment(deployment).setArtifact(artifact).build().toString();
    }

    public static ArtifactName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_ARTIFACT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_ARTIFACT.match(formattedString);
            return ArtifactName.ofProjectLocationArtifactName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("artifact"));
        }
        if (PROJECT_LOCATION_API_ARTIFACT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_API_ARTIFACT.match(formattedString);
            return ArtifactName.ofProjectLocationApiArtifactName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("api"), (String)matchMap.get("artifact"));
        }
        if (PROJECT_LOCATION_API_VERSION_ARTIFACT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_API_VERSION_ARTIFACT.match(formattedString);
            return ArtifactName.ofProjectLocationApiVersionArtifactName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("api"), (String)matchMap.get("version"), (String)matchMap.get("artifact"));
        }
        if (PROJECT_LOCATION_API_VERSION_SPEC_ARTIFACT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_API_VERSION_SPEC_ARTIFACT.match(formattedString);
            return ArtifactName.ofProjectLocationApiVersionSpecArtifactName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("api"), (String)matchMap.get("version"), (String)matchMap.get("spec"), (String)matchMap.get("artifact"));
        }
        if (PROJECT_LOCATION_API_DEPLOYMENT_ARTIFACT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_API_DEPLOYMENT_ARTIFACT.match(formattedString);
            return ArtifactName.ofProjectLocationApiDeploymentArtifactName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("api"), (String)matchMap.get("deployment"), (String)matchMap.get("artifact"));
        }
        throw new ValidationException("ArtifactName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ArtifactName> parseList(List<String> formattedStrings) {
        ArrayList<ArtifactName> list = new ArrayList<ArtifactName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ArtifactName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ArtifactName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ArtifactName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ARTIFACT.matches(formattedString) || PROJECT_LOCATION_API_ARTIFACT.matches(formattedString) || PROJECT_LOCATION_API_VERSION_ARTIFACT.matches(formattedString) || PROJECT_LOCATION_API_VERSION_SPEC_ARTIFACT.matches(formattedString) || PROJECT_LOCATION_API_DEPLOYMENT_ARTIFACT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ArtifactName artifactName = this;
            synchronized (artifactName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.artifact != null) {
                        fieldMapBuilder.put((Object)"artifact", (Object)this.artifact);
                    }
                    if (this.api != null) {
                        fieldMapBuilder.put((Object)"api", (Object)this.api);
                    }
                    if (this.version != null) {
                        fieldMapBuilder.put((Object)"version", (Object)this.version);
                    }
                    if (this.spec != null) {
                        fieldMapBuilder.put((Object)"spec", (Object)this.spec);
                    }
                    if (this.deployment != null) {
                        fieldMapBuilder.put((Object)"deployment", (Object)this.deployment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ArtifactName that = (ArtifactName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.artifact, that.artifact) && Objects.equals(this.api, that.api) && Objects.equals(this.version, that.version) && Objects.equals(this.spec, that.spec) && Objects.equals(this.deployment, that.deployment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.artifact);
        h *= 1000003;
        h ^= Objects.hashCode(this.api);
        h *= 1000003;
        h ^= Objects.hashCode(this.version);
        h *= 1000003;
        h ^= Objects.hashCode(this.spec);
        h *= 1000003;
        return h ^= Objects.hashCode(this.deployment);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationApiDeploymentArtifactBuilder {
        private String project;
        private String location;
        private String api;
        private String deployment;
        private String artifact;

        protected ProjectLocationApiDeploymentArtifactBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getApi() {
            return this.api;
        }

        public String getDeployment() {
            return this.deployment;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public ProjectLocationApiDeploymentArtifactBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationApiDeploymentArtifactBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationApiDeploymentArtifactBuilder setApi(String api) {
            this.api = api;
            return this;
        }

        public ProjectLocationApiDeploymentArtifactBuilder setDeployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        public ProjectLocationApiDeploymentArtifactBuilder setArtifact(String artifact) {
            this.artifact = artifact;
            return this;
        }

        public ArtifactName build() {
            return new ArtifactName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationApiVersionSpecArtifactBuilder {
        private String project;
        private String location;
        private String api;
        private String version;
        private String spec;
        private String artifact;

        protected ProjectLocationApiVersionSpecArtifactBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getApi() {
            return this.api;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSpec() {
            return this.spec;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public ProjectLocationApiVersionSpecArtifactBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationApiVersionSpecArtifactBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationApiVersionSpecArtifactBuilder setApi(String api) {
            this.api = api;
            return this;
        }

        public ProjectLocationApiVersionSpecArtifactBuilder setVersion(String version) {
            this.version = version;
            return this;
        }

        public ProjectLocationApiVersionSpecArtifactBuilder setSpec(String spec) {
            this.spec = spec;
            return this;
        }

        public ProjectLocationApiVersionSpecArtifactBuilder setArtifact(String artifact) {
            this.artifact = artifact;
            return this;
        }

        public ArtifactName build() {
            return new ArtifactName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationApiVersionArtifactBuilder {
        private String project;
        private String location;
        private String api;
        private String version;
        private String artifact;

        protected ProjectLocationApiVersionArtifactBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getApi() {
            return this.api;
        }

        public String getVersion() {
            return this.version;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public ProjectLocationApiVersionArtifactBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationApiVersionArtifactBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationApiVersionArtifactBuilder setApi(String api) {
            this.api = api;
            return this;
        }

        public ProjectLocationApiVersionArtifactBuilder setVersion(String version) {
            this.version = version;
            return this;
        }

        public ProjectLocationApiVersionArtifactBuilder setArtifact(String artifact) {
            this.artifact = artifact;
            return this;
        }

        public ArtifactName build() {
            return new ArtifactName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationApiArtifactBuilder {
        private String project;
        private String location;
        private String api;
        private String artifact;

        protected ProjectLocationApiArtifactBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getApi() {
            return this.api;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public ProjectLocationApiArtifactBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationApiArtifactBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationApiArtifactBuilder setApi(String api) {
            this.api = api;
            return this;
        }

        public ProjectLocationApiArtifactBuilder setArtifact(String artifact) {
            this.artifact = artifact;
            return this;
        }

        public ArtifactName build() {
            return new ArtifactName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String artifact;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setArtifact(String artifact) {
            this.artifact = artifact;
            return this;
        }

        private Builder(ArtifactName artifactName) {
            Preconditions.checkArgument((boolean)Objects.equals(artifactName.pathTemplate, PROJECT_LOCATION_ARTIFACT), (Object)"toBuilder is only supported when ArtifactName has the pattern of projects/{project}/locations/{location}/artifacts/{artifact}");
            this.project = artifactName.project;
            this.location = artifactName.location;
            this.artifact = artifactName.artifact;
        }

        public ArtifactName build() {
            return new ArtifactName(this);
        }
    }
}

