/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntryGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENTRY_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entryGroups/{entry_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String entryGroup;

    @Deprecated
    protected EntryGroupName() {
        this.project = null;
        this.location = null;
        this.entryGroup = null;
    }

    private EntryGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entryGroup = (String)Preconditions.checkNotNull((Object)builder.getEntryGroup());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEntryGroup() {
        return this.entryGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntryGroupName of(String project, String location, String entryGroup) {
        return EntryGroupName.newBuilder().setProject(project).setLocation(location).setEntryGroup(entryGroup).build();
    }

    public static String format(String project, String location, String entryGroup) {
        return EntryGroupName.newBuilder().setProject(project).setLocation(location).setEntryGroup(entryGroup).build().toString();
    }

    public static EntryGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENTRY_GROUP.validatedMatch(formattedString, "EntryGroupName.parse: formattedString not in valid format");
        return EntryGroupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("entry_group"));
    }

    public static List<EntryGroupName> parseList(List<String> formattedStrings) {
        ArrayList<EntryGroupName> list = new ArrayList<EntryGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntryGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntryGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntryGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENTRY_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntryGroupName entryGroupName = this;
            synchronized (entryGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.entryGroup != null) {
                        fieldMapBuilder.put((Object)"entry_group", (Object)this.entryGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENTRY_GROUP.instantiate(new String[]{"project", this.project, "location", this.location, "entry_group", this.entryGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EntryGroupName that = (EntryGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.entryGroup, that.entryGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.entryGroup);
    }

    public static class Builder {
        private String project;
        private String location;
        private String entryGroup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntryGroup() {
            return this.entryGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEntryGroup(String entryGroup) {
            this.entryGroup = entryGroup;
            return this;
        }

        private Builder(EntryGroupName entryGroupName) {
            this.project = entryGroupName.project;
            this.location = entryGroupName.location;
            this.entryGroup = entryGroupName.entryGroup;
        }

        public EntryGroupName build() {
            return new EntryGroupName(this);
        }
    }
}

