/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datalabeling.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EvaluationJobName
implements ResourceName {
    private static final PathTemplate PROJECT_EVALUATION_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/evaluationJobs/{evaluation_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String evaluationJob;

    @Deprecated
    protected EvaluationJobName() {
        this.project = null;
        this.evaluationJob = null;
    }

    private EvaluationJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.evaluationJob = (String)Preconditions.checkNotNull((Object)builder.getEvaluationJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getEvaluationJob() {
        return this.evaluationJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EvaluationJobName of(String project, String evaluationJob) {
        return EvaluationJobName.newBuilder().setProject(project).setEvaluationJob(evaluationJob).build();
    }

    public static String format(String project, String evaluationJob) {
        return EvaluationJobName.newBuilder().setProject(project).setEvaluationJob(evaluationJob).build().toString();
    }

    public static EvaluationJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_EVALUATION_JOB.validatedMatch(formattedString, "EvaluationJobName.parse: formattedString not in valid format");
        return EvaluationJobName.of((String)matchMap.get("project"), (String)matchMap.get("evaluation_job"));
    }

    public static List<EvaluationJobName> parseList(List<String> formattedStrings) {
        ArrayList<EvaluationJobName> list = new ArrayList<EvaluationJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EvaluationJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EvaluationJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EvaluationJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_EVALUATION_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EvaluationJobName evaluationJobName = this;
            synchronized (evaluationJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.evaluationJob != null) {
                        fieldMapBuilder.put((Object)"evaluation_job", (Object)this.evaluationJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_EVALUATION_JOB.instantiate(new String[]{"project", this.project, "evaluation_job", this.evaluationJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EvaluationJobName that = (EvaluationJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.evaluationJob, that.evaluationJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.evaluationJob);
    }

    public static class Builder {
        private String project;
        private String evaluationJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getEvaluationJob() {
            return this.evaluationJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setEvaluationJob(String evaluationJob) {
            this.evaluationJob = evaluationJob;
            return this;
        }

        private Builder(EvaluationJobName evaluationJobName) {
            this.project = evaluationJobName.project;
            this.evaluationJob = evaluationJobName.evaluationJob;
        }

        public EvaluationJobName build() {
            return new EvaluationJobName(this);
        }
    }
}

