/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1beta2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RegionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String region;

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private RegionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static RegionName of(String project, String region) {
        return RegionName.newBuilder().setProject(project).setRegion(region).build();
    }

    public static String format(String project, String region) {
        return RegionName.newBuilder().setProject(project).setRegion(region).build().toString();
    }

    public static RegionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "RegionName.parse: formattedString not in valid format");
        return RegionName.of((String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static List<RegionName> parseList(List<String> formattedStrings) {
        ArrayList<RegionName> list = new ArrayList<RegionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RegionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RegionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RegionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RegionName regionName = this;
            synchronized (regionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RegionName) {
            RegionName that = (RegionName)o;
            return this.project.equals(that.project) && this.region.equals(that.region);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.region.hashCode();
    }

    public static class Builder {
        private String project;
        private String region;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        private Builder(RegionName regionName) {
            this.project = regionName.project;
            this.region = regionName.region;
        }

        public RegionName build() {
            return new RegionName(this);
        }
    }
}

