/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/completion_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.CompleteQueryResponse}
 */
public final class CompleteQueryResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.CompleteQueryResponse)
    CompleteQueryResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CompleteQueryResponse.newBuilder() to construct.
  private CompleteQueryResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CompleteQueryResponse() {
    querySuggestions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CompleteQueryResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.CompletionServiceProto
        .internal_static_google_cloud_discoveryengine_v1_CompleteQueryResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.CompletionServiceProto
        .internal_static_google_cloud_discoveryengine_v1_CompleteQueryResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.CompleteQueryResponse.class,
            com.google.cloud.discoveryengine.v1.CompleteQueryResponse.Builder.class);
  }

  public interface QuerySuggestionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    java.lang.String getSuggestion();
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    com.google.protobuf.ByteString getSuggestionBytes();

    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @return A list containing the completableFieldPaths.
     */
    java.util.List<java.lang.String> getCompletableFieldPathsList();
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @return The count of completableFieldPaths.
     */
    int getCompletableFieldPathsCount();
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The completableFieldPaths at the given index.
     */
    java.lang.String getCompletableFieldPaths(int index);
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the completableFieldPaths at the given index.
     */
    com.google.protobuf.ByteString getCompletableFieldPathsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Suggestions as search queries.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion}
   */
  public static final class QuerySuggestion extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion)
      QuerySuggestionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QuerySuggestion.newBuilder() to construct.
    private QuerySuggestion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QuerySuggestion() {
      suggestion_ = "";
      completableFieldPaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QuerySuggestion();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CompleteQueryResponse_QuerySuggestion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CompleteQueryResponse_QuerySuggestion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.class,
              com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder
                  .class);
    }

    public static final int SUGGESTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object suggestion_ = "";
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    @java.lang.Override
    public java.lang.String getSuggestion() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suggestion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSuggestionBytes() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        suggestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COMPLETABLE_FIELD_PATHS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList completableFieldPaths_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @return A list containing the completableFieldPaths.
     */
    public com.google.protobuf.ProtocolStringList getCompletableFieldPathsList() {
      return completableFieldPaths_;
    }
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @return The count of completableFieldPaths.
     */
    public int getCompletableFieldPathsCount() {
      return completableFieldPaths_.size();
    }
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The completableFieldPaths at the given index.
     */
    public java.lang.String getCompletableFieldPaths(int index) {
      return completableFieldPaths_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the completableFieldPaths at the given index.
     */
    public com.google.protobuf.ByteString getCompletableFieldPathsBytes(int index) {
      return completableFieldPaths_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, suggestion_);
      }
      for (int i = 0; i < completableFieldPaths_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 2, completableFieldPaths_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, suggestion_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < completableFieldPaths_.size(); i++) {
          dataSize += computeStringSizeNoTag(completableFieldPaths_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getCompletableFieldPathsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion other =
          (com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion) obj;

      if (!getSuggestion().equals(other.getSuggestion())) return false;
      if (!getCompletableFieldPathsList().equals(other.getCompletableFieldPathsList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUGGESTION_FIELD_NUMBER;
      hash = (53 * hash) + getSuggestion().hashCode();
      if (getCompletableFieldPathsCount() > 0) {
        hash = (37 * hash) + COMPLETABLE_FIELD_PATHS_FIELD_NUMBER;
        hash = (53 * hash) + getCompletableFieldPathsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Suggestions as search queries.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion)
        com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1_CompleteQueryResponse_QuerySuggestion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1_CompleteQueryResponse_QuerySuggestion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.class,
                com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        suggestion_ = "";
        completableFieldPaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1_CompleteQueryResponse_QuerySuggestion_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion build() {
        com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
          buildPartial() {
        com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion result =
            new com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.suggestion_ = suggestion_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          completableFieldPaths_.makeImmutable();
          result.completableFieldPaths_ = completableFieldPaths_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion other) {
        if (other
            == com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
                .getDefaultInstance()) return this;
        if (!other.getSuggestion().isEmpty()) {
          suggestion_ = other.suggestion_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.completableFieldPaths_.isEmpty()) {
          if (completableFieldPaths_.isEmpty()) {
            completableFieldPaths_ = other.completableFieldPaths_;
            bitField0_ |= 0x00000002;
          } else {
            ensureCompletableFieldPathsIsMutable();
            completableFieldPaths_.addAll(other.completableFieldPaths_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  suggestion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureCompletableFieldPathsIsMutable();
                  completableFieldPaths_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object suggestion_ = "";
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The suggestion.
       */
      public java.lang.String getSuggestion() {
        java.lang.Object ref = suggestion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          suggestion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The bytes for suggestion.
       */
      public com.google.protobuf.ByteString getSuggestionBytes() {
        java.lang.Object ref = suggestion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          suggestion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuggestion() {
        suggestion_ = getDefaultInstance().getSuggestion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The bytes for suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList completableFieldPaths_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureCompletableFieldPathsIsMutable() {
        if (!completableFieldPaths_.isModifiable()) {
          completableFieldPaths_ =
              new com.google.protobuf.LazyStringArrayList(completableFieldPaths_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @return A list containing the completableFieldPaths.
       */
      public com.google.protobuf.ProtocolStringList getCompletableFieldPathsList() {
        completableFieldPaths_.makeImmutable();
        return completableFieldPaths_;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @return The count of completableFieldPaths.
       */
      public int getCompletableFieldPathsCount() {
        return completableFieldPaths_.size();
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The completableFieldPaths at the given index.
       */
      public java.lang.String getCompletableFieldPaths(int index) {
        return completableFieldPaths_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the completableFieldPaths at the given index.
       */
      public com.google.protobuf.ByteString getCompletableFieldPathsBytes(int index) {
        return completableFieldPaths_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The completableFieldPaths to set.
       * @return This builder for chaining.
       */
      public Builder setCompletableFieldPaths(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompletableFieldPathsIsMutable();
        completableFieldPaths_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param value The completableFieldPaths to add.
       * @return This builder for chaining.
       */
      public Builder addCompletableFieldPaths(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompletableFieldPathsIsMutable();
        completableFieldPaths_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param values The completableFieldPaths to add.
       * @return This builder for chaining.
       */
      public Builder addAllCompletableFieldPaths(java.lang.Iterable<java.lang.String> values) {
        ensureCompletableFieldPathsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, completableFieldPaths_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCompletableFieldPaths() {
        completableFieldPaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param value The bytes of the completableFieldPaths to add.
       * @return This builder for chaining.
       */
      public Builder addCompletableFieldPathsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureCompletableFieldPathsIsMutable();
        completableFieldPaths_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion)
    private static final com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion();
    }

    public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QuerySuggestion> PARSER =
        new com.google.protobuf.AbstractParser<QuerySuggestion>() {
          @java.lang.Override
          public QuerySuggestion parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QuerySuggestion> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QuerySuggestion> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int QUERY_SUGGESTIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion>
      querySuggestions_;
  /**
   *
   *
   * <pre>
   * Results of the matched query suggestions. The result list is ordered and
   * the first result is a top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion>
      getQuerySuggestionsList() {
    return querySuggestions_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matched query suggestions. The result list is ordered and
   * the first result is a top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestionOrBuilder>
      getQuerySuggestionsOrBuilderList() {
    return querySuggestions_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matched query suggestions. The result list is ordered and
   * the first result is a top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
   * </code>
   */
  @java.lang.Override
  public int getQuerySuggestionsCount() {
    return querySuggestions_.size();
  }
  /**
   *
   *
   * <pre>
   * Results of the matched query suggestions. The result list is ordered and
   * the first result is a top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
      getQuerySuggestions(int index) {
    return querySuggestions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Results of the matched query suggestions. The result list is ordered and
   * the first result is a top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestionOrBuilder
      getQuerySuggestionsOrBuilder(int index) {
    return querySuggestions_.get(index);
  }

  public static final int TAIL_MATCH_TRIGGERED_FIELD_NUMBER = 2;
  private boolean tailMatchTriggered_ = false;
  /**
   *
   *
   * <pre>
   * True if the returned suggestions are all tail suggestions.
   *
   * For tail matching to be triggered, include_tail_suggestions in the request
   * must be true and there must be no suggestions that match the full query.
   * </pre>
   *
   * <code>bool tail_match_triggered = 2;</code>
   *
   * @return The tailMatchTriggered.
   */
  @java.lang.Override
  public boolean getTailMatchTriggered() {
    return tailMatchTriggered_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < querySuggestions_.size(); i++) {
      output.writeMessage(1, querySuggestions_.get(i));
    }
    if (tailMatchTriggered_ != false) {
      output.writeBool(2, tailMatchTriggered_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < querySuggestions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, querySuggestions_.get(i));
    }
    if (tailMatchTriggered_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, tailMatchTriggered_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.CompleteQueryResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.CompleteQueryResponse other =
        (com.google.cloud.discoveryengine.v1.CompleteQueryResponse) obj;

    if (!getQuerySuggestionsList().equals(other.getQuerySuggestionsList())) return false;
    if (getTailMatchTriggered() != other.getTailMatchTriggered()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getQuerySuggestionsCount() > 0) {
      hash = (37 * hash) + QUERY_SUGGESTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getQuerySuggestionsList().hashCode();
    }
    hash = (37 * hash) + TAIL_MATCH_TRIGGERED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTailMatchTriggered());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.CompleteQueryResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.CompleteQueryResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.CompleteQueryResponse)
      com.google.cloud.discoveryengine.v1.CompleteQueryResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CompleteQueryResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CompleteQueryResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.CompleteQueryResponse.class,
              com.google.cloud.discoveryengine.v1.CompleteQueryResponse.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.CompleteQueryResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (querySuggestionsBuilder_ == null) {
        querySuggestions_ = java.util.Collections.emptyList();
      } else {
        querySuggestions_ = null;
        querySuggestionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      tailMatchTriggered_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CompleteQueryResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CompleteQueryResponse getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.CompleteQueryResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CompleteQueryResponse build() {
      com.google.cloud.discoveryengine.v1.CompleteQueryResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CompleteQueryResponse buildPartial() {
      com.google.cloud.discoveryengine.v1.CompleteQueryResponse result =
          new com.google.cloud.discoveryengine.v1.CompleteQueryResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1.CompleteQueryResponse result) {
      if (querySuggestionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          querySuggestions_ = java.util.Collections.unmodifiableList(querySuggestions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.querySuggestions_ = querySuggestions_;
      } else {
        result.querySuggestions_ = querySuggestionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.CompleteQueryResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.tailMatchTriggered_ = tailMatchTriggered_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.CompleteQueryResponse) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.CompleteQueryResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.CompleteQueryResponse other) {
      if (other == com.google.cloud.discoveryengine.v1.CompleteQueryResponse.getDefaultInstance())
        return this;
      if (querySuggestionsBuilder_ == null) {
        if (!other.querySuggestions_.isEmpty()) {
          if (querySuggestions_.isEmpty()) {
            querySuggestions_ = other.querySuggestions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureQuerySuggestionsIsMutable();
            querySuggestions_.addAll(other.querySuggestions_);
          }
          onChanged();
        }
      } else {
        if (!other.querySuggestions_.isEmpty()) {
          if (querySuggestionsBuilder_.isEmpty()) {
            querySuggestionsBuilder_.dispose();
            querySuggestionsBuilder_ = null;
            querySuggestions_ = other.querySuggestions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            querySuggestionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQuerySuggestionsFieldBuilder()
                    : null;
          } else {
            querySuggestionsBuilder_.addAllMessages(other.querySuggestions_);
          }
        }
      }
      if (other.getTailMatchTriggered() != false) {
        setTailMatchTriggered(other.getTailMatchTriggered());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
                            .parser(),
                        extensionRegistry);
                if (querySuggestionsBuilder_ == null) {
                  ensureQuerySuggestionsIsMutable();
                  querySuggestions_.add(m);
                } else {
                  querySuggestionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 16:
              {
                tailMatchTriggered_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion>
        querySuggestions_ = java.util.Collections.emptyList();

    private void ensureQuerySuggestionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        querySuggestions_ =
            new java.util.ArrayList<
                com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion>(
                querySuggestions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion,
            com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder,
            com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestionOrBuilder>
        querySuggestionsBuilder_;

    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion>
        getQuerySuggestionsList() {
      if (querySuggestionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(querySuggestions_);
      } else {
        return querySuggestionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public int getQuerySuggestionsCount() {
      if (querySuggestionsBuilder_ == null) {
        return querySuggestions_.size();
      } else {
        return querySuggestionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
        getQuerySuggestions(int index) {
      if (querySuggestionsBuilder_ == null) {
        return querySuggestions_.get(index);
      } else {
        return querySuggestionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder setQuerySuggestions(
        int index,
        com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion value) {
      if (querySuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.set(index, value);
        onChanged();
      } else {
        querySuggestionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder setQuerySuggestions(
        int index,
        com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder
            builderForValue) {
      if (querySuggestionsBuilder_ == null) {
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.set(index, builderForValue.build());
        onChanged();
      } else {
        querySuggestionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder addQuerySuggestions(
        com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion value) {
      if (querySuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.add(value);
        onChanged();
      } else {
        querySuggestionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder addQuerySuggestions(
        int index,
        com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion value) {
      if (querySuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.add(index, value);
        onChanged();
      } else {
        querySuggestionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder addQuerySuggestions(
        com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder
            builderForValue) {
      if (querySuggestionsBuilder_ == null) {
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.add(builderForValue.build());
        onChanged();
      } else {
        querySuggestionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder addQuerySuggestions(
        int index,
        com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder
            builderForValue) {
      if (querySuggestionsBuilder_ == null) {
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.add(index, builderForValue.build());
        onChanged();
      } else {
        querySuggestionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder addAllQuerySuggestions(
        java.lang.Iterable<
                ? extends com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion>
            values) {
      if (querySuggestionsBuilder_ == null) {
        ensureQuerySuggestionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, querySuggestions_);
        onChanged();
      } else {
        querySuggestionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder clearQuerySuggestions() {
      if (querySuggestionsBuilder_ == null) {
        querySuggestions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        querySuggestionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder removeQuerySuggestions(int index) {
      if (querySuggestionsBuilder_ == null) {
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.remove(index);
        onChanged();
      } else {
        querySuggestionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder
        getQuerySuggestionsBuilder(int index) {
      return getQuerySuggestionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestionOrBuilder
        getQuerySuggestionsOrBuilder(int index) {
      if (querySuggestionsBuilder_ == null) {
        return querySuggestions_.get(index);
      } else {
        return querySuggestionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestionOrBuilder>
        getQuerySuggestionsOrBuilderList() {
      if (querySuggestionsBuilder_ != null) {
        return querySuggestionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(querySuggestions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder
        addQuerySuggestionsBuilder() {
      return getQuerySuggestionsFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder
        addQuerySuggestionsBuilder(int index) {
      return getQuerySuggestionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder>
        getQuerySuggestionsBuilderList() {
      return getQuerySuggestionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion,
            com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder,
            com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestionOrBuilder>
        getQuerySuggestionsFieldBuilder() {
      if (querySuggestionsBuilder_ == null) {
        querySuggestionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion,
                com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.Builder,
                com.google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestionOrBuilder>(
                querySuggestions_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        querySuggestions_ = null;
      }
      return querySuggestionsBuilder_;
    }

    private boolean tailMatchTriggered_;
    /**
     *
     *
     * <pre>
     * True if the returned suggestions are all tail suggestions.
     *
     * For tail matching to be triggered, include_tail_suggestions in the request
     * must be true and there must be no suggestions that match the full query.
     * </pre>
     *
     * <code>bool tail_match_triggered = 2;</code>
     *
     * @return The tailMatchTriggered.
     */
    @java.lang.Override
    public boolean getTailMatchTriggered() {
      return tailMatchTriggered_;
    }
    /**
     *
     *
     * <pre>
     * True if the returned suggestions are all tail suggestions.
     *
     * For tail matching to be triggered, include_tail_suggestions in the request
     * must be true and there must be no suggestions that match the full query.
     * </pre>
     *
     * <code>bool tail_match_triggered = 2;</code>
     *
     * @param value The tailMatchTriggered to set.
     * @return This builder for chaining.
     */
    public Builder setTailMatchTriggered(boolean value) {

      tailMatchTriggered_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if the returned suggestions are all tail suggestions.
     *
     * For tail matching to be triggered, include_tail_suggestions in the request
     * must be true and there must be no suggestions that match the full query.
     * </pre>
     *
     * <code>bool tail_match_triggered = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTailMatchTriggered() {
      bitField0_ = (bitField0_ & ~0x00000002);
      tailMatchTriggered_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.CompleteQueryResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.CompleteQueryResponse)
  private static final com.google.cloud.discoveryengine.v1.CompleteQueryResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.CompleteQueryResponse();
  }

  public static com.google.cloud.discoveryengine.v1.CompleteQueryResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CompleteQueryResponse> PARSER =
      new com.google.protobuf.AbstractParser<CompleteQueryResponse>() {
        @java.lang.Override
        public CompleteQueryResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CompleteQueryResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CompleteQueryResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CompleteQueryResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
