/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/grounded_generation_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Top-level message sent by the client for the `GenerateGroundedContent`
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.GenerateGroundedContentRequest}
 */
public final class GenerateGroundedContentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest)
    GenerateGroundedContentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerateGroundedContentRequest.newBuilder() to construct.
  private GenerateGroundedContentRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateGroundedContentRequest() {
    location_ = "";
    contents_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateGroundedContentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
        .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
        .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.class,
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.Builder.class);
  }

  public interface GenerationSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specifies which Vertex model id to use for generation.
     * </pre>
     *
     * <code>string model_id = 3;</code>
     *
     * @return The modelId.
     */
    java.lang.String getModelId();
    /**
     *
     *
     * <pre>
     * Specifies which Vertex model id to use for generation.
     * </pre>
     *
     * <code>string model_id = 3;</code>
     *
     * @return The bytes for modelId.
     */
    com.google.protobuf.ByteString getModelIdBytes();

    /**
     *
     *
     * <pre>
     * Language code for content. Use language tags defined by
     * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The languageCode.
     */
    java.lang.String getLanguageCode();
    /**
     *
     *
     * <pre>
     * Language code for content. Use language tags defined by
     * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The bytes for languageCode.
     */
    com.google.protobuf.ByteString getLanguageCodeBytes();

    /**
     *
     *
     * <pre>
     * If specified, custom value for the temperature will be used.
     * </pre>
     *
     * <code>optional float temperature = 4;</code>
     *
     * @return Whether the temperature field is set.
     */
    boolean hasTemperature();
    /**
     *
     *
     * <pre>
     * If specified, custom value for the temperature will be used.
     * </pre>
     *
     * <code>optional float temperature = 4;</code>
     *
     * @return The temperature.
     */
    float getTemperature();

    /**
     *
     *
     * <pre>
     * If specified, custom value for nucleus sampling will be used.
     * </pre>
     *
     * <code>optional float top_p = 5;</code>
     *
     * @return Whether the topP field is set.
     */
    boolean hasTopP();
    /**
     *
     *
     * <pre>
     * If specified, custom value for nucleus sampling will be used.
     * </pre>
     *
     * <code>optional float top_p = 5;</code>
     *
     * @return The topP.
     */
    float getTopP();

    /**
     *
     *
     * <pre>
     * If specified, custom value for top-k sampling will be used.
     * </pre>
     *
     * <code>optional int32 top_k = 7;</code>
     *
     * @return Whether the topK field is set.
     */
    boolean hasTopK();
    /**
     *
     *
     * <pre>
     * If specified, custom value for top-k sampling will be used.
     * </pre>
     *
     * <code>optional int32 top_k = 7;</code>
     *
     * @return The topK.
     */
    int getTopK();

    /**
     *
     *
     * <pre>
     * If specified, custom value for frequency penalty will be used.
     * </pre>
     *
     * <code>optional float frequency_penalty = 8;</code>
     *
     * @return Whether the frequencyPenalty field is set.
     */
    boolean hasFrequencyPenalty();
    /**
     *
     *
     * <pre>
     * If specified, custom value for frequency penalty will be used.
     * </pre>
     *
     * <code>optional float frequency_penalty = 8;</code>
     *
     * @return The frequencyPenalty.
     */
    float getFrequencyPenalty();

    /**
     *
     *
     * <pre>
     * If specified, custom value for presence penalty will be used.
     * </pre>
     *
     * <code>optional float presence_penalty = 9;</code>
     *
     * @return Whether the presencePenalty field is set.
     */
    boolean hasPresencePenalty();
    /**
     *
     *
     * <pre>
     * If specified, custom value for presence penalty will be used.
     * </pre>
     *
     * <code>optional float presence_penalty = 9;</code>
     *
     * @return The presencePenalty.
     */
    float getPresencePenalty();

    /**
     *
     *
     * <pre>
     * If specified, custom value for max output tokens will be used.
     * </pre>
     *
     * <code>optional int32 max_output_tokens = 10;</code>
     *
     * @return Whether the maxOutputTokens field is set.
     */
    boolean hasMaxOutputTokens();
    /**
     *
     *
     * <pre>
     * If specified, custom value for max output tokens will be used.
     * </pre>
     *
     * <code>optional int32 max_output_tokens = 10;</code>
     *
     * @return The maxOutputTokens.
     */
    int getMaxOutputTokens();
  }
  /**
   *
   *
   * <pre>
   * Content generation specification.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec}
   */
  public static final class GenerationSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec)
      GenerationSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GenerationSpec.newBuilder() to construct.
    private GenerationSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GenerationSpec() {
      modelId_ = "";
      languageCode_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GenerationSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GenerationSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GenerationSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
                  .class,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
                  .Builder.class);
    }

    private int bitField0_;
    public static final int MODEL_ID_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelId_ = "";
    /**
     *
     *
     * <pre>
     * Specifies which Vertex model id to use for generation.
     * </pre>
     *
     * <code>string model_id = 3;</code>
     *
     * @return The modelId.
     */
    @java.lang.Override
    public java.lang.String getModelId() {
      java.lang.Object ref = modelId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies which Vertex model id to use for generation.
     * </pre>
     *
     * <code>string model_id = 3;</code>
     *
     * @return The bytes for modelId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelIdBytes() {
      java.lang.Object ref = modelId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LANGUAGE_CODE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Language code for content. Use language tags defined by
     * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The languageCode.
     */
    @java.lang.Override
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Language code for content. Use language tags defined by
     * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The bytes for languageCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TEMPERATURE_FIELD_NUMBER = 4;
    private float temperature_ = 0F;
    /**
     *
     *
     * <pre>
     * If specified, custom value for the temperature will be used.
     * </pre>
     *
     * <code>optional float temperature = 4;</code>
     *
     * @return Whether the temperature field is set.
     */
    @java.lang.Override
    public boolean hasTemperature() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * If specified, custom value for the temperature will be used.
     * </pre>
     *
     * <code>optional float temperature = 4;</code>
     *
     * @return The temperature.
     */
    @java.lang.Override
    public float getTemperature() {
      return temperature_;
    }

    public static final int TOP_P_FIELD_NUMBER = 5;
    private float topP_ = 0F;
    /**
     *
     *
     * <pre>
     * If specified, custom value for nucleus sampling will be used.
     * </pre>
     *
     * <code>optional float top_p = 5;</code>
     *
     * @return Whether the topP field is set.
     */
    @java.lang.Override
    public boolean hasTopP() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * If specified, custom value for nucleus sampling will be used.
     * </pre>
     *
     * <code>optional float top_p = 5;</code>
     *
     * @return The topP.
     */
    @java.lang.Override
    public float getTopP() {
      return topP_;
    }

    public static final int TOP_K_FIELD_NUMBER = 7;
    private int topK_ = 0;
    /**
     *
     *
     * <pre>
     * If specified, custom value for top-k sampling will be used.
     * </pre>
     *
     * <code>optional int32 top_k = 7;</code>
     *
     * @return Whether the topK field is set.
     */
    @java.lang.Override
    public boolean hasTopK() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * If specified, custom value for top-k sampling will be used.
     * </pre>
     *
     * <code>optional int32 top_k = 7;</code>
     *
     * @return The topK.
     */
    @java.lang.Override
    public int getTopK() {
      return topK_;
    }

    public static final int FREQUENCY_PENALTY_FIELD_NUMBER = 8;
    private float frequencyPenalty_ = 0F;
    /**
     *
     *
     * <pre>
     * If specified, custom value for frequency penalty will be used.
     * </pre>
     *
     * <code>optional float frequency_penalty = 8;</code>
     *
     * @return Whether the frequencyPenalty field is set.
     */
    @java.lang.Override
    public boolean hasFrequencyPenalty() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * If specified, custom value for frequency penalty will be used.
     * </pre>
     *
     * <code>optional float frequency_penalty = 8;</code>
     *
     * @return The frequencyPenalty.
     */
    @java.lang.Override
    public float getFrequencyPenalty() {
      return frequencyPenalty_;
    }

    public static final int PRESENCE_PENALTY_FIELD_NUMBER = 9;
    private float presencePenalty_ = 0F;
    /**
     *
     *
     * <pre>
     * If specified, custom value for presence penalty will be used.
     * </pre>
     *
     * <code>optional float presence_penalty = 9;</code>
     *
     * @return Whether the presencePenalty field is set.
     */
    @java.lang.Override
    public boolean hasPresencePenalty() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * If specified, custom value for presence penalty will be used.
     * </pre>
     *
     * <code>optional float presence_penalty = 9;</code>
     *
     * @return The presencePenalty.
     */
    @java.lang.Override
    public float getPresencePenalty() {
      return presencePenalty_;
    }

    public static final int MAX_OUTPUT_TOKENS_FIELD_NUMBER = 10;
    private int maxOutputTokens_ = 0;
    /**
     *
     *
     * <pre>
     * If specified, custom value for max output tokens will be used.
     * </pre>
     *
     * <code>optional int32 max_output_tokens = 10;</code>
     *
     * @return Whether the maxOutputTokens field is set.
     */
    @java.lang.Override
    public boolean hasMaxOutputTokens() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * If specified, custom value for max output tokens will be used.
     * </pre>
     *
     * <code>optional int32 max_output_tokens = 10;</code>
     *
     * @return The maxOutputTokens.
     */
    @java.lang.Override
    public int getMaxOutputTokens() {
      return maxOutputTokens_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, languageCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, modelId_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeFloat(4, temperature_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeFloat(5, topP_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeInt32(7, topK_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeFloat(8, frequencyPenalty_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeFloat(9, presencePenalty_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeInt32(10, maxOutputTokens_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, languageCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, modelId_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, temperature_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, topP_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, topK_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(8, frequencyPenalty_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(9, presencePenalty_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(10, maxOutputTokens_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec other =
          (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec) obj;

      if (!getModelId().equals(other.getModelId())) return false;
      if (!getLanguageCode().equals(other.getLanguageCode())) return false;
      if (hasTemperature() != other.hasTemperature()) return false;
      if (hasTemperature()) {
        if (java.lang.Float.floatToIntBits(getTemperature())
            != java.lang.Float.floatToIntBits(other.getTemperature())) return false;
      }
      if (hasTopP() != other.hasTopP()) return false;
      if (hasTopP()) {
        if (java.lang.Float.floatToIntBits(getTopP())
            != java.lang.Float.floatToIntBits(other.getTopP())) return false;
      }
      if (hasTopK() != other.hasTopK()) return false;
      if (hasTopK()) {
        if (getTopK() != other.getTopK()) return false;
      }
      if (hasFrequencyPenalty() != other.hasFrequencyPenalty()) return false;
      if (hasFrequencyPenalty()) {
        if (java.lang.Float.floatToIntBits(getFrequencyPenalty())
            != java.lang.Float.floatToIntBits(other.getFrequencyPenalty())) return false;
      }
      if (hasPresencePenalty() != other.hasPresencePenalty()) return false;
      if (hasPresencePenalty()) {
        if (java.lang.Float.floatToIntBits(getPresencePenalty())
            != java.lang.Float.floatToIntBits(other.getPresencePenalty())) return false;
      }
      if (hasMaxOutputTokens() != other.hasMaxOutputTokens()) return false;
      if (hasMaxOutputTokens()) {
        if (getMaxOutputTokens() != other.getMaxOutputTokens()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODEL_ID_FIELD_NUMBER;
      hash = (53 * hash) + getModelId().hashCode();
      hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getLanguageCode().hashCode();
      if (hasTemperature()) {
        hash = (37 * hash) + TEMPERATURE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getTemperature());
      }
      if (hasTopP()) {
        hash = (37 * hash) + TOP_P_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getTopP());
      }
      if (hasTopK()) {
        hash = (37 * hash) + TOP_K_FIELD_NUMBER;
        hash = (53 * hash) + getTopK();
      }
      if (hasFrequencyPenalty()) {
        hash = (37 * hash) + FREQUENCY_PENALTY_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getFrequencyPenalty());
      }
      if (hasPresencePenalty()) {
        hash = (37 * hash) + PRESENCE_PENALTY_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getPresencePenalty());
      }
      if (hasMaxOutputTokens()) {
        hash = (37 * hash) + MAX_OUTPUT_TOKENS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxOutputTokens();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Content generation specification.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec)
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GenerationSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GenerationSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
                    .class,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        modelId_ = "";
        languageCode_ = "";
        temperature_ = 0F;
        topP_ = 0F;
        topK_ = 0;
        frequencyPenalty_ = 0F;
        presencePenalty_ = 0F;
        maxOutputTokens_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GenerationSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
          build() {
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
          buildPartial() {
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec result =
            new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.modelId_ = modelId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.languageCode_ = languageCode_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.temperature_ = temperature_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.topP_ = topP_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.topK_ = topK_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.frequencyPenalty_ = frequencyPenalty_;
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.presencePenalty_ = presencePenalty_;
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.maxOutputTokens_ = maxOutputTokens_;
          to_bitField0_ |= 0x00000020;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
                .getDefaultInstance()) return this;
        if (!other.getModelId().isEmpty()) {
          modelId_ = other.modelId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getLanguageCode().isEmpty()) {
          languageCode_ = other.languageCode_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasTemperature()) {
          setTemperature(other.getTemperature());
        }
        if (other.hasTopP()) {
          setTopP(other.getTopP());
        }
        if (other.hasTopK()) {
          setTopK(other.getTopK());
        }
        if (other.hasFrequencyPenalty()) {
          setFrequencyPenalty(other.getFrequencyPenalty());
        }
        if (other.hasPresencePenalty()) {
          setPresencePenalty(other.getPresencePenalty());
        }
        if (other.hasMaxOutputTokens()) {
          setMaxOutputTokens(other.getMaxOutputTokens());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  languageCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  modelId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 26
              case 37:
                {
                  temperature_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 37
              case 45:
                {
                  topP_ = input.readFloat();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 45
              case 56:
                {
                  topK_ = input.readInt32();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 56
              case 69:
                {
                  frequencyPenalty_ = input.readFloat();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 69
              case 77:
                {
                  presencePenalty_ = input.readFloat();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 77
              case 80:
                {
                  maxOutputTokens_ = input.readInt32();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 80
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object modelId_ = "";
      /**
       *
       *
       * <pre>
       * Specifies which Vertex model id to use for generation.
       * </pre>
       *
       * <code>string model_id = 3;</code>
       *
       * @return The modelId.
       */
      public java.lang.String getModelId() {
        java.lang.Object ref = modelId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies which Vertex model id to use for generation.
       * </pre>
       *
       * <code>string model_id = 3;</code>
       *
       * @return The bytes for modelId.
       */
      public com.google.protobuf.ByteString getModelIdBytes() {
        java.lang.Object ref = modelId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies which Vertex model id to use for generation.
       * </pre>
       *
       * <code>string model_id = 3;</code>
       *
       * @param value The modelId to set.
       * @return This builder for chaining.
       */
      public Builder setModelId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies which Vertex model id to use for generation.
       * </pre>
       *
       * <code>string model_id = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelId() {
        modelId_ = getDefaultInstance().getModelId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies which Vertex model id to use for generation.
       * </pre>
       *
       * <code>string model_id = 3;</code>
       *
       * @param value The bytes for modelId to set.
       * @return This builder for chaining.
       */
      public Builder setModelIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object languageCode_ = "";
      /**
       *
       *
       * <pre>
       * Language code for content. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @return The languageCode.
       */
      public java.lang.String getLanguageCode() {
        java.lang.Object ref = languageCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          languageCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Language code for content. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @return The bytes for languageCode.
       */
      public com.google.protobuf.ByteString getLanguageCodeBytes() {
        java.lang.Object ref = languageCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          languageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Language code for content. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @param value The languageCode to set.
       * @return This builder for chaining.
       */
      public Builder setLanguageCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        languageCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Language code for content. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLanguageCode() {
        languageCode_ = getDefaultInstance().getLanguageCode();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Language code for content. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @param value The bytes for languageCode to set.
       * @return This builder for chaining.
       */
      public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        languageCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private float temperature_;
      /**
       *
       *
       * <pre>
       * If specified, custom value for the temperature will be used.
       * </pre>
       *
       * <code>optional float temperature = 4;</code>
       *
       * @return Whether the temperature field is set.
       */
      @java.lang.Override
      public boolean hasTemperature() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for the temperature will be used.
       * </pre>
       *
       * <code>optional float temperature = 4;</code>
       *
       * @return The temperature.
       */
      @java.lang.Override
      public float getTemperature() {
        return temperature_;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for the temperature will be used.
       * </pre>
       *
       * <code>optional float temperature = 4;</code>
       *
       * @param value The temperature to set.
       * @return This builder for chaining.
       */
      public Builder setTemperature(float value) {

        temperature_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for the temperature will be used.
       * </pre>
       *
       * <code>optional float temperature = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTemperature() {
        bitField0_ = (bitField0_ & ~0x00000004);
        temperature_ = 0F;
        onChanged();
        return this;
      }

      private float topP_;
      /**
       *
       *
       * <pre>
       * If specified, custom value for nucleus sampling will be used.
       * </pre>
       *
       * <code>optional float top_p = 5;</code>
       *
       * @return Whether the topP field is set.
       */
      @java.lang.Override
      public boolean hasTopP() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for nucleus sampling will be used.
       * </pre>
       *
       * <code>optional float top_p = 5;</code>
       *
       * @return The topP.
       */
      @java.lang.Override
      public float getTopP() {
        return topP_;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for nucleus sampling will be used.
       * </pre>
       *
       * <code>optional float top_p = 5;</code>
       *
       * @param value The topP to set.
       * @return This builder for chaining.
       */
      public Builder setTopP(float value) {

        topP_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for nucleus sampling will be used.
       * </pre>
       *
       * <code>optional float top_p = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopP() {
        bitField0_ = (bitField0_ & ~0x00000008);
        topP_ = 0F;
        onChanged();
        return this;
      }

      private int topK_;
      /**
       *
       *
       * <pre>
       * If specified, custom value for top-k sampling will be used.
       * </pre>
       *
       * <code>optional int32 top_k = 7;</code>
       *
       * @return Whether the topK field is set.
       */
      @java.lang.Override
      public boolean hasTopK() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for top-k sampling will be used.
       * </pre>
       *
       * <code>optional int32 top_k = 7;</code>
       *
       * @return The topK.
       */
      @java.lang.Override
      public int getTopK() {
        return topK_;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for top-k sampling will be used.
       * </pre>
       *
       * <code>optional int32 top_k = 7;</code>
       *
       * @param value The topK to set.
       * @return This builder for chaining.
       */
      public Builder setTopK(int value) {

        topK_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for top-k sampling will be used.
       * </pre>
       *
       * <code>optional int32 top_k = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopK() {
        bitField0_ = (bitField0_ & ~0x00000010);
        topK_ = 0;
        onChanged();
        return this;
      }

      private float frequencyPenalty_;
      /**
       *
       *
       * <pre>
       * If specified, custom value for frequency penalty will be used.
       * </pre>
       *
       * <code>optional float frequency_penalty = 8;</code>
       *
       * @return Whether the frequencyPenalty field is set.
       */
      @java.lang.Override
      public boolean hasFrequencyPenalty() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for frequency penalty will be used.
       * </pre>
       *
       * <code>optional float frequency_penalty = 8;</code>
       *
       * @return The frequencyPenalty.
       */
      @java.lang.Override
      public float getFrequencyPenalty() {
        return frequencyPenalty_;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for frequency penalty will be used.
       * </pre>
       *
       * <code>optional float frequency_penalty = 8;</code>
       *
       * @param value The frequencyPenalty to set.
       * @return This builder for chaining.
       */
      public Builder setFrequencyPenalty(float value) {

        frequencyPenalty_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for frequency penalty will be used.
       * </pre>
       *
       * <code>optional float frequency_penalty = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFrequencyPenalty() {
        bitField0_ = (bitField0_ & ~0x00000020);
        frequencyPenalty_ = 0F;
        onChanged();
        return this;
      }

      private float presencePenalty_;
      /**
       *
       *
       * <pre>
       * If specified, custom value for presence penalty will be used.
       * </pre>
       *
       * <code>optional float presence_penalty = 9;</code>
       *
       * @return Whether the presencePenalty field is set.
       */
      @java.lang.Override
      public boolean hasPresencePenalty() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for presence penalty will be used.
       * </pre>
       *
       * <code>optional float presence_penalty = 9;</code>
       *
       * @return The presencePenalty.
       */
      @java.lang.Override
      public float getPresencePenalty() {
        return presencePenalty_;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for presence penalty will be used.
       * </pre>
       *
       * <code>optional float presence_penalty = 9;</code>
       *
       * @param value The presencePenalty to set.
       * @return This builder for chaining.
       */
      public Builder setPresencePenalty(float value) {

        presencePenalty_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for presence penalty will be used.
       * </pre>
       *
       * <code>optional float presence_penalty = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPresencePenalty() {
        bitField0_ = (bitField0_ & ~0x00000040);
        presencePenalty_ = 0F;
        onChanged();
        return this;
      }

      private int maxOutputTokens_;
      /**
       *
       *
       * <pre>
       * If specified, custom value for max output tokens will be used.
       * </pre>
       *
       * <code>optional int32 max_output_tokens = 10;</code>
       *
       * @return Whether the maxOutputTokens field is set.
       */
      @java.lang.Override
      public boolean hasMaxOutputTokens() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for max output tokens will be used.
       * </pre>
       *
       * <code>optional int32 max_output_tokens = 10;</code>
       *
       * @return The maxOutputTokens.
       */
      @java.lang.Override
      public int getMaxOutputTokens() {
        return maxOutputTokens_;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for max output tokens will be used.
       * </pre>
       *
       * <code>optional int32 max_output_tokens = 10;</code>
       *
       * @param value The maxOutputTokens to set.
       * @return This builder for chaining.
       */
      public Builder setMaxOutputTokens(int value) {

        maxOutputTokens_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, custom value for max output tokens will be used.
       * </pre>
       *
       * <code>optional int32 max_output_tokens = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxOutputTokens() {
        bitField0_ = (bitField0_ & ~0x00000080);
        maxOutputTokens_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec)
    private static final com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .GenerationSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec();
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GenerationSpec> PARSER =
        new com.google.protobuf.AbstractParser<GenerationSpec>() {
          @java.lang.Override
          public GenerationSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GenerationSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GenerationSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DynamicRetrievalConfigurationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specification for the predictor for dynamic retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
     * </code>
     *
     * @return Whether the predictor field is set.
     */
    boolean hasPredictor();
    /**
     *
     *
     * <pre>
     * Specification for the predictor for dynamic retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
     * </code>
     *
     * @return The predictor.
     */
    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration
            .DynamicRetrievalPredictor
        getPredictor();
    /**
     *
     *
     * <pre>
     * Specification for the predictor for dynamic retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration
            .DynamicRetrievalPredictorOrBuilder
        getPredictorOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Describes the options to customize dynamic retrieval.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration}
   */
  public static final class DynamicRetrievalConfiguration
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration)
      DynamicRetrievalConfigurationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DynamicRetrievalConfiguration.newBuilder() to construct.
    private DynamicRetrievalConfiguration(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DynamicRetrievalConfiguration() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DynamicRetrievalConfiguration();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_DynamicRetrievalConfiguration_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_DynamicRetrievalConfiguration_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.class,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.Builder.class);
    }

    public interface DynamicRetrievalPredictorOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The version of the predictor to be used in dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version version = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for version.
       */
      int getVersionValue();
      /**
       *
       *
       * <pre>
       * The version of the predictor to be used in dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version version = 1;
       * </code>
       *
       * @return The version.
       */
      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version
          getVersion();

      /**
       *
       *
       * <pre>
       * The value of the threshold. If the predictor will predict a
       * value smaller than this, it would suppress grounding in the source.
       * </pre>
       *
       * <code>optional float threshold = 2;</code>
       *
       * @return Whether the threshold field is set.
       */
      boolean hasThreshold();
      /**
       *
       *
       * <pre>
       * The value of the threshold. If the predictor will predict a
       * value smaller than this, it would suppress grounding in the source.
       * </pre>
       *
       * <code>optional float threshold = 2;</code>
       *
       * @return The threshold.
       */
      float getThreshold();
    }
    /**
     *
     *
     * <pre>
     * Describes the predictor settings for dynamic retrieval.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor}
     */
    public static final class DynamicRetrievalPredictor
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor)
        DynamicRetrievalPredictorOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DynamicRetrievalPredictor.newBuilder() to construct.
      private DynamicRetrievalPredictor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DynamicRetrievalPredictor() {
        version_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DynamicRetrievalPredictor();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.class,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * The version of the predictor to be used in dynamic retrieval.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version}
       */
      public enum Version implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Automatically choose the best version of the retrieval predictor.
         * </pre>
         *
         * <code>VERSION_UNSPECIFIED = 0;</code>
         */
        VERSION_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * The V1 model which is evaluating each source independently.
         * </pre>
         *
         * <code>V1_INDEPENDENT = 1;</code>
         */
        V1_INDEPENDENT(1),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Automatically choose the best version of the retrieval predictor.
         * </pre>
         *
         * <code>VERSION_UNSPECIFIED = 0;</code>
         */
        public static final int VERSION_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * The V1 model which is evaluating each source independently.
         * </pre>
         *
         * <code>V1_INDEPENDENT = 1;</code>
         */
        public static final int V1_INDEPENDENT_VALUE = 1;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Version valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Version forNumber(int value) {
          switch (value) {
            case 0:
              return VERSION_UNSPECIFIED;
            case 1:
              return V1_INDEPENDENT;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Version> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<Version> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Version>() {
              public Version findValueByNumber(int number) {
                return Version.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final Version[] VALUES = values();

        public static Version valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Version(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version)
      }

      private int bitField0_;
      public static final int VERSION_FIELD_NUMBER = 1;
      private int version_ = 0;
      /**
       *
       *
       * <pre>
       * The version of the predictor to be used in dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version version = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for version.
       */
      @java.lang.Override
      public int getVersionValue() {
        return version_;
      }
      /**
       *
       *
       * <pre>
       * The version of the predictor to be used in dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version version = 1;
       * </code>
       *
       * @return The version.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version
          getVersion() {
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version
            result =
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version.forNumber(
                    version_);
        return result == null
            ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version.UNRECOGNIZED
            : result;
      }

      public static final int THRESHOLD_FIELD_NUMBER = 2;
      private float threshold_ = 0F;
      /**
       *
       *
       * <pre>
       * The value of the threshold. If the predictor will predict a
       * value smaller than this, it would suppress grounding in the source.
       * </pre>
       *
       * <code>optional float threshold = 2;</code>
       *
       * @return Whether the threshold field is set.
       */
      @java.lang.Override
      public boolean hasThreshold() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The value of the threshold. If the predictor will predict a
       * value smaller than this, it would suppress grounding in the source.
       * </pre>
       *
       * <code>optional float threshold = 2;</code>
       *
       * @return The threshold.
       */
      @java.lang.Override
      public float getThreshold() {
        return threshold_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (version_
            != com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version.VERSION_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, version_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeFloat(2, threshold_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (version_
            != com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version.VERSION_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, version_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, threshold_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.DynamicRetrievalPredictor)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
            other =
                (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                        .DynamicRetrievalConfiguration.DynamicRetrievalPredictor)
                    obj;

        if (version_ != other.version_) return false;
        if (hasThreshold() != other.hasThreshold()) return false;
        if (hasThreshold()) {
          if (java.lang.Float.floatToIntBits(getThreshold())
              != java.lang.Float.floatToIntBits(other.getThreshold())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + VERSION_FIELD_NUMBER;
        hash = (53 * hash) + version_;
        if (hasThreshold()) {
          hash = (37 * hash) + THRESHOLD_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getThreshold());
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Describes the predictor settings for dynamic retrieval.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor)
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictorOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.class,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          version_ = 0;
          threshold_ = 0F;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_DynamicRetrievalConfiguration_DynamicRetrievalPredictor_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
            build() {
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
            buildPartial() {
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
              result =
                  new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .DynamicRetrievalConfiguration.DynamicRetrievalPredictor(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.version_ = version_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.threshold_ = threshold_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                        .DynamicRetrievalConfiguration.DynamicRetrievalPredictor)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.getDefaultInstance())
            return this;
          if (other.version_ != 0) {
            setVersionValue(other.getVersionValue());
          }
          if (other.hasThreshold()) {
            setThreshold(other.getThreshold());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    version_ = input.readEnum();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 21:
                  {
                    threshold_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int version_ = 0;
        /**
         *
         *
         * <pre>
         * The version of the predictor to be used in dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version version = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for version.
         */
        @java.lang.Override
        public int getVersionValue() {
          return version_;
        }
        /**
         *
         *
         * <pre>
         * The version of the predictor to be used in dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version version = 1;
         * </code>
         *
         * @param value The enum numeric value on the wire for version to set.
         * @return This builder for chaining.
         */
        public Builder setVersionValue(int value) {
          version_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The version of the predictor to be used in dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version version = 1;
         * </code>
         *
         * @return The version.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version
            getVersion() {
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version
              result =
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version.forNumber(
                      version_);
          return result == null
              ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * The version of the predictor to be used in dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version version = 1;
         * </code>
         *
         * @param value The version to set.
         * @return This builder for chaining.
         */
        public Builder setVersion(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          version_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The version of the predictor to be used in dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Version version = 1;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearVersion() {
          bitField0_ = (bitField0_ & ~0x00000001);
          version_ = 0;
          onChanged();
          return this;
        }

        private float threshold_;
        /**
         *
         *
         * <pre>
         * The value of the threshold. If the predictor will predict a
         * value smaller than this, it would suppress grounding in the source.
         * </pre>
         *
         * <code>optional float threshold = 2;</code>
         *
         * @return Whether the threshold field is set.
         */
        @java.lang.Override
        public boolean hasThreshold() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * The value of the threshold. If the predictor will predict a
         * value smaller than this, it would suppress grounding in the source.
         * </pre>
         *
         * <code>optional float threshold = 2;</code>
         *
         * @return The threshold.
         */
        @java.lang.Override
        public float getThreshold() {
          return threshold_;
        }
        /**
         *
         *
         * <pre>
         * The value of the threshold. If the predictor will predict a
         * value smaller than this, it would suppress grounding in the source.
         * </pre>
         *
         * <code>optional float threshold = 2;</code>
         *
         * @param value The threshold to set.
         * @return This builder for chaining.
         */
        public Builder setThreshold(float value) {

          threshold_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The value of the threshold. If the predictor will predict a
         * value smaller than this, it would suppress grounding in the source.
         * </pre>
         *
         * <code>optional float threshold = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearThreshold() {
          bitField0_ = (bitField0_ & ~0x00000002);
          threshold_ = 0F;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor)
      private static final com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.DynamicRetrievalPredictor();
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DynamicRetrievalPredictor> PARSER =
          new com.google.protobuf.AbstractParser<DynamicRetrievalPredictor>() {
            @java.lang.Override
            public DynamicRetrievalPredictor parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DynamicRetrievalPredictor> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DynamicRetrievalPredictor> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int PREDICTOR_FIELD_NUMBER = 1;
    private com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
        predictor_;
    /**
     *
     *
     * <pre>
     * Specification for the predictor for dynamic retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
     * </code>
     *
     * @return Whether the predictor field is set.
     */
    @java.lang.Override
    public boolean hasPredictor() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specification for the predictor for dynamic retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
     * </code>
     *
     * @return The predictor.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
        getPredictor() {
      return predictor_ == null
          ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.getDefaultInstance()
          : predictor_;
    }
    /**
     *
     *
     * <pre>
     * Specification for the predictor for dynamic retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration.DynamicRetrievalPredictorOrBuilder
        getPredictorOrBuilder() {
      return predictor_ == null
          ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.getDefaultInstance()
          : predictor_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getPredictor());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPredictor());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration
          other =
              (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .DynamicRetrievalConfiguration)
                  obj;

      if (hasPredictor() != other.hasPredictor()) return false;
      if (hasPredictor()) {
        if (!getPredictor().equals(other.getPredictor())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPredictor()) {
        hash = (37 * hash) + PREDICTOR_FIELD_NUMBER;
        hash = (53 * hash) + getPredictor().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes the options to customize dynamic retrieval.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration)
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfigurationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_DynamicRetrievalConfiguration_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_DynamicRetrievalConfiguration_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.class,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPredictorFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        predictor_ = null;
        if (predictorBuilder_ != null) {
          predictorBuilder_.dispose();
          predictorBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_DynamicRetrievalConfiguration_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration
          build() {
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration
          buildPartial() {
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration
            result =
                new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.predictor_ = predictorBuilder_ == null ? predictor_ : predictorBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .DynamicRetrievalConfiguration)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration
              other) {
        if (other
            == com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.getDefaultInstance()) return this;
        if (other.hasPredictor()) {
          mergePredictor(other.getPredictor());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getPredictorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          predictor_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Builder,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictorOrBuilder>
          predictorBuilder_;
      /**
       *
       *
       * <pre>
       * Specification for the predictor for dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
       * </code>
       *
       * @return Whether the predictor field is set.
       */
      public boolean hasPredictor() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Specification for the predictor for dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
       * </code>
       *
       * @return The predictor.
       */
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
          getPredictor() {
        if (predictorBuilder_ == null) {
          return predictor_ == null
              ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.getDefaultInstance()
              : predictor_;
        } else {
          return predictorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Specification for the predictor for dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
       * </code>
       */
      public Builder setPredictor(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
              value) {
        if (predictorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          predictor_ = value;
        } else {
          predictorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification for the predictor for dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
       * </code>
       */
      public Builder setPredictor(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Builder
              builderForValue) {
        if (predictorBuilder_ == null) {
          predictor_ = builderForValue.build();
        } else {
          predictorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification for the predictor for dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
       * </code>
       */
      public Builder mergePredictor(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
              value) {
        if (predictorBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && predictor_ != null
              && predictor_
                  != com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .DynamicRetrievalConfiguration.DynamicRetrievalPredictor
                      .getDefaultInstance()) {
            getPredictorBuilder().mergeFrom(value);
          } else {
            predictor_ = value;
          }
        } else {
          predictorBuilder_.mergeFrom(value);
        }
        if (predictor_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification for the predictor for dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
       * </code>
       */
      public Builder clearPredictor() {
        bitField0_ = (bitField0_ & ~0x00000001);
        predictor_ = null;
        if (predictorBuilder_ != null) {
          predictorBuilder_.dispose();
          predictorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification for the predictor for dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Builder
          getPredictorBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPredictorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Specification for the predictor for dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration.DynamicRetrievalPredictorOrBuilder
          getPredictorOrBuilder() {
        if (predictorBuilder_ != null) {
          return predictorBuilder_.getMessageOrBuilder();
        } else {
          return predictor_ == null
              ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.getDefaultInstance()
              : predictor_;
        }
      }
      /**
       *
       *
       * <pre>
       * Specification for the predictor for dynamic retrieval.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration.DynamicRetrievalPredictor predictor = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Builder,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .DynamicRetrievalConfiguration.DynamicRetrievalPredictorOrBuilder>
          getPredictorFieldBuilder() {
        if (predictorBuilder_ == null) {
          predictorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .DynamicRetrievalConfiguration.DynamicRetrievalPredictor,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .DynamicRetrievalConfiguration.DynamicRetrievalPredictor.Builder,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .DynamicRetrievalConfiguration.DynamicRetrievalPredictorOrBuilder>(
                  getPredictor(), getParentForChildren(), isClean());
          predictor_ = null;
        }
        return predictorBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration)
    private static final com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration();
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DynamicRetrievalConfiguration> PARSER =
        new com.google.protobuf.AbstractParser<DynamicRetrievalConfiguration>() {
          @java.lang.Override
          public DynamicRetrievalConfiguration parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DynamicRetrievalConfiguration> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DynamicRetrievalConfiguration> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .DynamicRetrievalConfiguration
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GroundingSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If set, grounding is performed with inline content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
     * </code>
     *
     * @return Whether the inlineSource field is set.
     */
    boolean hasInlineSource();
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with inline content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
     * </code>
     *
     * @return The inlineSource.
     */
    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource
        getInlineSource();
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with inline content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            .InlineSourceOrBuilder
        getInlineSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
     * </code>
     *
     * @return Whether the searchSource field is set.
     */
    boolean hasSearchSource();
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
     * </code>
     *
     * @return The searchSource.
     */
    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource
        getSearchSource();
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            .SearchSourceOrBuilder
        getSearchSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Google Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
     * </code>
     *
     * @return Whether the googleSearchSource field is set.
     */
    boolean hasGoogleSearchSource();
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Google Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
     * </code>
     *
     * @return The googleSearchSource.
     */
    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            .GoogleSearchSource
        getGoogleSearchSource();
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Google Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            .GoogleSearchSourceOrBuilder
        getGoogleSearchSourceOrBuilder();

    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SourceCase
        getSourceCase();
  }
  /**
   *
   *
   * <pre>
   * Grounding source.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource}
   */
  public static final class GroundingSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource)
      GroundingSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GroundingSource.newBuilder() to construct.
    private GroundingSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GroundingSource() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GroundingSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .class,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .Builder.class);
    }

    public interface InlineSourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * List of facts to be used for grounding.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
       */
      java.util.List<com.google.cloud.discoveryengine.v1.GroundingFact> getGroundingFactsList();
      /**
       *
       *
       * <pre>
       * List of facts to be used for grounding.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
       */
      com.google.cloud.discoveryengine.v1.GroundingFact getGroundingFacts(int index);
      /**
       *
       *
       * <pre>
       * List of facts to be used for grounding.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
       */
      int getGroundingFactsCount();
      /**
       *
       *
       * <pre>
       * List of facts to be used for grounding.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
       */
      java.util.List<? extends com.google.cloud.discoveryengine.v1.GroundingFactOrBuilder>
          getGroundingFactsOrBuilderList();
      /**
       *
       *
       * <pre>
       * List of facts to be used for grounding.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
       */
      com.google.cloud.discoveryengine.v1.GroundingFactOrBuilder getGroundingFactsOrBuilder(
          int index);

      /**
       *
       *
       * <pre>
       * Attributes associated with the content.
       *
       * Common attributes include `source` (indicating where the content was
       * sourced from) and `author` (indicating the author of the content).
       * </pre>
       *
       * <code>map&lt;string, string&gt; attributes = 2;</code>
       */
      int getAttributesCount();
      /**
       *
       *
       * <pre>
       * Attributes associated with the content.
       *
       * Common attributes include `source` (indicating where the content was
       * sourced from) and `author` (indicating the author of the content).
       * </pre>
       *
       * <code>map&lt;string, string&gt; attributes = 2;</code>
       */
      boolean containsAttributes(java.lang.String key);
      /** Use {@link #getAttributesMap()} instead. */
      @java.lang.Deprecated
      java.util.Map<java.lang.String, java.lang.String> getAttributes();
      /**
       *
       *
       * <pre>
       * Attributes associated with the content.
       *
       * Common attributes include `source` (indicating where the content was
       * sourced from) and `author` (indicating the author of the content).
       * </pre>
       *
       * <code>map&lt;string, string&gt; attributes = 2;</code>
       */
      java.util.Map<java.lang.String, java.lang.String> getAttributesMap();
      /**
       *
       *
       * <pre>
       * Attributes associated with the content.
       *
       * Common attributes include `source` (indicating where the content was
       * sourced from) and `author` (indicating the author of the content).
       * </pre>
       *
       * <code>map&lt;string, string&gt; attributes = 2;</code>
       */
      /* nullable */
      java.lang.String getAttributesOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue);
      /**
       *
       *
       * <pre>
       * Attributes associated with the content.
       *
       * Common attributes include `source` (indicating where the content was
       * sourced from) and `author` (indicating the author of the content).
       * </pre>
       *
       * <code>map&lt;string, string&gt; attributes = 2;</code>
       */
      java.lang.String getAttributesOrThrow(java.lang.String key);
    }
    /**
     *
     *
     * <pre>
     * Message to be used for grounding based on inline content.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource}
     */
    public static final class InlineSource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource)
        InlineSourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use InlineSource.newBuilder() to construct.
      private InlineSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private InlineSource() {
        groundingFacts_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new InlineSource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_InlineSource_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      @java.lang.Override
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 2:
            return internalGetAttributes();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_InlineSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .InlineSource.class,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .InlineSource.Builder.class);
      }

      public static final int GROUNDING_FACTS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.discoveryengine.v1.GroundingFact> groundingFacts_;
      /**
       *
       *
       * <pre>
       * List of facts to be used for grounding.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.discoveryengine.v1.GroundingFact>
          getGroundingFactsList() {
        return groundingFacts_;
      }
      /**
       *
       *
       * <pre>
       * List of facts to be used for grounding.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.cloud.discoveryengine.v1.GroundingFactOrBuilder>
          getGroundingFactsOrBuilderList() {
        return groundingFacts_;
      }
      /**
       *
       *
       * <pre>
       * List of facts to be used for grounding.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
       */
      @java.lang.Override
      public int getGroundingFactsCount() {
        return groundingFacts_.size();
      }
      /**
       *
       *
       * <pre>
       * List of facts to be used for grounding.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GroundingFact getGroundingFacts(int index) {
        return groundingFacts_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of facts to be used for grounding.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GroundingFactOrBuilder getGroundingFactsOrBuilder(
          int index) {
        return groundingFacts_.get(index);
      }

      public static final int ATTRIBUTES_FIELD_NUMBER = 2;

      private static final class AttributesDefaultEntryHolder {
        static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
            com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
                com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
                    .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_InlineSource_AttributesEntry_descriptor,
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.STRING,
                "");
      }

      @SuppressWarnings("serial")
      private com.google.protobuf.MapField<java.lang.String, java.lang.String> attributes_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetAttributes() {
        if (attributes_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              AttributesDefaultEntryHolder.defaultEntry);
        }
        return attributes_;
      }

      public int getAttributesCount() {
        return internalGetAttributes().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Attributes associated with the content.
       *
       * Common attributes include `source` (indicating where the content was
       * sourced from) and `author` (indicating the author of the content).
       * </pre>
       *
       * <code>map&lt;string, string&gt; attributes = 2;</code>
       */
      @java.lang.Override
      public boolean containsAttributes(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetAttributes().getMap().containsKey(key);
      }
      /** Use {@link #getAttributesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
        return getAttributesMap();
      }
      /**
       *
       *
       * <pre>
       * Attributes associated with the content.
       *
       * Common attributes include `source` (indicating where the content was
       * sourced from) and `author` (indicating the author of the content).
       * </pre>
       *
       * <code>map&lt;string, string&gt; attributes = 2;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getAttributesMap() {
        return internalGetAttributes().getMap();
      }
      /**
       *
       *
       * <pre>
       * Attributes associated with the content.
       *
       * Common attributes include `source` (indicating where the content was
       * sourced from) and `author` (indicating the author of the content).
       * </pre>
       *
       * <code>map&lt;string, string&gt; attributes = 2;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getAttributesOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Attributes associated with the content.
       *
       * Common attributes include `source` (indicating where the content was
       * sourced from) and `author` (indicating the author of the content).
       * </pre>
       *
       * <code>map&lt;string, string&gt; attributes = 2;</code>
       */
      @java.lang.Override
      public java.lang.String getAttributesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < groundingFacts_.size(); i++) {
          output.writeMessage(1, groundingFacts_.get(i));
        }
        com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
            output, internalGetAttributes(), AttributesDefaultEntryHolder.defaultEntry, 2);
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < groundingFacts_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(1, groundingFacts_.get(i));
        }
        for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
            internalGetAttributes().getMap().entrySet()) {
          com.google.protobuf.MapEntry<java.lang.String, java.lang.String> attributes__ =
              AttributesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, attributes__);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .InlineSource)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .InlineSource
            other =
                (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                        .InlineSource)
                    obj;

        if (!getGroundingFactsList().equals(other.getGroundingFactsList())) return false;
        if (!internalGetAttributes().equals(other.internalGetAttributes())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getGroundingFactsCount() > 0) {
          hash = (37 * hash) + GROUNDING_FACTS_FIELD_NUMBER;
          hash = (53 * hash) + getGroundingFactsList().hashCode();
        }
        if (!internalGetAttributes().getMap().isEmpty()) {
          hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
          hash = (53 * hash) + internalGetAttributes().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Message to be used for grounding based on inline content.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource)
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .InlineSourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_InlineSource_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
            int number) {
          switch (number) {
            case 2:
              return internalGetAttributes();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapFieldReflectionAccessor
            internalGetMutableMapFieldReflection(int number) {
          switch (number) {
            case 2:
              return internalGetMutableAttributes();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_InlineSource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .InlineSource.class,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .InlineSource.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (groundingFactsBuilder_ == null) {
            groundingFacts_ = java.util.Collections.emptyList();
          } else {
            groundingFacts_ = null;
            groundingFactsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          internalGetMutableAttributes().clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_InlineSource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .InlineSource
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .InlineSource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .InlineSource
            build() {
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .InlineSource
            buildPartial() {
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource
              result =
                  new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .GroundingSource.InlineSource(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .InlineSource
                result) {
          if (groundingFactsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              groundingFacts_ = java.util.Collections.unmodifiableList(groundingFacts_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.groundingFacts_ = groundingFacts_;
          } else {
            result.groundingFacts_ = groundingFactsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .InlineSource
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.attributes_ = internalGetAttributes();
            result.attributes_.makeImmutable();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                        .InlineSource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .InlineSource
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource.getDefaultInstance()) return this;
          if (groundingFactsBuilder_ == null) {
            if (!other.groundingFacts_.isEmpty()) {
              if (groundingFacts_.isEmpty()) {
                groundingFacts_ = other.groundingFacts_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureGroundingFactsIsMutable();
                groundingFacts_.addAll(other.groundingFacts_);
              }
              onChanged();
            }
          } else {
            if (!other.groundingFacts_.isEmpty()) {
              if (groundingFactsBuilder_.isEmpty()) {
                groundingFactsBuilder_.dispose();
                groundingFactsBuilder_ = null;
                groundingFacts_ = other.groundingFacts_;
                bitField0_ = (bitField0_ & ~0x00000001);
                groundingFactsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getGroundingFactsFieldBuilder()
                        : null;
              } else {
                groundingFactsBuilder_.addAllMessages(other.groundingFacts_);
              }
            }
          }
          internalGetMutableAttributes().mergeFrom(other.internalGetAttributes());
          bitField0_ |= 0x00000002;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.discoveryengine.v1.GroundingFact m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1.GroundingFact.parser(),
                            extensionRegistry);
                    if (groundingFactsBuilder_ == null) {
                      ensureGroundingFactsIsMutable();
                      groundingFacts_.add(m);
                    } else {
                      groundingFactsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.protobuf.MapEntry<java.lang.String, java.lang.String> attributes__ =
                        input.readMessage(
                            AttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                    internalGetMutableAttributes()
                        .getMutableMap()
                        .put(attributes__.getKey(), attributes__.getValue());
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<com.google.cloud.discoveryengine.v1.GroundingFact> groundingFacts_ =
            java.util.Collections.emptyList();

        private void ensureGroundingFactsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            groundingFacts_ =
                new java.util.ArrayList<com.google.cloud.discoveryengine.v1.GroundingFact>(
                    groundingFacts_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.GroundingFact,
                com.google.cloud.discoveryengine.v1.GroundingFact.Builder,
                com.google.cloud.discoveryengine.v1.GroundingFactOrBuilder>
            groundingFactsBuilder_;

        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public java.util.List<com.google.cloud.discoveryengine.v1.GroundingFact>
            getGroundingFactsList() {
          if (groundingFactsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(groundingFacts_);
          } else {
            return groundingFactsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public int getGroundingFactsCount() {
          if (groundingFactsBuilder_ == null) {
            return groundingFacts_.size();
          } else {
            return groundingFactsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public com.google.cloud.discoveryengine.v1.GroundingFact getGroundingFacts(int index) {
          if (groundingFactsBuilder_ == null) {
            return groundingFacts_.get(index);
          } else {
            return groundingFactsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public Builder setGroundingFacts(
            int index, com.google.cloud.discoveryengine.v1.GroundingFact value) {
          if (groundingFactsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGroundingFactsIsMutable();
            groundingFacts_.set(index, value);
            onChanged();
          } else {
            groundingFactsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public Builder setGroundingFacts(
            int index, com.google.cloud.discoveryengine.v1.GroundingFact.Builder builderForValue) {
          if (groundingFactsBuilder_ == null) {
            ensureGroundingFactsIsMutable();
            groundingFacts_.set(index, builderForValue.build());
            onChanged();
          } else {
            groundingFactsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public Builder addGroundingFacts(com.google.cloud.discoveryengine.v1.GroundingFact value) {
          if (groundingFactsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGroundingFactsIsMutable();
            groundingFacts_.add(value);
            onChanged();
          } else {
            groundingFactsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public Builder addGroundingFacts(
            int index, com.google.cloud.discoveryengine.v1.GroundingFact value) {
          if (groundingFactsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGroundingFactsIsMutable();
            groundingFacts_.add(index, value);
            onChanged();
          } else {
            groundingFactsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public Builder addGroundingFacts(
            com.google.cloud.discoveryengine.v1.GroundingFact.Builder builderForValue) {
          if (groundingFactsBuilder_ == null) {
            ensureGroundingFactsIsMutable();
            groundingFacts_.add(builderForValue.build());
            onChanged();
          } else {
            groundingFactsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public Builder addGroundingFacts(
            int index, com.google.cloud.discoveryengine.v1.GroundingFact.Builder builderForValue) {
          if (groundingFactsBuilder_ == null) {
            ensureGroundingFactsIsMutable();
            groundingFacts_.add(index, builderForValue.build());
            onChanged();
          } else {
            groundingFactsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public Builder addAllGroundingFacts(
            java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.GroundingFact>
                values) {
          if (groundingFactsBuilder_ == null) {
            ensureGroundingFactsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groundingFacts_);
            onChanged();
          } else {
            groundingFactsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public Builder clearGroundingFacts() {
          if (groundingFactsBuilder_ == null) {
            groundingFacts_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            groundingFactsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public Builder removeGroundingFacts(int index) {
          if (groundingFactsBuilder_ == null) {
            ensureGroundingFactsIsMutable();
            groundingFacts_.remove(index);
            onChanged();
          } else {
            groundingFactsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public com.google.cloud.discoveryengine.v1.GroundingFact.Builder getGroundingFactsBuilder(
            int index) {
          return getGroundingFactsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public com.google.cloud.discoveryengine.v1.GroundingFactOrBuilder
            getGroundingFactsOrBuilder(int index) {
          if (groundingFactsBuilder_ == null) {
            return groundingFacts_.get(index);
          } else {
            return groundingFactsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public java.util.List<? extends com.google.cloud.discoveryengine.v1.GroundingFactOrBuilder>
            getGroundingFactsOrBuilderList() {
          if (groundingFactsBuilder_ != null) {
            return groundingFactsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(groundingFacts_);
          }
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public com.google.cloud.discoveryengine.v1.GroundingFact.Builder
            addGroundingFactsBuilder() {
          return getGroundingFactsFieldBuilder()
              .addBuilder(com.google.cloud.discoveryengine.v1.GroundingFact.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public com.google.cloud.discoveryengine.v1.GroundingFact.Builder addGroundingFactsBuilder(
            int index) {
          return getGroundingFactsFieldBuilder()
              .addBuilder(
                  index, com.google.cloud.discoveryengine.v1.GroundingFact.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of facts to be used for grounding.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1.GroundingFact grounding_facts = 1;</code>
         */
        public java.util.List<com.google.cloud.discoveryengine.v1.GroundingFact.Builder>
            getGroundingFactsBuilderList() {
          return getGroundingFactsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.GroundingFact,
                com.google.cloud.discoveryengine.v1.GroundingFact.Builder,
                com.google.cloud.discoveryengine.v1.GroundingFactOrBuilder>
            getGroundingFactsFieldBuilder() {
          if (groundingFactsBuilder_ == null) {
            groundingFactsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.GroundingFact,
                    com.google.cloud.discoveryengine.v1.GroundingFact.Builder,
                    com.google.cloud.discoveryengine.v1.GroundingFactOrBuilder>(
                    groundingFacts_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            groundingFacts_ = null;
          }
          return groundingFactsBuilder_;
        }

        private com.google.protobuf.MapField<java.lang.String, java.lang.String> attributes_;

        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetAttributes() {
          if (attributes_ == null) {
            return com.google.protobuf.MapField.emptyMapField(
                AttributesDefaultEntryHolder.defaultEntry);
          }
          return attributes_;
        }

        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetMutableAttributes() {
          if (attributes_ == null) {
            attributes_ =
                com.google.protobuf.MapField.newMapField(AttributesDefaultEntryHolder.defaultEntry);
          }
          if (!attributes_.isMutable()) {
            attributes_ = attributes_.copy();
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return attributes_;
        }

        public int getAttributesCount() {
          return internalGetAttributes().getMap().size();
        }
        /**
         *
         *
         * <pre>
         * Attributes associated with the content.
         *
         * Common attributes include `source` (indicating where the content was
         * sourced from) and `author` (indicating the author of the content).
         * </pre>
         *
         * <code>map&lt;string, string&gt; attributes = 2;</code>
         */
        @java.lang.Override
        public boolean containsAttributes(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          return internalGetAttributes().getMap().containsKey(key);
        }
        /** Use {@link #getAttributesMap()} instead. */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
          return getAttributesMap();
        }
        /**
         *
         *
         * <pre>
         * Attributes associated with the content.
         *
         * Common attributes include `source` (indicating where the content was
         * sourced from) and `author` (indicating the author of the content).
         * </pre>
         *
         * <code>map&lt;string, string&gt; attributes = 2;</code>
         */
        @java.lang.Override
        public java.util.Map<java.lang.String, java.lang.String> getAttributesMap() {
          return internalGetAttributes().getMap();
        }
        /**
         *
         *
         * <pre>
         * Attributes associated with the content.
         *
         * Common attributes include `source` (indicating where the content was
         * sourced from) and `author` (indicating the author of the content).
         * </pre>
         *
         * <code>map&lt;string, string&gt; attributes = 2;</code>
         */
        @java.lang.Override
        public /* nullable */ java.lang.String getAttributesOrDefault(
            java.lang.String key,
            /* nullable */
            java.lang.String defaultValue) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
          return map.containsKey(key) ? map.get(key) : defaultValue;
        }
        /**
         *
         *
         * <pre>
         * Attributes associated with the content.
         *
         * Common attributes include `source` (indicating where the content was
         * sourced from) and `author` (indicating the author of the content).
         * </pre>
         *
         * <code>map&lt;string, string&gt; attributes = 2;</code>
         */
        @java.lang.Override
        public java.lang.String getAttributesOrThrow(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return map.get(key);
        }

        public Builder clearAttributes() {
          bitField0_ = (bitField0_ & ~0x00000002);
          internalGetMutableAttributes().getMutableMap().clear();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Attributes associated with the content.
         *
         * Common attributes include `source` (indicating where the content was
         * sourced from) and `author` (indicating the author of the content).
         * </pre>
         *
         * <code>map&lt;string, string&gt; attributes = 2;</code>
         */
        public Builder removeAttributes(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          internalGetMutableAttributes().getMutableMap().remove(key);
          return this;
        }
        /** Use alternate mutation accessors instead. */
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getMutableAttributes() {
          bitField0_ |= 0x00000002;
          return internalGetMutableAttributes().getMutableMap();
        }
        /**
         *
         *
         * <pre>
         * Attributes associated with the content.
         *
         * Common attributes include `source` (indicating where the content was
         * sourced from) and `author` (indicating the author of the content).
         * </pre>
         *
         * <code>map&lt;string, string&gt; attributes = 2;</code>
         */
        public Builder putAttributes(java.lang.String key, java.lang.String value) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          if (value == null) {
            throw new NullPointerException("map value");
          }
          internalGetMutableAttributes().getMutableMap().put(key, value);
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Attributes associated with the content.
         *
         * Common attributes include `source` (indicating where the content was
         * sourced from) and `author` (indicating the author of the content).
         * </pre>
         *
         * <code>map&lt;string, string&gt; attributes = 2;</code>
         */
        public Builder putAllAttributes(java.util.Map<java.lang.String, java.lang.String> values) {
          internalGetMutableAttributes().getMutableMap().putAll(values);
          bitField0_ |= 0x00000002;
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource)
      private static final com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .InlineSource();
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.InlineSource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<InlineSource> PARSER =
          new com.google.protobuf.AbstractParser<InlineSource>() {
            @java.lang.Override
            public InlineSource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<InlineSource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<InlineSource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .InlineSource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SearchSourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The resource name of the Engine to use.
       *
       * Format:
       * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
       * </pre>
       *
       * <code>string serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The servingConfig.
       */
      java.lang.String getServingConfig();
      /**
       *
       *
       * <pre>
       * The resource name of the Engine to use.
       *
       * Format:
       * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
       * </pre>
       *
       * <code>string serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for servingConfig.
       */
      com.google.protobuf.ByteString getServingConfigBytes();

      /**
       *
       *
       * <pre>
       * Number of search results to return.
       *
       * The default value is 10. The maximumm allowed value is 10.
       * </pre>
       *
       * <code>int32 max_result_count = 2;</code>
       *
       * @return The maxResultCount.
       */
      int getMaxResultCount();

      /**
       *
       *
       * <pre>
       * Filter expression to be applied to the search.
       *
       * The syntax is the same as
       * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
       * </pre>
       *
       * <code>string filter = 3;</code>
       *
       * @return The filter.
       */
      java.lang.String getFilter();
      /**
       *
       *
       * <pre>
       * Filter expression to be applied to the search.
       *
       * The syntax is the same as
       * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
       * </pre>
       *
       * <code>string filter = 3;</code>
       *
       * @return The bytes for filter.
       */
      com.google.protobuf.ByteString getFilterBytes();

      /**
       *
       *
       * <pre>
       * If set, safe search is enabled in Vertex AI Search requests.
       * </pre>
       *
       * <code>bool safe_search = 5;</code>
       *
       * @return The safeSearch.
       */
      boolean getSafeSearch();
    }
    /**
     *
     *
     * <pre>
     * Message to be used for grounding with Vertex AI Search.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource}
     */
    public static final class SearchSource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource)
        SearchSourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SearchSource.newBuilder() to construct.
      private SearchSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SearchSource() {
        servingConfig_ = "";
        filter_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SearchSource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_SearchSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_SearchSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .SearchSource.class,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .SearchSource.Builder.class);
      }

      public static final int SERVING_CONFIG_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object servingConfig_ = "";
      /**
       *
       *
       * <pre>
       * The resource name of the Engine to use.
       *
       * Format:
       * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
       * </pre>
       *
       * <code>string serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The servingConfig.
       */
      @java.lang.Override
      public java.lang.String getServingConfig() {
        java.lang.Object ref = servingConfig_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          servingConfig_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Engine to use.
       *
       * Format:
       * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
       * </pre>
       *
       * <code>string serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for servingConfig.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getServingConfigBytes() {
        java.lang.Object ref = servingConfig_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          servingConfig_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int MAX_RESULT_COUNT_FIELD_NUMBER = 2;
      private int maxResultCount_ = 0;
      /**
       *
       *
       * <pre>
       * Number of search results to return.
       *
       * The default value is 10. The maximumm allowed value is 10.
       * </pre>
       *
       * <code>int32 max_result_count = 2;</code>
       *
       * @return The maxResultCount.
       */
      @java.lang.Override
      public int getMaxResultCount() {
        return maxResultCount_;
      }

      public static final int FILTER_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Filter expression to be applied to the search.
       *
       * The syntax is the same as
       * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
       * </pre>
       *
       * <code>string filter = 3;</code>
       *
       * @return The filter.
       */
      @java.lang.Override
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Filter expression to be applied to the search.
       *
       * The syntax is the same as
       * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
       * </pre>
       *
       * <code>string filter = 3;</code>
       *
       * @return The bytes for filter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SAFE_SEARCH_FIELD_NUMBER = 5;
      private boolean safeSearch_ = false;
      /**
       *
       *
       * <pre>
       * If set, safe search is enabled in Vertex AI Search requests.
       * </pre>
       *
       * <code>bool safe_search = 5;</code>
       *
       * @return The safeSearch.
       */
      @java.lang.Override
      public boolean getSafeSearch() {
        return safeSearch_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servingConfig_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, servingConfig_);
        }
        if (maxResultCount_ != 0) {
          output.writeInt32(2, maxResultCount_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filter_);
        }
        if (safeSearch_ != false) {
          output.writeBool(5, safeSearch_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servingConfig_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, servingConfig_);
        }
        if (maxResultCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxResultCount_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filter_);
        }
        if (safeSearch_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, safeSearch_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .SearchSource)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .SearchSource
            other =
                (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                        .SearchSource)
                    obj;

        if (!getServingConfig().equals(other.getServingConfig())) return false;
        if (getMaxResultCount() != other.getMaxResultCount()) return false;
        if (!getFilter().equals(other.getFilter())) return false;
        if (getSafeSearch() != other.getSafeSearch()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SERVING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getServingConfig().hashCode();
        hash = (37 * hash) + MAX_RESULT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMaxResultCount();
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
        hash = (37 * hash) + SAFE_SEARCH_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSafeSearch());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Message to be used for grounding with Vertex AI Search.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource)
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .SearchSourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_SearchSource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_SearchSource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .SearchSource.class,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .SearchSource.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          servingConfig_ = "";
          maxResultCount_ = 0;
          filter_ = "";
          safeSearch_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_SearchSource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .SearchSource
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .SearchSource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .SearchSource
            build() {
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .SearchSource
            buildPartial() {
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource
              result =
                  new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .GroundingSource.SearchSource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .SearchSource
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.servingConfig_ = servingConfig_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.maxResultCount_ = maxResultCount_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.filter_ = filter_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.safeSearch_ = safeSearch_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                        .SearchSource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .SearchSource
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource.getDefaultInstance()) return this;
          if (!other.getServingConfig().isEmpty()) {
            servingConfig_ = other.servingConfig_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getMaxResultCount() != 0) {
            setMaxResultCount(other.getMaxResultCount());
          }
          if (!other.getFilter().isEmpty()) {
            filter_ = other.filter_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (other.getSafeSearch() != false) {
            setSafeSearch(other.getSafeSearch());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    servingConfig_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    maxResultCount_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 26:
                  {
                    filter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 40:
                  {
                    safeSearch_ = input.readBool();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 40
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object servingConfig_ = "";
        /**
         *
         *
         * <pre>
         * The resource name of the Engine to use.
         *
         * Format:
         * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
         * </pre>
         *
         * <code>string serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The servingConfig.
         */
        public java.lang.String getServingConfig() {
          java.lang.Object ref = servingConfig_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            servingConfig_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The resource name of the Engine to use.
         *
         * Format:
         * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
         * </pre>
         *
         * <code>string serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The bytes for servingConfig.
         */
        public com.google.protobuf.ByteString getServingConfigBytes() {
          java.lang.Object ref = servingConfig_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            servingConfig_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The resource name of the Engine to use.
         *
         * Format:
         * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
         * </pre>
         *
         * <code>string serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The servingConfig to set.
         * @return This builder for chaining.
         */
        public Builder setServingConfig(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          servingConfig_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource name of the Engine to use.
         *
         * Format:
         * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
         * </pre>
         *
         * <code>string serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearServingConfig() {
          servingConfig_ = getDefaultInstance().getServingConfig();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource name of the Engine to use.
         *
         * Format:
         * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
         * </pre>
         *
         * <code>string serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The bytes for servingConfig to set.
         * @return This builder for chaining.
         */
        public Builder setServingConfigBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          servingConfig_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private int maxResultCount_;
        /**
         *
         *
         * <pre>
         * Number of search results to return.
         *
         * The default value is 10. The maximumm allowed value is 10.
         * </pre>
         *
         * <code>int32 max_result_count = 2;</code>
         *
         * @return The maxResultCount.
         */
        @java.lang.Override
        public int getMaxResultCount() {
          return maxResultCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of search results to return.
         *
         * The default value is 10. The maximumm allowed value is 10.
         * </pre>
         *
         * <code>int32 max_result_count = 2;</code>
         *
         * @param value The maxResultCount to set.
         * @return This builder for chaining.
         */
        public Builder setMaxResultCount(int value) {

          maxResultCount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of search results to return.
         *
         * The default value is 10. The maximumm allowed value is 10.
         * </pre>
         *
         * <code>int32 max_result_count = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxResultCount() {
          bitField0_ = (bitField0_ & ~0x00000002);
          maxResultCount_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object filter_ = "";
        /**
         *
         *
         * <pre>
         * Filter expression to be applied to the search.
         *
         * The syntax is the same as
         * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
         * </pre>
         *
         * <code>string filter = 3;</code>
         *
         * @return The filter.
         */
        public java.lang.String getFilter() {
          java.lang.Object ref = filter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            filter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Filter expression to be applied to the search.
         *
         * The syntax is the same as
         * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
         * </pre>
         *
         * <code>string filter = 3;</code>
         *
         * @return The bytes for filter.
         */
        public com.google.protobuf.ByteString getFilterBytes() {
          java.lang.Object ref = filter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            filter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Filter expression to be applied to the search.
         *
         * The syntax is the same as
         * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
         * </pre>
         *
         * <code>string filter = 3;</code>
         *
         * @param value The filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          filter_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Filter expression to be applied to the search.
         *
         * The syntax is the same as
         * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
         * </pre>
         *
         * <code>string filter = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFilter() {
          filter_ = getDefaultInstance().getFilter();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Filter expression to be applied to the search.
         *
         * The syntax is the same as
         * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
         * </pre>
         *
         * <code>string filter = 3;</code>
         *
         * @param value The bytes for filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          filter_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private boolean safeSearch_;
        /**
         *
         *
         * <pre>
         * If set, safe search is enabled in Vertex AI Search requests.
         * </pre>
         *
         * <code>bool safe_search = 5;</code>
         *
         * @return The safeSearch.
         */
        @java.lang.Override
        public boolean getSafeSearch() {
          return safeSearch_;
        }
        /**
         *
         *
         * <pre>
         * If set, safe search is enabled in Vertex AI Search requests.
         * </pre>
         *
         * <code>bool safe_search = 5;</code>
         *
         * @param value The safeSearch to set.
         * @return This builder for chaining.
         */
        public Builder setSafeSearch(boolean value) {

          safeSearch_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If set, safe search is enabled in Vertex AI Search requests.
         * </pre>
         *
         * <code>bool safe_search = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSafeSearch() {
          bitField0_ = (bitField0_ & ~0x00000008);
          safeSearch_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource)
      private static final com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .SearchSource();
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.SearchSource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SearchSource> PARSER =
          new com.google.protobuf.AbstractParser<SearchSource>() {
            @java.lang.Override
            public SearchSource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SearchSource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SearchSource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .SearchSource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface GoogleSearchSourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. Specifies the dynamic retrieval configuration for the given
       * source.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the dynamicRetrievalConfig field is set.
       */
      boolean hasDynamicRetrievalConfig();
      /**
       *
       *
       * <pre>
       * Optional. Specifies the dynamic retrieval configuration for the given
       * source.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The dynamicRetrievalConfig.
       */
      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration
          getDynamicRetrievalConfig();
      /**
       *
       *
       * <pre>
       * Optional. Specifies the dynamic retrieval configuration for the given
       * source.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfigurationOrBuilder
          getDynamicRetrievalConfigOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Google Search config parameters.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource}
     */
    public static final class GoogleSearchSource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource)
        GoogleSearchSourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use GoogleSearchSource.newBuilder() to construct.
      private GoogleSearchSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private GoogleSearchSource() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new GoogleSearchSource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .GoogleSearchSource.class,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .GoogleSearchSource.Builder.class);
      }

      private int bitField0_;
      public static final int DYNAMIC_RETRIEVAL_CONFIG_FIELD_NUMBER = 2;
      private com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration
          dynamicRetrievalConfig_;
      /**
       *
       *
       * <pre>
       * Optional. Specifies the dynamic retrieval configuration for the given
       * source.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the dynamicRetrievalConfig field is set.
       */
      @java.lang.Override
      public boolean hasDynamicRetrievalConfig() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies the dynamic retrieval configuration for the given
       * source.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The dynamicRetrievalConfig.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfiguration
          getDynamicRetrievalConfig() {
        return dynamicRetrievalConfig_ == null
            ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.getDefaultInstance()
            : dynamicRetrievalConfig_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies the dynamic retrieval configuration for the given
       * source.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .DynamicRetrievalConfigurationOrBuilder
          getDynamicRetrievalConfigOrBuilder() {
        return dynamicRetrievalConfig_ == null
            ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.getDefaultInstance()
            : dynamicRetrievalConfig_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getDynamicRetrievalConfig());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, getDynamicRetrievalConfig());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .GoogleSearchSource)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .GoogleSearchSource
            other =
                (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                        .GoogleSearchSource)
                    obj;

        if (hasDynamicRetrievalConfig() != other.hasDynamicRetrievalConfig()) return false;
        if (hasDynamicRetrievalConfig()) {
          if (!getDynamicRetrievalConfig().equals(other.getDynamicRetrievalConfig())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasDynamicRetrievalConfig()) {
          hash = (37 * hash) + DYNAMIC_RETRIEVAL_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getDynamicRetrievalConfig().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Google Search config parameters.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource)
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .GoogleSearchSourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .GoogleSearchSource.class,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .GoogleSearchSource.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getDynamicRetrievalConfigFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          dynamicRetrievalConfig_ = null;
          if (dynamicRetrievalConfigBuilder_ != null) {
            dynamicRetrievalConfigBuilder_.dispose();
            dynamicRetrievalConfigBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_GoogleSearchSource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .GoogleSearchSource
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .GoogleSearchSource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .GoogleSearchSource
            build() {
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .GoogleSearchSource
            buildPartial() {
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource
              result =
                  new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .GroundingSource.GoogleSearchSource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .GoogleSearchSource
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.dynamicRetrievalConfig_ =
                dynamicRetrievalConfigBuilder_ == null
                    ? dynamicRetrievalConfig_
                    : dynamicRetrievalConfigBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                        .GoogleSearchSource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .GoogleSearchSource
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource.getDefaultInstance()) return this;
          if (other.hasDynamicRetrievalConfig()) {
            mergeDynamicRetrievalConfig(other.getDynamicRetrievalConfig());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 18:
                  {
                    input.readMessage(
                        getDynamicRetrievalConfigFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration
            dynamicRetrievalConfig_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.Builder,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfigurationOrBuilder>
            dynamicRetrievalConfigBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. Specifies the dynamic retrieval configuration for the given
         * source.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the dynamicRetrievalConfig field is set.
         */
        public boolean hasDynamicRetrievalConfig() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Specifies the dynamic retrieval configuration for the given
         * source.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The dynamicRetrievalConfig.
         */
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration
            getDynamicRetrievalConfig() {
          if (dynamicRetrievalConfigBuilder_ == null) {
            return dynamicRetrievalConfig_ == null
                ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.getDefaultInstance()
                : dynamicRetrievalConfig_;
          } else {
            return dynamicRetrievalConfigBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Specifies the dynamic retrieval configuration for the given
         * source.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setDynamicRetrievalConfig(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration
                value) {
          if (dynamicRetrievalConfigBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            dynamicRetrievalConfig_ = value;
          } else {
            dynamicRetrievalConfigBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Specifies the dynamic retrieval configuration for the given
         * source.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setDynamicRetrievalConfig(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.Builder
                builderForValue) {
          if (dynamicRetrievalConfigBuilder_ == null) {
            dynamicRetrievalConfig_ = builderForValue.build();
          } else {
            dynamicRetrievalConfigBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Specifies the dynamic retrieval configuration for the given
         * source.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeDynamicRetrievalConfig(
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration
                value) {
          if (dynamicRetrievalConfigBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && dynamicRetrievalConfig_ != null
                && dynamicRetrievalConfig_
                    != com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                        .DynamicRetrievalConfiguration.getDefaultInstance()) {
              getDynamicRetrievalConfigBuilder().mergeFrom(value);
            } else {
              dynamicRetrievalConfig_ = value;
            }
          } else {
            dynamicRetrievalConfigBuilder_.mergeFrom(value);
          }
          if (dynamicRetrievalConfig_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Specifies the dynamic retrieval configuration for the given
         * source.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearDynamicRetrievalConfig() {
          bitField0_ = (bitField0_ & ~0x00000001);
          dynamicRetrievalConfig_ = null;
          if (dynamicRetrievalConfigBuilder_ != null) {
            dynamicRetrievalConfigBuilder_.dispose();
            dynamicRetrievalConfigBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Specifies the dynamic retrieval configuration for the given
         * source.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfiguration.Builder
            getDynamicRetrievalConfigBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getDynamicRetrievalConfigFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. Specifies the dynamic retrieval configuration for the given
         * source.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .DynamicRetrievalConfigurationOrBuilder
            getDynamicRetrievalConfigOrBuilder() {
          if (dynamicRetrievalConfigBuilder_ != null) {
            return dynamicRetrievalConfigBuilder_.getMessageOrBuilder();
          } else {
            return dynamicRetrievalConfig_ == null
                ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.getDefaultInstance()
                : dynamicRetrievalConfig_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Specifies the dynamic retrieval configuration for the given
         * source.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.DynamicRetrievalConfiguration dynamic_retrieval_config = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfiguration.Builder,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .DynamicRetrievalConfigurationOrBuilder>
            getDynamicRetrievalConfigFieldBuilder() {
          if (dynamicRetrievalConfigBuilder_ == null) {
            dynamicRetrievalConfigBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                        .DynamicRetrievalConfiguration,
                    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                        .DynamicRetrievalConfiguration.Builder,
                    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                        .DynamicRetrievalConfigurationOrBuilder>(
                    getDynamicRetrievalConfig(), getParentForChildren(), isClean());
            dynamicRetrievalConfig_ = null;
          }
          return dynamicRetrievalConfigBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource)
      private static final com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .GoogleSearchSource();
      }

      public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSource.GoogleSearchSource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<GoogleSearchSource> PARSER =
          new com.google.protobuf.AbstractParser<GoogleSearchSource>() {
            @java.lang.Override
            public GoogleSearchSource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<GoogleSearchSource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<GoogleSearchSource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .GoogleSearchSource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int sourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      INLINE_SOURCE(1),
      SEARCH_SOURCE(2),
      GOOGLE_SEARCH_SOURCE(3),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return INLINE_SOURCE;
          case 2:
            return SEARCH_SOURCE;
          case 3:
            return GOOGLE_SEARCH_SOURCE;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public static final int INLINE_SOURCE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with inline content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
     * </code>
     *
     * @return Whether the inlineSource field is set.
     */
    @java.lang.Override
    public boolean hasInlineSource() {
      return sourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with inline content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
     * </code>
     *
     * @return The inlineSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            .InlineSource
        getInlineSource() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .InlineSource)
            source_;
      }
      return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
          .InlineSource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with inline content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            .InlineSourceOrBuilder
        getInlineSourceOrBuilder() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .InlineSource)
            source_;
      }
      return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
          .InlineSource.getDefaultInstance();
    }

    public static final int SEARCH_SOURCE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
     * </code>
     *
     * @return Whether the searchSource field is set.
     */
    @java.lang.Override
    public boolean hasSearchSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
     * </code>
     *
     * @return The searchSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            .SearchSource
        getSearchSource() {
      if (sourceCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .SearchSource)
            source_;
      }
      return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
          .SearchSource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            .SearchSourceOrBuilder
        getSearchSourceOrBuilder() {
      if (sourceCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .SearchSource)
            source_;
      }
      return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
          .SearchSource.getDefaultInstance();
    }

    public static final int GOOGLE_SEARCH_SOURCE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Google Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
     * </code>
     *
     * @return Whether the googleSearchSource field is set.
     */
    @java.lang.Override
    public boolean hasGoogleSearchSource() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Google Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
     * </code>
     *
     * @return The googleSearchSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            .GoogleSearchSource
        getGoogleSearchSource() {
      if (sourceCase_ == 3) {
        return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .GoogleSearchSource)
            source_;
      }
      return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
          .GoogleSearchSource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * If set, grounding is performed with Google Search.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            .GoogleSearchSourceOrBuilder
        getGoogleSearchSourceOrBuilder() {
      if (sourceCase_ == 3) {
        return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .GoogleSearchSource)
            source_;
      }
      return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
          .GoogleSearchSource.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sourceCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .InlineSource)
                source_);
      }
      if (sourceCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .SearchSource)
                source_);
      }
      if (sourceCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .GoogleSearchSource)
                source_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                        .InlineSource)
                    source_);
      }
      if (sourceCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                        .SearchSource)
                    source_);
      }
      if (sourceCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                        .GoogleSearchSource)
                    source_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource other =
          (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource) obj;

      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 1:
          if (!getInlineSource().equals(other.getInlineSource())) return false;
          break;
        case 2:
          if (!getSearchSource().equals(other.getSearchSource())) return false;
          break;
        case 3:
          if (!getGoogleSearchSource().equals(other.getGoogleSearchSource())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (sourceCase_) {
        case 1:
          hash = (37 * hash) + INLINE_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getInlineSource().hashCode();
          break;
        case 2:
          hash = (37 * hash) + SEARCH_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getSearchSource().hashCode();
          break;
        case 3:
          hash = (37 * hash) + GOOGLE_SEARCH_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getGoogleSearchSource().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Grounding source.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource)
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .GroundingSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .class,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (inlineSourceBuilder_ != null) {
          inlineSourceBuilder_.clear();
        }
        if (searchSourceBuilder_ != null) {
          searchSourceBuilder_.clear();
        }
        if (googleSearchSourceBuilder_ != null) {
          googleSearchSourceBuilder_.clear();
        }
        sourceCase_ = 0;
        source_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
          build() {
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
          buildPartial() {
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource result =
            new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              result) {
        result.sourceCase_ = sourceCase_;
        result.source_ = this.source_;
        if (sourceCase_ == 1 && inlineSourceBuilder_ != null) {
          result.source_ = inlineSourceBuilder_.build();
        }
        if (sourceCase_ == 2 && searchSourceBuilder_ != null) {
          result.source_ = searchSourceBuilder_.build();
        }
        if (sourceCase_ == 3 && googleSearchSourceBuilder_ != null) {
          result.source_ = googleSearchSourceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              other) {
        if (other
            == com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                .getDefaultInstance()) return this;
        switch (other.getSourceCase()) {
          case INLINE_SOURCE:
            {
              mergeInlineSource(other.getInlineSource());
              break;
            }
          case SEARCH_SOURCE:
            {
              mergeSearchSource(other.getSearchSource());
              break;
            }
          case GOOGLE_SEARCH_SOURCE:
            {
              mergeGoogleSearchSource(other.getGoogleSearchSource());
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getInlineSourceFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getSearchSourceFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getGoogleSearchSourceFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource.Builder,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSourceOrBuilder>
          inlineSourceBuilder_;
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with inline content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
       * </code>
       *
       * @return Whether the inlineSource field is set.
       */
      @java.lang.Override
      public boolean hasInlineSource() {
        return sourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with inline content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
       * </code>
       *
       * @return The inlineSource.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .InlineSource
          getInlineSource() {
        if (inlineSourceBuilder_ == null) {
          if (sourceCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .GroundingSource.InlineSource)
                source_;
          }
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .InlineSource.getDefaultInstance();
        } else {
          if (sourceCase_ == 1) {
            return inlineSourceBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .InlineSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with inline content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
       * </code>
       */
      public Builder setInlineSource(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource
              value) {
        if (inlineSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          inlineSourceBuilder_.setMessage(value);
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with inline content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
       * </code>
       */
      public Builder setInlineSource(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource.Builder
              builderForValue) {
        if (inlineSourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          inlineSourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with inline content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
       * </code>
       */
      public Builder mergeInlineSource(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource
              value) {
        if (inlineSourceBuilder_ == null) {
          if (sourceCase_ == 1
              && source_
                  != com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .GroundingSource.InlineSource.getDefaultInstance()) {
            source_ =
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .InlineSource.newBuilder(
                        (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                                .GroundingSource.InlineSource)
                            source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 1) {
            inlineSourceBuilder_.mergeFrom(value);
          } else {
            inlineSourceBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with inline content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
       * </code>
       */
      public Builder clearInlineSource() {
        if (inlineSourceBuilder_ == null) {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
          }
          inlineSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with inline content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .InlineSource.Builder
          getInlineSourceBuilder() {
        return getInlineSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with inline content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .InlineSourceOrBuilder
          getInlineSourceOrBuilder() {
        if ((sourceCase_ == 1) && (inlineSourceBuilder_ != null)) {
          return inlineSourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .GroundingSource.InlineSource)
                source_;
          }
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .InlineSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with inline content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.InlineSource inline_source = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSource.Builder,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .InlineSourceOrBuilder>
          getInlineSourceFieldBuilder() {
        if (inlineSourceBuilder_ == null) {
          if (!(sourceCase_ == 1)) {
            source_ =
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .InlineSource.getDefaultInstance();
          }
          inlineSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .InlineSource,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .InlineSource.Builder,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .InlineSourceOrBuilder>(
                  (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                          .GroundingSource.InlineSource)
                      source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 1;
        onChanged();
        return inlineSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource.Builder,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSourceOrBuilder>
          searchSourceBuilder_;
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Vertex AI Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
       * </code>
       *
       * @return Whether the searchSource field is set.
       */
      @java.lang.Override
      public boolean hasSearchSource() {
        return sourceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Vertex AI Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
       * </code>
       *
       * @return The searchSource.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .SearchSource
          getSearchSource() {
        if (searchSourceBuilder_ == null) {
          if (sourceCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .GroundingSource.SearchSource)
                source_;
          }
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .SearchSource.getDefaultInstance();
        } else {
          if (sourceCase_ == 2) {
            return searchSourceBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .SearchSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Vertex AI Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
       * </code>
       */
      public Builder setSearchSource(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource
              value) {
        if (searchSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          searchSourceBuilder_.setMessage(value);
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Vertex AI Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
       * </code>
       */
      public Builder setSearchSource(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource.Builder
              builderForValue) {
        if (searchSourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          searchSourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Vertex AI Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
       * </code>
       */
      public Builder mergeSearchSource(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource
              value) {
        if (searchSourceBuilder_ == null) {
          if (sourceCase_ == 2
              && source_
                  != com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .GroundingSource.SearchSource.getDefaultInstance()) {
            source_ =
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .SearchSource.newBuilder(
                        (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                                .GroundingSource.SearchSource)
                            source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 2) {
            searchSourceBuilder_.mergeFrom(value);
          } else {
            searchSourceBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Vertex AI Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
       * </code>
       */
      public Builder clearSearchSource() {
        if (searchSourceBuilder_ == null) {
          if (sourceCase_ == 2) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 2) {
            sourceCase_ = 0;
            source_ = null;
          }
          searchSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Vertex AI Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .SearchSource.Builder
          getSearchSourceBuilder() {
        return getSearchSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Vertex AI Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .SearchSourceOrBuilder
          getSearchSourceOrBuilder() {
        if ((sourceCase_ == 2) && (searchSourceBuilder_ != null)) {
          return searchSourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .GroundingSource.SearchSource)
                source_;
          }
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .SearchSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Vertex AI Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.SearchSource search_source = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSource.Builder,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .SearchSourceOrBuilder>
          getSearchSourceFieldBuilder() {
        if (searchSourceBuilder_ == null) {
          if (!(sourceCase_ == 2)) {
            source_ =
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .SearchSource.getDefaultInstance();
          }
          searchSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .SearchSource,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .SearchSource.Builder,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .SearchSourceOrBuilder>(
                  (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                          .GroundingSource.SearchSource)
                      source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 2;
        onChanged();
        return searchSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource.Builder,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSourceOrBuilder>
          googleSearchSourceBuilder_;
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Google Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
       * </code>
       *
       * @return Whether the googleSearchSource field is set.
       */
      @java.lang.Override
      public boolean hasGoogleSearchSource() {
        return sourceCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Google Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
       * </code>
       *
       * @return The googleSearchSource.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .GoogleSearchSource
          getGoogleSearchSource() {
        if (googleSearchSourceBuilder_ == null) {
          if (sourceCase_ == 3) {
            return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .GroundingSource.GoogleSearchSource)
                source_;
          }
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .GoogleSearchSource.getDefaultInstance();
        } else {
          if (sourceCase_ == 3) {
            return googleSearchSourceBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .GoogleSearchSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Google Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
       * </code>
       */
      public Builder setGoogleSearchSource(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource
              value) {
        if (googleSearchSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          googleSearchSourceBuilder_.setMessage(value);
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Google Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
       * </code>
       */
      public Builder setGoogleSearchSource(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource.Builder
              builderForValue) {
        if (googleSearchSourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          googleSearchSourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Google Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
       * </code>
       */
      public Builder mergeGoogleSearchSource(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource
              value) {
        if (googleSearchSourceBuilder_ == null) {
          if (sourceCase_ == 3
              && source_
                  != com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .GroundingSource.GoogleSearchSource.getDefaultInstance()) {
            source_ =
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .GoogleSearchSource.newBuilder(
                        (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                                .GroundingSource.GoogleSearchSource)
                            source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 3) {
            googleSearchSourceBuilder_.mergeFrom(value);
          } else {
            googleSearchSourceBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Google Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
       * </code>
       */
      public Builder clearGoogleSearchSource() {
        if (googleSearchSourceBuilder_ == null) {
          if (sourceCase_ == 3) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 3) {
            sourceCase_ = 0;
            source_ = null;
          }
          googleSearchSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Google Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .GoogleSearchSource.Builder
          getGoogleSearchSourceBuilder() {
        return getGoogleSearchSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Google Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .GoogleSearchSourceOrBuilder
          getGoogleSearchSourceOrBuilder() {
        if ((sourceCase_ == 3) && (googleSearchSourceBuilder_ != null)) {
          return googleSearchSourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 3) {
            return (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .GroundingSource.GoogleSearchSource)
                source_;
          }
          return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .GoogleSearchSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, grounding is performed with Google Search.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.GoogleSearchSource google_search_source = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSource.Builder,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .GoogleSearchSourceOrBuilder>
          getGoogleSearchSourceFieldBuilder() {
        if (googleSearchSourceBuilder_ == null) {
          if (!(sourceCase_ == 3)) {
            source_ =
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .GoogleSearchSource.getDefaultInstance();
          }
          googleSearchSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .GoogleSearchSource,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .GoogleSearchSource.Builder,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .GoogleSearchSourceOrBuilder>(
                  (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                          .GroundingSource.GoogleSearchSource)
                      source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 3;
        onChanged();
        return googleSearchSourceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource)
    private static final com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .GroundingSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource();
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GroundingSource> PARSER =
        new com.google.protobuf.AbstractParser<GroundingSource>() {
          @java.lang.Override
          public GroundingSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GroundingSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GroundingSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GroundingSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Grounding sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
     * </code>
     */
    java.util.List<
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource>
        getGroundingSourcesList();
    /**
     *
     *
     * <pre>
     * Grounding sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        getGroundingSources(int index);
    /**
     *
     *
     * <pre>
     * Grounding sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
     * </code>
     */
    int getGroundingSourcesCount();
    /**
     *
     *
     * <pre>
     * Grounding sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .GroundingSourceOrBuilder>
        getGroundingSourcesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Grounding sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSourceOrBuilder
        getGroundingSourcesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Grounding specification.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec}
   */
  public static final class GroundingSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec)
      GroundingSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GroundingSpec.newBuilder() to construct.
    private GroundingSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GroundingSpec() {
      groundingSources_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GroundingSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
                  .class,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
                  .Builder.class);
    }

    public static final int GROUNDING_SOURCES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource>
        groundingSources_;
    /**
     *
     *
     * <pre>
     * Grounding sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource>
        getGroundingSourcesList() {
      return groundingSources_;
    }
    /**
     *
     *
     * <pre>
     * Grounding sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .GroundingSourceOrBuilder>
        getGroundingSourcesOrBuilderList() {
      return groundingSources_;
    }
    /**
     *
     *
     * <pre>
     * Grounding sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
     * </code>
     */
    @java.lang.Override
    public int getGroundingSourcesCount() {
      return groundingSources_.size();
    }
    /**
     *
     *
     * <pre>
     * Grounding sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
        getGroundingSources(int index) {
      return groundingSources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Grounding sources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .GroundingSourceOrBuilder
        getGroundingSourcesOrBuilder(int index) {
      return groundingSources_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < groundingSources_.size(); i++) {
        output.writeMessage(1, groundingSources_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < groundingSources_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, groundingSources_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec other =
          (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec) obj;

      if (!getGroundingSourcesList().equals(other.getGroundingSourcesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getGroundingSourcesCount() > 0) {
        hash = (37 * hash) + GROUNDING_SOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getGroundingSourcesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Grounding specification.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec)
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
                    .class,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (groundingSourcesBuilder_ == null) {
          groundingSources_ = java.util.Collections.emptyList();
        } else {
          groundingSources_ = null;
          groundingSourcesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_GroundingSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
          build() {
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
          buildPartial() {
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec result =
            new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec result) {
        if (groundingSourcesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            groundingSources_ = java.util.Collections.unmodifiableList(groundingSources_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.groundingSources_ = groundingSources_;
        } else {
          result.groundingSources_ = groundingSourcesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
                .getDefaultInstance()) return this;
        if (groundingSourcesBuilder_ == null) {
          if (!other.groundingSources_.isEmpty()) {
            if (groundingSources_.isEmpty()) {
              groundingSources_ = other.groundingSources_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureGroundingSourcesIsMutable();
              groundingSources_.addAll(other.groundingSources_);
            }
            onChanged();
          }
        } else {
          if (!other.groundingSources_.isEmpty()) {
            if (groundingSourcesBuilder_.isEmpty()) {
              groundingSourcesBuilder_.dispose();
              groundingSourcesBuilder_ = null;
              groundingSources_ = other.groundingSources_;
              bitField0_ = (bitField0_ & ~0x00000001);
              groundingSourcesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getGroundingSourcesFieldBuilder()
                      : null;
            } else {
              groundingSourcesBuilder_.addAllMessages(other.groundingSources_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      m =
                          input.readMessage(
                              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                                  .GroundingSource.parser(),
                              extensionRegistry);
                  if (groundingSourcesBuilder_ == null) {
                    ensureGroundingSourcesIsMutable();
                    groundingSources_.add(m);
                  } else {
                    groundingSourcesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource>
          groundingSources_ = java.util.Collections.emptyList();

      private void ensureGroundingSourcesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          groundingSources_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .GroundingSource>(groundingSources_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .Builder,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .GroundingSourceOrBuilder>
          groundingSourcesBuilder_;

      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource>
          getGroundingSourcesList() {
        if (groundingSourcesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(groundingSources_);
        } else {
          return groundingSourcesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public int getGroundingSourcesCount() {
        if (groundingSourcesBuilder_ == null) {
          return groundingSources_.size();
        } else {
          return groundingSourcesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
          getGroundingSources(int index) {
        if (groundingSourcesBuilder_ == null) {
          return groundingSources_.get(index);
        } else {
          return groundingSourcesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public Builder setGroundingSources(
          int index,
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              value) {
        if (groundingSourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroundingSourcesIsMutable();
          groundingSources_.set(index, value);
          onChanged();
        } else {
          groundingSourcesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public Builder setGroundingSources(
          int index,
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.Builder
              builderForValue) {
        if (groundingSourcesBuilder_ == null) {
          ensureGroundingSourcesIsMutable();
          groundingSources_.set(index, builderForValue.build());
          onChanged();
        } else {
          groundingSourcesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public Builder addGroundingSources(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              value) {
        if (groundingSourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroundingSourcesIsMutable();
          groundingSources_.add(value);
          onChanged();
        } else {
          groundingSourcesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public Builder addGroundingSources(
          int index,
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              value) {
        if (groundingSourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroundingSourcesIsMutable();
          groundingSources_.add(index, value);
          onChanged();
        } else {
          groundingSourcesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public Builder addGroundingSources(
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.Builder
              builderForValue) {
        if (groundingSourcesBuilder_ == null) {
          ensureGroundingSourcesIsMutable();
          groundingSources_.add(builderForValue.build());
          onChanged();
        } else {
          groundingSourcesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public Builder addGroundingSources(
          int index,
          com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource.Builder
              builderForValue) {
        if (groundingSourcesBuilder_ == null) {
          ensureGroundingSourcesIsMutable();
          groundingSources_.add(index, builderForValue.build());
          onChanged();
        } else {
          groundingSourcesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public Builder addAllGroundingSources(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                          .GroundingSource>
              values) {
        if (groundingSourcesBuilder_ == null) {
          ensureGroundingSourcesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groundingSources_);
          onChanged();
        } else {
          groundingSourcesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public Builder clearGroundingSources() {
        if (groundingSourcesBuilder_ == null) {
          groundingSources_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          groundingSourcesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public Builder removeGroundingSources(int index) {
        if (groundingSourcesBuilder_ == null) {
          ensureGroundingSourcesIsMutable();
          groundingSources_.remove(index);
          onChanged();
        } else {
          groundingSourcesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .Builder
          getGroundingSourcesBuilder(int index) {
        return getGroundingSourcesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .GroundingSourceOrBuilder
          getGroundingSourcesOrBuilder(int index) {
        if (groundingSourcesBuilder_ == null) {
          return groundingSources_.get(index);
        } else {
          return groundingSourcesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .GroundingSourceOrBuilder>
          getGroundingSourcesOrBuilderList() {
        if (groundingSourcesBuilder_ != null) {
          return groundingSourcesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(groundingSources_);
        }
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .Builder
          addGroundingSourcesBuilder() {
        return getGroundingSourcesFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
              .Builder
          addGroundingSourcesBuilder(int index) {
        return getGroundingSourcesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Grounding sources.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource grounding_sources = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .Builder>
          getGroundingSourcesBuilderList() {
        return getGroundingSourcesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                  .Builder,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                  .GroundingSourceOrBuilder>
          getGroundingSourcesFieldBuilder() {
        if (groundingSourcesBuilder_ == null) {
          groundingSourcesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .GroundingSource,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSource
                      .Builder,
                  com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                      .GroundingSourceOrBuilder>(
                  groundingSources_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          groundingSources_ = null;
        }
        return groundingSourcesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec)
    private static final com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .GroundingSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec();
    }

    public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GroundingSpec> PARSER =
        new com.google.protobuf.AbstractParser<GroundingSpec>() {
          @java.lang.Override
          public GroundingSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GroundingSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GroundingSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int LOCATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Required. Location resource.
   *
   * Format: `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Location resource.
   *
   * Format: `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SYSTEM_INSTRUCTION_FIELD_NUMBER = 5;
  private com.google.cloud.discoveryengine.v1.GroundedGenerationContent systemInstruction_;
  /**
   *
   *
   * <pre>
   * Content of the system instruction for the current API.
   *
   * These instructions will take priority over any other prompt instructions
   * if the selected model is supporting them.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;</code>
   *
   * @return Whether the systemInstruction field is set.
   */
  @java.lang.Override
  public boolean hasSystemInstruction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Content of the system instruction for the current API.
   *
   * These instructions will take priority over any other prompt instructions
   * if the selected model is supporting them.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;</code>
   *
   * @return The systemInstruction.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.GroundedGenerationContent getSystemInstruction() {
    return systemInstruction_ == null
        ? com.google.cloud.discoveryengine.v1.GroundedGenerationContent.getDefaultInstance()
        : systemInstruction_;
  }
  /**
   *
   *
   * <pre>
   * Content of the system instruction for the current API.
   *
   * These instructions will take priority over any other prompt instructions
   * if the selected model is supporting them.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder
      getSystemInstructionOrBuilder() {
    return systemInstruction_ == null
        ? com.google.cloud.discoveryengine.v1.GroundedGenerationContent.getDefaultInstance()
        : systemInstruction_;
  }

  public static final int CONTENTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.GroundedGenerationContent> contents_;
  /**
   *
   *
   * <pre>
   * Content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn queries,
   * this is a repeated field that contains conversation history + latest
   * request.
   *
   * Only a single-turn query is supported currently.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.GroundedGenerationContent>
      getContentsList() {
    return contents_;
  }
  /**
   *
   *
   * <pre>
   * Content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn queries,
   * this is a repeated field that contains conversation history + latest
   * request.
   *
   * Only a single-turn query is supported currently.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder>
      getContentsOrBuilderList() {
    return contents_;
  }
  /**
   *
   *
   * <pre>
   * Content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn queries,
   * this is a repeated field that contains conversation history + latest
   * request.
   *
   * Only a single-turn query is supported currently.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;</code>
   */
  @java.lang.Override
  public int getContentsCount() {
    return contents_.size();
  }
  /**
   *
   *
   * <pre>
   * Content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn queries,
   * this is a repeated field that contains conversation history + latest
   * request.
   *
   * Only a single-turn query is supported currently.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.GroundedGenerationContent getContents(int index) {
    return contents_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn queries,
   * this is a repeated field that contains conversation history + latest
   * request.
   *
   * Only a single-turn query is supported currently.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder
      getContentsOrBuilder(int index) {
    return contents_.get(index);
  }

  public static final int GENERATION_SPEC_FIELD_NUMBER = 3;
  private com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
      generationSpec_;
  /**
   *
   *
   * <pre>
   * Content generation specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
   * </code>
   *
   * @return Whether the generationSpec field is set.
   */
  @java.lang.Override
  public boolean hasGenerationSpec() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Content generation specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
   * </code>
   *
   * @return The generationSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
      getGenerationSpec() {
    return generationSpec_ == null
        ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
            .getDefaultInstance()
        : generationSpec_;
  }
  /**
   *
   *
   * <pre>
   * Content generation specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpecOrBuilder
      getGenerationSpecOrBuilder() {
    return generationSpec_ == null
        ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
            .getDefaultInstance()
        : generationSpec_;
  }

  public static final int GROUNDING_SPEC_FIELD_NUMBER = 4;
  private com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
      groundingSpec_;
  /**
   *
   *
   * <pre>
   * Grounding specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
   * </code>
   *
   * @return Whether the groundingSpec field is set.
   */
  @java.lang.Override
  public boolean hasGroundingSpec() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Grounding specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
   * </code>
   *
   * @return The groundingSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
      getGroundingSpec() {
    return groundingSpec_ == null
        ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
            .getDefaultInstance()
        : groundingSpec_;
  }
  /**
   *
   *
   * <pre>
   * Grounding specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpecOrBuilder
      getGroundingSpecOrBuilder() {
    return groundingSpec_ == null
        ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
            .getDefaultInstance()
        : groundingSpec_;
  }

  public static final int USER_LABELS_FIELD_NUMBER = 6;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 6;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 6;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
    }
    for (int i = 0; i < contents_.size(); i++) {
      output.writeMessage(2, contents_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getGenerationSpec());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getGroundingSpec());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getSystemInstruction());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 6);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
    }
    for (int i = 0; i < contents_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, contents_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getGenerationSpec());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getGroundingSpec());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSystemInstruction());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, userLabels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest other =
        (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest) obj;

    if (!getLocation().equals(other.getLocation())) return false;
    if (hasSystemInstruction() != other.hasSystemInstruction()) return false;
    if (hasSystemInstruction()) {
      if (!getSystemInstruction().equals(other.getSystemInstruction())) return false;
    }
    if (!getContentsList().equals(other.getContentsList())) return false;
    if (hasGenerationSpec() != other.hasGenerationSpec()) return false;
    if (hasGenerationSpec()) {
      if (!getGenerationSpec().equals(other.getGenerationSpec())) return false;
    }
    if (hasGroundingSpec() != other.hasGroundingSpec()) return false;
    if (hasGroundingSpec()) {
      if (!getGroundingSpec().equals(other.getGroundingSpec())) return false;
    }
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    if (hasSystemInstruction()) {
      hash = (37 * hash) + SYSTEM_INSTRUCTION_FIELD_NUMBER;
      hash = (53 * hash) + getSystemInstruction().hashCode();
    }
    if (getContentsCount() > 0) {
      hash = (37 * hash) + CONTENTS_FIELD_NUMBER;
      hash = (53 * hash) + getContentsList().hashCode();
    }
    if (hasGenerationSpec()) {
      hash = (37 * hash) + GENERATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getGenerationSpec().hashCode();
    }
    if (hasGroundingSpec()) {
      hash = (37 * hash) + GROUNDING_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getGroundingSpec().hashCode();
    }
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Top-level message sent by the client for the `GenerateGroundedContent`
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.GenerateGroundedContentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest)
      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.class,
              com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSystemInstructionFieldBuilder();
        getContentsFieldBuilder();
        getGenerationSpecFieldBuilder();
        getGroundingSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      location_ = "";
      systemInstruction_ = null;
      if (systemInstructionBuilder_ != null) {
        systemInstructionBuilder_.dispose();
        systemInstructionBuilder_ = null;
      }
      if (contentsBuilder_ == null) {
        contents_ = java.util.Collections.emptyList();
      } else {
        contents_ = null;
        contentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      generationSpec_ = null;
      if (generationSpecBuilder_ != null) {
        generationSpecBuilder_.dispose();
        generationSpecBuilder_ = null;
      }
      groundingSpec_ = null;
      if (groundingSpecBuilder_ != null) {
        groundingSpecBuilder_.dispose();
        groundingSpecBuilder_ = null;
      }
      internalGetMutableUserLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_GenerateGroundedContentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest build() {
      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest buildPartial() {
      com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest result =
          new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest result) {
      if (contentsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          contents_ = java.util.Collections.unmodifiableList(contents_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.contents_ = contents_;
      } else {
        result.contents_ = contentsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.location_ = location_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.systemInstruction_ =
            systemInstructionBuilder_ == null
                ? systemInstruction_
                : systemInstructionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.generationSpec_ =
            generationSpecBuilder_ == null ? generationSpec_ : generationSpecBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.groundingSpec_ =
            groundingSpecBuilder_ == null ? groundingSpec_ : groundingSpecBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
              .getDefaultInstance()) return this;
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSystemInstruction()) {
        mergeSystemInstruction(other.getSystemInstruction());
      }
      if (contentsBuilder_ == null) {
        if (!other.contents_.isEmpty()) {
          if (contents_.isEmpty()) {
            contents_ = other.contents_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureContentsIsMutable();
            contents_.addAll(other.contents_);
          }
          onChanged();
        }
      } else {
        if (!other.contents_.isEmpty()) {
          if (contentsBuilder_.isEmpty()) {
            contentsBuilder_.dispose();
            contentsBuilder_ = null;
            contents_ = other.contents_;
            bitField0_ = (bitField0_ & ~0x00000004);
            contentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContentsFieldBuilder()
                    : null;
          } else {
            contentsBuilder_.addAllMessages(other.contents_);
          }
        }
      }
      if (other.hasGenerationSpec()) {
        mergeGenerationSpec(other.getGenerationSpec());
      }
      if (other.hasGroundingSpec()) {
        mergeGroundingSpec(other.getGroundingSpec());
      }
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00000020;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.discoveryengine.v1.GroundedGenerationContent m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.GroundedGenerationContent.parser(),
                        extensionRegistry);
                if (contentsBuilder_ == null) {
                  ensureContentsIsMutable();
                  contents_.add(m);
                } else {
                  contentsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getGenerationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getGroundingSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getSystemInstructionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                    input.readMessage(
                        UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableUserLabels()
                    .getMutableMap()
                    .put(userLabels__.getKey(), userLabels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Required. Location resource.
     *
     * Format: `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Location resource.
     *
     * Format: `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Location resource.
     *
     * Format: `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Location resource.
     *
     * Format: `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Location resource.
     *
     * Format: `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1.GroundedGenerationContent systemInstruction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.GroundedGenerationContent,
            com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder,
            com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder>
        systemInstructionBuilder_;
    /**
     *
     *
     * <pre>
     * Content of the system instruction for the current API.
     *
     * These instructions will take priority over any other prompt instructions
     * if the selected model is supporting them.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;
     * </code>
     *
     * @return Whether the systemInstruction field is set.
     */
    public boolean hasSystemInstruction() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Content of the system instruction for the current API.
     *
     * These instructions will take priority over any other prompt instructions
     * if the selected model is supporting them.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;
     * </code>
     *
     * @return The systemInstruction.
     */
    public com.google.cloud.discoveryengine.v1.GroundedGenerationContent getSystemInstruction() {
      if (systemInstructionBuilder_ == null) {
        return systemInstruction_ == null
            ? com.google.cloud.discoveryengine.v1.GroundedGenerationContent.getDefaultInstance()
            : systemInstruction_;
      } else {
        return systemInstructionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Content of the system instruction for the current API.
     *
     * These instructions will take priority over any other prompt instructions
     * if the selected model is supporting them.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;
     * </code>
     */
    public Builder setSystemInstruction(
        com.google.cloud.discoveryengine.v1.GroundedGenerationContent value) {
      if (systemInstructionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        systemInstruction_ = value;
      } else {
        systemInstructionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the system instruction for the current API.
     *
     * These instructions will take priority over any other prompt instructions
     * if the selected model is supporting them.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;
     * </code>
     */
    public Builder setSystemInstruction(
        com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder builderForValue) {
      if (systemInstructionBuilder_ == null) {
        systemInstruction_ = builderForValue.build();
      } else {
        systemInstructionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the system instruction for the current API.
     *
     * These instructions will take priority over any other prompt instructions
     * if the selected model is supporting them.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;
     * </code>
     */
    public Builder mergeSystemInstruction(
        com.google.cloud.discoveryengine.v1.GroundedGenerationContent value) {
      if (systemInstructionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && systemInstruction_ != null
            && systemInstruction_
                != com.google.cloud.discoveryengine.v1.GroundedGenerationContent
                    .getDefaultInstance()) {
          getSystemInstructionBuilder().mergeFrom(value);
        } else {
          systemInstruction_ = value;
        }
      } else {
        systemInstructionBuilder_.mergeFrom(value);
      }
      if (systemInstruction_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the system instruction for the current API.
     *
     * These instructions will take priority over any other prompt instructions
     * if the selected model is supporting them.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;
     * </code>
     */
    public Builder clearSystemInstruction() {
      bitField0_ = (bitField0_ & ~0x00000002);
      systemInstruction_ = null;
      if (systemInstructionBuilder_ != null) {
        systemInstructionBuilder_.dispose();
        systemInstructionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the system instruction for the current API.
     *
     * These instructions will take priority over any other prompt instructions
     * if the selected model is supporting them.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder
        getSystemInstructionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSystemInstructionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Content of the system instruction for the current API.
     *
     * These instructions will take priority over any other prompt instructions
     * if the selected model is supporting them.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder
        getSystemInstructionOrBuilder() {
      if (systemInstructionBuilder_ != null) {
        return systemInstructionBuilder_.getMessageOrBuilder();
      } else {
        return systemInstruction_ == null
            ? com.google.cloud.discoveryengine.v1.GroundedGenerationContent.getDefaultInstance()
            : systemInstruction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Content of the system instruction for the current API.
     *
     * These instructions will take priority over any other prompt instructions
     * if the selected model is supporting them.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GroundedGenerationContent system_instruction = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.GroundedGenerationContent,
            com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder,
            com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder>
        getSystemInstructionFieldBuilder() {
      if (systemInstructionBuilder_ == null) {
        systemInstructionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.GroundedGenerationContent,
                com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder,
                com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder>(
                getSystemInstruction(), getParentForChildren(), isClean());
        systemInstruction_ = null;
      }
      return systemInstructionBuilder_;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1.GroundedGenerationContent>
        contents_ = java.util.Collections.emptyList();

    private void ensureContentsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        contents_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1.GroundedGenerationContent>(
                contents_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.GroundedGenerationContent,
            com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder,
            com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder>
        contentsBuilder_;

    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.GroundedGenerationContent>
        getContentsList() {
      if (contentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contents_);
      } else {
        return contentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public int getContentsCount() {
      if (contentsBuilder_ == null) {
        return contents_.size();
      } else {
        return contentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.GroundedGenerationContent getContents(int index) {
      if (contentsBuilder_ == null) {
        return contents_.get(index);
      } else {
        return contentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public Builder setContents(
        int index, com.google.cloud.discoveryengine.v1.GroundedGenerationContent value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.set(index, value);
        onChanged();
      } else {
        contentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public Builder setContents(
        int index,
        com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.set(index, builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public Builder addContents(
        com.google.cloud.discoveryengine.v1.GroundedGenerationContent value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.add(value);
        onChanged();
      } else {
        contentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public Builder addContents(
        int index, com.google.cloud.discoveryengine.v1.GroundedGenerationContent value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.add(index, value);
        onChanged();
      } else {
        contentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public Builder addContents(
        com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.add(builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public Builder addContents(
        int index,
        com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.add(index, builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public Builder addAllContents(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.GroundedGenerationContent>
            values) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contents_);
        onChanged();
      } else {
        contentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public Builder clearContents() {
      if (contentsBuilder_ == null) {
        contents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        contentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public Builder removeContents(int index) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.remove(index);
        onChanged();
      } else {
        contentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder getContentsBuilder(
        int index) {
      return getContentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder
        getContentsOrBuilder(int index) {
      if (contentsBuilder_ == null) {
        return contents_.get(index);
      } else {
        return contentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder>
        getContentsOrBuilderList() {
      if (contentsBuilder_ != null) {
        return contentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contents_);
      }
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder
        addContentsBuilder() {
      return getContentsFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1.GroundedGenerationContent.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder addContentsBuilder(
        int index) {
      return getContentsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1.GroundedGenerationContent.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     *
     * Only a single-turn query is supported currently.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.GroundedGenerationContent contents = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder>
        getContentsBuilderList() {
      return getContentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.GroundedGenerationContent,
            com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder,
            com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder>
        getContentsFieldBuilder() {
      if (contentsBuilder_ == null) {
        contentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.GroundedGenerationContent,
                com.google.cloud.discoveryengine.v1.GroundedGenerationContent.Builder,
                com.google.cloud.discoveryengine.v1.GroundedGenerationContentOrBuilder>(
                contents_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        contents_ = null;
      }
      return contentsBuilder_;
    }

    private com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        generationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec,
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
                .Builder,
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .GenerationSpecOrBuilder>
        generationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Content generation specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
     * </code>
     *
     * @return Whether the generationSpec field is set.
     */
    public boolean hasGenerationSpec() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Content generation specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
     * </code>
     *
     * @return The generationSpec.
     */
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
        getGenerationSpec() {
      if (generationSpecBuilder_ == null) {
        return generationSpec_ == null
            ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
                .getDefaultInstance()
            : generationSpec_;
      } else {
        return generationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Content generation specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
     * </code>
     */
    public Builder setGenerationSpec(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec value) {
      if (generationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        generationSpec_ = value;
      } else {
        generationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content generation specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
     * </code>
     */
    public Builder setGenerationSpec(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec.Builder
            builderForValue) {
      if (generationSpecBuilder_ == null) {
        generationSpec_ = builderForValue.build();
      } else {
        generationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content generation specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
     * </code>
     */
    public Builder mergeGenerationSpec(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec value) {
      if (generationSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && generationSpec_ != null
            && generationSpec_
                != com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
                    .getDefaultInstance()) {
          getGenerationSpecBuilder().mergeFrom(value);
        } else {
          generationSpec_ = value;
        }
      } else {
        generationSpecBuilder_.mergeFrom(value);
      }
      if (generationSpec_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content generation specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
     * </code>
     */
    public Builder clearGenerationSpec() {
      bitField0_ = (bitField0_ & ~0x00000008);
      generationSpec_ = null;
      if (generationSpecBuilder_ != null) {
        generationSpecBuilder_.dispose();
        generationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content generation specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec.Builder
        getGenerationSpecBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getGenerationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Content generation specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
            .GenerationSpecOrBuilder
        getGenerationSpecOrBuilder() {
      if (generationSpecBuilder_ != null) {
        return generationSpecBuilder_.getMessageOrBuilder();
      } else {
        return generationSpec_ == null
            ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
                .getDefaultInstance()
            : generationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Content generation specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec generation_spec = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec,
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
                .Builder,
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .GenerationSpecOrBuilder>
        getGenerationSpecFieldBuilder() {
      if (generationSpecBuilder_ == null) {
        generationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GenerationSpec
                    .Builder,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .GenerationSpecOrBuilder>(
                getGenerationSpec(), getParentForChildren(), isClean());
        generationSpec_ = null;
      }
      return generationSpecBuilder_;
    }

    private com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        groundingSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec,
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
                .Builder,
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .GroundingSpecOrBuilder>
        groundingSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Grounding specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
     * </code>
     *
     * @return Whether the groundingSpec field is set.
     */
    public boolean hasGroundingSpec() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Grounding specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
     * </code>
     *
     * @return The groundingSpec.
     */
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
        getGroundingSpec() {
      if (groundingSpecBuilder_ == null) {
        return groundingSpec_ == null
            ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
                .getDefaultInstance()
            : groundingSpec_;
      } else {
        return groundingSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Grounding specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
     * </code>
     */
    public Builder setGroundingSpec(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec value) {
      if (groundingSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        groundingSpec_ = value;
      } else {
        groundingSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Grounding specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
     * </code>
     */
    public Builder setGroundingSpec(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec.Builder
            builderForValue) {
      if (groundingSpecBuilder_ == null) {
        groundingSpec_ = builderForValue.build();
      } else {
        groundingSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Grounding specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
     * </code>
     */
    public Builder mergeGroundingSpec(
        com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec value) {
      if (groundingSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && groundingSpec_ != null
            && groundingSpec_
                != com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
                    .getDefaultInstance()) {
          getGroundingSpecBuilder().mergeFrom(value);
        } else {
          groundingSpec_ = value;
        }
      } else {
        groundingSpecBuilder_.mergeFrom(value);
      }
      if (groundingSpec_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Grounding specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
     * </code>
     */
    public Builder clearGroundingSpec() {
      bitField0_ = (bitField0_ & ~0x00000010);
      groundingSpec_ = null;
      if (groundingSpecBuilder_ != null) {
        groundingSpecBuilder_.dispose();
        groundingSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Grounding specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec.Builder
        getGroundingSpecBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getGroundingSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Grounding specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpecOrBuilder
        getGroundingSpecOrBuilder() {
      if (groundingSpecBuilder_ != null) {
        return groundingSpecBuilder_.getMessageOrBuilder();
      } else {
        return groundingSpec_ == null
            ? com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
                .getDefaultInstance()
            : groundingSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Grounding specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec grounding_spec = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec,
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
                .Builder,
            com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                .GroundingSpecOrBuilder>
        getGroundingSpecFieldBuilder() {
      if (groundingSpecBuilder_ == null) {
        groundingSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest.GroundingSpec
                    .Builder,
                com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
                    .GroundingSpecOrBuilder>(getGroundingSpec(), getParentForChildren(), isClean());
        groundingSpec_ = null;
      }
      return groundingSpecBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUserLabels() {
      if (userLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UserLabelsDefaultEntryHolder.defaultEntry);
      }
      return userLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableUserLabels() {
      if (userLabels_ == null) {
        userLabels_ =
            com.google.protobuf.MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!userLabels_.isMutable()) {
        userLabels_ = userLabels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return userLabels_;
    }

    public int getUserLabelsCount() {
      return internalGetUserLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 6;</code>
     */
    @java.lang.Override
    public boolean containsUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetUserLabels().getMap().containsKey(key);
    }
    /** Use {@link #getUserLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
      return getUserLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
      return internalGetUserLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getUserLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearUserLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableUserLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 6;</code>
     */
    public Builder removeUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableUserLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableUserLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableUserLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 6;</code>
     */
    public Builder putUserLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableUserLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 6;</code>
     */
    public Builder putAllUserLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableUserLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.GenerateGroundedContentRequest)
  private static final com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest();
  }

  public static com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateGroundedContentRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateGroundedContentRequest>() {
        @java.lang.Override
        public GenerateGroundedContentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateGroundedContentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateGroundedContentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.GenerateGroundedContentRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
