/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/rank_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Request message for
 * [RankService.Rank][google.cloud.discoveryengine.v1alpha.RankService.Rank]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.RankRequest}
 */
public final class RankRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.RankRequest)
    RankRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RankRequest.newBuilder() to construct.
  private RankRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RankRequest() {
    rankingConfig_ = "";
    model_ = "";
    query_ = "";
    records_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RankRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.RankServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_RankRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 7:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.RankServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_RankRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.RankRequest.class,
            com.google.cloud.discoveryengine.v1alpha.RankRequest.Builder.class);
  }

  public static final int RANKING_CONFIG_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rankingConfig_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the rank service config, such as
   * `projects/{project_num}/locations/{location_id}/rankingConfigs/default_ranking_config`.
   * </pre>
   *
   * <code>
   * string ranking_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The rankingConfig.
   */
  @java.lang.Override
  public java.lang.String getRankingConfig() {
    java.lang.Object ref = rankingConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rankingConfig_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the rank service config, such as
   * `projects/{project_num}/locations/{location_id}/rankingConfigs/default_ranking_config`.
   * </pre>
   *
   * <code>
   * string ranking_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for rankingConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRankingConfigBytes() {
    java.lang.Object ref = rankingConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rankingConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";
  /**
   *
   *
   * <pre>
   * The identifier of the model to use. It is one of:
   *
   * * `semantic-ranker-512&#64;latest`: Semantic ranking model with maxiumn input
   * token size 512.
   *
   * It is set to `semantic-ranker-512&#64;latest` by default if unspecified.
   * </pre>
   *
   * <code>string model = 2;</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The identifier of the model to use. It is one of:
   *
   * * `semantic-ranker-512&#64;latest`: Semantic ranking model with maxiumn input
   * token size 512.
   *
   * It is set to `semantic-ranker-512&#64;latest` by default if unspecified.
   * </pre>
   *
   * <code>string model = 2;</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TOP_N_FIELD_NUMBER = 3;
  private int topN_ = 0;
  /**
   *
   *
   * <pre>
   * The number of results to return. If this is unset or no bigger than zero,
   * returns all results.
   * </pre>
   *
   * <code>int32 top_n = 3;</code>
   *
   * @return The topN.
   */
  @java.lang.Override
  public int getTopN() {
    return topN_;
  }

  public static final int QUERY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";
  /**
   *
   *
   * <pre>
   * The query to use.
   * </pre>
   *
   * <code>string query = 4;</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The query to use.
   * </pre>
   *
   * <code>string query = 4;</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECORDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1alpha.RankingRecord> records_;
  /**
   *
   *
   * <pre>
   * Required. A list of records to rank. At most 200 records to rank.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1alpha.RankingRecord> getRecordsList() {
    return records_;
  }
  /**
   *
   *
   * <pre>
   * Required. A list of records to rank. At most 200 records to rank.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1alpha.RankingRecordOrBuilder>
      getRecordsOrBuilderList() {
    return records_;
  }
  /**
   *
   *
   * <pre>
   * Required. A list of records to rank. At most 200 records to rank.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getRecordsCount() {
    return records_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. A list of records to rank. At most 200 records to rank.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.RankingRecord getRecords(int index) {
    return records_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. A list of records to rank. At most 200 records to rank.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.RankingRecordOrBuilder getRecordsOrBuilder(
      int index) {
    return records_.get(index);
  }

  public static final int IGNORE_RECORD_DETAILS_IN_RESPONSE_FIELD_NUMBER = 6;
  private boolean ignoreRecordDetailsInResponse_ = false;
  /**
   *
   *
   * <pre>
   * If true, the response will contain only record ID and score. By default, it
   * is false, the response will contain record details.
   * </pre>
   *
   * <code>bool ignore_record_details_in_response = 6;</code>
   *
   * @return The ignoreRecordDetailsInResponse.
   */
  @java.lang.Override
  public boolean getIgnoreRecordDetailsInResponse() {
    return ignoreRecordDetailsInResponse_;
  }

  public static final int USER_LABELS_FIELD_NUMBER = 7;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.discoveryengine.v1alpha.RankServiceProto
                .internal_static_google_cloud_discoveryengine_v1alpha_RankRequest_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 7;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 7;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rankingConfig_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, rankingConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, model_);
    }
    if (topN_ != 0) {
      output.writeInt32(3, topN_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, query_);
    }
    for (int i = 0; i < records_.size(); i++) {
      output.writeMessage(5, records_.get(i));
    }
    if (ignoreRecordDetailsInResponse_ != false) {
      output.writeBool(6, ignoreRecordDetailsInResponse_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 7);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rankingConfig_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, rankingConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, model_);
    }
    if (topN_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, topN_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, query_);
    }
    for (int i = 0; i < records_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, records_.get(i));
    }
    if (ignoreRecordDetailsInResponse_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(6, ignoreRecordDetailsInResponse_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, userLabels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1alpha.RankRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.RankRequest other =
        (com.google.cloud.discoveryengine.v1alpha.RankRequest) obj;

    if (!getRankingConfig().equals(other.getRankingConfig())) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (getTopN() != other.getTopN()) return false;
    if (!getQuery().equals(other.getQuery())) return false;
    if (!getRecordsList().equals(other.getRecordsList())) return false;
    if (getIgnoreRecordDetailsInResponse() != other.getIgnoreRecordDetailsInResponse())
      return false;
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RANKING_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getRankingConfig().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    hash = (37 * hash) + TOP_N_FIELD_NUMBER;
    hash = (53 * hash) + getTopN();
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    if (getRecordsCount() > 0) {
      hash = (37 * hash) + RECORDS_FIELD_NUMBER;
      hash = (53 * hash) + getRecordsList().hashCode();
    }
    hash = (37 * hash) + IGNORE_RECORD_DETAILS_IN_RESPONSE_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreRecordDetailsInResponse());
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1alpha.RankRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [RankService.Rank][google.cloud.discoveryengine.v1alpha.RankService.Rank]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.RankRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.RankRequest)
      com.google.cloud.discoveryengine.v1alpha.RankRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.RankServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_RankRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.RankServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_RankRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.RankRequest.class,
              com.google.cloud.discoveryengine.v1alpha.RankRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1alpha.RankRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      rankingConfig_ = "";
      model_ = "";
      topN_ = 0;
      query_ = "";
      if (recordsBuilder_ == null) {
        records_ = java.util.Collections.emptyList();
      } else {
        records_ = null;
        recordsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      ignoreRecordDetailsInResponse_ = false;
      internalGetMutableUserLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.RankServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_RankRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.RankRequest getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.RankRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.RankRequest build() {
      com.google.cloud.discoveryengine.v1alpha.RankRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.RankRequest buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.RankRequest result =
          new com.google.cloud.discoveryengine.v1alpha.RankRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1alpha.RankRequest result) {
      if (recordsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          records_ = java.util.Collections.unmodifiableList(records_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.records_ = records_;
      } else {
        result.records_ = recordsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1alpha.RankRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.rankingConfig_ = rankingConfig_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.model_ = model_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.topN_ = topN_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.query_ = query_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ignoreRecordDetailsInResponse_ = ignoreRecordDetailsInResponse_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1alpha.RankRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1alpha.RankRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1alpha.RankRequest other) {
      if (other == com.google.cloud.discoveryengine.v1alpha.RankRequest.getDefaultInstance())
        return this;
      if (!other.getRankingConfig().isEmpty()) {
        rankingConfig_ = other.rankingConfig_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getTopN() != 0) {
        setTopN(other.getTopN());
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (recordsBuilder_ == null) {
        if (!other.records_.isEmpty()) {
          if (records_.isEmpty()) {
            records_ = other.records_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureRecordsIsMutable();
            records_.addAll(other.records_);
          }
          onChanged();
        }
      } else {
        if (!other.records_.isEmpty()) {
          if (recordsBuilder_.isEmpty()) {
            recordsBuilder_.dispose();
            recordsBuilder_ = null;
            records_ = other.records_;
            bitField0_ = (bitField0_ & ~0x00000010);
            recordsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRecordsFieldBuilder()
                    : null;
          } else {
            recordsBuilder_.addAllMessages(other.records_);
          }
        }
      }
      if (other.getIgnoreRecordDetailsInResponse() != false) {
        setIgnoreRecordDetailsInResponse(other.getIgnoreRecordDetailsInResponse());
      }
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00000040;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                rankingConfig_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                topN_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.discoveryengine.v1alpha.RankingRecord m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1alpha.RankingRecord.parser(),
                        extensionRegistry);
                if (recordsBuilder_ == null) {
                  ensureRecordsIsMutable();
                  records_.add(m);
                } else {
                  recordsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 48:
              {
                ignoreRecordDetailsInResponse_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                    input.readMessage(
                        UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableUserLabels()
                    .getMutableMap()
                    .put(userLabels__.getKey(), userLabels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object rankingConfig_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the rank service config, such as
     * `projects/{project_num}/locations/{location_id}/rankingConfigs/default_ranking_config`.
     * </pre>
     *
     * <code>
     * string ranking_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The rankingConfig.
     */
    public java.lang.String getRankingConfig() {
      java.lang.Object ref = rankingConfig_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rankingConfig_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the rank service config, such as
     * `projects/{project_num}/locations/{location_id}/rankingConfigs/default_ranking_config`.
     * </pre>
     *
     * <code>
     * string ranking_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for rankingConfig.
     */
    public com.google.protobuf.ByteString getRankingConfigBytes() {
      java.lang.Object ref = rankingConfig_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rankingConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the rank service config, such as
     * `projects/{project_num}/locations/{location_id}/rankingConfigs/default_ranking_config`.
     * </pre>
     *
     * <code>
     * string ranking_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The rankingConfig to set.
     * @return This builder for chaining.
     */
    public Builder setRankingConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rankingConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the rank service config, such as
     * `projects/{project_num}/locations/{location_id}/rankingConfigs/default_ranking_config`.
     * </pre>
     *
     * <code>
     * string ranking_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRankingConfig() {
      rankingConfig_ = getDefaultInstance().getRankingConfig();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the rank service config, such as
     * `projects/{project_num}/locations/{location_id}/rankingConfigs/default_ranking_config`.
     * </pre>
     *
     * <code>
     * string ranking_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for rankingConfig to set.
     * @return This builder for chaining.
     */
    public Builder setRankingConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rankingConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * The identifier of the model to use. It is one of:
     *
     * * `semantic-ranker-512&#64;latest`: Semantic ranking model with maxiumn input
     * token size 512.
     *
     * It is set to `semantic-ranker-512&#64;latest` by default if unspecified.
     * </pre>
     *
     * <code>string model = 2;</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier of the model to use. It is one of:
     *
     * * `semantic-ranker-512&#64;latest`: Semantic ranking model with maxiumn input
     * token size 512.
     *
     * It is set to `semantic-ranker-512&#64;latest` by default if unspecified.
     * </pre>
     *
     * <code>string model = 2;</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier of the model to use. It is one of:
     *
     * * `semantic-ranker-512&#64;latest`: Semantic ranking model with maxiumn input
     * token size 512.
     *
     * It is set to `semantic-ranker-512&#64;latest` by default if unspecified.
     * </pre>
     *
     * <code>string model = 2;</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the model to use. It is one of:
     *
     * * `semantic-ranker-512&#64;latest`: Semantic ranking model with maxiumn input
     * token size 512.
     *
     * It is set to `semantic-ranker-512&#64;latest` by default if unspecified.
     * </pre>
     *
     * <code>string model = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the model to use. It is one of:
     *
     * * `semantic-ranker-512&#64;latest`: Semantic ranking model with maxiumn input
     * token size 512.
     *
     * It is set to `semantic-ranker-512&#64;latest` by default if unspecified.
     * </pre>
     *
     * <code>string model = 2;</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int topN_;
    /**
     *
     *
     * <pre>
     * The number of results to return. If this is unset or no bigger than zero,
     * returns all results.
     * </pre>
     *
     * <code>int32 top_n = 3;</code>
     *
     * @return The topN.
     */
    @java.lang.Override
    public int getTopN() {
      return topN_;
    }
    /**
     *
     *
     * <pre>
     * The number of results to return. If this is unset or no bigger than zero,
     * returns all results.
     * </pre>
     *
     * <code>int32 top_n = 3;</code>
     *
     * @param value The topN to set.
     * @return This builder for chaining.
     */
    public Builder setTopN(int value) {

      topN_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of results to return. If this is unset or no bigger than zero,
     * returns all results.
     * </pre>
     *
     * <code>int32 top_n = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopN() {
      bitField0_ = (bitField0_ & ~0x00000004);
      topN_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * The query to use.
     * </pre>
     *
     * <code>string query = 4;</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The query to use.
     * </pre>
     *
     * <code>string query = 4;</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The query to use.
     * </pre>
     *
     * <code>string query = 4;</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query to use.
     * </pre>
     *
     * <code>string query = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query to use.
     * </pre>
     *
     * <code>string query = 4;</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1alpha.RankingRecord> records_ =
        java.util.Collections.emptyList();

    private void ensureRecordsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        records_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1alpha.RankingRecord>(
                records_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.RankingRecord,
            com.google.cloud.discoveryengine.v1alpha.RankingRecord.Builder,
            com.google.cloud.discoveryengine.v1alpha.RankingRecordOrBuilder>
        recordsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1alpha.RankingRecord> getRecordsList() {
      if (recordsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(records_);
      } else {
        return recordsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getRecordsCount() {
      if (recordsBuilder_ == null) {
        return records_.size();
      } else {
        return recordsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.RankingRecord getRecords(int index) {
      if (recordsBuilder_ == null) {
        return records_.get(index);
      } else {
        return recordsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRecords(
        int index, com.google.cloud.discoveryengine.v1alpha.RankingRecord value) {
      if (recordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecordsIsMutable();
        records_.set(index, value);
        onChanged();
      } else {
        recordsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRecords(
        int index, com.google.cloud.discoveryengine.v1alpha.RankingRecord.Builder builderForValue) {
      if (recordsBuilder_ == null) {
        ensureRecordsIsMutable();
        records_.set(index, builderForValue.build());
        onChanged();
      } else {
        recordsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRecords(com.google.cloud.discoveryengine.v1alpha.RankingRecord value) {
      if (recordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecordsIsMutable();
        records_.add(value);
        onChanged();
      } else {
        recordsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRecords(
        int index, com.google.cloud.discoveryengine.v1alpha.RankingRecord value) {
      if (recordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecordsIsMutable();
        records_.add(index, value);
        onChanged();
      } else {
        recordsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRecords(
        com.google.cloud.discoveryengine.v1alpha.RankingRecord.Builder builderForValue) {
      if (recordsBuilder_ == null) {
        ensureRecordsIsMutable();
        records_.add(builderForValue.build());
        onChanged();
      } else {
        recordsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRecords(
        int index, com.google.cloud.discoveryengine.v1alpha.RankingRecord.Builder builderForValue) {
      if (recordsBuilder_ == null) {
        ensureRecordsIsMutable();
        records_.add(index, builderForValue.build());
        onChanged();
      } else {
        recordsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllRecords(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1alpha.RankingRecord>
            values) {
      if (recordsBuilder_ == null) {
        ensureRecordsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, records_);
        onChanged();
      } else {
        recordsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRecords() {
      if (recordsBuilder_ == null) {
        records_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        recordsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeRecords(int index) {
      if (recordsBuilder_ == null) {
        ensureRecordsIsMutable();
        records_.remove(index);
        onChanged();
      } else {
        recordsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.RankingRecord.Builder getRecordsBuilder(
        int index) {
      return getRecordsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.RankingRecordOrBuilder getRecordsOrBuilder(
        int index) {
      if (recordsBuilder_ == null) {
        return records_.get(index);
      } else {
        return recordsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1alpha.RankingRecordOrBuilder>
        getRecordsOrBuilderList() {
      if (recordsBuilder_ != null) {
        return recordsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(records_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.RankingRecord.Builder addRecordsBuilder() {
      return getRecordsFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1alpha.RankingRecord.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.RankingRecord.Builder addRecordsBuilder(
        int index) {
      return getRecordsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.discoveryengine.v1alpha.RankingRecord.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. A list of records to rank. At most 200 records to rank.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RankingRecord records = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1alpha.RankingRecord.Builder>
        getRecordsBuilderList() {
      return getRecordsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.RankingRecord,
            com.google.cloud.discoveryengine.v1alpha.RankingRecord.Builder,
            com.google.cloud.discoveryengine.v1alpha.RankingRecordOrBuilder>
        getRecordsFieldBuilder() {
      if (recordsBuilder_ == null) {
        recordsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.RankingRecord,
                com.google.cloud.discoveryengine.v1alpha.RankingRecord.Builder,
                com.google.cloud.discoveryengine.v1alpha.RankingRecordOrBuilder>(
                records_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        records_ = null;
      }
      return recordsBuilder_;
    }

    private boolean ignoreRecordDetailsInResponse_;
    /**
     *
     *
     * <pre>
     * If true, the response will contain only record ID and score. By default, it
     * is false, the response will contain record details.
     * </pre>
     *
     * <code>bool ignore_record_details_in_response = 6;</code>
     *
     * @return The ignoreRecordDetailsInResponse.
     */
    @java.lang.Override
    public boolean getIgnoreRecordDetailsInResponse() {
      return ignoreRecordDetailsInResponse_;
    }
    /**
     *
     *
     * <pre>
     * If true, the response will contain only record ID and score. By default, it
     * is false, the response will contain record details.
     * </pre>
     *
     * <code>bool ignore_record_details_in_response = 6;</code>
     *
     * @param value The ignoreRecordDetailsInResponse to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreRecordDetailsInResponse(boolean value) {

      ignoreRecordDetailsInResponse_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, the response will contain only record ID and score. By default, it
     * is false, the response will contain record details.
     * </pre>
     *
     * <code>bool ignore_record_details_in_response = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnoreRecordDetailsInResponse() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ignoreRecordDetailsInResponse_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUserLabels() {
      if (userLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UserLabelsDefaultEntryHolder.defaultEntry);
      }
      return userLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableUserLabels() {
      if (userLabels_ == null) {
        userLabels_ =
            com.google.protobuf.MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!userLabels_.isMutable()) {
        userLabels_ = userLabels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return userLabels_;
    }

    public int getUserLabelsCount() {
      return internalGetUserLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    @java.lang.Override
    public boolean containsUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetUserLabels().getMap().containsKey(key);
    }
    /** Use {@link #getUserLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
      return getUserLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
      return internalGetUserLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getUserLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearUserLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableUserLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    public Builder removeUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableUserLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableUserLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableUserLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    public Builder putUserLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableUserLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    public Builder putAllUserLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableUserLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.RankRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.RankRequest)
  private static final com.google.cloud.discoveryengine.v1alpha.RankRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1alpha.RankRequest();
  }

  public static com.google.cloud.discoveryengine.v1alpha.RankRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RankRequest> PARSER =
      new com.google.protobuf.AbstractParser<RankRequest>() {
        @java.lang.Override
        public RankRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RankRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RankRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.RankRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
