/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.filestore.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SnapshotName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSTANCE_SNAPSHOT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/instances/{instance}/snapshots/{snapshot}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String instance;
    private final String snapshot;

    @Deprecated
    protected SnapshotName() {
        this.project = null;
        this.location = null;
        this.instance = null;
        this.snapshot = null;
    }

    private SnapshotName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.snapshot = (String)Preconditions.checkNotNull((Object)builder.getSnapshot());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SnapshotName of(String project, String location, String instance, String snapshot) {
        return SnapshotName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setSnapshot(snapshot).build();
    }

    public static String format(String project, String location, String instance, String snapshot) {
        return SnapshotName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setSnapshot(snapshot).build().toString();
    }

    public static SnapshotName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INSTANCE_SNAPSHOT.validatedMatch(formattedString, "SnapshotName.parse: formattedString not in valid format");
        return SnapshotName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("snapshot"));
    }

    public static List<SnapshotName> parseList(List<String> formattedStrings) {
        ArrayList<SnapshotName> list = new ArrayList<SnapshotName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SnapshotName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SnapshotName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SnapshotName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSTANCE_SNAPSHOT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SnapshotName snapshotName = this;
            synchronized (snapshotName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.snapshot != null) {
                        fieldMapBuilder.put((Object)"snapshot", (Object)this.snapshot);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INSTANCE_SNAPSHOT.instantiate(new String[]{"project", this.project, "location", this.location, "instance", this.instance, "snapshot", this.snapshot});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SnapshotName that = (SnapshotName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.snapshot, that.snapshot);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.snapshot);
    }

    public static class Builder {
        private String project;
        private String location;
        private String instance;
        private String snapshot;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getSnapshot() {
            return this.snapshot;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setSnapshot(String snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        private Builder(SnapshotName snapshotName) {
            this.project = snapshotName.project;
            this.location = snapshotName.location;
            this.instance = snapshotName.instance;
            this.snapshot = snapshotName.snapshot;
        }

        public SnapshotName build() {
            return new SnapshotName(this);
        }
    }
}

