/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LogViewName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BUCKET_VIEW = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/buckets/{bucket}/views/{view}");
    private static final PathTemplate ORGANIZATION_LOCATION_BUCKET_VIEW = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/buckets/{bucket}/views/{view}");
    private static final PathTemplate FOLDER_LOCATION_BUCKET_VIEW = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/buckets/{bucket}/views/{view}");
    private static final PathTemplate BILLING_ACCOUNT_LOCATION_BUCKET_VIEW = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}/views/{view}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String bucket;
    private final String view;
    private final String organization;
    private final String folder;
    private final String billingAccount;

    @Deprecated
    protected LogViewName() {
        this.project = null;
        this.location = null;
        this.bucket = null;
        this.view = null;
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
    }

    private LogViewName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.bucket = (String)Preconditions.checkNotNull((Object)builder.getBucket());
        this.view = (String)Preconditions.checkNotNull((Object)builder.getView());
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = PROJECT_LOCATION_BUCKET_VIEW;
    }

    private LogViewName(OrganizationLocationBucketViewBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.bucket = (String)Preconditions.checkNotNull((Object)builder.getBucket());
        this.view = (String)Preconditions.checkNotNull((Object)builder.getView());
        this.project = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = ORGANIZATION_LOCATION_BUCKET_VIEW;
    }

    private LogViewName(FolderLocationBucketViewBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.bucket = (String)Preconditions.checkNotNull((Object)builder.getBucket());
        this.view = (String)Preconditions.checkNotNull((Object)builder.getView());
        this.project = null;
        this.organization = null;
        this.billingAccount = null;
        this.pathTemplate = FOLDER_LOCATION_BUCKET_VIEW;
    }

    private LogViewName(BillingAccountLocationBucketViewBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.bucket = (String)Preconditions.checkNotNull((Object)builder.getBucket());
        this.view = (String)Preconditions.checkNotNull((Object)builder.getView());
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.pathTemplate = BILLING_ACCOUNT_LOCATION_BUCKET_VIEW;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getView() {
        return this.view;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationBucketViewBuilder() {
        return new Builder();
    }

    public static OrganizationLocationBucketViewBuilder newOrganizationLocationBucketViewBuilder() {
        return new OrganizationLocationBucketViewBuilder();
    }

    public static FolderLocationBucketViewBuilder newFolderLocationBucketViewBuilder() {
        return new FolderLocationBucketViewBuilder();
    }

    public static BillingAccountLocationBucketViewBuilder newBillingAccountLocationBucketViewBuilder() {
        return new BillingAccountLocationBucketViewBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LogViewName of(String project, String location, String bucket, String view) {
        return LogViewName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).setView(view).build();
    }

    public static LogViewName ofProjectLocationBucketViewName(String project, String location, String bucket, String view) {
        return LogViewName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).setView(view).build();
    }

    public static LogViewName ofOrganizationLocationBucketViewName(String organization, String location, String bucket, String view) {
        return LogViewName.newOrganizationLocationBucketViewBuilder().setOrganization(organization).setLocation(location).setBucket(bucket).setView(view).build();
    }

    public static LogViewName ofFolderLocationBucketViewName(String folder, String location, String bucket, String view) {
        return LogViewName.newFolderLocationBucketViewBuilder().setFolder(folder).setLocation(location).setBucket(bucket).setView(view).build();
    }

    public static LogViewName ofBillingAccountLocationBucketViewName(String billingAccount, String location, String bucket, String view) {
        return LogViewName.newBillingAccountLocationBucketViewBuilder().setBillingAccount(billingAccount).setLocation(location).setBucket(bucket).setView(view).build();
    }

    public static String format(String project, String location, String bucket, String view) {
        return LogViewName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).setView(view).build().toString();
    }

    public static String formatProjectLocationBucketViewName(String project, String location, String bucket, String view) {
        return LogViewName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).setView(view).build().toString();
    }

    public static String formatOrganizationLocationBucketViewName(String organization, String location, String bucket, String view) {
        return LogViewName.newOrganizationLocationBucketViewBuilder().setOrganization(organization).setLocation(location).setBucket(bucket).setView(view).build().toString();
    }

    public static String formatFolderLocationBucketViewName(String folder, String location, String bucket, String view) {
        return LogViewName.newFolderLocationBucketViewBuilder().setFolder(folder).setLocation(location).setBucket(bucket).setView(view).build().toString();
    }

    public static String formatBillingAccountLocationBucketViewName(String billingAccount, String location, String bucket, String view) {
        return LogViewName.newBillingAccountLocationBucketViewBuilder().setBillingAccount(billingAccount).setLocation(location).setBucket(bucket).setView(view).build().toString();
    }

    public static LogViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_BUCKET_VIEW.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_BUCKET_VIEW.match(formattedString);
            return LogViewName.ofProjectLocationBucketViewName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("bucket"), (String)matchMap.get("view"));
        }
        if (ORGANIZATION_LOCATION_BUCKET_VIEW.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_BUCKET_VIEW.match(formattedString);
            return LogViewName.ofOrganizationLocationBucketViewName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("bucket"), (String)matchMap.get("view"));
        }
        if (FOLDER_LOCATION_BUCKET_VIEW.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_BUCKET_VIEW.match(formattedString);
            return LogViewName.ofFolderLocationBucketViewName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("bucket"), (String)matchMap.get("view"));
        }
        if (BILLING_ACCOUNT_LOCATION_BUCKET_VIEW.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT_LOCATION_BUCKET_VIEW.match(formattedString);
            return LogViewName.ofBillingAccountLocationBucketViewName((String)matchMap.get("billing_account"), (String)matchMap.get("location"), (String)matchMap.get("bucket"), (String)matchMap.get("view"));
        }
        throw new ValidationException("LogViewName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<LogViewName> parseList(List<String> formattedStrings) {
        ArrayList<LogViewName> list = new ArrayList<LogViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LogViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LogViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LogViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BUCKET_VIEW.matches(formattedString) || ORGANIZATION_LOCATION_BUCKET_VIEW.matches(formattedString) || FOLDER_LOCATION_BUCKET_VIEW.matches(formattedString) || BILLING_ACCOUNT_LOCATION_BUCKET_VIEW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LogViewName logViewName = this;
            synchronized (logViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.bucket != null) {
                        fieldMapBuilder.put((Object)"bucket", (Object)this.bucket);
                    }
                    if (this.view != null) {
                        fieldMapBuilder.put((Object)"view", (Object)this.view);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LogViewName that = (LogViewName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.view, that.view) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.bucket);
        h *= 1000003;
        h ^= Objects.hashCode(this.view);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    public static class BillingAccountLocationBucketViewBuilder {
        private String billingAccount;
        private String location;
        private String bucket;
        private String view;

        protected BillingAccountLocationBucketViewBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getView() {
            return this.view;
        }

        public BillingAccountLocationBucketViewBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountLocationBucketViewBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public BillingAccountLocationBucketViewBuilder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public BillingAccountLocationBucketViewBuilder setView(String view) {
            this.view = view;
            return this;
        }

        public LogViewName build() {
            return new LogViewName(this);
        }
    }

    public static class FolderLocationBucketViewBuilder {
        private String folder;
        private String location;
        private String bucket;
        private String view;

        protected FolderLocationBucketViewBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getView() {
            return this.view;
        }

        public FolderLocationBucketViewBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationBucketViewBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationBucketViewBuilder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public FolderLocationBucketViewBuilder setView(String view) {
            this.view = view;
            return this;
        }

        public LogViewName build() {
            return new LogViewName(this);
        }
    }

    public static class OrganizationLocationBucketViewBuilder {
        private String organization;
        private String location;
        private String bucket;
        private String view;

        protected OrganizationLocationBucketViewBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getView() {
            return this.view;
        }

        public OrganizationLocationBucketViewBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationBucketViewBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationBucketViewBuilder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public OrganizationLocationBucketViewBuilder setView(String view) {
            this.view = view;
            return this;
        }

        public LogViewName build() {
            return new LogViewName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String bucket;
        private String view;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getView() {
            return this.view;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder setView(String view) {
            this.view = view;
            return this;
        }

        private Builder(LogViewName logViewName) {
            Preconditions.checkArgument((boolean)Objects.equals(logViewName.pathTemplate, PROJECT_LOCATION_BUCKET_VIEW), (Object)"toBuilder is only supported when LogViewName has the pattern of projects/{project}/locations/{location}/buckets/{bucket}/views/{view}");
            this.project = logViewName.project;
            this.location = logViewName.location;
            this.bucket = logViewName.bucket;
            this.view = logViewName.view;
        }

        public LogViewName build() {
            return new LogViewName(this);
        }
    }
}

