/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/v2/logging_config.proto

// Protobuf Java Version: 3.25.8
package com.google.logging.v2;

/**
 *
 *
 * <pre>
 * Describes a sink used to export log entries to one of the following
 * destinations in any project: a Cloud Storage bucket, a BigQuery dataset, a
 * Pub/Sub topic or a Cloud Logging log bucket. A logs filter controls which log
 * entries are exported. The sink must be created within a project,
 * organization, billing account, or folder.
 * </pre>
 *
 * Protobuf type {@code google.logging.v2.LogSink}
 */
public final class LogSink extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.logging.v2.LogSink)
    LogSinkOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use LogSink.newBuilder() to construct.
  private LogSink(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LogSink() {
    name_ = "";
    destination_ = "";
    filter_ = "";
    description_ = "";
    exclusions_ = java.util.Collections.emptyList();
    outputVersionFormat_ = 0;
    writerIdentity_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LogSink();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_LogSink_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_LogSink_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.logging.v2.LogSink.class, com.google.logging.v2.LogSink.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Deprecated. This is unused.
   * </pre>
   *
   * Protobuf enum {@code google.logging.v2.LogSink.VersionFormat}
   */
  public enum VersionFormat implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * An unspecified format version that will default to V2.
     * </pre>
     *
     * <code>VERSION_FORMAT_UNSPECIFIED = 0;</code>
     */
    VERSION_FORMAT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * `LogEntry` version 2 format.
     * </pre>
     *
     * <code>V2 = 1;</code>
     */
    V2(1),
    /**
     *
     *
     * <pre>
     * `LogEntry` version 1 format.
     * </pre>
     *
     * <code>V1 = 2;</code>
     */
    V1(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * An unspecified format version that will default to V2.
     * </pre>
     *
     * <code>VERSION_FORMAT_UNSPECIFIED = 0;</code>
     */
    public static final int VERSION_FORMAT_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * `LogEntry` version 2 format.
     * </pre>
     *
     * <code>V2 = 1;</code>
     */
    public static final int V2_VALUE = 1;

    /**
     *
     *
     * <pre>
     * `LogEntry` version 1 format.
     * </pre>
     *
     * <code>V1 = 2;</code>
     */
    public static final int V1_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VersionFormat valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VersionFormat forNumber(int value) {
      switch (value) {
        case 0:
          return VERSION_FORMAT_UNSPECIFIED;
        case 1:
          return V2;
        case 2:
          return V1;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VersionFormat> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VersionFormat> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<VersionFormat>() {
          public VersionFormat findValueByNumber(int number) {
            return VersionFormat.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.logging.v2.LogSink.getDescriptor().getEnumTypes().get(0);
    }

    private static final VersionFormat[] VALUES = values();

    public static VersionFormat valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VersionFormat(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.logging.v2.LogSink.VersionFormat)
  }

  private int bitField0_;
  private int optionsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object options_;

  public enum OptionsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BIGQUERY_OPTIONS(12),
    OPTIONS_NOT_SET(0);
    private final int value;

    private OptionsCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OptionsCase valueOf(int value) {
      return forNumber(value);
    }

    public static OptionsCase forNumber(int value) {
      switch (value) {
        case 12:
          return BIGQUERY_OPTIONS;
        case 0:
          return OPTIONS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OptionsCase getOptionsCase() {
    return OptionsCase.forNumber(optionsCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. The client-assigned sink identifier, unique within the project.
   *
   * For example: `"my-syslog-errors-to-pubsub"`. Sink identifiers are limited
   * to 100 characters and can include only the following characters: upper and
   * lower-case alphanumeric characters, underscores, hyphens, and periods.
   * First character has to be alphanumeric.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The client-assigned sink identifier, unique within the project.
   *
   * For example: `"my-syslog-errors-to-pubsub"`. Sink identifiers are limited
   * to 100 characters and can include only the following characters: upper and
   * lower-case alphanumeric characters, underscores, hyphens, and periods.
   * First character has to be alphanumeric.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destination_ = "";

  /**
   *
   *
   * <pre>
   * Required. The export destination:
   *
   *     "storage.googleapis.com/[GCS_BUCKET]"
   *     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
   *     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
   *
   * The sink's `writer_identity`, set when the sink is created, must have
   * permission to write to the destination or else the log entries are not
   * exported. For more information, see
   * [Exporting Logs with
   * Sinks](https://cloud.google.com/logging/docs/api/tasks/exporting-logs).
   * </pre>
   *
   * <code>
   * string destination = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public java.lang.String getDestination() {
    java.lang.Object ref = destination_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destination_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The export destination:
   *
   *     "storage.googleapis.com/[GCS_BUCKET]"
   *     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
   *     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
   *
   * The sink's `writer_identity`, set when the sink is created, must have
   * permission to write to the destination or else the log entries are not
   * exported. For more information, see
   * [Exporting Logs with
   * Sinks](https://cloud.google.com/logging/docs/api/tasks/exporting-logs).
   * </pre>
   *
   * <code>
   * string destination = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for destination.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationBytes() {
    java.lang.Object ref = destination_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destination_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";

  /**
   *
   *
   * <pre>
   * Optional. An [advanced logs
   * filter](https://cloud.google.com/logging/docs/view/advanced-queries). The
   * only exported log entries are those that are in the resource owning the
   * sink and that match the filter.
   *
   * For example:
   *
   *   `logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity&gt;=ERROR`
   * </pre>
   *
   * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. An [advanced logs
   * filter](https://cloud.google.com/logging/docs/view/advanced-queries). The
   * only exported log entries are those that are in the resource owning the
   * sink and that match the filter.
   *
   * For example:
   *
   *   `logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity&gt;=ERROR`
   * </pre>
   *
   * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A description of this sink.
   *
   * The maximum length of the description is 8000 characters.
   * </pre>
   *
   * <code>string description = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A description of this sink.
   *
   * The maximum length of the description is 8000 characters.
   * </pre>
   *
   * <code>string description = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLED_FIELD_NUMBER = 19;
  private boolean disabled_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If set to true, then this sink is disabled and it does not export
   * any log entries.
   * </pre>
   *
   * <code>bool disabled = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int EXCLUSIONS_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private java.util.List<com.google.logging.v2.LogExclusion> exclusions_;

  /**
   *
   *
   * <pre>
   * Optional. Log entries that match any of these exclusion filters will not be
   * exported.
   *
   * If a log entry is matched by both `filter` and one of `exclusion_filters`
   * it will not be exported.
   * </pre>
   *
   * <code>
   * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.logging.v2.LogExclusion> getExclusionsList() {
    return exclusions_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Log entries that match any of these exclusion filters will not be
   * exported.
   *
   * If a log entry is matched by both `filter` and one of `exclusion_filters`
   * it will not be exported.
   * </pre>
   *
   * <code>
   * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.logging.v2.LogExclusionOrBuilder>
      getExclusionsOrBuilderList() {
    return exclusions_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Log entries that match any of these exclusion filters will not be
   * exported.
   *
   * If a log entry is matched by both `filter` and one of `exclusion_filters`
   * it will not be exported.
   * </pre>
   *
   * <code>
   * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getExclusionsCount() {
    return exclusions_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Log entries that match any of these exclusion filters will not be
   * exported.
   *
   * If a log entry is matched by both `filter` and one of `exclusion_filters`
   * it will not be exported.
   * </pre>
   *
   * <code>
   * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.logging.v2.LogExclusion getExclusions(int index) {
    return exclusions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Log entries that match any of these exclusion filters will not be
   * exported.
   *
   * If a log entry is matched by both `filter` and one of `exclusion_filters`
   * it will not be exported.
   * </pre>
   *
   * <code>
   * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.logging.v2.LogExclusionOrBuilder getExclusionsOrBuilder(int index) {
    return exclusions_.get(index);
  }

  public static final int OUTPUT_VERSION_FORMAT_FIELD_NUMBER = 6;
  private int outputVersionFormat_ = 0;

  /**
   *
   *
   * <pre>
   * Deprecated. This field is unused.
   * </pre>
   *
   * <code>.google.logging.v2.LogSink.VersionFormat output_version_format = 6 [deprecated = true];
   * </code>
   *
   * @deprecated google.logging.v2.LogSink.output_version_format is deprecated. See
   *     google/logging/v2/logging_config.proto;l=1000
   * @return The enum numeric value on the wire for outputVersionFormat.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getOutputVersionFormatValue() {
    return outputVersionFormat_;
  }

  /**
   *
   *
   * <pre>
   * Deprecated. This field is unused.
   * </pre>
   *
   * <code>.google.logging.v2.LogSink.VersionFormat output_version_format = 6 [deprecated = true];
   * </code>
   *
   * @deprecated google.logging.v2.LogSink.output_version_format is deprecated. See
   *     google/logging/v2/logging_config.proto;l=1000
   * @return The outputVersionFormat.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.logging.v2.LogSink.VersionFormat getOutputVersionFormat() {
    com.google.logging.v2.LogSink.VersionFormat result =
        com.google.logging.v2.LogSink.VersionFormat.forNumber(outputVersionFormat_);
    return result == null ? com.google.logging.v2.LogSink.VersionFormat.UNRECOGNIZED : result;
  }

  public static final int WRITER_IDENTITY_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object writerIdentity_ = "";

  /**
   *
   *
   * <pre>
   * Output only. An IAM identity&amp;mdash;a service account or group&amp;mdash;under
   * which Cloud Logging writes the exported log entries to the sink's
   * destination. This field is either set by specifying
   * `custom_writer_identity` or set automatically by
   * [sinks.create][google.logging.v2.ConfigServiceV2.CreateSink] and
   * [sinks.update][google.logging.v2.ConfigServiceV2.UpdateSink] based on the
   * value of `unique_writer_identity` in those methods.
   *
   * Until you grant this identity write-access to the destination, log entry
   * exports from this sink will fail. For more information, see [Granting
   * Access for a
   * Resource](https://cloud.google.com/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
   * Consult the destination service's documentation to determine the
   * appropriate IAM roles to assign to the identity.
   *
   * Sinks that have a destination that is a log bucket in the same project as
   * the sink cannot have a writer_identity and no additional permissions are
   * required.
   * </pre>
   *
   * <code>string writer_identity = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The writerIdentity.
   */
  @java.lang.Override
  public java.lang.String getWriterIdentity() {
    java.lang.Object ref = writerIdentity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      writerIdentity_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. An IAM identity&amp;mdash;a service account or group&amp;mdash;under
   * which Cloud Logging writes the exported log entries to the sink's
   * destination. This field is either set by specifying
   * `custom_writer_identity` or set automatically by
   * [sinks.create][google.logging.v2.ConfigServiceV2.CreateSink] and
   * [sinks.update][google.logging.v2.ConfigServiceV2.UpdateSink] based on the
   * value of `unique_writer_identity` in those methods.
   *
   * Until you grant this identity write-access to the destination, log entry
   * exports from this sink will fail. For more information, see [Granting
   * Access for a
   * Resource](https://cloud.google.com/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
   * Consult the destination service's documentation to determine the
   * appropriate IAM roles to assign to the identity.
   *
   * Sinks that have a destination that is a log bucket in the same project as
   * the sink cannot have a writer_identity and no additional permissions are
   * required.
   * </pre>
   *
   * <code>string writer_identity = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for writerIdentity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWriterIdentityBytes() {
    java.lang.Object ref = writerIdentity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      writerIdentity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INCLUDE_CHILDREN_FIELD_NUMBER = 9;
  private boolean includeChildren_ = false;

  /**
   *
   *
   * <pre>
   * Optional. This field applies only to sinks owned by organizations and
   * folders. If the field is false, the default, only the logs owned by the
   * sink's parent resource are available for export. If the field is true, then
   * log entries from all the projects, folders, and billing accounts contained
   * in the sink's parent resource are also available for export. Whether a
   * particular log entry from the children is exported depends on the sink's
   * filter expression.
   *
   * For example, if this field is true, then the filter
   * `resource.type=gce_instance` would export all Compute Engine VM instance
   * log entries from all projects in the sink's parent.
   *
   * To only export entries from certain child projects, filter on the project
   * part of the log name:
   *
   *   logName:("projects/test-project1/" OR "projects/test-project2/") AND
   *   resource.type=gce_instance
   * </pre>
   *
   * <code>bool include_children = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The includeChildren.
   */
  @java.lang.Override
  public boolean getIncludeChildren() {
    return includeChildren_;
  }

  public static final int BIGQUERY_OPTIONS_FIELD_NUMBER = 12;

  /**
   *
   *
   * <pre>
   * Optional. Options that affect sinks exporting data to BigQuery.
   * </pre>
   *
   * <code>
   * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the bigqueryOptions field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryOptions() {
    return optionsCase_ == 12;
  }

  /**
   *
   *
   * <pre>
   * Optional. Options that affect sinks exporting data to BigQuery.
   * </pre>
   *
   * <code>
   * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bigqueryOptions.
   */
  @java.lang.Override
  public com.google.logging.v2.BigQueryOptions getBigqueryOptions() {
    if (optionsCase_ == 12) {
      return (com.google.logging.v2.BigQueryOptions) options_;
    }
    return com.google.logging.v2.BigQueryOptions.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Options that affect sinks exporting data to BigQuery.
   * </pre>
   *
   * <code>
   * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.logging.v2.BigQueryOptionsOrBuilder getBigqueryOptionsOrBuilder() {
    if (optionsCase_ == 12) {
      return (com.google.logging.v2.BigQueryOptions) options_;
    }
    return com.google.logging.v2.BigQueryOptions.getDefaultInstance();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the sink.
   *
   * This field may not be present for older sinks.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the sink.
   *
   * This field may not be present for older sinks.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the sink.
   *
   * This field may not be present for older sinks.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the sink.
   *
   * This field may not be present for older sinks.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the sink.
   *
   * This field may not be present for older sinks.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the sink.
   *
   * This field may not be present for older sinks.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destination_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, filter_);
    }
    if (outputVersionFormat_
        != com.google.logging.v2.LogSink.VersionFormat.VERSION_FORMAT_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, outputVersionFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(writerIdentity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, writerIdentity_);
    }
    if (includeChildren_ != false) {
      output.writeBool(9, includeChildren_);
    }
    if (optionsCase_ == 12) {
      output.writeMessage(12, (com.google.logging.v2.BigQueryOptions) options_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(13, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(14, getUpdateTime());
    }
    for (int i = 0; i < exclusions_.size(); i++) {
      output.writeMessage(16, exclusions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, description_);
    }
    if (disabled_ != false) {
      output.writeBool(19, disabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destination_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, filter_);
    }
    if (outputVersionFormat_
        != com.google.logging.v2.LogSink.VersionFormat.VERSION_FORMAT_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, outputVersionFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(writerIdentity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, writerIdentity_);
    }
    if (includeChildren_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, includeChildren_);
    }
    if (optionsCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.logging.v2.BigQueryOptions) options_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getUpdateTime());
    }
    for (int i = 0; i < exclusions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, exclusions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, description_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(19, disabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.logging.v2.LogSink)) {
      return super.equals(obj);
    }
    com.google.logging.v2.LogSink other = (com.google.logging.v2.LogSink) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDestination().equals(other.getDestination())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getDisabled() != other.getDisabled()) return false;
    if (!getExclusionsList().equals(other.getExclusionsList())) return false;
    if (outputVersionFormat_ != other.outputVersionFormat_) return false;
    if (!getWriterIdentity().equals(other.getWriterIdentity())) return false;
    if (getIncludeChildren() != other.getIncludeChildren()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getOptionsCase().equals(other.getOptionsCase())) return false;
    switch (optionsCase_) {
      case 12:
        if (!getBigqueryOptions().equals(other.getBigqueryOptions())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
    hash = (53 * hash) + getDestination().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    if (getExclusionsCount() > 0) {
      hash = (37 * hash) + EXCLUSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExclusionsList().hashCode();
    }
    hash = (37 * hash) + OUTPUT_VERSION_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + outputVersionFormat_;
    hash = (37 * hash) + WRITER_IDENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getWriterIdentity().hashCode();
    hash = (37 * hash) + INCLUDE_CHILDREN_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeChildren());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    switch (optionsCase_) {
      case 12:
        hash = (37 * hash) + BIGQUERY_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryOptions().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.logging.v2.LogSink parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogSink parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogSink parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogSink parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogSink parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogSink parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogSink parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogSink parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.LogSink parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogSink parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.LogSink parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogSink parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.logging.v2.LogSink prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Describes a sink used to export log entries to one of the following
   * destinations in any project: a Cloud Storage bucket, a BigQuery dataset, a
   * Pub/Sub topic or a Cloud Logging log bucket. A logs filter controls which log
   * entries are exported. The sink must be created within a project,
   * organization, billing account, or folder.
   * </pre>
   *
   * Protobuf type {@code google.logging.v2.LogSink}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.logging.v2.LogSink)
      com.google.logging.v2.LogSinkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_LogSink_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_LogSink_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.logging.v2.LogSink.class, com.google.logging.v2.LogSink.Builder.class);
    }

    // Construct using com.google.logging.v2.LogSink.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExclusionsFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      destination_ = "";
      filter_ = "";
      description_ = "";
      disabled_ = false;
      if (exclusionsBuilder_ == null) {
        exclusions_ = java.util.Collections.emptyList();
      } else {
        exclusions_ = null;
        exclusionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      outputVersionFormat_ = 0;
      writerIdentity_ = "";
      includeChildren_ = false;
      if (bigqueryOptionsBuilder_ != null) {
        bigqueryOptionsBuilder_.clear();
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      optionsCase_ = 0;
      options_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_LogSink_descriptor;
    }

    @java.lang.Override
    public com.google.logging.v2.LogSink getDefaultInstanceForType() {
      return com.google.logging.v2.LogSink.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.logging.v2.LogSink build() {
      com.google.logging.v2.LogSink result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.logging.v2.LogSink buildPartial() {
      com.google.logging.v2.LogSink result = new com.google.logging.v2.LogSink(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.logging.v2.LogSink result) {
      if (exclusionsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          exclusions_ = java.util.Collections.unmodifiableList(exclusions_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.exclusions_ = exclusions_;
      } else {
        result.exclusions_ = exclusionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.logging.v2.LogSink result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.destination_ = destination_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.disabled_ = disabled_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.outputVersionFormat_ = outputVersionFormat_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.writerIdentity_ = writerIdentity_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.includeChildren_ = includeChildren_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.logging.v2.LogSink result) {
      result.optionsCase_ = optionsCase_;
      result.options_ = this.options_;
      if (optionsCase_ == 12 && bigqueryOptionsBuilder_ != null) {
        result.options_ = bigqueryOptionsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.logging.v2.LogSink) {
        return mergeFrom((com.google.logging.v2.LogSink) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.logging.v2.LogSink other) {
      if (other == com.google.logging.v2.LogSink.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDestination().isEmpty()) {
        destination_ = other.destination_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      if (exclusionsBuilder_ == null) {
        if (!other.exclusions_.isEmpty()) {
          if (exclusions_.isEmpty()) {
            exclusions_ = other.exclusions_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureExclusionsIsMutable();
            exclusions_.addAll(other.exclusions_);
          }
          onChanged();
        }
      } else {
        if (!other.exclusions_.isEmpty()) {
          if (exclusionsBuilder_.isEmpty()) {
            exclusionsBuilder_.dispose();
            exclusionsBuilder_ = null;
            exclusions_ = other.exclusions_;
            bitField0_ = (bitField0_ & ~0x00000020);
            exclusionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExclusionsFieldBuilder()
                    : null;
          } else {
            exclusionsBuilder_.addAllMessages(other.exclusions_);
          }
        }
      }
      if (other.outputVersionFormat_ != 0) {
        setOutputVersionFormatValue(other.getOutputVersionFormatValue());
      }
      if (!other.getWriterIdentity().isEmpty()) {
        writerIdentity_ = other.writerIdentity_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.getIncludeChildren() != false) {
        setIncludeChildren(other.getIncludeChildren());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      switch (other.getOptionsCase()) {
        case BIGQUERY_OPTIONS:
          {
            mergeBigqueryOptions(other.getBigqueryOptions());
            break;
          }
        case OPTIONS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                destination_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 42:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 48:
              {
                outputVersionFormat_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 48
            case 66:
              {
                writerIdentity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                includeChildren_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 98:
              {
                input.readMessage(getBigqueryOptionsFieldBuilder().getBuilder(), extensionRegistry);
                optionsCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 114
            case 130:
              {
                com.google.logging.v2.LogExclusion m =
                    input.readMessage(
                        com.google.logging.v2.LogExclusion.parser(), extensionRegistry);
                if (exclusionsBuilder_ == null) {
                  ensureExclusionsIsMutable();
                  exclusions_.add(m);
                } else {
                  exclusionsBuilder_.addMessage(m);
                }
                break;
              } // case 130
            case 146:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 146
            case 152:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 152
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int optionsCase_ = 0;
    private java.lang.Object options_;

    public OptionsCase getOptionsCase() {
      return OptionsCase.forNumber(optionsCase_);
    }

    public Builder clearOptions() {
      optionsCase_ = 0;
      options_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. The client-assigned sink identifier, unique within the project.
     *
     * For example: `"my-syslog-errors-to-pubsub"`. Sink identifiers are limited
     * to 100 characters and can include only the following characters: upper and
     * lower-case alphanumeric characters, underscores, hyphens, and periods.
     * First character has to be alphanumeric.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The client-assigned sink identifier, unique within the project.
     *
     * For example: `"my-syslog-errors-to-pubsub"`. Sink identifiers are limited
     * to 100 characters and can include only the following characters: upper and
     * lower-case alphanumeric characters, underscores, hyphens, and periods.
     * First character has to be alphanumeric.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The client-assigned sink identifier, unique within the project.
     *
     * For example: `"my-syslog-errors-to-pubsub"`. Sink identifiers are limited
     * to 100 characters and can include only the following characters: upper and
     * lower-case alphanumeric characters, underscores, hyphens, and periods.
     * First character has to be alphanumeric.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The client-assigned sink identifier, unique within the project.
     *
     * For example: `"my-syslog-errors-to-pubsub"`. Sink identifiers are limited
     * to 100 characters and can include only the following characters: upper and
     * lower-case alphanumeric characters, underscores, hyphens, and periods.
     * First character has to be alphanumeric.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The client-assigned sink identifier, unique within the project.
     *
     * For example: `"my-syslog-errors-to-pubsub"`. Sink identifiers are limited
     * to 100 characters and can include only the following characters: upper and
     * lower-case alphanumeric characters, underscores, hyphens, and periods.
     * First character has to be alphanumeric.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object destination_ = "";

    /**
     *
     *
     * <pre>
     * Required. The export destination:
     *
     *     "storage.googleapis.com/[GCS_BUCKET]"
     *     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
     *     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
     *
     * The sink's `writer_identity`, set when the sink is created, must have
     * permission to write to the destination or else the log entries are not
     * exported. For more information, see
     * [Exporting Logs with
     * Sinks](https://cloud.google.com/logging/docs/api/tasks/exporting-logs).
     * </pre>
     *
     * <code>
     * string destination = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The destination.
     */
    public java.lang.String getDestination() {
      java.lang.Object ref = destination_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destination_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The export destination:
     *
     *     "storage.googleapis.com/[GCS_BUCKET]"
     *     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
     *     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
     *
     * The sink's `writer_identity`, set when the sink is created, must have
     * permission to write to the destination or else the log entries are not
     * exported. For more information, see
     * [Exporting Logs with
     * Sinks](https://cloud.google.com/logging/docs/api/tasks/exporting-logs).
     * </pre>
     *
     * <code>
     * string destination = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for destination.
     */
    public com.google.protobuf.ByteString getDestinationBytes() {
      java.lang.Object ref = destination_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destination_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The export destination:
     *
     *     "storage.googleapis.com/[GCS_BUCKET]"
     *     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
     *     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
     *
     * The sink's `writer_identity`, set when the sink is created, must have
     * permission to write to the destination or else the log entries are not
     * exported. For more information, see
     * [Exporting Logs with
     * Sinks](https://cloud.google.com/logging/docs/api/tasks/exporting-logs).
     * </pre>
     *
     * <code>
     * string destination = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The destination to set.
     * @return This builder for chaining.
     */
    public Builder setDestination(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destination_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The export destination:
     *
     *     "storage.googleapis.com/[GCS_BUCKET]"
     *     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
     *     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
     *
     * The sink's `writer_identity`, set when the sink is created, must have
     * permission to write to the destination or else the log entries are not
     * exported. For more information, see
     * [Exporting Logs with
     * Sinks](https://cloud.google.com/logging/docs/api/tasks/exporting-logs).
     * </pre>
     *
     * <code>
     * string destination = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestination() {
      destination_ = getDefaultInstance().getDestination();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The export destination:
     *
     *     "storage.googleapis.com/[GCS_BUCKET]"
     *     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
     *     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
     *
     * The sink's `writer_identity`, set when the sink is created, must have
     * permission to write to the destination or else the log entries are not
     * exported. For more information, see
     * [Exporting Logs with
     * Sinks](https://cloud.google.com/logging/docs/api/tasks/exporting-logs).
     * </pre>
     *
     * <code>
     * string destination = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for destination to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destination_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * Optional. An [advanced logs
     * filter](https://cloud.google.com/logging/docs/view/advanced-queries). The
     * only exported log entries are those that are in the resource owning the
     * sink and that match the filter.
     *
     * For example:
     *
     *   `logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity&gt;=ERROR`
     * </pre>
     *
     * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An [advanced logs
     * filter](https://cloud.google.com/logging/docs/view/advanced-queries). The
     * only exported log entries are those that are in the resource owning the
     * sink and that match the filter.
     *
     * For example:
     *
     *   `logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity&gt;=ERROR`
     * </pre>
     *
     * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An [advanced logs
     * filter](https://cloud.google.com/logging/docs/view/advanced-queries). The
     * only exported log entries are those that are in the resource owning the
     * sink and that match the filter.
     *
     * For example:
     *
     *   `logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity&gt;=ERROR`
     * </pre>
     *
     * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An [advanced logs
     * filter](https://cloud.google.com/logging/docs/view/advanced-queries). The
     * only exported log entries are those that are in the resource owning the
     * sink and that match the filter.
     *
     * For example:
     *
     *   `logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity&gt;=ERROR`
     * </pre>
     *
     * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An [advanced logs
     * filter](https://cloud.google.com/logging/docs/view/advanced-queries). The
     * only exported log entries are those that are in the resource owning the
     * sink and that match the filter.
     *
     * For example:
     *
     *   `logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity&gt;=ERROR`
     * </pre>
     *
     * <code>string filter = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A description of this sink.
     *
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A description of this sink.
     *
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A description of this sink.
     *
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A description of this sink.
     *
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A description of this sink.
     *
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean disabled_;

    /**
     *
     *
     * <pre>
     * Optional. If set to true, then this sink is disabled and it does not export
     * any log entries.
     * </pre>
     *
     * <code>bool disabled = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set to true, then this sink is disabled and it does not export
     * any log entries.
     * </pre>
     *
     * <code>bool disabled = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set to true, then this sink is disabled and it does not export
     * any log entries.
     * </pre>
     *
     * <code>bool disabled = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000010);
      disabled_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.logging.v2.LogExclusion> exclusions_ =
        java.util.Collections.emptyList();

    private void ensureExclusionsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        exclusions_ = new java.util.ArrayList<com.google.logging.v2.LogExclusion>(exclusions_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.logging.v2.LogExclusion,
            com.google.logging.v2.LogExclusion.Builder,
            com.google.logging.v2.LogExclusionOrBuilder>
        exclusionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.logging.v2.LogExclusion> getExclusionsList() {
      if (exclusionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(exclusions_);
      } else {
        return exclusionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getExclusionsCount() {
      if (exclusionsBuilder_ == null) {
        return exclusions_.size();
      } else {
        return exclusionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.LogExclusion getExclusions(int index) {
      if (exclusionsBuilder_ == null) {
        return exclusions_.get(index);
      } else {
        return exclusionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExclusions(int index, com.google.logging.v2.LogExclusion value) {
      if (exclusionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusionsIsMutable();
        exclusions_.set(index, value);
        onChanged();
      } else {
        exclusionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExclusions(
        int index, com.google.logging.v2.LogExclusion.Builder builderForValue) {
      if (exclusionsBuilder_ == null) {
        ensureExclusionsIsMutable();
        exclusions_.set(index, builderForValue.build());
        onChanged();
      } else {
        exclusionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addExclusions(com.google.logging.v2.LogExclusion value) {
      if (exclusionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusionsIsMutable();
        exclusions_.add(value);
        onChanged();
      } else {
        exclusionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addExclusions(int index, com.google.logging.v2.LogExclusion value) {
      if (exclusionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusionsIsMutable();
        exclusions_.add(index, value);
        onChanged();
      } else {
        exclusionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addExclusions(com.google.logging.v2.LogExclusion.Builder builderForValue) {
      if (exclusionsBuilder_ == null) {
        ensureExclusionsIsMutable();
        exclusions_.add(builderForValue.build());
        onChanged();
      } else {
        exclusionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addExclusions(
        int index, com.google.logging.v2.LogExclusion.Builder builderForValue) {
      if (exclusionsBuilder_ == null) {
        ensureExclusionsIsMutable();
        exclusions_.add(index, builderForValue.build());
        onChanged();
      } else {
        exclusionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllExclusions(
        java.lang.Iterable<? extends com.google.logging.v2.LogExclusion> values) {
      if (exclusionsBuilder_ == null) {
        ensureExclusionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exclusions_);
        onChanged();
      } else {
        exclusionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearExclusions() {
      if (exclusionsBuilder_ == null) {
        exclusions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        exclusionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeExclusions(int index) {
      if (exclusionsBuilder_ == null) {
        ensureExclusionsIsMutable();
        exclusions_.remove(index);
        onChanged();
      } else {
        exclusionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.LogExclusion.Builder getExclusionsBuilder(int index) {
      return getExclusionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.LogExclusionOrBuilder getExclusionsOrBuilder(int index) {
      if (exclusionsBuilder_ == null) {
        return exclusions_.get(index);
      } else {
        return exclusionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.logging.v2.LogExclusionOrBuilder>
        getExclusionsOrBuilderList() {
      if (exclusionsBuilder_ != null) {
        return exclusionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(exclusions_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.LogExclusion.Builder addExclusionsBuilder() {
      return getExclusionsFieldBuilder()
          .addBuilder(com.google.logging.v2.LogExclusion.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.LogExclusion.Builder addExclusionsBuilder(int index) {
      return getExclusionsFieldBuilder()
          .addBuilder(index, com.google.logging.v2.LogExclusion.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Log entries that match any of these exclusion filters will not be
     * exported.
     *
     * If a log entry is matched by both `filter` and one of `exclusion_filters`
     * it will not be exported.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.LogExclusion exclusions = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.logging.v2.LogExclusion.Builder> getExclusionsBuilderList() {
      return getExclusionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.logging.v2.LogExclusion,
            com.google.logging.v2.LogExclusion.Builder,
            com.google.logging.v2.LogExclusionOrBuilder>
        getExclusionsFieldBuilder() {
      if (exclusionsBuilder_ == null) {
        exclusionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.logging.v2.LogExclusion,
                com.google.logging.v2.LogExclusion.Builder,
                com.google.logging.v2.LogExclusionOrBuilder>(
                exclusions_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        exclusions_ = null;
      }
      return exclusionsBuilder_;
    }

    private int outputVersionFormat_ = 0;

    /**
     *
     *
     * <pre>
     * Deprecated. This field is unused.
     * </pre>
     *
     * <code>.google.logging.v2.LogSink.VersionFormat output_version_format = 6 [deprecated = true];
     * </code>
     *
     * @deprecated google.logging.v2.LogSink.output_version_format is deprecated. See
     *     google/logging/v2/logging_config.proto;l=1000
     * @return The enum numeric value on the wire for outputVersionFormat.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getOutputVersionFormatValue() {
      return outputVersionFormat_;
    }

    /**
     *
     *
     * <pre>
     * Deprecated. This field is unused.
     * </pre>
     *
     * <code>.google.logging.v2.LogSink.VersionFormat output_version_format = 6 [deprecated = true];
     * </code>
     *
     * @deprecated google.logging.v2.LogSink.output_version_format is deprecated. See
     *     google/logging/v2/logging_config.proto;l=1000
     * @param value The enum numeric value on the wire for outputVersionFormat to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setOutputVersionFormatValue(int value) {
      outputVersionFormat_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated. This field is unused.
     * </pre>
     *
     * <code>.google.logging.v2.LogSink.VersionFormat output_version_format = 6 [deprecated = true];
     * </code>
     *
     * @deprecated google.logging.v2.LogSink.output_version_format is deprecated. See
     *     google/logging/v2/logging_config.proto;l=1000
     * @return The outputVersionFormat.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.logging.v2.LogSink.VersionFormat getOutputVersionFormat() {
      com.google.logging.v2.LogSink.VersionFormat result =
          com.google.logging.v2.LogSink.VersionFormat.forNumber(outputVersionFormat_);
      return result == null ? com.google.logging.v2.LogSink.VersionFormat.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Deprecated. This field is unused.
     * </pre>
     *
     * <code>.google.logging.v2.LogSink.VersionFormat output_version_format = 6 [deprecated = true];
     * </code>
     *
     * @deprecated google.logging.v2.LogSink.output_version_format is deprecated. See
     *     google/logging/v2/logging_config.proto;l=1000
     * @param value The outputVersionFormat to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setOutputVersionFormat(com.google.logging.v2.LogSink.VersionFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      outputVersionFormat_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated. This field is unused.
     * </pre>
     *
     * <code>.google.logging.v2.LogSink.VersionFormat output_version_format = 6 [deprecated = true];
     * </code>
     *
     * @deprecated google.logging.v2.LogSink.output_version_format is deprecated. See
     *     google/logging/v2/logging_config.proto;l=1000
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearOutputVersionFormat() {
      bitField0_ = (bitField0_ & ~0x00000040);
      outputVersionFormat_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object writerIdentity_ = "";

    /**
     *
     *
     * <pre>
     * Output only. An IAM identity&amp;mdash;a service account or group&amp;mdash;under
     * which Cloud Logging writes the exported log entries to the sink's
     * destination. This field is either set by specifying
     * `custom_writer_identity` or set automatically by
     * [sinks.create][google.logging.v2.ConfigServiceV2.CreateSink] and
     * [sinks.update][google.logging.v2.ConfigServiceV2.UpdateSink] based on the
     * value of `unique_writer_identity` in those methods.
     *
     * Until you grant this identity write-access to the destination, log entry
     * exports from this sink will fail. For more information, see [Granting
     * Access for a
     * Resource](https://cloud.google.com/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
     * Consult the destination service's documentation to determine the
     * appropriate IAM roles to assign to the identity.
     *
     * Sinks that have a destination that is a log bucket in the same project as
     * the sink cannot have a writer_identity and no additional permissions are
     * required.
     * </pre>
     *
     * <code>string writer_identity = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The writerIdentity.
     */
    public java.lang.String getWriterIdentity() {
      java.lang.Object ref = writerIdentity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        writerIdentity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. An IAM identity&amp;mdash;a service account or group&amp;mdash;under
     * which Cloud Logging writes the exported log entries to the sink's
     * destination. This field is either set by specifying
     * `custom_writer_identity` or set automatically by
     * [sinks.create][google.logging.v2.ConfigServiceV2.CreateSink] and
     * [sinks.update][google.logging.v2.ConfigServiceV2.UpdateSink] based on the
     * value of `unique_writer_identity` in those methods.
     *
     * Until you grant this identity write-access to the destination, log entry
     * exports from this sink will fail. For more information, see [Granting
     * Access for a
     * Resource](https://cloud.google.com/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
     * Consult the destination service's documentation to determine the
     * appropriate IAM roles to assign to the identity.
     *
     * Sinks that have a destination that is a log bucket in the same project as
     * the sink cannot have a writer_identity and no additional permissions are
     * required.
     * </pre>
     *
     * <code>string writer_identity = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for writerIdentity.
     */
    public com.google.protobuf.ByteString getWriterIdentityBytes() {
      java.lang.Object ref = writerIdentity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        writerIdentity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. An IAM identity&amp;mdash;a service account or group&amp;mdash;under
     * which Cloud Logging writes the exported log entries to the sink's
     * destination. This field is either set by specifying
     * `custom_writer_identity` or set automatically by
     * [sinks.create][google.logging.v2.ConfigServiceV2.CreateSink] and
     * [sinks.update][google.logging.v2.ConfigServiceV2.UpdateSink] based on the
     * value of `unique_writer_identity` in those methods.
     *
     * Until you grant this identity write-access to the destination, log entry
     * exports from this sink will fail. For more information, see [Granting
     * Access for a
     * Resource](https://cloud.google.com/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
     * Consult the destination service's documentation to determine the
     * appropriate IAM roles to assign to the identity.
     *
     * Sinks that have a destination that is a log bucket in the same project as
     * the sink cannot have a writer_identity and no additional permissions are
     * required.
     * </pre>
     *
     * <code>string writer_identity = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The writerIdentity to set.
     * @return This builder for chaining.
     */
    public Builder setWriterIdentity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      writerIdentity_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. An IAM identity&amp;mdash;a service account or group&amp;mdash;under
     * which Cloud Logging writes the exported log entries to the sink's
     * destination. This field is either set by specifying
     * `custom_writer_identity` or set automatically by
     * [sinks.create][google.logging.v2.ConfigServiceV2.CreateSink] and
     * [sinks.update][google.logging.v2.ConfigServiceV2.UpdateSink] based on the
     * value of `unique_writer_identity` in those methods.
     *
     * Until you grant this identity write-access to the destination, log entry
     * exports from this sink will fail. For more information, see [Granting
     * Access for a
     * Resource](https://cloud.google.com/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
     * Consult the destination service's documentation to determine the
     * appropriate IAM roles to assign to the identity.
     *
     * Sinks that have a destination that is a log bucket in the same project as
     * the sink cannot have a writer_identity and no additional permissions are
     * required.
     * </pre>
     *
     * <code>string writer_identity = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWriterIdentity() {
      writerIdentity_ = getDefaultInstance().getWriterIdentity();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. An IAM identity&amp;mdash;a service account or group&amp;mdash;under
     * which Cloud Logging writes the exported log entries to the sink's
     * destination. This field is either set by specifying
     * `custom_writer_identity` or set automatically by
     * [sinks.create][google.logging.v2.ConfigServiceV2.CreateSink] and
     * [sinks.update][google.logging.v2.ConfigServiceV2.UpdateSink] based on the
     * value of `unique_writer_identity` in those methods.
     *
     * Until you grant this identity write-access to the destination, log entry
     * exports from this sink will fail. For more information, see [Granting
     * Access for a
     * Resource](https://cloud.google.com/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
     * Consult the destination service's documentation to determine the
     * appropriate IAM roles to assign to the identity.
     *
     * Sinks that have a destination that is a log bucket in the same project as
     * the sink cannot have a writer_identity and no additional permissions are
     * required.
     * </pre>
     *
     * <code>string writer_identity = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for writerIdentity to set.
     * @return This builder for chaining.
     */
    public Builder setWriterIdentityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      writerIdentity_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private boolean includeChildren_;

    /**
     *
     *
     * <pre>
     * Optional. This field applies only to sinks owned by organizations and
     * folders. If the field is false, the default, only the logs owned by the
     * sink's parent resource are available for export. If the field is true, then
     * log entries from all the projects, folders, and billing accounts contained
     * in the sink's parent resource are also available for export. Whether a
     * particular log entry from the children is exported depends on the sink's
     * filter expression.
     *
     * For example, if this field is true, then the filter
     * `resource.type=gce_instance` would export all Compute Engine VM instance
     * log entries from all projects in the sink's parent.
     *
     * To only export entries from certain child projects, filter on the project
     * part of the log name:
     *
     *   logName:("projects/test-project1/" OR "projects/test-project2/") AND
     *   resource.type=gce_instance
     * </pre>
     *
     * <code>bool include_children = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The includeChildren.
     */
    @java.lang.Override
    public boolean getIncludeChildren() {
      return includeChildren_;
    }

    /**
     *
     *
     * <pre>
     * Optional. This field applies only to sinks owned by organizations and
     * folders. If the field is false, the default, only the logs owned by the
     * sink's parent resource are available for export. If the field is true, then
     * log entries from all the projects, folders, and billing accounts contained
     * in the sink's parent resource are also available for export. Whether a
     * particular log entry from the children is exported depends on the sink's
     * filter expression.
     *
     * For example, if this field is true, then the filter
     * `resource.type=gce_instance` would export all Compute Engine VM instance
     * log entries from all projects in the sink's parent.
     *
     * To only export entries from certain child projects, filter on the project
     * part of the log name:
     *
     *   logName:("projects/test-project1/" OR "projects/test-project2/") AND
     *   resource.type=gce_instance
     * </pre>
     *
     * <code>bool include_children = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The includeChildren to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeChildren(boolean value) {

      includeChildren_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. This field applies only to sinks owned by organizations and
     * folders. If the field is false, the default, only the logs owned by the
     * sink's parent resource are available for export. If the field is true, then
     * log entries from all the projects, folders, and billing accounts contained
     * in the sink's parent resource are also available for export. Whether a
     * particular log entry from the children is exported depends on the sink's
     * filter expression.
     *
     * For example, if this field is true, then the filter
     * `resource.type=gce_instance` would export all Compute Engine VM instance
     * log entries from all projects in the sink's parent.
     *
     * To only export entries from certain child projects, filter on the project
     * part of the log name:
     *
     *   logName:("projects/test-project1/" OR "projects/test-project2/") AND
     *   resource.type=gce_instance
     * </pre>
     *
     * <code>bool include_children = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeChildren() {
      bitField0_ = (bitField0_ & ~0x00000100);
      includeChildren_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.BigQueryOptions,
            com.google.logging.v2.BigQueryOptions.Builder,
            com.google.logging.v2.BigQueryOptionsOrBuilder>
        bigqueryOptionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Options that affect sinks exporting data to BigQuery.
     * </pre>
     *
     * <code>
     * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the bigqueryOptions field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryOptions() {
      return optionsCase_ == 12;
    }

    /**
     *
     *
     * <pre>
     * Optional. Options that affect sinks exporting data to BigQuery.
     * </pre>
     *
     * <code>
     * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bigqueryOptions.
     */
    @java.lang.Override
    public com.google.logging.v2.BigQueryOptions getBigqueryOptions() {
      if (bigqueryOptionsBuilder_ == null) {
        if (optionsCase_ == 12) {
          return (com.google.logging.v2.BigQueryOptions) options_;
        }
        return com.google.logging.v2.BigQueryOptions.getDefaultInstance();
      } else {
        if (optionsCase_ == 12) {
          return bigqueryOptionsBuilder_.getMessage();
        }
        return com.google.logging.v2.BigQueryOptions.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Options that affect sinks exporting data to BigQuery.
     * </pre>
     *
     * <code>
     * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBigqueryOptions(com.google.logging.v2.BigQueryOptions value) {
      if (bigqueryOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        options_ = value;
        onChanged();
      } else {
        bigqueryOptionsBuilder_.setMessage(value);
      }
      optionsCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Options that affect sinks exporting data to BigQuery.
     * </pre>
     *
     * <code>
     * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBigqueryOptions(
        com.google.logging.v2.BigQueryOptions.Builder builderForValue) {
      if (bigqueryOptionsBuilder_ == null) {
        options_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryOptionsBuilder_.setMessage(builderForValue.build());
      }
      optionsCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Options that affect sinks exporting data to BigQuery.
     * </pre>
     *
     * <code>
     * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeBigqueryOptions(com.google.logging.v2.BigQueryOptions value) {
      if (bigqueryOptionsBuilder_ == null) {
        if (optionsCase_ == 12
            && options_ != com.google.logging.v2.BigQueryOptions.getDefaultInstance()) {
          options_ =
              com.google.logging.v2.BigQueryOptions.newBuilder(
                      (com.google.logging.v2.BigQueryOptions) options_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          options_ = value;
        }
        onChanged();
      } else {
        if (optionsCase_ == 12) {
          bigqueryOptionsBuilder_.mergeFrom(value);
        } else {
          bigqueryOptionsBuilder_.setMessage(value);
        }
      }
      optionsCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Options that affect sinks exporting data to BigQuery.
     * </pre>
     *
     * <code>
     * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearBigqueryOptions() {
      if (bigqueryOptionsBuilder_ == null) {
        if (optionsCase_ == 12) {
          optionsCase_ = 0;
          options_ = null;
          onChanged();
        }
      } else {
        if (optionsCase_ == 12) {
          optionsCase_ = 0;
          options_ = null;
        }
        bigqueryOptionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Options that affect sinks exporting data to BigQuery.
     * </pre>
     *
     * <code>
     * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.BigQueryOptions.Builder getBigqueryOptionsBuilder() {
      return getBigqueryOptionsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Options that affect sinks exporting data to BigQuery.
     * </pre>
     *
     * <code>
     * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.logging.v2.BigQueryOptionsOrBuilder getBigqueryOptionsOrBuilder() {
      if ((optionsCase_ == 12) && (bigqueryOptionsBuilder_ != null)) {
        return bigqueryOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (optionsCase_ == 12) {
          return (com.google.logging.v2.BigQueryOptions) options_;
        }
        return com.google.logging.v2.BigQueryOptions.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Options that affect sinks exporting data to BigQuery.
     * </pre>
     *
     * <code>
     * .google.logging.v2.BigQueryOptions bigquery_options = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.BigQueryOptions,
            com.google.logging.v2.BigQueryOptions.Builder,
            com.google.logging.v2.BigQueryOptionsOrBuilder>
        getBigqueryOptionsFieldBuilder() {
      if (bigqueryOptionsBuilder_ == null) {
        if (!(optionsCase_ == 12)) {
          options_ = com.google.logging.v2.BigQueryOptions.getDefaultInstance();
        }
        bigqueryOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.logging.v2.BigQueryOptions,
                com.google.logging.v2.BigQueryOptions.Builder,
                com.google.logging.v2.BigQueryOptionsOrBuilder>(
                (com.google.logging.v2.BigQueryOptions) options_,
                getParentForChildren(),
                isClean());
        options_ = null;
      }
      optionsCase_ = 12;
      onChanged();
      return bigqueryOptionsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the sink.
     *
     * This field may not be present for older sinks.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.logging.v2.LogSink)
  }

  // @@protoc_insertion_point(class_scope:google.logging.v2.LogSink)
  private static final com.google.logging.v2.LogSink DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.logging.v2.LogSink();
  }

  public static com.google.logging.v2.LogSink getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LogSink> PARSER =
      new com.google.protobuf.AbstractParser<LogSink>() {
        @java.lang.Override
        public LogSink parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LogSink> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LogSink> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.logging.v2.LogSink getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
