/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.SinkName;
import java.util.ArrayList;
import java.util.List;

public class UntypedSinkName
extends SinkName {
    private final String rawValue;

    private UntypedSinkName(String rawValue) {
        this.rawValue = (String)Preconditions.checkNotNull((Object)rawValue);
    }

    public static UntypedSinkName from(ResourceName resourceName) {
        return new UntypedSinkName(resourceName.toString());
    }

    public static UntypedSinkName parse(String formattedString) {
        return new UntypedSinkName(formattedString);
    }

    public static List<UntypedSinkName> parseList(List<String> formattedStrings) {
        ArrayList<UntypedSinkName> list = new ArrayList<UntypedSinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UntypedSinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UntypedSinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UntypedSinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return true;
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("UntypedSinkName.getType() not supported");
    }

    public String toString() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UntypedSinkName) {
            UntypedSinkName that = (UntypedSinkName)o;
            return this.rawValue.equals(that.rawValue);
        }
        return false;
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }
}

