/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/alert.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A description of the conditions under which some aspect of your system is
 * considered to be "unhealthy" and the ways to notify people or services about
 * this state. For an overview of alert policies, see
 * [Introduction to Alerting](https://cloud.google.com/monitoring/alerts/).
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.AlertPolicy}
 */
public final class AlertPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy)
    AlertPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AlertPolicy.newBuilder() to construct.
  private AlertPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AlertPolicy() {
    name_ = "";
    displayName_ = "";
    conditions_ = java.util.Collections.emptyList();
    combiner_ = 0;
    notificationChannels_ = com.google.protobuf.LazyStringArrayList.emptyList();
    severity_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AlertPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.AlertProto
        .internal_static_google_monitoring_v3_AlertPolicy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 16:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.AlertProto
        .internal_static_google_monitoring_v3_AlertPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.AlertPolicy.class,
            com.google.monitoring.v3.AlertPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Operators for combining conditions.
   * </pre>
   *
   * Protobuf enum {@code google.monitoring.v3.AlertPolicy.ConditionCombinerType}
   */
  public enum ConditionCombinerType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * An unspecified combiner.
     * </pre>
     *
     * <code>COMBINE_UNSPECIFIED = 0;</code>
     */
    COMBINE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Combine conditions using the logical `AND` operator. An
     * incident is created only if all the conditions are met
     * simultaneously. This combiner is satisfied if all conditions are
     * met, even if they are met on completely different resources.
     * </pre>
     *
     * <code>AND = 1;</code>
     */
    AND(1),
    /**
     *
     *
     * <pre>
     * Combine conditions using the logical `OR` operator. An incident
     * is created if any of the listed conditions is met.
     * </pre>
     *
     * <code>OR = 2;</code>
     */
    OR(2),
    /**
     *
     *
     * <pre>
     * Combine conditions using logical `AND` operator, but unlike the regular
     * `AND` option, an incident is created only if all conditions are met
     * simultaneously on at least one resource.
     * </pre>
     *
     * <code>AND_WITH_MATCHING_RESOURCE = 3;</code>
     */
    AND_WITH_MATCHING_RESOURCE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * An unspecified combiner.
     * </pre>
     *
     * <code>COMBINE_UNSPECIFIED = 0;</code>
     */
    public static final int COMBINE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Combine conditions using the logical `AND` operator. An
     * incident is created only if all the conditions are met
     * simultaneously. This combiner is satisfied if all conditions are
     * met, even if they are met on completely different resources.
     * </pre>
     *
     * <code>AND = 1;</code>
     */
    public static final int AND_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Combine conditions using the logical `OR` operator. An incident
     * is created if any of the listed conditions is met.
     * </pre>
     *
     * <code>OR = 2;</code>
     */
    public static final int OR_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Combine conditions using logical `AND` operator, but unlike the regular
     * `AND` option, an incident is created only if all conditions are met
     * simultaneously on at least one resource.
     * </pre>
     *
     * <code>AND_WITH_MATCHING_RESOURCE = 3;</code>
     */
    public static final int AND_WITH_MATCHING_RESOURCE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConditionCombinerType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConditionCombinerType forNumber(int value) {
      switch (value) {
        case 0:
          return COMBINE_UNSPECIFIED;
        case 1:
          return AND;
        case 2:
          return OR;
        case 3:
          return AND_WITH_MATCHING_RESOURCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConditionCombinerType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConditionCombinerType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConditionCombinerType>() {
              public ConditionCombinerType findValueByNumber(int number) {
                return ConditionCombinerType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.monitoring.v3.AlertPolicy.getDescriptor().getEnumTypes().get(0);
    }

    private static final ConditionCombinerType[] VALUES = values();

    public static ConditionCombinerType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConditionCombinerType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.monitoring.v3.AlertPolicy.ConditionCombinerType)
  }

  /**
   *
   *
   * <pre>
   * An enumeration of possible severity level for an Alert Policy.
   * </pre>
   *
   * Protobuf enum {@code google.monitoring.v3.AlertPolicy.Severity}
   */
  public enum Severity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No severity is specified. This is the default value.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    SEVERITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * This is the highest severity level. Use this if the problem could
     * cause significant damage or downtime.
     * </pre>
     *
     * <code>CRITICAL = 1;</code>
     */
    CRITICAL(1),
    /**
     *
     *
     * <pre>
     * This is the medium severity level. Use this if the problem could
     * cause minor damage or downtime.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    ERROR(2),
    /**
     *
     *
     * <pre>
     * This is the lowest severity level. Use this if the problem is not causing
     * any damage or downtime, but could potentially lead to a problem in the
     * future.
     * </pre>
     *
     * <code>WARNING = 3;</code>
     */
    WARNING(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No severity is specified. This is the default value.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    public static final int SEVERITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This is the highest severity level. Use this if the problem could
     * cause significant damage or downtime.
     * </pre>
     *
     * <code>CRITICAL = 1;</code>
     */
    public static final int CRITICAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This is the medium severity level. Use this if the problem could
     * cause minor damage or downtime.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    public static final int ERROR_VALUE = 2;
    /**
     *
     *
     * <pre>
     * This is the lowest severity level. Use this if the problem is not causing
     * any damage or downtime, but could potentially lead to a problem in the
     * future.
     * </pre>
     *
     * <code>WARNING = 3;</code>
     */
    public static final int WARNING_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Severity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Severity forNumber(int value) {
      switch (value) {
        case 0:
          return SEVERITY_UNSPECIFIED;
        case 1:
          return CRITICAL;
        case 2:
          return ERROR;
        case 3:
          return WARNING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Severity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Severity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
          public Severity findValueByNumber(int number) {
            return Severity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.monitoring.v3.AlertPolicy.getDescriptor().getEnumTypes().get(1);
    }

    private static final Severity[] VALUES = values();

    public static Severity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Severity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.monitoring.v3.AlertPolicy.Severity)
  }

  public interface DocumentationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Documentation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The body of the documentation, interpreted according to `mime_type`.
     * The content may not exceed 8,192 Unicode characters and may not exceed
     * more than 10,240 bytes when encoded in UTF-8 format, whichever is
     * smaller. This text can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The content.
     */
    java.lang.String getContent();
    /**
     *
     *
     * <pre>
     * The body of the documentation, interpreted according to `mime_type`.
     * The content may not exceed 8,192 Unicode characters and may not exceed
     * more than 10,240 bytes when encoded in UTF-8 format, whichever is
     * smaller. This text can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The bytes for content.
     */
    com.google.protobuf.ByteString getContentBytes();

    /**
     *
     *
     * <pre>
     * The format of the `content` field. Presently, only the value
     * `"text/markdown"` is supported. See
     * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The mimeType.
     */
    java.lang.String getMimeType();
    /**
     *
     *
     * <pre>
     * The format of the `content` field. Presently, only the value
     * `"text/markdown"` is supported. See
     * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The bytes for mimeType.
     */
    com.google.protobuf.ByteString getMimeTypeBytes();

    /**
     *
     *
     * <pre>
     * Optional. The subject line of the notification. The subject line may not
     * exceed 10,240 bytes. In notifications generated by this policy, the
     * contents of the subject line after variable expansion will be truncated
     * to 255 bytes or shorter at the latest UTF-8 character boundary. The
     * 255-byte limit is recommended by [this
     * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
     * It is both the limit imposed by some third-party ticketing products and
     * it is common to define textual fields in databases as VARCHAR(255).
     *
     * The contents of the subject line can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
     * If this field is missing or empty, a default subject line will be
     * generated.
     * </pre>
     *
     * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The subject.
     */
    java.lang.String getSubject();
    /**
     *
     *
     * <pre>
     * Optional. The subject line of the notification. The subject line may not
     * exceed 10,240 bytes. In notifications generated by this policy, the
     * contents of the subject line after variable expansion will be truncated
     * to 255 bytes or shorter at the latest UTF-8 character boundary. The
     * 255-byte limit is recommended by [this
     * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
     * It is both the limit imposed by some third-party ticketing products and
     * it is common to define textual fields in databases as VARCHAR(255).
     *
     * The contents of the subject line can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
     * If this field is missing or empty, a default subject line will be
     * generated.
     * </pre>
     *
     * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for subject.
     */
    com.google.protobuf.ByteString getSubjectBytes();
  }
  /**
   *
   *
   * <pre>
   * A content string and a MIME type that describes the content string's
   * format.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.AlertPolicy.Documentation}
   */
  public static final class Documentation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Documentation)
      DocumentationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Documentation.newBuilder() to construct.
    private Documentation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Documentation() {
      content_ = "";
      mimeType_ = "";
      subject_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Documentation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_Documentation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_Documentation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.AlertPolicy.Documentation.class,
              com.google.monitoring.v3.AlertPolicy.Documentation.Builder.class);
    }

    public static final int CONTENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object content_ = "";
    /**
     *
     *
     * <pre>
     * The body of the documentation, interpreted according to `mime_type`.
     * The content may not exceed 8,192 Unicode characters and may not exceed
     * more than 10,240 bytes when encoded in UTF-8 format, whichever is
     * smaller. This text can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The content.
     */
    @java.lang.Override
    public java.lang.String getContent() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        content_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The body of the documentation, interpreted according to `mime_type`.
     * The content may not exceed 8,192 Unicode characters and may not exceed
     * more than 10,240 bytes when encoded in UTF-8 format, whichever is
     * smaller. This text can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The bytes for content.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContentBytes() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        content_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MIME_TYPE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object mimeType_ = "";
    /**
     *
     *
     * <pre>
     * The format of the `content` field. Presently, only the value
     * `"text/markdown"` is supported. See
     * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The mimeType.
     */
    @java.lang.Override
    public java.lang.String getMimeType() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mimeType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The format of the `content` field. Presently, only the value
     * `"text/markdown"` is supported. See
     * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The bytes for mimeType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMimeTypeBytes() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mimeType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUBJECT_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object subject_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The subject line of the notification. The subject line may not
     * exceed 10,240 bytes. In notifications generated by this policy, the
     * contents of the subject line after variable expansion will be truncated
     * to 255 bytes or shorter at the latest UTF-8 character boundary. The
     * 255-byte limit is recommended by [this
     * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
     * It is both the limit imposed by some third-party ticketing products and
     * it is common to define textual fields in databases as VARCHAR(255).
     *
     * The contents of the subject line can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
     * If this field is missing or empty, a default subject line will be
     * generated.
     * </pre>
     *
     * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The subject.
     */
    @java.lang.Override
    public java.lang.String getSubject() {
      java.lang.Object ref = subject_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subject_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The subject line of the notification. The subject line may not
     * exceed 10,240 bytes. In notifications generated by this policy, the
     * contents of the subject line after variable expansion will be truncated
     * to 255 bytes or shorter at the latest UTF-8 character boundary. The
     * 255-byte limit is recommended by [this
     * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
     * It is both the limit imposed by some third-party ticketing products and
     * it is common to define textual fields in databases as VARCHAR(255).
     *
     * The contents of the subject line can be [templatized by using
     * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
     * If this field is missing or empty, a default subject line will be
     * generated.
     * </pre>
     *
     * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for subject.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSubjectBytes() {
      java.lang.Object ref = subject_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, content_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, mimeType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subject_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, subject_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, content_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, mimeType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subject_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, subject_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Documentation)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.AlertPolicy.Documentation other =
          (com.google.monitoring.v3.AlertPolicy.Documentation) obj;

      if (!getContent().equals(other.getContent())) return false;
      if (!getMimeType().equals(other.getMimeType())) return false;
      if (!getSubject().equals(other.getSubject())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
      hash = (37 * hash) + MIME_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMimeType().hashCode();
      hash = (37 * hash) + SUBJECT_FIELD_NUMBER;
      hash = (53 * hash) + getSubject().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.AlertPolicy.Documentation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A content string and a MIME type that describes the content string's
     * format.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Documentation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Documentation)
        com.google.monitoring.v3.AlertPolicy.DocumentationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Documentation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Documentation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Documentation.class,
                com.google.monitoring.v3.AlertPolicy.Documentation.Builder.class);
      }

      // Construct using com.google.monitoring.v3.AlertPolicy.Documentation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        content_ = "";
        mimeType_ = "";
        subject_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Documentation_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Documentation getDefaultInstanceForType() {
        return com.google.monitoring.v3.AlertPolicy.Documentation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Documentation build() {
        com.google.monitoring.v3.AlertPolicy.Documentation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Documentation buildPartial() {
        com.google.monitoring.v3.AlertPolicy.Documentation result =
            new com.google.monitoring.v3.AlertPolicy.Documentation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.AlertPolicy.Documentation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.content_ = content_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.mimeType_ = mimeType_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.subject_ = subject_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.AlertPolicy.Documentation) {
          return mergeFrom((com.google.monitoring.v3.AlertPolicy.Documentation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.AlertPolicy.Documentation other) {
        if (other == com.google.monitoring.v3.AlertPolicy.Documentation.getDefaultInstance())
          return this;
        if (!other.getContent().isEmpty()) {
          content_ = other.content_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getMimeType().isEmpty()) {
          mimeType_ = other.mimeType_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getSubject().isEmpty()) {
          subject_ = other.subject_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  content_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  mimeType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  subject_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object content_ = "";
      /**
       *
       *
       * <pre>
       * The body of the documentation, interpreted according to `mime_type`.
       * The content may not exceed 8,192 Unicode characters and may not exceed
       * more than 10,240 bytes when encoded in UTF-8 format, whichever is
       * smaller. This text can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return The content.
       */
      public java.lang.String getContent() {
        java.lang.Object ref = content_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          content_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The body of the documentation, interpreted according to `mime_type`.
       * The content may not exceed 8,192 Unicode characters and may not exceed
       * more than 10,240 bytes when encoded in UTF-8 format, whichever is
       * smaller. This text can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return The bytes for content.
       */
      public com.google.protobuf.ByteString getContentBytes() {
        java.lang.Object ref = content_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          content_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The body of the documentation, interpreted according to `mime_type`.
       * The content may not exceed 8,192 Unicode characters and may not exceed
       * more than 10,240 bytes when encoded in UTF-8 format, whichever is
       * smaller. This text can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @param value The content to set.
       * @return This builder for chaining.
       */
      public Builder setContent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The body of the documentation, interpreted according to `mime_type`.
       * The content may not exceed 8,192 Unicode characters and may not exceed
       * more than 10,240 bytes when encoded in UTF-8 format, whichever is
       * smaller. This text can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContent() {
        content_ = getDefaultInstance().getContent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The body of the documentation, interpreted according to `mime_type`.
       * The content may not exceed 8,192 Unicode characters and may not exceed
       * more than 10,240 bytes when encoded in UTF-8 format, whichever is
       * smaller. This text can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @param value The bytes for content to set.
       * @return This builder for chaining.
       */
      public Builder setContentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        content_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object mimeType_ = "";
      /**
       *
       *
       * <pre>
       * The format of the `content` field. Presently, only the value
       * `"text/markdown"` is supported. See
       * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The mimeType.
       */
      public java.lang.String getMimeType() {
        java.lang.Object ref = mimeType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mimeType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The format of the `content` field. Presently, only the value
       * `"text/markdown"` is supported. See
       * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The bytes for mimeType.
       */
      public com.google.protobuf.ByteString getMimeTypeBytes() {
        java.lang.Object ref = mimeType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mimeType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The format of the `content` field. Presently, only the value
       * `"text/markdown"` is supported. See
       * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @param value The mimeType to set.
       * @return This builder for chaining.
       */
      public Builder setMimeType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        mimeType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The format of the `content` field. Presently, only the value
       * `"text/markdown"` is supported. See
       * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMimeType() {
        mimeType_ = getDefaultInstance().getMimeType();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The format of the `content` field. Presently, only the value
       * `"text/markdown"` is supported. See
       * [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @param value The bytes for mimeType to set.
       * @return This builder for chaining.
       */
      public Builder setMimeTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        mimeType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object subject_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The subject line of the notification. The subject line may not
       * exceed 10,240 bytes. In notifications generated by this policy, the
       * contents of the subject line after variable expansion will be truncated
       * to 255 bytes or shorter at the latest UTF-8 character boundary. The
       * 255-byte limit is recommended by [this
       * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
       * It is both the limit imposed by some third-party ticketing products and
       * it is common to define textual fields in databases as VARCHAR(255).
       *
       * The contents of the subject line can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * If this field is missing or empty, a default subject line will be
       * generated.
       * </pre>
       *
       * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The subject.
       */
      public java.lang.String getSubject() {
        java.lang.Object ref = subject_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subject_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The subject line of the notification. The subject line may not
       * exceed 10,240 bytes. In notifications generated by this policy, the
       * contents of the subject line after variable expansion will be truncated
       * to 255 bytes or shorter at the latest UTF-8 character boundary. The
       * 255-byte limit is recommended by [this
       * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
       * It is both the limit imposed by some third-party ticketing products and
       * it is common to define textual fields in databases as VARCHAR(255).
       *
       * The contents of the subject line can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * If this field is missing or empty, a default subject line will be
       * generated.
       * </pre>
       *
       * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for subject.
       */
      public com.google.protobuf.ByteString getSubjectBytes() {
        java.lang.Object ref = subject_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subject_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The subject line of the notification. The subject line may not
       * exceed 10,240 bytes. In notifications generated by this policy, the
       * contents of the subject line after variable expansion will be truncated
       * to 255 bytes or shorter at the latest UTF-8 character boundary. The
       * 255-byte limit is recommended by [this
       * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
       * It is both the limit imposed by some third-party ticketing products and
       * it is common to define textual fields in databases as VARCHAR(255).
       *
       * The contents of the subject line can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * If this field is missing or empty, a default subject line will be
       * generated.
       * </pre>
       *
       * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The subject to set.
       * @return This builder for chaining.
       */
      public Builder setSubject(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        subject_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The subject line of the notification. The subject line may not
       * exceed 10,240 bytes. In notifications generated by this policy, the
       * contents of the subject line after variable expansion will be truncated
       * to 255 bytes or shorter at the latest UTF-8 character boundary. The
       * 255-byte limit is recommended by [this
       * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
       * It is both the limit imposed by some third-party ticketing products and
       * it is common to define textual fields in databases as VARCHAR(255).
       *
       * The contents of the subject line can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * If this field is missing or empty, a default subject line will be
       * generated.
       * </pre>
       *
       * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSubject() {
        subject_ = getDefaultInstance().getSubject();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The subject line of the notification. The subject line may not
       * exceed 10,240 bytes. In notifications generated by this policy, the
       * contents of the subject line after variable expansion will be truncated
       * to 255 bytes or shorter at the latest UTF-8 character boundary. The
       * 255-byte limit is recommended by [this
       * thread](https://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit).
       * It is both the limit imposed by some third-party ticketing products and
       * it is common to define textual fields in databases as VARCHAR(255).
       *
       * The contents of the subject line can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * If this field is missing or empty, a default subject line will be
       * generated.
       * </pre>
       *
       * <code>string subject = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for subject to set.
       * @return This builder for chaining.
       */
      public Builder setSubjectBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        subject_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Documentation)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Documentation)
    private static final com.google.monitoring.v3.AlertPolicy.Documentation DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Documentation();
    }

    public static com.google.monitoring.v3.AlertPolicy.Documentation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Documentation> PARSER =
        new com.google.protobuf.AbstractParser<Documentation>() {
          @java.lang.Override
          public Documentation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Documentation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Documentation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Documentation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required if the condition exists. The unique resource name for this
     * condition. Its format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     *
     * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     * condition is created as part of a new or updated alerting policy.
     *
     * When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the conditions of the
     * requested alerting policy. Cloud Monitoring creates the
     * condition identifiers and includes them in the new policy.
     *
     * When calling the
     * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     * method to update a policy, including a condition `name` causes the
     * existing condition to be updated. Conditions without names are added to
     * the updated policy. Existing conditions are deleted if they are not
     * updated.
     *
     * Best practice is to preserve `[CONDITION_ID]` if you make only small
     * changes, such as those to condition thresholds, durations, or trigger
     * values.  Otherwise, treat the change as a new condition and let the
     * existing condition be deleted.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required if the condition exists. The unique resource name for this
     * condition. Its format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     *
     * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     * condition is created as part of a new or updated alerting policy.
     *
     * When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the conditions of the
     * requested alerting policy. Cloud Monitoring creates the
     * condition identifiers and includes them in the new policy.
     *
     * When calling the
     * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     * method to update a policy, including a condition `name` causes the
     * existing condition to be updated. Conditions without names are added to
     * the updated policy. Existing conditions are deleted if they are not
     * updated.
     *
     * Best practice is to preserve `[CONDITION_ID]` if you make only small
     * changes, such as those to condition thresholds, durations, or trigger
     * values.  Otherwise, treat the change as a new condition and let the
     * existing condition be deleted.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the condition in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple conditions in the same policy.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the condition in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple conditions in the same policy.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     *
     * @return Whether the conditionThreshold field is set.
     */
    boolean hasConditionThreshold();
    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     *
     * @return The conditionThreshold.
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold getConditionThreshold();
    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MetricThresholdOrBuilder
        getConditionThresholdOrBuilder();

    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     *
     * @return Whether the conditionAbsent field is set.
     */
    boolean hasConditionAbsent();
    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     *
     * @return The conditionAbsent.
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence getConditionAbsent();
    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsenceOrBuilder
        getConditionAbsentOrBuilder();

    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     *
     * @return Whether the conditionMatchedLog field is set.
     */
    boolean hasConditionMatchedLog();
    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     *
     * @return The conditionMatchedLog.
     */
    com.google.monitoring.v3.AlertPolicy.Condition.LogMatch getConditionMatchedLog();
    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     */
    com.google.monitoring.v3.AlertPolicy.Condition.LogMatchOrBuilder
        getConditionMatchedLogOrBuilder();

    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     *
     * @return Whether the conditionMonitoringQueryLanguage field is set.
     */
    boolean hasConditionMonitoringQueryLanguage();
    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     *
     * @return The conditionMonitoringQueryLanguage.
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
        getConditionMonitoringQueryLanguage();
    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     */
    com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageConditionOrBuilder
        getConditionMonitoringQueryLanguageOrBuilder();

    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     *
     * @return Whether the conditionPrometheusQueryLanguage field is set.
     */
    boolean hasConditionPrometheusQueryLanguage();
    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     *
     * @return The conditionPrometheusQueryLanguage.
     */
    com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
        getConditionPrometheusQueryLanguage();
    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     */
    com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageConditionOrBuilder
        getConditionPrometheusQueryLanguageOrBuilder();

    com.google.monitoring.v3.AlertPolicy.Condition.ConditionCase getConditionCase();
  }
  /**
   *
   *
   * <pre>
   * A condition is a true/false test that determines when an alerting policy
   * should open an incident. If a condition evaluates to true, it signifies
   * that something is wrong.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition}
   */
  public static final class Condition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition)
      ConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Condition.newBuilder() to construct.
    private Condition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Condition() {
      name_ = "";
      displayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Condition();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_Condition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_Condition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.AlertPolicy.Condition.class,
              com.google.monitoring.v3.AlertPolicy.Condition.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * A condition control that determines how metric-threshold conditions
     * are evaluated when data stops arriving.
     * This control doesn't affect metric-absence policies.
     * </pre>
     *
     * Protobuf enum {@code google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData}
     */
    public enum EvaluationMissingData implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * An unspecified evaluation missing data option.  Equivalent to
       * EVALUATION_MISSING_DATA_NO_OP.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_UNSPECIFIED = 0;</code>
       */
      EVALUATION_MISSING_DATA_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * If there is no data to evaluate the condition, then evaluate the
       * condition as false.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_INACTIVE = 1;</code>
       */
      EVALUATION_MISSING_DATA_INACTIVE(1),
      /**
       *
       *
       * <pre>
       * If there is no data to evaluate the condition, then evaluate the
       * condition as true.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_ACTIVE = 2;</code>
       */
      EVALUATION_MISSING_DATA_ACTIVE(2),
      /**
       *
       *
       * <pre>
       * Do not evaluate the condition to any value if there is no data.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_NO_OP = 3;</code>
       */
      EVALUATION_MISSING_DATA_NO_OP(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * An unspecified evaluation missing data option.  Equivalent to
       * EVALUATION_MISSING_DATA_NO_OP.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_UNSPECIFIED = 0;</code>
       */
      public static final int EVALUATION_MISSING_DATA_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * If there is no data to evaluate the condition, then evaluate the
       * condition as false.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_INACTIVE = 1;</code>
       */
      public static final int EVALUATION_MISSING_DATA_INACTIVE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * If there is no data to evaluate the condition, then evaluate the
       * condition as true.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_ACTIVE = 2;</code>
       */
      public static final int EVALUATION_MISSING_DATA_ACTIVE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Do not evaluate the condition to any value if there is no data.
       * </pre>
       *
       * <code>EVALUATION_MISSING_DATA_NO_OP = 3;</code>
       */
      public static final int EVALUATION_MISSING_DATA_NO_OP_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static EvaluationMissingData valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static EvaluationMissingData forNumber(int value) {
        switch (value) {
          case 0:
            return EVALUATION_MISSING_DATA_UNSPECIFIED;
          case 1:
            return EVALUATION_MISSING_DATA_INACTIVE;
          case 2:
            return EVALUATION_MISSING_DATA_ACTIVE;
          case 3:
            return EVALUATION_MISSING_DATA_NO_OP;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<EvaluationMissingData>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<EvaluationMissingData>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<EvaluationMissingData>() {
                public EvaluationMissingData findValueByNumber(int number) {
                  return EvaluationMissingData.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.monitoring.v3.AlertPolicy.Condition.getDescriptor().getEnumTypes().get(0);
      }

      private static final EvaluationMissingData[] VALUES = values();

      public static EvaluationMissingData valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private EvaluationMissingData(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData)
    }

    public interface TriggerOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.Trigger)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The absolute number of time series that must fail
       * the predicate for the condition to be triggered.
       * </pre>
       *
       * <code>int32 count = 1;</code>
       *
       * @return Whether the count field is set.
       */
      boolean hasCount();
      /**
       *
       *
       * <pre>
       * The absolute number of time series that must fail
       * the predicate for the condition to be triggered.
       * </pre>
       *
       * <code>int32 count = 1;</code>
       *
       * @return The count.
       */
      int getCount();

      /**
       *
       *
       * <pre>
       * The percentage of time series that must fail the
       * predicate for the condition to be triggered.
       * </pre>
       *
       * <code>double percent = 2;</code>
       *
       * @return Whether the percent field is set.
       */
      boolean hasPercent();
      /**
       *
       *
       * <pre>
       * The percentage of time series that must fail the
       * predicate for the condition to be triggered.
       * </pre>
       *
       * <code>double percent = 2;</code>
       *
       * @return The percent.
       */
      double getPercent();

      com.google.monitoring.v3.AlertPolicy.Condition.Trigger.TypeCase getTypeCase();
    }
    /**
     *
     *
     * <pre>
     * Specifies how many time series must fail a predicate to trigger a
     * condition. If not specified, then a `{count: 1}` trigger is used.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.Trigger}
     */
    public static final class Trigger extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.Trigger)
        TriggerOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Trigger.newBuilder() to construct.
      private Trigger(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Trigger() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Trigger();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_Trigger_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_Trigger_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.class,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder.class);
      }

      private int typeCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object type_;

      public enum TypeCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        COUNT(1),
        PERCENT(2),
        TYPE_NOT_SET(0);
        private final int value;

        private TypeCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static TypeCase valueOf(int value) {
          return forNumber(value);
        }

        public static TypeCase forNumber(int value) {
          switch (value) {
            case 1:
              return COUNT;
            case 2:
              return PERCENT;
            case 0:
              return TYPE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public TypeCase getTypeCase() {
        return TypeCase.forNumber(typeCase_);
      }

      public static final int COUNT_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * The absolute number of time series that must fail
       * the predicate for the condition to be triggered.
       * </pre>
       *
       * <code>int32 count = 1;</code>
       *
       * @return Whether the count field is set.
       */
      @java.lang.Override
      public boolean hasCount() {
        return typeCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * The absolute number of time series that must fail
       * the predicate for the condition to be triggered.
       * </pre>
       *
       * <code>int32 count = 1;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public int getCount() {
        if (typeCase_ == 1) {
          return (java.lang.Integer) type_;
        }
        return 0;
      }

      public static final int PERCENT_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * The percentage of time series that must fail the
       * predicate for the condition to be triggered.
       * </pre>
       *
       * <code>double percent = 2;</code>
       *
       * @return Whether the percent field is set.
       */
      @java.lang.Override
      public boolean hasPercent() {
        return typeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The percentage of time series that must fail the
       * predicate for the condition to be triggered.
       * </pre>
       *
       * <code>double percent = 2;</code>
       *
       * @return The percent.
       */
      @java.lang.Override
      public double getPercent() {
        if (typeCase_ == 2) {
          return (java.lang.Double) type_;
        }
        return 0D;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (typeCase_ == 1) {
          output.writeInt32(1, (int) ((java.lang.Integer) type_));
        }
        if (typeCase_ == 2) {
          output.writeDouble(2, (double) ((java.lang.Double) type_));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (typeCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt32Size(
                  1, (int) ((java.lang.Integer) type_));
        }
        if (typeCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeDoubleSize(
                  2, (double) ((java.lang.Double) type_));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition.Trigger)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.Trigger other =
            (com.google.monitoring.v3.AlertPolicy.Condition.Trigger) obj;

        if (!getTypeCase().equals(other.getTypeCase())) return false;
        switch (typeCase_) {
          case 1:
            if (getCount() != other.getCount()) return false;
            break;
          case 2:
            if (java.lang.Double.doubleToLongBits(getPercent())
                != java.lang.Double.doubleToLongBits(other.getPercent())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (typeCase_) {
          case 1:
            hash = (37 * hash) + COUNT_FIELD_NUMBER;
            hash = (53 * hash) + getCount();
            break;
          case 2:
            hash = (37 * hash) + PERCENT_FIELD_NUMBER;
            hash =
                (53 * hash)
                    + com.google.protobuf.Internal.hashLong(
                        java.lang.Double.doubleToLongBits(getPercent()));
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.Trigger prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specifies how many time series must fail a predicate to trigger a
       * condition. If not specified, then a `{count: 1}` trigger is used.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.Trigger}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.Trigger)
          com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_Trigger_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_Trigger_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.Trigger.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder.class);
        }

        // Construct using com.google.monitoring.v3.AlertPolicy.Condition.Trigger.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          typeCase_ = 0;
          type_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_Trigger_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger build() {
          com.google.monitoring.v3.AlertPolicy.Condition.Trigger result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.Trigger result =
              new com.google.monitoring.v3.AlertPolicy.Condition.Trigger(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.monitoring.v3.AlertPolicy.Condition.Trigger result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.monitoring.v3.AlertPolicy.Condition.Trigger result) {
          result.typeCase_ = typeCase_;
          result.type_ = this.type_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.monitoring.v3.AlertPolicy.Condition.Trigger) {
            return mergeFrom((com.google.monitoring.v3.AlertPolicy.Condition.Trigger) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.monitoring.v3.AlertPolicy.Condition.Trigger other) {
          if (other == com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance())
            return this;
          switch (other.getTypeCase()) {
            case COUNT:
              {
                setCount(other.getCount());
                break;
              }
            case PERCENT:
              {
                setPercent(other.getPercent());
                break;
              }
            case TYPE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    type_ = input.readInt32();
                    typeCase_ = 1;
                    break;
                  } // case 8
                case 17:
                  {
                    type_ = input.readDouble();
                    typeCase_ = 2;
                    break;
                  } // case 17
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int typeCase_ = 0;
        private java.lang.Object type_;

        public TypeCase getTypeCase() {
          return TypeCase.forNumber(typeCase_);
        }

        public Builder clearType() {
          typeCase_ = 0;
          type_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * The absolute number of time series that must fail
         * the predicate for the condition to be triggered.
         * </pre>
         *
         * <code>int32 count = 1;</code>
         *
         * @return Whether the count field is set.
         */
        public boolean hasCount() {
          return typeCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * The absolute number of time series that must fail
         * the predicate for the condition to be triggered.
         * </pre>
         *
         * <code>int32 count = 1;</code>
         *
         * @return The count.
         */
        public int getCount() {
          if (typeCase_ == 1) {
            return (java.lang.Integer) type_;
          }
          return 0;
        }
        /**
         *
         *
         * <pre>
         * The absolute number of time series that must fail
         * the predicate for the condition to be triggered.
         * </pre>
         *
         * <code>int32 count = 1;</code>
         *
         * @param value The count to set.
         * @return This builder for chaining.
         */
        public Builder setCount(int value) {

          typeCase_ = 1;
          type_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The absolute number of time series that must fail
         * the predicate for the condition to be triggered.
         * </pre>
         *
         * <code>int32 count = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCount() {
          if (typeCase_ == 1) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * The percentage of time series that must fail the
         * predicate for the condition to be triggered.
         * </pre>
         *
         * <code>double percent = 2;</code>
         *
         * @return Whether the percent field is set.
         */
        public boolean hasPercent() {
          return typeCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * The percentage of time series that must fail the
         * predicate for the condition to be triggered.
         * </pre>
         *
         * <code>double percent = 2;</code>
         *
         * @return The percent.
         */
        public double getPercent() {
          if (typeCase_ == 2) {
            return (java.lang.Double) type_;
          }
          return 0D;
        }
        /**
         *
         *
         * <pre>
         * The percentage of time series that must fail the
         * predicate for the condition to be triggered.
         * </pre>
         *
         * <code>double percent = 2;</code>
         *
         * @param value The percent to set.
         * @return This builder for chaining.
         */
        public Builder setPercent(double value) {

          typeCase_ = 2;
          type_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The percentage of time series that must fail the
         * predicate for the condition to be triggered.
         * </pre>
         *
         * <code>double percent = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPercent() {
          if (typeCase_ == 2) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.Trigger)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.Trigger)
      private static final com.google.monitoring.v3.AlertPolicy.Condition.Trigger DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Condition.Trigger();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.Trigger getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Trigger> PARSER =
          new com.google.protobuf.AbstractParser<Trigger>() {
            @java.lang.Override
            public Trigger parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Trigger> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Trigger> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MetricThresholdOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      java.lang.String getFilter();
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      com.google.protobuf.ByteString getFilterBytes();

      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      com.google.monitoring.v3.Aggregation getAggregations(int index);
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      int getAggregationsCount();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getAggregationsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies a time series that should be used as the denominator of a
       * ratio that will be compared with the threshold. If a
       * `denominator_filter` is specified, the time series specified by the
       * `filter` field will be used as the numerator.
       *
       * The filter must specify the metric type and optionally may contain
       * restrictions on resource type, resource labels, and metric labels.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string denominator_filter = 9;</code>
       *
       * @return The denominatorFilter.
       */
      java.lang.String getDenominatorFilter();
      /**
       *
       *
       * <pre>
       * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies a time series that should be used as the denominator of a
       * ratio that will be compared with the threshold. If a
       * `denominator_filter` is specified, the time series specified by the
       * `filter` field will be used as the numerator.
       *
       * The filter must specify the metric type and optionally may contain
       * restrictions on resource type, resource labels, and metric labels.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string denominator_filter = 9;</code>
       *
       * @return The bytes for denominatorFilter.
       */
      com.google.protobuf.ByteString getDenominatorFilterBytes();

      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      java.util.List<com.google.monitoring.v3.Aggregation> getDenominatorAggregationsList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      com.google.monitoring.v3.Aggregation getDenominatorAggregations(int index);
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      int getDenominatorAggregationsCount();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getDenominatorAggregationsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      com.google.monitoring.v3.AggregationOrBuilder getDenominatorAggregationsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       *
       * @return Whether the forecastOptions field is set.
       */
      boolean hasForecastOptions();
      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       *
       * @return The forecastOptions.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
          getForecastOptions();
      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptionsOrBuilder
          getForecastOptionsOrBuilder();

      /**
       *
       *
       * <pre>
       * The comparison to apply between the time series (indicated by `filter`
       * and `aggregation`) and the threshold (indicated by `threshold_value`).
       * The comparison is applied on each time series, with the time series
       * on the left-hand side and the threshold on the right-hand side.
       *
       * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
       * </pre>
       *
       * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
       *
       * @return The enum numeric value on the wire for comparison.
       */
      int getComparisonValue();
      /**
       *
       *
       * <pre>
       * The comparison to apply between the time series (indicated by `filter`
       * and `aggregation`) and the threshold (indicated by `threshold_value`).
       * The comparison is applied on each time series, with the time series
       * on the left-hand side and the threshold on the right-hand side.
       *
       * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
       * </pre>
       *
       * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
       *
       * @return The comparison.
       */
      com.google.monitoring.v3.ComparisonType getComparison();

      /**
       *
       *
       * <pre>
       * A value against which to compare the time series.
       * </pre>
       *
       * <code>double threshold_value = 5;</code>
       *
       * @return The thresholdValue.
       */
      double getThresholdValue();

      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       *
       * @return Whether the duration field is set.
       */
      boolean hasDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       *
       * @return The duration.
       */
      com.google.protobuf.Duration getDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       */
      com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       *
       * @return Whether the trigger field is set.
       */
      boolean hasTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       *
       * @return The trigger.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder();

      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
       * </code>
       *
       * @return The enum numeric value on the wire for evaluationMissingData.
       */
      int getEvaluationMissingDataValue();
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
       * </code>
       *
       * @return The evaluationMissingData.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
          getEvaluationMissingData();
    }
    /**
     *
     *
     * <pre>
     * A condition type that compares a collection of time series
     * against a threshold.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.MetricThreshold}
     */
    public static final class MetricThreshold extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)
        MetricThresholdOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MetricThreshold.newBuilder() to construct.
      private MetricThreshold(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MetricThreshold() {
        filter_ = "";
        aggregations_ = java.util.Collections.emptyList();
        denominatorFilter_ = "";
        denominatorAggregations_ = java.util.Collections.emptyList();
        comparison_ = 0;
        evaluationMissingData_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MetricThreshold();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.class,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.Builder.class);
      }

      public interface ForecastOptionsOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the forecastHorizon field is set.
         */
        boolean hasForecastHorizon();
        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The forecastHorizon.
         */
        com.google.protobuf.Duration getForecastHorizon();
        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        com.google.protobuf.DurationOrBuilder getForecastHorizonOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * Options used when forecasting the time series and testing
       * the predicted value against the threshold.
       * </pre>
       *
       * Protobuf type {@code
       * google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions}
       */
      public static final class ForecastOptions extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
          ForecastOptionsOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use ForecastOptions.newBuilder() to construct.
        private ForecastOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ForecastOptions() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ForecastOptions();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_ForecastOptions_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_ForecastOptions_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                      .class,
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                      .Builder.class);
        }

        public static final int FORECAST_HORIZON_FIELD_NUMBER = 1;
        private com.google.protobuf.Duration forecastHorizon_;
        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the forecastHorizon field is set.
         */
        @java.lang.Override
        public boolean hasForecastHorizon() {
          return forecastHorizon_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The forecastHorizon.
         */
        @java.lang.Override
        public com.google.protobuf.Duration getForecastHorizon() {
          return forecastHorizon_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : forecastHorizon_;
        }
        /**
         *
         *
         * <pre>
         * Required. The length of time into the future to forecast whether a
         * time series will violate the threshold. If the predicted value is
         * found to violate the threshold, and the violation is observed in all
         * forecasts made for the configured `duration`, then the time series is
         * considered to be failing.
         * The forecast horizon can range from 1 hour to 60 hours.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public com.google.protobuf.DurationOrBuilder getForecastHorizonOrBuilder() {
          return forecastHorizon_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : forecastHorizon_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (forecastHorizon_ != null) {
            output.writeMessage(1, getForecastHorizon());
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (forecastHorizon_ != null) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(1, getForecastHorizon());
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)) {
            return super.equals(obj);
          }
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions other =
              (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions) obj;

          if (hasForecastHorizon() != other.hasForecastHorizon()) return false;
          if (hasForecastHorizon()) {
            if (!getForecastHorizon().equals(other.getForecastHorizon())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasForecastHorizon()) {
            hash = (37 * hash) + FORECAST_HORIZON_FIELD_NUMBER;
            hash = (53 * hash) + getForecastHorizon().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Options used when forecasting the time series and testing
         * the predicted value against the threshold.
         * </pre>
         *
         * Protobuf type {@code
         * google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                .ForecastOptionsOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_ForecastOptions_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_ForecastOptions_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                        .class,
                    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                        .Builder.class);
          }

          // Construct using
          // com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            forecastHorizon_ = null;
            if (forecastHorizonBuilder_ != null) {
              forecastHorizonBuilder_.dispose();
              forecastHorizonBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_ForecastOptions_descriptor;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
              getDefaultInstanceForType() {
            return com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
              build() {
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
              buildPartial() {
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions result =
                new com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions(
                    this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.forecastHorizon_ =
                  forecastHorizonBuilder_ == null
                      ? forecastHorizon_
                      : forecastHorizonBuilder_.build();
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions) {
              return mergeFrom(
                  (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                  other) {
            if (other
                == com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                    .getDefaultInstance()) return this;
            if (other.hasForecastHorizon()) {
              mergeForecastHorizon(other.getForecastHorizon());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(
                          getForecastHorizonFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.Duration forecastHorizon_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>
              forecastHorizonBuilder_;
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return Whether the forecastHorizon field is set.
           */
          public boolean hasForecastHorizon() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The forecastHorizon.
           */
          public com.google.protobuf.Duration getForecastHorizon() {
            if (forecastHorizonBuilder_ == null) {
              return forecastHorizon_ == null
                  ? com.google.protobuf.Duration.getDefaultInstance()
                  : forecastHorizon_;
            } else {
              return forecastHorizonBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setForecastHorizon(com.google.protobuf.Duration value) {
            if (forecastHorizonBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              forecastHorizon_ = value;
            } else {
              forecastHorizonBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setForecastHorizon(com.google.protobuf.Duration.Builder builderForValue) {
            if (forecastHorizonBuilder_ == null) {
              forecastHorizon_ = builderForValue.build();
            } else {
              forecastHorizonBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder mergeForecastHorizon(com.google.protobuf.Duration value) {
            if (forecastHorizonBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)
                  && forecastHorizon_ != null
                  && forecastHorizon_ != com.google.protobuf.Duration.getDefaultInstance()) {
                getForecastHorizonBuilder().mergeFrom(value);
              } else {
                forecastHorizon_ = value;
              }
            } else {
              forecastHorizonBuilder_.mergeFrom(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder clearForecastHorizon() {
            bitField0_ = (bitField0_ & ~0x00000001);
            forecastHorizon_ = null;
            if (forecastHorizonBuilder_ != null) {
              forecastHorizonBuilder_.dispose();
              forecastHorizonBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.protobuf.Duration.Builder getForecastHorizonBuilder() {
            bitField0_ |= 0x00000001;
            onChanged();
            return getForecastHorizonFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.protobuf.DurationOrBuilder getForecastHorizonOrBuilder() {
            if (forecastHorizonBuilder_ != null) {
              return forecastHorizonBuilder_.getMessageOrBuilder();
            } else {
              return forecastHorizon_ == null
                  ? com.google.protobuf.Duration.getDefaultInstance()
                  : forecastHorizon_;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The length of time into the future to forecast whether a
           * time series will violate the threshold. If the predicted value is
           * found to violate the threshold, and the violation is observed in all
           * forecasts made for the configured `duration`, then the time series is
           * considered to be failing.
           * The forecast horizon can range from 1 hour to 60 hours.
           * </pre>
           *
           * <code>
           * .google.protobuf.Duration forecast_horizon = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>
              getForecastHorizonFieldBuilder() {
            if (forecastHorizonBuilder_ == null) {
              forecastHorizonBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.protobuf.Duration,
                      com.google.protobuf.Duration.Builder,
                      com.google.protobuf.DurationOrBuilder>(
                      getForecastHorizon(), getParentForChildren(), isClean());
              forecastHorizon_ = null;
            }
            return forecastHorizonBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
        }

        // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions)
        private static final com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                .ForecastOptions
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions();
        }

        public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ForecastOptions> PARSER =
            new com.google.protobuf.AbstractParser<ForecastOptions>() {
              @java.lang.Override
              public ForecastOptions parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ForecastOptions> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ForecastOptions> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int FILTER_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      @java.lang.Override
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int AGGREGATIONS_FIELD_NUMBER = 8;

      @SuppressWarnings("serial")
      private java.util.List<com.google.monitoring.v3.Aggregation> aggregations_;
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList() {
        return aggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getAggregationsOrBuilderList() {
        return aggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      @java.lang.Override
      public int getAggregationsCount() {
        return aggregations_.size();
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.Aggregation getAggregations(int index) {
        return aggregations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index) {
        return aggregations_.get(index);
      }

      public static final int DENOMINATOR_FILTER_FIELD_NUMBER = 9;

      @SuppressWarnings("serial")
      private volatile java.lang.Object denominatorFilter_ = "";
      /**
       *
       *
       * <pre>
       * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies a time series that should be used as the denominator of a
       * ratio that will be compared with the threshold. If a
       * `denominator_filter` is specified, the time series specified by the
       * `filter` field will be used as the numerator.
       *
       * The filter must specify the metric type and optionally may contain
       * restrictions on resource type, resource labels, and metric labels.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string denominator_filter = 9;</code>
       *
       * @return The denominatorFilter.
       */
      @java.lang.Override
      public java.lang.String getDenominatorFilter() {
        java.lang.Object ref = denominatorFilter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          denominatorFilter_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies a time series that should be used as the denominator of a
       * ratio that will be compared with the threshold. If a
       * `denominator_filter` is specified, the time series specified by the
       * `filter` field will be used as the numerator.
       *
       * The filter must specify the metric type and optionally may contain
       * restrictions on resource type, resource labels, and metric labels.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string denominator_filter = 9;</code>
       *
       * @return The bytes for denominatorFilter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDenominatorFilterBytes() {
        java.lang.Object ref = denominatorFilter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          denominatorFilter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DENOMINATOR_AGGREGATIONS_FIELD_NUMBER = 10;

      @SuppressWarnings("serial")
      private java.util.List<com.google.monitoring.v3.Aggregation> denominatorAggregations_;
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.monitoring.v3.Aggregation> getDenominatorAggregationsList() {
        return denominatorAggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getDenominatorAggregationsOrBuilderList() {
        return denominatorAggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      @java.lang.Override
      public int getDenominatorAggregationsCount() {
        return denominatorAggregations_.size();
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.Aggregation getDenominatorAggregations(int index) {
        return denominatorAggregations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series
       * selected by `denominatorFilter` as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources).
       *
       * When computing ratios, the `aggregations` and
       * `denominator_aggregations` fields must use the same alignment period
       * and produce time series that have the same periodicity and labels.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AggregationOrBuilder getDenominatorAggregationsOrBuilder(
          int index) {
        return denominatorAggregations_.get(index);
      }

      public static final int FORECAST_OPTIONS_FIELD_NUMBER = 12;
      private com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
          forecastOptions_;
      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       *
       * @return Whether the forecastOptions field is set.
       */
      @java.lang.Override
      public boolean hasForecastOptions() {
        return forecastOptions_ != null;
      }
      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       *
       * @return The forecastOptions.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
          getForecastOptions() {
        return forecastOptions_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                .getDefaultInstance()
            : forecastOptions_;
      }
      /**
       *
       *
       * <pre>
       * When this field is present, the `MetricThreshold` condition forecasts
       * whether the time series is predicted to violate the threshold within
       * the `forecast_horizon`. When this field is not set, the
       * `MetricThreshold` tests the current value of the timeseries against the
       * threshold.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
       * </code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptionsOrBuilder
          getForecastOptionsOrBuilder() {
        return forecastOptions_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                .getDefaultInstance()
            : forecastOptions_;
      }

      public static final int COMPARISON_FIELD_NUMBER = 4;
      private int comparison_ = 0;
      /**
       *
       *
       * <pre>
       * The comparison to apply between the time series (indicated by `filter`
       * and `aggregation`) and the threshold (indicated by `threshold_value`).
       * The comparison is applied on each time series, with the time series
       * on the left-hand side and the threshold on the right-hand side.
       *
       * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
       * </pre>
       *
       * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
       *
       * @return The enum numeric value on the wire for comparison.
       */
      @java.lang.Override
      public int getComparisonValue() {
        return comparison_;
      }
      /**
       *
       *
       * <pre>
       * The comparison to apply between the time series (indicated by `filter`
       * and `aggregation`) and the threshold (indicated by `threshold_value`).
       * The comparison is applied on each time series, with the time series
       * on the left-hand side and the threshold on the right-hand side.
       *
       * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
       * </pre>
       *
       * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
       *
       * @return The comparison.
       */
      @java.lang.Override
      public com.google.monitoring.v3.ComparisonType getComparison() {
        com.google.monitoring.v3.ComparisonType result =
            com.google.monitoring.v3.ComparisonType.forNumber(comparison_);
        return result == null ? com.google.monitoring.v3.ComparisonType.UNRECOGNIZED : result;
      }

      public static final int THRESHOLD_VALUE_FIELD_NUMBER = 5;
      private double thresholdValue_ = 0D;
      /**
       *
       *
       * <pre>
       * A value against which to compare the time series.
       * </pre>
       *
       * <code>double threshold_value = 5;</code>
       *
       * @return The thresholdValue.
       */
      @java.lang.Override
      public double getThresholdValue() {
        return thresholdValue_;
      }

      public static final int DURATION_FIELD_NUMBER = 6;
      private com.google.protobuf.Duration duration_;
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       *
       * @return Whether the duration field is set.
       */
      @java.lang.Override
      public boolean hasDuration() {
        return duration_ != null;
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       *
       * @return The duration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getDuration() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 6;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }

      public static final int TRIGGER_FIELD_NUMBER = 7;
      private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       *
       * @return Whether the trigger field is set.
       */
      @java.lang.Override
      public boolean hasTrigger() {
        return trigger_ != null;
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       *
       * @return The trigger.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }

      public static final int EVALUATION_MISSING_DATA_FIELD_NUMBER = 11;
      private int evaluationMissingData_ = 0;
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
       * </code>
       *
       * @return The enum numeric value on the wire for evaluationMissingData.
       */
      @java.lang.Override
      public int getEvaluationMissingDataValue() {
        return evaluationMissingData_;
      }
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
       * </code>
       *
       * @return The evaluationMissingData.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
          getEvaluationMissingData() {
        com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData result =
            com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.forNumber(
                evaluationMissingData_);
        return result == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
        }
        if (comparison_
            != com.google.monitoring.v3.ComparisonType.COMPARISON_UNSPECIFIED.getNumber()) {
          output.writeEnum(4, comparison_);
        }
        if (java.lang.Double.doubleToRawLongBits(thresholdValue_) != 0) {
          output.writeDouble(5, thresholdValue_);
        }
        if (duration_ != null) {
          output.writeMessage(6, getDuration());
        }
        if (trigger_ != null) {
          output.writeMessage(7, getTrigger());
        }
        for (int i = 0; i < aggregations_.size(); i++) {
          output.writeMessage(8, aggregations_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(denominatorFilter_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 9, denominatorFilter_);
        }
        for (int i = 0; i < denominatorAggregations_.size(); i++) {
          output.writeMessage(10, denominatorAggregations_.get(i));
        }
        if (evaluationMissingData_
            != com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
                .EVALUATION_MISSING_DATA_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(11, evaluationMissingData_);
        }
        if (forecastOptions_ != null) {
          output.writeMessage(12, getForecastOptions());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
        }
        if (comparison_
            != com.google.monitoring.v3.ComparisonType.COMPARISON_UNSPECIFIED.getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, comparison_);
        }
        if (java.lang.Double.doubleToRawLongBits(thresholdValue_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(5, thresholdValue_);
        }
        if (duration_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDuration());
        }
        if (trigger_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTrigger());
        }
        for (int i = 0; i < aggregations_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, aggregations_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(denominatorFilter_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, denominatorFilter_);
        }
        for (int i = 0; i < denominatorAggregations_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  10, denominatorAggregations_.get(i));
        }
        if (evaluationMissingData_
            != com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
                .EVALUATION_MISSING_DATA_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, evaluationMissingData_);
        }
        if (forecastOptions_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(12, getForecastOptions());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold other =
            (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) obj;

        if (!getFilter().equals(other.getFilter())) return false;
        if (!getAggregationsList().equals(other.getAggregationsList())) return false;
        if (!getDenominatorFilter().equals(other.getDenominatorFilter())) return false;
        if (!getDenominatorAggregationsList().equals(other.getDenominatorAggregationsList()))
          return false;
        if (hasForecastOptions() != other.hasForecastOptions()) return false;
        if (hasForecastOptions()) {
          if (!getForecastOptions().equals(other.getForecastOptions())) return false;
        }
        if (comparison_ != other.comparison_) return false;
        if (java.lang.Double.doubleToLongBits(getThresholdValue())
            != java.lang.Double.doubleToLongBits(other.getThresholdValue())) return false;
        if (hasDuration() != other.hasDuration()) return false;
        if (hasDuration()) {
          if (!getDuration().equals(other.getDuration())) return false;
        }
        if (hasTrigger() != other.hasTrigger()) return false;
        if (hasTrigger()) {
          if (!getTrigger().equals(other.getTrigger())) return false;
        }
        if (evaluationMissingData_ != other.evaluationMissingData_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
        if (getAggregationsCount() > 0) {
          hash = (37 * hash) + AGGREGATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getAggregationsList().hashCode();
        }
        hash = (37 * hash) + DENOMINATOR_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getDenominatorFilter().hashCode();
        if (getDenominatorAggregationsCount() > 0) {
          hash = (37 * hash) + DENOMINATOR_AGGREGATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getDenominatorAggregationsList().hashCode();
        }
        if (hasForecastOptions()) {
          hash = (37 * hash) + FORECAST_OPTIONS_FIELD_NUMBER;
          hash = (53 * hash) + getForecastOptions().hashCode();
        }
        hash = (37 * hash) + COMPARISON_FIELD_NUMBER;
        hash = (53 * hash) + comparison_;
        hash = (37 * hash) + THRESHOLD_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getThresholdValue()));
        if (hasDuration()) {
          hash = (37 * hash) + DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getDuration().hashCode();
        }
        if (hasTrigger()) {
          hash = (37 * hash) + TRIGGER_FIELD_NUMBER;
          hash = (53 * hash) + getTrigger().hashCode();
        }
        hash = (37 * hash) + EVALUATION_MISSING_DATA_FIELD_NUMBER;
        hash = (53 * hash) + evaluationMissingData_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A condition type that compares a collection of time series
       * against a threshold.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.MetricThreshold}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThresholdOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.Builder.class);
        }

        // Construct using
        // com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          filter_ = "";
          if (aggregationsBuilder_ == null) {
            aggregations_ = java.util.Collections.emptyList();
          } else {
            aggregations_ = null;
            aggregationsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          denominatorFilter_ = "";
          if (denominatorAggregationsBuilder_ == null) {
            denominatorAggregations_ = java.util.Collections.emptyList();
          } else {
            denominatorAggregations_ = null;
            denominatorAggregationsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          forecastOptions_ = null;
          if (forecastOptionsBuilder_ != null) {
            forecastOptionsBuilder_.dispose();
            forecastOptionsBuilder_ = null;
          }
          comparison_ = 0;
          thresholdValue_ = 0D;
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          evaluationMissingData_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricThreshold_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold build() {
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold result =
              new com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold result) {
          if (aggregationsBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              aggregations_ = java.util.Collections.unmodifiableList(aggregations_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.aggregations_ = aggregations_;
          } else {
            result.aggregations_ = aggregationsBuilder_.build();
          }
          if (denominatorAggregationsBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              denominatorAggregations_ =
                  java.util.Collections.unmodifiableList(denominatorAggregations_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.denominatorAggregations_ = denominatorAggregations_;
          } else {
            result.denominatorAggregations_ = denominatorAggregationsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.filter_ = filter_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.denominatorFilter_ = denominatorFilter_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.forecastOptions_ =
                forecastOptionsBuilder_ == null
                    ? forecastOptions_
                    : forecastOptionsBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.comparison_ = comparison_;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.thresholdValue_ = thresholdValue_;
          }
          if (((from_bitField0_ & 0x00000080) != 0)) {
            result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000100) != 0)) {
            result.trigger_ = triggerBuilder_ == null ? trigger_ : triggerBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000200) != 0)) {
            result.evaluationMissingData_ = evaluationMissingData_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) {
            return mergeFrom(
                (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold other) {
          if (other
              == com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                  .getDefaultInstance()) return this;
          if (!other.getFilter().isEmpty()) {
            filter_ = other.filter_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (aggregationsBuilder_ == null) {
            if (!other.aggregations_.isEmpty()) {
              if (aggregations_.isEmpty()) {
                aggregations_ = other.aggregations_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureAggregationsIsMutable();
                aggregations_.addAll(other.aggregations_);
              }
              onChanged();
            }
          } else {
            if (!other.aggregations_.isEmpty()) {
              if (aggregationsBuilder_.isEmpty()) {
                aggregationsBuilder_.dispose();
                aggregationsBuilder_ = null;
                aggregations_ = other.aggregations_;
                bitField0_ = (bitField0_ & ~0x00000002);
                aggregationsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getAggregationsFieldBuilder()
                        : null;
              } else {
                aggregationsBuilder_.addAllMessages(other.aggregations_);
              }
            }
          }
          if (!other.getDenominatorFilter().isEmpty()) {
            denominatorFilter_ = other.denominatorFilter_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (denominatorAggregationsBuilder_ == null) {
            if (!other.denominatorAggregations_.isEmpty()) {
              if (denominatorAggregations_.isEmpty()) {
                denominatorAggregations_ = other.denominatorAggregations_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureDenominatorAggregationsIsMutable();
                denominatorAggregations_.addAll(other.denominatorAggregations_);
              }
              onChanged();
            }
          } else {
            if (!other.denominatorAggregations_.isEmpty()) {
              if (denominatorAggregationsBuilder_.isEmpty()) {
                denominatorAggregationsBuilder_.dispose();
                denominatorAggregationsBuilder_ = null;
                denominatorAggregations_ = other.denominatorAggregations_;
                bitField0_ = (bitField0_ & ~0x00000008);
                denominatorAggregationsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDenominatorAggregationsFieldBuilder()
                        : null;
              } else {
                denominatorAggregationsBuilder_.addAllMessages(other.denominatorAggregations_);
              }
            }
          }
          if (other.hasForecastOptions()) {
            mergeForecastOptions(other.getForecastOptions());
          }
          if (other.comparison_ != 0) {
            setComparisonValue(other.getComparisonValue());
          }
          if (other.getThresholdValue() != 0D) {
            setThresholdValue(other.getThresholdValue());
          }
          if (other.hasDuration()) {
            mergeDuration(other.getDuration());
          }
          if (other.hasTrigger()) {
            mergeTrigger(other.getTrigger());
          }
          if (other.evaluationMissingData_ != 0) {
            setEvaluationMissingDataValue(other.getEvaluationMissingDataValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 18:
                  {
                    filter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 18
                case 32:
                  {
                    comparison_ = input.readEnum();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 32
                case 41:
                  {
                    thresholdValue_ = input.readDouble();
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 41
                case 50:
                  {
                    input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000080;
                    break;
                  } // case 50
                case 58:
                  {
                    input.readMessage(getTriggerFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000100;
                    break;
                  } // case 58
                case 66:
                  {
                    com.google.monitoring.v3.Aggregation m =
                        input.readMessage(
                            com.google.monitoring.v3.Aggregation.parser(), extensionRegistry);
                    if (aggregationsBuilder_ == null) {
                      ensureAggregationsIsMutable();
                      aggregations_.add(m);
                    } else {
                      aggregationsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 66
                case 74:
                  {
                    denominatorFilter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 74
                case 82:
                  {
                    com.google.monitoring.v3.Aggregation m =
                        input.readMessage(
                            com.google.monitoring.v3.Aggregation.parser(), extensionRegistry);
                    if (denominatorAggregationsBuilder_ == null) {
                      ensureDenominatorAggregationsIsMutable();
                      denominatorAggregations_.add(m);
                    } else {
                      denominatorAggregationsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 82
                case 88:
                  {
                    evaluationMissingData_ = input.readEnum();
                    bitField0_ |= 0x00000200;
                    break;
                  } // case 88
                case 98:
                  {
                    input.readMessage(
                        getForecastOptionsFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 98
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object filter_ = "";
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The filter.
         */
        public java.lang.String getFilter() {
          java.lang.Object ref = filter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            filter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for filter.
         */
        public com.google.protobuf.ByteString getFilterBytes() {
          java.lang.Object ref = filter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            filter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFilter() {
          filter_ = getDefaultInstance().getFilter();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.util.List<com.google.monitoring.v3.Aggregation> aggregations_ =
            java.util.Collections.emptyList();

        private void ensureAggregationsIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            aggregations_ =
                new java.util.ArrayList<com.google.monitoring.v3.Aggregation>(aggregations_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            aggregationsBuilder_;

        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList() {
          if (aggregationsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(aggregations_);
          } else {
            return aggregationsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public int getAggregationsCount() {
          if (aggregationsBuilder_ == null) {
            return aggregations_.size();
          } else {
            return aggregationsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public com.google.monitoring.v3.Aggregation getAggregations(int index) {
          if (aggregationsBuilder_ == null) {
            return aggregations_.get(index);
          } else {
            return aggregationsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder setAggregations(int index, com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.set(index, value);
            onChanged();
          } else {
            aggregationsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder setAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.set(index, builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder addAggregations(com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.add(value);
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder addAggregations(int index, com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.add(index, value);
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder addAggregations(
            com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.add(builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder addAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.add(index, builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder addAllAggregations(
            java.lang.Iterable<? extends com.google.monitoring.v3.Aggregation> values) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, aggregations_);
            onChanged();
          } else {
            aggregationsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder clearAggregations() {
          if (aggregationsBuilder_ == null) {
            aggregations_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            aggregationsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public Builder removeAggregations(int index) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.remove(index);
            onChanged();
          } else {
            aggregationsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder getAggregationsBuilder(int index) {
          return getAggregationsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index) {
          if (aggregationsBuilder_ == null) {
            return aggregations_.get(index);
          } else {
            return aggregationsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
            getAggregationsOrBuilderList() {
          if (aggregationsBuilder_ != null) {
            return aggregationsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(aggregations_);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addAggregationsBuilder() {
          return getAggregationsFieldBuilder()
              .addBuilder(com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addAggregationsBuilder(int index) {
          return getAggregationsFieldBuilder()
              .addBuilder(index, com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 8;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation.Builder>
            getAggregationsBuilderList() {
          return getAggregationsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            getAggregationsFieldBuilder() {
          if (aggregationsBuilder_ == null) {
            aggregationsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.monitoring.v3.Aggregation,
                    com.google.monitoring.v3.Aggregation.Builder,
                    com.google.monitoring.v3.AggregationOrBuilder>(
                    aggregations_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            aggregations_ = null;
          }
          return aggregationsBuilder_;
        }

        private java.lang.Object denominatorFilter_ = "";
        /**
         *
         *
         * <pre>
         * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies a time series that should be used as the denominator of a
         * ratio that will be compared with the threshold. If a
         * `denominator_filter` is specified, the time series specified by the
         * `filter` field will be used as the numerator.
         *
         * The filter must specify the metric type and optionally may contain
         * restrictions on resource type, resource labels, and metric labels.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string denominator_filter = 9;</code>
         *
         * @return The denominatorFilter.
         */
        public java.lang.String getDenominatorFilter() {
          java.lang.Object ref = denominatorFilter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            denominatorFilter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies a time series that should be used as the denominator of a
         * ratio that will be compared with the threshold. If a
         * `denominator_filter` is specified, the time series specified by the
         * `filter` field will be used as the numerator.
         *
         * The filter must specify the metric type and optionally may contain
         * restrictions on resource type, resource labels, and metric labels.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string denominator_filter = 9;</code>
         *
         * @return The bytes for denominatorFilter.
         */
        public com.google.protobuf.ByteString getDenominatorFilterBytes() {
          java.lang.Object ref = denominatorFilter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            denominatorFilter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies a time series that should be used as the denominator of a
         * ratio that will be compared with the threshold. If a
         * `denominator_filter` is specified, the time series specified by the
         * `filter` field will be used as the numerator.
         *
         * The filter must specify the metric type and optionally may contain
         * restrictions on resource type, resource labels, and metric labels.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string denominator_filter = 9;</code>
         *
         * @param value The denominatorFilter to set.
         * @return This builder for chaining.
         */
        public Builder setDenominatorFilter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          denominatorFilter_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies a time series that should be used as the denominator of a
         * ratio that will be compared with the threshold. If a
         * `denominator_filter` is specified, the time series specified by the
         * `filter` field will be used as the numerator.
         *
         * The filter must specify the metric type and optionally may contain
         * restrictions on resource type, resource labels, and metric labels.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string denominator_filter = 9;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDenominatorFilter() {
          denominatorFilter_ = getDefaultInstance().getDenominatorFilter();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies a time series that should be used as the denominator of a
         * ratio that will be compared with the threshold. If a
         * `denominator_filter` is specified, the time series specified by the
         * `filter` field will be used as the numerator.
         *
         * The filter must specify the metric type and optionally may contain
         * restrictions on resource type, resource labels, and metric labels.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string denominator_filter = 9;</code>
         *
         * @param value The bytes for denominatorFilter to set.
         * @return This builder for chaining.
         */
        public Builder setDenominatorFilterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          denominatorFilter_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.util.List<com.google.monitoring.v3.Aggregation> denominatorAggregations_ =
            java.util.Collections.emptyList();

        private void ensureDenominatorAggregationsIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            denominatorAggregations_ =
                new java.util.ArrayList<com.google.monitoring.v3.Aggregation>(
                    denominatorAggregations_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            denominatorAggregationsBuilder_;

        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation>
            getDenominatorAggregationsList() {
          if (denominatorAggregationsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(denominatorAggregations_);
          } else {
            return denominatorAggregationsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public int getDenominatorAggregationsCount() {
          if (denominatorAggregationsBuilder_ == null) {
            return denominatorAggregations_.size();
          } else {
            return denominatorAggregationsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public com.google.monitoring.v3.Aggregation getDenominatorAggregations(int index) {
          if (denominatorAggregationsBuilder_ == null) {
            return denominatorAggregations_.get(index);
          } else {
            return denominatorAggregationsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder setDenominatorAggregations(
            int index, com.google.monitoring.v3.Aggregation value) {
          if (denominatorAggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.set(index, value);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder setDenominatorAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (denominatorAggregationsBuilder_ == null) {
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.set(index, builderForValue.build());
            onChanged();
          } else {
            denominatorAggregationsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder addDenominatorAggregations(com.google.monitoring.v3.Aggregation value) {
          if (denominatorAggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.add(value);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder addDenominatorAggregations(
            int index, com.google.monitoring.v3.Aggregation value) {
          if (denominatorAggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.add(index, value);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder addDenominatorAggregations(
            com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (denominatorAggregationsBuilder_ == null) {
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.add(builderForValue.build());
            onChanged();
          } else {
            denominatorAggregationsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder addDenominatorAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (denominatorAggregationsBuilder_ == null) {
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.add(index, builderForValue.build());
            onChanged();
          } else {
            denominatorAggregationsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder addAllDenominatorAggregations(
            java.lang.Iterable<? extends com.google.monitoring.v3.Aggregation> values) {
          if (denominatorAggregationsBuilder_ == null) {
            ensureDenominatorAggregationsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, denominatorAggregations_);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder clearDenominatorAggregations() {
          if (denominatorAggregationsBuilder_ == null) {
            denominatorAggregations_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public Builder removeDenominatorAggregations(int index) {
          if (denominatorAggregationsBuilder_ == null) {
            ensureDenominatorAggregationsIsMutable();
            denominatorAggregations_.remove(index);
            onChanged();
          } else {
            denominatorAggregationsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder getDenominatorAggregationsBuilder(
            int index) {
          return getDenominatorAggregationsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public com.google.monitoring.v3.AggregationOrBuilder getDenominatorAggregationsOrBuilder(
            int index) {
          if (denominatorAggregationsBuilder_ == null) {
            return denominatorAggregations_.get(index);
          } else {
            return denominatorAggregationsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
            getDenominatorAggregationsOrBuilderList() {
          if (denominatorAggregationsBuilder_ != null) {
            return denominatorAggregationsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(denominatorAggregations_);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addDenominatorAggregationsBuilder() {
          return getDenominatorAggregationsFieldBuilder()
              .addBuilder(com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addDenominatorAggregationsBuilder(
            int index) {
          return getDenominatorAggregationsFieldBuilder()
              .addBuilder(index, com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series
         * selected by `denominatorFilter` as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources).
         *
         * When computing ratios, the `aggregations` and
         * `denominator_aggregations` fields must use the same alignment period
         * and produce time series that have the same periodicity and labels.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation denominator_aggregations = 10;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation.Builder>
            getDenominatorAggregationsBuilderList() {
          return getDenominatorAggregationsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            getDenominatorAggregationsFieldBuilder() {
          if (denominatorAggregationsBuilder_ == null) {
            denominatorAggregationsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.monitoring.v3.Aggregation,
                    com.google.monitoring.v3.Aggregation.Builder,
                    com.google.monitoring.v3.AggregationOrBuilder>(
                    denominatorAggregations_,
                    ((bitField0_ & 0x00000008) != 0),
                    getParentForChildren(),
                    isClean());
            denominatorAggregations_ = null;
          }
          return denominatorAggregationsBuilder_;
        }

        private com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            forecastOptions_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                    .Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                    .ForecastOptionsOrBuilder>
            forecastOptionsBuilder_;
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         *
         * @return Whether the forecastOptions field is set.
         */
        public boolean hasForecastOptions() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         *
         * @return The forecastOptions.
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
            getForecastOptions() {
          if (forecastOptionsBuilder_ == null) {
            return forecastOptions_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                    .getDefaultInstance()
                : forecastOptions_;
          } else {
            return forecastOptionsBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public Builder setForecastOptions(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions value) {
          if (forecastOptionsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            forecastOptions_ = value;
          } else {
            forecastOptionsBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public Builder setForecastOptions(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions.Builder
                builderForValue) {
          if (forecastOptionsBuilder_ == null) {
            forecastOptions_ = builderForValue.build();
          } else {
            forecastOptionsBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public Builder mergeForecastOptions(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions value) {
          if (forecastOptionsBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0)
                && forecastOptions_ != null
                && forecastOptions_
                    != com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                        .ForecastOptions.getDefaultInstance()) {
              getForecastOptionsBuilder().mergeFrom(value);
            } else {
              forecastOptions_ = value;
            }
          } else {
            forecastOptionsBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public Builder clearForecastOptions() {
          bitField0_ = (bitField0_ & ~0x00000010);
          forecastOptions_ = null;
          if (forecastOptionsBuilder_ != null) {
            forecastOptionsBuilder_.dispose();
            forecastOptionsBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                .Builder
            getForecastOptionsBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getForecastOptionsFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                .ForecastOptionsOrBuilder
            getForecastOptionsOrBuilder() {
          if (forecastOptionsBuilder_ != null) {
            return forecastOptionsBuilder_.getMessageOrBuilder();
          } else {
            return forecastOptions_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                    .getDefaultInstance()
                : forecastOptions_;
          }
        }
        /**
         *
         *
         * <pre>
         * When this field is present, the `MetricThreshold` condition forecasts
         * whether the time series is predicted to violate the threshold within
         * the `forecast_horizon`. When this field is not set, the
         * `MetricThreshold` tests the current value of the timeseries against the
         * threshold.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions forecast_options = 12;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                    .Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                    .ForecastOptionsOrBuilder>
            getForecastOptionsFieldBuilder() {
          if (forecastOptionsBuilder_ == null) {
            forecastOptionsBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions,
                    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.ForecastOptions
                        .Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                        .ForecastOptionsOrBuilder>(
                    getForecastOptions(), getParentForChildren(), isClean());
            forecastOptions_ = null;
          }
          return forecastOptionsBuilder_;
        }

        private int comparison_ = 0;
        /**
         *
         *
         * <pre>
         * The comparison to apply between the time series (indicated by `filter`
         * and `aggregation`) and the threshold (indicated by `threshold_value`).
         * The comparison is applied on each time series, with the time series
         * on the left-hand side and the threshold on the right-hand side.
         *
         * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
         * </pre>
         *
         * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
         *
         * @return The enum numeric value on the wire for comparison.
         */
        @java.lang.Override
        public int getComparisonValue() {
          return comparison_;
        }
        /**
         *
         *
         * <pre>
         * The comparison to apply between the time series (indicated by `filter`
         * and `aggregation`) and the threshold (indicated by `threshold_value`).
         * The comparison is applied on each time series, with the time series
         * on the left-hand side and the threshold on the right-hand side.
         *
         * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
         * </pre>
         *
         * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
         *
         * @param value The enum numeric value on the wire for comparison to set.
         * @return This builder for chaining.
         */
        public Builder setComparisonValue(int value) {
          comparison_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The comparison to apply between the time series (indicated by `filter`
         * and `aggregation`) and the threshold (indicated by `threshold_value`).
         * The comparison is applied on each time series, with the time series
         * on the left-hand side and the threshold on the right-hand side.
         *
         * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
         * </pre>
         *
         * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
         *
         * @return The comparison.
         */
        @java.lang.Override
        public com.google.monitoring.v3.ComparisonType getComparison() {
          com.google.monitoring.v3.ComparisonType result =
              com.google.monitoring.v3.ComparisonType.forNumber(comparison_);
          return result == null ? com.google.monitoring.v3.ComparisonType.UNRECOGNIZED : result;
        }
        /**
         *
         *
         * <pre>
         * The comparison to apply between the time series (indicated by `filter`
         * and `aggregation`) and the threshold (indicated by `threshold_value`).
         * The comparison is applied on each time series, with the time series
         * on the left-hand side and the threshold on the right-hand side.
         *
         * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
         * </pre>
         *
         * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
         *
         * @param value The comparison to set.
         * @return This builder for chaining.
         */
        public Builder setComparison(com.google.monitoring.v3.ComparisonType value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000020;
          comparison_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The comparison to apply between the time series (indicated by `filter`
         * and `aggregation`) and the threshold (indicated by `threshold_value`).
         * The comparison is applied on each time series, with the time series
         * on the left-hand side and the threshold on the right-hand side.
         *
         * Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
         * </pre>
         *
         * <code>.google.monitoring.v3.ComparisonType comparison = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearComparison() {
          bitField0_ = (bitField0_ & ~0x00000020);
          comparison_ = 0;
          onChanged();
          return this;
        }

        private double thresholdValue_;
        /**
         *
         *
         * <pre>
         * A value against which to compare the time series.
         * </pre>
         *
         * <code>double threshold_value = 5;</code>
         *
         * @return The thresholdValue.
         */
        @java.lang.Override
        public double getThresholdValue() {
          return thresholdValue_;
        }
        /**
         *
         *
         * <pre>
         * A value against which to compare the time series.
         * </pre>
         *
         * <code>double threshold_value = 5;</code>
         *
         * @param value The thresholdValue to set.
         * @return This builder for chaining.
         */
        public Builder setThresholdValue(double value) {

          thresholdValue_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A value against which to compare the time series.
         * </pre>
         *
         * <code>double threshold_value = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearThresholdValue() {
          bitField0_ = (bitField0_ & ~0x00000040);
          thresholdValue_ = 0D;
          onChanged();
          return this;
        }

        private com.google.protobuf.Duration duration_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            durationBuilder_;
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         *
         * @return Whether the duration field is set.
         */
        public boolean hasDuration() {
          return ((bitField0_ & 0x00000080) != 0);
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         *
         * @return The duration.
         */
        public com.google.protobuf.Duration getDuration() {
          if (durationBuilder_ == null) {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          } else {
            return durationBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            duration_ = value;
          } else {
            durationBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
          if (durationBuilder_ == null) {
            duration_ = builderForValue.build();
          } else {
            durationBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public Builder mergeDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (((bitField0_ & 0x00000080) != 0)
                && duration_ != null
                && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getDurationBuilder().mergeFrom(value);
            } else {
              duration_ = value;
            }
          } else {
            durationBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public Builder clearDuration() {
          bitField0_ = (bitField0_ & ~0x00000080);
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public com.google.protobuf.Duration.Builder getDurationBuilder() {
          bitField0_ |= 0x00000080;
          onChanged();
          return getDurationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
          if (durationBuilder_ != null) {
            return durationBuilder_.getMessageOrBuilder();
          } else {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 6;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getDurationFieldBuilder() {
          if (durationBuilder_ == null) {
            durationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getDuration(), getParentForChildren(), isClean());
            duration_ = null;
          }
          return durationBuilder_;
        }

        private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            triggerBuilder_;
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         *
         * @return Whether the trigger field is set.
         */
        public boolean hasTrigger() {
          return ((bitField0_ & 0x00000100) != 0);
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         *
         * @return The trigger.
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
          if (triggerBuilder_ == null) {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          } else {
            return triggerBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public Builder setTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            trigger_ = value;
          } else {
            triggerBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public Builder setTrigger(
            com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder builderForValue) {
          if (triggerBuilder_ == null) {
            trigger_ = builderForValue.build();
          } else {
            triggerBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public Builder mergeTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (((bitField0_ & 0x00000100) != 0)
                && trigger_ != null
                && trigger_
                    != com.google.monitoring.v3.AlertPolicy.Condition.Trigger
                        .getDefaultInstance()) {
              getTriggerBuilder().mergeFrom(value);
            } else {
              trigger_ = value;
            }
          } else {
            triggerBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public Builder clearTrigger() {
          bitField0_ = (bitField0_ & ~0x00000100);
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder getTriggerBuilder() {
          bitField0_ |= 0x00000100;
          onChanged();
          return getTriggerFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder
            getTriggerOrBuilder() {
          if (triggerBuilder_ != null) {
            return triggerBuilder_.getMessageOrBuilder();
          } else {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 7;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            getTriggerFieldBuilder() {
          if (triggerBuilder_ == null) {
            triggerBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>(
                    getTrigger(), getParentForChildren(), isClean());
            trigger_ = null;
          }
          return triggerBuilder_;
        }

        private int evaluationMissingData_ = 0;
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
         * </code>
         *
         * @return The enum numeric value on the wire for evaluationMissingData.
         */
        @java.lang.Override
        public int getEvaluationMissingDataValue() {
          return evaluationMissingData_;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
         * </code>
         *
         * @param value The enum numeric value on the wire for evaluationMissingData to set.
         * @return This builder for chaining.
         */
        public Builder setEvaluationMissingDataValue(int value) {
          evaluationMissingData_ = value;
          bitField0_ |= 0x00000200;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
         * </code>
         *
         * @return The evaluationMissingData.
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
            getEvaluationMissingData() {
          com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData result =
              com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.forNumber(
                  evaluationMissingData_);
          return result == null
              ? com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
         * </code>
         *
         * @param value The evaluationMissingData to set.
         * @return This builder for chaining.
         */
        public Builder setEvaluationMissingData(
            com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000200;
          evaluationMissingData_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 11;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEvaluationMissingData() {
          bitField0_ = (bitField0_ & ~0x00000200);
          evaluationMissingData_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.MetricThreshold)
      private static final com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MetricThreshold> PARSER =
          new com.google.protobuf.AbstractParser<MetricThreshold>() {
            @java.lang.Override
            public MetricThreshold parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MetricThreshold> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MetricThreshold> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MetricAbsenceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      java.lang.String getFilter();
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      com.google.protobuf.ByteString getFilterBytes();

      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      com.google.monitoring.v3.Aggregation getAggregations(int index);
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      int getAggregationsCount();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getAggregationsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return Whether the duration field is set.
       */
      boolean hasDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return The duration.
       */
      com.google.protobuf.Duration getDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return Whether the trigger field is set.
       */
      boolean hasTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return The trigger.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * A condition type that checks that monitored resources
     * are reporting data. The configuration defines a metric and
     * a set of monitored resources. The predicate is considered in violation
     * when a time series for the specified metric of a monitored
     * resource does not include any data in the specified `duration`.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.MetricAbsence}
     */
    public static final class MetricAbsence extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)
        MetricAbsenceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MetricAbsence.newBuilder() to construct.
      private MetricAbsence(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MetricAbsence() {
        filter_ = "";
        aggregations_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MetricAbsence();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricAbsence_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricAbsence_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.class,
                com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.Builder.class);
      }

      public static final int FILTER_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      @java.lang.Override
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A
       * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
       * identifies which time series should be compared with the threshold.
       *
       * The filter is similar to the one that is specified in the
       * [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
       * (that call is useful to verify the time series that will be retrieved /
       * processed). The filter must specify the metric type and the resource
       * type. Optionally, it can specify resource labels and metric labels.
       * This field must not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int AGGREGATIONS_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private java.util.List<com.google.monitoring.v3.Aggregation> aggregations_;
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList() {
        return aggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
          getAggregationsOrBuilderList() {
        return aggregations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      @java.lang.Override
      public int getAggregationsCount() {
        return aggregations_.size();
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.Aggregation getAggregations(int index) {
        return aggregations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies the alignment of data points in individual time series as
       * well as how to combine the retrieved time series together (such as
       * when aggregating multiple streams on each resource to a single
       * stream for each resource or when aggregating streams across all
       * members of a group of resources). Multiple aggregations
       * are applied in the order specified.
       *
       * This field is similar to the one in the [`ListTimeSeries`
       * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
       * It is advisable to use the `ListTimeSeries` method when debugging this
       * field.
       * </pre>
       *
       * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index) {
        return aggregations_.get(index);
      }

      public static final int DURATION_FIELD_NUMBER = 2;
      private com.google.protobuf.Duration duration_;
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return Whether the duration field is set.
       */
      @java.lang.Override
      public boolean hasDuration() {
        return duration_ != null;
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return The duration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getDuration() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must fail to report new
       * data to be considered failing. The minimum value of this field
       * is 120 seconds. Larger values that are a multiple of a
       * minute--for example, 240 or 300 seconds--are supported.
       * If an invalid value is given, an
       * error will be returned. The `Duration.nanos` field is
       * ignored.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }

      public static final int TRIGGER_FIELD_NUMBER = 3;
      private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return Whether the trigger field is set.
       */
      @java.lang.Override
      public boolean hasTrigger() {
        return trigger_ != null;
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return The trigger.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, filter_);
        }
        if (duration_ != null) {
          output.writeMessage(2, getDuration());
        }
        if (trigger_ != null) {
          output.writeMessage(3, getTrigger());
        }
        for (int i = 0; i < aggregations_.size(); i++) {
          output.writeMessage(5, aggregations_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, filter_);
        }
        if (duration_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDuration());
        }
        if (trigger_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTrigger());
        }
        for (int i = 0; i < aggregations_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, aggregations_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence other =
            (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) obj;

        if (!getFilter().equals(other.getFilter())) return false;
        if (!getAggregationsList().equals(other.getAggregationsList())) return false;
        if (hasDuration() != other.hasDuration()) return false;
        if (hasDuration()) {
          if (!getDuration().equals(other.getDuration())) return false;
        }
        if (hasTrigger() != other.hasTrigger()) return false;
        if (hasTrigger()) {
          if (!getTrigger().equals(other.getTrigger())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
        if (getAggregationsCount() > 0) {
          hash = (37 * hash) + AGGREGATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getAggregationsList().hashCode();
        }
        if (hasDuration()) {
          hash = (37 * hash) + DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getDuration().hashCode();
        }
        if (hasTrigger()) {
          hash = (37 * hash) + TRIGGER_FIELD_NUMBER;
          hash = (53 * hash) + getTrigger().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A condition type that checks that monitored resources
       * are reporting data. The configuration defines a metric and
       * a set of monitored resources. The predicate is considered in violation
       * when a time series for the specified metric of a monitored
       * resource does not include any data in the specified `duration`.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.MetricAbsence}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)
          com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsenceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricAbsence_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricAbsence_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.Builder.class);
        }

        // Construct using com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          filter_ = "";
          if (aggregationsBuilder_ == null) {
            aggregations_ = java.util.Collections.emptyList();
          } else {
            aggregations_ = null;
            aggregationsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MetricAbsence_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence build() {
          com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence result =
              new com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence result) {
          if (aggregationsBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              aggregations_ = java.util.Collections.unmodifiableList(aggregations_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.aggregations_ = aggregations_;
          } else {
            result.aggregations_ = aggregationsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.filter_ = filter_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.trigger_ = triggerBuilder_ == null ? trigger_ : triggerBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) {
            return mergeFrom((com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence other) {
          if (other
              == com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance())
            return this;
          if (!other.getFilter().isEmpty()) {
            filter_ = other.filter_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (aggregationsBuilder_ == null) {
            if (!other.aggregations_.isEmpty()) {
              if (aggregations_.isEmpty()) {
                aggregations_ = other.aggregations_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureAggregationsIsMutable();
                aggregations_.addAll(other.aggregations_);
              }
              onChanged();
            }
          } else {
            if (!other.aggregations_.isEmpty()) {
              if (aggregationsBuilder_.isEmpty()) {
                aggregationsBuilder_.dispose();
                aggregationsBuilder_ = null;
                aggregations_ = other.aggregations_;
                bitField0_ = (bitField0_ & ~0x00000002);
                aggregationsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getAggregationsFieldBuilder()
                        : null;
              } else {
                aggregationsBuilder_.addAllMessages(other.aggregations_);
              }
            }
          }
          if (other.hasDuration()) {
            mergeDuration(other.getDuration());
          }
          if (other.hasTrigger()) {
            mergeTrigger(other.getTrigger());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    filter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getTriggerFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 26
                case 42:
                  {
                    com.google.monitoring.v3.Aggregation m =
                        input.readMessage(
                            com.google.monitoring.v3.Aggregation.parser(), extensionRegistry);
                    if (aggregationsBuilder_ == null) {
                      ensureAggregationsIsMutable();
                      aggregations_.add(m);
                    } else {
                      aggregationsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object filter_ = "";
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The filter.
         */
        public java.lang.String getFilter() {
          java.lang.Object ref = filter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            filter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for filter.
         */
        public com.google.protobuf.ByteString getFilterBytes() {
          java.lang.Object ref = filter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            filter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFilter() {
          filter_ = getDefaultInstance().getFilter();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A
         * [filter](https://cloud.google.com/monitoring/api/v3/filters) that
         * identifies which time series should be compared with the threshold.
         *
         * The filter is similar to the one that is specified in the
         * [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
         * (that call is useful to verify the time series that will be retrieved /
         * processed). The filter must specify the metric type and the resource
         * type. Optionally, it can specify resource labels and metric labels.
         * This field must not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.util.List<com.google.monitoring.v3.Aggregation> aggregations_ =
            java.util.Collections.emptyList();

        private void ensureAggregationsIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            aggregations_ =
                new java.util.ArrayList<com.google.monitoring.v3.Aggregation>(aggregations_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            aggregationsBuilder_;

        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation> getAggregationsList() {
          if (aggregationsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(aggregations_);
          } else {
            return aggregationsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public int getAggregationsCount() {
          if (aggregationsBuilder_ == null) {
            return aggregations_.size();
          } else {
            return aggregationsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public com.google.monitoring.v3.Aggregation getAggregations(int index) {
          if (aggregationsBuilder_ == null) {
            return aggregations_.get(index);
          } else {
            return aggregationsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder setAggregations(int index, com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.set(index, value);
            onChanged();
          } else {
            aggregationsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder setAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.set(index, builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder addAggregations(com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.add(value);
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder addAggregations(int index, com.google.monitoring.v3.Aggregation value) {
          if (aggregationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAggregationsIsMutable();
            aggregations_.add(index, value);
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder addAggregations(
            com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.add(builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder addAggregations(
            int index, com.google.monitoring.v3.Aggregation.Builder builderForValue) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.add(index, builderForValue.build());
            onChanged();
          } else {
            aggregationsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder addAllAggregations(
            java.lang.Iterable<? extends com.google.monitoring.v3.Aggregation> values) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, aggregations_);
            onChanged();
          } else {
            aggregationsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder clearAggregations() {
          if (aggregationsBuilder_ == null) {
            aggregations_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            aggregationsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public Builder removeAggregations(int index) {
          if (aggregationsBuilder_ == null) {
            ensureAggregationsIsMutable();
            aggregations_.remove(index);
            onChanged();
          } else {
            aggregationsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder getAggregationsBuilder(int index) {
          return getAggregationsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public com.google.monitoring.v3.AggregationOrBuilder getAggregationsOrBuilder(int index) {
          if (aggregationsBuilder_ == null) {
            return aggregations_.get(index);
          } else {
            return aggregationsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public java.util.List<? extends com.google.monitoring.v3.AggregationOrBuilder>
            getAggregationsOrBuilderList() {
          if (aggregationsBuilder_ != null) {
            return aggregationsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(aggregations_);
          }
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addAggregationsBuilder() {
          return getAggregationsFieldBuilder()
              .addBuilder(com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public com.google.monitoring.v3.Aggregation.Builder addAggregationsBuilder(int index) {
          return getAggregationsFieldBuilder()
              .addBuilder(index, com.google.monitoring.v3.Aggregation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specifies the alignment of data points in individual time series as
         * well as how to combine the retrieved time series together (such as
         * when aggregating multiple streams on each resource to a single
         * stream for each resource or when aggregating streams across all
         * members of a group of resources). Multiple aggregations
         * are applied in the order specified.
         *
         * This field is similar to the one in the [`ListTimeSeries`
         * request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
         * It is advisable to use the `ListTimeSeries` method when debugging this
         * field.
         * </pre>
         *
         * <code>repeated .google.monitoring.v3.Aggregation aggregations = 5;</code>
         */
        public java.util.List<com.google.monitoring.v3.Aggregation.Builder>
            getAggregationsBuilderList() {
          return getAggregationsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Aggregation,
                com.google.monitoring.v3.Aggregation.Builder,
                com.google.monitoring.v3.AggregationOrBuilder>
            getAggregationsFieldBuilder() {
          if (aggregationsBuilder_ == null) {
            aggregationsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.monitoring.v3.Aggregation,
                    com.google.monitoring.v3.Aggregation.Builder,
                    com.google.monitoring.v3.AggregationOrBuilder>(
                    aggregations_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            aggregations_ = null;
          }
          return aggregationsBuilder_;
        }

        private com.google.protobuf.Duration duration_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            durationBuilder_;
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         *
         * @return Whether the duration field is set.
         */
        public boolean hasDuration() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         *
         * @return The duration.
         */
        public com.google.protobuf.Duration getDuration() {
          if (durationBuilder_ == null) {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          } else {
            return durationBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            duration_ = value;
          } else {
            durationBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
          if (durationBuilder_ == null) {
            duration_ = builderForValue.build();
          } else {
            durationBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder mergeDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && duration_ != null
                && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getDurationBuilder().mergeFrom(value);
            } else {
              duration_ = value;
            }
          } else {
            durationBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder clearDuration() {
          bitField0_ = (bitField0_ & ~0x00000004);
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public com.google.protobuf.Duration.Builder getDurationBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getDurationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
          if (durationBuilder_ != null) {
            return durationBuilder_.getMessageOrBuilder();
          } else {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must fail to report new
         * data to be considered failing. The minimum value of this field
         * is 120 seconds. Larger values that are a multiple of a
         * minute--for example, 240 or 300 seconds--are supported.
         * If an invalid value is given, an
         * error will be returned. The `Duration.nanos` field is
         * ignored.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getDurationFieldBuilder() {
          if (durationBuilder_ == null) {
            durationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getDuration(), getParentForChildren(), isClean());
            duration_ = null;
          }
          return durationBuilder_;
        }

        private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            triggerBuilder_;
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         *
         * @return Whether the trigger field is set.
         */
        public boolean hasTrigger() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         *
         * @return The trigger.
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
          if (triggerBuilder_ == null) {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          } else {
            return triggerBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder setTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            trigger_ = value;
          } else {
            triggerBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder setTrigger(
            com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder builderForValue) {
          if (triggerBuilder_ == null) {
            trigger_ = builderForValue.build();
          } else {
            triggerBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder mergeTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)
                && trigger_ != null
                && trigger_
                    != com.google.monitoring.v3.AlertPolicy.Condition.Trigger
                        .getDefaultInstance()) {
              getTriggerBuilder().mergeFrom(value);
            } else {
              trigger_ = value;
            }
          } else {
            triggerBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder clearTrigger() {
          bitField0_ = (bitField0_ & ~0x00000008);
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder getTriggerBuilder() {
          bitField0_ |= 0x00000008;
          onChanged();
          return getTriggerFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder
            getTriggerOrBuilder() {
          if (triggerBuilder_ != null) {
            return triggerBuilder_.getMessageOrBuilder();
          } else {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            getTriggerFieldBuilder() {
          if (triggerBuilder_ == null) {
            triggerBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>(
                    getTrigger(), getParentForChildren(), isClean());
            trigger_ = null;
          }
          return triggerBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.MetricAbsence)
      private static final com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MetricAbsence> PARSER =
          new com.google.protobuf.AbstractParser<MetricAbsence>() {
            @java.lang.Override
            public MetricAbsence parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MetricAbsence> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MetricAbsence> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface LogMatchOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.LogMatch)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. A logs-based filter. See [Advanced Logs
       * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
       * for how this filter should be constructed.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      java.lang.String getFilter();
      /**
       *
       *
       * <pre>
       * Required. A logs-based filter. See [Advanced Logs
       * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
       * for how this filter should be constructed.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      com.google.protobuf.ByteString getFilterBytes();

      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      int getLabelExtractorsCount();
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      boolean containsLabelExtractors(java.lang.String key);
      /** Use {@link #getLabelExtractorsMap()} instead. */
      @java.lang.Deprecated
      java.util.Map<java.lang.String, java.lang.String> getLabelExtractors();
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      java.util.Map<java.lang.String, java.lang.String> getLabelExtractorsMap();
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      /* nullable */
      java.lang.String getLabelExtractorsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue);
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      java.lang.String getLabelExtractorsOrThrow(java.lang.String key);
    }
    /**
     *
     *
     * <pre>
     * A condition type that checks whether a log message in the [scoping
     * project](https://cloud.google.com/monitoring/api/v3#project_name)
     * satisfies the given filter. Logs from other projects in the metrics
     * scope are not evaluated.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.LogMatch}
     */
    public static final class LogMatch extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.LogMatch)
        LogMatchOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use LogMatch.newBuilder() to construct.
      private LogMatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private LogMatch() {
        filter_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new LogMatch();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      @java.lang.Override
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 2:
            return internalGetLabelExtractors();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.class,
                com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.Builder.class);
      }

      public static final int FILTER_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Required. A logs-based filter. See [Advanced Logs
       * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
       * for how this filter should be constructed.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      @java.lang.Override
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A logs-based filter. See [Advanced Logs
       * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
       * for how this filter should be constructed.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int LABEL_EXTRACTORS_FIELD_NUMBER = 2;

      private static final class LabelExtractorsDefaultEntryHolder {
        static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
            com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
                com.google.monitoring.v3.AlertProto
                    .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_LabelExtractorsEntry_descriptor,
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.STRING,
                "");
      }

      @SuppressWarnings("serial")
      private com.google.protobuf.MapField<java.lang.String, java.lang.String> labelExtractors_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetLabelExtractors() {
        if (labelExtractors_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              LabelExtractorsDefaultEntryHolder.defaultEntry);
        }
        return labelExtractors_;
      }

      public int getLabelExtractorsCount() {
        return internalGetLabelExtractors().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      @java.lang.Override
      public boolean containsLabelExtractors(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetLabelExtractors().getMap().containsKey(key);
      }
      /** Use {@link #getLabelExtractorsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getLabelExtractors() {
        return getLabelExtractorsMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getLabelExtractorsMap() {
        return internalGetLabelExtractors().getMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getLabelExtractorsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetLabelExtractors().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Optional. A map from a label key to an extractor expression, which is
       * used to extract the value for this label key. Each entry in this map is
       * a specification for how data should be extracted from log entries that
       * match `filter`. Each combination of extracted values is treated as a
       * separate rule for the purposes of triggering notifications. Label keys
       * and corresponding values can be used in notifications generated by this
       * condition.
       *
       * Please see [the documentation on logs-based metric
       * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
       * for syntax and examples.
       * </pre>
       *
       * <code>map&lt;string, string&gt; label_extractors = 2;</code>
       */
      @java.lang.Override
      public java.lang.String getLabelExtractorsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetLabelExtractors().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, filter_);
        }
        com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
            output,
            internalGetLabelExtractors(),
            LabelExtractorsDefaultEntryHolder.defaultEntry,
            2);
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, filter_);
        }
        for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
            internalGetLabelExtractors().getMap().entrySet()) {
          com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labelExtractors__ =
              LabelExtractorsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labelExtractors__);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition.LogMatch)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.LogMatch other =
            (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) obj;

        if (!getFilter().equals(other.getFilter())) return false;
        if (!internalGetLabelExtractors().equals(other.internalGetLabelExtractors())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
        if (!internalGetLabelExtractors().getMap().isEmpty()) {
          hash = (37 * hash) + LABEL_EXTRACTORS_FIELD_NUMBER;
          hash = (53 * hash) + internalGetLabelExtractors().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.LogMatch prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A condition type that checks whether a log message in the [scoping
       * project](https://cloud.google.com/monitoring/api/v3#project_name)
       * satisfies the given filter. Logs from other projects in the metrics
       * scope are not evaluated.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition.LogMatch}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.LogMatch)
          com.google.monitoring.v3.AlertPolicy.Condition.LogMatchOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapField internalGetMapField(int number) {
          switch (number) {
            case 2:
              return internalGetLabelExtractors();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
          switch (number) {
            case 2:
              return internalGetMutableLabelExtractors();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.class,
                  com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.Builder.class);
        }

        // Construct using com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          filter_ = "";
          internalGetMutableLabelExtractors().clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_LogMatch_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch build() {
          com.google.monitoring.v3.AlertPolicy.Condition.LogMatch result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.LogMatch result =
              new com.google.monitoring.v3.AlertPolicy.Condition.LogMatch(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.monitoring.v3.AlertPolicy.Condition.LogMatch result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.filter_ = filter_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.labelExtractors_ = internalGetLabelExtractors();
            result.labelExtractors_.makeImmutable();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) {
            return mergeFrom((com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.monitoring.v3.AlertPolicy.Condition.LogMatch other) {
          if (other == com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance())
            return this;
          if (!other.getFilter().isEmpty()) {
            filter_ = other.filter_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          internalGetMutableLabelExtractors().mergeFrom(other.internalGetLabelExtractors());
          bitField0_ |= 0x00000002;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    filter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                        labelExtractors__ =
                            input.readMessage(
                                LabelExtractorsDefaultEntryHolder.defaultEntry.getParserForType(),
                                extensionRegistry);
                    internalGetMutableLabelExtractors()
                        .getMutableMap()
                        .put(labelExtractors__.getKey(), labelExtractors__.getValue());
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object filter_ = "";
        /**
         *
         *
         * <pre>
         * Required. A logs-based filter. See [Advanced Logs
         * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
         * for how this filter should be constructed.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The filter.
         */
        public java.lang.String getFilter() {
          java.lang.Object ref = filter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            filter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A logs-based filter. See [Advanced Logs
         * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
         * for how this filter should be constructed.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for filter.
         */
        public com.google.protobuf.ByteString getFilterBytes() {
          java.lang.Object ref = filter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            filter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A logs-based filter. See [Advanced Logs
         * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
         * for how this filter should be constructed.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A logs-based filter. See [Advanced Logs
         * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
         * for how this filter should be constructed.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFilter() {
          filter_ = getDefaultInstance().getFilter();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A logs-based filter. See [Advanced Logs
         * Queries](https://cloud.google.com/logging/docs/view/advanced-queries)
         * for how this filter should be constructed.
         * </pre>
         *
         * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          filter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.MapField<java.lang.String, java.lang.String> labelExtractors_;

        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetLabelExtractors() {
          if (labelExtractors_ == null) {
            return com.google.protobuf.MapField.emptyMapField(
                LabelExtractorsDefaultEntryHolder.defaultEntry);
          }
          return labelExtractors_;
        }

        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetMutableLabelExtractors() {
          if (labelExtractors_ == null) {
            labelExtractors_ =
                com.google.protobuf.MapField.newMapField(
                    LabelExtractorsDefaultEntryHolder.defaultEntry);
          }
          if (!labelExtractors_.isMutable()) {
            labelExtractors_ = labelExtractors_.copy();
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return labelExtractors_;
        }

        public int getLabelExtractorsCount() {
          return internalGetLabelExtractors().getMap().size();
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        @java.lang.Override
        public boolean containsLabelExtractors(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          return internalGetLabelExtractors().getMap().containsKey(key);
        }
        /** Use {@link #getLabelExtractorsMap()} instead. */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getLabelExtractors() {
          return getLabelExtractorsMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        @java.lang.Override
        public java.util.Map<java.lang.String, java.lang.String> getLabelExtractorsMap() {
          return internalGetLabelExtractors().getMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        @java.lang.Override
        public /* nullable */ java.lang.String getLabelExtractorsOrDefault(
            java.lang.String key,
            /* nullable */
            java.lang.String defaultValue) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map =
              internalGetLabelExtractors().getMap();
          return map.containsKey(key) ? map.get(key) : defaultValue;
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        @java.lang.Override
        public java.lang.String getLabelExtractorsOrThrow(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map =
              internalGetLabelExtractors().getMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return map.get(key);
        }

        public Builder clearLabelExtractors() {
          bitField0_ = (bitField0_ & ~0x00000002);
          internalGetMutableLabelExtractors().getMutableMap().clear();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        public Builder removeLabelExtractors(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          internalGetMutableLabelExtractors().getMutableMap().remove(key);
          return this;
        }
        /** Use alternate mutation accessors instead. */
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getMutableLabelExtractors() {
          bitField0_ |= 0x00000002;
          return internalGetMutableLabelExtractors().getMutableMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        public Builder putLabelExtractors(java.lang.String key, java.lang.String value) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          if (value == null) {
            throw new NullPointerException("map value");
          }
          internalGetMutableLabelExtractors().getMutableMap().put(key, value);
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A map from a label key to an extractor expression, which is
         * used to extract the value for this label key. Each entry in this map is
         * a specification for how data should be extracted from log entries that
         * match `filter`. Each combination of extracted values is treated as a
         * separate rule for the purposes of triggering notifications. Label keys
         * and corresponding values can be used in notifications generated by this
         * condition.
         *
         * Please see [the documentation on logs-based metric
         * `valueExtractor`s](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.value_extractor)
         * for syntax and examples.
         * </pre>
         *
         * <code>map&lt;string, string&gt; label_extractors = 2;</code>
         */
        public Builder putAllLabelExtractors(
            java.util.Map<java.lang.String, java.lang.String> values) {
          internalGetMutableLabelExtractors().getMutableMap().putAll(values);
          bitField0_ |= 0x00000002;
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.LogMatch)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.LogMatch)
      private static final com.google.monitoring.v3.AlertPolicy.Condition.LogMatch DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Condition.LogMatch();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.LogMatch getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<LogMatch> PARSER =
          new com.google.protobuf.AbstractParser<LogMatch>() {
            @java.lang.Override
            public LogMatch parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<LogMatch> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<LogMatch> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MonitoringQueryLanguageConditionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
       * query that outputs a boolean stream.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The query.
       */
      java.lang.String getQuery();
      /**
       *
       *
       * <pre>
       * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
       * query that outputs a boolean stream.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The bytes for query.
       */
      com.google.protobuf.ByteString getQueryBytes();

      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return Whether the duration field is set.
       */
      boolean hasDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return The duration.
       */
      com.google.protobuf.Duration getDuration();
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return Whether the trigger field is set.
       */
      boolean hasTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return The trigger.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger();
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       */
      com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder();

      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for evaluationMissingData.
       */
      int getEvaluationMissingDataValue();
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
       * </code>
       *
       * @return The evaluationMissingData.
       */
      com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
          getEvaluationMissingData();
    }
    /**
     *
     *
     * <pre>
     * A condition type that allows alert policies to be defined using
     * [Monitoring Query Language](https://cloud.google.com/monitoring/mql).
     * </pre>
     *
     * Protobuf type {@code
     * google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition}
     */
    public static final class MonitoringQueryLanguageCondition
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
        MonitoringQueryLanguageConditionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MonitoringQueryLanguageCondition.newBuilder() to construct.
      private MonitoringQueryLanguageCondition(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MonitoringQueryLanguageCondition() {
        query_ = "";
        evaluationMissingData_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MonitoringQueryLanguageCondition();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MonitoringQueryLanguageCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_MonitoringQueryLanguageCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                    .class,
                com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                    .Builder.class);
      }

      public static final int QUERY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object query_ = "";
      /**
       *
       *
       * <pre>
       * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
       * query that outputs a boolean stream.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The query.
       */
      @java.lang.Override
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          query_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
       * query that outputs a boolean stream.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The bytes for query.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DURATION_FIELD_NUMBER = 2;
      private com.google.protobuf.Duration duration_;
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return Whether the duration field is set.
       */
      @java.lang.Override
      public boolean hasDuration() {
        return duration_ != null;
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return The duration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getDuration() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
      /**
       *
       *
       * <pre>
       * The amount of time that a time series must violate the
       * threshold to be considered failing. Currently, only values
       * that are a multiple of a minute--e.g., 0, 60, 120, or 300
       * seconds--are supported. If an invalid value is given, an
       * error will be returned. When choosing a duration, it is useful to
       * keep in mind the frequency of the underlying time series data
       * (which may also be affected by any alignments specified in the
       * `aggregations` field); a good duration is long enough so that a single
       * outlier does not generate spurious alerts, but short enough that
       * unhealthy states are detected and alerted on quickly.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }

      public static final int TRIGGER_FIELD_NUMBER = 3;
      private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return Whether the trigger field is set.
       */
      @java.lang.Override
      public boolean hasTrigger() {
        return trigger_ != null;
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       *
       * @return The trigger.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }
      /**
       *
       *
       * <pre>
       * The number/percent of time series for which the comparison must hold
       * in order for the condition to trigger. If unspecified, then the
       * condition will trigger if the comparison is true for any of the
       * time series that have been identified by `filter` and `aggregations`,
       * or by the ratio, if `denominator_filter` and `denominator_aggregations`
       * are specified.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder getTriggerOrBuilder() {
        return trigger_ == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
            : trigger_;
      }

      public static final int EVALUATION_MISSING_DATA_FIELD_NUMBER = 4;
      private int evaluationMissingData_ = 0;
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for evaluationMissingData.
       */
      @java.lang.Override
      public int getEvaluationMissingDataValue() {
        return evaluationMissingData_;
      }
      /**
       *
       *
       * <pre>
       * A condition control that determines how metric-threshold conditions
       * are evaluated when data stops arriving.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
       * </code>
       *
       * @return The evaluationMissingData.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
          getEvaluationMissingData() {
        com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData result =
            com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.forNumber(
                evaluationMissingData_);
        return result == null
            ? com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
        }
        if (duration_ != null) {
          output.writeMessage(2, getDuration());
        }
        if (trigger_ != null) {
          output.writeMessage(3, getTrigger());
        }
        if (evaluationMissingData_
            != com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
                .EVALUATION_MISSING_DATA_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(4, evaluationMissingData_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
        }
        if (duration_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDuration());
        }
        if (trigger_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTrigger());
        }
        if (evaluationMissingData_
            != com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
                .EVALUATION_MISSING_DATA_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, evaluationMissingData_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition other =
            (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition) obj;

        if (!getQuery().equals(other.getQuery())) return false;
        if (hasDuration() != other.hasDuration()) return false;
        if (hasDuration()) {
          if (!getDuration().equals(other.getDuration())) return false;
        }
        if (hasTrigger() != other.hasTrigger()) return false;
        if (hasTrigger()) {
          if (!getTrigger().equals(other.getTrigger())) return false;
        }
        if (evaluationMissingData_ != other.evaluationMissingData_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
        if (hasDuration()) {
          hash = (37 * hash) + DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getDuration().hashCode();
        }
        if (hasTrigger()) {
          hash = (37 * hash) + TRIGGER_FIELD_NUMBER;
          hash = (53 * hash) + getTrigger().hashCode();
        }
        hash = (37 * hash) + EVALUATION_MISSING_DATA_FIELD_NUMBER;
        hash = (53 * hash) + evaluationMissingData_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A condition type that allows alert policies to be defined using
       * [Monitoring Query Language](https://cloud.google.com/monitoring/mql).
       * </pre>
       *
       * Protobuf type {@code
       * google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
          com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageConditionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MonitoringQueryLanguageCondition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MonitoringQueryLanguageCondition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                      .class,
                  com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                      .Builder.class);
        }

        // Construct using
        // com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          query_ = "";
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          evaluationMissingData_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_MonitoringQueryLanguageCondition_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
            build() {
          com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
            buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition result =
              new com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.query_ = query_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.trigger_ = triggerBuilder_ == null ? trigger_ : triggerBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.evaluationMissingData_ = evaluationMissingData_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition) {
            return mergeFrom(
                (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition other) {
          if (other
              == com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                  .getDefaultInstance()) return this;
          if (!other.getQuery().isEmpty()) {
            query_ = other.query_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasDuration()) {
            mergeDuration(other.getDuration());
          }
          if (other.hasTrigger()) {
            mergeTrigger(other.getTrigger());
          }
          if (other.evaluationMissingData_ != 0) {
            setEvaluationMissingDataValue(other.getEvaluationMissingDataValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    query_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getTriggerFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 32:
                  {
                    evaluationMissingData_ = input.readEnum();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object query_ = "";
        /**
         *
         *
         * <pre>
         * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
         * query that outputs a boolean stream.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The query.
         */
        public java.lang.String getQuery() {
          java.lang.Object ref = query_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            query_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
         * query that outputs a boolean stream.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The bytes for query.
         */
        public com.google.protobuf.ByteString getQueryBytes() {
          java.lang.Object ref = query_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            query_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
         * query that outputs a boolean stream.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @param value The query to set.
         * @return This builder for chaining.
         */
        public Builder setQuery(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
         * query that outputs a boolean stream.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearQuery() {
          query_ = getDefaultInstance().getQuery();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Monitoring Query Language](https://cloud.google.com/monitoring/mql)
         * query that outputs a boolean stream.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @param value The bytes for query to set.
         * @return This builder for chaining.
         */
        public Builder setQueryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Duration duration_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            durationBuilder_;
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         *
         * @return Whether the duration field is set.
         */
        public boolean hasDuration() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         *
         * @return The duration.
         */
        public com.google.protobuf.Duration getDuration() {
          if (durationBuilder_ == null) {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          } else {
            return durationBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            duration_ = value;
          } else {
            durationBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
          if (durationBuilder_ == null) {
            duration_ = builderForValue.build();
          } else {
            durationBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder mergeDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && duration_ != null
                && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getDurationBuilder().mergeFrom(value);
            } else {
              duration_ = value;
            }
          } else {
            durationBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public Builder clearDuration() {
          bitField0_ = (bitField0_ & ~0x00000002);
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public com.google.protobuf.Duration.Builder getDurationBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getDurationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
          if (durationBuilder_ != null) {
            return durationBuilder_.getMessageOrBuilder();
          } else {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          }
        }
        /**
         *
         *
         * <pre>
         * The amount of time that a time series must violate the
         * threshold to be considered failing. Currently, only values
         * that are a multiple of a minute--e.g., 0, 60, 120, or 300
         * seconds--are supported. If an invalid value is given, an
         * error will be returned. When choosing a duration, it is useful to
         * keep in mind the frequency of the underlying time series data
         * (which may also be affected by any alignments specified in the
         * `aggregations` field); a good duration is long enough so that a single
         * outlier does not generate spurious alerts, but short enough that
         * unhealthy states are detected and alerted on quickly.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getDurationFieldBuilder() {
          if (durationBuilder_ == null) {
            durationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getDuration(), getParentForChildren(), isClean());
            duration_ = null;
          }
          return durationBuilder_;
        }

        private com.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            triggerBuilder_;
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         *
         * @return Whether the trigger field is set.
         */
        public boolean hasTrigger() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         *
         * @return The trigger.
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger getTrigger() {
          if (triggerBuilder_ == null) {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          } else {
            return triggerBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder setTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            trigger_ = value;
          } else {
            triggerBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder setTrigger(
            com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder builderForValue) {
          if (triggerBuilder_ == null) {
            trigger_ = builderForValue.build();
          } else {
            triggerBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder mergeTrigger(com.google.monitoring.v3.AlertPolicy.Condition.Trigger value) {
          if (triggerBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && trigger_ != null
                && trigger_
                    != com.google.monitoring.v3.AlertPolicy.Condition.Trigger
                        .getDefaultInstance()) {
              getTriggerBuilder().mergeFrom(value);
            } else {
              trigger_ = value;
            }
          } else {
            triggerBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public Builder clearTrigger() {
          bitField0_ = (bitField0_ & ~0x00000004);
          trigger_ = null;
          if (triggerBuilder_ != null) {
            triggerBuilder_.dispose();
            triggerBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder getTriggerBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getTriggerFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        public com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder
            getTriggerOrBuilder() {
          if (triggerBuilder_ != null) {
            return triggerBuilder_.getMessageOrBuilder();
          } else {
            return trigger_ == null
                ? com.google.monitoring.v3.AlertPolicy.Condition.Trigger.getDefaultInstance()
                : trigger_;
          }
        }
        /**
         *
         *
         * <pre>
         * The number/percent of time series for which the comparison must hold
         * in order for the condition to trigger. If unspecified, then the
         * condition will trigger if the comparison is true for any of the
         * time series that have been identified by `filter` and `aggregations`,
         * or by the ratio, if `denominator_filter` and `denominator_aggregations`
         * are specified.
         * </pre>
         *
         * <code>.google.monitoring.v3.AlertPolicy.Condition.Trigger trigger = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>
            getTriggerFieldBuilder() {
          if (triggerBuilder_ == null) {
            triggerBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger,
                    com.google.monitoring.v3.AlertPolicy.Condition.Trigger.Builder,
                    com.google.monitoring.v3.AlertPolicy.Condition.TriggerOrBuilder>(
                    getTrigger(), getParentForChildren(), isClean());
            trigger_ = null;
          }
          return triggerBuilder_;
        }

        private int evaluationMissingData_ = 0;
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
         * </code>
         *
         * @return The enum numeric value on the wire for evaluationMissingData.
         */
        @java.lang.Override
        public int getEvaluationMissingDataValue() {
          return evaluationMissingData_;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
         * </code>
         *
         * @param value The enum numeric value on the wire for evaluationMissingData to set.
         * @return This builder for chaining.
         */
        public Builder setEvaluationMissingDataValue(int value) {
          evaluationMissingData_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
         * </code>
         *
         * @return The evaluationMissingData.
         */
        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData
            getEvaluationMissingData() {
          com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData result =
              com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.forNumber(
                  evaluationMissingData_);
          return result == null
              ? com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
         * </code>
         *
         * @param value The evaluationMissingData to set.
         * @return This builder for chaining.
         */
        public Builder setEvaluationMissingData(
            com.google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000008;
          evaluationMissingData_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A condition control that determines how metric-threshold conditions
         * are evaluated when data stops arriving.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.AlertPolicy.Condition.EvaluationMissingData evaluation_missing_data = 4;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEvaluationMissingData() {
          bitField0_ = (bitField0_ & ~0x00000008);
          evaluationMissingData_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
      private static final com.google.monitoring.v3.AlertPolicy.Condition
              .MonitoringQueryLanguageCondition
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MonitoringQueryLanguageCondition> PARSER =
          new com.google.protobuf.AbstractParser<MonitoringQueryLanguageCondition>() {
            @java.lang.Override
            public MonitoringQueryLanguageCondition parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MonitoringQueryLanguageCondition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MonitoringQueryLanguageCondition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface PrometheusQueryLanguageConditionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The PromQL expression to evaluate. Every evaluation cycle
       * this expression is evaluated at the current time, and all resultant
       * time series become pending/firing alerts. This field must not be empty.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The query.
       */
      java.lang.String getQuery();
      /**
       *
       *
       * <pre>
       * Required. The PromQL expression to evaluate. Every evaluation cycle
       * this expression is evaluated at the current time, and all resultant
       * time series become pending/firing alerts. This field must not be empty.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for query.
       */
      com.google.protobuf.ByteString getQueryBytes();

      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the duration field is set.
       */
      boolean hasDuration();
      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The duration.
       */
      com.google.protobuf.Duration getDuration();
      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the evaluationInterval field is set.
       */
      boolean hasEvaluationInterval();
      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The evaluationInterval.
       */
      com.google.protobuf.Duration getEvaluationInterval();
      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.DurationOrBuilder getEvaluationIntervalOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      int getLabelsCount();
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      boolean containsLabels(java.lang.String key);
      /** Use {@link #getLabelsMap()} instead. */
      @java.lang.Deprecated
      java.util.Map<java.lang.String, java.lang.String> getLabels();
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      /* nullable */
      java.lang.String getLabelsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue);
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.lang.String getLabelsOrThrow(java.lang.String key);

      /**
       *
       *
       * <pre>
       * Optional. The rule group name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must
       * contain a valid UTF-8 string.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The ruleGroup.
       */
      java.lang.String getRuleGroup();
      /**
       *
       *
       * <pre>
       * Optional. The rule group name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must
       * contain a valid UTF-8 string.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for ruleGroup.
       */
      com.google.protobuf.ByteString getRuleGroupBytes();

      /**
       *
       *
       * <pre>
       * Optional. The alerting rule name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must be a
       * [valid Prometheus label
       * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The alertRule.
       */
      java.lang.String getAlertRule();
      /**
       *
       *
       * <pre>
       * Optional. The alerting rule name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must be a
       * [valid Prometheus label
       * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for alertRule.
       */
      com.google.protobuf.ByteString getAlertRuleBytes();
    }
    /**
     *
     *
     * <pre>
     * A condition type that allows alert policies to be defined using
     * [Prometheus Query Language
     * (PromQL)](https://prometheus.io/docs/prometheus/latest/querying/basics/).
     *
     * The PrometheusQueryLanguageCondition message contains information
     * from a Prometheus alerting rule and its associated rule group.
     *
     * A Prometheus alerting rule is described
     * [here](https://prometheus.io/docs/prometheus/latest/configuration/alerting_rules/).
     * The semantics of a Prometheus alerting rule is described
     * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/#rule).
     *
     * A Prometheus rule group is described
     * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/).
     * The semantics of a Prometheus rule group is described
     * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/#rule_group).
     *
     * Because Cloud Alerting has no representation of a Prometheus rule
     * group resource, we must embed the information of the parent rule
     * group inside each of the conditions that refer to it. We must also
     * update the contents of all Prometheus alerts in case the information
     * of their rule group changes.
     *
     * The PrometheusQueryLanguageCondition protocol buffer combines the
     * information of the corresponding rule group and alerting rule.
     * The structure of the PrometheusQueryLanguageCondition protocol buffer
     * does NOT mimic the structure of the Prometheus rule group and alerting
     * rule YAML declarations. The PrometheusQueryLanguageCondition protocol
     * buffer may change in the future to support future rule group and/or
     * alerting rule features. There are no new such features at the present
     * time (2023-06-26).
     * </pre>
     *
     * Protobuf type {@code
     * google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition}
     */
    public static final class PrometheusQueryLanguageCondition
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
        PrometheusQueryLanguageConditionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use PrometheusQueryLanguageCondition.newBuilder() to construct.
      private PrometheusQueryLanguageCondition(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private PrometheusQueryLanguageCondition() {
        query_ = "";
        ruleGroup_ = "";
        alertRule_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new PrometheusQueryLanguageCondition();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      @java.lang.Override
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 4:
            return internalGetLabels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                    .class,
                com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                    .Builder.class);
      }

      public static final int QUERY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object query_ = "";
      /**
       *
       *
       * <pre>
       * Required. The PromQL expression to evaluate. Every evaluation cycle
       * this expression is evaluated at the current time, and all resultant
       * time series become pending/firing alerts. This field must not be empty.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The query.
       */
      @java.lang.Override
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          query_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The PromQL expression to evaluate. Every evaluation cycle
       * this expression is evaluated at the current time, and all resultant
       * time series become pending/firing alerts. This field must not be empty.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for query.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DURATION_FIELD_NUMBER = 2;
      private com.google.protobuf.Duration duration_;
      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the duration field is set.
       */
      @java.lang.Override
      public boolean hasDuration() {
        return duration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The duration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getDuration() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Alerts are considered firing once their PromQL expression was
       * evaluated to be "true" for this long.
       * Alerts whose PromQL expression was not evaluated to be "true" for
       * long enough are considered pending.
       * Must be a non-negative duration or missing.
       * This field is optional. Its default value is zero.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }

      public static final int EVALUATION_INTERVAL_FIELD_NUMBER = 3;
      private com.google.protobuf.Duration evaluationInterval_;
      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the evaluationInterval field is set.
       */
      @java.lang.Override
      public boolean hasEvaluationInterval() {
        return evaluationInterval_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The evaluationInterval.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getEvaluationInterval() {
        return evaluationInterval_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : evaluationInterval_;
      }
      /**
       *
       *
       * <pre>
       * Optional. How often this rule should be evaluated.
       * Must be a positive multiple of 30 seconds or missing.
       * This field is optional. Its default value is 30 seconds.
       * If this PrometheusQueryLanguageCondition was generated from a
       * Prometheus alerting rule, then this value should be taken from the
       * enclosing rule group.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getEvaluationIntervalOrBuilder() {
        return evaluationInterval_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : evaluationInterval_;
      }

      public static final int LABELS_FIELD_NUMBER = 4;

      private static final class LabelsDefaultEntryHolder {
        static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
            com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
                com.google.monitoring.v3.AlertProto
                    .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_LabelsEntry_descriptor,
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.STRING,
                "");
      }

      @SuppressWarnings("serial")
      private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
        if (labels_ == null) {
          return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return labels_;
      }

      public int getLabelsCount() {
        return internalGetLabels().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetLabels().getMap().containsKey(key);
      }
      /** Use {@link #getLabelsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return getLabelsMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
        return internalGetLabels().getMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getLabelsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Optional. Labels to add to or overwrite in the PromQL query result.
       * Label names [must be
       * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * Label values can be [templatized by using
       * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
       * The only available variable names are the names of the labels in the
       * PromQL result, including "__name__" and "value". "labels" may be empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.lang.String getLabelsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public static final int RULE_GROUP_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private volatile java.lang.Object ruleGroup_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The rule group name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must
       * contain a valid UTF-8 string.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The ruleGroup.
       */
      @java.lang.Override
      public java.lang.String getRuleGroup() {
        java.lang.Object ref = ruleGroup_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ruleGroup_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The rule group name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must
       * contain a valid UTF-8 string.
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for ruleGroup.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRuleGroupBytes() {
        java.lang.Object ref = ruleGroup_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ruleGroup_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ALERT_RULE_FIELD_NUMBER = 6;

      @SuppressWarnings("serial")
      private volatile java.lang.Object alertRule_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The alerting rule name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must be a
       * [valid Prometheus label
       * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The alertRule.
       */
      @java.lang.Override
      public java.lang.String getAlertRule() {
        java.lang.Object ref = alertRule_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          alertRule_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The alerting rule name of this alert in the corresponding
       * Prometheus configuration file.
       *
       * Some external tools may require this field to be populated correctly
       * in order to refer to the original Prometheus configuration file.
       * The rule group name and the alert name are necessary to update the
       * relevant AlertPolicies in case the definition of the rule group changes
       * in the future.
       *
       * This field is optional. If this field is not empty, then it must be a
       * [valid Prometheus label
       * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
       * This field may not exceed 2048 Unicode characters in length.
       * </pre>
       *
       * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for alertRule.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAlertRuleBytes() {
        java.lang.Object ref = alertRule_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          alertRule_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
        }
        if (duration_ != null) {
          output.writeMessage(2, getDuration());
        }
        if (evaluationInterval_ != null) {
          output.writeMessage(3, getEvaluationInterval());
        }
        com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
            output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ruleGroup_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, ruleGroup_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alertRule_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 6, alertRule_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
        }
        if (duration_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDuration());
        }
        if (evaluationInterval_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEvaluationInterval());
        }
        for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
            internalGetLabels().getMap().entrySet()) {
          com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
              LabelsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ruleGroup_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, ruleGroup_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alertRule_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, alertRule_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition other =
            (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition) obj;

        if (!getQuery().equals(other.getQuery())) return false;
        if (hasDuration() != other.hasDuration()) return false;
        if (hasDuration()) {
          if (!getDuration().equals(other.getDuration())) return false;
        }
        if (hasEvaluationInterval() != other.hasEvaluationInterval()) return false;
        if (hasEvaluationInterval()) {
          if (!getEvaluationInterval().equals(other.getEvaluationInterval())) return false;
        }
        if (!internalGetLabels().equals(other.internalGetLabels())) return false;
        if (!getRuleGroup().equals(other.getRuleGroup())) return false;
        if (!getAlertRule().equals(other.getAlertRule())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
        if (hasDuration()) {
          hash = (37 * hash) + DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getDuration().hashCode();
        }
        if (hasEvaluationInterval()) {
          hash = (37 * hash) + EVALUATION_INTERVAL_FIELD_NUMBER;
          hash = (53 * hash) + getEvaluationInterval().hashCode();
        }
        if (!internalGetLabels().getMap().isEmpty()) {
          hash = (37 * hash) + LABELS_FIELD_NUMBER;
          hash = (53 * hash) + internalGetLabels().hashCode();
        }
        hash = (37 * hash) + RULE_GROUP_FIELD_NUMBER;
        hash = (53 * hash) + getRuleGroup().hashCode();
        hash = (37 * hash) + ALERT_RULE_FIELD_NUMBER;
        hash = (53 * hash) + getAlertRule().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A condition type that allows alert policies to be defined using
       * [Prometheus Query Language
       * (PromQL)](https://prometheus.io/docs/prometheus/latest/querying/basics/).
       *
       * The PrometheusQueryLanguageCondition message contains information
       * from a Prometheus alerting rule and its associated rule group.
       *
       * A Prometheus alerting rule is described
       * [here](https://prometheus.io/docs/prometheus/latest/configuration/alerting_rules/).
       * The semantics of a Prometheus alerting rule is described
       * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/#rule).
       *
       * A Prometheus rule group is described
       * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/).
       * The semantics of a Prometheus rule group is described
       * [here](https://prometheus.io/docs/prometheus/latest/configuration/recording_rules/#rule_group).
       *
       * Because Cloud Alerting has no representation of a Prometheus rule
       * group resource, we must embed the information of the parent rule
       * group inside each of the conditions that refer to it. We must also
       * update the contents of all Prometheus alerts in case the information
       * of their rule group changes.
       *
       * The PrometheusQueryLanguageCondition protocol buffer combines the
       * information of the corresponding rule group and alerting rule.
       * The structure of the PrometheusQueryLanguageCondition protocol buffer
       * does NOT mimic the structure of the Prometheus rule group and alerting
       * rule YAML declarations. The PrometheusQueryLanguageCondition protocol
       * buffer may change in the future to support future rule group and/or
       * alerting rule features. There are no new such features at the present
       * time (2023-06-26).
       * </pre>
       *
       * Protobuf type {@code
       * google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
          com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageConditionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapField internalGetMapField(int number) {
          switch (number) {
            case 4:
              return internalGetLabels();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
          switch (number) {
            case 4:
              return internalGetMutableLabels();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                      .class,
                  com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                      .Builder.class);
        }

        // Construct using
        // com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          query_ = "";
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          evaluationInterval_ = null;
          if (evaluationIntervalBuilder_ != null) {
            evaluationIntervalBuilder_.dispose();
            evaluationIntervalBuilder_ = null;
          }
          internalGetMutableLabels().clear();
          ruleGroup_ = "";
          alertRule_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_Condition_PrometheusQueryLanguageCondition_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
            build() {
          com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
            buildPartial() {
          com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition result =
              new com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.query_ = query_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.evaluationInterval_ =
                evaluationIntervalBuilder_ == null
                    ? evaluationInterval_
                    : evaluationIntervalBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.labels_ = internalGetLabels();
            result.labels_.makeImmutable();
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.ruleGroup_ = ruleGroup_;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.alertRule_ = alertRule_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition) {
            return mergeFrom(
                (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition other) {
          if (other
              == com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                  .getDefaultInstance()) return this;
          if (!other.getQuery().isEmpty()) {
            query_ = other.query_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasDuration()) {
            mergeDuration(other.getDuration());
          }
          if (other.hasEvaluationInterval()) {
            mergeEvaluationInterval(other.getEvaluationInterval());
          }
          internalGetMutableLabels().mergeFrom(other.internalGetLabels());
          bitField0_ |= 0x00000008;
          if (!other.getRuleGroup().isEmpty()) {
            ruleGroup_ = other.ruleGroup_;
            bitField0_ |= 0x00000010;
            onChanged();
          }
          if (!other.getAlertRule().isEmpty()) {
            alertRule_ = other.alertRule_;
            bitField0_ |= 0x00000020;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    query_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(
                        getEvaluationIntervalFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                        input.readMessage(
                            LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                    internalGetMutableLabels()
                        .getMutableMap()
                        .put(labels__.getKey(), labels__.getValue());
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 42:
                  {
                    ruleGroup_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 42
                case 50:
                  {
                    alertRule_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 50
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object query_ = "";
        /**
         *
         *
         * <pre>
         * Required. The PromQL expression to evaluate. Every evaluation cycle
         * this expression is evaluated at the current time, and all resultant
         * time series become pending/firing alerts. This field must not be empty.
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The query.
         */
        public java.lang.String getQuery() {
          java.lang.Object ref = query_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            query_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The PromQL expression to evaluate. Every evaluation cycle
         * this expression is evaluated at the current time, and all resultant
         * time series become pending/firing alerts. This field must not be empty.
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for query.
         */
        public com.google.protobuf.ByteString getQueryBytes() {
          java.lang.Object ref = query_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            query_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The PromQL expression to evaluate. Every evaluation cycle
         * this expression is evaluated at the current time, and all resultant
         * time series become pending/firing alerts. This field must not be empty.
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The query to set.
         * @return This builder for chaining.
         */
        public Builder setQuery(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The PromQL expression to evaluate. Every evaluation cycle
         * this expression is evaluated at the current time, and all resultant
         * time series become pending/firing alerts. This field must not be empty.
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearQuery() {
          query_ = getDefaultInstance().getQuery();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The PromQL expression to evaluate. Every evaluation cycle
         * this expression is evaluated at the current time, and all resultant
         * time series become pending/firing alerts. This field must not be empty.
         * </pre>
         *
         * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for query to set.
         * @return This builder for chaining.
         */
        public Builder setQueryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Duration duration_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            durationBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the duration field is set.
         */
        public boolean hasDuration() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The duration.
         */
        public com.google.protobuf.Duration getDuration() {
          if (durationBuilder_ == null) {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          } else {
            return durationBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            duration_ = value;
          } else {
            durationBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
          if (durationBuilder_ == null) {
            duration_ = builderForValue.build();
          } else {
            durationBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeDuration(com.google.protobuf.Duration value) {
          if (durationBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && duration_ != null
                && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getDurationBuilder().mergeFrom(value);
            } else {
              duration_ = value;
            }
          } else {
            durationBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearDuration() {
          bitField0_ = (bitField0_ & ~0x00000002);
          duration_ = null;
          if (durationBuilder_ != null) {
            durationBuilder_.dispose();
            durationBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.Duration.Builder getDurationBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getDurationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
          if (durationBuilder_ != null) {
            return durationBuilder_.getMessageOrBuilder();
          } else {
            return duration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : duration_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Alerts are considered firing once their PromQL expression was
         * evaluated to be "true" for this long.
         * Alerts whose PromQL expression was not evaluated to be "true" for
         * long enough are considered pending.
         * Must be a non-negative duration or missing.
         * This field is optional. Its default value is zero.
         * </pre>
         *
         * <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getDurationFieldBuilder() {
          if (durationBuilder_ == null) {
            durationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getDuration(), getParentForChildren(), isClean());
            duration_ = null;
          }
          return durationBuilder_;
        }

        private com.google.protobuf.Duration evaluationInterval_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            evaluationIntervalBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the evaluationInterval field is set.
         */
        public boolean hasEvaluationInterval() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The evaluationInterval.
         */
        public com.google.protobuf.Duration getEvaluationInterval() {
          if (evaluationIntervalBuilder_ == null) {
            return evaluationInterval_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : evaluationInterval_;
          } else {
            return evaluationIntervalBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setEvaluationInterval(com.google.protobuf.Duration value) {
          if (evaluationIntervalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            evaluationInterval_ = value;
          } else {
            evaluationIntervalBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setEvaluationInterval(com.google.protobuf.Duration.Builder builderForValue) {
          if (evaluationIntervalBuilder_ == null) {
            evaluationInterval_ = builderForValue.build();
          } else {
            evaluationIntervalBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeEvaluationInterval(com.google.protobuf.Duration value) {
          if (evaluationIntervalBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && evaluationInterval_ != null
                && evaluationInterval_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getEvaluationIntervalBuilder().mergeFrom(value);
            } else {
              evaluationInterval_ = value;
            }
          } else {
            evaluationIntervalBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearEvaluationInterval() {
          bitField0_ = (bitField0_ & ~0x00000004);
          evaluationInterval_ = null;
          if (evaluationIntervalBuilder_ != null) {
            evaluationIntervalBuilder_.dispose();
            evaluationIntervalBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.Duration.Builder getEvaluationIntervalBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getEvaluationIntervalFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.DurationOrBuilder getEvaluationIntervalOrBuilder() {
          if (evaluationIntervalBuilder_ != null) {
            return evaluationIntervalBuilder_.getMessageOrBuilder();
          } else {
            return evaluationInterval_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : evaluationInterval_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. How often this rule should be evaluated.
         * Must be a positive multiple of 30 seconds or missing.
         * This field is optional. Its default value is 30 seconds.
         * If this PrometheusQueryLanguageCondition was generated from a
         * Prometheus alerting rule, then this value should be taken from the
         * enclosing rule group.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration evaluation_interval = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getEvaluationIntervalFieldBuilder() {
          if (evaluationIntervalBuilder_ == null) {
            evaluationIntervalBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getEvaluationInterval(), getParentForChildren(), isClean());
            evaluationInterval_ = null;
          }
          return evaluationIntervalBuilder_;
        }

        private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetLabels() {
          if (labels_ == null) {
            return com.google.protobuf.MapField.emptyMapField(
                LabelsDefaultEntryHolder.defaultEntry);
          }
          return labels_;
        }

        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetMutableLabels() {
          if (labels_ == null) {
            labels_ =
                com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
          }
          if (!labels_.isMutable()) {
            labels_ = labels_.copy();
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return labels_;
        }

        public int getLabelsCount() {
          return internalGetLabels().getMap().size();
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public boolean containsLabels(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          return internalGetLabels().getMap().containsKey(key);
        }
        /** Use {@link #getLabelsMap()} instead. */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getLabels() {
          return getLabelsMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
          return internalGetLabels().getMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public /* nullable */ java.lang.String getLabelsOrDefault(
            java.lang.String key,
            /* nullable */
            java.lang.String defaultValue) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
          return map.containsKey(key) ? map.get(key) : defaultValue;
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public java.lang.String getLabelsOrThrow(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return map.get(key);
        }

        public Builder clearLabels() {
          bitField0_ = (bitField0_ & ~0x00000008);
          internalGetMutableLabels().getMutableMap().clear();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder removeLabels(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          internalGetMutableLabels().getMutableMap().remove(key);
          return this;
        }
        /** Use alternate mutation accessors instead. */
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
          bitField0_ |= 0x00000008;
          return internalGetMutableLabels().getMutableMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder putLabels(java.lang.String key, java.lang.String value) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          if (value == null) {
            throw new NullPointerException("map value");
          }
          internalGetMutableLabels().getMutableMap().put(key, value);
          bitField0_ |= 0x00000008;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels to add to or overwrite in the PromQL query result.
         * Label names [must be
         * valid](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * Label values can be [templatized by using
         * variables](https://cloud.google.com/monitoring/alerts/doc-variables).
         * The only available variable names are the names of the labels in the
         * PromQL result, including "__name__" and "value". "labels" may be empty.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
          internalGetMutableLabels().getMutableMap().putAll(values);
          bitField0_ |= 0x00000008;
          return this;
        }

        private java.lang.Object ruleGroup_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The rule group name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must
         * contain a valid UTF-8 string.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The ruleGroup.
         */
        public java.lang.String getRuleGroup() {
          java.lang.Object ref = ruleGroup_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            ruleGroup_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The rule group name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must
         * contain a valid UTF-8 string.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for ruleGroup.
         */
        public com.google.protobuf.ByteString getRuleGroupBytes() {
          java.lang.Object ref = ruleGroup_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            ruleGroup_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The rule group name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must
         * contain a valid UTF-8 string.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The ruleGroup to set.
         * @return This builder for chaining.
         */
        public Builder setRuleGroup(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ruleGroup_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The rule group name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must
         * contain a valid UTF-8 string.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRuleGroup() {
          ruleGroup_ = getDefaultInstance().getRuleGroup();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The rule group name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must
         * contain a valid UTF-8 string.
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string rule_group = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for ruleGroup to set.
         * @return This builder for chaining.
         */
        public Builder setRuleGroupBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ruleGroup_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        private java.lang.Object alertRule_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The alerting rule name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must be a
         * [valid Prometheus label
         * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The alertRule.
         */
        public java.lang.String getAlertRule() {
          java.lang.Object ref = alertRule_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            alertRule_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The alerting rule name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must be a
         * [valid Prometheus label
         * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for alertRule.
         */
        public com.google.protobuf.ByteString getAlertRuleBytes() {
          java.lang.Object ref = alertRule_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            alertRule_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The alerting rule name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must be a
         * [valid Prometheus label
         * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The alertRule to set.
         * @return This builder for chaining.
         */
        public Builder setAlertRule(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          alertRule_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The alerting rule name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must be a
         * [valid Prometheus label
         * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAlertRule() {
          alertRule_ = getDefaultInstance().getAlertRule();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The alerting rule name of this alert in the corresponding
         * Prometheus configuration file.
         *
         * Some external tools may require this field to be populated correctly
         * in order to refer to the original Prometheus configuration file.
         * The rule group name and the alert name are necessary to update the
         * relevant AlertPolicies in case the definition of the rule group changes
         * in the future.
         *
         * This field is optional. If this field is not empty, then it must be a
         * [valid Prometheus label
         * name](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels).
         * This field may not exceed 2048 Unicode characters in length.
         * </pre>
         *
         * <code>string alert_rule = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for alertRule to set.
         * @return This builder for chaining.
         */
        public Builder setAlertRuleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          alertRule_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
      private static final com.google.monitoring.v3.AlertPolicy.Condition
              .PrometheusQueryLanguageCondition
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition();
      }

      public static com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<PrometheusQueryLanguageCondition> PARSER =
          new com.google.protobuf.AbstractParser<PrometheusQueryLanguageCondition>() {
            @java.lang.Override
            public PrometheusQueryLanguageCondition parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<PrometheusQueryLanguageCondition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<PrometheusQueryLanguageCondition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int conditionCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object condition_;

    public enum ConditionCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CONDITION_THRESHOLD(1),
      CONDITION_ABSENT(2),
      CONDITION_MATCHED_LOG(20),
      CONDITION_MONITORING_QUERY_LANGUAGE(19),
      CONDITION_PROMETHEUS_QUERY_LANGUAGE(21),
      CONDITION_NOT_SET(0);
      private final int value;

      private ConditionCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ConditionCase valueOf(int value) {
        return forNumber(value);
      }

      public static ConditionCase forNumber(int value) {
        switch (value) {
          case 1:
            return CONDITION_THRESHOLD;
          case 2:
            return CONDITION_ABSENT;
          case 20:
            return CONDITION_MATCHED_LOG;
          case 19:
            return CONDITION_MONITORING_QUERY_LANGUAGE;
          case 21:
            return CONDITION_PROMETHEUS_QUERY_LANGUAGE;
          case 0:
            return CONDITION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ConditionCase getConditionCase() {
      return ConditionCase.forNumber(conditionCase_);
    }

    public static final int NAME_FIELD_NUMBER = 12;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required if the condition exists. The unique resource name for this
     * condition. Its format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     *
     * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     * condition is created as part of a new or updated alerting policy.
     *
     * When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the conditions of the
     * requested alerting policy. Cloud Monitoring creates the
     * condition identifiers and includes them in the new policy.
     *
     * When calling the
     * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     * method to update a policy, including a condition `name` causes the
     * existing condition to be updated. Conditions without names are added to
     * the updated policy. Existing conditions are deleted if they are not
     * updated.
     *
     * Best practice is to preserve `[CONDITION_ID]` if you make only small
     * changes, such as those to condition thresholds, durations, or trigger
     * values.  Otherwise, treat the change as a new condition and let the
     * existing condition be deleted.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required if the condition exists. The unique resource name for this
     * condition. Its format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     *
     * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     * condition is created as part of a new or updated alerting policy.
     *
     * When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the conditions of the
     * requested alerting policy. Cloud Monitoring creates the
     * condition identifiers and includes them in the new policy.
     *
     * When calling the
     * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     * method to update a policy, including a condition `name` causes the
     * existing condition to be updated. Conditions without names are added to
     * the updated policy. Existing conditions are deleted if they are not
     * updated.
     *
     * Best practice is to preserve `[CONDITION_ID]` if you make only small
     * changes, such as those to condition thresholds, durations, or trigger
     * values.  Otherwise, treat the change as a new condition and let the
     * existing condition be deleted.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the condition in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple conditions in the same policy.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the condition in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple conditions in the same policy.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONDITION_THRESHOLD_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     *
     * @return Whether the conditionThreshold field is set.
     */
    @java.lang.Override
    public boolean hasConditionThreshold() {
      return conditionCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     *
     * @return The conditionThreshold.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold getConditionThreshold() {
      if (conditionCase_ == 1) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A condition that compares a time series against a threshold.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MetricThresholdOrBuilder
        getConditionThresholdOrBuilder() {
      if (conditionCase_ == 1) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.getDefaultInstance();
    }

    public static final int CONDITION_ABSENT_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     *
     * @return Whether the conditionAbsent field is set.
     */
    @java.lang.Override
    public boolean hasConditionAbsent() {
      return conditionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     *
     * @return The conditionAbsent.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence getConditionAbsent() {
      if (conditionCase_ == 2) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A condition that checks that a time series continues to
     * receive new data points.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsenceOrBuilder
        getConditionAbsentOrBuilder() {
      if (conditionCase_ == 2) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance();
    }

    public static final int CONDITION_MATCHED_LOG_FIELD_NUMBER = 20;
    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     *
     * @return Whether the conditionMatchedLog field is set.
     */
    @java.lang.Override
    public boolean hasConditionMatchedLog() {
      return conditionCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     *
     * @return The conditionMatchedLog.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch getConditionMatchedLog() {
      if (conditionCase_ == 20) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.LogMatchOrBuilder
        getConditionMatchedLogOrBuilder() {
      if (conditionCase_ == 20) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance();
    }

    public static final int CONDITION_MONITORING_QUERY_LANGUAGE_FIELD_NUMBER = 19;
    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     *
     * @return Whether the conditionMonitoringQueryLanguage field is set.
     */
    @java.lang.Override
    public boolean hasConditionMonitoringQueryLanguage() {
      return conditionCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     *
     * @return The conditionMonitoringQueryLanguage.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
        getConditionMonitoringQueryLanguage() {
      if (conditionCase_ == 19) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
            condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageConditionOrBuilder
        getConditionMonitoringQueryLanguageOrBuilder() {
      if (conditionCase_ == 19) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
            condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          .getDefaultInstance();
    }

    public static final int CONDITION_PROMETHEUS_QUERY_LANGUAGE_FIELD_NUMBER = 21;
    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     *
     * @return Whether the conditionPrometheusQueryLanguage field is set.
     */
    @java.lang.Override
    public boolean hasConditionPrometheusQueryLanguage() {
      return conditionCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     *
     * @return The conditionPrometheusQueryLanguage.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
        getConditionPrometheusQueryLanguage() {
      if (conditionCase_ == 21) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
            condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A condition that uses the Prometheus query language to define alerts.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageConditionOrBuilder
        getConditionPrometheusQueryLanguageOrBuilder() {
      if (conditionCase_ == 21) {
        return (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
            condition_;
      }
      return com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (conditionCase_ == 1) {
        output.writeMessage(
            1, (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_);
      }
      if (conditionCase_ == 2) {
        output.writeMessage(
            2, (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 12, name_);
      }
      if (conditionCase_ == 19) {
        output.writeMessage(
            19,
            (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
                condition_);
      }
      if (conditionCase_ == 20) {
        output.writeMessage(
            20, (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_);
      }
      if (conditionCase_ == 21) {
        output.writeMessage(
            21,
            (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
                condition_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (conditionCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_);
      }
      if (conditionCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, name_);
      }
      if (conditionCase_ == 19) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                19,
                (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
                    condition_);
      }
      if (conditionCase_ == 20) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                20, (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_);
      }
      if (conditionCase_ == 21) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                21,
                (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
                    condition_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.Condition)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.AlertPolicy.Condition other =
          (com.google.monitoring.v3.AlertPolicy.Condition) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getConditionCase().equals(other.getConditionCase())) return false;
      switch (conditionCase_) {
        case 1:
          if (!getConditionThreshold().equals(other.getConditionThreshold())) return false;
          break;
        case 2:
          if (!getConditionAbsent().equals(other.getConditionAbsent())) return false;
          break;
        case 20:
          if (!getConditionMatchedLog().equals(other.getConditionMatchedLog())) return false;
          break;
        case 19:
          if (!getConditionMonitoringQueryLanguage()
              .equals(other.getConditionMonitoringQueryLanguage())) return false;
          break;
        case 21:
          if (!getConditionPrometheusQueryLanguage()
              .equals(other.getConditionPrometheusQueryLanguage())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      switch (conditionCase_) {
        case 1:
          hash = (37 * hash) + CONDITION_THRESHOLD_FIELD_NUMBER;
          hash = (53 * hash) + getConditionThreshold().hashCode();
          break;
        case 2:
          hash = (37 * hash) + CONDITION_ABSENT_FIELD_NUMBER;
          hash = (53 * hash) + getConditionAbsent().hashCode();
          break;
        case 20:
          hash = (37 * hash) + CONDITION_MATCHED_LOG_FIELD_NUMBER;
          hash = (53 * hash) + getConditionMatchedLog().hashCode();
          break;
        case 19:
          hash = (37 * hash) + CONDITION_MONITORING_QUERY_LANGUAGE_FIELD_NUMBER;
          hash = (53 * hash) + getConditionMonitoringQueryLanguage().hashCode();
          break;
        case 21:
          hash = (37 * hash) + CONDITION_PROMETHEUS_QUERY_LANGUAGE_FIELD_NUMBER;
          hash = (53 * hash) + getConditionPrometheusQueryLanguage().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.AlertPolicy.Condition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A condition is a true/false test that determines when an alerting policy
     * should open an incident. If a condition evaluates to true, it signifies
     * that something is wrong.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.Condition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.Condition)
        com.google.monitoring.v3.AlertPolicy.ConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.Condition.class,
                com.google.monitoring.v3.AlertPolicy.Condition.Builder.class);
      }

      // Construct using com.google.monitoring.v3.AlertPolicy.Condition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        displayName_ = "";
        if (conditionThresholdBuilder_ != null) {
          conditionThresholdBuilder_.clear();
        }
        if (conditionAbsentBuilder_ != null) {
          conditionAbsentBuilder_.clear();
        }
        if (conditionMatchedLogBuilder_ != null) {
          conditionMatchedLogBuilder_.clear();
        }
        if (conditionMonitoringQueryLanguageBuilder_ != null) {
          conditionMonitoringQueryLanguageBuilder_.clear();
        }
        if (conditionPrometheusQueryLanguageBuilder_ != null) {
          conditionPrometheusQueryLanguageBuilder_.clear();
        }
        conditionCase_ = 0;
        condition_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_Condition_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition getDefaultInstanceForType() {
        return com.google.monitoring.v3.AlertPolicy.Condition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition build() {
        com.google.monitoring.v3.AlertPolicy.Condition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition buildPartial() {
        com.google.monitoring.v3.AlertPolicy.Condition result =
            new com.google.monitoring.v3.AlertPolicy.Condition(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.AlertPolicy.Condition result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.displayName_ = displayName_;
        }
      }

      private void buildPartialOneofs(com.google.monitoring.v3.AlertPolicy.Condition result) {
        result.conditionCase_ = conditionCase_;
        result.condition_ = this.condition_;
        if (conditionCase_ == 1 && conditionThresholdBuilder_ != null) {
          result.condition_ = conditionThresholdBuilder_.build();
        }
        if (conditionCase_ == 2 && conditionAbsentBuilder_ != null) {
          result.condition_ = conditionAbsentBuilder_.build();
        }
        if (conditionCase_ == 20 && conditionMatchedLogBuilder_ != null) {
          result.condition_ = conditionMatchedLogBuilder_.build();
        }
        if (conditionCase_ == 19 && conditionMonitoringQueryLanguageBuilder_ != null) {
          result.condition_ = conditionMonitoringQueryLanguageBuilder_.build();
        }
        if (conditionCase_ == 21 && conditionPrometheusQueryLanguageBuilder_ != null) {
          result.condition_ = conditionPrometheusQueryLanguageBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.AlertPolicy.Condition) {
          return mergeFrom((com.google.monitoring.v3.AlertPolicy.Condition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.AlertPolicy.Condition other) {
        if (other == com.google.monitoring.v3.AlertPolicy.Condition.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        switch (other.getConditionCase()) {
          case CONDITION_THRESHOLD:
            {
              mergeConditionThreshold(other.getConditionThreshold());
              break;
            }
          case CONDITION_ABSENT:
            {
              mergeConditionAbsent(other.getConditionAbsent());
              break;
            }
          case CONDITION_MATCHED_LOG:
            {
              mergeConditionMatchedLog(other.getConditionMatchedLog());
              break;
            }
          case CONDITION_MONITORING_QUERY_LANGUAGE:
            {
              mergeConditionMonitoringQueryLanguage(other.getConditionMonitoringQueryLanguage());
              break;
            }
          case CONDITION_PROMETHEUS_QUERY_LANGUAGE:
            {
              mergeConditionPrometheusQueryLanguage(other.getConditionPrometheusQueryLanguage());
              break;
            }
          case CONDITION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getConditionThresholdFieldBuilder().getBuilder(), extensionRegistry);
                  conditionCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getConditionAbsentFieldBuilder().getBuilder(), extensionRegistry);
                  conditionCase_ = 2;
                  break;
                } // case 18
              case 50:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 50
              case 98:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 98
              case 154:
                {
                  input.readMessage(
                      getConditionMonitoringQueryLanguageFieldBuilder().getBuilder(),
                      extensionRegistry);
                  conditionCase_ = 19;
                  break;
                } // case 154
              case 162:
                {
                  input.readMessage(
                      getConditionMatchedLogFieldBuilder().getBuilder(), extensionRegistry);
                  conditionCase_ = 20;
                  break;
                } // case 162
              case 170:
                {
                  input.readMessage(
                      getConditionPrometheusQueryLanguageFieldBuilder().getBuilder(),
                      extensionRegistry);
                  conditionCase_ = 21;
                  break;
                } // case 170
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int conditionCase_ = 0;
      private java.lang.Object condition_;

      public ConditionCase getConditionCase() {
        return ConditionCase.forNumber(conditionCase_);
      }

      public Builder clearCondition() {
        conditionCase_ = 0;
        condition_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required if the condition exists. The unique resource name for this
       * condition. Its format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
       *
       * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
       * condition is created as part of a new or updated alerting policy.
       *
       * When calling the
       * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
       * method, do not include the `name` field in the conditions of the
       * requested alerting policy. Cloud Monitoring creates the
       * condition identifiers and includes them in the new policy.
       *
       * When calling the
       * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
       * method to update a policy, including a condition `name` causes the
       * existing condition to be updated. Conditions without names are added to
       * the updated policy. Existing conditions are deleted if they are not
       * updated.
       *
       * Best practice is to preserve `[CONDITION_ID]` if you make only small
       * changes, such as those to condition thresholds, durations, or trigger
       * values.  Otherwise, treat the change as a new condition and let the
       * existing condition be deleted.
       * </pre>
       *
       * <code>string name = 12;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required if the condition exists. The unique resource name for this
       * condition. Its format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
       *
       * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
       * condition is created as part of a new or updated alerting policy.
       *
       * When calling the
       * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
       * method, do not include the `name` field in the conditions of the
       * requested alerting policy. Cloud Monitoring creates the
       * condition identifiers and includes them in the new policy.
       *
       * When calling the
       * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
       * method to update a policy, including a condition `name` causes the
       * existing condition to be updated. Conditions without names are added to
       * the updated policy. Existing conditions are deleted if they are not
       * updated.
       *
       * Best practice is to preserve `[CONDITION_ID]` if you make only small
       * changes, such as those to condition thresholds, durations, or trigger
       * values.  Otherwise, treat the change as a new condition and let the
       * existing condition be deleted.
       * </pre>
       *
       * <code>string name = 12;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required if the condition exists. The unique resource name for this
       * condition. Its format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
       *
       * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
       * condition is created as part of a new or updated alerting policy.
       *
       * When calling the
       * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
       * method, do not include the `name` field in the conditions of the
       * requested alerting policy. Cloud Monitoring creates the
       * condition identifiers and includes them in the new policy.
       *
       * When calling the
       * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
       * method to update a policy, including a condition `name` causes the
       * existing condition to be updated. Conditions without names are added to
       * the updated policy. Existing conditions are deleted if they are not
       * updated.
       *
       * Best practice is to preserve `[CONDITION_ID]` if you make only small
       * changes, such as those to condition thresholds, durations, or trigger
       * values.  Otherwise, treat the change as a new condition and let the
       * existing condition be deleted.
       * </pre>
       *
       * <code>string name = 12;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required if the condition exists. The unique resource name for this
       * condition. Its format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
       *
       * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
       * condition is created as part of a new or updated alerting policy.
       *
       * When calling the
       * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
       * method, do not include the `name` field in the conditions of the
       * requested alerting policy. Cloud Monitoring creates the
       * condition identifiers and includes them in the new policy.
       *
       * When calling the
       * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
       * method to update a policy, including a condition `name` causes the
       * existing condition to be updated. Conditions without names are added to
       * the updated policy. Existing conditions are deleted if they are not
       * updated.
       *
       * Best practice is to preserve `[CONDITION_ID]` if you make only small
       * changes, such as those to condition thresholds, durations, or trigger
       * values.  Otherwise, treat the change as a new condition and let the
       * existing condition be deleted.
       * </pre>
       *
       * <code>string name = 12;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required if the condition exists. The unique resource name for this
       * condition. Its format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
       *
       * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
       * condition is created as part of a new or updated alerting policy.
       *
       * When calling the
       * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
       * method, do not include the `name` field in the conditions of the
       * requested alerting policy. Cloud Monitoring creates the
       * condition identifiers and includes them in the new policy.
       *
       * When calling the
       * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
       * method to update a policy, including a condition `name` causes the
       * existing condition to be updated. Conditions without names are added to
       * the updated policy. Existing conditions are deleted if they are not
       * updated.
       *
       * Best practice is to preserve `[CONDITION_ID]` if you make only small
       * changes, such as those to condition thresholds, durations, or trigger
       * values.  Otherwise, treat the change as a new condition and let the
       * existing condition be deleted.
       * </pre>
       *
       * <code>string name = 12;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * A short name or phrase used to identify the condition in dashboards,
       * notifications, and incidents. To avoid confusion, don't use the same
       * display name for multiple conditions in the same policy.
       * </pre>
       *
       * <code>string display_name = 6;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A short name or phrase used to identify the condition in dashboards,
       * notifications, and incidents. To avoid confusion, don't use the same
       * display name for multiple conditions in the same policy.
       * </pre>
       *
       * <code>string display_name = 6;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A short name or phrase used to identify the condition in dashboards,
       * notifications, and incidents. To avoid confusion, don't use the same
       * display name for multiple conditions in the same policy.
       * </pre>
       *
       * <code>string display_name = 6;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A short name or phrase used to identify the condition in dashboards,
       * notifications, and incidents. To avoid confusion, don't use the same
       * display name for multiple conditions in the same policy.
       * </pre>
       *
       * <code>string display_name = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A short name or phrase used to identify the condition in dashboards,
       * notifications, and incidents. To avoid confusion, don't use the same
       * display name for multiple conditions in the same policy.
       * </pre>
       *
       * <code>string display_name = 6;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold,
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.Builder,
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThresholdOrBuilder>
          conditionThresholdBuilder_;
      /**
       *
       *
       * <pre>
       * A condition that compares a time series against a threshold.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
       * </code>
       *
       * @return Whether the conditionThreshold field is set.
       */
      @java.lang.Override
      public boolean hasConditionThreshold() {
        return conditionCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * A condition that compares a time series against a threshold.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
       * </code>
       *
       * @return The conditionThreshold.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
          getConditionThreshold() {
        if (conditionThresholdBuilder_ == null) {
          if (conditionCase_ == 1) {
            return (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_;
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
              .getDefaultInstance();
        } else {
          if (conditionCase_ == 1) {
            return conditionThresholdBuilder_.getMessage();
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition that compares a time series against a threshold.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
       * </code>
       */
      public Builder setConditionThreshold(
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold value) {
        if (conditionThresholdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          condition_ = value;
          onChanged();
        } else {
          conditionThresholdBuilder_.setMessage(value);
        }
        conditionCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that compares a time series against a threshold.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
       * </code>
       */
      public Builder setConditionThreshold(
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.Builder builderForValue) {
        if (conditionThresholdBuilder_ == null) {
          condition_ = builderForValue.build();
          onChanged();
        } else {
          conditionThresholdBuilder_.setMessage(builderForValue.build());
        }
        conditionCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that compares a time series against a threshold.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
       * </code>
       */
      public Builder mergeConditionThreshold(
          com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold value) {
        if (conditionThresholdBuilder_ == null) {
          if (conditionCase_ == 1
              && condition_
                  != com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
                      .getDefaultInstance()) {
            condition_ =
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.newBuilder(
                        (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            condition_ = value;
          }
          onChanged();
        } else {
          if (conditionCase_ == 1) {
            conditionThresholdBuilder_.mergeFrom(value);
          } else {
            conditionThresholdBuilder_.setMessage(value);
          }
        }
        conditionCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that compares a time series against a threshold.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
       * </code>
       */
      public Builder clearConditionThreshold() {
        if (conditionThresholdBuilder_ == null) {
          if (conditionCase_ == 1) {
            conditionCase_ = 0;
            condition_ = null;
            onChanged();
          }
        } else {
          if (conditionCase_ == 1) {
            conditionCase_ = 0;
            condition_ = null;
          }
          conditionThresholdBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that compares a time series against a threshold.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.Builder
          getConditionThresholdBuilder() {
        return getConditionThresholdFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A condition that compares a time series against a threshold.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricThresholdOrBuilder
          getConditionThresholdOrBuilder() {
        if ((conditionCase_ == 1) && (conditionThresholdBuilder_ != null)) {
          return conditionThresholdBuilder_.getMessageOrBuilder();
        } else {
          if (conditionCase_ == 1) {
            return (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_;
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition that compares a time series against a threshold.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold,
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.Builder,
              com.google.monitoring.v3.AlertPolicy.Condition.MetricThresholdOrBuilder>
          getConditionThresholdFieldBuilder() {
        if (conditionThresholdBuilder_ == null) {
          if (!(conditionCase_ == 1)) {
            condition_ =
                com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.getDefaultInstance();
          }
          conditionThresholdBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold,
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.Builder,
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricThresholdOrBuilder>(
                  (com.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold) condition_,
                  getParentForChildren(),
                  isClean());
          condition_ = null;
        }
        conditionCase_ = 1;
        onChanged();
        return conditionThresholdBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence,
              com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.Builder,
              com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsenceOrBuilder>
          conditionAbsentBuilder_;
      /**
       *
       *
       * <pre>
       * A condition that checks that a time series continues to
       * receive new data points.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;
       * </code>
       *
       * @return Whether the conditionAbsent field is set.
       */
      @java.lang.Override
      public boolean hasConditionAbsent() {
        return conditionCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * A condition that checks that a time series continues to
       * receive new data points.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;
       * </code>
       *
       * @return The conditionAbsent.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence getConditionAbsent() {
        if (conditionAbsentBuilder_ == null) {
          if (conditionCase_ == 2) {
            return (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_;
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance();
        } else {
          if (conditionCase_ == 2) {
            return conditionAbsentBuilder_.getMessage();
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition that checks that a time series continues to
       * receive new data points.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;
       * </code>
       */
      public Builder setConditionAbsent(
          com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence value) {
        if (conditionAbsentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          condition_ = value;
          onChanged();
        } else {
          conditionAbsentBuilder_.setMessage(value);
        }
        conditionCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that checks that a time series continues to
       * receive new data points.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;
       * </code>
       */
      public Builder setConditionAbsent(
          com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.Builder builderForValue) {
        if (conditionAbsentBuilder_ == null) {
          condition_ = builderForValue.build();
          onChanged();
        } else {
          conditionAbsentBuilder_.setMessage(builderForValue.build());
        }
        conditionCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that checks that a time series continues to
       * receive new data points.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;
       * </code>
       */
      public Builder mergeConditionAbsent(
          com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence value) {
        if (conditionAbsentBuilder_ == null) {
          if (conditionCase_ == 2
              && condition_
                  != com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence
                      .getDefaultInstance()) {
            condition_ =
                com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.newBuilder(
                        (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            condition_ = value;
          }
          onChanged();
        } else {
          if (conditionCase_ == 2) {
            conditionAbsentBuilder_.mergeFrom(value);
          } else {
            conditionAbsentBuilder_.setMessage(value);
          }
        }
        conditionCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that checks that a time series continues to
       * receive new data points.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;
       * </code>
       */
      public Builder clearConditionAbsent() {
        if (conditionAbsentBuilder_ == null) {
          if (conditionCase_ == 2) {
            conditionCase_ = 0;
            condition_ = null;
            onChanged();
          }
        } else {
          if (conditionCase_ == 2) {
            conditionCase_ = 0;
            condition_ = null;
          }
          conditionAbsentBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that checks that a time series continues to
       * receive new data points.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.Builder
          getConditionAbsentBuilder() {
        return getConditionAbsentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A condition that checks that a time series continues to
       * receive new data points.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsenceOrBuilder
          getConditionAbsentOrBuilder() {
        if ((conditionCase_ == 2) && (conditionAbsentBuilder_ != null)) {
          return conditionAbsentBuilder_.getMessageOrBuilder();
        } else {
          if (conditionCase_ == 2) {
            return (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_;
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition that checks that a time series continues to
       * receive new data points.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence,
              com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.Builder,
              com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsenceOrBuilder>
          getConditionAbsentFieldBuilder() {
        if (conditionAbsentBuilder_ == null) {
          if (!(conditionCase_ == 2)) {
            condition_ =
                com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.getDefaultInstance();
          }
          conditionAbsentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence,
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.Builder,
                  com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsenceOrBuilder>(
                  (com.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence) condition_,
                  getParentForChildren(),
                  isClean());
          condition_ = null;
        }
        conditionCase_ = 2;
        onChanged();
        return conditionAbsentBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Condition.LogMatch,
              com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.Builder,
              com.google.monitoring.v3.AlertPolicy.Condition.LogMatchOrBuilder>
          conditionMatchedLogBuilder_;
      /**
       *
       *
       * <pre>
       * A condition that checks for log messages matching given constraints. If
       * set, no other conditions can be present.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;
       * </code>
       *
       * @return Whether the conditionMatchedLog field is set.
       */
      @java.lang.Override
      public boolean hasConditionMatchedLog() {
        return conditionCase_ == 20;
      }
      /**
       *
       *
       * <pre>
       * A condition that checks for log messages matching given constraints. If
       * set, no other conditions can be present.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;
       * </code>
       *
       * @return The conditionMatchedLog.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch getConditionMatchedLog() {
        if (conditionMatchedLogBuilder_ == null) {
          if (conditionCase_ == 20) {
            return (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_;
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance();
        } else {
          if (conditionCase_ == 20) {
            return conditionMatchedLogBuilder_.getMessage();
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition that checks for log messages matching given constraints. If
       * set, no other conditions can be present.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;
       * </code>
       */
      public Builder setConditionMatchedLog(
          com.google.monitoring.v3.AlertPolicy.Condition.LogMatch value) {
        if (conditionMatchedLogBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          condition_ = value;
          onChanged();
        } else {
          conditionMatchedLogBuilder_.setMessage(value);
        }
        conditionCase_ = 20;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that checks for log messages matching given constraints. If
       * set, no other conditions can be present.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;
       * </code>
       */
      public Builder setConditionMatchedLog(
          com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.Builder builderForValue) {
        if (conditionMatchedLogBuilder_ == null) {
          condition_ = builderForValue.build();
          onChanged();
        } else {
          conditionMatchedLogBuilder_.setMessage(builderForValue.build());
        }
        conditionCase_ = 20;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that checks for log messages matching given constraints. If
       * set, no other conditions can be present.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;
       * </code>
       */
      public Builder mergeConditionMatchedLog(
          com.google.monitoring.v3.AlertPolicy.Condition.LogMatch value) {
        if (conditionMatchedLogBuilder_ == null) {
          if (conditionCase_ == 20
              && condition_
                  != com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance()) {
            condition_ =
                com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.newBuilder(
                        (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            condition_ = value;
          }
          onChanged();
        } else {
          if (conditionCase_ == 20) {
            conditionMatchedLogBuilder_.mergeFrom(value);
          } else {
            conditionMatchedLogBuilder_.setMessage(value);
          }
        }
        conditionCase_ = 20;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that checks for log messages matching given constraints. If
       * set, no other conditions can be present.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;
       * </code>
       */
      public Builder clearConditionMatchedLog() {
        if (conditionMatchedLogBuilder_ == null) {
          if (conditionCase_ == 20) {
            conditionCase_ = 0;
            condition_ = null;
            onChanged();
          }
        } else {
          if (conditionCase_ == 20) {
            conditionCase_ = 0;
            condition_ = null;
          }
          conditionMatchedLogBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that checks for log messages matching given constraints. If
       * set, no other conditions can be present.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.Builder
          getConditionMatchedLogBuilder() {
        return getConditionMatchedLogFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A condition that checks for log messages matching given constraints. If
       * set, no other conditions can be present.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;
       * </code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.LogMatchOrBuilder
          getConditionMatchedLogOrBuilder() {
        if ((conditionCase_ == 20) && (conditionMatchedLogBuilder_ != null)) {
          return conditionMatchedLogBuilder_.getMessageOrBuilder();
        } else {
          if (conditionCase_ == 20) {
            return (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_;
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition that checks for log messages matching given constraints. If
       * set, no other conditions can be present.
       * </pre>
       *
       * <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Condition.LogMatch,
              com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.Builder,
              com.google.monitoring.v3.AlertPolicy.Condition.LogMatchOrBuilder>
          getConditionMatchedLogFieldBuilder() {
        if (conditionMatchedLogBuilder_ == null) {
          if (!(conditionCase_ == 20)) {
            condition_ =
                com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.getDefaultInstance();
          }
          conditionMatchedLogBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.AlertPolicy.Condition.LogMatch,
                  com.google.monitoring.v3.AlertPolicy.Condition.LogMatch.Builder,
                  com.google.monitoring.v3.AlertPolicy.Condition.LogMatchOrBuilder>(
                  (com.google.monitoring.v3.AlertPolicy.Condition.LogMatch) condition_,
                  getParentForChildren(),
                  isClean());
          condition_ = null;
        }
        conditionCase_ = 20;
        onChanged();
        return conditionMatchedLogBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition,
              com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                  .Builder,
              com.google.monitoring.v3.AlertPolicy.Condition
                  .MonitoringQueryLanguageConditionOrBuilder>
          conditionMonitoringQueryLanguageBuilder_;
      /**
       *
       *
       * <pre>
       * A condition that uses the Monitoring Query Language to define
       * alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
       * </code>
       *
       * @return Whether the conditionMonitoringQueryLanguage field is set.
       */
      @java.lang.Override
      public boolean hasConditionMonitoringQueryLanguage() {
        return conditionCase_ == 19;
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Monitoring Query Language to define
       * alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
       * </code>
       *
       * @return The conditionMonitoringQueryLanguage.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
          getConditionMonitoringQueryLanguage() {
        if (conditionMonitoringQueryLanguageBuilder_ == null) {
          if (conditionCase_ == 19) {
            return (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
                condition_;
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
              .getDefaultInstance();
        } else {
          if (conditionCase_ == 19) {
            return conditionMonitoringQueryLanguageBuilder_.getMessage();
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Monitoring Query Language to define
       * alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
       * </code>
       */
      public Builder setConditionMonitoringQueryLanguage(
          com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition value) {
        if (conditionMonitoringQueryLanguageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          condition_ = value;
          onChanged();
        } else {
          conditionMonitoringQueryLanguageBuilder_.setMessage(value);
        }
        conditionCase_ = 19;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Monitoring Query Language to define
       * alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
       * </code>
       */
      public Builder setConditionMonitoringQueryLanguage(
          com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition.Builder
              builderForValue) {
        if (conditionMonitoringQueryLanguageBuilder_ == null) {
          condition_ = builderForValue.build();
          onChanged();
        } else {
          conditionMonitoringQueryLanguageBuilder_.setMessage(builderForValue.build());
        }
        conditionCase_ = 19;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Monitoring Query Language to define
       * alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
       * </code>
       */
      public Builder mergeConditionMonitoringQueryLanguage(
          com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition value) {
        if (conditionMonitoringQueryLanguageBuilder_ == null) {
          if (conditionCase_ == 19
              && condition_
                  != com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                      .getDefaultInstance()) {
            condition_ =
                com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                    .newBuilder(
                        (com.google.monitoring.v3.AlertPolicy.Condition
                                .MonitoringQueryLanguageCondition)
                            condition_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            condition_ = value;
          }
          onChanged();
        } else {
          if (conditionCase_ == 19) {
            conditionMonitoringQueryLanguageBuilder_.mergeFrom(value);
          } else {
            conditionMonitoringQueryLanguageBuilder_.setMessage(value);
          }
        }
        conditionCase_ = 19;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Monitoring Query Language to define
       * alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
       * </code>
       */
      public Builder clearConditionMonitoringQueryLanguage() {
        if (conditionMonitoringQueryLanguageBuilder_ == null) {
          if (conditionCase_ == 19) {
            conditionCase_ = 0;
            condition_ = null;
            onChanged();
          }
        } else {
          if (conditionCase_ == 19) {
            conditionCase_ = 0;
            condition_ = null;
          }
          conditionMonitoringQueryLanguageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Monitoring Query Language to define
       * alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition.Builder
          getConditionMonitoringQueryLanguageBuilder() {
        return getConditionMonitoringQueryLanguageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Monitoring Query Language to define
       * alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
       * </code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition
              .MonitoringQueryLanguageConditionOrBuilder
          getConditionMonitoringQueryLanguageOrBuilder() {
        if ((conditionCase_ == 19) && (conditionMonitoringQueryLanguageBuilder_ != null)) {
          return conditionMonitoringQueryLanguageBuilder_.getMessageOrBuilder();
        } else {
          if (conditionCase_ == 19) {
            return (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
                condition_;
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Monitoring Query Language to define
       * alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition,
              com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                  .Builder,
              com.google.monitoring.v3.AlertPolicy.Condition
                  .MonitoringQueryLanguageConditionOrBuilder>
          getConditionMonitoringQueryLanguageFieldBuilder() {
        if (conditionMonitoringQueryLanguageBuilder_ == null) {
          if (!(conditionCase_ == 19)) {
            condition_ =
                com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                    .getDefaultInstance();
          }
          conditionMonitoringQueryLanguageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition,
                  com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition
                      .Builder,
                  com.google.monitoring.v3.AlertPolicy.Condition
                      .MonitoringQueryLanguageConditionOrBuilder>(
                  (com.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition)
                      condition_,
                  getParentForChildren(),
                  isClean());
          condition_ = null;
        }
        conditionCase_ = 19;
        onChanged();
        return conditionMonitoringQueryLanguageBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition,
              com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                  .Builder,
              com.google.monitoring.v3.AlertPolicy.Condition
                  .PrometheusQueryLanguageConditionOrBuilder>
          conditionPrometheusQueryLanguageBuilder_;
      /**
       *
       *
       * <pre>
       * A condition that uses the Prometheus query language to define alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
       * </code>
       *
       * @return Whether the conditionPrometheusQueryLanguage field is set.
       */
      @java.lang.Override
      public boolean hasConditionPrometheusQueryLanguage() {
        return conditionCase_ == 21;
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Prometheus query language to define alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
       * </code>
       *
       * @return The conditionPrometheusQueryLanguage.
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
          getConditionPrometheusQueryLanguage() {
        if (conditionPrometheusQueryLanguageBuilder_ == null) {
          if (conditionCase_ == 21) {
            return (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
                condition_;
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
              .getDefaultInstance();
        } else {
          if (conditionCase_ == 21) {
            return conditionPrometheusQueryLanguageBuilder_.getMessage();
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Prometheus query language to define alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
       * </code>
       */
      public Builder setConditionPrometheusQueryLanguage(
          com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition value) {
        if (conditionPrometheusQueryLanguageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          condition_ = value;
          onChanged();
        } else {
          conditionPrometheusQueryLanguageBuilder_.setMessage(value);
        }
        conditionCase_ = 21;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Prometheus query language to define alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
       * </code>
       */
      public Builder setConditionPrometheusQueryLanguage(
          com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition.Builder
              builderForValue) {
        if (conditionPrometheusQueryLanguageBuilder_ == null) {
          condition_ = builderForValue.build();
          onChanged();
        } else {
          conditionPrometheusQueryLanguageBuilder_.setMessage(builderForValue.build());
        }
        conditionCase_ = 21;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Prometheus query language to define alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
       * </code>
       */
      public Builder mergeConditionPrometheusQueryLanguage(
          com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition value) {
        if (conditionPrometheusQueryLanguageBuilder_ == null) {
          if (conditionCase_ == 21
              && condition_
                  != com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                      .getDefaultInstance()) {
            condition_ =
                com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                    .newBuilder(
                        (com.google.monitoring.v3.AlertPolicy.Condition
                                .PrometheusQueryLanguageCondition)
                            condition_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            condition_ = value;
          }
          onChanged();
        } else {
          if (conditionCase_ == 21) {
            conditionPrometheusQueryLanguageBuilder_.mergeFrom(value);
          } else {
            conditionPrometheusQueryLanguageBuilder_.setMessage(value);
          }
        }
        conditionCase_ = 21;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Prometheus query language to define alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
       * </code>
       */
      public Builder clearConditionPrometheusQueryLanguage() {
        if (conditionPrometheusQueryLanguageBuilder_ == null) {
          if (conditionCase_ == 21) {
            conditionCase_ = 0;
            condition_ = null;
            onChanged();
          }
        } else {
          if (conditionCase_ == 21) {
            conditionCase_ = 0;
            condition_ = null;
          }
          conditionPrometheusQueryLanguageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Prometheus query language to define alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition.Builder
          getConditionPrometheusQueryLanguageBuilder() {
        return getConditionPrometheusQueryLanguageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Prometheus query language to define alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
       * </code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.Condition
              .PrometheusQueryLanguageConditionOrBuilder
          getConditionPrometheusQueryLanguageOrBuilder() {
        if ((conditionCase_ == 21) && (conditionPrometheusQueryLanguageBuilder_ != null)) {
          return conditionPrometheusQueryLanguageBuilder_.getMessageOrBuilder();
        } else {
          if (conditionCase_ == 21) {
            return (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
                condition_;
          }
          return com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition that uses the Prometheus query language to define alerts.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition,
              com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                  .Builder,
              com.google.monitoring.v3.AlertPolicy.Condition
                  .PrometheusQueryLanguageConditionOrBuilder>
          getConditionPrometheusQueryLanguageFieldBuilder() {
        if (conditionPrometheusQueryLanguageBuilder_ == null) {
          if (!(conditionCase_ == 21)) {
            condition_ =
                com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                    .getDefaultInstance();
          }
          conditionPrometheusQueryLanguageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition,
                  com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition
                      .Builder,
                  com.google.monitoring.v3.AlertPolicy.Condition
                      .PrometheusQueryLanguageConditionOrBuilder>(
                  (com.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition)
                      condition_,
                  getParentForChildren(),
                  isClean());
          condition_ = null;
        }
        conditionCase_ = 21;
        onChanged();
        return conditionPrometheusQueryLanguageBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.Condition)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.Condition)
    private static final com.google.monitoring.v3.AlertPolicy.Condition DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.Condition();
    }

    public static com.google.monitoring.v3.AlertPolicy.Condition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Condition> PARSER =
        new com.google.protobuf.AbstractParser<Condition>() {
          @java.lang.Override
          public Condition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Condition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Condition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.Condition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AlertStrategyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.AlertStrategy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required for alert policies with a `LogMatch` condition.
     *
     * This limit is not implemented for alert policies that are not log-based.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
     * </code>
     *
     * @return Whether the notificationRateLimit field is set.
     */
    boolean hasNotificationRateLimit();
    /**
     *
     *
     * <pre>
     * Required for alert policies with a `LogMatch` condition.
     *
     * This limit is not implemented for alert policies that are not log-based.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
     * </code>
     *
     * @return The notificationRateLimit.
     */
    com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
        getNotificationRateLimit();
    /**
     *
     *
     * <pre>
     * Required for alert policies with a `LogMatch` condition.
     *
     * This limit is not implemented for alert policies that are not log-based.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
     * </code>
     */
    com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimitOrBuilder
        getNotificationRateLimitOrBuilder();

    /**
     *
     *
     * <pre>
     * If an alert policy that was active has no data for this long, any open
     * incidents will close
     * </pre>
     *
     * <code>.google.protobuf.Duration auto_close = 3;</code>
     *
     * @return Whether the autoClose field is set.
     */
    boolean hasAutoClose();
    /**
     *
     *
     * <pre>
     * If an alert policy that was active has no data for this long, any open
     * incidents will close
     * </pre>
     *
     * <code>.google.protobuf.Duration auto_close = 3;</code>
     *
     * @return The autoClose.
     */
    com.google.protobuf.Duration getAutoClose();
    /**
     *
     *
     * <pre>
     * If an alert policy that was active has no data for this long, any open
     * incidents will close
     * </pre>
     *
     * <code>.google.protobuf.Duration auto_close = 3;</code>
     */
    com.google.protobuf.DurationOrBuilder getAutoCloseOrBuilder();

    /**
     *
     *
     * <pre>
     * Control how notifications will be sent out, on a per-channel basis.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
     * </code>
     */
    java.util.List<com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy>
        getNotificationChannelStrategyList();
    /**
     *
     *
     * <pre>
     * Control how notifications will be sent out, on a per-channel basis.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
     * </code>
     */
    com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
        getNotificationChannelStrategy(int index);
    /**
     *
     *
     * <pre>
     * Control how notifications will be sent out, on a per-channel basis.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
     * </code>
     */
    int getNotificationChannelStrategyCount();
    /**
     *
     *
     * <pre>
     * Control how notifications will be sent out, on a per-channel basis.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.monitoring.v3.AlertPolicy.AlertStrategy
                    .NotificationChannelStrategyOrBuilder>
        getNotificationChannelStrategyOrBuilderList();
    /**
     *
     *
     * <pre>
     * Control how notifications will be sent out, on a per-channel basis.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
     * </code>
     */
    com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategyOrBuilder
        getNotificationChannelStrategyOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Control over how the notification channels in `notification_channels`
   * are notified when this alert fires.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.AlertPolicy.AlertStrategy}
   */
  public static final class AlertStrategy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.AlertStrategy)
      AlertStrategyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AlertStrategy.newBuilder() to construct.
    private AlertStrategy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AlertStrategy() {
      notificationChannelStrategy_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AlertStrategy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.class,
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.Builder.class);
    }

    public interface NotificationRateLimitOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Not more than one notification per `period`.
       * </pre>
       *
       * <code>.google.protobuf.Duration period = 1;</code>
       *
       * @return Whether the period field is set.
       */
      boolean hasPeriod();
      /**
       *
       *
       * <pre>
       * Not more than one notification per `period`.
       * </pre>
       *
       * <code>.google.protobuf.Duration period = 1;</code>
       *
       * @return The period.
       */
      com.google.protobuf.Duration getPeriod();
      /**
       *
       *
       * <pre>
       * Not more than one notification per `period`.
       * </pre>
       *
       * <code>.google.protobuf.Duration period = 1;</code>
       */
      com.google.protobuf.DurationOrBuilder getPeriodOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Control over the rate of notifications sent to this alert policy's
     * notification channels.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit}
     */
    public static final class NotificationRateLimit extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit)
        NotificationRateLimitOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use NotificationRateLimit.newBuilder() to construct.
      private NotificationRateLimit(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private NotificationRateLimit() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new NotificationRateLimit();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_NotificationRateLimit_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_NotificationRateLimit_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit.class,
                com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit.Builder
                    .class);
      }

      public static final int PERIOD_FIELD_NUMBER = 1;
      private com.google.protobuf.Duration period_;
      /**
       *
       *
       * <pre>
       * Not more than one notification per `period`.
       * </pre>
       *
       * <code>.google.protobuf.Duration period = 1;</code>
       *
       * @return Whether the period field is set.
       */
      @java.lang.Override
      public boolean hasPeriod() {
        return period_ != null;
      }
      /**
       *
       *
       * <pre>
       * Not more than one notification per `period`.
       * </pre>
       *
       * <code>.google.protobuf.Duration period = 1;</code>
       *
       * @return The period.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getPeriod() {
        return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
      }
      /**
       *
       *
       * <pre>
       * Not more than one notification per `period`.
       * </pre>
       *
       * <code>.google.protobuf.Duration period = 1;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getPeriodOrBuilder() {
        return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (period_ != null) {
          output.writeMessage(1, getPeriod());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (period_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPeriod());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit other =
            (com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit) obj;

        if (hasPeriod() != other.hasPeriod()) return false;
        if (hasPeriod()) {
          if (!getPeriod().equals(other.getPeriod())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasPeriod()) {
          hash = (37 * hash) + PERIOD_FIELD_NUMBER;
          hash = (53 * hash) + getPeriod().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Control over the rate of notifications sent to this alert policy's
       * notification channels.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit)
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimitOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_NotificationRateLimit_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_NotificationRateLimit_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit.class,
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit.Builder
                      .class);
        }

        // Construct using
        // com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          period_ = null;
          if (periodBuilder_ != null) {
            periodBuilder_.dispose();
            periodBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_NotificationRateLimit_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit build() {
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
            buildPartial() {
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit result =
              new com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.period_ = periodBuilder_ == null ? period_ : periodBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit) {
            return mergeFrom(
                (com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit other) {
          if (other
              == com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
                  .getDefaultInstance()) return this;
          if (other.hasPeriod()) {
            mergePeriod(other.getPeriod());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getPeriodFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.Duration period_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            periodBuilder_;
        /**
         *
         *
         * <pre>
         * Not more than one notification per `period`.
         * </pre>
         *
         * <code>.google.protobuf.Duration period = 1;</code>
         *
         * @return Whether the period field is set.
         */
        public boolean hasPeriod() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Not more than one notification per `period`.
         * </pre>
         *
         * <code>.google.protobuf.Duration period = 1;</code>
         *
         * @return The period.
         */
        public com.google.protobuf.Duration getPeriod() {
          if (periodBuilder_ == null) {
            return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
          } else {
            return periodBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Not more than one notification per `period`.
         * </pre>
         *
         * <code>.google.protobuf.Duration period = 1;</code>
         */
        public Builder setPeriod(com.google.protobuf.Duration value) {
          if (periodBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            period_ = value;
          } else {
            periodBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Not more than one notification per `period`.
         * </pre>
         *
         * <code>.google.protobuf.Duration period = 1;</code>
         */
        public Builder setPeriod(com.google.protobuf.Duration.Builder builderForValue) {
          if (periodBuilder_ == null) {
            period_ = builderForValue.build();
          } else {
            periodBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Not more than one notification per `period`.
         * </pre>
         *
         * <code>.google.protobuf.Duration period = 1;</code>
         */
        public Builder mergePeriod(com.google.protobuf.Duration value) {
          if (periodBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && period_ != null
                && period_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getPeriodBuilder().mergeFrom(value);
            } else {
              period_ = value;
            }
          } else {
            periodBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Not more than one notification per `period`.
         * </pre>
         *
         * <code>.google.protobuf.Duration period = 1;</code>
         */
        public Builder clearPeriod() {
          bitField0_ = (bitField0_ & ~0x00000001);
          period_ = null;
          if (periodBuilder_ != null) {
            periodBuilder_.dispose();
            periodBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Not more than one notification per `period`.
         * </pre>
         *
         * <code>.google.protobuf.Duration period = 1;</code>
         */
        public com.google.protobuf.Duration.Builder getPeriodBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getPeriodFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Not more than one notification per `period`.
         * </pre>
         *
         * <code>.google.protobuf.Duration period = 1;</code>
         */
        public com.google.protobuf.DurationOrBuilder getPeriodOrBuilder() {
          if (periodBuilder_ != null) {
            return periodBuilder_.getMessageOrBuilder();
          } else {
            return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
          }
        }
        /**
         *
         *
         * <pre>
         * Not more than one notification per `period`.
         * </pre>
         *
         * <code>.google.protobuf.Duration period = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getPeriodFieldBuilder() {
          if (periodBuilder_ == null) {
            periodBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getPeriod(), getParentForChildren(), isClean());
            period_ = null;
          }
          return periodBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit)
      private static final com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit();
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<NotificationRateLimit> PARSER =
          new com.google.protobuf.AbstractParser<NotificationRateLimit>() {
            @java.lang.Override
            public NotificationRateLimit parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<NotificationRateLimit> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<NotificationRateLimit> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface NotificationChannelStrategyOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The full REST resource name for the notification channels that these
       * settings apply to. Each of these correspond to the name field in one
       * of the NotificationChannel objects referenced in the
       * notification_channels field of this AlertPolicy.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
       * </pre>
       *
       * <code>repeated string notification_channel_names = 1;</code>
       *
       * @return A list containing the notificationChannelNames.
       */
      java.util.List<java.lang.String> getNotificationChannelNamesList();
      /**
       *
       *
       * <pre>
       * The full REST resource name for the notification channels that these
       * settings apply to. Each of these correspond to the name field in one
       * of the NotificationChannel objects referenced in the
       * notification_channels field of this AlertPolicy.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
       * </pre>
       *
       * <code>repeated string notification_channel_names = 1;</code>
       *
       * @return The count of notificationChannelNames.
       */
      int getNotificationChannelNamesCount();
      /**
       *
       *
       * <pre>
       * The full REST resource name for the notification channels that these
       * settings apply to. Each of these correspond to the name field in one
       * of the NotificationChannel objects referenced in the
       * notification_channels field of this AlertPolicy.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
       * </pre>
       *
       * <code>repeated string notification_channel_names = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The notificationChannelNames at the given index.
       */
      java.lang.String getNotificationChannelNames(int index);
      /**
       *
       *
       * <pre>
       * The full REST resource name for the notification channels that these
       * settings apply to. Each of these correspond to the name field in one
       * of the NotificationChannel objects referenced in the
       * notification_channels field of this AlertPolicy.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
       * </pre>
       *
       * <code>repeated string notification_channel_names = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the notificationChannelNames at the given index.
       */
      com.google.protobuf.ByteString getNotificationChannelNamesBytes(int index);

      /**
       *
       *
       * <pre>
       * The frequency at which to send reminder notifications for open
       * incidents.
       * </pre>
       *
       * <code>.google.protobuf.Duration renotify_interval = 2;</code>
       *
       * @return Whether the renotifyInterval field is set.
       */
      boolean hasRenotifyInterval();
      /**
       *
       *
       * <pre>
       * The frequency at which to send reminder notifications for open
       * incidents.
       * </pre>
       *
       * <code>.google.protobuf.Duration renotify_interval = 2;</code>
       *
       * @return The renotifyInterval.
       */
      com.google.protobuf.Duration getRenotifyInterval();
      /**
       *
       *
       * <pre>
       * The frequency at which to send reminder notifications for open
       * incidents.
       * </pre>
       *
       * <code>.google.protobuf.Duration renotify_interval = 2;</code>
       */
      com.google.protobuf.DurationOrBuilder getRenotifyIntervalOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Control over how the notification channels in `notification_channels`
     * are notified when this alert fires, on a per-channel basis.
     * </pre>
     *
     * Protobuf type {@code
     * google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy}
     */
    public static final class NotificationChannelStrategy
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy)
        NotificationChannelStrategyOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use NotificationChannelStrategy.newBuilder() to construct.
      private NotificationChannelStrategy(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private NotificationChannelStrategy() {
        notificationChannelNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new NotificationChannelStrategy();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_NotificationChannelStrategy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_NotificationChannelStrategy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
                    .class,
                com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
                    .Builder.class);
      }

      public static final int NOTIFICATION_CHANNEL_NAMES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList notificationChannelNames_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * The full REST resource name for the notification channels that these
       * settings apply to. Each of these correspond to the name field in one
       * of the NotificationChannel objects referenced in the
       * notification_channels field of this AlertPolicy.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
       * </pre>
       *
       * <code>repeated string notification_channel_names = 1;</code>
       *
       * @return A list containing the notificationChannelNames.
       */
      public com.google.protobuf.ProtocolStringList getNotificationChannelNamesList() {
        return notificationChannelNames_;
      }
      /**
       *
       *
       * <pre>
       * The full REST resource name for the notification channels that these
       * settings apply to. Each of these correspond to the name field in one
       * of the NotificationChannel objects referenced in the
       * notification_channels field of this AlertPolicy.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
       * </pre>
       *
       * <code>repeated string notification_channel_names = 1;</code>
       *
       * @return The count of notificationChannelNames.
       */
      public int getNotificationChannelNamesCount() {
        return notificationChannelNames_.size();
      }
      /**
       *
       *
       * <pre>
       * The full REST resource name for the notification channels that these
       * settings apply to. Each of these correspond to the name field in one
       * of the NotificationChannel objects referenced in the
       * notification_channels field of this AlertPolicy.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
       * </pre>
       *
       * <code>repeated string notification_channel_names = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The notificationChannelNames at the given index.
       */
      public java.lang.String getNotificationChannelNames(int index) {
        return notificationChannelNames_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The full REST resource name for the notification channels that these
       * settings apply to. Each of these correspond to the name field in one
       * of the NotificationChannel objects referenced in the
       * notification_channels field of this AlertPolicy.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
       * </pre>
       *
       * <code>repeated string notification_channel_names = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the notificationChannelNames at the given index.
       */
      public com.google.protobuf.ByteString getNotificationChannelNamesBytes(int index) {
        return notificationChannelNames_.getByteString(index);
      }

      public static final int RENOTIFY_INTERVAL_FIELD_NUMBER = 2;
      private com.google.protobuf.Duration renotifyInterval_;
      /**
       *
       *
       * <pre>
       * The frequency at which to send reminder notifications for open
       * incidents.
       * </pre>
       *
       * <code>.google.protobuf.Duration renotify_interval = 2;</code>
       *
       * @return Whether the renotifyInterval field is set.
       */
      @java.lang.Override
      public boolean hasRenotifyInterval() {
        return renotifyInterval_ != null;
      }
      /**
       *
       *
       * <pre>
       * The frequency at which to send reminder notifications for open
       * incidents.
       * </pre>
       *
       * <code>.google.protobuf.Duration renotify_interval = 2;</code>
       *
       * @return The renotifyInterval.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getRenotifyInterval() {
        return renotifyInterval_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : renotifyInterval_;
      }
      /**
       *
       *
       * <pre>
       * The frequency at which to send reminder notifications for open
       * incidents.
       * </pre>
       *
       * <code>.google.protobuf.Duration renotify_interval = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getRenotifyIntervalOrBuilder() {
        return renotifyInterval_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : renotifyInterval_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < notificationChannelNames_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 1, notificationChannelNames_.getRaw(i));
        }
        if (renotifyInterval_ != null) {
          output.writeMessage(2, getRenotifyInterval());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < notificationChannelNames_.size(); i++) {
            dataSize += computeStringSizeNoTag(notificationChannelNames_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getNotificationChannelNamesList().size();
        }
        if (renotifyInterval_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRenotifyInterval());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy other =
            (com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy) obj;

        if (!getNotificationChannelNamesList().equals(other.getNotificationChannelNamesList()))
          return false;
        if (hasRenotifyInterval() != other.hasRenotifyInterval()) return false;
        if (hasRenotifyInterval()) {
          if (!getRenotifyInterval().equals(other.getRenotifyInterval())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getNotificationChannelNamesCount() > 0) {
          hash = (37 * hash) + NOTIFICATION_CHANNEL_NAMES_FIELD_NUMBER;
          hash = (53 * hash) + getNotificationChannelNamesList().hashCode();
        }
        if (hasRenotifyInterval()) {
          hash = (37 * hash) + RENOTIFY_INTERVAL_FIELD_NUMBER;
          hash = (53 * hash) + getRenotifyInterval().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Control over how the notification channels in `notification_channels`
       * are notified when this alert fires, on a per-channel basis.
       * </pre>
       *
       * Protobuf type {@code
       * google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy)
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategyOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_NotificationChannelStrategy_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_NotificationChannelStrategy_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
                      .class,
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
                      .Builder.class);
        }

        // Construct using
        // com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          notificationChannelNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
          renotifyInterval_ = null;
          if (renotifyIntervalBuilder_ != null) {
            renotifyIntervalBuilder_.dispose();
            renotifyIntervalBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.AlertProto
              .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_NotificationChannelStrategy_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
            build() {
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
            buildPartial() {
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy result =
              new com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            notificationChannelNames_.makeImmutable();
            result.notificationChannelNames_ = notificationChannelNames_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.renotifyInterval_ =
                renotifyIntervalBuilder_ == null
                    ? renotifyInterval_
                    : renotifyIntervalBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy) {
            return mergeFrom(
                (com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy other) {
          if (other
              == com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
                  .getDefaultInstance()) return this;
          if (!other.notificationChannelNames_.isEmpty()) {
            if (notificationChannelNames_.isEmpty()) {
              notificationChannelNames_ = other.notificationChannelNames_;
              bitField0_ |= 0x00000001;
            } else {
              ensureNotificationChannelNamesIsMutable();
              notificationChannelNames_.addAll(other.notificationChannelNames_);
            }
            onChanged();
          }
          if (other.hasRenotifyInterval()) {
            mergeRenotifyInterval(other.getRenotifyInterval());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureNotificationChannelNamesIsMutable();
                    notificationChannelNames_.add(s);
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getRenotifyIntervalFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList notificationChannelNames_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureNotificationChannelNamesIsMutable() {
          if (!notificationChannelNames_.isModifiable()) {
            notificationChannelNames_ =
                new com.google.protobuf.LazyStringArrayList(notificationChannelNames_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * The full REST resource name for the notification channels that these
         * settings apply to. Each of these correspond to the name field in one
         * of the NotificationChannel objects referenced in the
         * notification_channels field of this AlertPolicy.
         * The format is:
         *
         *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
         * </pre>
         *
         * <code>repeated string notification_channel_names = 1;</code>
         *
         * @return A list containing the notificationChannelNames.
         */
        public com.google.protobuf.ProtocolStringList getNotificationChannelNamesList() {
          notificationChannelNames_.makeImmutable();
          return notificationChannelNames_;
        }
        /**
         *
         *
         * <pre>
         * The full REST resource name for the notification channels that these
         * settings apply to. Each of these correspond to the name field in one
         * of the NotificationChannel objects referenced in the
         * notification_channels field of this AlertPolicy.
         * The format is:
         *
         *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
         * </pre>
         *
         * <code>repeated string notification_channel_names = 1;</code>
         *
         * @return The count of notificationChannelNames.
         */
        public int getNotificationChannelNamesCount() {
          return notificationChannelNames_.size();
        }
        /**
         *
         *
         * <pre>
         * The full REST resource name for the notification channels that these
         * settings apply to. Each of these correspond to the name field in one
         * of the NotificationChannel objects referenced in the
         * notification_channels field of this AlertPolicy.
         * The format is:
         *
         *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
         * </pre>
         *
         * <code>repeated string notification_channel_names = 1;</code>
         *
         * @param index The index of the element to return.
         * @return The notificationChannelNames at the given index.
         */
        public java.lang.String getNotificationChannelNames(int index) {
          return notificationChannelNames_.get(index);
        }
        /**
         *
         *
         * <pre>
         * The full REST resource name for the notification channels that these
         * settings apply to. Each of these correspond to the name field in one
         * of the NotificationChannel objects referenced in the
         * notification_channels field of this AlertPolicy.
         * The format is:
         *
         *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
         * </pre>
         *
         * <code>repeated string notification_channel_names = 1;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the notificationChannelNames at the given index.
         */
        public com.google.protobuf.ByteString getNotificationChannelNamesBytes(int index) {
          return notificationChannelNames_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * The full REST resource name for the notification channels that these
         * settings apply to. Each of these correspond to the name field in one
         * of the NotificationChannel objects referenced in the
         * notification_channels field of this AlertPolicy.
         * The format is:
         *
         *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
         * </pre>
         *
         * <code>repeated string notification_channel_names = 1;</code>
         *
         * @param index The index to set the value at.
         * @param value The notificationChannelNames to set.
         * @return This builder for chaining.
         */
        public Builder setNotificationChannelNames(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNotificationChannelNamesIsMutable();
          notificationChannelNames_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full REST resource name for the notification channels that these
         * settings apply to. Each of these correspond to the name field in one
         * of the NotificationChannel objects referenced in the
         * notification_channels field of this AlertPolicy.
         * The format is:
         *
         *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
         * </pre>
         *
         * <code>repeated string notification_channel_names = 1;</code>
         *
         * @param value The notificationChannelNames to add.
         * @return This builder for chaining.
         */
        public Builder addNotificationChannelNames(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNotificationChannelNamesIsMutable();
          notificationChannelNames_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full REST resource name for the notification channels that these
         * settings apply to. Each of these correspond to the name field in one
         * of the NotificationChannel objects referenced in the
         * notification_channels field of this AlertPolicy.
         * The format is:
         *
         *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
         * </pre>
         *
         * <code>repeated string notification_channel_names = 1;</code>
         *
         * @param values The notificationChannelNames to add.
         * @return This builder for chaining.
         */
        public Builder addAllNotificationChannelNames(java.lang.Iterable<java.lang.String> values) {
          ensureNotificationChannelNamesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, notificationChannelNames_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full REST resource name for the notification channels that these
         * settings apply to. Each of these correspond to the name field in one
         * of the NotificationChannel objects referenced in the
         * notification_channels field of this AlertPolicy.
         * The format is:
         *
         *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
         * </pre>
         *
         * <code>repeated string notification_channel_names = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearNotificationChannelNames() {
          notificationChannelNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full REST resource name for the notification channels that these
         * settings apply to. Each of these correspond to the name field in one
         * of the NotificationChannel objects referenced in the
         * notification_channels field of this AlertPolicy.
         * The format is:
         *
         *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
         * </pre>
         *
         * <code>repeated string notification_channel_names = 1;</code>
         *
         * @param value The bytes of the notificationChannelNames to add.
         * @return This builder for chaining.
         */
        public Builder addNotificationChannelNamesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureNotificationChannelNamesIsMutable();
          notificationChannelNames_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Duration renotifyInterval_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            renotifyIntervalBuilder_;
        /**
         *
         *
         * <pre>
         * The frequency at which to send reminder notifications for open
         * incidents.
         * </pre>
         *
         * <code>.google.protobuf.Duration renotify_interval = 2;</code>
         *
         * @return Whether the renotifyInterval field is set.
         */
        public boolean hasRenotifyInterval() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * The frequency at which to send reminder notifications for open
         * incidents.
         * </pre>
         *
         * <code>.google.protobuf.Duration renotify_interval = 2;</code>
         *
         * @return The renotifyInterval.
         */
        public com.google.protobuf.Duration getRenotifyInterval() {
          if (renotifyIntervalBuilder_ == null) {
            return renotifyInterval_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : renotifyInterval_;
          } else {
            return renotifyIntervalBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The frequency at which to send reminder notifications for open
         * incidents.
         * </pre>
         *
         * <code>.google.protobuf.Duration renotify_interval = 2;</code>
         */
        public Builder setRenotifyInterval(com.google.protobuf.Duration value) {
          if (renotifyIntervalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            renotifyInterval_ = value;
          } else {
            renotifyIntervalBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The frequency at which to send reminder notifications for open
         * incidents.
         * </pre>
         *
         * <code>.google.protobuf.Duration renotify_interval = 2;</code>
         */
        public Builder setRenotifyInterval(com.google.protobuf.Duration.Builder builderForValue) {
          if (renotifyIntervalBuilder_ == null) {
            renotifyInterval_ = builderForValue.build();
          } else {
            renotifyIntervalBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The frequency at which to send reminder notifications for open
         * incidents.
         * </pre>
         *
         * <code>.google.protobuf.Duration renotify_interval = 2;</code>
         */
        public Builder mergeRenotifyInterval(com.google.protobuf.Duration value) {
          if (renotifyIntervalBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && renotifyInterval_ != null
                && renotifyInterval_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getRenotifyIntervalBuilder().mergeFrom(value);
            } else {
              renotifyInterval_ = value;
            }
          } else {
            renotifyIntervalBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The frequency at which to send reminder notifications for open
         * incidents.
         * </pre>
         *
         * <code>.google.protobuf.Duration renotify_interval = 2;</code>
         */
        public Builder clearRenotifyInterval() {
          bitField0_ = (bitField0_ & ~0x00000002);
          renotifyInterval_ = null;
          if (renotifyIntervalBuilder_ != null) {
            renotifyIntervalBuilder_.dispose();
            renotifyIntervalBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The frequency at which to send reminder notifications for open
         * incidents.
         * </pre>
         *
         * <code>.google.protobuf.Duration renotify_interval = 2;</code>
         */
        public com.google.protobuf.Duration.Builder getRenotifyIntervalBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getRenotifyIntervalFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The frequency at which to send reminder notifications for open
         * incidents.
         * </pre>
         *
         * <code>.google.protobuf.Duration renotify_interval = 2;</code>
         */
        public com.google.protobuf.DurationOrBuilder getRenotifyIntervalOrBuilder() {
          if (renotifyIntervalBuilder_ != null) {
            return renotifyIntervalBuilder_.getMessageOrBuilder();
          } else {
            return renotifyInterval_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : renotifyInterval_;
          }
        }
        /**
         *
         *
         * <pre>
         * The frequency at which to send reminder notifications for open
         * incidents.
         * </pre>
         *
         * <code>.google.protobuf.Duration renotify_interval = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getRenotifyIntervalFieldBuilder() {
          if (renotifyIntervalBuilder_ == null) {
            renotifyIntervalBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getRenotifyInterval(), getParentForChildren(), isClean());
            renotifyInterval_ = null;
          }
          return renotifyIntervalBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy)
      private static final com.google.monitoring.v3.AlertPolicy.AlertStrategy
              .NotificationChannelStrategy
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy();
      }

      public static com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<NotificationChannelStrategy> PARSER =
          new com.google.protobuf.AbstractParser<NotificationChannelStrategy>() {
            @java.lang.Override
            public NotificationChannelStrategy parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<NotificationChannelStrategy> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<NotificationChannelStrategy> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int NOTIFICATION_RATE_LIMIT_FIELD_NUMBER = 1;
    private com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
        notificationRateLimit_;
    /**
     *
     *
     * <pre>
     * Required for alert policies with a `LogMatch` condition.
     *
     * This limit is not implemented for alert policies that are not log-based.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
     * </code>
     *
     * @return Whether the notificationRateLimit field is set.
     */
    @java.lang.Override
    public boolean hasNotificationRateLimit() {
      return notificationRateLimit_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required for alert policies with a `LogMatch` condition.
     *
     * This limit is not implemented for alert policies that are not log-based.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
     * </code>
     *
     * @return The notificationRateLimit.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
        getNotificationRateLimit() {
      return notificationRateLimit_ == null
          ? com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
              .getDefaultInstance()
          : notificationRateLimit_;
    }
    /**
     *
     *
     * <pre>
     * Required for alert policies with a `LogMatch` condition.
     *
     * This limit is not implemented for alert policies that are not log-based.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimitOrBuilder
        getNotificationRateLimitOrBuilder() {
      return notificationRateLimit_ == null
          ? com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
              .getDefaultInstance()
          : notificationRateLimit_;
    }

    public static final int AUTO_CLOSE_FIELD_NUMBER = 3;
    private com.google.protobuf.Duration autoClose_;
    /**
     *
     *
     * <pre>
     * If an alert policy that was active has no data for this long, any open
     * incidents will close
     * </pre>
     *
     * <code>.google.protobuf.Duration auto_close = 3;</code>
     *
     * @return Whether the autoClose field is set.
     */
    @java.lang.Override
    public boolean hasAutoClose() {
      return autoClose_ != null;
    }
    /**
     *
     *
     * <pre>
     * If an alert policy that was active has no data for this long, any open
     * incidents will close
     * </pre>
     *
     * <code>.google.protobuf.Duration auto_close = 3;</code>
     *
     * @return The autoClose.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getAutoClose() {
      return autoClose_ == null ? com.google.protobuf.Duration.getDefaultInstance() : autoClose_;
    }
    /**
     *
     *
     * <pre>
     * If an alert policy that was active has no data for this long, any open
     * incidents will close
     * </pre>
     *
     * <code>.google.protobuf.Duration auto_close = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getAutoCloseOrBuilder() {
      return autoClose_ == null ? com.google.protobuf.Duration.getDefaultInstance() : autoClose_;
    }

    public static final int NOTIFICATION_CHANNEL_STRATEGY_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy>
        notificationChannelStrategy_;
    /**
     *
     *
     * <pre>
     * Control how notifications will be sent out, on a per-channel basis.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy>
        getNotificationChannelStrategyList() {
      return notificationChannelStrategy_;
    }
    /**
     *
     *
     * <pre>
     * Control how notifications will be sent out, on a per-channel basis.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.monitoring.v3.AlertPolicy.AlertStrategy
                    .NotificationChannelStrategyOrBuilder>
        getNotificationChannelStrategyOrBuilderList() {
      return notificationChannelStrategy_;
    }
    /**
     *
     *
     * <pre>
     * Control how notifications will be sent out, on a per-channel basis.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
     * </code>
     */
    @java.lang.Override
    public int getNotificationChannelStrategyCount() {
      return notificationChannelStrategy_.size();
    }
    /**
     *
     *
     * <pre>
     * Control how notifications will be sent out, on a per-channel basis.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
        getNotificationChannelStrategy(int index) {
      return notificationChannelStrategy_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Control how notifications will be sent out, on a per-channel basis.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategyOrBuilder
        getNotificationChannelStrategyOrBuilder(int index) {
      return notificationChannelStrategy_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (notificationRateLimit_ != null) {
        output.writeMessage(1, getNotificationRateLimit());
      }
      if (autoClose_ != null) {
        output.writeMessage(3, getAutoClose());
      }
      for (int i = 0; i < notificationChannelStrategy_.size(); i++) {
        output.writeMessage(4, notificationChannelStrategy_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (notificationRateLimit_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, getNotificationRateLimit());
      }
      if (autoClose_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAutoClose());
      }
      for (int i = 0; i < notificationChannelStrategy_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, notificationChannelStrategy_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.AlertPolicy.AlertStrategy)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.AlertPolicy.AlertStrategy other =
          (com.google.monitoring.v3.AlertPolicy.AlertStrategy) obj;

      if (hasNotificationRateLimit() != other.hasNotificationRateLimit()) return false;
      if (hasNotificationRateLimit()) {
        if (!getNotificationRateLimit().equals(other.getNotificationRateLimit())) return false;
      }
      if (hasAutoClose() != other.hasAutoClose()) return false;
      if (hasAutoClose()) {
        if (!getAutoClose().equals(other.getAutoClose())) return false;
      }
      if (!getNotificationChannelStrategyList().equals(other.getNotificationChannelStrategyList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasNotificationRateLimit()) {
        hash = (37 * hash) + NOTIFICATION_RATE_LIMIT_FIELD_NUMBER;
        hash = (53 * hash) + getNotificationRateLimit().hashCode();
      }
      if (hasAutoClose()) {
        hash = (37 * hash) + AUTO_CLOSE_FIELD_NUMBER;
        hash = (53 * hash) + getAutoClose().hashCode();
      }
      if (getNotificationChannelStrategyCount() > 0) {
        hash = (37 * hash) + NOTIFICATION_CHANNEL_STRATEGY_FIELD_NUMBER;
        hash = (53 * hash) + getNotificationChannelStrategyList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.AlertPolicy.AlertStrategy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Control over how the notification channels in `notification_channels`
     * are notified when this alert fires.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.AlertPolicy.AlertStrategy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy.AlertStrategy)
        com.google.monitoring.v3.AlertPolicy.AlertStrategyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.AlertPolicy.AlertStrategy.class,
                com.google.monitoring.v3.AlertPolicy.AlertStrategy.Builder.class);
      }

      // Construct using com.google.monitoring.v3.AlertPolicy.AlertStrategy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        notificationRateLimit_ = null;
        if (notificationRateLimitBuilder_ != null) {
          notificationRateLimitBuilder_.dispose();
          notificationRateLimitBuilder_ = null;
        }
        autoClose_ = null;
        if (autoCloseBuilder_ != null) {
          autoCloseBuilder_.dispose();
          autoCloseBuilder_ = null;
        }
        if (notificationChannelStrategyBuilder_ == null) {
          notificationChannelStrategy_ = java.util.Collections.emptyList();
        } else {
          notificationChannelStrategy_ = null;
          notificationChannelStrategyBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.AlertProto
            .internal_static_google_monitoring_v3_AlertPolicy_AlertStrategy_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy getDefaultInstanceForType() {
        return com.google.monitoring.v3.AlertPolicy.AlertStrategy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy build() {
        com.google.monitoring.v3.AlertPolicy.AlertStrategy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy buildPartial() {
        com.google.monitoring.v3.AlertPolicy.AlertStrategy result =
            new com.google.monitoring.v3.AlertPolicy.AlertStrategy(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.monitoring.v3.AlertPolicy.AlertStrategy result) {
        if (notificationChannelStrategyBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            notificationChannelStrategy_ =
                java.util.Collections.unmodifiableList(notificationChannelStrategy_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.notificationChannelStrategy_ = notificationChannelStrategy_;
        } else {
          result.notificationChannelStrategy_ = notificationChannelStrategyBuilder_.build();
        }
      }

      private void buildPartial0(com.google.monitoring.v3.AlertPolicy.AlertStrategy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.notificationRateLimit_ =
              notificationRateLimitBuilder_ == null
                  ? notificationRateLimit_
                  : notificationRateLimitBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.autoClose_ = autoCloseBuilder_ == null ? autoClose_ : autoCloseBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.AlertPolicy.AlertStrategy) {
          return mergeFrom((com.google.monitoring.v3.AlertPolicy.AlertStrategy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.AlertPolicy.AlertStrategy other) {
        if (other == com.google.monitoring.v3.AlertPolicy.AlertStrategy.getDefaultInstance())
          return this;
        if (other.hasNotificationRateLimit()) {
          mergeNotificationRateLimit(other.getNotificationRateLimit());
        }
        if (other.hasAutoClose()) {
          mergeAutoClose(other.getAutoClose());
        }
        if (notificationChannelStrategyBuilder_ == null) {
          if (!other.notificationChannelStrategy_.isEmpty()) {
            if (notificationChannelStrategy_.isEmpty()) {
              notificationChannelStrategy_ = other.notificationChannelStrategy_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureNotificationChannelStrategyIsMutable();
              notificationChannelStrategy_.addAll(other.notificationChannelStrategy_);
            }
            onChanged();
          }
        } else {
          if (!other.notificationChannelStrategy_.isEmpty()) {
            if (notificationChannelStrategyBuilder_.isEmpty()) {
              notificationChannelStrategyBuilder_.dispose();
              notificationChannelStrategyBuilder_ = null;
              notificationChannelStrategy_ = other.notificationChannelStrategy_;
              bitField0_ = (bitField0_ & ~0x00000004);
              notificationChannelStrategyBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getNotificationChannelStrategyFieldBuilder()
                      : null;
            } else {
              notificationChannelStrategyBuilder_.addAllMessages(
                  other.notificationChannelStrategy_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getNotificationRateLimitFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(getAutoCloseFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              case 34:
                {
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy m =
                      input.readMessage(
                          com.google.monitoring.v3.AlertPolicy.AlertStrategy
                              .NotificationChannelStrategy.parser(),
                          extensionRegistry);
                  if (notificationChannelStrategyBuilder_ == null) {
                    ensureNotificationChannelStrategyIsMutable();
                    notificationChannelStrategy_.add(m);
                  } else {
                    notificationChannelStrategyBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          notificationRateLimit_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit,
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit.Builder,
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimitOrBuilder>
          notificationRateLimitBuilder_;
      /**
       *
       *
       * <pre>
       * Required for alert policies with a `LogMatch` condition.
       *
       * This limit is not implemented for alert policies that are not log-based.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
       * </code>
       *
       * @return Whether the notificationRateLimit field is set.
       */
      public boolean hasNotificationRateLimit() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required for alert policies with a `LogMatch` condition.
       *
       * This limit is not implemented for alert policies that are not log-based.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
       * </code>
       *
       * @return The notificationRateLimit.
       */
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
          getNotificationRateLimit() {
        if (notificationRateLimitBuilder_ == null) {
          return notificationRateLimit_ == null
              ? com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
                  .getDefaultInstance()
              : notificationRateLimit_;
        } else {
          return notificationRateLimitBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required for alert policies with a `LogMatch` condition.
       *
       * This limit is not implemented for alert policies that are not log-based.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
       * </code>
       */
      public Builder setNotificationRateLimit(
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit value) {
        if (notificationRateLimitBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          notificationRateLimit_ = value;
        } else {
          notificationRateLimitBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required for alert policies with a `LogMatch` condition.
       *
       * This limit is not implemented for alert policies that are not log-based.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
       * </code>
       */
      public Builder setNotificationRateLimit(
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit.Builder
              builderForValue) {
        if (notificationRateLimitBuilder_ == null) {
          notificationRateLimit_ = builderForValue.build();
        } else {
          notificationRateLimitBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required for alert policies with a `LogMatch` condition.
       *
       * This limit is not implemented for alert policies that are not log-based.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
       * </code>
       */
      public Builder mergeNotificationRateLimit(
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit value) {
        if (notificationRateLimitBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && notificationRateLimit_ != null
              && notificationRateLimit_
                  != com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
                      .getDefaultInstance()) {
            getNotificationRateLimitBuilder().mergeFrom(value);
          } else {
            notificationRateLimit_ = value;
          }
        } else {
          notificationRateLimitBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required for alert policies with a `LogMatch` condition.
       *
       * This limit is not implemented for alert policies that are not log-based.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
       * </code>
       */
      public Builder clearNotificationRateLimit() {
        bitField0_ = (bitField0_ & ~0x00000001);
        notificationRateLimit_ = null;
        if (notificationRateLimitBuilder_ != null) {
          notificationRateLimitBuilder_.dispose();
          notificationRateLimitBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required for alert policies with a `LogMatch` condition.
       *
       * This limit is not implemented for alert policies that are not log-based.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit.Builder
          getNotificationRateLimitBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getNotificationRateLimitFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required for alert policies with a `LogMatch` condition.
       *
       * This limit is not implemented for alert policies that are not log-based.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimitOrBuilder
          getNotificationRateLimitOrBuilder() {
        if (notificationRateLimitBuilder_ != null) {
          return notificationRateLimitBuilder_.getMessageOrBuilder();
        } else {
          return notificationRateLimit_ == null
              ? com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit
                  .getDefaultInstance()
              : notificationRateLimit_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required for alert policies with a `LogMatch` condition.
       *
       * This limit is not implemented for alert policies that are not log-based.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit notification_rate_limit = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit,
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit.Builder,
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimitOrBuilder>
          getNotificationRateLimitFieldBuilder() {
        if (notificationRateLimitBuilder_ == null) {
          notificationRateLimitBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit,
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationRateLimit.Builder,
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy
                      .NotificationRateLimitOrBuilder>(
                  getNotificationRateLimit(), getParentForChildren(), isClean());
          notificationRateLimit_ = null;
        }
        return notificationRateLimitBuilder_;
      }

      private com.google.protobuf.Duration autoClose_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          autoCloseBuilder_;
      /**
       *
       *
       * <pre>
       * If an alert policy that was active has no data for this long, any open
       * incidents will close
       * </pre>
       *
       * <code>.google.protobuf.Duration auto_close = 3;</code>
       *
       * @return Whether the autoClose field is set.
       */
      public boolean hasAutoClose() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * If an alert policy that was active has no data for this long, any open
       * incidents will close
       * </pre>
       *
       * <code>.google.protobuf.Duration auto_close = 3;</code>
       *
       * @return The autoClose.
       */
      public com.google.protobuf.Duration getAutoClose() {
        if (autoCloseBuilder_ == null) {
          return autoClose_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : autoClose_;
        } else {
          return autoCloseBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If an alert policy that was active has no data for this long, any open
       * incidents will close
       * </pre>
       *
       * <code>.google.protobuf.Duration auto_close = 3;</code>
       */
      public Builder setAutoClose(com.google.protobuf.Duration value) {
        if (autoCloseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          autoClose_ = value;
        } else {
          autoCloseBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If an alert policy that was active has no data for this long, any open
       * incidents will close
       * </pre>
       *
       * <code>.google.protobuf.Duration auto_close = 3;</code>
       */
      public Builder setAutoClose(com.google.protobuf.Duration.Builder builderForValue) {
        if (autoCloseBuilder_ == null) {
          autoClose_ = builderForValue.build();
        } else {
          autoCloseBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If an alert policy that was active has no data for this long, any open
       * incidents will close
       * </pre>
       *
       * <code>.google.protobuf.Duration auto_close = 3;</code>
       */
      public Builder mergeAutoClose(com.google.protobuf.Duration value) {
        if (autoCloseBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && autoClose_ != null
              && autoClose_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getAutoCloseBuilder().mergeFrom(value);
          } else {
            autoClose_ = value;
          }
        } else {
          autoCloseBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If an alert policy that was active has no data for this long, any open
       * incidents will close
       * </pre>
       *
       * <code>.google.protobuf.Duration auto_close = 3;</code>
       */
      public Builder clearAutoClose() {
        bitField0_ = (bitField0_ & ~0x00000002);
        autoClose_ = null;
        if (autoCloseBuilder_ != null) {
          autoCloseBuilder_.dispose();
          autoCloseBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If an alert policy that was active has no data for this long, any open
       * incidents will close
       * </pre>
       *
       * <code>.google.protobuf.Duration auto_close = 3;</code>
       */
      public com.google.protobuf.Duration.Builder getAutoCloseBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getAutoCloseFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If an alert policy that was active has no data for this long, any open
       * incidents will close
       * </pre>
       *
       * <code>.google.protobuf.Duration auto_close = 3;</code>
       */
      public com.google.protobuf.DurationOrBuilder getAutoCloseOrBuilder() {
        if (autoCloseBuilder_ != null) {
          return autoCloseBuilder_.getMessageOrBuilder();
        } else {
          return autoClose_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : autoClose_;
        }
      }
      /**
       *
       *
       * <pre>
       * If an alert policy that was active has no data for this long, any open
       * incidents will close
       * </pre>
       *
       * <code>.google.protobuf.Duration auto_close = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getAutoCloseFieldBuilder() {
        if (autoCloseBuilder_ == null) {
          autoCloseBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getAutoClose(), getParentForChildren(), isClean());
          autoClose_ = null;
        }
        return autoCloseBuilder_;
      }

      private java.util.List<
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy>
          notificationChannelStrategy_ = java.util.Collections.emptyList();

      private void ensureNotificationChannelStrategyIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          notificationChannelStrategy_ =
              new java.util.ArrayList<
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy>(
                  notificationChannelStrategy_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy,
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
                  .Builder,
              com.google.monitoring.v3.AlertPolicy.AlertStrategy
                  .NotificationChannelStrategyOrBuilder>
          notificationChannelStrategyBuilder_;

      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public java.util.List<
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy>
          getNotificationChannelStrategyList() {
        if (notificationChannelStrategyBuilder_ == null) {
          return java.util.Collections.unmodifiableList(notificationChannelStrategy_);
        } else {
          return notificationChannelStrategyBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public int getNotificationChannelStrategyCount() {
        if (notificationChannelStrategyBuilder_ == null) {
          return notificationChannelStrategy_.size();
        } else {
          return notificationChannelStrategyBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
          getNotificationChannelStrategy(int index) {
        if (notificationChannelStrategyBuilder_ == null) {
          return notificationChannelStrategy_.get(index);
        } else {
          return notificationChannelStrategyBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public Builder setNotificationChannelStrategy(
          int index,
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy value) {
        if (notificationChannelStrategyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNotificationChannelStrategyIsMutable();
          notificationChannelStrategy_.set(index, value);
          onChanged();
        } else {
          notificationChannelStrategyBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public Builder setNotificationChannelStrategy(
          int index,
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy.Builder
              builderForValue) {
        if (notificationChannelStrategyBuilder_ == null) {
          ensureNotificationChannelStrategyIsMutable();
          notificationChannelStrategy_.set(index, builderForValue.build());
          onChanged();
        } else {
          notificationChannelStrategyBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public Builder addNotificationChannelStrategy(
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy value) {
        if (notificationChannelStrategyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNotificationChannelStrategyIsMutable();
          notificationChannelStrategy_.add(value);
          onChanged();
        } else {
          notificationChannelStrategyBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public Builder addNotificationChannelStrategy(
          int index,
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy value) {
        if (notificationChannelStrategyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNotificationChannelStrategyIsMutable();
          notificationChannelStrategy_.add(index, value);
          onChanged();
        } else {
          notificationChannelStrategyBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public Builder addNotificationChannelStrategy(
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy.Builder
              builderForValue) {
        if (notificationChannelStrategyBuilder_ == null) {
          ensureNotificationChannelStrategyIsMutable();
          notificationChannelStrategy_.add(builderForValue.build());
          onChanged();
        } else {
          notificationChannelStrategyBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public Builder addNotificationChannelStrategy(
          int index,
          com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy.Builder
              builderForValue) {
        if (notificationChannelStrategyBuilder_ == null) {
          ensureNotificationChannelStrategyIsMutable();
          notificationChannelStrategy_.add(index, builderForValue.build());
          onChanged();
        } else {
          notificationChannelStrategyBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public Builder addAllNotificationChannelStrategy(
          java.lang.Iterable<
                  ? extends
                      com.google.monitoring.v3.AlertPolicy.AlertStrategy
                          .NotificationChannelStrategy>
              values) {
        if (notificationChannelStrategyBuilder_ == null) {
          ensureNotificationChannelStrategyIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, notificationChannelStrategy_);
          onChanged();
        } else {
          notificationChannelStrategyBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public Builder clearNotificationChannelStrategy() {
        if (notificationChannelStrategyBuilder_ == null) {
          notificationChannelStrategy_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          notificationChannelStrategyBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public Builder removeNotificationChannelStrategy(int index) {
        if (notificationChannelStrategyBuilder_ == null) {
          ensureNotificationChannelStrategyIsMutable();
          notificationChannelStrategy_.remove(index);
          onChanged();
        } else {
          notificationChannelStrategyBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy.Builder
          getNotificationChannelStrategyBuilder(int index) {
        return getNotificationChannelStrategyFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategyOrBuilder
          getNotificationChannelStrategyOrBuilder(int index) {
        if (notificationChannelStrategyBuilder_ == null) {
          return notificationChannelStrategy_.get(index);
        } else {
          return notificationChannelStrategyBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy
                      .NotificationChannelStrategyOrBuilder>
          getNotificationChannelStrategyOrBuilderList() {
        if (notificationChannelStrategyBuilder_ != null) {
          return notificationChannelStrategyBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(notificationChannelStrategy_);
        }
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy.Builder
          addNotificationChannelStrategyBuilder() {
        return getNotificationChannelStrategyFieldBuilder()
            .addBuilder(
                com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy.Builder
          addNotificationChannelStrategyBuilder(int index) {
        return getNotificationChannelStrategyFieldBuilder()
            .addBuilder(
                index,
                com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Control how notifications will be sent out, on a per-channel basis.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy notification_channel_strategy = 4;
       * </code>
       */
      public java.util.List<
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
                  .Builder>
          getNotificationChannelStrategyBuilderList() {
        return getNotificationChannelStrategyFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy,
              com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
                  .Builder,
              com.google.monitoring.v3.AlertPolicy.AlertStrategy
                  .NotificationChannelStrategyOrBuilder>
          getNotificationChannelStrategyFieldBuilder() {
        if (notificationChannelStrategyBuilder_ == null) {
          notificationChannelStrategyBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy,
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy.NotificationChannelStrategy
                      .Builder,
                  com.google.monitoring.v3.AlertPolicy.AlertStrategy
                      .NotificationChannelStrategyOrBuilder>(
                  notificationChannelStrategy_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          notificationChannelStrategy_ = null;
        }
        return notificationChannelStrategyBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.AlertPolicy.AlertStrategy)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.AlertPolicy.AlertStrategy)
    private static final com.google.monitoring.v3.AlertPolicy.AlertStrategy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.AlertPolicy.AlertStrategy();
    }

    public static com.google.monitoring.v3.AlertPolicy.AlertStrategy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AlertStrategy> PARSER =
        new com.google.protobuf.AbstractParser<AlertStrategy>() {
          @java.lang.Override
          public AlertStrategy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AlertStrategy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AlertStrategy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.AlertStrategy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required if the policy exists. The resource name for this policy. The
   * format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
   *
   * `[ALERT_POLICY_ID]` is assigned by Cloud Monitoring when the policy
   * is created. When calling the
   * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
   * method, do not include the `name` field in the alerting policy passed as
   * part of the request.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required if the policy exists. The resource name for this policy. The
   * format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
   *
   * `[ALERT_POLICY_ID]` is assigned by Cloud Monitoring when the policy
   * is created. When calling the
   * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
   * method, do not include the `name` field in the alerting policy passed as
   * part of the request.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * A short name or phrase used to identify the policy in dashboards,
   * notifications, and incidents. To avoid confusion, don't use the same
   * display name for multiple policies in the same project. The name is
   * limited to 512 Unicode characters.
   *
   * The convention for the display_name of a PrometheusQueryLanguageCondition
   * is "{rule group name}/{alert name}", where the {rule group name} and
   * {alert name} should be taken from the corresponding Prometheus
   * configuration file. This convention is not enforced.
   * In any case the display_name is not a unique key of the AlertPolicy.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A short name or phrase used to identify the policy in dashboards,
   * notifications, and incidents. To avoid confusion, don't use the same
   * display name for multiple policies in the same project. The name is
   * limited to 512 Unicode characters.
   *
   * The convention for the display_name of a PrometheusQueryLanguageCondition
   * is "{rule group name}/{alert name}", where the {rule group name} and
   * {alert name} should be taken from the corresponding Prometheus
   * configuration file. This convention is not enforced.
   * In any case the display_name is not a unique key of the AlertPolicy.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENTATION_FIELD_NUMBER = 13;
  private com.google.monitoring.v3.AlertPolicy.Documentation documentation_;
  /**
   *
   *
   * <pre>
   * Documentation that is included with notifications and incidents related to
   * this policy. Best practice is for the documentation to include information
   * to help responders understand, mitigate, escalate, and correct the
   * underlying problems detected by the alerting policy. Notification channels
   * that have limited capacity might not show this documentation.
   * </pre>
   *
   * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
   *
   * @return Whether the documentation field is set.
   */
  @java.lang.Override
  public boolean hasDocumentation() {
    return documentation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Documentation that is included with notifications and incidents related to
   * this policy. Best practice is for the documentation to include information
   * to help responders understand, mitigate, escalate, and correct the
   * underlying problems detected by the alerting policy. Notification channels
   * that have limited capacity might not show this documentation.
   * </pre>
   *
   * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
   *
   * @return The documentation.
   */
  @java.lang.Override
  public com.google.monitoring.v3.AlertPolicy.Documentation getDocumentation() {
    return documentation_ == null
        ? com.google.monitoring.v3.AlertPolicy.Documentation.getDefaultInstance()
        : documentation_;
  }
  /**
   *
   *
   * <pre>
   * Documentation that is included with notifications and incidents related to
   * this policy. Best practice is for the documentation to include information
   * to help responders understand, mitigate, escalate, and correct the
   * underlying problems detected by the alerting policy. Notification channels
   * that have limited capacity might not show this documentation.
   * </pre>
   *
   * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.AlertPolicy.DocumentationOrBuilder getDocumentationOrBuilder() {
    return documentation_ == null
        ? com.google.monitoring.v3.AlertPolicy.Documentation.getDefaultInstance()
        : documentation_;
  }

  public static final int USER_LABELS_FIELD_NUMBER = 16;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.monitoring.v3.AlertProto
                .internal_static_google_monitoring_v3_AlertPolicy_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data to be used for organizing and
   * identifying the `AlertPolicy` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   *
   * Note that Prometheus {alert name} is a
   * [valid Prometheus label
   * names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels),
   * whereas Prometheus {rule group} is an unrestricted UTF-8 string.
   * This means that they cannot be stored as-is in user labels, because
   * they may contain characters that are not allowed in user-label values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 16;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data to be used for organizing and
   * identifying the `AlertPolicy` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   *
   * Note that Prometheus {alert name} is a
   * [valid Prometheus label
   * names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels),
   * whereas Prometheus {rule group} is an unrestricted UTF-8 string.
   * This means that they cannot be stored as-is in user labels, because
   * they may contain characters that are not allowed in user-label values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 16;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data to be used for organizing and
   * identifying the `AlertPolicy` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   *
   * Note that Prometheus {alert name} is a
   * [valid Prometheus label
   * names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels),
   * whereas Prometheus {rule group} is an unrestricted UTF-8 string.
   * This means that they cannot be stored as-is in user labels, because
   * they may contain characters that are not allowed in user-label values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 16;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User-supplied key/value data to be used for organizing and
   * identifying the `AlertPolicy` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   *
   * Note that Prometheus {alert name} is a
   * [valid Prometheus label
   * names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels),
   * whereas Prometheus {rule group} is an unrestricted UTF-8 string.
   * This means that they cannot be stored as-is in user labels, because
   * they may contain characters that are not allowed in user-label values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 16;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CONDITIONS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.monitoring.v3.AlertPolicy.Condition> conditions_;
  /**
   *
   *
   * <pre>
   * A list of conditions for the policy. The conditions are combined by AND or
   * OR according to the `combiner` field. If the combined conditions evaluate
   * to true, then an incident is created. A policy can have from one to six
   * conditions.
   * If `condition_time_series_query_language` is present, it must be the only
   * `condition`.
   * If `condition_monitoring_query_language` is present, it must be the only
   * `condition`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.AlertPolicy.Condition> getConditionsList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * A list of conditions for the policy. The conditions are combined by AND or
   * OR according to the `combiner` field. If the combined conditions evaluate
   * to true, then an incident is created. A policy can have from one to six
   * conditions.
   * If `condition_time_series_query_language` is present, it must be the only
   * `condition`.
   * If `condition_monitoring_query_language` is present, it must be the only
   * `condition`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.monitoring.v3.AlertPolicy.ConditionOrBuilder>
      getConditionsOrBuilderList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * A list of conditions for the policy. The conditions are combined by AND or
   * OR according to the `combiner` field. If the combined conditions evaluate
   * to true, then an incident is created. A policy can have from one to six
   * conditions.
   * If `condition_time_series_query_language` is present, it must be the only
   * `condition`.
   * If `condition_monitoring_query_language` is present, it must be the only
   * `condition`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
   */
  @java.lang.Override
  public int getConditionsCount() {
    return conditions_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of conditions for the policy. The conditions are combined by AND or
   * OR according to the `combiner` field. If the combined conditions evaluate
   * to true, then an incident is created. A policy can have from one to six
   * conditions.
   * If `condition_time_series_query_language` is present, it must be the only
   * `condition`.
   * If `condition_monitoring_query_language` is present, it must be the only
   * `condition`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.AlertPolicy.Condition getConditions(int index) {
    return conditions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of conditions for the policy. The conditions are combined by AND or
   * OR according to the `combiner` field. If the combined conditions evaluate
   * to true, then an incident is created. A policy can have from one to six
   * conditions.
   * If `condition_time_series_query_language` is present, it must be the only
   * `condition`.
   * If `condition_monitoring_query_language` is present, it must be the only
   * `condition`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.AlertPolicy.ConditionOrBuilder getConditionsOrBuilder(int index) {
    return conditions_.get(index);
  }

  public static final int COMBINER_FIELD_NUMBER = 6;
  private int combiner_ = 0;
  /**
   *
   *
   * <pre>
   * How to combine the results of multiple conditions to determine if an
   * incident should be opened.
   * If `condition_time_series_query_language` is present, this must be
   * `COMBINE_UNSPECIFIED`.
   * </pre>
   *
   * <code>.google.monitoring.v3.AlertPolicy.ConditionCombinerType combiner = 6;</code>
   *
   * @return The enum numeric value on the wire for combiner.
   */
  @java.lang.Override
  public int getCombinerValue() {
    return combiner_;
  }
  /**
   *
   *
   * <pre>
   * How to combine the results of multiple conditions to determine if an
   * incident should be opened.
   * If `condition_time_series_query_language` is present, this must be
   * `COMBINE_UNSPECIFIED`.
   * </pre>
   *
   * <code>.google.monitoring.v3.AlertPolicy.ConditionCombinerType combiner = 6;</code>
   *
   * @return The combiner.
   */
  @java.lang.Override
  public com.google.monitoring.v3.AlertPolicy.ConditionCombinerType getCombiner() {
    com.google.monitoring.v3.AlertPolicy.ConditionCombinerType result =
        com.google.monitoring.v3.AlertPolicy.ConditionCombinerType.forNumber(combiner_);
    return result == null
        ? com.google.monitoring.v3.AlertPolicy.ConditionCombinerType.UNRECOGNIZED
        : result;
  }

  public static final int ENABLED_FIELD_NUMBER = 17;
  private com.google.protobuf.BoolValue enabled_;
  /**
   *
   *
   * <pre>
   * Whether or not the policy is enabled. On write, the default interpretation
   * if unset is that the policy is enabled. On read, clients should not make
   * any assumption about the state if it has not been populated. The
   * field should always be populated on List and Get operations, unless
   * a field projection has been specified that strips it out.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enabled = 17;</code>
   *
   * @return Whether the enabled field is set.
   */
  @java.lang.Override
  public boolean hasEnabled() {
    return enabled_ != null;
  }
  /**
   *
   *
   * <pre>
   * Whether or not the policy is enabled. On write, the default interpretation
   * if unset is that the policy is enabled. On read, clients should not make
   * any assumption about the state if it has not been populated. The
   * field should always be populated on List and Get operations, unless
   * a field projection has been specified that strips it out.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enabled = 17;</code>
   *
   * @return The enabled.
   */
  @java.lang.Override
  public com.google.protobuf.BoolValue getEnabled() {
    return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
  }
  /**
   *
   *
   * <pre>
   * Whether or not the policy is enabled. On write, the default interpretation
   * if unset is that the policy is enabled. On read, clients should not make
   * any assumption about the state if it has not been populated. The
   * field should always be populated on List and Get operations, unless
   * a field projection has been specified that strips it out.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enabled = 17;</code>
   */
  @java.lang.Override
  public com.google.protobuf.BoolValueOrBuilder getEnabledOrBuilder() {
    return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
  }

  public static final int VALIDITY_FIELD_NUMBER = 18;
  private com.google.rpc.Status validity_;
  /**
   *
   *
   * <pre>
   * Read-only description of how the alert policy is invalid. This field is
   * only set when the alert policy is invalid. An invalid alert policy will not
   * generate incidents.
   * </pre>
   *
   * <code>.google.rpc.Status validity = 18;</code>
   *
   * @return Whether the validity field is set.
   */
  @java.lang.Override
  public boolean hasValidity() {
    return validity_ != null;
  }
  /**
   *
   *
   * <pre>
   * Read-only description of how the alert policy is invalid. This field is
   * only set when the alert policy is invalid. An invalid alert policy will not
   * generate incidents.
   * </pre>
   *
   * <code>.google.rpc.Status validity = 18;</code>
   *
   * @return The validity.
   */
  @java.lang.Override
  public com.google.rpc.Status getValidity() {
    return validity_ == null ? com.google.rpc.Status.getDefaultInstance() : validity_;
  }
  /**
   *
   *
   * <pre>
   * Read-only description of how the alert policy is invalid. This field is
   * only set when the alert policy is invalid. An invalid alert policy will not
   * generate incidents.
   * </pre>
   *
   * <code>.google.rpc.Status validity = 18;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getValidityOrBuilder() {
    return validity_ == null ? com.google.rpc.Status.getDefaultInstance() : validity_;
  }

  public static final int NOTIFICATION_CHANNELS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList notificationChannels_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Identifies the notification channels to which notifications should be sent
   * when incidents are opened or closed or when new violations occur on
   * an already opened incident. Each element of this array corresponds to
   * the `name` field in each of the
   * [`NotificationChannel`][google.monitoring.v3.NotificationChannel]
   * objects that are returned from the [`ListNotificationChannels`]
   * [google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
   * method. The format of the entries in this field is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
   * </pre>
   *
   * <code>repeated string notification_channels = 14;</code>
   *
   * @return A list containing the notificationChannels.
   */
  public com.google.protobuf.ProtocolStringList getNotificationChannelsList() {
    return notificationChannels_;
  }
  /**
   *
   *
   * <pre>
   * Identifies the notification channels to which notifications should be sent
   * when incidents are opened or closed or when new violations occur on
   * an already opened incident. Each element of this array corresponds to
   * the `name` field in each of the
   * [`NotificationChannel`][google.monitoring.v3.NotificationChannel]
   * objects that are returned from the [`ListNotificationChannels`]
   * [google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
   * method. The format of the entries in this field is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
   * </pre>
   *
   * <code>repeated string notification_channels = 14;</code>
   *
   * @return The count of notificationChannels.
   */
  public int getNotificationChannelsCount() {
    return notificationChannels_.size();
  }
  /**
   *
   *
   * <pre>
   * Identifies the notification channels to which notifications should be sent
   * when incidents are opened or closed or when new violations occur on
   * an already opened incident. Each element of this array corresponds to
   * the `name` field in each of the
   * [`NotificationChannel`][google.monitoring.v3.NotificationChannel]
   * objects that are returned from the [`ListNotificationChannels`]
   * [google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
   * method. The format of the entries in this field is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
   * </pre>
   *
   * <code>repeated string notification_channels = 14;</code>
   *
   * @param index The index of the element to return.
   * @return The notificationChannels at the given index.
   */
  public java.lang.String getNotificationChannels(int index) {
    return notificationChannels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Identifies the notification channels to which notifications should be sent
   * when incidents are opened or closed or when new violations occur on
   * an already opened incident. Each element of this array corresponds to
   * the `name` field in each of the
   * [`NotificationChannel`][google.monitoring.v3.NotificationChannel]
   * objects that are returned from the [`ListNotificationChannels`]
   * [google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
   * method. The format of the entries in this field is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
   * </pre>
   *
   * <code>repeated string notification_channels = 14;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the notificationChannels at the given index.
   */
  public com.google.protobuf.ByteString getNotificationChannelsBytes(int index) {
    return notificationChannels_.getByteString(index);
  }

  public static final int CREATION_RECORD_FIELD_NUMBER = 10;
  private com.google.monitoring.v3.MutationRecord creationRecord_;
  /**
   *
   *
   * <pre>
   * A read-only record of the creation of the alerting policy. If provided
   * in a call to create or update, this field will be ignored.
   * </pre>
   *
   * <code>.google.monitoring.v3.MutationRecord creation_record = 10;</code>
   *
   * @return Whether the creationRecord field is set.
   */
  @java.lang.Override
  public boolean hasCreationRecord() {
    return creationRecord_ != null;
  }
  /**
   *
   *
   * <pre>
   * A read-only record of the creation of the alerting policy. If provided
   * in a call to create or update, this field will be ignored.
   * </pre>
   *
   * <code>.google.monitoring.v3.MutationRecord creation_record = 10;</code>
   *
   * @return The creationRecord.
   */
  @java.lang.Override
  public com.google.monitoring.v3.MutationRecord getCreationRecord() {
    return creationRecord_ == null
        ? com.google.monitoring.v3.MutationRecord.getDefaultInstance()
        : creationRecord_;
  }
  /**
   *
   *
   * <pre>
   * A read-only record of the creation of the alerting policy. If provided
   * in a call to create or update, this field will be ignored.
   * </pre>
   *
   * <code>.google.monitoring.v3.MutationRecord creation_record = 10;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.MutationRecordOrBuilder getCreationRecordOrBuilder() {
    return creationRecord_ == null
        ? com.google.monitoring.v3.MutationRecord.getDefaultInstance()
        : creationRecord_;
  }

  public static final int MUTATION_RECORD_FIELD_NUMBER = 11;
  private com.google.monitoring.v3.MutationRecord mutationRecord_;
  /**
   *
   *
   * <pre>
   * A read-only record of the most recent change to the alerting policy. If
   * provided in a call to create or update, this field will be ignored.
   * </pre>
   *
   * <code>.google.monitoring.v3.MutationRecord mutation_record = 11;</code>
   *
   * @return Whether the mutationRecord field is set.
   */
  @java.lang.Override
  public boolean hasMutationRecord() {
    return mutationRecord_ != null;
  }
  /**
   *
   *
   * <pre>
   * A read-only record of the most recent change to the alerting policy. If
   * provided in a call to create or update, this field will be ignored.
   * </pre>
   *
   * <code>.google.monitoring.v3.MutationRecord mutation_record = 11;</code>
   *
   * @return The mutationRecord.
   */
  @java.lang.Override
  public com.google.monitoring.v3.MutationRecord getMutationRecord() {
    return mutationRecord_ == null
        ? com.google.monitoring.v3.MutationRecord.getDefaultInstance()
        : mutationRecord_;
  }
  /**
   *
   *
   * <pre>
   * A read-only record of the most recent change to the alerting policy. If
   * provided in a call to create or update, this field will be ignored.
   * </pre>
   *
   * <code>.google.monitoring.v3.MutationRecord mutation_record = 11;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.MutationRecordOrBuilder getMutationRecordOrBuilder() {
    return mutationRecord_ == null
        ? com.google.monitoring.v3.MutationRecord.getDefaultInstance()
        : mutationRecord_;
  }

  public static final int ALERT_STRATEGY_FIELD_NUMBER = 21;
  private com.google.monitoring.v3.AlertPolicy.AlertStrategy alertStrategy_;
  /**
   *
   *
   * <pre>
   * Control over how this alert policy's notification channels are notified.
   * </pre>
   *
   * <code>.google.monitoring.v3.AlertPolicy.AlertStrategy alert_strategy = 21;</code>
   *
   * @return Whether the alertStrategy field is set.
   */
  @java.lang.Override
  public boolean hasAlertStrategy() {
    return alertStrategy_ != null;
  }
  /**
   *
   *
   * <pre>
   * Control over how this alert policy's notification channels are notified.
   * </pre>
   *
   * <code>.google.monitoring.v3.AlertPolicy.AlertStrategy alert_strategy = 21;</code>
   *
   * @return The alertStrategy.
   */
  @java.lang.Override
  public com.google.monitoring.v3.AlertPolicy.AlertStrategy getAlertStrategy() {
    return alertStrategy_ == null
        ? com.google.monitoring.v3.AlertPolicy.AlertStrategy.getDefaultInstance()
        : alertStrategy_;
  }
  /**
   *
   *
   * <pre>
   * Control over how this alert policy's notification channels are notified.
   * </pre>
   *
   * <code>.google.monitoring.v3.AlertPolicy.AlertStrategy alert_strategy = 21;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.AlertPolicy.AlertStrategyOrBuilder getAlertStrategyOrBuilder() {
    return alertStrategy_ == null
        ? com.google.monitoring.v3.AlertPolicy.AlertStrategy.getDefaultInstance()
        : alertStrategy_;
  }

  public static final int SEVERITY_FIELD_NUMBER = 22;
  private int severity_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The severity of an alert policy indicates how important incidents
   * generated by that policy are. The severity level will be displayed on the
   * Incident detail page and in notifications.
   * </pre>
   *
   * <code>
   * .google.monitoring.v3.AlertPolicy.Severity severity = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  @java.lang.Override
  public int getSeverityValue() {
    return severity_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The severity of an alert policy indicates how important incidents
   * generated by that policy are. The severity level will be displayed on the
   * Incident detail page and in notifications.
   * </pre>
   *
   * <code>
   * .google.monitoring.v3.AlertPolicy.Severity severity = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The severity.
   */
  @java.lang.Override
  public com.google.monitoring.v3.AlertPolicy.Severity getSeverity() {
    com.google.monitoring.v3.AlertPolicy.Severity result =
        com.google.monitoring.v3.AlertPolicy.Severity.forNumber(severity_);
    return result == null ? com.google.monitoring.v3.AlertPolicy.Severity.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (combiner_
        != com.google.monitoring.v3.AlertPolicy.ConditionCombinerType.COMBINE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, combiner_);
    }
    if (creationRecord_ != null) {
      output.writeMessage(10, getCreationRecord());
    }
    if (mutationRecord_ != null) {
      output.writeMessage(11, getMutationRecord());
    }
    for (int i = 0; i < conditions_.size(); i++) {
      output.writeMessage(12, conditions_.get(i));
    }
    if (documentation_ != null) {
      output.writeMessage(13, getDocumentation());
    }
    for (int i = 0; i < notificationChannels_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 14, notificationChannels_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 16);
    if (enabled_ != null) {
      output.writeMessage(17, getEnabled());
    }
    if (validity_ != null) {
      output.writeMessage(18, getValidity());
    }
    if (alertStrategy_ != null) {
      output.writeMessage(21, getAlertStrategy());
    }
    if (severity_
        != com.google.monitoring.v3.AlertPolicy.Severity.SEVERITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(22, severity_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (combiner_
        != com.google.monitoring.v3.AlertPolicy.ConditionCombinerType.COMBINE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, combiner_);
    }
    if (creationRecord_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCreationRecord());
    }
    if (mutationRecord_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getMutationRecord());
    }
    for (int i = 0; i < conditions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, conditions_.get(i));
    }
    if (documentation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getDocumentation());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < notificationChannels_.size(); i++) {
        dataSize += computeStringSizeNoTag(notificationChannels_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNotificationChannelsList().size();
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, userLabels__);
    }
    if (enabled_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getEnabled());
    }
    if (validity_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getValidity());
    }
    if (alertStrategy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getAlertStrategy());
    }
    if (severity_
        != com.google.monitoring.v3.AlertPolicy.Severity.SEVERITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(22, severity_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.AlertPolicy)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.AlertPolicy other = (com.google.monitoring.v3.AlertPolicy) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasDocumentation() != other.hasDocumentation()) return false;
    if (hasDocumentation()) {
      if (!getDocumentation().equals(other.getDocumentation())) return false;
    }
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (combiner_ != other.combiner_) return false;
    if (hasEnabled() != other.hasEnabled()) return false;
    if (hasEnabled()) {
      if (!getEnabled().equals(other.getEnabled())) return false;
    }
    if (hasValidity() != other.hasValidity()) return false;
    if (hasValidity()) {
      if (!getValidity().equals(other.getValidity())) return false;
    }
    if (!getNotificationChannelsList().equals(other.getNotificationChannelsList())) return false;
    if (hasCreationRecord() != other.hasCreationRecord()) return false;
    if (hasCreationRecord()) {
      if (!getCreationRecord().equals(other.getCreationRecord())) return false;
    }
    if (hasMutationRecord() != other.hasMutationRecord()) return false;
    if (hasMutationRecord()) {
      if (!getMutationRecord().equals(other.getMutationRecord())) return false;
    }
    if (hasAlertStrategy() != other.hasAlertStrategy()) return false;
    if (hasAlertStrategy()) {
      if (!getAlertStrategy().equals(other.getAlertStrategy())) return false;
    }
    if (severity_ != other.severity_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasDocumentation()) {
      hash = (37 * hash) + DOCUMENTATION_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentation().hashCode();
    }
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    hash = (37 * hash) + COMBINER_FIELD_NUMBER;
    hash = (53 * hash) + combiner_;
    if (hasEnabled()) {
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + getEnabled().hashCode();
    }
    if (hasValidity()) {
      hash = (37 * hash) + VALIDITY_FIELD_NUMBER;
      hash = (53 * hash) + getValidity().hashCode();
    }
    if (getNotificationChannelsCount() > 0) {
      hash = (37 * hash) + NOTIFICATION_CHANNELS_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationChannelsList().hashCode();
    }
    if (hasCreationRecord()) {
      hash = (37 * hash) + CREATION_RECORD_FIELD_NUMBER;
      hash = (53 * hash) + getCreationRecord().hashCode();
    }
    if (hasMutationRecord()) {
      hash = (37 * hash) + MUTATION_RECORD_FIELD_NUMBER;
      hash = (53 * hash) + getMutationRecord().hashCode();
    }
    if (hasAlertStrategy()) {
      hash = (37 * hash) + ALERT_STRATEGY_FIELD_NUMBER;
      hash = (53 * hash) + getAlertStrategy().hashCode();
    }
    hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
    hash = (53 * hash) + severity_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.AlertPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.AlertPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.AlertPolicy parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.AlertPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.AlertPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.AlertPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.AlertPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.AlertPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.AlertPolicy parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.AlertPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.AlertPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.AlertPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.AlertPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A description of the conditions under which some aspect of your system is
   * considered to be "unhealthy" and the ways to notify people or services about
   * this state. For an overview of alert policies, see
   * [Introduction to Alerting](https://cloud.google.com/monitoring/alerts/).
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.AlertPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.AlertPolicy)
      com.google.monitoring.v3.AlertPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 16:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 16:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.AlertPolicy.class,
              com.google.monitoring.v3.AlertPolicy.Builder.class);
    }

    // Construct using com.google.monitoring.v3.AlertPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      documentation_ = null;
      if (documentationBuilder_ != null) {
        documentationBuilder_.dispose();
        documentationBuilder_ = null;
      }
      internalGetMutableUserLabels().clear();
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
      } else {
        conditions_ = null;
        conditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      combiner_ = 0;
      enabled_ = null;
      if (enabledBuilder_ != null) {
        enabledBuilder_.dispose();
        enabledBuilder_ = null;
      }
      validity_ = null;
      if (validityBuilder_ != null) {
        validityBuilder_.dispose();
        validityBuilder_ = null;
      }
      notificationChannels_ = com.google.protobuf.LazyStringArrayList.emptyList();
      creationRecord_ = null;
      if (creationRecordBuilder_ != null) {
        creationRecordBuilder_.dispose();
        creationRecordBuilder_ = null;
      }
      mutationRecord_ = null;
      if (mutationRecordBuilder_ != null) {
        mutationRecordBuilder_.dispose();
        mutationRecordBuilder_ = null;
      }
      alertStrategy_ = null;
      if (alertStrategyBuilder_ != null) {
        alertStrategyBuilder_.dispose();
        alertStrategyBuilder_ = null;
      }
      severity_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.AlertProto
          .internal_static_google_monitoring_v3_AlertPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy getDefaultInstanceForType() {
      return com.google.monitoring.v3.AlertPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy build() {
      com.google.monitoring.v3.AlertPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy buildPartial() {
      com.google.monitoring.v3.AlertPolicy result = new com.google.monitoring.v3.AlertPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.monitoring.v3.AlertPolicy result) {
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.conditions_ = conditions_;
      } else {
        result.conditions_ = conditionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.monitoring.v3.AlertPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.documentation_ =
            documentationBuilder_ == null ? documentation_ : documentationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.combiner_ = combiner_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.enabled_ = enabledBuilder_ == null ? enabled_ : enabledBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.validity_ = validityBuilder_ == null ? validity_ : validityBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        notificationChannels_.makeImmutable();
        result.notificationChannels_ = notificationChannels_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.creationRecord_ =
            creationRecordBuilder_ == null ? creationRecord_ : creationRecordBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.mutationRecord_ =
            mutationRecordBuilder_ == null ? mutationRecord_ : mutationRecordBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.alertStrategy_ =
            alertStrategyBuilder_ == null ? alertStrategy_ : alertStrategyBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.severity_ = severity_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.AlertPolicy) {
        return mergeFrom((com.google.monitoring.v3.AlertPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.AlertPolicy other) {
      if (other == com.google.monitoring.v3.AlertPolicy.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDocumentation()) {
        mergeDocumentation(other.getDocumentation());
      }
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00000008;
      if (conditionsBuilder_ == null) {
        if (!other.conditions_.isEmpty()) {
          if (conditions_.isEmpty()) {
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureConditionsIsMutable();
            conditions_.addAll(other.conditions_);
          }
          onChanged();
        }
      } else {
        if (!other.conditions_.isEmpty()) {
          if (conditionsBuilder_.isEmpty()) {
            conditionsBuilder_.dispose();
            conditionsBuilder_ = null;
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00000010);
            conditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionsFieldBuilder()
                    : null;
          } else {
            conditionsBuilder_.addAllMessages(other.conditions_);
          }
        }
      }
      if (other.combiner_ != 0) {
        setCombinerValue(other.getCombinerValue());
      }
      if (other.hasEnabled()) {
        mergeEnabled(other.getEnabled());
      }
      if (other.hasValidity()) {
        mergeValidity(other.getValidity());
      }
      if (!other.notificationChannels_.isEmpty()) {
        if (notificationChannels_.isEmpty()) {
          notificationChannels_ = other.notificationChannels_;
          bitField0_ |= 0x00000100;
        } else {
          ensureNotificationChannelsIsMutable();
          notificationChannels_.addAll(other.notificationChannels_);
        }
        onChanged();
      }
      if (other.hasCreationRecord()) {
        mergeCreationRecord(other.getCreationRecord());
      }
      if (other.hasMutationRecord()) {
        mergeMutationRecord(other.getMutationRecord());
      }
      if (other.hasAlertStrategy()) {
        mergeAlertStrategy(other.getAlertStrategy());
      }
      if (other.severity_ != 0) {
        setSeverityValue(other.getSeverityValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 48:
              {
                combiner_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 82:
              {
                input.readMessage(getCreationRecordFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getMutationRecordFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                com.google.monitoring.v3.AlertPolicy.Condition m =
                    input.readMessage(
                        com.google.monitoring.v3.AlertPolicy.Condition.parser(), extensionRegistry);
                if (conditionsBuilder_ == null) {
                  ensureConditionsIsMutable();
                  conditions_.add(m);
                } else {
                  conditionsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getDocumentationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 106
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNotificationChannelsIsMutable();
                notificationChannels_.add(s);
                break;
              } // case 114
            case 130:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                    input.readMessage(
                        UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableUserLabels()
                    .getMutableMap()
                    .put(userLabels__.getKey(), userLabels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getEnabledFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getValidityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 146
            case 170:
              {
                input.readMessage(getAlertStrategyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 170
            case 176:
              {
                severity_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 176
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required if the policy exists. The resource name for this policy. The
     * format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
     *
     * `[ALERT_POLICY_ID]` is assigned by Cloud Monitoring when the policy
     * is created. When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the alerting policy passed as
     * part of the request.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required if the policy exists. The resource name for this policy. The
     * format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
     *
     * `[ALERT_POLICY_ID]` is assigned by Cloud Monitoring when the policy
     * is created. When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the alerting policy passed as
     * part of the request.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required if the policy exists. The resource name for this policy. The
     * format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
     *
     * `[ALERT_POLICY_ID]` is assigned by Cloud Monitoring when the policy
     * is created. When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the alerting policy passed as
     * part of the request.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required if the policy exists. The resource name for this policy. The
     * format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
     *
     * `[ALERT_POLICY_ID]` is assigned by Cloud Monitoring when the policy
     * is created. When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the alerting policy passed as
     * part of the request.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required if the policy exists. The resource name for this policy. The
     * format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
     *
     * `[ALERT_POLICY_ID]` is assigned by Cloud Monitoring when the policy
     * is created. When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the alerting policy passed as
     * part of the request.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the policy in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple policies in the same project. The name is
     * limited to 512 Unicode characters.
     *
     * The convention for the display_name of a PrometheusQueryLanguageCondition
     * is "{rule group name}/{alert name}", where the {rule group name} and
     * {alert name} should be taken from the corresponding Prometheus
     * configuration file. This convention is not enforced.
     * In any case the display_name is not a unique key of the AlertPolicy.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the policy in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple policies in the same project. The name is
     * limited to 512 Unicode characters.
     *
     * The convention for the display_name of a PrometheusQueryLanguageCondition
     * is "{rule group name}/{alert name}", where the {rule group name} and
     * {alert name} should be taken from the corresponding Prometheus
     * configuration file. This convention is not enforced.
     * In any case the display_name is not a unique key of the AlertPolicy.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the policy in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple policies in the same project. The name is
     * limited to 512 Unicode characters.
     *
     * The convention for the display_name of a PrometheusQueryLanguageCondition
     * is "{rule group name}/{alert name}", where the {rule group name} and
     * {alert name} should be taken from the corresponding Prometheus
     * configuration file. This convention is not enforced.
     * In any case the display_name is not a unique key of the AlertPolicy.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the policy in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple policies in the same project. The name is
     * limited to 512 Unicode characters.
     *
     * The convention for the display_name of a PrometheusQueryLanguageCondition
     * is "{rule group name}/{alert name}", where the {rule group name} and
     * {alert name} should be taken from the corresponding Prometheus
     * configuration file. This convention is not enforced.
     * In any case the display_name is not a unique key of the AlertPolicy.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short name or phrase used to identify the policy in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple policies in the same project. The name is
     * limited to 512 Unicode characters.
     *
     * The convention for the display_name of a PrometheusQueryLanguageCondition
     * is "{rule group name}/{alert name}", where the {rule group name} and
     * {alert name} should be taken from the corresponding Prometheus
     * configuration file. This convention is not enforced.
     * In any case the display_name is not a unique key of the AlertPolicy.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.monitoring.v3.AlertPolicy.Documentation documentation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.AlertPolicy.Documentation,
            com.google.monitoring.v3.AlertPolicy.Documentation.Builder,
            com.google.monitoring.v3.AlertPolicy.DocumentationOrBuilder>
        documentationBuilder_;
    /**
     *
     *
     * <pre>
     * Documentation that is included with notifications and incidents related to
     * this policy. Best practice is for the documentation to include information
     * to help responders understand, mitigate, escalate, and correct the
     * underlying problems detected by the alerting policy. Notification channels
     * that have limited capacity might not show this documentation.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
     *
     * @return Whether the documentation field is set.
     */
    public boolean hasDocumentation() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Documentation that is included with notifications and incidents related to
     * this policy. Best practice is for the documentation to include information
     * to help responders understand, mitigate, escalate, and correct the
     * underlying problems detected by the alerting policy. Notification channels
     * that have limited capacity might not show this documentation.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
     *
     * @return The documentation.
     */
    public com.google.monitoring.v3.AlertPolicy.Documentation getDocumentation() {
      if (documentationBuilder_ == null) {
        return documentation_ == null
            ? com.google.monitoring.v3.AlertPolicy.Documentation.getDefaultInstance()
            : documentation_;
      } else {
        return documentationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Documentation that is included with notifications and incidents related to
     * this policy. Best practice is for the documentation to include information
     * to help responders understand, mitigate, escalate, and correct the
     * underlying problems detected by the alerting policy. Notification channels
     * that have limited capacity might not show this documentation.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
     */
    public Builder setDocumentation(com.google.monitoring.v3.AlertPolicy.Documentation value) {
      if (documentationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentation_ = value;
      } else {
        documentationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Documentation that is included with notifications and incidents related to
     * this policy. Best practice is for the documentation to include information
     * to help responders understand, mitigate, escalate, and correct the
     * underlying problems detected by the alerting policy. Notification channels
     * that have limited capacity might not show this documentation.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
     */
    public Builder setDocumentation(
        com.google.monitoring.v3.AlertPolicy.Documentation.Builder builderForValue) {
      if (documentationBuilder_ == null) {
        documentation_ = builderForValue.build();
      } else {
        documentationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Documentation that is included with notifications and incidents related to
     * this policy. Best practice is for the documentation to include information
     * to help responders understand, mitigate, escalate, and correct the
     * underlying problems detected by the alerting policy. Notification channels
     * that have limited capacity might not show this documentation.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
     */
    public Builder mergeDocumentation(com.google.monitoring.v3.AlertPolicy.Documentation value) {
      if (documentationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && documentation_ != null
            && documentation_
                != com.google.monitoring.v3.AlertPolicy.Documentation.getDefaultInstance()) {
          getDocumentationBuilder().mergeFrom(value);
        } else {
          documentation_ = value;
        }
      } else {
        documentationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Documentation that is included with notifications and incidents related to
     * this policy. Best practice is for the documentation to include information
     * to help responders understand, mitigate, escalate, and correct the
     * underlying problems detected by the alerting policy. Notification channels
     * that have limited capacity might not show this documentation.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
     */
    public Builder clearDocumentation() {
      bitField0_ = (bitField0_ & ~0x00000004);
      documentation_ = null;
      if (documentationBuilder_ != null) {
        documentationBuilder_.dispose();
        documentationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Documentation that is included with notifications and incidents related to
     * this policy. Best practice is for the documentation to include information
     * to help responders understand, mitigate, escalate, and correct the
     * underlying problems detected by the alerting policy. Notification channels
     * that have limited capacity might not show this documentation.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
     */
    public com.google.monitoring.v3.AlertPolicy.Documentation.Builder getDocumentationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDocumentationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Documentation that is included with notifications and incidents related to
     * this policy. Best practice is for the documentation to include information
     * to help responders understand, mitigate, escalate, and correct the
     * underlying problems detected by the alerting policy. Notification channels
     * that have limited capacity might not show this documentation.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
     */
    public com.google.monitoring.v3.AlertPolicy.DocumentationOrBuilder getDocumentationOrBuilder() {
      if (documentationBuilder_ != null) {
        return documentationBuilder_.getMessageOrBuilder();
      } else {
        return documentation_ == null
            ? com.google.monitoring.v3.AlertPolicy.Documentation.getDefaultInstance()
            : documentation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Documentation that is included with notifications and incidents related to
     * this policy. Best practice is for the documentation to include information
     * to help responders understand, mitigate, escalate, and correct the
     * underlying problems detected by the alerting policy. Notification channels
     * that have limited capacity might not show this documentation.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.Documentation documentation = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.AlertPolicy.Documentation,
            com.google.monitoring.v3.AlertPolicy.Documentation.Builder,
            com.google.monitoring.v3.AlertPolicy.DocumentationOrBuilder>
        getDocumentationFieldBuilder() {
      if (documentationBuilder_ == null) {
        documentationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Documentation,
                com.google.monitoring.v3.AlertPolicy.Documentation.Builder,
                com.google.monitoring.v3.AlertPolicy.DocumentationOrBuilder>(
                getDocumentation(), getParentForChildren(), isClean());
        documentation_ = null;
      }
      return documentationBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUserLabels() {
      if (userLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UserLabelsDefaultEntryHolder.defaultEntry);
      }
      return userLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableUserLabels() {
      if (userLabels_ == null) {
        userLabels_ =
            com.google.protobuf.MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!userLabels_.isMutable()) {
        userLabels_ = userLabels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return userLabels_;
    }

    public int getUserLabelsCount() {
      return internalGetUserLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `AlertPolicy` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Note that Prometheus {alert name} is a
     * [valid Prometheus label
     * names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels),
     * whereas Prometheus {rule group} is an unrestricted UTF-8 string.
     * This means that they cannot be stored as-is in user labels, because
     * they may contain characters that are not allowed in user-label values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 16;</code>
     */
    @java.lang.Override
    public boolean containsUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetUserLabels().getMap().containsKey(key);
    }
    /** Use {@link #getUserLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
      return getUserLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `AlertPolicy` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Note that Prometheus {alert name} is a
     * [valid Prometheus label
     * names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels),
     * whereas Prometheus {rule group} is an unrestricted UTF-8 string.
     * This means that they cannot be stored as-is in user labels, because
     * they may contain characters that are not allowed in user-label values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 16;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
      return internalGetUserLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `AlertPolicy` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Note that Prometheus {alert name} is a
     * [valid Prometheus label
     * names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels),
     * whereas Prometheus {rule group} is an unrestricted UTF-8 string.
     * This means that they cannot be stored as-is in user labels, because
     * they may contain characters that are not allowed in user-label values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 16;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getUserLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `AlertPolicy` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Note that Prometheus {alert name} is a
     * [valid Prometheus label
     * names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels),
     * whereas Prometheus {rule group} is an unrestricted UTF-8 string.
     * This means that they cannot be stored as-is in user labels, because
     * they may contain characters that are not allowed in user-label values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 16;</code>
     */
    @java.lang.Override
    public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearUserLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableUserLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `AlertPolicy` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Note that Prometheus {alert name} is a
     * [valid Prometheus label
     * names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels),
     * whereas Prometheus {rule group} is an unrestricted UTF-8 string.
     * This means that they cannot be stored as-is in user labels, because
     * they may contain characters that are not allowed in user-label values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 16;</code>
     */
    public Builder removeUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableUserLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableUserLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableUserLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `AlertPolicy` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Note that Prometheus {alert name} is a
     * [valid Prometheus label
     * names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels),
     * whereas Prometheus {rule group} is an unrestricted UTF-8 string.
     * This means that they cannot be stored as-is in user labels, because
     * they may contain characters that are not allowed in user-label values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 16;</code>
     */
    public Builder putUserLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableUserLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `AlertPolicy` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Note that Prometheus {alert name} is a
     * [valid Prometheus label
     * names](https://prometheus.io/docs/concepts/data_model/#metric-names-and-labels),
     * whereas Prometheus {rule group} is an unrestricted UTF-8 string.
     * This means that they cannot be stored as-is in user labels, because
     * they may contain characters that are not allowed in user-label values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 16;</code>
     */
    public Builder putAllUserLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableUserLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.util.List<com.google.monitoring.v3.AlertPolicy.Condition> conditions_ =
        java.util.Collections.emptyList();

    private void ensureConditionsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        conditions_ =
            new java.util.ArrayList<com.google.monitoring.v3.AlertPolicy.Condition>(conditions_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.AlertPolicy.Condition,
            com.google.monitoring.v3.AlertPolicy.Condition.Builder,
            com.google.monitoring.v3.AlertPolicy.ConditionOrBuilder>
        conditionsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public java.util.List<com.google.monitoring.v3.AlertPolicy.Condition> getConditionsList() {
      if (conditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditions_);
      } else {
        return conditionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public int getConditionsCount() {
      if (conditionsBuilder_ == null) {
        return conditions_.size();
      } else {
        return conditionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public com.google.monitoring.v3.AlertPolicy.Condition getConditions(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public Builder setConditions(int index, com.google.monitoring.v3.AlertPolicy.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.set(index, value);
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public Builder setConditions(
        int index, com.google.monitoring.v3.AlertPolicy.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public Builder addConditions(com.google.monitoring.v3.AlertPolicy.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public Builder addConditions(int index, com.google.monitoring.v3.AlertPolicy.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(index, value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public Builder addConditions(
        com.google.monitoring.v3.AlertPolicy.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public Builder addConditions(
        int index, com.google.monitoring.v3.AlertPolicy.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public Builder addAllConditions(
        java.lang.Iterable<? extends com.google.monitoring.v3.AlertPolicy.Condition> values) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
        onChanged();
      } else {
        conditionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public Builder clearConditions() {
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        conditionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public Builder removeConditions(int index) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.remove(index);
        onChanged();
      } else {
        conditionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public com.google.monitoring.v3.AlertPolicy.Condition.Builder getConditionsBuilder(int index) {
      return getConditionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public com.google.monitoring.v3.AlertPolicy.ConditionOrBuilder getConditionsOrBuilder(
        int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public java.util.List<? extends com.google.monitoring.v3.AlertPolicy.ConditionOrBuilder>
        getConditionsOrBuilderList() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditions_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public com.google.monitoring.v3.AlertPolicy.Condition.Builder addConditionsBuilder() {
      return getConditionsFieldBuilder()
          .addBuilder(com.google.monitoring.v3.AlertPolicy.Condition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public com.google.monitoring.v3.AlertPolicy.Condition.Builder addConditionsBuilder(int index) {
      return getConditionsFieldBuilder()
          .addBuilder(index, com.google.monitoring.v3.AlertPolicy.Condition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of conditions for the policy. The conditions are combined by AND or
     * OR according to the `combiner` field. If the combined conditions evaluate
     * to true, then an incident is created. A policy can have from one to six
     * conditions.
     * If `condition_time_series_query_language` is present, it must be the only
     * `condition`.
     * If `condition_monitoring_query_language` is present, it must be the only
     * `condition`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.AlertPolicy.Condition conditions = 12;</code>
     */
    public java.util.List<com.google.monitoring.v3.AlertPolicy.Condition.Builder>
        getConditionsBuilderList() {
      return getConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.AlertPolicy.Condition,
            com.google.monitoring.v3.AlertPolicy.Condition.Builder,
            com.google.monitoring.v3.AlertPolicy.ConditionOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.AlertPolicy.Condition,
                com.google.monitoring.v3.AlertPolicy.Condition.Builder,
                com.google.monitoring.v3.AlertPolicy.ConditionOrBuilder>(
                conditions_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    private int combiner_ = 0;
    /**
     *
     *
     * <pre>
     * How to combine the results of multiple conditions to determine if an
     * incident should be opened.
     * If `condition_time_series_query_language` is present, this must be
     * `COMBINE_UNSPECIFIED`.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.ConditionCombinerType combiner = 6;</code>
     *
     * @return The enum numeric value on the wire for combiner.
     */
    @java.lang.Override
    public int getCombinerValue() {
      return combiner_;
    }
    /**
     *
     *
     * <pre>
     * How to combine the results of multiple conditions to determine if an
     * incident should be opened.
     * If `condition_time_series_query_language` is present, this must be
     * `COMBINE_UNSPECIFIED`.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.ConditionCombinerType combiner = 6;</code>
     *
     * @param value The enum numeric value on the wire for combiner to set.
     * @return This builder for chaining.
     */
    public Builder setCombinerValue(int value) {
      combiner_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How to combine the results of multiple conditions to determine if an
     * incident should be opened.
     * If `condition_time_series_query_language` is present, this must be
     * `COMBINE_UNSPECIFIED`.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.ConditionCombinerType combiner = 6;</code>
     *
     * @return The combiner.
     */
    @java.lang.Override
    public com.google.monitoring.v3.AlertPolicy.ConditionCombinerType getCombiner() {
      com.google.monitoring.v3.AlertPolicy.ConditionCombinerType result =
          com.google.monitoring.v3.AlertPolicy.ConditionCombinerType.forNumber(combiner_);
      return result == null
          ? com.google.monitoring.v3.AlertPolicy.ConditionCombinerType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * How to combine the results of multiple conditions to determine if an
     * incident should be opened.
     * If `condition_time_series_query_language` is present, this must be
     * `COMBINE_UNSPECIFIED`.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.ConditionCombinerType combiner = 6;</code>
     *
     * @param value The combiner to set.
     * @return This builder for chaining.
     */
    public Builder setCombiner(com.google.monitoring.v3.AlertPolicy.ConditionCombinerType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      combiner_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How to combine the results of multiple conditions to determine if an
     * incident should be opened.
     * If `condition_time_series_query_language` is present, this must be
     * `COMBINE_UNSPECIFIED`.
     * </pre>
     *
     * <code>.google.monitoring.v3.AlertPolicy.ConditionCombinerType combiner = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCombiner() {
      bitField0_ = (bitField0_ & ~0x00000020);
      combiner_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.BoolValue enabled_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        enabledBuilder_;
    /**
     *
     *
     * <pre>
     * Whether or not the policy is enabled. On write, the default interpretation
     * if unset is that the policy is enabled. On read, clients should not make
     * any assumption about the state if it has not been populated. The
     * field should always be populated on List and Get operations, unless
     * a field projection has been specified that strips it out.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 17;</code>
     *
     * @return Whether the enabled field is set.
     */
    public boolean hasEnabled() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether or not the policy is enabled. On write, the default interpretation
     * if unset is that the policy is enabled. On read, clients should not make
     * any assumption about the state if it has not been populated. The
     * field should always be populated on List and Get operations, unless
     * a field projection has been specified that strips it out.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 17;</code>
     *
     * @return The enabled.
     */
    public com.google.protobuf.BoolValue getEnabled() {
      if (enabledBuilder_ == null) {
        return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
      } else {
        return enabledBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Whether or not the policy is enabled. On write, the default interpretation
     * if unset is that the policy is enabled. On read, clients should not make
     * any assumption about the state if it has not been populated. The
     * field should always be populated on List and Get operations, unless
     * a field projection has been specified that strips it out.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 17;</code>
     */
    public Builder setEnabled(com.google.protobuf.BoolValue value) {
      if (enabledBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        enabled_ = value;
      } else {
        enabledBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether or not the policy is enabled. On write, the default interpretation
     * if unset is that the policy is enabled. On read, clients should not make
     * any assumption about the state if it has not been populated. The
     * field should always be populated on List and Get operations, unless
     * a field projection has been specified that strips it out.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 17;</code>
     */
    public Builder setEnabled(com.google.protobuf.BoolValue.Builder builderForValue) {
      if (enabledBuilder_ == null) {
        enabled_ = builderForValue.build();
      } else {
        enabledBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether or not the policy is enabled. On write, the default interpretation
     * if unset is that the policy is enabled. On read, clients should not make
     * any assumption about the state if it has not been populated. The
     * field should always be populated on List and Get operations, unless
     * a field projection has been specified that strips it out.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 17;</code>
     */
    public Builder mergeEnabled(com.google.protobuf.BoolValue value) {
      if (enabledBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && enabled_ != null
            && enabled_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
          getEnabledBuilder().mergeFrom(value);
        } else {
          enabled_ = value;
        }
      } else {
        enabledBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether or not the policy is enabled. On write, the default interpretation
     * if unset is that the policy is enabled. On read, clients should not make
     * any assumption about the state if it has not been populated. The
     * field should always be populated on List and Get operations, unless
     * a field projection has been specified that strips it out.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 17;</code>
     */
    public Builder clearEnabled() {
      bitField0_ = (bitField0_ & ~0x00000040);
      enabled_ = null;
      if (enabledBuilder_ != null) {
        enabledBuilder_.dispose();
        enabledBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether or not the policy is enabled. On write, the default interpretation
     * if unset is that the policy is enabled. On read, clients should not make
     * any assumption about the state if it has not been populated. The
     * field should always be populated on List and Get operations, unless
     * a field projection has been specified that strips it out.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 17;</code>
     */
    public com.google.protobuf.BoolValue.Builder getEnabledBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getEnabledFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Whether or not the policy is enabled. On write, the default interpretation
     * if unset is that the policy is enabled. On read, clients should not make
     * any assumption about the state if it has not been populated. The
     * field should always be populated on List and Get operations, unless
     * a field projection has been specified that strips it out.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 17;</code>
     */
    public com.google.protobuf.BoolValueOrBuilder getEnabledOrBuilder() {
      if (enabledBuilder_ != null) {
        return enabledBuilder_.getMessageOrBuilder();
      } else {
        return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
      }
    }
    /**
     *
     *
     * <pre>
     * Whether or not the policy is enabled. On write, the default interpretation
     * if unset is that the policy is enabled. On read, clients should not make
     * any assumption about the state if it has not been populated. The
     * field should always be populated on List and Get operations, unless
     * a field projection has been specified that strips it out.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enabled = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        getEnabledFieldBuilder() {
      if (enabledBuilder_ == null) {
        enabledBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>(
                getEnabled(), getParentForChildren(), isClean());
        enabled_ = null;
      }
      return enabledBuilder_;
    }

    private com.google.rpc.Status validity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        validityBuilder_;
    /**
     *
     *
     * <pre>
     * Read-only description of how the alert policy is invalid. This field is
     * only set when the alert policy is invalid. An invalid alert policy will not
     * generate incidents.
     * </pre>
     *
     * <code>.google.rpc.Status validity = 18;</code>
     *
     * @return Whether the validity field is set.
     */
    public boolean hasValidity() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Read-only description of how the alert policy is invalid. This field is
     * only set when the alert policy is invalid. An invalid alert policy will not
     * generate incidents.
     * </pre>
     *
     * <code>.google.rpc.Status validity = 18;</code>
     *
     * @return The validity.
     */
    public com.google.rpc.Status getValidity() {
      if (validityBuilder_ == null) {
        return validity_ == null ? com.google.rpc.Status.getDefaultInstance() : validity_;
      } else {
        return validityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Read-only description of how the alert policy is invalid. This field is
     * only set when the alert policy is invalid. An invalid alert policy will not
     * generate incidents.
     * </pre>
     *
     * <code>.google.rpc.Status validity = 18;</code>
     */
    public Builder setValidity(com.google.rpc.Status value) {
      if (validityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        validity_ = value;
      } else {
        validityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read-only description of how the alert policy is invalid. This field is
     * only set when the alert policy is invalid. An invalid alert policy will not
   