/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * Response for the `StreamingPull` method. This response is used to stream
 * messages from the server to the client.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.StreamingPullResponse}
 */
public final class StreamingPullResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.StreamingPullResponse)
    StreamingPullResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingPullResponse.newBuilder() to construct.
  private StreamingPullResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingPullResponse() {
    receivedMessages_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingPullResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_StreamingPullResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_StreamingPullResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.StreamingPullResponse.class,
            com.google.pubsub.v1.StreamingPullResponse.Builder.class);
  }

  public interface AcknowledgeConfirmationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the ackIds.
     */
    java.util.List<java.lang.String> getAckIdsList();
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of ackIds.
     */
    int getAckIdsCount();
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The ackIds at the given index.
     */
    java.lang.String getAckIds(int index);
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ackIds at the given index.
     */
    com.google.protobuf.ByteString getAckIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the invalidAckIds.
     */
    java.util.List<java.lang.String> getInvalidAckIdsList();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of invalidAckIds.
     */
    int getInvalidAckIdsCount();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The invalidAckIds at the given index.
     */
    java.lang.String getInvalidAckIds(int index);
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the invalidAckIds at the given index.
     */
    com.google.protobuf.ByteString getInvalidAckIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were out of order.
     * </pre>
     *
     * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the unorderedAckIds.
     */
    java.util.List<java.lang.String> getUnorderedAckIdsList();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were out of order.
     * </pre>
     *
     * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of unorderedAckIds.
     */
    int getUnorderedAckIdsCount();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were out of order.
     * </pre>
     *
     * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The unorderedAckIds at the given index.
     */
    java.lang.String getUnorderedAckIds(int index);
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were out of order.
     * </pre>
     *
     * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unorderedAckIds at the given index.
     */
    com.google.protobuf.ByteString getUnorderedAckIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the temporaryFailedAckIds.
     */
    java.util.List<java.lang.String> getTemporaryFailedAckIdsList();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of temporaryFailedAckIds.
     */
    int getTemporaryFailedAckIdsCount();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The temporaryFailedAckIds at the given index.
     */
    java.lang.String getTemporaryFailedAckIds(int index);
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the temporaryFailedAckIds at the given index.
     */
    com.google.protobuf.ByteString getTemporaryFailedAckIdsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Acknowledgement IDs sent in one or more previous requests to acknowledge a
   * previously received message.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation}
   */
  public static final class AcknowledgeConfirmation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation)
      AcknowledgeConfirmationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AcknowledgeConfirmation.newBuilder() to construct.
    private AcknowledgeConfirmation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AcknowledgeConfirmation() {
      ackIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      invalidAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      unorderedAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      temporaryFailedAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AcknowledgeConfirmation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullResponse_AcknowledgeConfirmation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullResponse_AcknowledgeConfirmation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.class,
              com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.Builder.class);
    }

    public static final int ACK_IDS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList ackIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the ackIds.
     */
    public com.google.protobuf.ProtocolStringList getAckIdsList() {
      return ackIds_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of ackIds.
     */
    public int getAckIdsCount() {
      return ackIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The ackIds at the given index.
     */
    public java.lang.String getAckIds(int index) {
      return ackIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ackIds at the given index.
     */
    public com.google.protobuf.ByteString getAckIdsBytes(int index) {
      return ackIds_.getByteString(index);
    }

    public static final int INVALID_ACK_IDS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList invalidAckIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the invalidAckIds.
     */
    public com.google.protobuf.ProtocolStringList getInvalidAckIdsList() {
      return invalidAckIds_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of invalidAckIds.
     */
    public int getInvalidAckIdsCount() {
      return invalidAckIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The invalidAckIds at the given index.
     */
    public java.lang.String getInvalidAckIds(int index) {
      return invalidAckIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the invalidAckIds at the given index.
     */
    public com.google.protobuf.ByteString getInvalidAckIdsBytes(int index) {
      return invalidAckIds_.getByteString(index);
    }

    public static final int UNORDERED_ACK_IDS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList unorderedAckIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were out of order.
     * </pre>
     *
     * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the unorderedAckIds.
     */
    public com.google.protobuf.ProtocolStringList getUnorderedAckIdsList() {
      return unorderedAckIds_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were out of order.
     * </pre>
     *
     * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of unorderedAckIds.
     */
    public int getUnorderedAckIdsCount() {
      return unorderedAckIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were out of order.
     * </pre>
     *
     * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The unorderedAckIds at the given index.
     */
    public java.lang.String getUnorderedAckIds(int index) {
      return unorderedAckIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were out of order.
     * </pre>
     *
     * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unorderedAckIds at the given index.
     */
    public com.google.protobuf.ByteString getUnorderedAckIdsBytes(int index) {
      return unorderedAckIds_.getByteString(index);
    }

    public static final int TEMPORARY_FAILED_ACK_IDS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList temporaryFailedAckIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the temporaryFailedAckIds.
     */
    public com.google.protobuf.ProtocolStringList getTemporaryFailedAckIdsList() {
      return temporaryFailedAckIds_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of temporaryFailedAckIds.
     */
    public int getTemporaryFailedAckIdsCount() {
      return temporaryFailedAckIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The temporaryFailedAckIds at the given index.
     */
    public java.lang.String getTemporaryFailedAckIds(int index) {
      return temporaryFailedAckIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the temporaryFailedAckIds at the given index.
     */
    public com.google.protobuf.ByteString getTemporaryFailedAckIdsBytes(int index) {
      return temporaryFailedAckIds_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < ackIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ackIds_.getRaw(i));
      }
      for (int i = 0; i < invalidAckIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, invalidAckIds_.getRaw(i));
      }
      for (int i = 0; i < unorderedAckIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, unorderedAckIds_.getRaw(i));
      }
      for (int i = 0; i < temporaryFailedAckIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 4, temporaryFailedAckIds_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < ackIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(ackIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAckIdsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < invalidAckIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(invalidAckIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getInvalidAckIdsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < unorderedAckIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(unorderedAckIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getUnorderedAckIdsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < temporaryFailedAckIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(temporaryFailedAckIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTemporaryFailedAckIdsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation other =
          (com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation) obj;

      if (!getAckIdsList().equals(other.getAckIdsList())) return false;
      if (!getInvalidAckIdsList().equals(other.getInvalidAckIdsList())) return false;
      if (!getUnorderedAckIdsList().equals(other.getUnorderedAckIdsList())) return false;
      if (!getTemporaryFailedAckIdsList().equals(other.getTemporaryFailedAckIdsList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAckIdsCount() > 0) {
        hash = (37 * hash) + ACK_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getAckIdsList().hashCode();
      }
      if (getInvalidAckIdsCount() > 0) {
        hash = (37 * hash) + INVALID_ACK_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getInvalidAckIdsList().hashCode();
      }
      if (getUnorderedAckIdsCount() > 0) {
        hash = (37 * hash) + UNORDERED_ACK_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getUnorderedAckIdsList().hashCode();
      }
      if (getTemporaryFailedAckIdsCount() > 0) {
        hash = (37 * hash) + TEMPORARY_FAILED_ACK_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getTemporaryFailedAckIdsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Acknowledgement IDs sent in one or more previous requests to acknowledge a
     * previously received message.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation)
        com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_StreamingPullResponse_AcknowledgeConfirmation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_StreamingPullResponse_AcknowledgeConfirmation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.class,
                com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.Builder.class);
      }

      // Construct using
      // com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        ackIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        invalidAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        unorderedAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        temporaryFailedAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_StreamingPullResponse_AcknowledgeConfirmation_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation build() {
        com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation buildPartial() {
        com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation result =
            new com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          ackIds_.makeImmutable();
          result.ackIds_ = ackIds_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          invalidAckIds_.makeImmutable();
          result.invalidAckIds_ = invalidAckIds_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          unorderedAckIds_.makeImmutable();
          result.unorderedAckIds_ = unorderedAckIds_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          temporaryFailedAckIds_.makeImmutable();
          result.temporaryFailedAckIds_ = temporaryFailedAckIds_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation) {
          return mergeFrom(
              (com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation other) {
        if (other
            == com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                .getDefaultInstance()) return this;
        if (!other.ackIds_.isEmpty()) {
          if (ackIds_.isEmpty()) {
            ackIds_ = other.ackIds_;
            bitField0_ |= 0x00000001;
          } else {
            ensureAckIdsIsMutable();
            ackIds_.addAll(other.ackIds_);
          }
          onChanged();
        }
        if (!other.invalidAckIds_.isEmpty()) {
          if (invalidAckIds_.isEmpty()) {
            invalidAckIds_ = other.invalidAckIds_;
            bitField0_ |= 0x00000002;
          } else {
            ensureInvalidAckIdsIsMutable();
            invalidAckIds_.addAll(other.invalidAckIds_);
          }
          onChanged();
        }
        if (!other.unorderedAckIds_.isEmpty()) {
          if (unorderedAckIds_.isEmpty()) {
            unorderedAckIds_ = other.unorderedAckIds_;
            bitField0_ |= 0x00000004;
          } else {
            ensureUnorderedAckIdsIsMutable();
            unorderedAckIds_.addAll(other.unorderedAckIds_);
          }
          onChanged();
        }
        if (!other.temporaryFailedAckIds_.isEmpty()) {
          if (temporaryFailedAckIds_.isEmpty()) {
            temporaryFailedAckIds_ = other.temporaryFailedAckIds_;
            bitField0_ |= 0x00000008;
          } else {
            ensureTemporaryFailedAckIdsIsMutable();
            temporaryFailedAckIds_.addAll(other.temporaryFailedAckIds_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAckIdsIsMutable();
                  ackIds_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureInvalidAckIdsIsMutable();
                  invalidAckIds_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureUnorderedAckIdsIsMutable();
                  unorderedAckIds_.add(s);
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTemporaryFailedAckIdsIsMutable();
                  temporaryFailedAckIds_.add(s);
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList ackIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAckIdsIsMutable() {
        if (!ackIds_.isModifiable()) {
          ackIds_ = new com.google.protobuf.LazyStringArrayList(ackIds_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the ackIds.
       */
      public com.google.protobuf.ProtocolStringList getAckIdsList() {
        ackIds_.makeImmutable();
        return ackIds_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of ackIds.
       */
      public int getAckIdsCount() {
        return ackIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The ackIds at the given index.
       */
      public java.lang.String getAckIds(int index) {
        return ackIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the ackIds at the given index.
       */
      public com.google.protobuf.ByteString getAckIdsBytes(int index) {
        return ackIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The ackIds to set.
       * @return This builder for chaining.
       */
      public Builder setAckIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAckIdsIsMutable();
        ackIds_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The ackIds to add.
       * @return This builder for chaining.
       */
      public Builder addAckIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAckIdsIsMutable();
        ackIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The ackIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllAckIds(java.lang.Iterable<java.lang.String> values) {
        ensureAckIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ackIds_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAckIds() {
        ackIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the ackIds to add.
       * @return This builder for chaining.
       */
      public Builder addAckIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAckIdsIsMutable();
        ackIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList invalidAckIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureInvalidAckIdsIsMutable() {
        if (!invalidAckIds_.isModifiable()) {
          invalidAckIds_ = new com.google.protobuf.LazyStringArrayList(invalidAckIds_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the invalidAckIds.
       */
      public com.google.protobuf.ProtocolStringList getInvalidAckIdsList() {
        invalidAckIds_.makeImmutable();
        return invalidAckIds_;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of invalidAckIds.
       */
      public int getInvalidAckIdsCount() {
        return invalidAckIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The invalidAckIds at the given index.
       */
      public java.lang.String getInvalidAckIds(int index) {
        return invalidAckIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the invalidAckIds at the given index.
       */
      public com.google.protobuf.ByteString getInvalidAckIdsBytes(int index) {
        return invalidAckIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The invalidAckIds to set.
       * @return This builder for chaining.
       */
      public Builder setInvalidAckIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInvalidAckIdsIsMutable();
        invalidAckIds_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The invalidAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addInvalidAckIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInvalidAckIdsIsMutable();
        invalidAckIds_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The invalidAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllInvalidAckIds(java.lang.Iterable<java.lang.String> values) {
        ensureInvalidAckIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, invalidAckIds_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInvalidAckIds() {
        invalidAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the invalidAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addInvalidAckIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureInvalidAckIdsIsMutable();
        invalidAckIds_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList unorderedAckIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureUnorderedAckIdsIsMutable() {
        if (!unorderedAckIds_.isModifiable()) {
          unorderedAckIds_ = new com.google.protobuf.LazyStringArrayList(unorderedAckIds_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were out of order.
       * </pre>
       *
       * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the unorderedAckIds.
       */
      public com.google.protobuf.ProtocolStringList getUnorderedAckIdsList() {
        unorderedAckIds_.makeImmutable();
        return unorderedAckIds_;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were out of order.
       * </pre>
       *
       * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of unorderedAckIds.
       */
      public int getUnorderedAckIdsCount() {
        return unorderedAckIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were out of order.
       * </pre>
       *
       * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The unorderedAckIds at the given index.
       */
      public java.lang.String getUnorderedAckIds(int index) {
        return unorderedAckIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were out of order.
       * </pre>
       *
       * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the unorderedAckIds at the given index.
       */
      public com.google.protobuf.ByteString getUnorderedAckIdsBytes(int index) {
        return unorderedAckIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were out of order.
       * </pre>
       *
       * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The unorderedAckIds to set.
       * @return This builder for chaining.
       */
      public Builder setUnorderedAckIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUnorderedAckIdsIsMutable();
        unorderedAckIds_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were out of order.
       * </pre>
       *
       * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The unorderedAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addUnorderedAckIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUnorderedAckIdsIsMutable();
        unorderedAckIds_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were out of order.
       * </pre>
       *
       * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The unorderedAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllUnorderedAckIds(java.lang.Iterable<java.lang.String> values) {
        ensureUnorderedAckIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unorderedAckIds_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were out of order.
       * </pre>
       *
       * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUnorderedAckIds() {
        unorderedAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were out of order.
       * </pre>
       *
       * <code>repeated string unordered_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the unorderedAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addUnorderedAckIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureUnorderedAckIdsIsMutable();
        unorderedAckIds_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList temporaryFailedAckIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureTemporaryFailedAckIdsIsMutable() {
        if (!temporaryFailedAckIds_.isModifiable()) {
          temporaryFailedAckIds_ =
              new com.google.protobuf.LazyStringArrayList(temporaryFailedAckIds_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the temporaryFailedAckIds.
       */
      public com.google.protobuf.ProtocolStringList getTemporaryFailedAckIdsList() {
        temporaryFailedAckIds_.makeImmutable();
        return temporaryFailedAckIds_;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of temporaryFailedAckIds.
       */
      public int getTemporaryFailedAckIdsCount() {
        return temporaryFailedAckIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The temporaryFailedAckIds at the given index.
       */
      public java.lang.String getTemporaryFailedAckIds(int index) {
        return temporaryFailedAckIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the temporaryFailedAckIds at the given index.
       */
      public com.google.protobuf.ByteString getTemporaryFailedAckIdsBytes(int index) {
        return temporaryFailedAckIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The temporaryFailedAckIds to set.
       * @return This builder for chaining.
       */
      public Builder setTemporaryFailedAckIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTemporaryFailedAckIdsIsMutable();
        temporaryFailedAckIds_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The temporaryFailedAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addTemporaryFailedAckIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTemporaryFailedAckIdsIsMutable();
        temporaryFailedAckIds_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The temporaryFailedAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllTemporaryFailedAckIds(java.lang.Iterable<java.lang.String> values) {
        ensureTemporaryFailedAckIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, temporaryFailedAckIds_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTemporaryFailedAckIds() {
        temporaryFailedAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the temporaryFailedAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addTemporaryFailedAckIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTemporaryFailedAckIdsIsMutable();
        temporaryFailedAckIds_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation)
    private static final com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation();
    }

    public static com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AcknowledgeConfirmation> PARSER =
        new com.google.protobuf.AbstractParser<AcknowledgeConfirmation>() {
          @java.lang.Override
          public AcknowledgeConfirmation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AcknowledgeConfirmation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AcknowledgeConfirmation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ModifyAckDeadlineConfirmationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the ackIds.
     */
    java.util.List<java.lang.String> getAckIdsList();
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of ackIds.
     */
    int getAckIdsCount();
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The ackIds at the given index.
     */
    java.lang.String getAckIds(int index);
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ackIds at the given index.
     */
    com.google.protobuf.ByteString getAckIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the invalidAckIds.
     */
    java.util.List<java.lang.String> getInvalidAckIdsList();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of invalidAckIds.
     */
    int getInvalidAckIdsCount();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The invalidAckIds at the given index.
     */
    java.lang.String getInvalidAckIds(int index);
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the invalidAckIds at the given index.
     */
    com.google.protobuf.ByteString getInvalidAckIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the temporaryFailedAckIds.
     */
    java.util.List<java.lang.String> getTemporaryFailedAckIdsList();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of temporaryFailedAckIds.
     */
    int getTemporaryFailedAckIdsCount();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The temporaryFailedAckIds at the given index.
     */
    java.lang.String getTemporaryFailedAckIds(int index);
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the temporaryFailedAckIds at the given index.
     */
    com.google.protobuf.ByteString getTemporaryFailedAckIdsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Acknowledgement IDs sent in one or more previous requests to modify the
   * deadline for a specific message.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation}
   */
  public static final class ModifyAckDeadlineConfirmation
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation)
      ModifyAckDeadlineConfirmationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ModifyAckDeadlineConfirmation.newBuilder() to construct.
    private ModifyAckDeadlineConfirmation(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ModifyAckDeadlineConfirmation() {
      ackIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      invalidAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      temporaryFailedAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ModifyAckDeadlineConfirmation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullResponse_ModifyAckDeadlineConfirmation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullResponse_ModifyAckDeadlineConfirmation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.class,
              com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.Builder
                  .class);
    }

    public static final int ACK_IDS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList ackIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the ackIds.
     */
    public com.google.protobuf.ProtocolStringList getAckIdsList() {
      return ackIds_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of ackIds.
     */
    public int getAckIdsCount() {
      return ackIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The ackIds at the given index.
     */
    public java.lang.String getAckIds(int index) {
      return ackIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Successfully processed acknowledgement IDs.
     * </pre>
     *
     * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ackIds at the given index.
     */
    public com.google.protobuf.ByteString getAckIdsBytes(int index) {
      return ackIds_.getByteString(index);
    }

    public static final int INVALID_ACK_IDS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList invalidAckIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the invalidAckIds.
     */
    public com.google.protobuf.ProtocolStringList getInvalidAckIdsList() {
      return invalidAckIds_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of invalidAckIds.
     */
    public int getInvalidAckIdsCount() {
      return invalidAckIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The invalidAckIds at the given index.
     */
    public java.lang.String getInvalidAckIds(int index) {
      return invalidAckIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that were malformed or whose
     * acknowledgement deadline has expired.
     * </pre>
     *
     * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the invalidAckIds at the given index.
     */
    public com.google.protobuf.ByteString getInvalidAckIdsBytes(int index) {
      return invalidAckIds_.getByteString(index);
    }

    public static final int TEMPORARY_FAILED_ACK_IDS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList temporaryFailedAckIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the temporaryFailedAckIds.
     */
    public com.google.protobuf.ProtocolStringList getTemporaryFailedAckIdsList() {
      return temporaryFailedAckIds_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of temporaryFailedAckIds.
     */
    public int getTemporaryFailedAckIdsCount() {
      return temporaryFailedAckIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The temporaryFailedAckIds at the given index.
     */
    public java.lang.String getTemporaryFailedAckIds(int index) {
      return temporaryFailedAckIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of acknowledgement IDs that failed processing with
     * temporary issues.
     * </pre>
     *
     * <code>repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the temporaryFailedAckIds at the given index.
     */
    public com.google.protobuf.ByteString getTemporaryFailedAckIdsBytes(int index) {
      return temporaryFailedAckIds_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < ackIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ackIds_.getRaw(i));
      }
      for (int i = 0; i < invalidAckIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, invalidAckIds_.getRaw(i));
      }
      for (int i = 0; i < temporaryFailedAckIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 3, temporaryFailedAckIds_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < ackIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(ackIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAckIdsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < invalidAckIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(invalidAckIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getInvalidAckIdsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < temporaryFailedAckIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(temporaryFailedAckIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTemporaryFailedAckIdsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation other =
          (com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation) obj;

      if (!getAckIdsList().equals(other.getAckIdsList())) return false;
      if (!getInvalidAckIdsList().equals(other.getInvalidAckIdsList())) return false;
      if (!getTemporaryFailedAckIdsList().equals(other.getTemporaryFailedAckIdsList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAckIdsCount() > 0) {
        hash = (37 * hash) + ACK_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getAckIdsList().hashCode();
      }
      if (getInvalidAckIdsCount() > 0) {
        hash = (37 * hash) + INVALID_ACK_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getInvalidAckIdsList().hashCode();
      }
      if (getTemporaryFailedAckIdsCount() > 0) {
        hash = (37 * hash) + TEMPORARY_FAILED_ACK_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getTemporaryFailedAckIdsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Acknowledgement IDs sent in one or more previous requests to modify the
     * deadline for a specific message.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation)
        com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_StreamingPullResponse_ModifyAckDeadlineConfirmation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_StreamingPullResponse_ModifyAckDeadlineConfirmation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.class,
                com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.Builder
                    .class);
      }

      // Construct using
      // com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        ackIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        invalidAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        temporaryFailedAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_StreamingPullResponse_ModifyAckDeadlineConfirmation_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation build() {
        com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
          buildPartial() {
        com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation result =
            new com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          ackIds_.makeImmutable();
          result.ackIds_ = ackIds_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          invalidAckIds_.makeImmutable();
          result.invalidAckIds_ = invalidAckIds_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          temporaryFailedAckIds_.makeImmutable();
          result.temporaryFailedAckIds_ = temporaryFailedAckIds_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation) {
          return mergeFrom(
              (com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation other) {
        if (other
            == com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                .getDefaultInstance()) return this;
        if (!other.ackIds_.isEmpty()) {
          if (ackIds_.isEmpty()) {
            ackIds_ = other.ackIds_;
            bitField0_ |= 0x00000001;
          } else {
            ensureAckIdsIsMutable();
            ackIds_.addAll(other.ackIds_);
          }
          onChanged();
        }
        if (!other.invalidAckIds_.isEmpty()) {
          if (invalidAckIds_.isEmpty()) {
            invalidAckIds_ = other.invalidAckIds_;
            bitField0_ |= 0x00000002;
          } else {
            ensureInvalidAckIdsIsMutable();
            invalidAckIds_.addAll(other.invalidAckIds_);
          }
          onChanged();
        }
        if (!other.temporaryFailedAckIds_.isEmpty()) {
          if (temporaryFailedAckIds_.isEmpty()) {
            temporaryFailedAckIds_ = other.temporaryFailedAckIds_;
            bitField0_ |= 0x00000004;
          } else {
            ensureTemporaryFailedAckIdsIsMutable();
            temporaryFailedAckIds_.addAll(other.temporaryFailedAckIds_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAckIdsIsMutable();
                  ackIds_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureInvalidAckIdsIsMutable();
                  invalidAckIds_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTemporaryFailedAckIdsIsMutable();
                  temporaryFailedAckIds_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList ackIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAckIdsIsMutable() {
        if (!ackIds_.isModifiable()) {
          ackIds_ = new com.google.protobuf.LazyStringArrayList(ackIds_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the ackIds.
       */
      public com.google.protobuf.ProtocolStringList getAckIdsList() {
        ackIds_.makeImmutable();
        return ackIds_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of ackIds.
       */
      public int getAckIdsCount() {
        return ackIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The ackIds at the given index.
       */
      public java.lang.String getAckIds(int index) {
        return ackIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the ackIds at the given index.
       */
      public com.google.protobuf.ByteString getAckIdsBytes(int index) {
        return ackIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The ackIds to set.
       * @return This builder for chaining.
       */
      public Builder setAckIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAckIdsIsMutable();
        ackIds_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The ackIds to add.
       * @return This builder for chaining.
       */
      public Builder addAckIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAckIdsIsMutable();
        ackIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The ackIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllAckIds(java.lang.Iterable<java.lang.String> values) {
        ensureAckIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ackIds_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAckIds() {
        ackIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Successfully processed acknowledgement IDs.
       * </pre>
       *
       * <code>repeated string ack_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the ackIds to add.
       * @return This builder for chaining.
       */
      public Builder addAckIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAckIdsIsMutable();
        ackIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList invalidAckIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureInvalidAckIdsIsMutable() {
        if (!invalidAckIds_.isModifiable()) {
          invalidAckIds_ = new com.google.protobuf.LazyStringArrayList(invalidAckIds_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the invalidAckIds.
       */
      public com.google.protobuf.ProtocolStringList getInvalidAckIdsList() {
        invalidAckIds_.makeImmutable();
        return invalidAckIds_;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of invalidAckIds.
       */
      public int getInvalidAckIdsCount() {
        return invalidAckIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The invalidAckIds at the given index.
       */
      public java.lang.String getInvalidAckIds(int index) {
        return invalidAckIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the invalidAckIds at the given index.
       */
      public com.google.protobuf.ByteString getInvalidAckIdsBytes(int index) {
        return invalidAckIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The invalidAckIds to set.
       * @return This builder for chaining.
       */
      public Builder setInvalidAckIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInvalidAckIdsIsMutable();
        invalidAckIds_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The invalidAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addInvalidAckIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInvalidAckIdsIsMutable();
        invalidAckIds_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The invalidAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllInvalidAckIds(java.lang.Iterable<java.lang.String> values) {
        ensureInvalidAckIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, invalidAckIds_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInvalidAckIds() {
        invalidAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that were malformed or whose
       * acknowledgement deadline has expired.
       * </pre>
       *
       * <code>repeated string invalid_ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the invalidAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addInvalidAckIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureInvalidAckIdsIsMutable();
        invalidAckIds_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList temporaryFailedAckIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureTemporaryFailedAckIdsIsMutable() {
        if (!temporaryFailedAckIds_.isModifiable()) {
          temporaryFailedAckIds_ =
              new com.google.protobuf.LazyStringArrayList(temporaryFailedAckIds_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the temporaryFailedAckIds.
       */
      public com.google.protobuf.ProtocolStringList getTemporaryFailedAckIdsList() {
        temporaryFailedAckIds_.makeImmutable();
        return temporaryFailedAckIds_;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of temporaryFailedAckIds.
       */
      public int getTemporaryFailedAckIdsCount() {
        return temporaryFailedAckIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The temporaryFailedAckIds at the given index.
       */
      public java.lang.String getTemporaryFailedAckIds(int index) {
        return temporaryFailedAckIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the temporaryFailedAckIds at the given index.
       */
      public com.google.protobuf.ByteString getTemporaryFailedAckIdsBytes(int index) {
        return temporaryFailedAckIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The temporaryFailedAckIds to set.
       * @return This builder for chaining.
       */
      public Builder setTemporaryFailedAckIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTemporaryFailedAckIdsIsMutable();
        temporaryFailedAckIds_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The temporaryFailedAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addTemporaryFailedAckIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTemporaryFailedAckIdsIsMutable();
        temporaryFailedAckIds_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The temporaryFailedAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllTemporaryFailedAckIds(java.lang.Iterable<java.lang.String> values) {
        ensureTemporaryFailedAckIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, temporaryFailedAckIds_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTemporaryFailedAckIds() {
        temporaryFailedAckIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of acknowledgement IDs that failed processing with
       * temporary issues.
       * </pre>
       *
       * <code>
       * repeated string temporary_failed_ack_ids = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the temporaryFailedAckIds to add.
       * @return This builder for chaining.
       */
      public Builder addTemporaryFailedAckIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTemporaryFailedAckIdsIsMutable();
        temporaryFailedAckIds_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation)
    private static final com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation();
    }

    public static com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModifyAckDeadlineConfirmation> PARSER =
        new com.google.protobuf.AbstractParser<ModifyAckDeadlineConfirmation>() {
          @java.lang.Override
          public ModifyAckDeadlineConfirmation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ModifyAckDeadlineConfirmation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModifyAckDeadlineConfirmation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SubscriptionPropertiesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.StreamingPullResponse.SubscriptionProperties)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. True iff exactly once delivery is enabled for this
     * subscription.
     * </pre>
     *
     * <code>bool exactly_once_delivery_enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The exactlyOnceDeliveryEnabled.
     */
    boolean getExactlyOnceDeliveryEnabled();

    /**
     *
     *
     * <pre>
     * Optional. True iff message ordering is enabled for this subscription.
     * </pre>
     *
     * <code>bool message_ordering_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The messageOrderingEnabled.
     */
    boolean getMessageOrderingEnabled();
  }
  /**
   *
   *
   * <pre>
   * Subscription properties sent as part of the response.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.StreamingPullResponse.SubscriptionProperties}
   */
  public static final class SubscriptionProperties extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.StreamingPullResponse.SubscriptionProperties)
      SubscriptionPropertiesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SubscriptionProperties.newBuilder() to construct.
    private SubscriptionProperties(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SubscriptionProperties() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SubscriptionProperties();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullResponse_SubscriptionProperties_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullResponse_SubscriptionProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.class,
              com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.Builder.class);
    }

    public static final int EXACTLY_ONCE_DELIVERY_ENABLED_FIELD_NUMBER = 1;
    private boolean exactlyOnceDeliveryEnabled_ = false;
    /**
     *
     *
     * <pre>
     * Optional. True iff exactly once delivery is enabled for this
     * subscription.
     * </pre>
     *
     * <code>bool exactly_once_delivery_enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The exactlyOnceDeliveryEnabled.
     */
    @java.lang.Override
    public boolean getExactlyOnceDeliveryEnabled() {
      return exactlyOnceDeliveryEnabled_;
    }

    public static final int MESSAGE_ORDERING_ENABLED_FIELD_NUMBER = 2;
    private boolean messageOrderingEnabled_ = false;
    /**
     *
     *
     * <pre>
     * Optional. True iff message ordering is enabled for this subscription.
     * </pre>
     *
     * <code>bool message_ordering_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The messageOrderingEnabled.
     */
    @java.lang.Override
    public boolean getMessageOrderingEnabled() {
      return messageOrderingEnabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (exactlyOnceDeliveryEnabled_ != false) {
        output.writeBool(1, exactlyOnceDeliveryEnabled_);
      }
      if (messageOrderingEnabled_ != false) {
        output.writeBool(2, messageOrderingEnabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (exactlyOnceDeliveryEnabled_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(1, exactlyOnceDeliveryEnabled_);
      }
      if (messageOrderingEnabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, messageOrderingEnabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties other =
          (com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties) obj;

      if (getExactlyOnceDeliveryEnabled() != other.getExactlyOnceDeliveryEnabled()) return false;
      if (getMessageOrderingEnabled() != other.getMessageOrderingEnabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EXACTLY_ONCE_DELIVERY_ENABLED_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExactlyOnceDeliveryEnabled());
      hash = (37 * hash) + MESSAGE_ORDERING_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMessageOrderingEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Subscription properties sent as part of the response.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.StreamingPullResponse.SubscriptionProperties}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.StreamingPullResponse.SubscriptionProperties)
        com.google.pubsub.v1.StreamingPullResponse.SubscriptionPropertiesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_StreamingPullResponse_SubscriptionProperties_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_StreamingPullResponse_SubscriptionProperties_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.class,
                com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.Builder.class);
      }

      // Construct using
      // com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        exactlyOnceDeliveryEnabled_ = false;
        messageOrderingEnabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_StreamingPullResponse_SubscriptionProperties_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties build() {
        com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties buildPartial() {
        com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties result =
            new com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.exactlyOnceDeliveryEnabled_ = exactlyOnceDeliveryEnabled_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.messageOrderingEnabled_ = messageOrderingEnabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties) {
          return mergeFrom(
              (com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties other) {
        if (other
            == com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                .getDefaultInstance()) return this;
        if (other.getExactlyOnceDeliveryEnabled() != false) {
          setExactlyOnceDeliveryEnabled(other.getExactlyOnceDeliveryEnabled());
        }
        if (other.getMessageOrderingEnabled() != false) {
          setMessageOrderingEnabled(other.getMessageOrderingEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  exactlyOnceDeliveryEnabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  messageOrderingEnabled_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean exactlyOnceDeliveryEnabled_;
      /**
       *
       *
       * <pre>
       * Optional. True iff exactly once delivery is enabled for this
       * subscription.
       * </pre>
       *
       * <code>bool exactly_once_delivery_enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The exactlyOnceDeliveryEnabled.
       */
      @java.lang.Override
      public boolean getExactlyOnceDeliveryEnabled() {
        return exactlyOnceDeliveryEnabled_;
      }
      /**
       *
       *
       * <pre>
       * Optional. True iff exactly once delivery is enabled for this
       * subscription.
       * </pre>
       *
       * <code>bool exactly_once_delivery_enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The exactlyOnceDeliveryEnabled to set.
       * @return This builder for chaining.
       */
      public Builder setExactlyOnceDeliveryEnabled(boolean value) {

        exactlyOnceDeliveryEnabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. True iff exactly once delivery is enabled for this
       * subscription.
       * </pre>
       *
       * <code>bool exactly_once_delivery_enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExactlyOnceDeliveryEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        exactlyOnceDeliveryEnabled_ = false;
        onChanged();
        return this;
      }

      private boolean messageOrderingEnabled_;
      /**
       *
       *
       * <pre>
       * Optional. True iff message ordering is enabled for this subscription.
       * </pre>
       *
       * <code>bool message_ordering_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The messageOrderingEnabled.
       */
      @java.lang.Override
      public boolean getMessageOrderingEnabled() {
        return messageOrderingEnabled_;
      }
      /**
       *
       *
       * <pre>
       * Optional. True iff message ordering is enabled for this subscription.
       * </pre>
       *
       * <code>bool message_ordering_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The messageOrderingEnabled to set.
       * @return This builder for chaining.
       */
      public Builder setMessageOrderingEnabled(boolean value) {

        messageOrderingEnabled_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. True iff message ordering is enabled for this subscription.
       * </pre>
       *
       * <code>bool message_ordering_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMessageOrderingEnabled() {
        bitField0_ = (bitField0_ & ~0x00000002);
        messageOrderingEnabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.StreamingPullResponse.SubscriptionProperties)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.StreamingPullResponse.SubscriptionProperties)
    private static final com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties();
    }

    public static com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SubscriptionProperties> PARSER =
        new com.google.protobuf.AbstractParser<SubscriptionProperties>() {
          @java.lang.Override
          public SubscriptionProperties parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SubscriptionProperties> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SubscriptionProperties> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int RECEIVED_MESSAGES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.pubsub.v1.ReceivedMessage> receivedMessages_;
  /**
   *
   *
   * <pre>
   * Optional. Received Pub/Sub messages. This will not be empty.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.pubsub.v1.ReceivedMessage> getReceivedMessagesList() {
    return receivedMessages_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Received Pub/Sub messages. This will not be empty.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.pubsub.v1.ReceivedMessageOrBuilder>
      getReceivedMessagesOrBuilderList() {
    return receivedMessages_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Received Pub/Sub messages. This will not be empty.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getReceivedMessagesCount() {
    return receivedMessages_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Received Pub/Sub messages. This will not be empty.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.ReceivedMessage getReceivedMessages(int index) {
    return receivedMessages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Received Pub/Sub messages. This will not be empty.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.ReceivedMessageOrBuilder getReceivedMessagesOrBuilder(int index) {
    return receivedMessages_.get(index);
  }

  public static final int ACKNOWLEDGE_CONFIRMATION_FIELD_NUMBER = 5;
  private com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
      acknowledgeConfirmation_;
  /**
   *
   *
   * <pre>
   * Optional. This field will only be set if `enable_exactly_once_delivery` is
   * set to `true`.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the acknowledgeConfirmation field is set.
   */
  @java.lang.Override
  public boolean hasAcknowledgeConfirmation() {
    return acknowledgeConfirmation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. This field will only be set if `enable_exactly_once_delivery` is
   * set to `true`.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The acknowledgeConfirmation.
   */
  @java.lang.Override
  public com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
      getAcknowledgeConfirmation() {
    return acknowledgeConfirmation_ == null
        ? com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.getDefaultInstance()
        : acknowledgeConfirmation_;
  }
  /**
   *
   *
   * <pre>
   * Optional. This field will only be set if `enable_exactly_once_delivery` is
   * set to `true`.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmationOrBuilder
      getAcknowledgeConfirmationOrBuilder() {
    return acknowledgeConfirmation_ == null
        ? com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.getDefaultInstance()
        : acknowledgeConfirmation_;
  }

  public static final int MODIFY_ACK_DEADLINE_CONFIRMATION_FIELD_NUMBER = 3;
  private com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
      modifyAckDeadlineConfirmation_;
  /**
   *
   *
   * <pre>
   * Optional. This field will only be set if `enable_exactly_once_delivery` is
   * set to `true`.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the modifyAckDeadlineConfirmation field is set.
   */
  @java.lang.Override
  public boolean hasModifyAckDeadlineConfirmation() {
    return modifyAckDeadlineConfirmation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. This field will only be set if `enable_exactly_once_delivery` is
   * set to `true`.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The modifyAckDeadlineConfirmation.
   */
  @java.lang.Override
  public com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
      getModifyAckDeadlineConfirmation() {
    return modifyAckDeadlineConfirmation_ == null
        ? com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
            .getDefaultInstance()
        : modifyAckDeadlineConfirmation_;
  }
  /**
   *
   *
   * <pre>
   * Optional. This field will only be set if `enable_exactly_once_delivery` is
   * set to `true`.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmationOrBuilder
      getModifyAckDeadlineConfirmationOrBuilder() {
    return modifyAckDeadlineConfirmation_ == null
        ? com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
            .getDefaultInstance()
        : modifyAckDeadlineConfirmation_;
  }

  public static final int SUBSCRIPTION_PROPERTIES_FIELD_NUMBER = 4;
  private com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscriptionProperties_;
  /**
   *
   *
   * <pre>
   * Optional. Properties associated with this subscription.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the subscriptionProperties field is set.
   */
  @java.lang.Override
  public boolean hasSubscriptionProperties() {
    return subscriptionProperties_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Properties associated with this subscription.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The subscriptionProperties.
   */
  @java.lang.Override
  public com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
      getSubscriptionProperties() {
    return subscriptionProperties_ == null
        ? com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.getDefaultInstance()
        : subscriptionProperties_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Properties associated with this subscription.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.StreamingPullResponse.SubscriptionPropertiesOrBuilder
      getSubscriptionPropertiesOrBuilder() {
    return subscriptionProperties_ == null
        ? com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.getDefaultInstance()
        : subscriptionProperties_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < receivedMessages_.size(); i++) {
      output.writeMessage(1, receivedMessages_.get(i));
    }
    if (modifyAckDeadlineConfirmation_ != null) {
      output.writeMessage(3, getModifyAckDeadlineConfirmation());
    }
    if (subscriptionProperties_ != null) {
      output.writeMessage(4, getSubscriptionProperties());
    }
    if (acknowledgeConfirmation_ != null) {
      output.writeMessage(5, getAcknowledgeConfirmation());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < receivedMessages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, receivedMessages_.get(i));
    }
    if (modifyAckDeadlineConfirmation_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getModifyAckDeadlineConfirmation());
    }
    if (subscriptionProperties_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSubscriptionProperties());
    }
    if (acknowledgeConfirmation_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAcknowledgeConfirmation());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.StreamingPullResponse)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.StreamingPullResponse other =
        (com.google.pubsub.v1.StreamingPullResponse) obj;

    if (!getReceivedMessagesList().equals(other.getReceivedMessagesList())) return false;
    if (hasAcknowledgeConfirmation() != other.hasAcknowledgeConfirmation()) return false;
    if (hasAcknowledgeConfirmation()) {
      if (!getAcknowledgeConfirmation().equals(other.getAcknowledgeConfirmation())) return false;
    }
    if (hasModifyAckDeadlineConfirmation() != other.hasModifyAckDeadlineConfirmation())
      return false;
    if (hasModifyAckDeadlineConfirmation()) {
      if (!getModifyAckDeadlineConfirmation().equals(other.getModifyAckDeadlineConfirmation()))
        return false;
    }
    if (hasSubscriptionProperties() != other.hasSubscriptionProperties()) return false;
    if (hasSubscriptionProperties()) {
      if (!getSubscriptionProperties().equals(other.getSubscriptionProperties())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getReceivedMessagesCount() > 0) {
      hash = (37 * hash) + RECEIVED_MESSAGES_FIELD_NUMBER;
      hash = (53 * hash) + getReceivedMessagesList().hashCode();
    }
    if (hasAcknowledgeConfirmation()) {
      hash = (37 * hash) + ACKNOWLEDGE_CONFIRMATION_FIELD_NUMBER;
      hash = (53 * hash) + getAcknowledgeConfirmation().hashCode();
    }
    if (hasModifyAckDeadlineConfirmation()) {
      hash = (37 * hash) + MODIFY_ACK_DEADLINE_CONFIRMATION_FIELD_NUMBER;
      hash = (53 * hash) + getModifyAckDeadlineConfirmation().hashCode();
    }
    if (hasSubscriptionProperties()) {
      hash = (37 * hash) + SUBSCRIPTION_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getSubscriptionProperties().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.StreamingPullResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.StreamingPullResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response for the `StreamingPull` method. This response is used to stream
   * messages from the server to the client.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.StreamingPullResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.StreamingPullResponse)
      com.google.pubsub.v1.StreamingPullResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.StreamingPullResponse.class,
              com.google.pubsub.v1.StreamingPullResponse.Builder.class);
    }

    // Construct using com.google.pubsub.v1.StreamingPullResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (receivedMessagesBuilder_ == null) {
        receivedMessages_ = java.util.Collections.emptyList();
      } else {
        receivedMessages_ = null;
        receivedMessagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      acknowledgeConfirmation_ = null;
      if (acknowledgeConfirmationBuilder_ != null) {
        acknowledgeConfirmationBuilder_.dispose();
        acknowledgeConfirmationBuilder_ = null;
      }
      modifyAckDeadlineConfirmation_ = null;
      if (modifyAckDeadlineConfirmationBuilder_ != null) {
        modifyAckDeadlineConfirmationBuilder_.dispose();
        modifyAckDeadlineConfirmationBuilder_ = null;
      }
      subscriptionProperties_ = null;
      if (subscriptionPropertiesBuilder_ != null) {
        subscriptionPropertiesBuilder_.dispose();
        subscriptionPropertiesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullResponse_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.StreamingPullResponse getDefaultInstanceForType() {
      return com.google.pubsub.v1.StreamingPullResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.StreamingPullResponse build() {
      com.google.pubsub.v1.StreamingPullResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.StreamingPullResponse buildPartial() {
      com.google.pubsub.v1.StreamingPullResponse result =
          new com.google.pubsub.v1.StreamingPullResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.pubsub.v1.StreamingPullResponse result) {
      if (receivedMessagesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          receivedMessages_ = java.util.Collections.unmodifiableList(receivedMessages_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.receivedMessages_ = receivedMessages_;
      } else {
        result.receivedMessages_ = receivedMessagesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.pubsub.v1.StreamingPullResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.acknowledgeConfirmation_ =
            acknowledgeConfirmationBuilder_ == null
                ? acknowledgeConfirmation_
                : acknowledgeConfirmationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.modifyAckDeadlineConfirmation_ =
            modifyAckDeadlineConfirmationBuilder_ == null
                ? modifyAckDeadlineConfirmation_
                : modifyAckDeadlineConfirmationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.subscriptionProperties_ =
            subscriptionPropertiesBuilder_ == null
                ? subscriptionProperties_
                : subscriptionPropertiesBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.StreamingPullResponse) {
        return mergeFrom((com.google.pubsub.v1.StreamingPullResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.StreamingPullResponse other) {
      if (other == com.google.pubsub.v1.StreamingPullResponse.getDefaultInstance()) return this;
      if (receivedMessagesBuilder_ == null) {
        if (!other.receivedMessages_.isEmpty()) {
          if (receivedMessages_.isEmpty()) {
            receivedMessages_ = other.receivedMessages_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureReceivedMessagesIsMutable();
            receivedMessages_.addAll(other.receivedMessages_);
          }
          onChanged();
        }
      } else {
        if (!other.receivedMessages_.isEmpty()) {
          if (receivedMessagesBuilder_.isEmpty()) {
            receivedMessagesBuilder_.dispose();
            receivedMessagesBuilder_ = null;
            receivedMessages_ = other.receivedMessages_;
            bitField0_ = (bitField0_ & ~0x00000001);
            receivedMessagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getReceivedMessagesFieldBuilder()
                    : null;
          } else {
            receivedMessagesBuilder_.addAllMessages(other.receivedMessages_);
          }
        }
      }
      if (other.hasAcknowledgeConfirmation()) {
        mergeAcknowledgeConfirmation(other.getAcknowledgeConfirmation());
      }
      if (other.hasModifyAckDeadlineConfirmation()) {
        mergeModifyAckDeadlineConfirmation(other.getModifyAckDeadlineConfirmation());
      }
      if (other.hasSubscriptionProperties()) {
        mergeSubscriptionProperties(other.getSubscriptionProperties());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.pubsub.v1.ReceivedMessage m =
                    input.readMessage(
                        com.google.pubsub.v1.ReceivedMessage.parser(), extensionRegistry);
                if (receivedMessagesBuilder_ == null) {
                  ensureReceivedMessagesIsMutable();
                  receivedMessages_.add(m);
                } else {
                  receivedMessagesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 26:
              {
                input.readMessage(
                    getModifyAckDeadlineConfirmationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getSubscriptionPropertiesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getAcknowledgeConfirmationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.pubsub.v1.ReceivedMessage> receivedMessages_ =
        java.util.Collections.emptyList();

    private void ensureReceivedMessagesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        receivedMessages_ =
            new java.util.ArrayList<com.google.pubsub.v1.ReceivedMessage>(receivedMessages_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.pubsub.v1.ReceivedMessage,
            com.google.pubsub.v1.ReceivedMessage.Builder,
            com.google.pubsub.v1.ReceivedMessageOrBuilder>
        receivedMessagesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.pubsub.v1.ReceivedMessage> getReceivedMessagesList() {
      if (receivedMessagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(receivedMessages_);
      } else {
        return receivedMessagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getReceivedMessagesCount() {
      if (receivedMessagesBuilder_ == null) {
        return receivedMessages_.size();
      } else {
        return receivedMessagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.ReceivedMessage getReceivedMessages(int index) {
      if (receivedMessagesBuilder_ == null) {
        return receivedMessages_.get(index);
      } else {
        return receivedMessagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReceivedMessages(int index, com.google.pubsub.v1.ReceivedMessage value) {
      if (receivedMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReceivedMessagesIsMutable();
        receivedMessages_.set(index, value);
        onChanged();
      } else {
        receivedMessagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReceivedMessages(
        int index, com.google.pubsub.v1.ReceivedMessage.Builder builderForValue) {
      if (receivedMessagesBuilder_ == null) {
        ensureReceivedMessagesIsMutable();
        receivedMessages_.set(index, builderForValue.build());
        onChanged();
      } else {
        receivedMessagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addReceivedMessages(com.google.pubsub.v1.ReceivedMessage value) {
      if (receivedMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReceivedMessagesIsMutable();
        receivedMessages_.add(value);
        onChanged();
      } else {
        receivedMessagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addReceivedMessages(int index, com.google.pubsub.v1.ReceivedMessage value) {
      if (receivedMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReceivedMessagesIsMutable();
        receivedMessages_.add(index, value);
        onChanged();
      } else {
        receivedMessagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addReceivedMessages(
        com.google.pubsub.v1.ReceivedMessage.Builder builderForValue) {
      if (receivedMessagesBuilder_ == null) {
        ensureReceivedMessagesIsMutable();
        receivedMessages_.add(builderForValue.build());
        onChanged();
      } else {
        receivedMessagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addReceivedMessages(
        int index, com.google.pubsub.v1.ReceivedMessage.Builder builderForValue) {
      if (receivedMessagesBuilder_ == null) {
        ensureReceivedMessagesIsMutable();
        receivedMessages_.add(index, builderForValue.build());
        onChanged();
      } else {
        receivedMessagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllReceivedMessages(
        java.lang.Iterable<? extends com.google.pubsub.v1.ReceivedMessage> values) {
      if (receivedMessagesBuilder_ == null) {
        ensureReceivedMessagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, receivedMessages_);
        onChanged();
      } else {
        receivedMessagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearReceivedMessages() {
      if (receivedMessagesBuilder_ == null) {
        receivedMessages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        receivedMessagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeReceivedMessages(int index) {
      if (receivedMessagesBuilder_ == null) {
        ensureReceivedMessagesIsMutable();
        receivedMessages_.remove(index);
        onChanged();
      } else {
        receivedMessagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.ReceivedMessage.Builder getReceivedMessagesBuilder(int index) {
      return getReceivedMessagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.ReceivedMessageOrBuilder getReceivedMessagesOrBuilder(int index) {
      if (receivedMessagesBuilder_ == null) {
        return receivedMessages_.get(index);
      } else {
        return receivedMessagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.pubsub.v1.ReceivedMessageOrBuilder>
        getReceivedMessagesOrBuilderList() {
      if (receivedMessagesBuilder_ != null) {
        return receivedMessagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(receivedMessages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.ReceivedMessage.Builder addReceivedMessagesBuilder() {
      return getReceivedMessagesFieldBuilder()
          .addBuilder(com.google.pubsub.v1.ReceivedMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.ReceivedMessage.Builder addReceivedMessagesBuilder(int index) {
      return getReceivedMessagesFieldBuilder()
          .addBuilder(index, com.google.pubsub.v1.ReceivedMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Received Pub/Sub messages. This will not be empty.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.ReceivedMessage received_messages = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.pubsub.v1.ReceivedMessage.Builder>
        getReceivedMessagesBuilderList() {
      return getReceivedMessagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.pubsub.v1.ReceivedMessage,
            com.google.pubsub.v1.ReceivedMessage.Builder,
            com.google.pubsub.v1.ReceivedMessageOrBuilder>
        getReceivedMessagesFieldBuilder() {
      if (receivedMessagesBuilder_ == null) {
        receivedMessagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.pubsub.v1.ReceivedMessage,
                com.google.pubsub.v1.ReceivedMessage.Builder,
                com.google.pubsub.v1.ReceivedMessageOrBuilder>(
                receivedMessages_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        receivedMessages_ = null;
      }
      return receivedMessagesBuilder_;
    }

    private com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
        acknowledgeConfirmation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation,
            com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.Builder,
            com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmationOrBuilder>
        acknowledgeConfirmationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the acknowledgeConfirmation field is set.
     */
    public boolean hasAcknowledgeConfirmation() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The acknowledgeConfirmation.
     */
    public com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
        getAcknowledgeConfirmation() {
      if (acknowledgeConfirmationBuilder_ == null) {
        return acknowledgeConfirmation_ == null
            ? com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                .getDefaultInstance()
            : acknowledgeConfirmation_;
      } else {
        return acknowledgeConfirmationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAcknowledgeConfirmation(
        com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation value) {
      if (acknowledgeConfirmationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        acknowledgeConfirmation_ = value;
      } else {
        acknowledgeConfirmationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAcknowledgeConfirmation(
        com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.Builder
            builderForValue) {
      if (acknowledgeConfirmationBuilder_ == null) {
        acknowledgeConfirmation_ = builderForValue.build();
      } else {
        acknowledgeConfirmationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAcknowledgeConfirmation(
        com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation value) {
      if (acknowledgeConfirmationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && acknowledgeConfirmation_ != null
            && acknowledgeConfirmation_
                != com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                    .getDefaultInstance()) {
          getAcknowledgeConfirmationBuilder().mergeFrom(value);
        } else {
          acknowledgeConfirmation_ = value;
        }
      } else {
        acknowledgeConfirmationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAcknowledgeConfirmation() {
      bitField0_ = (bitField0_ & ~0x00000002);
      acknowledgeConfirmation_ = null;
      if (acknowledgeConfirmationBuilder_ != null) {
        acknowledgeConfirmationBuilder_.dispose();
        acknowledgeConfirmationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.Builder
        getAcknowledgeConfirmationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAcknowledgeConfirmationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmationOrBuilder
        getAcknowledgeConfirmationOrBuilder() {
      if (acknowledgeConfirmationBuilder_ != null) {
        return acknowledgeConfirmationBuilder_.getMessageOrBuilder();
      } else {
        return acknowledgeConfirmation_ == null
            ? com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                .getDefaultInstance()
            : acknowledgeConfirmation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation acknowledge_confirmation = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation,
            com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.Builder,
            com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmationOrBuilder>
        getAcknowledgeConfirmationFieldBuilder() {
      if (acknowledgeConfirmationBuilder_ == null) {
        acknowledgeConfirmationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation,
                com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.Builder,
                com.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmationOrBuilder>(
                getAcknowledgeConfirmation(), getParentForChildren(), isClean());
        acknowledgeConfirmation_ = null;
      }
      return acknowledgeConfirmationBuilder_;
    }

    private com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        modifyAckDeadlineConfirmation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation,
            com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.Builder,
            com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmationOrBuilder>
        modifyAckDeadlineConfirmationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the modifyAckDeadlineConfirmation field is set.
     */
    public boolean hasModifyAckDeadlineConfirmation() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The modifyAckDeadlineConfirmation.
     */
    public com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
        getModifyAckDeadlineConfirmation() {
      if (modifyAckDeadlineConfirmationBuilder_ == null) {
        return modifyAckDeadlineConfirmation_ == null
            ? com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                .getDefaultInstance()
            : modifyAckDeadlineConfirmation_;
      } else {
        return modifyAckDeadlineConfirmationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setModifyAckDeadlineConfirmation(
        com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation value) {
      if (modifyAckDeadlineConfirmationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modifyAckDeadlineConfirmation_ = value;
      } else {
        modifyAckDeadlineConfirmationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setModifyAckDeadlineConfirmation(
        com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.Builder
            builderForValue) {
      if (modifyAckDeadlineConfirmationBuilder_ == null) {
        modifyAckDeadlineConfirmation_ = builderForValue.build();
      } else {
        modifyAckDeadlineConfirmationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeModifyAckDeadlineConfirmation(
        com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation value) {
      if (modifyAckDeadlineConfirmationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && modifyAckDeadlineConfirmation_ != null
            && modifyAckDeadlineConfirmation_
                != com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                    .getDefaultInstance()) {
          getModifyAckDeadlineConfirmationBuilder().mergeFrom(value);
        } else {
          modifyAckDeadlineConfirmation_ = value;
        }
      } else {
        modifyAckDeadlineConfirmationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearModifyAckDeadlineConfirmation() {
      bitField0_ = (bitField0_ & ~0x00000004);
      modifyAckDeadlineConfirmation_ = null;
      if (modifyAckDeadlineConfirmationBuilder_ != null) {
        modifyAckDeadlineConfirmationBuilder_.dispose();
        modifyAckDeadlineConfirmationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.Builder
        getModifyAckDeadlineConfirmationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getModifyAckDeadlineConfirmationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmationOrBuilder
        getModifyAckDeadlineConfirmationOrBuilder() {
      if (modifyAckDeadlineConfirmationBuilder_ != null) {
        return modifyAckDeadlineConfirmationBuilder_.getMessageOrBuilder();
      } else {
        return modifyAckDeadlineConfirmation_ == null
            ? com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                .getDefaultInstance()
            : modifyAckDeadlineConfirmation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field will only be set if `enable_exactly_once_delivery` is
     * set to `true`.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation modify_ack_deadline_confirmation = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation,
            com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.Builder,
            com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmationOrBuilder>
        getModifyAckDeadlineConfirmationFieldBuilder() {
      if (modifyAckDeadlineConfirmationBuilder_ == null) {
        modifyAckDeadlineConfirmationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation,
                com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.Builder,
                com.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmationOrBuilder>(
                getModifyAckDeadlineConfirmation(), getParentForChildren(), isClean());
        modifyAckDeadlineConfirmation_ = null;
      }
      return modifyAckDeadlineConfirmationBuilder_;
    }

    private com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
        subscriptionProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties,
            com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.Builder,
            com.google.pubsub.v1.StreamingPullResponse.SubscriptionPropertiesOrBuilder>
        subscriptionPropertiesBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Properties associated with this subscription.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the subscriptionProperties field is set.
     */
    public boolean hasSubscriptionProperties() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties associated with this subscription.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The subscriptionProperties.
     */
    public com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
        getSubscriptionProperties() {
      if (subscriptionPropertiesBuilder_ == null) {
        return subscriptionProperties_ == null
            ? com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.getDefaultInstance()
            : subscriptionProperties_;
      } else {
        return subscriptionPropertiesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties associated with this subscription.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSubscriptionProperties(
        com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties value) {
      if (subscriptionPropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        subscriptionProperties_ = value;
      } else {
        subscriptionPropertiesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties associated with this subscription.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSubscriptionProperties(
        com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.Builder builderForValue) {
      if (subscriptionPropertiesBuilder_ == null) {
        subscriptionProperties_ = builderForValue.build();
      } else {
        subscriptionPropertiesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties associated with this subscription.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSubscriptionProperties(
        com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties value) {
      if (subscriptionPropertiesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && subscriptionProperties_ != null
            && subscriptionProperties_
                != com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                    .getDefaultInstance()) {
          getSubscriptionPropertiesBuilder().mergeFrom(value);
        } else {
          subscriptionProperties_ = value;
        }
      } else {
        subscriptionPropertiesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties associated with this subscription.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSubscriptionProperties() {
      bitField0_ = (bitField0_ & ~0x00000008);
      subscriptionProperties_ = null;
      if (subscriptionPropertiesBuilder_ != null) {
        subscriptionPropertiesBuilder_.dispose();
        subscriptionPropertiesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties associated with this subscription.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.Builder
        getSubscriptionPropertiesBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getSubscriptionPropertiesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties associated with this subscription.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.StreamingPullResponse.SubscriptionPropertiesOrBuilder
        getSubscriptionPropertiesOrBuilder() {
      if (subscriptionPropertiesBuilder_ != null) {
        return subscriptionPropertiesBuilder_.getMessageOrBuilder();
      } else {
        return subscriptionProperties_ == null
            ? com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.getDefaultInstance()
            : subscriptionProperties_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties associated with this subscription.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.StreamingPullResponse.SubscriptionProperties subscription_properties = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties,
            com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.Builder,
            com.google.pubsub.v1.StreamingPullResponse.SubscriptionPropertiesOrBuilder>
        getSubscriptionPropertiesFieldBuilder() {
      if (subscriptionPropertiesBuilder_ == null) {
        subscriptionPropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties,
                com.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.Builder,
                com.google.pubsub.v1.StreamingPullResponse.SubscriptionPropertiesOrBuilder>(
                getSubscriptionProperties(), getParentForChildren(), isClean());
        subscriptionProperties_ = null;
      }
      return subscriptionPropertiesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.StreamingPullResponse)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.StreamingPullResponse)
  private static final com.google.pubsub.v1.StreamingPullResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.StreamingPullResponse();
  }

  public static com.google.pubsub.v1.StreamingPullResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingPullResponse> PARSER =
      new com.google.protobuf.AbstractParser<StreamingPullResponse>() {
        @java.lang.Override
        public StreamingPullResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingPullResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingPullResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.StreamingPullResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
