/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BigQueryExportName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_EXPORT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/bigQueryExports/{export}");
    private static final PathTemplate FOLDER_EXPORT = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/bigQueryExports/{export}");
    private static final PathTemplate PROJECT_EXPORT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/bigQueryExports/{export}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String export;
    private final String folder;
    private final String project;

    @Deprecated
    protected BigQueryExportName() {
        this.organization = null;
        this.export = null;
        this.folder = null;
        this.project = null;
    }

    private BigQueryExportName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.export = (String)Preconditions.checkNotNull((Object)builder.getExport());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_EXPORT;
    }

    private BigQueryExportName(FolderExportBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.export = (String)Preconditions.checkNotNull((Object)builder.getExport());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_EXPORT;
    }

    private BigQueryExportName(ProjectExportBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.export = (String)Preconditions.checkNotNull((Object)builder.getExport());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_EXPORT;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getExport() {
        return this.export;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newOrganizationExportBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderExportBuilder newFolderExportBuilder() {
        return new FolderExportBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectExportBuilder newProjectExportBuilder() {
        return new ProjectExportBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BigQueryExportName of(String organization, String export) {
        return BigQueryExportName.newBuilder().setOrganization(organization).setExport(export).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static BigQueryExportName ofOrganizationExportName(String organization, String export) {
        return BigQueryExportName.newBuilder().setOrganization(organization).setExport(export).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static BigQueryExportName ofFolderExportName(String folder, String export) {
        return BigQueryExportName.newFolderExportBuilder().setFolder(folder).setExport(export).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static BigQueryExportName ofProjectExportName(String project, String export) {
        return BigQueryExportName.newProjectExportBuilder().setProject(project).setExport(export).build();
    }

    public static String format(String organization, String export) {
        return BigQueryExportName.newBuilder().setOrganization(organization).setExport(export).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationExportName(String organization, String export) {
        return BigQueryExportName.newBuilder().setOrganization(organization).setExport(export).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderExportName(String folder, String export) {
        return BigQueryExportName.newFolderExportBuilder().setFolder(folder).setExport(export).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectExportName(String project, String export) {
        return BigQueryExportName.newProjectExportBuilder().setProject(project).setExport(export).build().toString();
    }

    public static BigQueryExportName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_EXPORT.matches(formattedString)) {
            Map matchMap = ORGANIZATION_EXPORT.match(formattedString);
            return BigQueryExportName.ofOrganizationExportName((String)matchMap.get("organization"), (String)matchMap.get("export"));
        }
        if (FOLDER_EXPORT.matches(formattedString)) {
            Map matchMap = FOLDER_EXPORT.match(formattedString);
            return BigQueryExportName.ofFolderExportName((String)matchMap.get("folder"), (String)matchMap.get("export"));
        }
        if (PROJECT_EXPORT.matches(formattedString)) {
            Map matchMap = PROJECT_EXPORT.match(formattedString);
            return BigQueryExportName.ofProjectExportName((String)matchMap.get("project"), (String)matchMap.get("export"));
        }
        throw new ValidationException("BigQueryExportName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<BigQueryExportName> parseList(List<String> formattedStrings) {
        ArrayList<BigQueryExportName> list = new ArrayList<BigQueryExportName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BigQueryExportName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BigQueryExportName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BigQueryExportName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_EXPORT.matches(formattedString) || FOLDER_EXPORT.matches(formattedString) || PROJECT_EXPORT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BigQueryExportName bigQueryExportName = this;
            synchronized (bigQueryExportName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.export != null) {
                        fieldMapBuilder.put((Object)"export", (Object)this.export);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            BigQueryExportName that = (BigQueryExportName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.export, that.export) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.export);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectExportBuilder {
        private String project;
        private String export;

        protected ProjectExportBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getExport() {
            return this.export;
        }

        public ProjectExportBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectExportBuilder setExport(String export) {
            this.export = export;
            return this;
        }

        public BigQueryExportName build() {
            return new BigQueryExportName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderExportBuilder {
        private String folder;
        private String export;

        protected FolderExportBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getExport() {
            return this.export;
        }

        public FolderExportBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderExportBuilder setExport(String export) {
            this.export = export;
            return this;
        }

        public BigQueryExportName build() {
            return new BigQueryExportName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String export;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getExport() {
            return this.export;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setExport(String export) {
            this.export = export;
            return this;
        }

        private Builder(BigQueryExportName bigQueryExportName) {
            Preconditions.checkArgument((boolean)Objects.equals(bigQueryExportName.pathTemplate, ORGANIZATION_EXPORT), (Object)"toBuilder is only supported when BigQueryExportName has the pattern of organizations/{organization}/bigQueryExports/{export}");
            this.organization = bigQueryExportName.organization;
            this.export = bigQueryExportName.export;
        }

        public BigQueryExportName build() {
            return new BigQueryExportName(this);
        }
    }
}

