/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1p1beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SourceName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_SOURCE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/sources/{source}");
    private static final PathTemplate FOLDER_SOURCE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/sources/{source}");
    private static final PathTemplate PROJECT_SOURCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/sources/{source}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String source;
    private final String folder;
    private final String project;

    @Deprecated
    protected SourceName() {
        this.organization = null;
        this.source = null;
        this.folder = null;
        this.project = null;
    }

    private SourceName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_SOURCE;
    }

    private SourceName(FolderSourceBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_SOURCE;
    }

    private SourceName(ProjectSourceBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_SOURCE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getSource() {
        return this.source;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newOrganizationSourceBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderSourceBuilder newFolderSourceBuilder() {
        return new FolderSourceBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectSourceBuilder newProjectSourceBuilder() {
        return new ProjectSourceBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SourceName of(String organization, String source) {
        return SourceName.newBuilder().setOrganization(organization).setSource(source).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SourceName ofOrganizationSourceName(String organization, String source) {
        return SourceName.newBuilder().setOrganization(organization).setSource(source).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SourceName ofFolderSourceName(String folder, String source) {
        return SourceName.newFolderSourceBuilder().setFolder(folder).setSource(source).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SourceName ofProjectSourceName(String project, String source) {
        return SourceName.newProjectSourceBuilder().setProject(project).setSource(source).build();
    }

    public static String format(String organization, String source) {
        return SourceName.newBuilder().setOrganization(organization).setSource(source).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationSourceName(String organization, String source) {
        return SourceName.newBuilder().setOrganization(organization).setSource(source).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderSourceName(String folder, String source) {
        return SourceName.newFolderSourceBuilder().setFolder(folder).setSource(source).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectSourceName(String project, String source) {
        return SourceName.newProjectSourceBuilder().setProject(project).setSource(source).build().toString();
    }

    public static SourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_SOURCE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SOURCE.match(formattedString);
            return SourceName.ofOrganizationSourceName((String)matchMap.get("organization"), (String)matchMap.get("source"));
        }
        if (FOLDER_SOURCE.matches(formattedString)) {
            Map matchMap = FOLDER_SOURCE.match(formattedString);
            return SourceName.ofFolderSourceName((String)matchMap.get("folder"), (String)matchMap.get("source"));
        }
        if (PROJECT_SOURCE.matches(formattedString)) {
            Map matchMap = PROJECT_SOURCE.match(formattedString);
            return SourceName.ofProjectSourceName((String)matchMap.get("project"), (String)matchMap.get("source"));
        }
        throw new ValidationException("SourceName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SourceName> parseList(List<String> formattedStrings) {
        ArrayList<SourceName> list = new ArrayList<SourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_SOURCE.matches(formattedString) || FOLDER_SOURCE.matches(formattedString) || PROJECT_SOURCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SourceName sourceName = this;
            synchronized (sourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SourceName that = (SourceName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.source, that.source) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectSourceBuilder {
        private String project;
        private String source;

        protected ProjectSourceBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSource() {
            return this.source;
        }

        public ProjectSourceBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectSourceBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public SourceName build() {
            return new SourceName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderSourceBuilder {
        private String folder;
        private String source;

        protected FolderSourceBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getSource() {
            return this.source;
        }

        public FolderSourceBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderSourceBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public SourceName build() {
            return new SourceName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String source;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        private Builder(SourceName sourceName) {
            Preconditions.checkArgument((boolean)Objects.equals(sourceName.pathTemplate, ORGANIZATION_SOURCE), (Object)"toBuilder is only supported when SourceName has the pattern of organizations/{organization}/sources/{source}");
            this.organization = sourceName.organization;
            this.source = sourceName.source;
        }

        public SourceName build() {
            return new SourceName(this);
        }
    }
}

