/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/mutation.proto

// Protobuf Java Version: 3.25.5
package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * A modification to one or more Cloud Spanner rows.  Mutations can be
 * applied to a Cloud Spanner database by sending them in a
 * [Commit][google.spanner.v1.Spanner.Commit] call.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.Mutation}
 */
public final class Mutation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.Mutation)
    MutationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Mutation.newBuilder() to construct.
  private Mutation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Mutation() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Mutation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.MutationProto
        .internal_static_google_spanner_v1_Mutation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.MutationProto
        .internal_static_google_spanner_v1_Mutation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.Mutation.class, com.google.spanner.v1.Mutation.Builder.class);
  }

  public interface WriteOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.Mutation.Write)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The table whose rows will be written.
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The table.
     */
    java.lang.String getTable();
    /**
     *
     *
     * <pre>
     * Required. The table whose rows will be written.
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for table.
     */
    com.google.protobuf.ByteString getTableBytes();

    /**
     *
     *
     * <pre>
     * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
     *
     * The list of columns must contain enough columns to allow
     * Cloud Spanner to derive values for all primary key columns in the
     * row(s) to be modified.
     * </pre>
     *
     * <code>repeated string columns = 2;</code>
     *
     * @return A list containing the columns.
     */
    java.util.List<java.lang.String> getColumnsList();
    /**
     *
     *
     * <pre>
     * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
     *
     * The list of columns must contain enough columns to allow
     * Cloud Spanner to derive values for all primary key columns in the
     * row(s) to be modified.
     * </pre>
     *
     * <code>repeated string columns = 2;</code>
     *
     * @return The count of columns.
     */
    int getColumnsCount();
    /**
     *
     *
     * <pre>
     * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
     *
     * The list of columns must contain enough columns to allow
     * Cloud Spanner to derive values for all primary key columns in the
     * row(s) to be modified.
     * </pre>
     *
     * <code>repeated string columns = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The columns at the given index.
     */
    java.lang.String getColumns(int index);
    /**
     *
     *
     * <pre>
     * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
     *
     * The list of columns must contain enough columns to allow
     * Cloud Spanner to derive values for all primary key columns in the
     * row(s) to be modified.
     * </pre>
     *
     * <code>repeated string columns = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the columns at the given index.
     */
    com.google.protobuf.ByteString getColumnsBytes(int index);

    /**
     *
     *
     * <pre>
     * The values to be written. `values` can contain more than one
     * list of values. If it does, then multiple rows are written, one
     * for each entry in `values`. Each list in `values` must have
     * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
     * above. Sending multiple lists is equivalent to sending multiple
     * `Mutation`s, each containing one `values` entry and repeating
     * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
     * encoded as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue values = 3;</code>
     */
    java.util.List<com.google.protobuf.ListValue> getValuesList();
    /**
     *
     *
     * <pre>
     * The values to be written. `values` can contain more than one
     * list of values. If it does, then multiple rows are written, one
     * for each entry in `values`. Each list in `values` must have
     * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
     * above. Sending multiple lists is equivalent to sending multiple
     * `Mutation`s, each containing one `values` entry and repeating
     * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
     * encoded as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue values = 3;</code>
     */
    com.google.protobuf.ListValue getValues(int index);
    /**
     *
     *
     * <pre>
     * The values to be written. `values` can contain more than one
     * list of values. If it does, then multiple rows are written, one
     * for each entry in `values`. Each list in `values` must have
     * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
     * above. Sending multiple lists is equivalent to sending multiple
     * `Mutation`s, each containing one `values` entry and repeating
     * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
     * encoded as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue values = 3;</code>
     */
    int getValuesCount();
    /**
     *
     *
     * <pre>
     * The values to be written. `values` can contain more than one
     * list of values. If it does, then multiple rows are written, one
     * for each entry in `values`. Each list in `values` must have
     * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
     * above. Sending multiple lists is equivalent to sending multiple
     * `Mutation`s, each containing one `values` entry and repeating
     * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
     * encoded as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue values = 3;</code>
     */
    java.util.List<? extends com.google.protobuf.ListValueOrBuilder> getValuesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The values to be written. `values` can contain more than one
     * list of values. If it does, then multiple rows are written, one
     * for each entry in `values`. Each list in `values` must have
     * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
     * above. Sending multiple lists is equivalent to sending multiple
     * `Mutation`s, each containing one `values` entry and repeating
     * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
     * encoded as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue values = 3;</code>
     */
    com.google.protobuf.ListValueOrBuilder getValuesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Arguments to [insert][google.spanner.v1.Mutation.insert], [update][google.spanner.v1.Mutation.update], [insert_or_update][google.spanner.v1.Mutation.insert_or_update], and
   * [replace][google.spanner.v1.Mutation.replace] operations.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.Mutation.Write}
   */
  public static final class Write extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.Mutation.Write)
      WriteOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Write.newBuilder() to construct.
    private Write(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Write() {
      table_ = "";
      columns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      values_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Write();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.MutationProto
          .internal_static_google_spanner_v1_Mutation_Write_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.MutationProto
          .internal_static_google_spanner_v1_Mutation_Write_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.Mutation.Write.class,
              com.google.spanner.v1.Mutation.Write.Builder.class);
    }

    public static final int TABLE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object table_ = "";
    /**
     *
     *
     * <pre>
     * Required. The table whose rows will be written.
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The table.
     */
    @java.lang.Override
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The table whose rows will be written.
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for table.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COLUMNS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList columns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
     *
     * The list of columns must contain enough columns to allow
     * Cloud Spanner to derive values for all primary key columns in the
     * row(s) to be modified.
     * </pre>
     *
     * <code>repeated string columns = 2;</code>
     *
     * @return A list containing the columns.
     */
    public com.google.protobuf.ProtocolStringList getColumnsList() {
      return columns_;
    }
    /**
     *
     *
     * <pre>
     * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
     *
     * The list of columns must contain enough columns to allow
     * Cloud Spanner to derive values for all primary key columns in the
     * row(s) to be modified.
     * </pre>
     *
     * <code>repeated string columns = 2;</code>
     *
     * @return The count of columns.
     */
    public int getColumnsCount() {
      return columns_.size();
    }
    /**
     *
     *
     * <pre>
     * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
     *
     * The list of columns must contain enough columns to allow
     * Cloud Spanner to derive values for all primary key columns in the
     * row(s) to be modified.
     * </pre>
     *
     * <code>repeated string columns = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The columns at the given index.
     */
    public java.lang.String getColumns(int index) {
      return columns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
     *
     * The list of columns must contain enough columns to allow
     * Cloud Spanner to derive values for all primary key columns in the
     * row(s) to be modified.
     * </pre>
     *
     * <code>repeated string columns = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the columns at the given index.
     */
    public com.google.protobuf.ByteString getColumnsBytes(int index) {
      return columns_.getByteString(index);
    }

    public static final int VALUES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.protobuf.ListValue> values_;
    /**
     *
     *
     * <pre>
     * The values to be written. `values` can contain more than one
     * list of values. If it does, then multiple rows are written, one
     * for each entry in `values`. Each list in `values` must have
     * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
     * above. Sending multiple lists is equivalent to sending multiple
     * `Mutation`s, each containing one `values` entry and repeating
     * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
     * encoded as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue values = 3;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.protobuf.ListValue> getValuesList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * The values to be written. `values` can contain more than one
     * list of values. If it does, then multiple rows are written, one
     * for each entry in `values`. Each list in `values` must have
     * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
     * above. Sending multiple lists is equivalent to sending multiple
     * `Mutation`s, each containing one `values` entry and repeating
     * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
     * encoded as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue values = 3;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.protobuf.ListValueOrBuilder>
        getValuesOrBuilderList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * The values to be written. `values` can contain more than one
     * list of values. If it does, then multiple rows are written, one
     * for each entry in `values`. Each list in `values` must have
     * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
     * above. Sending multiple lists is equivalent to sending multiple
     * `Mutation`s, each containing one `values` entry and repeating
     * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
     * encoded as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue values = 3;</code>
     */
    @java.lang.Override
    public int getValuesCount() {
      return values_.size();
    }
    /**
     *
     *
     * <pre>
     * The values to be written. `values` can contain more than one
     * list of values. If it does, then multiple rows are written, one
     * for each entry in `values`. Each list in `values` must have
     * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
     * above. Sending multiple lists is equivalent to sending multiple
     * `Mutation`s, each containing one `values` entry and repeating
     * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
     * encoded as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue values = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.ListValue getValues(int index) {
      return values_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The values to be written. `values` can contain more than one
     * list of values. If it does, then multiple rows are written, one
     * for each entry in `values`. Each list in `values` must have
     * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
     * above. Sending multiple lists is equivalent to sending multiple
     * `Mutation`s, each containing one `values` entry and repeating
     * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
     * encoded as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue values = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.ListValueOrBuilder getValuesOrBuilder(int index) {
      return values_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, table_);
      }
      for (int i = 0; i < columns_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, columns_.getRaw(i));
      }
      for (int i = 0; i < values_.size(); i++) {
        output.writeMessage(3, values_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, table_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < columns_.size(); i++) {
          dataSize += computeStringSizeNoTag(columns_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getColumnsList().size();
      }
      for (int i = 0; i < values_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, values_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.Mutation.Write)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.Mutation.Write other = (com.google.spanner.v1.Mutation.Write) obj;

      if (!getTable().equals(other.getTable())) return false;
      if (!getColumnsList().equals(other.getColumnsList())) return false;
      if (!getValuesList().equals(other.getValuesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getTable().hashCode();
      if (getColumnsCount() > 0) {
        hash = (37 * hash) + COLUMNS_FIELD_NUMBER;
        hash = (53 * hash) + getColumnsList().hashCode();
      }
      if (getValuesCount() > 0) {
        hash = (37 * hash) + VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getValuesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.Mutation.Write parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.Mutation.Write parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.Mutation.Write parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.Mutation.Write parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.Mutation.Write parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.Mutation.Write parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.Mutation.Write parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.Mutation.Write parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.Mutation.Write parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.Mutation.Write parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.Mutation.Write parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.Mutation.Write parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.spanner.v1.Mutation.Write prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Arguments to [insert][google.spanner.v1.Mutation.insert], [update][google.spanner.v1.Mutation.update], [insert_or_update][google.spanner.v1.Mutation.insert_or_update], and
     * [replace][google.spanner.v1.Mutation.replace] operations.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.Mutation.Write}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.Mutation.Write)
        com.google.spanner.v1.Mutation.WriteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.MutationProto
            .internal_static_google_spanner_v1_Mutation_Write_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.MutationProto
            .internal_static_google_spanner_v1_Mutation_Write_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.Mutation.Write.class,
                com.google.spanner.v1.Mutation.Write.Builder.class);
      }

      // Construct using com.google.spanner.v1.Mutation.Write.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        table_ = "";
        columns_ = com.google.protobuf.LazyStringArrayList.emptyList();
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
        } else {
          values_ = null;
          valuesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.MutationProto
            .internal_static_google_spanner_v1_Mutation_Write_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.Mutation.Write getDefaultInstanceForType() {
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.Mutation.Write build() {
        com.google.spanner.v1.Mutation.Write result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.Mutation.Write buildPartial() {
        com.google.spanner.v1.Mutation.Write result =
            new com.google.spanner.v1.Mutation.Write(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.google.spanner.v1.Mutation.Write result) {
        if (valuesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            values_ = java.util.Collections.unmodifiableList(values_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.values_ = values_;
        } else {
          result.values_ = valuesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.spanner.v1.Mutation.Write result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.table_ = table_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          columns_.makeImmutable();
          result.columns_ = columns_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.Mutation.Write) {
          return mergeFrom((com.google.spanner.v1.Mutation.Write) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.Mutation.Write other) {
        if (other == com.google.spanner.v1.Mutation.Write.getDefaultInstance()) return this;
        if (!other.getTable().isEmpty()) {
          table_ = other.table_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.columns_.isEmpty()) {
          if (columns_.isEmpty()) {
            columns_ = other.columns_;
            bitField0_ |= 0x00000002;
          } else {
            ensureColumnsIsMutable();
            columns_.addAll(other.columns_);
          }
          onChanged();
        }
        if (valuesBuilder_ == null) {
          if (!other.values_.isEmpty()) {
            if (values_.isEmpty()) {
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureValuesIsMutable();
              values_.addAll(other.values_);
            }
            onChanged();
          }
        } else {
          if (!other.values_.isEmpty()) {
            if (valuesBuilder_.isEmpty()) {
              valuesBuilder_.dispose();
              valuesBuilder_ = null;
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000004);
              valuesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getValuesFieldBuilder()
                      : null;
            } else {
              valuesBuilder_.addAllMessages(other.values_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  table_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureColumnsIsMutable();
                  columns_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  com.google.protobuf.ListValue m =
                      input.readMessage(com.google.protobuf.ListValue.parser(), extensionRegistry);
                  if (valuesBuilder_ == null) {
                    ensureValuesIsMutable();
                    values_.add(m);
                  } else {
                    valuesBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object table_ = "";
      /**
       *
       *
       * <pre>
       * Required. The table whose rows will be written.
       * </pre>
       *
       * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The table.
       */
      public java.lang.String getTable() {
        java.lang.Object ref = table_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          table_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The table whose rows will be written.
       * </pre>
       *
       * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for table.
       */
      public com.google.protobuf.ByteString getTableBytes() {
        java.lang.Object ref = table_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          table_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The table whose rows will be written.
       * </pre>
       *
       * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The table to set.
       * @return This builder for chaining.
       */
      public Builder setTable(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        table_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The table whose rows will be written.
       * </pre>
       *
       * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTable() {
        table_ = getDefaultInstance().getTable();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The table whose rows will be written.
       * </pre>
       *
       * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for table to set.
       * @return This builder for chaining.
       */
      public Builder setTableBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        table_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList columns_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureColumnsIsMutable() {
        if (!columns_.isModifiable()) {
          columns_ = new com.google.protobuf.LazyStringArrayList(columns_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
       *
       * The list of columns must contain enough columns to allow
       * Cloud Spanner to derive values for all primary key columns in the
       * row(s) to be modified.
       * </pre>
       *
       * <code>repeated string columns = 2;</code>
       *
       * @return A list containing the columns.
       */
      public com.google.protobuf.ProtocolStringList getColumnsList() {
        columns_.makeImmutable();
        return columns_;
      }
      /**
       *
       *
       * <pre>
       * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
       *
       * The list of columns must contain enough columns to allow
       * Cloud Spanner to derive values for all primary key columns in the
       * row(s) to be modified.
       * </pre>
       *
       * <code>repeated string columns = 2;</code>
       *
       * @return The count of columns.
       */
      public int getColumnsCount() {
        return columns_.size();
      }
      /**
       *
       *
       * <pre>
       * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
       *
       * The list of columns must contain enough columns to allow
       * Cloud Spanner to derive values for all primary key columns in the
       * row(s) to be modified.
       * </pre>
       *
       * <code>repeated string columns = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The columns at the given index.
       */
      public java.lang.String getColumns(int index) {
        return columns_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
       *
       * The list of columns must contain enough columns to allow
       * Cloud Spanner to derive values for all primary key columns in the
       * row(s) to be modified.
       * </pre>
       *
       * <code>repeated string columns = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the columns at the given index.
       */
      public com.google.protobuf.ByteString getColumnsBytes(int index) {
        return columns_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
       *
       * The list of columns must contain enough columns to allow
       * Cloud Spanner to derive values for all primary key columns in the
       * row(s) to be modified.
       * </pre>
       *
       * <code>repeated string columns = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The columns to set.
       * @return This builder for chaining.
       */
      public Builder setColumns(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureColumnsIsMutable();
        columns_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
       *
       * The list of columns must contain enough columns to allow
       * Cloud Spanner to derive values for all primary key columns in the
       * row(s) to be modified.
       * </pre>
       *
       * <code>repeated string columns = 2;</code>
       *
       * @param value The columns to add.
       * @return This builder for chaining.
       */
      public Builder addColumns(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureColumnsIsMutable();
        columns_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
       *
       * The list of columns must contain enough columns to allow
       * Cloud Spanner to derive values for all primary key columns in the
       * row(s) to be modified.
       * </pre>
       *
       * <code>repeated string columns = 2;</code>
       *
       * @param values The columns to add.
       * @return This builder for chaining.
       */
      public Builder addAllColumns(java.lang.Iterable<java.lang.String> values) {
        ensureColumnsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, columns_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
       *
       * The list of columns must contain enough columns to allow
       * Cloud Spanner to derive values for all primary key columns in the
       * row(s) to be modified.
       * </pre>
       *
       * <code>repeated string columns = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearColumns() {
        columns_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
       *
       * The list of columns must contain enough columns to allow
       * Cloud Spanner to derive values for all primary key columns in the
       * row(s) to be modified.
       * </pre>
       *
       * <code>repeated string columns = 2;</code>
       *
       * @param value The bytes of the columns to add.
       * @return This builder for chaining.
       */
      public Builder addColumnsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureColumnsIsMutable();
        columns_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.util.List<com.google.protobuf.ListValue> values_ =
          java.util.Collections.emptyList();

      private void ensureValuesIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          values_ = new java.util.ArrayList<com.google.protobuf.ListValue>(values_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.protobuf.ListValue,
              com.google.protobuf.ListValue.Builder,
              com.google.protobuf.ListValueOrBuilder>
          valuesBuilder_;

      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public java.util.List<com.google.protobuf.ListValue> getValuesList() {
        if (valuesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(values_);
        } else {
          return valuesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public int getValuesCount() {
        if (valuesBuilder_ == null) {
          return values_.size();
        } else {
          return valuesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public com.google.protobuf.ListValue getValues(int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public Builder setValues(int index, com.google.protobuf.ListValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.set(index, value);
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public Builder setValues(int index, com.google.protobuf.ListValue.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.set(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public Builder addValues(com.google.protobuf.ListValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public Builder addValues(int index, com.google.protobuf.ListValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(index, value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public Builder addValues(com.google.protobuf.ListValue.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public Builder addValues(int index, com.google.protobuf.ListValue.Builder builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public Builder addAllValues(
          java.lang.Iterable<? extends com.google.protobuf.ListValue> values) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
          onChanged();
        } else {
          valuesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public Builder clearValues() {
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          valuesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public Builder removeValues(int index) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.remove(index);
          onChanged();
        } else {
          valuesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public com.google.protobuf.ListValue.Builder getValuesBuilder(int index) {
        return getValuesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public com.google.protobuf.ListValueOrBuilder getValuesOrBuilder(int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public java.util.List<? extends com.google.protobuf.ListValueOrBuilder>
          getValuesOrBuilderList() {
        if (valuesBuilder_ != null) {
          return valuesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(values_);
        }
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public com.google.protobuf.ListValue.Builder addValuesBuilder() {
        return getValuesFieldBuilder()
            .addBuilder(com.google.protobuf.ListValue.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public com.google.protobuf.ListValue.Builder addValuesBuilder(int index) {
        return getValuesFieldBuilder()
            .addBuilder(index, com.google.protobuf.ListValue.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The values to be written. `values` can contain more than one
       * list of values. If it does, then multiple rows are written, one
       * for each entry in `values`. Each list in `values` must have
       * exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
       * above. Sending multiple lists is equivalent to sending multiple
       * `Mutation`s, each containing one `values` entry and repeating
       * [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
       * encoded as described [here][google.spanner.v1.TypeCode].
       * </pre>
       *
       * <code>repeated .google.protobuf.ListValue values = 3;</code>
       */
      public java.util.List<com.google.protobuf.ListValue.Builder> getValuesBuilderList() {
        return getValuesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.protobuf.ListValue,
              com.google.protobuf.ListValue.Builder,
              com.google.protobuf.ListValueOrBuilder>
          getValuesFieldBuilder() {
        if (valuesBuilder_ == null) {
          valuesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.protobuf.ListValue,
                  com.google.protobuf.ListValue.Builder,
                  com.google.protobuf.ListValueOrBuilder>(
                  values_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
          values_ = null;
        }
        return valuesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.Mutation.Write)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.Mutation.Write)
    private static final com.google.spanner.v1.Mutation.Write DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.Mutation.Write();
    }

    public static com.google.spanner.v1.Mutation.Write getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Write> PARSER =
        new com.google.protobuf.AbstractParser<Write>() {
          @java.lang.Override
          public Write parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Write> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Write> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.Mutation.Write getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeleteOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.Mutation.Delete)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The table whose rows will be deleted.
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The table.
     */
    java.lang.String getTable();
    /**
     *
     *
     * <pre>
     * Required. The table whose rows will be deleted.
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for table.
     */
    com.google.protobuf.ByteString getTableBytes();

    /**
     *
     *
     * <pre>
     * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
     * primary keys must be specified in the order in which they appear in the
     * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
     * statement used to create the table).
     * Delete is idempotent. The transaction will succeed even if some or all
     * rows do not exist.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the keySet field is set.
     */
    boolean hasKeySet();
    /**
     *
     *
     * <pre>
     * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
     * primary keys must be specified in the order in which they appear in the
     * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
     * statement used to create the table).
     * Delete is idempotent. The transaction will succeed even if some or all
     * rows do not exist.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The keySet.
     */
    com.google.spanner.v1.KeySet getKeySet();
    /**
     *
     *
     * <pre>
     * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
     * primary keys must be specified in the order in which they appear in the
     * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
     * statement used to create the table).
     * Delete is idempotent. The transaction will succeed even if some or all
     * rows do not exist.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    com.google.spanner.v1.KeySetOrBuilder getKeySetOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Arguments to [delete][google.spanner.v1.Mutation.delete] operations.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.Mutation.Delete}
   */
  public static final class Delete extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.Mutation.Delete)
      DeleteOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Delete.newBuilder() to construct.
    private Delete(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Delete() {
      table_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Delete();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.MutationProto
          .internal_static_google_spanner_v1_Mutation_Delete_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.MutationProto
          .internal_static_google_spanner_v1_Mutation_Delete_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.Mutation.Delete.class,
              com.google.spanner.v1.Mutation.Delete.Builder.class);
    }

    private int bitField0_;
    public static final int TABLE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object table_ = "";
    /**
     *
     *
     * <pre>
     * Required. The table whose rows will be deleted.
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The table.
     */
    @java.lang.Override
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The table whose rows will be deleted.
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for table.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KEY_SET_FIELD_NUMBER = 2;
    private com.google.spanner.v1.KeySet keySet_;
    /**
     *
     *
     * <pre>
     * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
     * primary keys must be specified in the order in which they appear in the
     * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
     * statement used to create the table).
     * Delete is idempotent. The transaction will succeed even if some or all
     * rows do not exist.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the keySet field is set.
     */
    @java.lang.Override
    public boolean hasKeySet() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
     * primary keys must be specified in the order in which they appear in the
     * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
     * statement used to create the table).
     * Delete is idempotent. The transaction will succeed even if some or all
     * rows do not exist.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The keySet.
     */
    @java.lang.Override
    public com.google.spanner.v1.KeySet getKeySet() {
      return keySet_ == null ? com.google.spanner.v1.KeySet.getDefaultInstance() : keySet_;
    }
    /**
     *
     *
     * <pre>
     * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
     * primary keys must be specified in the order in which they appear in the
     * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
     * statement used to create the table).
     * Delete is idempotent. The transaction will succeed even if some or all
     * rows do not exist.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.KeySetOrBuilder getKeySetOrBuilder() {
      return keySet_ == null ? com.google.spanner.v1.KeySet.getDefaultInstance() : keySet_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, table_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getKeySet());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, table_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getKeySet());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.Mutation.Delete)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.Mutation.Delete other = (com.google.spanner.v1.Mutation.Delete) obj;

      if (!getTable().equals(other.getTable())) return false;
      if (hasKeySet() != other.hasKeySet()) return false;
      if (hasKeySet()) {
        if (!getKeySet().equals(other.getKeySet())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getTable().hashCode();
      if (hasKeySet()) {
        hash = (37 * hash) + KEY_SET_FIELD_NUMBER;
        hash = (53 * hash) + getKeySet().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.Mutation.Delete parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.Mutation.Delete parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.Mutation.Delete parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.Mutation.Delete parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.Mutation.Delete parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.Mutation.Delete parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.Mutation.Delete parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.Mutation.Delete parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.Mutation.Delete parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.Mutation.Delete parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.Mutation.Delete parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.Mutation.Delete parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.spanner.v1.Mutation.Delete prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Arguments to [delete][google.spanner.v1.Mutation.delete] operations.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.Mutation.Delete}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.Mutation.Delete)
        com.google.spanner.v1.Mutation.DeleteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.MutationProto
            .internal_static_google_spanner_v1_Mutation_Delete_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.MutationProto
            .internal_static_google_spanner_v1_Mutation_Delete_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.Mutation.Delete.class,
                com.google.spanner.v1.Mutation.Delete.Builder.class);
      }

      // Construct using com.google.spanner.v1.Mutation.Delete.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getKeySetFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        table_ = "";
        keySet_ = null;
        if (keySetBuilder_ != null) {
          keySetBuilder_.dispose();
          keySetBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.MutationProto
            .internal_static_google_spanner_v1_Mutation_Delete_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.Mutation.Delete getDefaultInstanceForType() {
        return com.google.spanner.v1.Mutation.Delete.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.Mutation.Delete build() {
        com.google.spanner.v1.Mutation.Delete result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.Mutation.Delete buildPartial() {
        com.google.spanner.v1.Mutation.Delete result =
            new com.google.spanner.v1.Mutation.Delete(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.spanner.v1.Mutation.Delete result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.table_ = table_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.keySet_ = keySetBuilder_ == null ? keySet_ : keySetBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.Mutation.Delete) {
          return mergeFrom((com.google.spanner.v1.Mutation.Delete) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.Mutation.Delete other) {
        if (other == com.google.spanner.v1.Mutation.Delete.getDefaultInstance()) return this;
        if (!other.getTable().isEmpty()) {
          table_ = other.table_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasKeySet()) {
          mergeKeySet(other.getKeySet());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  table_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getKeySetFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object table_ = "";
      /**
       *
       *
       * <pre>
       * Required. The table whose rows will be deleted.
       * </pre>
       *
       * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The table.
       */
      public java.lang.String getTable() {
        java.lang.Object ref = table_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          table_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The table whose rows will be deleted.
       * </pre>
       *
       * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for table.
       */
      public com.google.protobuf.ByteString getTableBytes() {
        java.lang.Object ref = table_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          table_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The table whose rows will be deleted.
       * </pre>
       *
       * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The table to set.
       * @return This builder for chaining.
       */
      public Builder setTable(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        table_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The table whose rows will be deleted.
       * </pre>
       *
       * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTable() {
        table_ = getDefaultInstance().getTable();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The table whose rows will be deleted.
       * </pre>
       *
       * <code>string table = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for table to set.
       * @return This builder for chaining.
       */
      public Builder setTableBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        table_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.spanner.v1.KeySet keySet_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.spanner.v1.KeySet,
              com.google.spanner.v1.KeySet.Builder,
              com.google.spanner.v1.KeySetOrBuilder>
          keySetBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
       * primary keys must be specified in the order in which they appear in the
       * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
       * statement used to create the table).
       * Delete is idempotent. The transaction will succeed even if some or all
       * rows do not exist.
       * </pre>
       *
       * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the keySet field is set.
       */
      public boolean hasKeySet() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
       * primary keys must be specified in the order in which they appear in the
       * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
       * statement used to create the table).
       * Delete is idempotent. The transaction will succeed even if some or all
       * rows do not exist.
       * </pre>
       *
       * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The keySet.
       */
      public com.google.spanner.v1.KeySet getKeySet() {
        if (keySetBuilder_ == null) {
          return keySet_ == null ? com.google.spanner.v1.KeySet.getDefaultInstance() : keySet_;
        } else {
          return keySetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
       * primary keys must be specified in the order in which they appear in the
       * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
       * statement used to create the table).
       * Delete is idempotent. The transaction will succeed even if some or all
       * rows do not exist.
       * </pre>
       *
       * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setKeySet(com.google.spanner.v1.KeySet value) {
        if (keySetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          keySet_ = value;
        } else {
          keySetBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
       * primary keys must be specified in the order in which they appear in the
       * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
       * statement used to create the table).
       * Delete is idempotent. The transaction will succeed even if some or all
       * rows do not exist.
       * </pre>
       *
       * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setKeySet(com.google.spanner.v1.KeySet.Builder builderForValue) {
        if (keySetBuilder_ == null) {
          keySet_ = builderForValue.build();
        } else {
          keySetBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
       * primary keys must be specified in the order in which they appear in the
       * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
       * statement used to create the table).
       * Delete is idempotent. The transaction will succeed even if some or all
       * rows do not exist.
       * </pre>
       *
       * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeKeySet(com.google.spanner.v1.KeySet value) {
        if (keySetBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && keySet_ != null
              && keySet_ != com.google.spanner.v1.KeySet.getDefaultInstance()) {
            getKeySetBuilder().mergeFrom(value);
          } else {
            keySet_ = value;
          }
        } else {
          keySetBuilder_.mergeFrom(value);
        }
        if (keySet_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
       * primary keys must be specified in the order in which they appear in the
       * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
       * statement used to create the table).
       * Delete is idempotent. The transaction will succeed even if some or all
       * rows do not exist.
       * </pre>
       *
       * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearKeySet() {
        bitField0_ = (bitField0_ & ~0x00000002);
        keySet_ = null;
        if (keySetBuilder_ != null) {
          keySetBuilder_.dispose();
          keySetBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
       * primary keys must be specified in the order in which they appear in the
       * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
       * statement used to create the table).
       * Delete is idempotent. The transaction will succeed even if some or all
       * rows do not exist.
       * </pre>
       *
       * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.spanner.v1.KeySet.Builder getKeySetBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getKeySetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
       * primary keys must be specified in the order in which they appear in the
       * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
       * statement used to create the table).
       * Delete is idempotent. The transaction will succeed even if some or all
       * rows do not exist.
       * </pre>
       *
       * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.spanner.v1.KeySetOrBuilder getKeySetOrBuilder() {
        if (keySetBuilder_ != null) {
          return keySetBuilder_.getMessageOrBuilder();
        } else {
          return keySet_ == null ? com.google.spanner.v1.KeySet.getDefaultInstance() : keySet_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.  The
       * primary keys must be specified in the order in which they appear in the
       * `PRIMARY KEY()` clause of the table's equivalent DDL statement (the DDL
       * statement used to create the table).
       * Delete is idempotent. The transaction will succeed even if some or all
       * rows do not exist.
       * </pre>
       *
       * <code>.google.spanner.v1.KeySet key_set = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.spanner.v1.KeySet,
              com.google.spanner.v1.KeySet.Builder,
              com.google.spanner.v1.KeySetOrBuilder>
          getKeySetFieldBuilder() {
        if (keySetBuilder_ == null) {
          keySetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.spanner.v1.KeySet,
                  com.google.spanner.v1.KeySet.Builder,
                  com.google.spanner.v1.KeySetOrBuilder>(
                  getKeySet(), getParentForChildren(), isClean());
          keySet_ = null;
        }
        return keySetBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.Mutation.Delete)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.Mutation.Delete)
    private static final com.google.spanner.v1.Mutation.Delete DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.Mutation.Delete();
    }

    public static com.google.spanner.v1.Mutation.Delete getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Delete> PARSER =
        new com.google.protobuf.AbstractParser<Delete>() {
          @java.lang.Override
          public Delete parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Delete> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Delete> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.Mutation.Delete getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int operationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object operation_;

  public enum OperationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INSERT(1),
    UPDATE(2),
    INSERT_OR_UPDATE(3),
    REPLACE(4),
    DELETE(5),
    OPERATION_NOT_SET(0);
    private final int value;

    private OperationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OperationCase valueOf(int value) {
      return forNumber(value);
    }

    public static OperationCase forNumber(int value) {
      switch (value) {
        case 1:
          return INSERT;
        case 2:
          return UPDATE;
        case 3:
          return INSERT_OR_UPDATE;
        case 4:
          return REPLACE;
        case 5:
          return DELETE;
        case 0:
          return OPERATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OperationCase getOperationCase() {
    return OperationCase.forNumber(operationCase_);
  }

  public static final int INSERT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Insert new rows in a table. If any of the rows already exist,
   * the write or transaction fails with error `ALREADY_EXISTS`.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
   *
   * @return Whether the insert field is set.
   */
  @java.lang.Override
  public boolean hasInsert() {
    return operationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Insert new rows in a table. If any of the rows already exist,
   * the write or transaction fails with error `ALREADY_EXISTS`.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
   *
   * @return The insert.
   */
  @java.lang.Override
  public com.google.spanner.v1.Mutation.Write getInsert() {
    if (operationCase_ == 1) {
      return (com.google.spanner.v1.Mutation.Write) operation_;
    }
    return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Insert new rows in a table. If any of the rows already exist,
   * the write or transaction fails with error `ALREADY_EXISTS`.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.Mutation.WriteOrBuilder getInsertOrBuilder() {
    if (operationCase_ == 1) {
      return (com.google.spanner.v1.Mutation.Write) operation_;
    }
    return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
  }

  public static final int UPDATE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Update existing rows in a table. If any of the rows does not
   * already exist, the transaction fails with error `NOT_FOUND`.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
   *
   * @return Whether the update field is set.
   */
  @java.lang.Override
  public boolean hasUpdate() {
    return operationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Update existing rows in a table. If any of the rows does not
   * already exist, the transaction fails with error `NOT_FOUND`.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
   *
   * @return The update.
   */
  @java.lang.Override
  public com.google.spanner.v1.Mutation.Write getUpdate() {
    if (operationCase_ == 2) {
      return (com.google.spanner.v1.Mutation.Write) operation_;
    }
    return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Update existing rows in a table. If any of the rows does not
   * already exist, the transaction fails with error `NOT_FOUND`.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.Mutation.WriteOrBuilder getUpdateOrBuilder() {
    if (operationCase_ == 2) {
      return (com.google.spanner.v1.Mutation.Write) operation_;
    }
    return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
  }

  public static final int INSERT_OR_UPDATE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
   * its column values are overwritten with the ones provided. Any
   * column values not explicitly written are preserved.
   *
   * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
   * NULL` columns in the table must be given a value. This holds true
   * even when the row already exists and will therefore actually be updated.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
   *
   * @return Whether the insertOrUpdate field is set.
   */
  @java.lang.Override
  public boolean hasInsertOrUpdate() {
    return operationCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
   * its column values are overwritten with the ones provided. Any
   * column values not explicitly written are preserved.
   *
   * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
   * NULL` columns in the table must be given a value. This holds true
   * even when the row already exists and will therefore actually be updated.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
   *
   * @return The insertOrUpdate.
   */
  @java.lang.Override
  public com.google.spanner.v1.Mutation.Write getInsertOrUpdate() {
    if (operationCase_ == 3) {
      return (com.google.spanner.v1.Mutation.Write) operation_;
    }
    return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
   * its column values are overwritten with the ones provided. Any
   * column values not explicitly written are preserved.
   *
   * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
   * NULL` columns in the table must be given a value. This holds true
   * even when the row already exists and will therefore actually be updated.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.Mutation.WriteOrBuilder getInsertOrUpdateOrBuilder() {
    if (operationCase_ == 3) {
      return (com.google.spanner.v1.Mutation.Write) operation_;
    }
    return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
  }

  public static final int REPLACE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
   * deleted, and the column values provided are inserted
   * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
   * explicitly written become `NULL`.
   *
   * In an interleaved table, if you create the child table with the
   * `ON DELETE CASCADE` annotation, then replacing a parent row
   * also deletes the child rows. Otherwise, you must delete the
   * child rows before you replace the parent row.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
   *
   * @return Whether the replace field is set.
   */
  @java.lang.Override
  public boolean hasReplace() {
    return operationCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
   * deleted, and the column values provided are inserted
   * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
   * explicitly written become `NULL`.
   *
   * In an interleaved table, if you create the child table with the
   * `ON DELETE CASCADE` annotation, then replacing a parent row
   * also deletes the child rows. Otherwise, you must delete the
   * child rows before you replace the parent row.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
   *
   * @return The replace.
   */
  @java.lang.Override
  public com.google.spanner.v1.Mutation.Write getReplace() {
    if (operationCase_ == 4) {
      return (com.google.spanner.v1.Mutation.Write) operation_;
    }
    return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
   * deleted, and the column values provided are inserted
   * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
   * explicitly written become `NULL`.
   *
   * In an interleaved table, if you create the child table with the
   * `ON DELETE CASCADE` annotation, then replacing a parent row
   * also deletes the child rows. Otherwise, you must delete the
   * child rows before you replace the parent row.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.Mutation.WriteOrBuilder getReplaceOrBuilder() {
    if (operationCase_ == 4) {
      return (com.google.spanner.v1.Mutation.Write) operation_;
    }
    return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
  }

  public static final int DELETE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Delete rows from a table. Succeeds whether or not the named
   * rows were present.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
   *
   * @return Whether the delete field is set.
   */
  @java.lang.Override
  public boolean hasDelete() {
    return operationCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Delete rows from a table. Succeeds whether or not the named
   * rows were present.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
   *
   * @return The delete.
   */
  @java.lang.Override
  public com.google.spanner.v1.Mutation.Delete getDelete() {
    if (operationCase_ == 5) {
      return (com.google.spanner.v1.Mutation.Delete) operation_;
    }
    return com.google.spanner.v1.Mutation.Delete.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Delete rows from a table. Succeeds whether or not the named
   * rows were present.
   * </pre>
   *
   * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.Mutation.DeleteOrBuilder getDeleteOrBuilder() {
    if (operationCase_ == 5) {
      return (com.google.spanner.v1.Mutation.Delete) operation_;
    }
    return com.google.spanner.v1.Mutation.Delete.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (operationCase_ == 1) {
      output.writeMessage(1, (com.google.spanner.v1.Mutation.Write) operation_);
    }
    if (operationCase_ == 2) {
      output.writeMessage(2, (com.google.spanner.v1.Mutation.Write) operation_);
    }
    if (operationCase_ == 3) {
      output.writeMessage(3, (com.google.spanner.v1.Mutation.Write) operation_);
    }
    if (operationCase_ == 4) {
      output.writeMessage(4, (com.google.spanner.v1.Mutation.Write) operation_);
    }
    if (operationCase_ == 5) {
      output.writeMessage(5, (com.google.spanner.v1.Mutation.Delete) operation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (operationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.spanner.v1.Mutation.Write) operation_);
    }
    if (operationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.spanner.v1.Mutation.Write) operation_);
    }
    if (operationCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.spanner.v1.Mutation.Write) operation_);
    }
    if (operationCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.spanner.v1.Mutation.Write) operation_);
    }
    if (operationCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.spanner.v1.Mutation.Delete) operation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.Mutation)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.Mutation other = (com.google.spanner.v1.Mutation) obj;

    if (!getOperationCase().equals(other.getOperationCase())) return false;
    switch (operationCase_) {
      case 1:
        if (!getInsert().equals(other.getInsert())) return false;
        break;
      case 2:
        if (!getUpdate().equals(other.getUpdate())) return false;
        break;
      case 3:
        if (!getInsertOrUpdate().equals(other.getInsertOrUpdate())) return false;
        break;
      case 4:
        if (!getReplace().equals(other.getReplace())) return false;
        break;
      case 5:
        if (!getDelete().equals(other.getDelete())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (operationCase_) {
      case 1:
        hash = (37 * hash) + INSERT_FIELD_NUMBER;
        hash = (53 * hash) + getInsert().hashCode();
        break;
      case 2:
        hash = (37 * hash) + UPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getUpdate().hashCode();
        break;
      case 3:
        hash = (37 * hash) + INSERT_OR_UPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getInsertOrUpdate().hashCode();
        break;
      case 4:
        hash = (37 * hash) + REPLACE_FIELD_NUMBER;
        hash = (53 * hash) + getReplace().hashCode();
        break;
      case 5:
        hash = (37 * hash) + DELETE_FIELD_NUMBER;
        hash = (53 * hash) + getDelete().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.Mutation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.Mutation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.Mutation parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.Mutation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.Mutation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.Mutation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.Mutation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.Mutation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.Mutation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.Mutation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.Mutation parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.Mutation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.Mutation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A modification to one or more Cloud Spanner rows.  Mutations can be
   * applied to a Cloud Spanner database by sending them in a
   * [Commit][google.spanner.v1.Spanner.Commit] call.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.Mutation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.Mutation)
      com.google.spanner.v1.MutationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.MutationProto
          .internal_static_google_spanner_v1_Mutation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.MutationProto
          .internal_static_google_spanner_v1_Mutation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.Mutation.class, com.google.spanner.v1.Mutation.Builder.class);
    }

    // Construct using com.google.spanner.v1.Mutation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (insertBuilder_ != null) {
        insertBuilder_.clear();
      }
      if (updateBuilder_ != null) {
        updateBuilder_.clear();
      }
      if (insertOrUpdateBuilder_ != null) {
        insertOrUpdateBuilder_.clear();
      }
      if (replaceBuilder_ != null) {
        replaceBuilder_.clear();
      }
      if (deleteBuilder_ != null) {
        deleteBuilder_.clear();
      }
      operationCase_ = 0;
      operation_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.MutationProto
          .internal_static_google_spanner_v1_Mutation_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.Mutation getDefaultInstanceForType() {
      return com.google.spanner.v1.Mutation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.Mutation build() {
      com.google.spanner.v1.Mutation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.Mutation buildPartial() {
      com.google.spanner.v1.Mutation result = new com.google.spanner.v1.Mutation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.v1.Mutation result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.spanner.v1.Mutation result) {
      result.operationCase_ = operationCase_;
      result.operation_ = this.operation_;
      if (operationCase_ == 1 && insertBuilder_ != null) {
        result.operation_ = insertBuilder_.build();
      }
      if (operationCase_ == 2 && updateBuilder_ != null) {
        result.operation_ = updateBuilder_.build();
      }
      if (operationCase_ == 3 && insertOrUpdateBuilder_ != null) {
        result.operation_ = insertOrUpdateBuilder_.build();
      }
      if (operationCase_ == 4 && replaceBuilder_ != null) {
        result.operation_ = replaceBuilder_.build();
      }
      if (operationCase_ == 5 && deleteBuilder_ != null) {
        result.operation_ = deleteBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.Mutation) {
        return mergeFrom((com.google.spanner.v1.Mutation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.Mutation other) {
      if (other == com.google.spanner.v1.Mutation.getDefaultInstance()) return this;
      switch (other.getOperationCase()) {
        case INSERT:
          {
            mergeInsert(other.getInsert());
            break;
          }
        case UPDATE:
          {
            mergeUpdate(other.getUpdate());
            break;
          }
        case INSERT_OR_UPDATE:
          {
            mergeInsertOrUpdate(other.getInsertOrUpdate());
            break;
          }
        case REPLACE:
          {
            mergeReplace(other.getReplace());
            break;
          }
        case DELETE:
          {
            mergeDelete(other.getDelete());
            break;
          }
        case OPERATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getInsertFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getInsertOrUpdateFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getReplaceFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getDeleteFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int operationCase_ = 0;
    private java.lang.Object operation_;

    public OperationCase getOperationCase() {
      return OperationCase.forNumber(operationCase_);
    }

    public Builder clearOperation() {
      operationCase_ = 0;
      operation_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Mutation.Write,
            com.google.spanner.v1.Mutation.Write.Builder,
            com.google.spanner.v1.Mutation.WriteOrBuilder>
        insertBuilder_;
    /**
     *
     *
     * <pre>
     * Insert new rows in a table. If any of the rows already exist,
     * the write or transaction fails with error `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
     *
     * @return Whether the insert field is set.
     */
    @java.lang.Override
    public boolean hasInsert() {
      return operationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Insert new rows in a table. If any of the rows already exist,
     * the write or transaction fails with error `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
     *
     * @return The insert.
     */
    @java.lang.Override
    public com.google.spanner.v1.Mutation.Write getInsert() {
      if (insertBuilder_ == null) {
        if (operationCase_ == 1) {
          return (com.google.spanner.v1.Mutation.Write) operation_;
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      } else {
        if (operationCase_ == 1) {
          return insertBuilder_.getMessage();
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Insert new rows in a table. If any of the rows already exist,
     * the write or transaction fails with error `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
     */
    public Builder setInsert(com.google.spanner.v1.Mutation.Write value) {
      if (insertBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        insertBuilder_.setMessage(value);
      }
      operationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insert new rows in a table. If any of the rows already exist,
     * the write or transaction fails with error `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
     */
    public Builder setInsert(com.google.spanner.v1.Mutation.Write.Builder builderForValue) {
      if (insertBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        insertBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insert new rows in a table. If any of the rows already exist,
     * the write or transaction fails with error `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
     */
    public Builder mergeInsert(com.google.spanner.v1.Mutation.Write value) {
      if (insertBuilder_ == null) {
        if (operationCase_ == 1
            && operation_ != com.google.spanner.v1.Mutation.Write.getDefaultInstance()) {
          operation_ =
              com.google.spanner.v1.Mutation.Write.newBuilder(
                      (com.google.spanner.v1.Mutation.Write) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 1) {
          insertBuilder_.mergeFrom(value);
        } else {
          insertBuilder_.setMessage(value);
        }
      }
      operationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insert new rows in a table. If any of the rows already exist,
     * the write or transaction fails with error `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
     */
    public Builder clearInsert() {
      if (insertBuilder_ == null) {
        if (operationCase_ == 1) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 1) {
          operationCase_ = 0;
          operation_ = null;
        }
        insertBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Insert new rows in a table. If any of the rows already exist,
     * the write or transaction fails with error `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
     */
    public com.google.spanner.v1.Mutation.Write.Builder getInsertBuilder() {
      return getInsertFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Insert new rows in a table. If any of the rows already exist,
     * the write or transaction fails with error `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.Mutation.WriteOrBuilder getInsertOrBuilder() {
      if ((operationCase_ == 1) && (insertBuilder_ != null)) {
        return insertBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 1) {
          return (com.google.spanner.v1.Mutation.Write) operation_;
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Insert new rows in a table. If any of the rows already exist,
     * the write or transaction fails with error `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Mutation.Write,
            com.google.spanner.v1.Mutation.Write.Builder,
            com.google.spanner.v1.Mutation.WriteOrBuilder>
        getInsertFieldBuilder() {
      if (insertBuilder_ == null) {
        if (!(operationCase_ == 1)) {
          operation_ = com.google.spanner.v1.Mutation.Write.getDefaultInstance();
        }
        insertBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.Mutation.Write,
                com.google.spanner.v1.Mutation.Write.Builder,
                com.google.spanner.v1.Mutation.WriteOrBuilder>(
                (com.google.spanner.v1.Mutation.Write) operation_,
                getParentForChildren(),
                isClean());
        operation_ = null;
      }
      operationCase_ = 1;
      onChanged();
      return insertBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Mutation.Write,
            com.google.spanner.v1.Mutation.Write.Builder,
            com.google.spanner.v1.Mutation.WriteOrBuilder>
        updateBuilder_;
    /**
     *
     *
     * <pre>
     * Update existing rows in a table. If any of the rows does not
     * already exist, the transaction fails with error `NOT_FOUND`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
     *
     * @return Whether the update field is set.
     */
    @java.lang.Override
    public boolean hasUpdate() {
      return operationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Update existing rows in a table. If any of the rows does not
     * already exist, the transaction fails with error `NOT_FOUND`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
     *
     * @return The update.
     */
    @java.lang.Override
    public com.google.spanner.v1.Mutation.Write getUpdate() {
      if (updateBuilder_ == null) {
        if (operationCase_ == 2) {
          return (com.google.spanner.v1.Mutation.Write) operation_;
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      } else {
        if (operationCase_ == 2) {
          return updateBuilder_.getMessage();
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Update existing rows in a table. If any of the rows does not
     * already exist, the transaction fails with error `NOT_FOUND`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
     */
    public Builder setUpdate(com.google.spanner.v1.Mutation.Write value) {
      if (updateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        updateBuilder_.setMessage(value);
      }
      operationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Update existing rows in a table. If any of the rows does not
     * already exist, the transaction fails with error `NOT_FOUND`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
     */
    public Builder setUpdate(com.google.spanner.v1.Mutation.Write.Builder builderForValue) {
      if (updateBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        updateBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Update existing rows in a table. If any of the rows does not
     * already exist, the transaction fails with error `NOT_FOUND`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
     */
    public Builder mergeUpdate(com.google.spanner.v1.Mutation.Write value) {
      if (updateBuilder_ == null) {
        if (operationCase_ == 2
            && operation_ != com.google.spanner.v1.Mutation.Write.getDefaultInstance()) {
          operation_ =
              com.google.spanner.v1.Mutation.Write.newBuilder(
                      (com.google.spanner.v1.Mutation.Write) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 2) {
          updateBuilder_.mergeFrom(value);
        } else {
          updateBuilder_.setMessage(value);
        }
      }
      operationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Update existing rows in a table. If any of the rows does not
     * already exist, the transaction fails with error `NOT_FOUND`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
     */
    public Builder clearUpdate() {
      if (updateBuilder_ == null) {
        if (operationCase_ == 2) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 2) {
          operationCase_ = 0;
          operation_ = null;
        }
        updateBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Update existing rows in a table. If any of the rows does not
     * already exist, the transaction fails with error `NOT_FOUND`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
     */
    public com.google.spanner.v1.Mutation.Write.Builder getUpdateBuilder() {
      return getUpdateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Update existing rows in a table. If any of the rows does not
     * already exist, the transaction fails with error `NOT_FOUND`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.Mutation.WriteOrBuilder getUpdateOrBuilder() {
      if ((operationCase_ == 2) && (updateBuilder_ != null)) {
        return updateBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 2) {
          return (com.google.spanner.v1.Mutation.Write) operation_;
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Update existing rows in a table. If any of the rows does not
     * already exist, the transaction fails with error `NOT_FOUND`.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write update = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Mutation.Write,
            com.google.spanner.v1.Mutation.Write.Builder,
            com.google.spanner.v1.Mutation.WriteOrBuilder>
        getUpdateFieldBuilder() {
      if (updateBuilder_ == null) {
        if (!(operationCase_ == 2)) {
          operation_ = com.google.spanner.v1.Mutation.Write.getDefaultInstance();
        }
        updateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.Mutation.Write,
                com.google.spanner.v1.Mutation.Write.Builder,
                com.google.spanner.v1.Mutation.WriteOrBuilder>(
                (com.google.spanner.v1.Mutation.Write) operation_,
                getParentForChildren(),
                isClean());
        operation_ = null;
      }
      operationCase_ = 2;
      onChanged();
      return updateBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Mutation.Write,
            com.google.spanner.v1.Mutation.Write.Builder,
            com.google.spanner.v1.Mutation.WriteOrBuilder>
        insertOrUpdateBuilder_;
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
     * its column values are overwritten with the ones provided. Any
     * column values not explicitly written are preserved.
     *
     * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
     * NULL` columns in the table must be given a value. This holds true
     * even when the row already exists and will therefore actually be updated.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
     *
     * @return Whether the insertOrUpdate field is set.
     */
    @java.lang.Override
    public boolean hasInsertOrUpdate() {
      return operationCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
     * its column values are overwritten with the ones provided. Any
     * column values not explicitly written are preserved.
     *
     * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
     * NULL` columns in the table must be given a value. This holds true
     * even when the row already exists and will therefore actually be updated.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
     *
     * @return The insertOrUpdate.
     */
    @java.lang.Override
    public com.google.spanner.v1.Mutation.Write getInsertOrUpdate() {
      if (insertOrUpdateBuilder_ == null) {
        if (operationCase_ == 3) {
          return (com.google.spanner.v1.Mutation.Write) operation_;
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      } else {
        if (operationCase_ == 3) {
          return insertOrUpdateBuilder_.getMessage();
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
     * its column values are overwritten with the ones provided. Any
     * column values not explicitly written are preserved.
     *
     * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
     * NULL` columns in the table must be given a value. This holds true
     * even when the row already exists and will therefore actually be updated.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
     */
    public Builder setInsertOrUpdate(com.google.spanner.v1.Mutation.Write value) {
      if (insertOrUpdateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        insertOrUpdateBuilder_.setMessage(value);
      }
      operationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
     * its column values are overwritten with the ones provided. Any
     * column values not explicitly written are preserved.
     *
     * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
     * NULL` columns in the table must be given a value. This holds true
     * even when the row already exists and will therefore actually be updated.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
     */
    public Builder setInsertOrUpdate(com.google.spanner.v1.Mutation.Write.Builder builderForValue) {
      if (insertOrUpdateBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        insertOrUpdateBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
     * its column values are overwritten with the ones provided. Any
     * column values not explicitly written are preserved.
     *
     * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
     * NULL` columns in the table must be given a value. This holds true
     * even when the row already exists and will therefore actually be updated.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
     */
    public Builder mergeInsertOrUpdate(com.google.spanner.v1.Mutation.Write value) {
      if (insertOrUpdateBuilder_ == null) {
        if (operationCase_ == 3
            && operation_ != com.google.spanner.v1.Mutation.Write.getDefaultInstance()) {
          operation_ =
              com.google.spanner.v1.Mutation.Write.newBuilder(
                      (com.google.spanner.v1.Mutation.Write) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 3) {
          insertOrUpdateBuilder_.mergeFrom(value);
        } else {
          insertOrUpdateBuilder_.setMessage(value);
        }
      }
      operationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
     * its column values are overwritten with the ones provided. Any
     * column values not explicitly written are preserved.
     *
     * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
     * NULL` columns in the table must be given a value. This holds true
     * even when the row already exists and will therefore actually be updated.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
     */
    public Builder clearInsertOrUpdate() {
      if (insertOrUpdateBuilder_ == null) {
        if (operationCase_ == 3) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 3) {
          operationCase_ = 0;
          operation_ = null;
        }
        insertOrUpdateBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
     * its column values are overwritten with the ones provided. Any
     * column values not explicitly written are preserved.
     *
     * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
     * NULL` columns in the table must be given a value. This holds true
     * even when the row already exists and will therefore actually be updated.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
     */
    public com.google.spanner.v1.Mutation.Write.Builder getInsertOrUpdateBuilder() {
      return getInsertOrUpdateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
     * its column values are overwritten with the ones provided. Any
     * column values not explicitly written are preserved.
     *
     * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
     * NULL` columns in the table must be given a value. This holds true
     * even when the row already exists and will therefore actually be updated.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.Mutation.WriteOrBuilder getInsertOrUpdateOrBuilder() {
      if ((operationCase_ == 3) && (insertOrUpdateBuilder_ != null)) {
        return insertOrUpdateBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 3) {
          return (com.google.spanner.v1.Mutation.Write) operation_;
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, then
     * its column values are overwritten with the ones provided. Any
     * column values not explicitly written are preserved.
     *
     * When using [insert_or_update][google.spanner.v1.Mutation.insert_or_update], just as when using [insert][google.spanner.v1.Mutation.insert], all `NOT
     * NULL` columns in the table must be given a value. This holds true
     * even when the row already exists and will therefore actually be updated.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write insert_or_update = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Mutation.Write,
            com.google.spanner.v1.Mutation.Write.Builder,
            com.google.spanner.v1.Mutation.WriteOrBuilder>
        getInsertOrUpdateFieldBuilder() {
      if (insertOrUpdateBuilder_ == null) {
        if (!(operationCase_ == 3)) {
          operation_ = com.google.spanner.v1.Mutation.Write.getDefaultInstance();
        }
        insertOrUpdateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.Mutation.Write,
                com.google.spanner.v1.Mutation.Write.Builder,
                com.google.spanner.v1.Mutation.WriteOrBuilder>(
                (com.google.spanner.v1.Mutation.Write) operation_,
                getParentForChildren(),
                isClean());
        operation_ = null;
      }
      operationCase_ = 3;
      onChanged();
      return insertOrUpdateBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Mutation.Write,
            com.google.spanner.v1.Mutation.Write.Builder,
            com.google.spanner.v1.Mutation.WriteOrBuilder>
        replaceBuilder_;
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
     * deleted, and the column values provided are inserted
     * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
     * explicitly written become `NULL`.
     *
     * In an interleaved table, if you create the child table with the
     * `ON DELETE CASCADE` annotation, then replacing a parent row
     * also deletes the child rows. Otherwise, you must delete the
     * child rows before you replace the parent row.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
     *
     * @return Whether the replace field is set.
     */
    @java.lang.Override
    public boolean hasReplace() {
      return operationCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
     * deleted, and the column values provided are inserted
     * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
     * explicitly written become `NULL`.
     *
     * In an interleaved table, if you create the child table with the
     * `ON DELETE CASCADE` annotation, then replacing a parent row
     * also deletes the child rows. Otherwise, you must delete the
     * child rows before you replace the parent row.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
     *
     * @return The replace.
     */
    @java.lang.Override
    public com.google.spanner.v1.Mutation.Write getReplace() {
      if (replaceBuilder_ == null) {
        if (operationCase_ == 4) {
          return (com.google.spanner.v1.Mutation.Write) operation_;
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      } else {
        if (operationCase_ == 4) {
          return replaceBuilder_.getMessage();
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
     * deleted, and the column values provided are inserted
     * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
     * explicitly written become `NULL`.
     *
     * In an interleaved table, if you create the child table with the
     * `ON DELETE CASCADE` annotation, then replacing a parent row
     * also deletes the child rows. Otherwise, you must delete the
     * child rows before you replace the parent row.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
     */
    public Builder setReplace(com.google.spanner.v1.Mutation.Write value) {
      if (replaceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        replaceBuilder_.setMessage(value);
      }
      operationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
     * deleted, and the column values provided are inserted
     * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
     * explicitly written become `NULL`.
     *
     * In an interleaved table, if you create the child table with the
     * `ON DELETE CASCADE` annotation, then replacing a parent row
     * also deletes the child rows. Otherwise, you must delete the
     * child rows before you replace the parent row.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
     */
    public Builder setReplace(com.google.spanner.v1.Mutation.Write.Builder builderForValue) {
      if (replaceBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        replaceBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
     * deleted, and the column values provided are inserted
     * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
     * explicitly written become `NULL`.
     *
     * In an interleaved table, if you create the child table with the
     * `ON DELETE CASCADE` annotation, then replacing a parent row
     * also deletes the child rows. Otherwise, you must delete the
     * child rows before you replace the parent row.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
     */
    public Builder mergeReplace(com.google.spanner.v1.Mutation.Write value) {
      if (replaceBuilder_ == null) {
        if (operationCase_ == 4
            && operation_ != com.google.spanner.v1.Mutation.Write.getDefaultInstance()) {
          operation_ =
              com.google.spanner.v1.Mutation.Write.newBuilder(
                      (com.google.spanner.v1.Mutation.Write) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 4) {
          replaceBuilder_.mergeFrom(value);
        } else {
          replaceBuilder_.setMessage(value);
        }
      }
      operationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
     * deleted, and the column values provided are inserted
     * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
     * explicitly written become `NULL`.
     *
     * In an interleaved table, if you create the child table with the
     * `ON DELETE CASCADE` annotation, then replacing a parent row
     * also deletes the child rows. Otherwise, you must delete the
     * child rows before you replace the parent row.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
     */
    public Builder clearReplace() {
      if (replaceBuilder_ == null) {
        if (operationCase_ == 4) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 4) {
          operationCase_ = 0;
          operation_ = null;
        }
        replaceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
     * deleted, and the column values provided are inserted
     * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
     * explicitly written become `NULL`.
     *
     * In an interleaved table, if you create the child table with the
     * `ON DELETE CASCADE` annotation, then replacing a parent row
     * also deletes the child rows. Otherwise, you must delete the
     * child rows before you replace the parent row.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
     */
    public com.google.spanner.v1.Mutation.Write.Builder getReplaceBuilder() {
      return getReplaceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
     * deleted, and the column values provided are inserted
     * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
     * explicitly written become `NULL`.
     *
     * In an interleaved table, if you create the child table with the
     * `ON DELETE CASCADE` annotation, then replacing a parent row
     * also deletes the child rows. Otherwise, you must delete the
     * child rows before you replace the parent row.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.Mutation.WriteOrBuilder getReplaceOrBuilder() {
      if ((operationCase_ == 4) && (replaceBuilder_ != null)) {
        return replaceBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 4) {
          return (com.google.spanner.v1.Mutation.Write) operation_;
        }
        return com.google.spanner.v1.Mutation.Write.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Like [insert][google.spanner.v1.Mutation.insert], except that if the row already exists, it is
     * deleted, and the column values provided are inserted
     * instead. Unlike [insert_or_update][google.spanner.v1.Mutation.insert_or_update], this means any values not
     * explicitly written become `NULL`.
     *
     * In an interleaved table, if you create the child table with the
     * `ON DELETE CASCADE` annotation, then replacing a parent row
     * also deletes the child rows. Otherwise, you must delete the
     * child rows before you replace the parent row.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Write replace = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Mutation.Write,
            com.google.spanner.v1.Mutation.Write.Builder,
            com.google.spanner.v1.Mutation.WriteOrBuilder>
        getReplaceFieldBuilder() {
      if (replaceBuilder_ == null) {
        if (!(operationCase_ == 4)) {
          operation_ = com.google.spanner.v1.Mutation.Write.getDefaultInstance();
        }
        replaceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.Mutation.Write,
                com.google.spanner.v1.Mutation.Write.Builder,
                com.google.spanner.v1.Mutation.WriteOrBuilder>(
                (com.google.spanner.v1.Mutation.Write) operation_,
                getParentForChildren(),
                isClean());
        operation_ = null;
      }
      operationCase_ = 4;
      onChanged();
      return replaceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Mutation.Delete,
            com.google.spanner.v1.Mutation.Delete.Builder,
            com.google.spanner.v1.Mutation.DeleteOrBuilder>
        deleteBuilder_;
    /**
     *
     *
     * <pre>
     * Delete rows from a table. Succeeds whether or not the named
     * rows were present.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
     *
     * @return Whether the delete field is set.
     */
    @java.lang.Override
    public boolean hasDelete() {
      return operationCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Delete rows from a table. Succeeds whether or not the named
     * rows were present.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
     *
     * @return The delete.
     */
    @java.lang.Override
    public com.google.spanner.v1.Mutation.Delete getDelete() {
      if (deleteBuilder_ == null) {
        if (operationCase_ == 5) {
          return (com.google.spanner.v1.Mutation.Delete) operation_;
        }
        return com.google.spanner.v1.Mutation.Delete.getDefaultInstance();
      } else {
        if (operationCase_ == 5) {
          return deleteBuilder_.getMessage();
        }
        return com.google.spanner.v1.Mutation.Delete.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Delete rows from a table. Succeeds whether or not the named
     * rows were present.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
     */
    public Builder setDelete(com.google.spanner.v1.Mutation.Delete value) {
      if (deleteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        deleteBuilder_.setMessage(value);
      }
      operationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Delete rows from a table. Succeeds whether or not the named
     * rows were present.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
     */
    public Builder setDelete(com.google.spanner.v1.Mutation.Delete.Builder builderForValue) {
      if (deleteBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        deleteBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Delete rows from a table. Succeeds whether or not the named
     * rows were present.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
     */
    public Builder mergeDelete(com.google.spanner.v1.Mutation.Delete value) {
      if (deleteBuilder_ == null) {
        if (operationCase_ == 5
            && operation_ != com.google.spanner.v1.Mutation.Delete.getDefaultInstance()) {
          operation_ =
              com.google.spanner.v1.Mutation.Delete.newBuilder(
                      (com.google.spanner.v1.Mutation.Delete) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 5) {
          deleteBuilder_.mergeFrom(value);
        } else {
          deleteBuilder_.setMessage(value);
        }
      }
      operationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Delete rows from a table. Succeeds whether or not the named
     * rows were present.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
     */
    public Builder clearDelete() {
      if (deleteBuilder_ == null) {
        if (operationCase_ == 5) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 5) {
          operationCase_ = 0;
          operation_ = null;
        }
        deleteBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Delete rows from a table. Succeeds whether or not the named
     * rows were present.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
     */
    public com.google.spanner.v1.Mutation.Delete.Builder getDeleteBuilder() {
      return getDeleteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Delete rows from a table. Succeeds whether or not the named
     * rows were present.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.Mutation.DeleteOrBuilder getDeleteOrBuilder() {
      if ((operationCase_ == 5) && (deleteBuilder_ != null)) {
        return deleteBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 5) {
          return (com.google.spanner.v1.Mutation.Delete) operation_;
        }
        return com.google.spanner.v1.Mutation.Delete.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Delete rows from a table. Succeeds whether or not the named
     * rows were present.
     * </pre>
     *
     * <code>.google.spanner.v1.Mutation.Delete delete = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Mutation.Delete,
            com.google.spanner.v1.Mutation.Delete.Builder,
            com.google.spanner.v1.Mutation.DeleteOrBuilder>
        getDeleteFieldBuilder() {
      if (deleteBuilder_ == null) {
        if (!(operationCase_ == 5)) {
          operation_ = com.google.spanner.v1.Mutation.Delete.getDefaultInstance();
        }
        deleteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.Mutation.Delete,
                com.google.spanner.v1.Mutation.Delete.Builder,
                com.google.spanner.v1.Mutation.DeleteOrBuilder>(
                (com.google.spanner.v1.Mutation.Delete) operation_,
                getParentForChildren(),
                isClean());
        operation_ = null;
      }
      operationCase_ = 5;
      onChanged();
      return deleteBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.Mutation)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.Mutation)
  private static final com.google.spanner.v1.Mutation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.Mutation();
  }

  public static com.google.spanner.v1.Mutation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Mutation> PARSER =
      new com.google.protobuf.AbstractParser<Mutation>() {
        @java.lang.Override
        public Mutation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Mutation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Mutation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.Mutation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
