/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PhraseSetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PHRASE_SET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/phraseSets/{phrase_set}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String phraseSet;

    @Deprecated
    protected PhraseSetName() {
        this.project = null;
        this.location = null;
        this.phraseSet = null;
    }

    private PhraseSetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.phraseSet = (String)Preconditions.checkNotNull((Object)builder.getPhraseSet());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPhraseSet() {
        return this.phraseSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PhraseSetName of(String project, String location, String phraseSet) {
        return PhraseSetName.newBuilder().setProject(project).setLocation(location).setPhraseSet(phraseSet).build();
    }

    public static String format(String project, String location, String phraseSet) {
        return PhraseSetName.newBuilder().setProject(project).setLocation(location).setPhraseSet(phraseSet).build().toString();
    }

    public static PhraseSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PHRASE_SET.validatedMatch(formattedString, "PhraseSetName.parse: formattedString not in valid format");
        return PhraseSetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("phrase_set"));
    }

    public static List<PhraseSetName> parseList(List<String> formattedStrings) {
        ArrayList<PhraseSetName> list = new ArrayList<PhraseSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PhraseSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PhraseSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PhraseSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PHRASE_SET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PhraseSetName phraseSetName = this;
            synchronized (phraseSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.phraseSet != null) {
                        fieldMapBuilder.put((Object)"phrase_set", (Object)this.phraseSet);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PHRASE_SET.instantiate(new String[]{"project", this.project, "location", this.location, "phrase_set", this.phraseSet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PhraseSetName that = (PhraseSetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.phraseSet, that.phraseSet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.phraseSet);
    }

    public static class Builder {
        private String project;
        private String location;
        private String phraseSet;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPhraseSet() {
            return this.phraseSet;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPhraseSet(String phraseSet) {
            this.phraseSet = phraseSet;
            return this;
        }

        private Builder(PhraseSetName phraseSetName) {
            this.project = phraseSetName.project;
            this.location = phraseSetName.location;
            this.phraseSet = phraseSetName.phraseSet;
        }

        public PhraseSetName build() {
            return new PhraseSetName(this);
        }
    }
}

