/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.control.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ManagedFolderName
implements ResourceName {
    private static final PathTemplate PROJECT_BUCKET_MANAGEDFOLDER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/buckets/{bucket}/managedFolders/{managedFolder=**}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String bucket;
    private final String managedFolder;

    @Deprecated
    protected ManagedFolderName() {
        this.project = null;
        this.bucket = null;
        this.managedFolder = null;
    }

    private ManagedFolderName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.bucket = (String)Preconditions.checkNotNull((Object)builder.getBucket());
        this.managedFolder = (String)Preconditions.checkNotNull((Object)builder.getManagedFolder());
    }

    public String getProject() {
        return this.project;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getManagedFolder() {
        return this.managedFolder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ManagedFolderName of(String project, String bucket, String managedFolder) {
        return ManagedFolderName.newBuilder().setProject(project).setBucket(bucket).setManagedFolder(managedFolder).build();
    }

    public static String format(String project, String bucket, String managedFolder) {
        return ManagedFolderName.newBuilder().setProject(project).setBucket(bucket).setManagedFolder(managedFolder).build().toString();
    }

    public static ManagedFolderName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_BUCKET_MANAGEDFOLDER.validatedMatch(formattedString, "ManagedFolderName.parse: formattedString not in valid format");
        return ManagedFolderName.of((String)matchMap.get("project"), (String)matchMap.get("bucket"), (String)matchMap.get("managedFolder"));
    }

    public static List<ManagedFolderName> parseList(List<String> formattedStrings) {
        ArrayList<ManagedFolderName> list = new ArrayList<ManagedFolderName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ManagedFolderName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ManagedFolderName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ManagedFolderName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_BUCKET_MANAGEDFOLDER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ManagedFolderName managedFolderName = this;
            synchronized (managedFolderName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.bucket != null) {
                        fieldMapBuilder.put((Object)"bucket", (Object)this.bucket);
                    }
                    if (this.managedFolder != null) {
                        fieldMapBuilder.put((Object)"managedFolder", (Object)this.managedFolder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_BUCKET_MANAGEDFOLDER.instantiate(new String[]{"project", this.project, "bucket", this.bucket, "managedFolder", this.managedFolder});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ManagedFolderName that = (ManagedFolderName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.managedFolder, that.managedFolder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.bucket);
        h *= 1000003;
        return h ^= Objects.hashCode(this.managedFolder);
    }

    public static class Builder {
        private String project;
        private String bucket;
        private String managedFolder;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getManagedFolder() {
            return this.managedFolder;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder setManagedFolder(String managedFolder) {
            this.managedFolder = managedFolder;
            return this;
        }

        private Builder(ManagedFolderName managedFolderName) {
            this.project = managedFolderName.project;
            this.bucket = managedFolderName.bucket;
            this.managedFolder = managedFolderName.managedFolder;
        }

        public ManagedFolderName build() {
            return new ManagedFolderName(this);
        }
    }
}

