/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Request message for [UpdateObject][google.storage.v2.Storage.UpdateObject].
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.UpdateObjectRequest}
 */
public final class UpdateObjectRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.UpdateObjectRequest)
    UpdateObjectRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use UpdateObjectRequest.newBuilder() to construct.
  private UpdateObjectRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateObjectRequest() {
    predefinedAcl_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateObjectRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_UpdateObjectRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_UpdateObjectRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.UpdateObjectRequest.class,
            com.google.storage.v2.UpdateObjectRequest.Builder.class);
  }

  private int bitField0_;
  public static final int OBJECT_FIELD_NUMBER = 1;
  private com.google.storage.v2.Object object_;

  /**
   *
   *
   * <pre>
   * Required. The object to update.
   * The object's bucket and name fields are used to identify the object to
   * update. If present, the object's generation field selects a specific
   * revision of this object whose metadata should be updated. Otherwise,
   * assumes the live version of the object.
   * </pre>
   *
   * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the object field is set.
   */
  @java.lang.Override
  public boolean hasObject() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The object to update.
   * The object's bucket and name fields are used to identify the object to
   * update. If present, the object's generation field selects a specific
   * revision of this object whose metadata should be updated. Otherwise,
   * assumes the live version of the object.
   * </pre>
   *
   * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The object.
   */
  @java.lang.Override
  public com.google.storage.v2.Object getObject() {
    return object_ == null ? com.google.storage.v2.Object.getDefaultInstance() : object_;
  }

  /**
   *
   *
   * <pre>
   * Required. The object to update.
   * The object's bucket and name fields are used to identify the object to
   * update. If present, the object's generation field selects a specific
   * revision of this object whose metadata should be updated. Otherwise,
   * assumes the live version of the object.
   * </pre>
   *
   * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectOrBuilder getObjectOrBuilder() {
    return object_ == null ? com.google.storage.v2.Object.getDefaultInstance() : object_;
  }

  public static final int IF_GENERATION_MATCH_FIELD_NUMBER = 2;
  private long ifGenerationMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 2;</code>
   *
   * @return Whether the ifGenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationMatch() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 2;</code>
   *
   * @return The ifGenerationMatch.
   */
  @java.lang.Override
  public long getIfGenerationMatch() {
    return ifGenerationMatch_;
  }

  public static final int IF_GENERATION_NOT_MATCH_FIELD_NUMBER = 3;
  private long ifGenerationNotMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live generation
   * does not match the given value. If no live object exists, the precondition
   * fails. Setting to 0 makes the operation succeed only if there is a live
   * version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 3;</code>
   *
   * @return Whether the ifGenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationNotMatch() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live generation
   * does not match the given value. If no live object exists, the precondition
   * fails. Setting to 0 makes the operation succeed only if there is a live
   * version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 3;</code>
   *
   * @return The ifGenerationNotMatch.
   */
  @java.lang.Override
  public long getIfGenerationNotMatch() {
    return ifGenerationNotMatch_;
  }

  public static final int IF_METAGENERATION_MATCH_FIELD_NUMBER = 4;
  private long ifMetagenerationMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 4;</code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationMatch() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 4;</code>
   *
   * @return The ifMetagenerationMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationMatch() {
    return ifMetagenerationMatch_;
  }

  public static final int IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER = 5;
  private long ifMetagenerationNotMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 5;</code>
   *
   * @return Whether the ifMetagenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationNotMatch() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 5;</code>
   *
   * @return The ifMetagenerationNotMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationNotMatch() {
    return ifMetagenerationNotMatch_;
  }

  public static final int PREDEFINED_ACL_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object predefinedAcl_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Apply a predefined set of access controls to this object.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string predefined_acl = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The predefinedAcl.
   */
  @java.lang.Override
  public java.lang.String getPredefinedAcl() {
    java.lang.Object ref = predefinedAcl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      predefinedAcl_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Apply a predefined set of access controls to this object.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string predefined_acl = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for predefinedAcl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPredefinedAclBytes() {
    java.lang.Object ref = predefinedAcl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      predefinedAcl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 7;
  private com.google.protobuf.FieldMask updateMask_;

  /**
   *
   *
   * <pre>
   * Required. List of fields to be updated.
   *
   * To specify ALL fields, equivalent to the JSON API's "update" function,
   * specify a single field with the value `*`. Note: not recommended. If a new
   * field is introduced at a later time, an older client updating with the `*`
   * might accidentally reset the new field's value.
   *
   * Not specifying any fields is an error.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. List of fields to be updated.
   *
   * To specify ALL fields, equivalent to the JSON API's "update" function,
   * specify a single field with the value `*`. Note: not recommended. If a new
   * field is introduced at a later time, an older client updating with the `*`
   * might accidentally reset the new field's value.
   *
   * Not specifying any fields is an error.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  /**
   *
   *
   * <pre>
   * Required. List of fields to be updated.
   *
   * To specify ALL fields, equivalent to the JSON API's "update" function,
   * specify a single field with the value `*`. Note: not recommended. If a new
   * field is introduced at a later time, an older client updating with the `*`
   * might accidentally reset the new field's value.
   *
   * Not specifying any fields is an error.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  public static final int COMMON_OBJECT_REQUEST_PARAMS_FIELD_NUMBER = 8;
  private com.google.storage.v2.CommonObjectRequestParams commonObjectRequestParams_;

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the commonObjectRequestParams field is set.
   */
  @java.lang.Override
  public boolean hasCommonObjectRequestParams() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The commonObjectRequestParams.
   */
  @java.lang.Override
  public com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams() {
    return commonObjectRequestParams_ == null
        ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
        : commonObjectRequestParams_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.CommonObjectRequestParamsOrBuilder
      getCommonObjectRequestParamsOrBuilder() {
    return commonObjectRequestParams_ == null
        ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
        : commonObjectRequestParams_;
  }

  public static final int OVERRIDE_UNLOCKED_RETENTION_FIELD_NUMBER = 11;
  private boolean overrideUnlockedRetention_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Overrides the unlocked retention config on the object.
   * </pre>
   *
   * <code>bool override_unlocked_retention = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The overrideUnlockedRetention.
   */
  @java.lang.Override
  public boolean getOverrideUnlockedRetention() {
    return overrideUnlockedRetention_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getObject());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(2, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(3, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(4, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt64(5, ifMetagenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(7, getUpdateMask());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(8, getCommonObjectRequestParams());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedAcl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, predefinedAcl_);
    }
    if (overrideUnlockedRetention_ != false) {
      output.writeBool(11, overrideUnlockedRetention_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getObject());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, ifMetagenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateMask());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getCommonObjectRequestParams());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedAcl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, predefinedAcl_);
    }
    if (overrideUnlockedRetention_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, overrideUnlockedRetention_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.UpdateObjectRequest)) {
      return super.equals(obj);
    }
    com.google.storage.v2.UpdateObjectRequest other =
        (com.google.storage.v2.UpdateObjectRequest) obj;

    if (hasObject() != other.hasObject()) return false;
    if (hasObject()) {
      if (!getObject().equals(other.getObject())) return false;
    }
    if (hasIfGenerationMatch() != other.hasIfGenerationMatch()) return false;
    if (hasIfGenerationMatch()) {
      if (getIfGenerationMatch() != other.getIfGenerationMatch()) return false;
    }
    if (hasIfGenerationNotMatch() != other.hasIfGenerationNotMatch()) return false;
    if (hasIfGenerationNotMatch()) {
      if (getIfGenerationNotMatch() != other.getIfGenerationNotMatch()) return false;
    }
    if (hasIfMetagenerationMatch() != other.hasIfMetagenerationMatch()) return false;
    if (hasIfMetagenerationMatch()) {
      if (getIfMetagenerationMatch() != other.getIfMetagenerationMatch()) return false;
    }
    if (hasIfMetagenerationNotMatch() != other.hasIfMetagenerationNotMatch()) return false;
    if (hasIfMetagenerationNotMatch()) {
      if (getIfMetagenerationNotMatch() != other.getIfMetagenerationNotMatch()) return false;
    }
    if (!getPredefinedAcl().equals(other.getPredefinedAcl())) return false;
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (hasCommonObjectRequestParams() != other.hasCommonObjectRequestParams()) return false;
    if (hasCommonObjectRequestParams()) {
      if (!getCommonObjectRequestParams().equals(other.getCommonObjectRequestParams()))
        return false;
    }
    if (getOverrideUnlockedRetention() != other.getOverrideUnlockedRetention()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasObject()) {
      hash = (37 * hash) + OBJECT_FIELD_NUMBER;
      hash = (53 * hash) + getObject().hashCode();
    }
    if (hasIfGenerationMatch()) {
      hash = (37 * hash) + IF_GENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationMatch());
    }
    if (hasIfGenerationNotMatch()) {
      hash = (37 * hash) + IF_GENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationNotMatch());
    }
    if (hasIfMetagenerationMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationMatch());
    }
    if (hasIfMetagenerationNotMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationNotMatch());
    }
    hash = (37 * hash) + PREDEFINED_ACL_FIELD_NUMBER;
    hash = (53 * hash) + getPredefinedAcl().hashCode();
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    if (hasCommonObjectRequestParams()) {
      hash = (37 * hash) + COMMON_OBJECT_REQUEST_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getCommonObjectRequestParams().hashCode();
    }
    hash = (37 * hash) + OVERRIDE_UNLOCKED_RETENTION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOverrideUnlockedRetention());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.UpdateObjectRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.UpdateObjectRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.UpdateObjectRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.UpdateObjectRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.UpdateObjectRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.UpdateObjectRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.UpdateObjectRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.UpdateObjectRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.UpdateObjectRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.UpdateObjectRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.UpdateObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.UpdateObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.UpdateObjectRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for [UpdateObject][google.storage.v2.Storage.UpdateObject].
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.UpdateObjectRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.UpdateObjectRequest)
      com.google.storage.v2.UpdateObjectRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_UpdateObjectRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_UpdateObjectRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.UpdateObjectRequest.class,
              com.google.storage.v2.UpdateObjectRequest.Builder.class);
    }

    // Construct using com.google.storage.v2.UpdateObjectRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getObjectFieldBuilder();
        getUpdateMaskFieldBuilder();
        getCommonObjectRequestParamsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      object_ = null;
      if (objectBuilder_ != null) {
        objectBuilder_.dispose();
        objectBuilder_ = null;
      }
      ifGenerationMatch_ = 0L;
      ifGenerationNotMatch_ = 0L;
      ifMetagenerationMatch_ = 0L;
      ifMetagenerationNotMatch_ = 0L;
      predefinedAcl_ = "";
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      commonObjectRequestParams_ = null;
      if (commonObjectRequestParamsBuilder_ != null) {
        commonObjectRequestParamsBuilder_.dispose();
        commonObjectRequestParamsBuilder_ = null;
      }
      overrideUnlockedRetention_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_UpdateObjectRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.UpdateObjectRequest getDefaultInstanceForType() {
      return com.google.storage.v2.UpdateObjectRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.UpdateObjectRequest build() {
      com.google.storage.v2.UpdateObjectRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.UpdateObjectRequest buildPartial() {
      com.google.storage.v2.UpdateObjectRequest result =
          new com.google.storage.v2.UpdateObjectRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.UpdateObjectRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.object_ = objectBuilder_ == null ? object_ : objectBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.ifGenerationMatch_ = ifGenerationMatch_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.ifGenerationNotMatch_ = ifGenerationNotMatch_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ifMetagenerationMatch_ = ifMetagenerationMatch_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ifMetagenerationNotMatch_ = ifMetagenerationNotMatch_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.predefinedAcl_ = predefinedAcl_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.commonObjectRequestParams_ =
            commonObjectRequestParamsBuilder_ == null
                ? commonObjectRequestParams_
                : commonObjectRequestParamsBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.overrideUnlockedRetention_ = overrideUnlockedRetention_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.UpdateObjectRequest) {
        return mergeFrom((com.google.storage.v2.UpdateObjectRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.UpdateObjectRequest other) {
      if (other == com.google.storage.v2.UpdateObjectRequest.getDefaultInstance()) return this;
      if (other.hasObject()) {
        mergeObject(other.getObject());
      }
      if (other.hasIfGenerationMatch()) {
        setIfGenerationMatch(other.getIfGenerationMatch());
      }
      if (other.hasIfGenerationNotMatch()) {
        setIfGenerationNotMatch(other.getIfGenerationNotMatch());
      }
      if (other.hasIfMetagenerationMatch()) {
        setIfMetagenerationMatch(other.getIfMetagenerationMatch());
      }
      if (other.hasIfMetagenerationNotMatch()) {
        setIfMetagenerationNotMatch(other.getIfMetagenerationNotMatch());
      }
      if (!other.getPredefinedAcl().isEmpty()) {
        predefinedAcl_ = other.predefinedAcl_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (other.hasCommonObjectRequestParams()) {
        mergeCommonObjectRequestParams(other.getCommonObjectRequestParams());
      }
      if (other.getOverrideUnlockedRetention() != false) {
        setOverrideUnlockedRetention(other.getOverrideUnlockedRetention());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getObjectFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                ifGenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                ifGenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                ifMetagenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                ifMetagenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 58:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getCommonObjectRequestParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 82:
              {
                predefinedAcl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 82
            case 88:
              {
                overrideUnlockedRetention_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 88
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.storage.v2.Object object_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        objectBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The object to update.
     * The object's bucket and name fields are used to identify the object to
     * update. If present, the object's generation field selects a specific
     * revision of this object whose metadata should be updated. Otherwise,
     * assumes the live version of the object.
     * </pre>
     *
     * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the object field is set.
     */
    public boolean hasObject() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The object to update.
     * The object's bucket and name fields are used to identify the object to
     * update. If present, the object's generation field selects a specific
     * revision of this object whose metadata should be updated. Otherwise,
     * assumes the live version of the object.
     * </pre>
     *
     * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The object.
     */
    public com.google.storage.v2.Object getObject() {
      if (objectBuilder_ == null) {
        return object_ == null ? com.google.storage.v2.Object.getDefaultInstance() : object_;
      } else {
        return objectBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The object to update.
     * The object's bucket and name fields are used to identify the object to
     * update. If present, the object's generation field selects a specific
     * revision of this object whose metadata should be updated. Otherwise,
     * assumes the live version of the object.
     * </pre>
     *
     * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setObject(com.google.storage.v2.Object value) {
      if (objectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        object_ = value;
      } else {
        objectBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The object to update.
     * The object's bucket and name fields are used to identify the object to
     * update. If present, the object's generation field selects a specific
     * revision of this object whose metadata should be updated. Otherwise,
     * assumes the live version of the object.
     * </pre>
     *
     * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setObject(com.google.storage.v2.Object.Builder builderForValue) {
      if (objectBuilder_ == null) {
        object_ = builderForValue.build();
      } else {
        objectBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The object to update.
     * The object's bucket and name fields are used to identify the object to
     * update. If present, the object's generation field selects a specific
     * revision of this object whose metadata should be updated. Otherwise,
     * assumes the live version of the object.
     * </pre>
     *
     * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeObject(com.google.storage.v2.Object value) {
      if (objectBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && object_ != null
            && object_ != com.google.storage.v2.Object.getDefaultInstance()) {
          getObjectBuilder().mergeFrom(value);
        } else {
          object_ = value;
        }
      } else {
        objectBuilder_.mergeFrom(value);
      }
      if (object_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The object to update.
     * The object's bucket and name fields are used to identify the object to
     * update. If present, the object's generation field selects a specific
     * revision of this object whose metadata should be updated. Otherwise,
     * assumes the live version of the object.
     * </pre>
     *
     * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearObject() {
      bitField0_ = (bitField0_ & ~0x00000001);
      object_ = null;
      if (objectBuilder_ != null) {
        objectBuilder_.dispose();
        objectBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The object to update.
     * The object's bucket and name fields are used to identify the object to
     * update. If present, the object's generation field selects a specific
     * revision of this object whose metadata should be updated. Otherwise,
     * assumes the live version of the object.
     * </pre>
     *
     * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.storage.v2.Object.Builder getObjectBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getObjectFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The object to update.
     * The object's bucket and name fields are used to identify the object to
     * update. If present, the object's generation field selects a specific
     * revision of this object whose metadata should be updated. Otherwise,
     * assumes the live version of the object.
     * </pre>
     *
     * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.storage.v2.ObjectOrBuilder getObjectOrBuilder() {
      if (objectBuilder_ != null) {
        return objectBuilder_.getMessageOrBuilder();
      } else {
        return object_ == null ? com.google.storage.v2.Object.getDefaultInstance() : object_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The object to update.
     * The object's bucket and name fields are used to identify the object to
     * update. If present, the object's generation field selects a specific
     * revision of this object whose metadata should be updated. Otherwise,
     * assumes the live version of the object.
     * </pre>
     *
     * <code>.google.storage.v2.Object object = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        getObjectFieldBuilder() {
      if (objectBuilder_ == null) {
        objectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Object,
                com.google.storage.v2.Object.Builder,
                com.google.storage.v2.ObjectOrBuilder>(
                getObject(), getParentForChildren(), isClean());
        object_ = null;
      }
      return objectBuilder_;
    }

    private long ifGenerationMatch_;

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 2;</code>
     *
     * @return Whether the ifGenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationMatch() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 2;</code>
     *
     * @return The ifGenerationMatch.
     */
    @java.lang.Override
    public long getIfGenerationMatch() {
      return ifGenerationMatch_;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 2;</code>
     *
     * @param value The ifGenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationMatch(long value) {

      ifGenerationMatch_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000002);
      ifGenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifGenerationNotMatch_;

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 3;</code>
     *
     * @return Whether the ifGenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationNotMatch() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 3;</code>
     *
     * @return The ifGenerationNotMatch.
     */
    @java.lang.Override
    public long getIfGenerationNotMatch() {
      return ifGenerationNotMatch_;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 3;</code>
     *
     * @param value The ifGenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationNotMatch(long value) {

      ifGenerationNotMatch_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000004);
      ifGenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationMatch_;

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 4;</code>
     *
     * @return Whether the ifMetagenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationMatch() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 4;</code>
     *
     * @return The ifMetagenerationMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationMatch() {
      return ifMetagenerationMatch_;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 4;</code>
     *
     * @param value The ifMetagenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationMatch(long value) {

      ifMetagenerationMatch_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ifMetagenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationNotMatch_;

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 5;</code>
     *
     * @return Whether the ifMetagenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationNotMatch() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 5;</code>
     *
     * @return The ifMetagenerationNotMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationNotMatch() {
      return ifMetagenerationNotMatch_;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 5;</code>
     *
     * @param value The ifMetagenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationNotMatch(long value) {

      ifMetagenerationNotMatch_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ifMetagenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object predefinedAcl_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of access controls to this object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_acl = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The predefinedAcl.
     */
    public java.lang.String getPredefinedAcl() {
      java.lang.Object ref = predefinedAcl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predefinedAcl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of access controls to this object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_acl = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for predefinedAcl.
     */
    public com.google.protobuf.ByteString getPredefinedAclBytes() {
      java.lang.Object ref = predefinedAcl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predefinedAcl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of access controls to this object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_acl = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The predefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedAcl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      predefinedAcl_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of access controls to this object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_acl = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredefinedAcl() {
      predefinedAcl_ = getDefaultInstance().getPredefinedAcl();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of access controls to this object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_acl = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for predefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedAclBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      predefinedAcl_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;

    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     *
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * might accidentally reset the new field's value.
     *
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     *
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * might accidentally reset the new field's value.
     *
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     *
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * might accidentally reset the new field's value.
     *
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     *
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * might accidentally reset the new field's value.
     *
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     *
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * might accidentally reset the new field's value.
     *
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      if (updateMask_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     *
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * might accidentally reset the new field's value.
     *
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     *
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * might accidentally reset the new field's value.
     *
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     *
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * might accidentally reset the new field's value.
     *
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. List of fields to be updated.
     *
     * To specify ALL fields, equivalent to the JSON API's "update" function,
     * specify a single field with the value `*`. Note: not recommended. If a new
     * field is introduced at a later time, an older client updating with the `*`
     * might accidentally reset the new field's value.
     *
     * Not specifying any fields is an error.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private com.google.storage.v2.CommonObjectRequestParams commonObjectRequestParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CommonObjectRequestParams,
            com.google.storage.v2.CommonObjectRequestParams.Builder,
            com.google.storage.v2.CommonObjectRequestParamsOrBuilder>
        commonObjectRequestParamsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the commonObjectRequestParams field is set.
     */
    public boolean hasCommonObjectRequestParams() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The commonObjectRequestParams.
     */
    public com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams() {
      if (commonObjectRequestParamsBuilder_ == null) {
        return commonObjectRequestParams_ == null
            ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
            : commonObjectRequestParams_;
      } else {
        return commonObjectRequestParamsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams value) {
      if (commonObjectRequestParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commonObjectRequestParams_ = value;
      } else {
        commonObjectRequestParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams.Builder builderForValue) {
      if (commonObjectRequestParamsBuilder_ == null) {
        commonObjectRequestParams_ = builderForValue.build();
      } else {
        commonObjectRequestParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams value) {
      if (commonObjectRequestParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && commonObjectRequestParams_ != null
            && commonObjectRequestParams_
                != com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()) {
          getCommonObjectRequestParamsBuilder().mergeFrom(value);
        } else {
          commonObjectRequestParams_ = value;
        }
      } else {
        commonObjectRequestParamsBuilder_.mergeFrom(value);
      }
      if (commonObjectRequestParams_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCommonObjectRequestParams() {
      bitField0_ = (bitField0_ & ~0x00000080);
      commonObjectRequestParams_ = null;
      if (commonObjectRequestParamsBuilder_ != null) {
        commonObjectRequestParamsBuilder_.dispose();
        commonObjectRequestParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.CommonObjectRequestParams.Builder
        getCommonObjectRequestParamsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCommonObjectRequestParamsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.CommonObjectRequestParamsOrBuilder
        getCommonObjectRequestParamsOrBuilder() {
      if (commonObjectRequestParamsBuilder_ != null) {
        return commonObjectRequestParamsBuilder_.getMessageOrBuilder();
      } else {
        return commonObjectRequestParams_ == null
            ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
            : commonObjectRequestParams_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CommonObjectRequestParams,
            com.google.storage.v2.CommonObjectRequestParams.Builder,
            com.google.storage.v2.CommonObjectRequestParamsOrBuilder>
        getCommonObjectRequestParamsFieldBuilder() {
      if (commonObjectRequestParamsBuilder_ == null) {
        commonObjectRequestParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.CommonObjectRequestParams,
                com.google.storage.v2.CommonObjectRequestParams.Builder,
                com.google.storage.v2.CommonObjectRequestParamsOrBuilder>(
                getCommonObjectRequestParams(), getParentForChildren(), isClean());
        commonObjectRequestParams_ = null;
      }
      return commonObjectRequestParamsBuilder_;
    }

    private boolean overrideUnlockedRetention_;

    /**
     *
     *
     * <pre>
     * Optional. Overrides the unlocked retention config on the object.
     * </pre>
     *
     * <code>bool override_unlocked_retention = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The overrideUnlockedRetention.
     */
    @java.lang.Override
    public boolean getOverrideUnlockedRetention() {
      return overrideUnlockedRetention_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Overrides the unlocked retention config on the object.
     * </pre>
     *
     * <code>bool override_unlocked_retention = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The overrideUnlockedRetention to set.
     * @return This builder for chaining.
     */
    public Builder setOverrideUnlockedRetention(boolean value) {

      overrideUnlockedRetention_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Overrides the unlocked retention config on the object.
     * </pre>
     *
     * <code>bool override_unlocked_retention = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOverrideUnlockedRetention() {
      bitField0_ = (bitField0_ & ~0x00000100);
      overrideUnlockedRetention_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.UpdateObjectRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.UpdateObjectRequest)
  private static final com.google.storage.v2.UpdateObjectRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.UpdateObjectRequest();
  }

  public static com.google.storage.v2.UpdateObjectRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateObjectRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateObjectRequest>() {
        @java.lang.Override
        public UpdateObjectRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateObjectRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateObjectRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.UpdateObjectRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
