/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2beta2/cloudtasks.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.tasks.v2beta2;

/**
 *
 *
 * <pre>
 * Request message for leasing tasks using
 * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks].
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2beta2.LeaseTasksRequest}
 */
public final class LeaseTasksRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2beta2.LeaseTasksRequest)
    LeaseTasksRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use LeaseTasksRequest.newBuilder() to construct.
  private LeaseTasksRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LeaseTasksRequest() {
    parent_ = "";
    responseView_ = 0;
    filter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LeaseTasksRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2beta2.CloudTasksProto
        .internal_static_google_cloud_tasks_v2beta2_LeaseTasksRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2beta2.CloudTasksProto
        .internal_static_google_cloud_tasks_v2beta2_LeaseTasksRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2beta2.LeaseTasksRequest.class,
            com.google.cloud.tasks.v2beta2.LeaseTasksRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The queue name. For example:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The queue name. For example:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_TASKS_FIELD_NUMBER = 2;
  private int maxTasks_ = 0;

  /**
   *
   *
   * <pre>
   * The maximum number of tasks to lease.
   *
   * The system will make a best effort to return as close to as
   * `max_tasks` as possible.
   *
   * The largest that `max_tasks` can be is 1000.
   *
   * The maximum total size of a [lease tasks
   * response][google.cloud.tasks.v2beta2.LeaseTasksResponse] is 32 MB. If the
   * sum of all task sizes requested reaches this limit, fewer tasks than
   * requested are returned.
   * </pre>
   *
   * <code>int32 max_tasks = 2;</code>
   *
   * @return The maxTasks.
   */
  @java.lang.Override
  public int getMaxTasks() {
    return maxTasks_;
  }

  public static final int LEASE_DURATION_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration leaseDuration_;

  /**
   *
   *
   * <pre>
   * Required. The duration of the lease.
   *
   * Each task returned in the
   * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
   * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
   * current time plus the `lease_duration`. The task is leased until its
   * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
   * task will not be returned to another
   * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
   * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
   *
   *
   * After the worker has successfully finished the work associated
   * with the task, the worker must call via
   * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
   * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
   * Otherwise the task will be returned to a later
   * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
   * another worker can retry it.
   *
   * The maximum lease duration is 1 week.
   * `lease_duration` will be truncated to the nearest second.
   * </pre>
   *
   * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the leaseDuration field is set.
   */
  @java.lang.Override
  public boolean hasLeaseDuration() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The duration of the lease.
   *
   * Each task returned in the
   * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
   * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
   * current time plus the `lease_duration`. The task is leased until its
   * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
   * task will not be returned to another
   * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
   * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
   *
   *
   * After the worker has successfully finished the work associated
   * with the task, the worker must call via
   * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
   * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
   * Otherwise the task will be returned to a later
   * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
   * another worker can retry it.
   *
   * The maximum lease duration is 1 week.
   * `lease_duration` will be truncated to the nearest second.
   * </pre>
   *
   * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The leaseDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getLeaseDuration() {
    return leaseDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : leaseDuration_;
  }

  /**
   *
   *
   * <pre>
   * Required. The duration of the lease.
   *
   * Each task returned in the
   * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
   * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
   * current time plus the `lease_duration`. The task is leased until its
   * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
   * task will not be returned to another
   * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
   * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
   *
   *
   * After the worker has successfully finished the work associated
   * with the task, the worker must call via
   * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
   * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
   * Otherwise the task will be returned to a later
   * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
   * another worker can retry it.
   *
   * The maximum lease duration is 1 week.
   * `lease_duration` will be truncated to the nearest second.
   * </pre>
   *
   * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getLeaseDurationOrBuilder() {
    return leaseDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : leaseDuration_;
  }

  public static final int RESPONSE_VIEW_FIELD_NUMBER = 4;
  private int responseView_ = 0;

  /**
   *
   *
   * <pre>
   * The response_view specifies which subset of the
   * [Task][google.cloud.tasks.v2beta2.Task] will be returned.
   *
   * By default response_view is
   * [BASIC][google.cloud.tasks.v2beta2.Task.View.BASIC]; not all information is
   * retrieved by default because some data, such as payloads, might be
   * desirable to return only when needed because of its large size or because
   * of the sensitivity of data that it contains.
   *
   * Authorization for [FULL][google.cloud.tasks.v2beta2.Task.View.FULL]
   * requires `cloudtasks.tasks.fullView` [Google
   * IAM](https://cloud.google.com/iam/) permission on the
   * [Task][google.cloud.tasks.v2beta2.Task] resource.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.Task.View response_view = 4;</code>
   *
   * @return The enum numeric value on the wire for responseView.
   */
  @java.lang.Override
  public int getResponseViewValue() {
    return responseView_;
  }

  /**
   *
   *
   * <pre>
   * The response_view specifies which subset of the
   * [Task][google.cloud.tasks.v2beta2.Task] will be returned.
   *
   * By default response_view is
   * [BASIC][google.cloud.tasks.v2beta2.Task.View.BASIC]; not all information is
   * retrieved by default because some data, such as payloads, might be
   * desirable to return only when needed because of its large size or because
   * of the sensitivity of data that it contains.
   *
   * Authorization for [FULL][google.cloud.tasks.v2beta2.Task.View.FULL]
   * requires `cloudtasks.tasks.fullView` [Google
   * IAM](https://cloud.google.com/iam/) permission on the
   * [Task][google.cloud.tasks.v2beta2.Task] resource.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.Task.View response_view = 4;</code>
   *
   * @return The responseView.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.Task.View getResponseView() {
    com.google.cloud.tasks.v2beta2.Task.View result =
        com.google.cloud.tasks.v2beta2.Task.View.forNumber(responseView_);
    return result == null ? com.google.cloud.tasks.v2beta2.Task.View.UNRECOGNIZED : result;
  }

  public static final int FILTER_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";

  /**
   *
   *
   * <pre>
   * `filter` can be used to specify a subset of tasks to lease.
   *
   * When `filter` is set to `tag=&lt;my-tag&gt;` then the
   * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will contain only
   * tasks whose [tag][google.cloud.tasks.v2beta2.PullMessage.tag] is equal to
   * `&lt;my-tag&gt;`. `&lt;my-tag&gt;` must be less than 500 characters.
   *
   * When `filter` is set to `tag_function=oldest_tag()`, only tasks which have
   * the same tag as the task with the oldest
   * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] will be
   * returned.
   *
   * Grammar Syntax:
   *
   * * `filter = "tag=" tag | "tag_function=" function`
   *
   * * `tag = string`
   *
   * * `function = "oldest_tag()"`
   *
   * The `oldest_tag()` function returns tasks which have the same tag as the
   * oldest task (ordered by schedule time).
   *
   * SDK compatibility: Although the SDK allows tags to be either
   * string or
   * [bytes](https://cloud.google.com/appengine/docs/standard/java/javadoc/com/google/appengine/api/taskqueue/TaskOptions.html#tag-byte:A-),
   * only UTF-8 encoded tags can be used in Cloud Tasks. Tag which
   * aren't UTF-8 encoded can't be used in the
   * [filter][google.cloud.tasks.v2beta2.LeaseTasksRequest.filter] and the
   * task's [tag][google.cloud.tasks.v2beta2.PullMessage.tag] will be displayed
   * as empty in Cloud Tasks.
   * </pre>
   *
   * <code>string filter = 5;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * `filter` can be used to specify a subset of tasks to lease.
   *
   * When `filter` is set to `tag=&lt;my-tag&gt;` then the
   * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will contain only
   * tasks whose [tag][google.cloud.tasks.v2beta2.PullMessage.tag] is equal to
   * `&lt;my-tag&gt;`. `&lt;my-tag&gt;` must be less than 500 characters.
   *
   * When `filter` is set to `tag_function=oldest_tag()`, only tasks which have
   * the same tag as the task with the oldest
   * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] will be
   * returned.
   *
   * Grammar Syntax:
   *
   * * `filter = "tag=" tag | "tag_function=" function`
   *
   * * `tag = string`
   *
   * * `function = "oldest_tag()"`
   *
   * The `oldest_tag()` function returns tasks which have the same tag as the
   * oldest task (ordered by schedule time).
   *
   * SDK compatibility: Although the SDK allows tags to be either
   * string or
   * [bytes](https://cloud.google.com/appengine/docs/standard/java/javadoc/com/google/appengine/api/taskqueue/TaskOptions.html#tag-byte:A-),
   * only UTF-8 encoded tags can be used in Cloud Tasks. Tag which
   * aren't UTF-8 encoded can't be used in the
   * [filter][google.cloud.tasks.v2beta2.LeaseTasksRequest.filter] and the
   * task's [tag][google.cloud.tasks.v2beta2.PullMessage.tag] will be displayed
   * as empty in Cloud Tasks.
   * </pre>
   *
   * <code>string filter = 5;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (maxTasks_ != 0) {
      output.writeInt32(2, maxTasks_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getLeaseDuration());
    }
    if (responseView_ != com.google.cloud.tasks.v2beta2.Task.View.VIEW_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, responseView_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, filter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (maxTasks_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxTasks_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLeaseDuration());
    }
    if (responseView_ != com.google.cloud.tasks.v2beta2.Task.View.VIEW_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, responseView_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, filter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2beta2.LeaseTasksRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2beta2.LeaseTasksRequest other =
        (com.google.cloud.tasks.v2beta2.LeaseTasksRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getMaxTasks() != other.getMaxTasks()) return false;
    if (hasLeaseDuration() != other.hasLeaseDuration()) return false;
    if (hasLeaseDuration()) {
      if (!getLeaseDuration().equals(other.getLeaseDuration())) return false;
    }
    if (responseView_ != other.responseView_) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + MAX_TASKS_FIELD_NUMBER;
    hash = (53 * hash) + getMaxTasks();
    if (hasLeaseDuration()) {
      hash = (37 * hash) + LEASE_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getLeaseDuration().hashCode();
    }
    hash = (37 * hash) + RESPONSE_VIEW_FIELD_NUMBER;
    hash = (53 * hash) + responseView_;
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2beta2.LeaseTasksRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for leasing tasks using
   * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks].
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2beta2.LeaseTasksRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2beta2.LeaseTasksRequest)
      com.google.cloud.tasks.v2beta2.LeaseTasksRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta2.CloudTasksProto
          .internal_static_google_cloud_tasks_v2beta2_LeaseTasksRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2beta2.CloudTasksProto
          .internal_static_google_cloud_tasks_v2beta2_LeaseTasksRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2beta2.LeaseTasksRequest.class,
              com.google.cloud.tasks.v2beta2.LeaseTasksRequest.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2beta2.LeaseTasksRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLeaseDurationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      maxTasks_ = 0;
      leaseDuration_ = null;
      if (leaseDurationBuilder_ != null) {
        leaseDurationBuilder_.dispose();
        leaseDurationBuilder_ = null;
      }
      responseView_ = 0;
      filter_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2beta2.CloudTasksProto
          .internal_static_google_cloud_tasks_v2beta2_LeaseTasksRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.LeaseTasksRequest getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2beta2.LeaseTasksRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.LeaseTasksRequest build() {
      com.google.cloud.tasks.v2beta2.LeaseTasksRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.LeaseTasksRequest buildPartial() {
      com.google.cloud.tasks.v2beta2.LeaseTasksRequest result =
          new com.google.cloud.tasks.v2beta2.LeaseTasksRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.tasks.v2beta2.LeaseTasksRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.maxTasks_ = maxTasks_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.leaseDuration_ =
            leaseDurationBuilder_ == null ? leaseDuration_ : leaseDurationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.responseView_ = responseView_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.filter_ = filter_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2beta2.LeaseTasksRequest) {
        return mergeFrom((com.google.cloud.tasks.v2beta2.LeaseTasksRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2beta2.LeaseTasksRequest other) {
      if (other == com.google.cloud.tasks.v2beta2.LeaseTasksRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getMaxTasks() != 0) {
        setMaxTasks(other.getMaxTasks());
      }
      if (other.hasLeaseDuration()) {
        mergeLeaseDuration(other.getLeaseDuration());
      }
      if (other.responseView_ != 0) {
        setResponseViewValue(other.getResponseViewValue());
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                maxTasks_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getLeaseDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                responseView_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The queue name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The queue name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The queue name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The queue name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The queue name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int maxTasks_;

    /**
     *
     *
     * <pre>
     * The maximum number of tasks to lease.
     *
     * The system will make a best effort to return as close to as
     * `max_tasks` as possible.
     *
     * The largest that `max_tasks` can be is 1000.
     *
     * The maximum total size of a [lease tasks
     * response][google.cloud.tasks.v2beta2.LeaseTasksResponse] is 32 MB. If the
     * sum of all task sizes requested reaches this limit, fewer tasks than
     * requested are returned.
     * </pre>
     *
     * <code>int32 max_tasks = 2;</code>
     *
     * @return The maxTasks.
     */
    @java.lang.Override
    public int getMaxTasks() {
      return maxTasks_;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of tasks to lease.
     *
     * The system will make a best effort to return as close to as
     * `max_tasks` as possible.
     *
     * The largest that `max_tasks` can be is 1000.
     *
     * The maximum total size of a [lease tasks
     * response][google.cloud.tasks.v2beta2.LeaseTasksResponse] is 32 MB. If the
     * sum of all task sizes requested reaches this limit, fewer tasks than
     * requested are returned.
     * </pre>
     *
     * <code>int32 max_tasks = 2;</code>
     *
     * @param value The maxTasks to set.
     * @return This builder for chaining.
     */
    public Builder setMaxTasks(int value) {

      maxTasks_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of tasks to lease.
     *
     * The system will make a best effort to return as close to as
     * `max_tasks` as possible.
     *
     * The largest that `max_tasks` can be is 1000.
     *
     * The maximum total size of a [lease tasks
     * response][google.cloud.tasks.v2beta2.LeaseTasksResponse] is 32 MB. If the
     * sum of all task sizes requested reaches this limit, fewer tasks than
     * requested are returned.
     * </pre>
     *
     * <code>int32 max_tasks = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxTasks() {
      bitField0_ = (bitField0_ & ~0x00000002);
      maxTasks_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration leaseDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        leaseDurationBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The duration of the lease.
     *
     * Each task returned in the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
     * current time plus the `lease_duration`. The task is leased until its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
     * task will not be returned to another
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
     * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     *
     *
     * After the worker has successfully finished the work associated
     * with the task, the worker must call via
     * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
     * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     * Otherwise the task will be returned to a later
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
     * another worker can retry it.
     *
     * The maximum lease duration is 1 week.
     * `lease_duration` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the leaseDuration field is set.
     */
    public boolean hasLeaseDuration() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The duration of the lease.
     *
     * Each task returned in the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
     * current time plus the `lease_duration`. The task is leased until its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
     * task will not be returned to another
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
     * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     *
     *
     * After the worker has successfully finished the work associated
     * with the task, the worker must call via
     * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
     * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     * Otherwise the task will be returned to a later
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
     * another worker can retry it.
     *
     * The maximum lease duration is 1 week.
     * `lease_duration` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The leaseDuration.
     */
    public com.google.protobuf.Duration getLeaseDuration() {
      if (leaseDurationBuilder_ == null) {
        return leaseDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : leaseDuration_;
      } else {
        return leaseDurationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The duration of the lease.
     *
     * Each task returned in the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
     * current time plus the `lease_duration`. The task is leased until its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
     * task will not be returned to another
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
     * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     *
     *
     * After the worker has successfully finished the work associated
     * with the task, the worker must call via
     * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
     * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     * Otherwise the task will be returned to a later
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
     * another worker can retry it.
     *
     * The maximum lease duration is 1 week.
     * `lease_duration` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setLeaseDuration(com.google.protobuf.Duration value) {
      if (leaseDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        leaseDuration_ = value;
      } else {
        leaseDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The duration of the lease.
     *
     * Each task returned in the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
     * current time plus the `lease_duration`. The task is leased until its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
     * task will not be returned to another
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
     * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     *
     *
     * After the worker has successfully finished the work associated
     * with the task, the worker must call via
     * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
     * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     * Otherwise the task will be returned to a later
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
     * another worker can retry it.
     *
     * The maximum lease duration is 1 week.
     * `lease_duration` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setLeaseDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (leaseDurationBuilder_ == null) {
        leaseDuration_ = builderForValue.build();
      } else {
        leaseDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The duration of the lease.
     *
     * Each task returned in the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
     * current time plus the `lease_duration`. The task is leased until its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
     * task will not be returned to another
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
     * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     *
     *
     * After the worker has successfully finished the work associated
     * with the task, the worker must call via
     * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
     * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     * Otherwise the task will be returned to a later
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
     * another worker can retry it.
     *
     * The maximum lease duration is 1 week.
     * `lease_duration` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeLeaseDuration(com.google.protobuf.Duration value) {
      if (leaseDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && leaseDuration_ != null
            && leaseDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getLeaseDurationBuilder().mergeFrom(value);
        } else {
          leaseDuration_ = value;
        }
      } else {
        leaseDurationBuilder_.mergeFrom(value);
      }
      if (leaseDuration_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The duration of the lease.
     *
     * Each task returned in the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
     * current time plus the `lease_duration`. The task is leased until its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
     * task will not be returned to another
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
     * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     *
     *
     * After the worker has successfully finished the work associated
     * with the task, the worker must call via
     * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
     * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     * Otherwise the task will be returned to a later
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
     * another worker can retry it.
     *
     * The maximum lease duration is 1 week.
     * `lease_duration` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearLeaseDuration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      leaseDuration_ = null;
      if (leaseDurationBuilder_ != null) {
        leaseDurationBuilder_.dispose();
        leaseDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The duration of the lease.
     *
     * Each task returned in the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
     * current time plus the `lease_duration`. The task is leased until its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
     * task will not be returned to another
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
     * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     *
     *
     * After the worker has successfully finished the work associated
     * with the task, the worker must call via
     * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
     * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     * Otherwise the task will be returned to a later
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
     * another worker can retry it.
     *
     * The maximum lease duration is 1 week.
     * `lease_duration` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getLeaseDurationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getLeaseDurationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The duration of the lease.
     *
     * Each task returned in the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
     * current time plus the `lease_duration`. The task is leased until its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
     * task will not be returned to another
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
     * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     *
     *
     * After the worker has successfully finished the work associated
     * with the task, the worker must call via
     * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
     * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     * Otherwise the task will be returned to a later
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
     * another worker can retry it.
     *
     * The maximum lease duration is 1 week.
     * `lease_duration` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getLeaseDurationOrBuilder() {
      if (leaseDurationBuilder_ != null) {
        return leaseDurationBuilder_.getMessageOrBuilder();
      } else {
        return leaseDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : leaseDuration_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The duration of the lease.
     *
     * Each task returned in the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will have its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] set to the
     * current time plus the `lease_duration`. The task is leased until its
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time]; thus, the
     * task will not be returned to another
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call before
     * its [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     *
     *
     * After the worker has successfully finished the work associated
     * with the task, the worker must call via
     * [AcknowledgeTask][google.cloud.tasks.v2beta2.CloudTasks.AcknowledgeTask]
     * before the [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time].
     * Otherwise the task will be returned to a later
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] call so that
     * another worker can retry it.
     *
     * The maximum lease duration is 1 week.
     * `lease_duration` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Duration lease_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getLeaseDurationFieldBuilder() {
      if (leaseDurationBuilder_ == null) {
        leaseDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getLeaseDuration(), getParentForChildren(), isClean());
        leaseDuration_ = null;
      }
      return leaseDurationBuilder_;
    }

    private int responseView_ = 0;

    /**
     *
     *
     * <pre>
     * The response_view specifies which subset of the
     * [Task][google.cloud.tasks.v2beta2.Task] will be returned.
     *
     * By default response_view is
     * [BASIC][google.cloud.tasks.v2beta2.Task.View.BASIC]; not all information is
     * retrieved by default because some data, such as payloads, might be
     * desirable to return only when needed because of its large size or because
     * of the sensitivity of data that it contains.
     *
     * Authorization for [FULL][google.cloud.tasks.v2beta2.Task.View.FULL]
     * requires `cloudtasks.tasks.fullView` [Google
     * IAM](https://cloud.google.com/iam/) permission on the
     * [Task][google.cloud.tasks.v2beta2.Task] resource.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.Task.View response_view = 4;</code>
     *
     * @return The enum numeric value on the wire for responseView.
     */
    @java.lang.Override
    public int getResponseViewValue() {
      return responseView_;
    }

    /**
     *
     *
     * <pre>
     * The response_view specifies which subset of the
     * [Task][google.cloud.tasks.v2beta2.Task] will be returned.
     *
     * By default response_view is
     * [BASIC][google.cloud.tasks.v2beta2.Task.View.BASIC]; not all information is
     * retrieved by default because some data, such as payloads, might be
     * desirable to return only when needed because of its large size or because
     * of the sensitivity of data that it contains.
     *
     * Authorization for [FULL][google.cloud.tasks.v2beta2.Task.View.FULL]
     * requires `cloudtasks.tasks.fullView` [Google
     * IAM](https://cloud.google.com/iam/) permission on the
     * [Task][google.cloud.tasks.v2beta2.Task] resource.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.Task.View response_view = 4;</code>
     *
     * @param value The enum numeric value on the wire for responseView to set.
     * @return This builder for chaining.
     */
    public Builder setResponseViewValue(int value) {
      responseView_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The response_view specifies which subset of the
     * [Task][google.cloud.tasks.v2beta2.Task] will be returned.
     *
     * By default response_view is
     * [BASIC][google.cloud.tasks.v2beta2.Task.View.BASIC]; not all information is
     * retrieved by default because some data, such as payloads, might be
     * desirable to return only when needed because of its large size or because
     * of the sensitivity of data that it contains.
     *
     * Authorization for [FULL][google.cloud.tasks.v2beta2.Task.View.FULL]
     * requires `cloudtasks.tasks.fullView` [Google
     * IAM](https://cloud.google.com/iam/) permission on the
     * [Task][google.cloud.tasks.v2beta2.Task] resource.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.Task.View response_view = 4;</code>
     *
     * @return The responseView.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.Task.View getResponseView() {
      com.google.cloud.tasks.v2beta2.Task.View result =
          com.google.cloud.tasks.v2beta2.Task.View.forNumber(responseView_);
      return result == null ? com.google.cloud.tasks.v2beta2.Task.View.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * The response_view specifies which subset of the
     * [Task][google.cloud.tasks.v2beta2.Task] will be returned.
     *
     * By default response_view is
     * [BASIC][google.cloud.tasks.v2beta2.Task.View.BASIC]; not all information is
     * retrieved by default because some data, such as payloads, might be
     * desirable to return only when needed because of its large size or because
     * of the sensitivity of data that it contains.
     *
     * Authorization for [FULL][google.cloud.tasks.v2beta2.Task.View.FULL]
     * requires `cloudtasks.tasks.fullView` [Google
     * IAM](https://cloud.google.com/iam/) permission on the
     * [Task][google.cloud.tasks.v2beta2.Task] resource.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.Task.View response_view = 4;</code>
     *
     * @param value The responseView to set.
     * @return This builder for chaining.
     */
    public Builder setResponseView(com.google.cloud.tasks.v2beta2.Task.View value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      responseView_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The response_view specifies which subset of the
     * [Task][google.cloud.tasks.v2beta2.Task] will be returned.
     *
     * By default response_view is
     * [BASIC][google.cloud.tasks.v2beta2.Task.View.BASIC]; not all information is
     * retrieved by default because some data, such as payloads, might be
     * desirable to return only when needed because of its large size or because
     * of the sensitivity of data that it contains.
     *
     * Authorization for [FULL][google.cloud.tasks.v2beta2.Task.View.FULL]
     * requires `cloudtasks.tasks.fullView` [Google
     * IAM](https://cloud.google.com/iam/) permission on the
     * [Task][google.cloud.tasks.v2beta2.Task] resource.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.Task.View response_view = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseView() {
      bitField0_ = (bitField0_ & ~0x00000008);
      responseView_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * `filter` can be used to specify a subset of tasks to lease.
     *
     * When `filter` is set to `tag=&lt;my-tag&gt;` then the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will contain only
     * tasks whose [tag][google.cloud.tasks.v2beta2.PullMessage.tag] is equal to
     * `&lt;my-tag&gt;`. `&lt;my-tag&gt;` must be less than 500 characters.
     *
     * When `filter` is set to `tag_function=oldest_tag()`, only tasks which have
     * the same tag as the task with the oldest
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] will be
     * returned.
     *
     * Grammar Syntax:
     *
     * * `filter = "tag=" tag | "tag_function=" function`
     *
     * * `tag = string`
     *
     * * `function = "oldest_tag()"`
     *
     * The `oldest_tag()` function returns tasks which have the same tag as the
     * oldest task (ordered by schedule time).
     *
     * SDK compatibility: Although the SDK allows tags to be either
     * string or
     * [bytes](https://cloud.google.com/appengine/docs/standard/java/javadoc/com/google/appengine/api/taskqueue/TaskOptions.html#tag-byte:A-),
     * only UTF-8 encoded tags can be used in Cloud Tasks. Tag which
     * aren't UTF-8 encoded can't be used in the
     * [filter][google.cloud.tasks.v2beta2.LeaseTasksRequest.filter] and the
     * task's [tag][google.cloud.tasks.v2beta2.PullMessage.tag] will be displayed
     * as empty in Cloud Tasks.
     * </pre>
     *
     * <code>string filter = 5;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * `filter` can be used to specify a subset of tasks to lease.
     *
     * When `filter` is set to `tag=&lt;my-tag&gt;` then the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will contain only
     * tasks whose [tag][google.cloud.tasks.v2beta2.PullMessage.tag] is equal to
     * `&lt;my-tag&gt;`. `&lt;my-tag&gt;` must be less than 500 characters.
     *
     * When `filter` is set to `tag_function=oldest_tag()`, only tasks which have
     * the same tag as the task with the oldest
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] will be
     * returned.
     *
     * Grammar Syntax:
     *
     * * `filter = "tag=" tag | "tag_function=" function`
     *
     * * `tag = string`
     *
     * * `function = "oldest_tag()"`
     *
     * The `oldest_tag()` function returns tasks which have the same tag as the
     * oldest task (ordered by schedule time).
     *
     * SDK compatibility: Although the SDK allows tags to be either
     * string or
     * [bytes](https://cloud.google.com/appengine/docs/standard/java/javadoc/com/google/appengine/api/taskqueue/TaskOptions.html#tag-byte:A-),
     * only UTF-8 encoded tags can be used in Cloud Tasks. Tag which
     * aren't UTF-8 encoded can't be used in the
     * [filter][google.cloud.tasks.v2beta2.LeaseTasksRequest.filter] and the
     * task's [tag][google.cloud.tasks.v2beta2.PullMessage.tag] will be displayed
     * as empty in Cloud Tasks.
     * </pre>
     *
     * <code>string filter = 5;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * `filter` can be used to specify a subset of tasks to lease.
     *
     * When `filter` is set to `tag=&lt;my-tag&gt;` then the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will contain only
     * tasks whose [tag][google.cloud.tasks.v2beta2.PullMessage.tag] is equal to
     * `&lt;my-tag&gt;`. `&lt;my-tag&gt;` must be less than 500 characters.
     *
     * When `filter` is set to `tag_function=oldest_tag()`, only tasks which have
     * the same tag as the task with the oldest
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] will be
     * returned.
     *
     * Grammar Syntax:
     *
     * * `filter = "tag=" tag | "tag_function=" function`
     *
     * * `tag = string`
     *
     * * `function = "oldest_tag()"`
     *
     * The `oldest_tag()` function returns tasks which have the same tag as the
     * oldest task (ordered by schedule time).
     *
     * SDK compatibility: Although the SDK allows tags to be either
     * string or
     * [bytes](https://cloud.google.com/appengine/docs/standard/java/javadoc/com/google/appengine/api/taskqueue/TaskOptions.html#tag-byte:A-),
     * only UTF-8 encoded tags can be used in Cloud Tasks. Tag which
     * aren't UTF-8 encoded can't be used in the
     * [filter][google.cloud.tasks.v2beta2.LeaseTasksRequest.filter] and the
     * task's [tag][google.cloud.tasks.v2beta2.PullMessage.tag] will be displayed
     * as empty in Cloud Tasks.
     * </pre>
     *
     * <code>string filter = 5;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * `filter` can be used to specify a subset of tasks to lease.
     *
     * When `filter` is set to `tag=&lt;my-tag&gt;` then the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will contain only
     * tasks whose [tag][google.cloud.tasks.v2beta2.PullMessage.tag] is equal to
     * `&lt;my-tag&gt;`. `&lt;my-tag&gt;` must be less than 500 characters.
     *
     * When `filter` is set to `tag_function=oldest_tag()`, only tasks which have
     * the same tag as the task with the oldest
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] will be
     * returned.
     *
     * Grammar Syntax:
     *
     * * `filter = "tag=" tag | "tag_function=" function`
     *
     * * `tag = string`
     *
     * * `function = "oldest_tag()"`
     *
     * The `oldest_tag()` function returns tasks which have the same tag as the
     * oldest task (ordered by schedule time).
     *
     * SDK compatibility: Although the SDK allows tags to be either
     * string or
     * [bytes](https://cloud.google.com/appengine/docs/standard/java/javadoc/com/google/appengine/api/taskqueue/TaskOptions.html#tag-byte:A-),
     * only UTF-8 encoded tags can be used in Cloud Tasks. Tag which
     * aren't UTF-8 encoded can't be used in the
     * [filter][google.cloud.tasks.v2beta2.LeaseTasksRequest.filter] and the
     * task's [tag][google.cloud.tasks.v2beta2.PullMessage.tag] will be displayed
     * as empty in Cloud Tasks.
     * </pre>
     *
     * <code>string filter = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * `filter` can be used to specify a subset of tasks to lease.
     *
     * When `filter` is set to `tag=&lt;my-tag&gt;` then the
     * [response][google.cloud.tasks.v2beta2.LeaseTasksResponse] will contain only
     * tasks whose [tag][google.cloud.tasks.v2beta2.PullMessage.tag] is equal to
     * `&lt;my-tag&gt;`. `&lt;my-tag&gt;` must be less than 500 characters.
     *
     * When `filter` is set to `tag_function=oldest_tag()`, only tasks which have
     * the same tag as the task with the oldest
     * [schedule_time][google.cloud.tasks.v2beta2.Task.schedule_time] will be
     * returned.
     *
     * Grammar Syntax:
     *
     * * `filter = "tag=" tag | "tag_function=" function`
     *
     * * `tag = string`
     *
     * * `function = "oldest_tag()"`
     *
     * The `oldest_tag()` function returns tasks which have the same tag as the
     * oldest task (ordered by schedule time).
     *
     * SDK compatibility: Although the SDK allows tags to be either
     * string or
     * [bytes](https://cloud.google.com/appengine/docs/standard/java/javadoc/com/google/appengine/api/taskqueue/TaskOptions.html#tag-byte:A-),
     * only UTF-8 encoded tags can be used in Cloud Tasks. Tag which
     * aren't UTF-8 encoded can't be used in the
     * [filter][google.cloud.tasks.v2beta2.LeaseTasksRequest.filter] and the
     * task's [tag][google.cloud.tasks.v2beta2.PullMessage.tag] will be displayed
     * as empty in Cloud Tasks.
     * </pre>
     *
     * <code>string filter = 5;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2beta2.LeaseTasksRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2beta2.LeaseTasksRequest)
  private static final com.google.cloud.tasks.v2beta2.LeaseTasksRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2beta2.LeaseTasksRequest();
  }

  public static com.google.cloud.tasks.v2beta2.LeaseTasksRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LeaseTasksRequest> PARSER =
      new com.google.protobuf.AbstractParser<LeaseTasksRequest>() {
        @java.lang.Override
        public LeaseTasksRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LeaseTasksRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LeaseTasksRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.LeaseTasksRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
