/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/workstations/v1/workstations.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.workstations.v1;

/**
 *
 *
 * <pre>
 * Response message for ListUsableWorkstationConfigs.
 * </pre>
 *
 * Protobuf type {@code google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse}
 */
public final class ListUsableWorkstationConfigsResponse
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse)
    ListUsableWorkstationConfigsResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ListUsableWorkstationConfigsResponse.newBuilder() to construct.
  private ListUsableWorkstationConfigsResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListUsableWorkstationConfigsResponse() {
    workstationConfigs_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListUsableWorkstationConfigsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.workstations.v1.WorkstationsProto
        .internal_static_google_cloud_workstations_v1_ListUsableWorkstationConfigsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.workstations.v1.WorkstationsProto
        .internal_static_google_cloud_workstations_v1_ListUsableWorkstationConfigsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse.class,
            com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse.Builder.class);
  }

  public static final int WORKSTATION_CONFIGS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.workstations.v1.WorkstationConfig> workstationConfigs_;

  /**
   *
   *
   * <pre>
   * The requested configs.
   * </pre>
   *
   * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.workstations.v1.WorkstationConfig>
      getWorkstationConfigsList() {
    return workstationConfigs_;
  }

  /**
   *
   *
   * <pre>
   * The requested configs.
   * </pre>
   *
   * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.workstations.v1.WorkstationConfigOrBuilder>
      getWorkstationConfigsOrBuilderList() {
    return workstationConfigs_;
  }

  /**
   *
   *
   * <pre>
   * The requested configs.
   * </pre>
   *
   * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;</code>
   */
  @java.lang.Override
  public int getWorkstationConfigsCount() {
    return workstationConfigs_.size();
  }

  /**
   *
   *
   * <pre>
   * The requested configs.
   * </pre>
   *
   * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig getWorkstationConfigs(int index) {
    return workstationConfigs_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The requested configs.
   * </pre>
   *
   * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfigOrBuilder getWorkstationConfigsOrBuilder(
      int index) {
    return workstationConfigs_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";

  /**
   *
   *
   * <pre>
   * Token to retrieve the next page of results, or empty if there are no more
   * results in the list.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Token to retrieve the next page of results, or empty if there are no more
   * results in the list.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNREACHABLE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList unreachable_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Unreachable resources.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return A list containing the unreachable.
   */
  public com.google.protobuf.ProtocolStringList getUnreachableList() {
    return unreachable_;
  }

  /**
   *
   *
   * <pre>
   * Unreachable resources.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return The count of unreachable.
   */
  public int getUnreachableCount() {
    return unreachable_.size();
  }

  /**
   *
   *
   * <pre>
   * Unreachable resources.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The unreachable at the given index.
   */
  public java.lang.String getUnreachable(int index) {
    return unreachable_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Unreachable resources.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unreachable at the given index.
   */
  public com.google.protobuf.ByteString getUnreachableBytes(int index) {
    return unreachable_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < workstationConfigs_.size(); i++) {
      output.writeMessage(1, workstationConfigs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    for (int i = 0; i < unreachable_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, unreachable_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < workstationConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, workstationConfigs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unreachable_.size(); i++) {
        dataSize += computeStringSizeNoTag(unreachable_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnreachableList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse other =
        (com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse) obj;

    if (!getWorkstationConfigsList().equals(other.getWorkstationConfigsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnreachableList().equals(other.getUnreachableList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getWorkstationConfigsCount() > 0) {
      hash = (37 * hash) + WORKSTATION_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getWorkstationConfigsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getUnreachableCount() > 0) {
      hash = (37 * hash) + UNREACHABLE_FIELD_NUMBER;
      hash = (53 * hash) + getUnreachableList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Response message for ListUsableWorkstationConfigs.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse)
      com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_ListUsableWorkstationConfigsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_ListUsableWorkstationConfigsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse.class,
              com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse.Builder.class);
    }

    // Construct using
    // com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (workstationConfigsBuilder_ == null) {
        workstationConfigs_ = java.util.Collections.emptyList();
      } else {
        workstationConfigs_ = null;
        workstationConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_ListUsableWorkstationConfigsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse build() {
      com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse buildPartial() {
      com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse result =
          new com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse result) {
      if (workstationConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          workstationConfigs_ = java.util.Collections.unmodifiableList(workstationConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.workstationConfigs_ = workstationConfigs_;
      } else {
        result.workstationConfigs_ = workstationConfigsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        unreachable_.makeImmutable();
        result.unreachable_ = unreachable_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse) {
        return mergeFrom(
            (com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse other) {
      if (other
          == com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse
              .getDefaultInstance()) return this;
      if (workstationConfigsBuilder_ == null) {
        if (!other.workstationConfigs_.isEmpty()) {
          if (workstationConfigs_.isEmpty()) {
            workstationConfigs_ = other.workstationConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureWorkstationConfigsIsMutable();
            workstationConfigs_.addAll(other.workstationConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.workstationConfigs_.isEmpty()) {
          if (workstationConfigsBuilder_.isEmpty()) {
            workstationConfigsBuilder_.dispose();
            workstationConfigsBuilder_ = null;
            workstationConfigs_ = other.workstationConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            workstationConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWorkstationConfigsFieldBuilder()
                    : null;
          } else {
            workstationConfigsBuilder_.addAllMessages(other.workstationConfigs_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.unreachable_.isEmpty()) {
        if (unreachable_.isEmpty()) {
          unreachable_ = other.unreachable_;
          bitField0_ |= 0x00000004;
        } else {
          ensureUnreachableIsMutable();
          unreachable_.addAll(other.unreachable_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.workstations.v1.WorkstationConfig m =
                    input.readMessage(
                        com.google.cloud.workstations.v1.WorkstationConfig.parser(),
                        extensionRegistry);
                if (workstationConfigsBuilder_ == null) {
                  ensureWorkstationConfigsIsMutable();
                  workstationConfigs_.add(m);
                } else {
                  workstationConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnreachableIsMutable();
                unreachable_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.workstations.v1.WorkstationConfig> workstationConfigs_ =
        java.util.Collections.emptyList();

    private void ensureWorkstationConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        workstationConfigs_ =
            new java.util.ArrayList<com.google.cloud.workstations.v1.WorkstationConfig>(
                workstationConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig,
            com.google.cloud.workstations.v1.WorkstationConfig.Builder,
            com.google.cloud.workstations.v1.WorkstationConfigOrBuilder>
        workstationConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.workstations.v1.WorkstationConfig>
        getWorkstationConfigsList() {
      if (workstationConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(workstationConfigs_);
      } else {
        return workstationConfigsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public int getWorkstationConfigsCount() {
      if (workstationConfigsBuilder_ == null) {
        return workstationConfigs_.size();
      } else {
        return workstationConfigsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig getWorkstationConfigs(int index) {
      if (workstationConfigsBuilder_ == null) {
        return workstationConfigs_.get(index);
      } else {
        return workstationConfigsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public Builder setWorkstationConfigs(
        int index, com.google.cloud.workstations.v1.WorkstationConfig value) {
      if (workstationConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkstationConfigsIsMutable();
        workstationConfigs_.set(index, value);
        onChanged();
      } else {
        workstationConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public Builder setWorkstationConfigs(
        int index, com.google.cloud.workstations.v1.WorkstationConfig.Builder builderForValue) {
      if (workstationConfigsBuilder_ == null) {
        ensureWorkstationConfigsIsMutable();
        workstationConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        workstationConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public Builder addWorkstationConfigs(com.google.cloud.workstations.v1.WorkstationConfig value) {
      if (workstationConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkstationConfigsIsMutable();
        workstationConfigs_.add(value);
        onChanged();
      } else {
        workstationConfigsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public Builder addWorkstationConfigs(
        int index, com.google.cloud.workstations.v1.WorkstationConfig value) {
      if (workstationConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkstationConfigsIsMutable();
        workstationConfigs_.add(index, value);
        onChanged();
      } else {
        workstationConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public Builder addWorkstationConfigs(
        com.google.cloud.workstations.v1.WorkstationConfig.Builder builderForValue) {
      if (workstationConfigsBuilder_ == null) {
        ensureWorkstationConfigsIsMutable();
        workstationConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        workstationConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public Builder addWorkstationConfigs(
        int index, com.google.cloud.workstations.v1.WorkstationConfig.Builder builderForValue) {
      if (workstationConfigsBuilder_ == null) {
        ensureWorkstationConfigsIsMutable();
        workstationConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        workstationConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public Builder addAllWorkstationConfigs(
        java.lang.Iterable<? extends com.google.cloud.workstations.v1.WorkstationConfig> values) {
      if (workstationConfigsBuilder_ == null) {
        ensureWorkstationConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, workstationConfigs_);
        onChanged();
      } else {
        workstationConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public Builder clearWorkstationConfigs() {
      if (workstationConfigsBuilder_ == null) {
        workstationConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        workstationConfigsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public Builder removeWorkstationConfigs(int index) {
      if (workstationConfigsBuilder_ == null) {
        ensureWorkstationConfigsIsMutable();
        workstationConfigs_.remove(index);
        onChanged();
      } else {
        workstationConfigsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.Builder getWorkstationConfigsBuilder(
        int index) {
      return getWorkstationConfigsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfigOrBuilder
        getWorkstationConfigsOrBuilder(int index) {
      if (workstationConfigsBuilder_ == null) {
        return workstationConfigs_.get(index);
      } else {
        return workstationConfigsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.workstations.v1.WorkstationConfigOrBuilder>
        getWorkstationConfigsOrBuilderList() {
      if (workstationConfigsBuilder_ != null) {
        return workstationConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(workstationConfigs_);
      }
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.Builder
        addWorkstationConfigsBuilder() {
      return getWorkstationConfigsFieldBuilder()
          .addBuilder(com.google.cloud.workstations.v1.WorkstationConfig.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.Builder addWorkstationConfigsBuilder(
        int index) {
      return getWorkstationConfigsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.workstations.v1.WorkstationConfig.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The requested configs.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1.WorkstationConfig workstation_configs = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.workstations.v1.WorkstationConfig.Builder>
        getWorkstationConfigsBuilderList() {
      return getWorkstationConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig,
            com.google.cloud.workstations.v1.WorkstationConfig.Builder,
            com.google.cloud.workstations.v1.WorkstationConfigOrBuilder>
        getWorkstationConfigsFieldBuilder() {
      if (workstationConfigsBuilder_ == null) {
        workstationConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.workstations.v1.WorkstationConfig,
                com.google.cloud.workstations.v1.WorkstationConfig.Builder,
                com.google.cloud.workstations.v1.WorkstationConfigOrBuilder>(
                workstationConfigs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        workstationConfigs_ = null;
      }
      return workstationConfigsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";

    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList unreachable_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUnreachableIsMutable() {
      if (!unreachable_.isModifiable()) {
        unreachable_ = new com.google.protobuf.LazyStringArrayList(unreachable_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return A list containing the unreachable.
     */
    public com.google.protobuf.ProtocolStringList getUnreachableList() {
      unreachable_.makeImmutable();
      return unreachable_;
    }

    /**
     *
     *
     * <pre>
     * Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return The count of unreachable.
     */
    public int getUnreachableCount() {
      return unreachable_.size();
    }

    /**
     *
     *
     * <pre>
     * Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The unreachable at the given index.
     */
    public java.lang.String getUnreachable(int index) {
      return unreachable_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unreachable at the given index.
     */
    public com.google.protobuf.ByteString getUnreachableBytes(int index) {
      return unreachable_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The unreachable to set.
     * @return This builder for chaining.
     */
    public Builder setUnreachable(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param values The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnreachable(java.lang.Iterable<java.lang.String> values) {
      ensureUnreachableIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unreachable_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnreachable() {
      unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The bytes of the unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse)
  private static final com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse();
  }

  public static com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListUsableWorkstationConfigsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListUsableWorkstationConfigsResponse>() {
        @java.lang.Override
        public ListUsableWorkstationConfigsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListUsableWorkstationConfigsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListUsableWorkstationConfigsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
