/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.5
package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * An icon displayed in a widget on a card. For an example in Google Chat apps,
 * see [Add an
 * icon](https://developers.google.com/workspace/chat/add-text-image-card-dialog#add_an_icon).
 *
 * Supports
 * [built-in](https://developers.google.com/workspace/chat/format-messages#builtinicons)
 * and
 * [custom](https://developers.google.com/workspace/chat/format-messages#customicons)
 * icons.
 *
 * [Google Workspace Add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.Icon}
 */
public final class Icon extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.Icon)
    IconOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Icon.newBuilder() to construct.
  private Icon(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Icon() {
    altText_ = "";
    imageType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Icon();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Icon_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_Icon_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.Icon.class, com.google.apps.card.v1.Icon.Builder.class);
  }

  private int iconsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object icons_;

  public enum IconsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    KNOWN_ICON(1),
    ICON_URL(2),
    MATERIAL_ICON(5),
    ICONS_NOT_SET(0);
    private final int value;

    private IconsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IconsCase valueOf(int value) {
      return forNumber(value);
    }

    public static IconsCase forNumber(int value) {
      switch (value) {
        case 1:
          return KNOWN_ICON;
        case 2:
          return ICON_URL;
        case 5:
          return MATERIAL_ICON;
        case 0:
          return ICONS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public IconsCase getIconsCase() {
    return IconsCase.forNumber(iconsCase_);
  }

  public static final int KNOWN_ICON_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Display one of the built-in icons provided by Google Workspace.
   *
   * For example, to display an airplane icon, specify `AIRPLANE`.
   * For a bus, specify `BUS`.
   *
   * For a full list of supported icons, see [built-in
   * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
   * </pre>
   *
   * <code>string known_icon = 1;</code>
   *
   * @return Whether the knownIcon field is set.
   */
  public boolean hasKnownIcon() {
    return iconsCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Display one of the built-in icons provided by Google Workspace.
   *
   * For example, to display an airplane icon, specify `AIRPLANE`.
   * For a bus, specify `BUS`.
   *
   * For a full list of supported icons, see [built-in
   * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
   * </pre>
   *
   * <code>string known_icon = 1;</code>
   *
   * @return The knownIcon.
   */
  public java.lang.String getKnownIcon() {
    java.lang.Object ref = "";
    if (iconsCase_ == 1) {
      ref = icons_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (iconsCase_ == 1) {
        icons_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Display one of the built-in icons provided by Google Workspace.
   *
   * For example, to display an airplane icon, specify `AIRPLANE`.
   * For a bus, specify `BUS`.
   *
   * For a full list of supported icons, see [built-in
   * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
   * </pre>
   *
   * <code>string known_icon = 1;</code>
   *
   * @return The bytes for knownIcon.
   */
  public com.google.protobuf.ByteString getKnownIconBytes() {
    java.lang.Object ref = "";
    if (iconsCase_ == 1) {
      ref = icons_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (iconsCase_ == 1) {
        icons_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ICON_URL_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Display a custom icon hosted at an HTTPS URL.
   *
   * For example:
   *
   * ```
   * "iconUrl":
   * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
   * ```
   *
   * Supported file types include `.png` and `.jpg`.
   * </pre>
   *
   * <code>string icon_url = 2;</code>
   *
   * @return Whether the iconUrl field is set.
   */
  public boolean hasIconUrl() {
    return iconsCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Display a custom icon hosted at an HTTPS URL.
   *
   * For example:
   *
   * ```
   * "iconUrl":
   * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
   * ```
   *
   * Supported file types include `.png` and `.jpg`.
   * </pre>
   *
   * <code>string icon_url = 2;</code>
   *
   * @return The iconUrl.
   */
  public java.lang.String getIconUrl() {
    java.lang.Object ref = "";
    if (iconsCase_ == 2) {
      ref = icons_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (iconsCase_ == 2) {
        icons_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Display a custom icon hosted at an HTTPS URL.
   *
   * For example:
   *
   * ```
   * "iconUrl":
   * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
   * ```
   *
   * Supported file types include `.png` and `.jpg`.
   * </pre>
   *
   * <code>string icon_url = 2;</code>
   *
   * @return The bytes for iconUrl.
   */
  public com.google.protobuf.ByteString getIconUrlBytes() {
    java.lang.Object ref = "";
    if (iconsCase_ == 2) {
      ref = icons_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (iconsCase_ == 2) {
        icons_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATERIAL_ICON_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Display one of the [Google Material
   * Icons](https://fonts.google.com/icons).
   *
   * For example, to display a [checkbox
   * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
   * use
   * ```
   * "material_icon": {
   *   "name": "check_box"
   * }
   * ```
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
   *
   * @return Whether the materialIcon field is set.
   */
  @java.lang.Override
  public boolean hasMaterialIcon() {
    return iconsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Display one of the [Google Material
   * Icons](https://fonts.google.com/icons).
   *
   * For example, to display a [checkbox
   * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
   * use
   * ```
   * "material_icon": {
   *   "name": "check_box"
   * }
   * ```
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
   *
   * @return The materialIcon.
   */
  @java.lang.Override
  public com.google.apps.card.v1.MaterialIcon getMaterialIcon() {
    if (iconsCase_ == 5) {
      return (com.google.apps.card.v1.MaterialIcon) icons_;
    }
    return com.google.apps.card.v1.MaterialIcon.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display one of the [Google Material
   * Icons](https://fonts.google.com/icons).
   *
   * For example, to display a [checkbox
   * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
   * use
   * ```
   * "material_icon": {
   *   "name": "check_box"
   * }
   * ```
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.MaterialIconOrBuilder getMaterialIconOrBuilder() {
    if (iconsCase_ == 5) {
      return (com.google.apps.card.v1.MaterialIcon) icons_;
    }
    return com.google.apps.card.v1.MaterialIcon.getDefaultInstance();
  }

  public static final int ALT_TEXT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object altText_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A description of the icon used for accessibility.
   * If unspecified, the default value `Button` is provided. As a best practice,
   * you should set a helpful description for what the icon displays, and if
   * applicable, what it does. For example, `A user's account portrait`, or
   * `Opens a new browser tab and navigates to the Google Chat developer
   * documentation at https://developers.google.com/workspace/chat`.
   *
   * If the icon is set in a [`Button`][google.apps.card.v1.Button], the
   * `altText` appears as helper text when the user hovers over the button.
   * However, if the button also sets `text`, the icon's `altText` is ignored.
   * </pre>
   *
   * <code>string alt_text = 3;</code>
   *
   * @return The altText.
   */
  @java.lang.Override
  public java.lang.String getAltText() {
    java.lang.Object ref = altText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      altText_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A description of the icon used for accessibility.
   * If unspecified, the default value `Button` is provided. As a best practice,
   * you should set a helpful description for what the icon displays, and if
   * applicable, what it does. For example, `A user's account portrait`, or
   * `Opens a new browser tab and navigates to the Google Chat developer
   * documentation at https://developers.google.com/workspace/chat`.
   *
   * If the icon is set in a [`Button`][google.apps.card.v1.Button], the
   * `altText` appears as helper text when the user hovers over the button.
   * However, if the button also sets `text`, the icon's `altText` is ignored.
   * </pre>
   *
   * <code>string alt_text = 3;</code>
   *
   * @return The bytes for altText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAltTextBytes() {
    java.lang.Object ref = altText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      altText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMAGE_TYPE_FIELD_NUMBER = 4;
  private int imageType_ = 0;
  /**
   *
   *
   * <pre>
   * The crop style applied to the image. In some cases, applying a
   * `CIRCLE` crop causes the image to be drawn larger than a built-in
   * icon.
   * </pre>
   *
   * <code>.google.apps.card.v1.Widget.ImageType image_type = 4;</code>
   *
   * @return The enum numeric value on the wire for imageType.
   */
  @java.lang.Override
  public int getImageTypeValue() {
    return imageType_;
  }
  /**
   *
   *
   * <pre>
   * The crop style applied to the image. In some cases, applying a
   * `CIRCLE` crop causes the image to be drawn larger than a built-in
   * icon.
   * </pre>
   *
   * <code>.google.apps.card.v1.Widget.ImageType image_type = 4;</code>
   *
   * @return The imageType.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Widget.ImageType getImageType() {
    com.google.apps.card.v1.Widget.ImageType result =
        com.google.apps.card.v1.Widget.ImageType.forNumber(imageType_);
    return result == null ? com.google.apps.card.v1.Widget.ImageType.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (iconsCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, icons_);
    }
    if (iconsCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, icons_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(altText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, altText_);
    }
    if (imageType_ != com.google.apps.card.v1.Widget.ImageType.SQUARE.getNumber()) {
      output.writeEnum(4, imageType_);
    }
    if (iconsCase_ == 5) {
      output.writeMessage(5, (com.google.apps.card.v1.MaterialIcon) icons_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (iconsCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, icons_);
    }
    if (iconsCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, icons_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(altText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, altText_);
    }
    if (imageType_ != com.google.apps.card.v1.Widget.ImageType.SQUARE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, imageType_);
    }
    if (iconsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.apps.card.v1.MaterialIcon) icons_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.Icon)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.Icon other = (com.google.apps.card.v1.Icon) obj;

    if (!getAltText().equals(other.getAltText())) return false;
    if (imageType_ != other.imageType_) return false;
    if (!getIconsCase().equals(other.getIconsCase())) return false;
    switch (iconsCase_) {
      case 1:
        if (!getKnownIcon().equals(other.getKnownIcon())) return false;
        break;
      case 2:
        if (!getIconUrl().equals(other.getIconUrl())) return false;
        break;
      case 5:
        if (!getMaterialIcon().equals(other.getMaterialIcon())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ALT_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getAltText().hashCode();
    hash = (37 * hash) + IMAGE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + imageType_;
    switch (iconsCase_) {
      case 1:
        hash = (37 * hash) + KNOWN_ICON_FIELD_NUMBER;
        hash = (53 * hash) + getKnownIcon().hashCode();
        break;
      case 2:
        hash = (37 * hash) + ICON_URL_FIELD_NUMBER;
        hash = (53 * hash) + getIconUrl().hashCode();
        break;
      case 5:
        hash = (37 * hash) + MATERIAL_ICON_FIELD_NUMBER;
        hash = (53 * hash) + getMaterialIcon().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.Icon parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Icon parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Icon parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Icon parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Icon parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Icon parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Icon parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Icon parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Icon parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Icon parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Icon parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Icon parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.Icon prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An icon displayed in a widget on a card. For an example in Google Chat apps,
   * see [Add an
   * icon](https://developers.google.com/workspace/chat/add-text-image-card-dialog#add_an_icon).
   *
   * Supports
   * [built-in](https://developers.google.com/workspace/chat/format-messages#builtinicons)
   * and
   * [custom](https://developers.google.com/workspace/chat/format-messages#customicons)
   * icons.
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Icon}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Icon)
      com.google.apps.card.v1.IconOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Icon_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Icon_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Icon.class, com.google.apps.card.v1.Icon.Builder.class);
    }

    // Construct using com.google.apps.card.v1.Icon.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (materialIconBuilder_ != null) {
        materialIconBuilder_.clear();
      }
      altText_ = "";
      imageType_ = 0;
      iconsCase_ = 0;
      icons_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Icon_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Icon getDefaultInstanceForType() {
      return com.google.apps.card.v1.Icon.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.Icon build() {
      com.google.apps.card.v1.Icon result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Icon buildPartial() {
      com.google.apps.card.v1.Icon result = new com.google.apps.card.v1.Icon(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.apps.card.v1.Icon result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.altText_ = altText_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.imageType_ = imageType_;
      }
    }

    private void buildPartialOneofs(com.google.apps.card.v1.Icon result) {
      result.iconsCase_ = iconsCase_;
      result.icons_ = this.icons_;
      if (iconsCase_ == 5 && materialIconBuilder_ != null) {
        result.icons_ = materialIconBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.Icon) {
        return mergeFrom((com.google.apps.card.v1.Icon) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.Icon other) {
      if (other == com.google.apps.card.v1.Icon.getDefaultInstance()) return this;
      if (!other.getAltText().isEmpty()) {
        altText_ = other.altText_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.imageType_ != 0) {
        setImageTypeValue(other.getImageTypeValue());
      }
      switch (other.getIconsCase()) {
        case KNOWN_ICON:
          {
            iconsCase_ = 1;
            icons_ = other.icons_;
            onChanged();
            break;
          }
        case ICON_URL:
          {
            iconsCase_ = 2;
            icons_ = other.icons_;
            onChanged();
            break;
          }
        case MATERIAL_ICON:
          {
            mergeMaterialIcon(other.getMaterialIcon());
            break;
          }
        case ICONS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                iconsCase_ = 1;
                icons_ = s;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                iconsCase_ = 2;
                icons_ = s;
                break;
              } // case 18
            case 26:
              {
                altText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 32:
              {
                imageType_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getMaterialIconFieldBuilder().getBuilder(), extensionRegistry);
                iconsCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int iconsCase_ = 0;
    private java.lang.Object icons_;

    public IconsCase getIconsCase() {
      return IconsCase.forNumber(iconsCase_);
    }

    public Builder clearIcons() {
      iconsCase_ = 0;
      icons_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Display one of the built-in icons provided by Google Workspace.
     *
     * For example, to display an airplane icon, specify `AIRPLANE`.
     * For a bus, specify `BUS`.
     *
     * For a full list of supported icons, see [built-in
     * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
     * </pre>
     *
     * <code>string known_icon = 1;</code>
     *
     * @return Whether the knownIcon field is set.
     */
    @java.lang.Override
    public boolean hasKnownIcon() {
      return iconsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Display one of the built-in icons provided by Google Workspace.
     *
     * For example, to display an airplane icon, specify `AIRPLANE`.
     * For a bus, specify `BUS`.
     *
     * For a full list of supported icons, see [built-in
     * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
     * </pre>
     *
     * <code>string known_icon = 1;</code>
     *
     * @return The knownIcon.
     */
    @java.lang.Override
    public java.lang.String getKnownIcon() {
      java.lang.Object ref = "";
      if (iconsCase_ == 1) {
        ref = icons_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (iconsCase_ == 1) {
          icons_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display one of the built-in icons provided by Google Workspace.
     *
     * For example, to display an airplane icon, specify `AIRPLANE`.
     * For a bus, specify `BUS`.
     *
     * For a full list of supported icons, see [built-in
     * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
     * </pre>
     *
     * <code>string known_icon = 1;</code>
     *
     * @return The bytes for knownIcon.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKnownIconBytes() {
      java.lang.Object ref = "";
      if (iconsCase_ == 1) {
        ref = icons_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (iconsCase_ == 1) {
          icons_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display one of the built-in icons provided by Google Workspace.
     *
     * For example, to display an airplane icon, specify `AIRPLANE`.
     * For a bus, specify `BUS`.
     *
     * For a full list of supported icons, see [built-in
     * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
     * </pre>
     *
     * <code>string known_icon = 1;</code>
     *
     * @param value The knownIcon to set.
     * @return This builder for chaining.
     */
    public Builder setKnownIcon(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      iconsCase_ = 1;
      icons_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display one of the built-in icons provided by Google Workspace.
     *
     * For example, to display an airplane icon, specify `AIRPLANE`.
     * For a bus, specify `BUS`.
     *
     * For a full list of supported icons, see [built-in
     * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
     * </pre>
     *
     * <code>string known_icon = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKnownIcon() {
      if (iconsCase_ == 1) {
        iconsCase_ = 0;
        icons_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display one of the built-in icons provided by Google Workspace.
     *
     * For example, to display an airplane icon, specify `AIRPLANE`.
     * For a bus, specify `BUS`.
     *
     * For a full list of supported icons, see [built-in
     * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
     * </pre>
     *
     * <code>string known_icon = 1;</code>
     *
     * @param value The bytes for knownIcon to set.
     * @return This builder for chaining.
     */
    public Builder setKnownIconBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      iconsCase_ = 1;
      icons_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Display a custom icon hosted at an HTTPS URL.
     *
     * For example:
     *
     * ```
     * "iconUrl":
     * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
     * ```
     *
     * Supported file types include `.png` and `.jpg`.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @return Whether the iconUrl field is set.
     */
    @java.lang.Override
    public boolean hasIconUrl() {
      return iconsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Display a custom icon hosted at an HTTPS URL.
     *
     * For example:
     *
     * ```
     * "iconUrl":
     * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
     * ```
     *
     * Supported file types include `.png` and `.jpg`.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @return The iconUrl.
     */
    @java.lang.Override
    public java.lang.String getIconUrl() {
      java.lang.Object ref = "";
      if (iconsCase_ == 2) {
        ref = icons_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (iconsCase_ == 2) {
          icons_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display a custom icon hosted at an HTTPS URL.
     *
     * For example:
     *
     * ```
     * "iconUrl":
     * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
     * ```
     *
     * Supported file types include `.png` and `.jpg`.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @return The bytes for iconUrl.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIconUrlBytes() {
      java.lang.Object ref = "";
      if (iconsCase_ == 2) {
        ref = icons_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (iconsCase_ == 2) {
          icons_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display a custom icon hosted at an HTTPS URL.
     *
     * For example:
     *
     * ```
     * "iconUrl":
     * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
     * ```
     *
     * Supported file types include `.png` and `.jpg`.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @param value The iconUrl to set.
     * @return This builder for chaining.
     */
    public Builder setIconUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      iconsCase_ = 2;
      icons_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display a custom icon hosted at an HTTPS URL.
     *
     * For example:
     *
     * ```
     * "iconUrl":
     * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
     * ```
     *
     * Supported file types include `.png` and `.jpg`.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIconUrl() {
      if (iconsCase_ == 2) {
        iconsCase_ = 0;
        icons_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display a custom icon hosted at an HTTPS URL.
     *
     * For example:
     *
     * ```
     * "iconUrl":
     * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
     * ```
     *
     * Supported file types include `.png` and `.jpg`.
     * </pre>
     *
     * <code>string icon_url = 2;</code>
     *
     * @param value The bytes for iconUrl to set.
     * @return This builder for chaining.
     */
    public Builder setIconUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      iconsCase_ = 2;
      icons_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.MaterialIcon,
            com.google.apps.card.v1.MaterialIcon.Builder,
            com.google.apps.card.v1.MaterialIconOrBuilder>
        materialIconBuilder_;
    /**
     *
     *
     * <pre>
     * Display one of the [Google Material
     * Icons](https://fonts.google.com/icons).
     *
     * For example, to display a [checkbox
     * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
     * use
     * ```
     * "material_icon": {
     *   "name": "check_box"
     * }
     * ```
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
     *
     * @return Whether the materialIcon field is set.
     */
    @java.lang.Override
    public boolean hasMaterialIcon() {
      return iconsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Display one of the [Google Material
     * Icons](https://fonts.google.com/icons).
     *
     * For example, to display a [checkbox
     * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
     * use
     * ```
     * "material_icon": {
     *   "name": "check_box"
     * }
     * ```
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
     *
     * @return The materialIcon.
     */
    @java.lang.Override
    public com.google.apps.card.v1.MaterialIcon getMaterialIcon() {
      if (materialIconBuilder_ == null) {
        if (iconsCase_ == 5) {
          return (com.google.apps.card.v1.MaterialIcon) icons_;
        }
        return com.google.apps.card.v1.MaterialIcon.getDefaultInstance();
      } else {
        if (iconsCase_ == 5) {
          return materialIconBuilder_.getMessage();
        }
        return com.google.apps.card.v1.MaterialIcon.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display one of the [Google Material
     * Icons](https://fonts.google.com/icons).
     *
     * For example, to display a [checkbox
     * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
     * use
     * ```
     * "material_icon": {
     *   "name": "check_box"
     * }
     * ```
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
     */
    public Builder setMaterialIcon(com.google.apps.card.v1.MaterialIcon value) {
      if (materialIconBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        icons_ = value;
        onChanged();
      } else {
        materialIconBuilder_.setMessage(value);
      }
      iconsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display one of the [Google Material
     * Icons](https://fonts.google.com/icons).
     *
     * For example, to display a [checkbox
     * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
     * use
     * ```
     * "material_icon": {
     *   "name": "check_box"
     * }
     * ```
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
     */
    public Builder setMaterialIcon(com.google.apps.card.v1.MaterialIcon.Builder builderForValue) {
      if (materialIconBuilder_ == null) {
        icons_ = builderForValue.build();
        onChanged();
      } else {
        materialIconBuilder_.setMessage(builderForValue.build());
      }
      iconsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display one of the [Google Material
     * Icons](https://fonts.google.com/icons).
     *
     * For example, to display a [checkbox
     * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
     * use
     * ```
     * "material_icon": {
     *   "name": "check_box"
     * }
     * ```
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
     */
    public Builder mergeMaterialIcon(com.google.apps.card.v1.MaterialIcon value) {
      if (materialIconBuilder_ == null) {
        if (iconsCase_ == 5
            && icons_ != com.google.apps.card.v1.MaterialIcon.getDefaultInstance()) {
          icons_ =
              com.google.apps.card.v1.MaterialIcon.newBuilder(
                      (com.google.apps.card.v1.MaterialIcon) icons_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          icons_ = value;
        }
        onChanged();
      } else {
        if (iconsCase_ == 5) {
          materialIconBuilder_.mergeFrom(value);
        } else {
          materialIconBuilder_.setMessage(value);
        }
      }
      iconsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display one of the [Google Material
     * Icons](https://fonts.google.com/icons).
     *
     * For example, to display a [checkbox
     * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
     * use
     * ```
     * "material_icon": {
     *   "name": "check_box"
     * }
     * ```
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
     */
    public Builder clearMaterialIcon() {
      if (materialIconBuilder_ == null) {
        if (iconsCase_ == 5) {
          iconsCase_ = 0;
          icons_ = null;
          onChanged();
        }
      } else {
        if (iconsCase_ == 5) {
          iconsCase_ = 0;
          icons_ = null;
        }
        materialIconBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display one of the [Google Material
     * Icons](https://fonts.google.com/icons).
     *
     * For example, to display a [checkbox
     * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
     * use
     * ```
     * "material_icon": {
     *   "name": "check_box"
     * }
     * ```
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
     */
    public com.google.apps.card.v1.MaterialIcon.Builder getMaterialIconBuilder() {
      return getMaterialIconFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display one of the [Google Material
     * Icons](https://fonts.google.com/icons).
     *
     * For example, to display a [checkbox
     * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
     * use
     * ```
     * "material_icon": {
     *   "name": "check_box"
     * }
     * ```
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.MaterialIconOrBuilder getMaterialIconOrBuilder() {
      if ((iconsCase_ == 5) && (materialIconBuilder_ != null)) {
        return materialIconBuilder_.getMessageOrBuilder();
      } else {
        if (iconsCase_ == 5) {
          return (com.google.apps.card.v1.MaterialIcon) icons_;
        }
        return com.google.apps.card.v1.MaterialIcon.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display one of the [Google Material
     * Icons](https://fonts.google.com/icons).
     *
     * For example, to display a [checkbox
     * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
     * use
     * ```
     * "material_icon": {
     *   "name": "check_box"
     * }
     * ```
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.MaterialIcon,
            com.google.apps.card.v1.MaterialIcon.Builder,
            com.google.apps.card.v1.MaterialIconOrBuilder>
        getMaterialIconFieldBuilder() {
      if (materialIconBuilder_ == null) {
        if (!(iconsCase_ == 5)) {
          icons_ = com.google.apps.card.v1.MaterialIcon.getDefaultInstance();
        }
        materialIconBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.MaterialIcon,
                com.google.apps.card.v1.MaterialIcon.Builder,
                com.google.apps.card.v1.MaterialIconOrBuilder>(
                (com.google.apps.card.v1.MaterialIcon) icons_, getParentForChildren(), isClean());
        icons_ = null;
      }
      iconsCase_ = 5;
      onChanged();
      return materialIconBuilder_;
    }

    private java.lang.Object altText_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A description of the icon used for accessibility.
     * If unspecified, the default value `Button` is provided. As a best practice,
     * you should set a helpful description for what the icon displays, and if
     * applicable, what it does. For example, `A user's account portrait`, or
     * `Opens a new browser tab and navigates to the Google Chat developer
     * documentation at https://developers.google.com/workspace/chat`.
     *
     * If the icon is set in a [`Button`][google.apps.card.v1.Button], the
     * `altText` appears as helper text when the user hovers over the button.
     * However, if the button also sets `text`, the icon's `altText` is ignored.
     * </pre>
     *
     * <code>string alt_text = 3;</code>
     *
     * @return The altText.
     */
    public java.lang.String getAltText() {
      java.lang.Object ref = altText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        altText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of the icon used for accessibility.
     * If unspecified, the default value `Button` is provided. As a best practice,
     * you should set a helpful description for what the icon displays, and if
     * applicable, what it does. For example, `A user's account portrait`, or
     * `Opens a new browser tab and navigates to the Google Chat developer
     * documentation at https://developers.google.com/workspace/chat`.
     *
     * If the icon is set in a [`Button`][google.apps.card.v1.Button], the
     * `altText` appears as helper text when the user hovers over the button.
     * However, if the button also sets `text`, the icon's `altText` is ignored.
     * </pre>
     *
     * <code>string alt_text = 3;</code>
     *
     * @return The bytes for altText.
     */
    public com.google.protobuf.ByteString getAltTextBytes() {
      java.lang.Object ref = altText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        altText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of the icon used for accessibility.
     * If unspecified, the default value `Button` is provided. As a best practice,
     * you should set a helpful description for what the icon displays, and if
     * applicable, what it does. For example, `A user's account portrait`, or
     * `Opens a new browser tab and navigates to the Google Chat developer
     * documentation at https://developers.google.com/workspace/chat`.
     *
     * If the icon is set in a [`Button`][google.apps.card.v1.Button], the
     * `altText` appears as helper text when the user hovers over the button.
     * However, if the button also sets `text`, the icon's `altText` is ignored.
     * </pre>
     *
     * <code>string alt_text = 3;</code>
     *
     * @param value The altText to set.
     * @return This builder for chaining.
     */
    public Builder setAltText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      altText_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of the icon used for accessibility.
     * If unspecified, the default value `Button` is provided. As a best practice,
     * you should set a helpful description for what the icon displays, and if
     * applicable, what it does. For example, `A user's account portrait`, or
     * `Opens a new browser tab and navigates to the Google Chat developer
     * documentation at https://developers.google.com/workspace/chat`.
     *
     * If the icon is set in a [`Button`][google.apps.card.v1.Button], the
     * `altText` appears as helper text when the user hovers over the button.
     * However, if the button also sets `text`, the icon's `altText` is ignored.
     * </pre>
     *
     * <code>string alt_text = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAltText() {
      altText_ = getDefaultInstance().getAltText();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of the icon used for accessibility.
     * If unspecified, the default value `Button` is provided. As a best practice,
     * you should set a helpful description for what the icon displays, and if
     * applicable, what it does. For example, `A user's account portrait`, or
     * `Opens a new browser tab and navigates to the Google Chat developer
     * documentation at https://developers.google.com/workspace/chat`.
     *
     * If the icon is set in a [`Button`][google.apps.card.v1.Button], the
     * `altText` appears as helper text when the user hovers over the button.
     * However, if the button also sets `text`, the icon's `altText` is ignored.
     * </pre>
     *
     * <code>string alt_text = 3;</code>
     *
     * @param value The bytes for altText to set.
     * @return This builder for chaining.
     */
    public Builder setAltTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      altText_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int imageType_ = 0;
    /**
     *
     *
     * <pre>
     * The crop style applied to the image. In some cases, applying a
     * `CIRCLE` crop causes the image to be drawn larger than a built-in
     * icon.
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.ImageType image_type = 4;</code>
     *
     * @return The enum numeric value on the wire for imageType.
     */
    @java.lang.Override
    public int getImageTypeValue() {
      return imageType_;
    }
    /**
     *
     *
     * <pre>
     * The crop style applied to the image. In some cases, applying a
     * `CIRCLE` crop causes the image to be drawn larger than a built-in
     * icon.
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.ImageType image_type = 4;</code>
     *
     * @param value The enum numeric value on the wire for imageType to set.
     * @return This builder for chaining.
     */
    public Builder setImageTypeValue(int value) {
      imageType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The crop style applied to the image. In some cases, applying a
     * `CIRCLE` crop causes the image to be drawn larger than a built-in
     * icon.
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.ImageType image_type = 4;</code>
     *
     * @return The imageType.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Widget.ImageType getImageType() {
      com.google.apps.card.v1.Widget.ImageType result =
          com.google.apps.card.v1.Widget.ImageType.forNumber(imageType_);
      return result == null ? com.google.apps.card.v1.Widget.ImageType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The crop style applied to the image. In some cases, applying a
     * `CIRCLE` crop causes the image to be drawn larger than a built-in
     * icon.
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.ImageType image_type = 4;</code>
     *
     * @param value The imageType to set.
     * @return This builder for chaining.
     */
    public Builder setImageType(com.google.apps.card.v1.Widget.ImageType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      imageType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The crop style applied to the image. In some cases, applying a
     * `CIRCLE` crop causes the image to be drawn larger than a built-in
     * icon.
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.ImageType image_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      imageType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Icon)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.Icon)
  private static final com.google.apps.card.v1.Icon DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.Icon();
  }

  public static com.google.apps.card.v1.Icon getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Icon> PARSER =
      new com.google.protobuf.AbstractParser<Icon>() {
        @java.lang.Override
        public Icon parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Icon> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Icon> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.Icon getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
