/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.5
package com.google.apps.card.v1;

public interface IconOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.apps.card.v1.Icon)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Display one of the built-in icons provided by Google Workspace.
   *
   * For example, to display an airplane icon, specify `AIRPLANE`.
   * For a bus, specify `BUS`.
   *
   * For a full list of supported icons, see [built-in
   * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
   * </pre>
   *
   * <code>string known_icon = 1;</code>
   *
   * @return Whether the knownIcon field is set.
   */
  boolean hasKnownIcon();
  /**
   *
   *
   * <pre>
   * Display one of the built-in icons provided by Google Workspace.
   *
   * For example, to display an airplane icon, specify `AIRPLANE`.
   * For a bus, specify `BUS`.
   *
   * For a full list of supported icons, see [built-in
   * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
   * </pre>
   *
   * <code>string known_icon = 1;</code>
   *
   * @return The knownIcon.
   */
  java.lang.String getKnownIcon();
  /**
   *
   *
   * <pre>
   * Display one of the built-in icons provided by Google Workspace.
   *
   * For example, to display an airplane icon, specify `AIRPLANE`.
   * For a bus, specify `BUS`.
   *
   * For a full list of supported icons, see [built-in
   * icons](https://developers.google.com/workspace/chat/format-messages#builtinicons).
   * </pre>
   *
   * <code>string known_icon = 1;</code>
   *
   * @return The bytes for knownIcon.
   */
  com.google.protobuf.ByteString getKnownIconBytes();

  /**
   *
   *
   * <pre>
   * Display a custom icon hosted at an HTTPS URL.
   *
   * For example:
   *
   * ```
   * "iconUrl":
   * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
   * ```
   *
   * Supported file types include `.png` and `.jpg`.
   * </pre>
   *
   * <code>string icon_url = 2;</code>
   *
   * @return Whether the iconUrl field is set.
   */
  boolean hasIconUrl();
  /**
   *
   *
   * <pre>
   * Display a custom icon hosted at an HTTPS URL.
   *
   * For example:
   *
   * ```
   * "iconUrl":
   * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
   * ```
   *
   * Supported file types include `.png` and `.jpg`.
   * </pre>
   *
   * <code>string icon_url = 2;</code>
   *
   * @return The iconUrl.
   */
  java.lang.String getIconUrl();
  /**
   *
   *
   * <pre>
   * Display a custom icon hosted at an HTTPS URL.
   *
   * For example:
   *
   * ```
   * "iconUrl":
   * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png"
   * ```
   *
   * Supported file types include `.png` and `.jpg`.
   * </pre>
   *
   * <code>string icon_url = 2;</code>
   *
   * @return The bytes for iconUrl.
   */
  com.google.protobuf.ByteString getIconUrlBytes();

  /**
   *
   *
   * <pre>
   * Display one of the [Google Material
   * Icons](https://fonts.google.com/icons).
   *
   * For example, to display a [checkbox
   * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
   * use
   * ```
   * "material_icon": {
   *   "name": "check_box"
   * }
   * ```
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
   *
   * @return Whether the materialIcon field is set.
   */
  boolean hasMaterialIcon();
  /**
   *
   *
   * <pre>
   * Display one of the [Google Material
   * Icons](https://fonts.google.com/icons).
   *
   * For example, to display a [checkbox
   * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
   * use
   * ```
   * "material_icon": {
   *   "name": "check_box"
   * }
   * ```
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
   *
   * @return The materialIcon.
   */
  com.google.apps.card.v1.MaterialIcon getMaterialIcon();
  /**
   *
   *
   * <pre>
   * Display one of the [Google Material
   * Icons](https://fonts.google.com/icons).
   *
   * For example, to display a [checkbox
   * icon](https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck_box%3AFILL%400%3Bwght%40400%3BGRAD%400%3Bopsz%4048),
   * use
   * ```
   * "material_icon": {
   *   "name": "check_box"
   * }
   * ```
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>.google.apps.card.v1.MaterialIcon material_icon = 5;</code>
   */
  com.google.apps.card.v1.MaterialIconOrBuilder getMaterialIconOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. A description of the icon used for accessibility.
   * If unspecified, the default value `Button` is provided. As a best practice,
   * you should set a helpful description for what the icon displays, and if
   * applicable, what it does. For example, `A user's account portrait`, or
   * `Opens a new browser tab and navigates to the Google Chat developer
   * documentation at https://developers.google.com/workspace/chat`.
   *
   * If the icon is set in a [`Button`][google.apps.card.v1.Button], the
   * `altText` appears as helper text when the user hovers over the button.
   * However, if the button also sets `text`, the icon's `altText` is ignored.
   * </pre>
   *
   * <code>string alt_text = 3;</code>
   *
   * @return The altText.
   */
  java.lang.String getAltText();
  /**
   *
   *
   * <pre>
   * Optional. A description of the icon used for accessibility.
   * If unspecified, the default value `Button` is provided. As a best practice,
   * you should set a helpful description for what the icon displays, and if
   * applicable, what it does. For example, `A user's account portrait`, or
   * `Opens a new browser tab and navigates to the Google Chat developer
   * documentation at https://developers.google.com/workspace/chat`.
   *
   * If the icon is set in a [`Button`][google.apps.card.v1.Button], the
   * `altText` appears as helper text when the user hovers over the button.
   * However, if the button also sets `text`, the icon's `altText` is ignored.
   * </pre>
   *
   * <code>string alt_text = 3;</code>
   *
   * @return The bytes for altText.
   */
  com.google.protobuf.ByteString getAltTextBytes();

  /**
   *
   *
   * <pre>
   * The crop style applied to the image. In some cases, applying a
   * `CIRCLE` crop causes the image to be drawn larger than a built-in
   * icon.
   * </pre>
   *
   * <code>.google.apps.card.v1.Widget.ImageType image_type = 4;</code>
   *
   * @return The enum numeric value on the wire for imageType.
   */
  int getImageTypeValue();
  /**
   *
   *
   * <pre>
   * The crop style applied to the image. In some cases, applying a
   * `CIRCLE` crop causes the image to be drawn larger than a built-in
   * icon.
   * </pre>
   *
   * <code>.google.apps.card.v1.Widget.ImageType image_type = 4;</code>
   *
   * @return The imageType.
   */
  com.google.apps.card.v1.Widget.ImageType getImageType();

  com.google.apps.card.v1.Icon.IconsCase getIconsCase();
}
