/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/config_change.proto

package com.google.api;

/**
 *
 *
 * <pre>
 * Output generated from semantically comparing two versions of a service
 * configuration.
 * Includes detailed information about a field that have changed with
 * applicable advice about potential consequences for the change, such as
 * backwards-incompatibility.
 * </pre>
 *
 * Protobuf type {@code google.api.ConfigChange}
 */
public final class ConfigChange extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.ConfigChange)
    ConfigChangeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConfigChange.newBuilder() to construct.
  private ConfigChange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConfigChange() {
    element_ = "";
    oldValue_ = "";
    newValue_ = "";
    changeType_ = 0;
    advices_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConfigChange();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ConfigChange(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              element_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              oldValue_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              newValue_ = s;
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              changeType_ = rawValue;
              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                advices_ = new java.util.ArrayList<com.google.api.Advice>();
                mutable_bitField0_ |= 0x00000001;
              }
              advices_.add(input.readMessage(com.google.api.Advice.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        advices_ = java.util.Collections.unmodifiableList(advices_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.ConfigChangeProto.internal_static_google_api_ConfigChange_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.ConfigChangeProto
        .internal_static_google_api_ConfigChange_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.ConfigChange.class, com.google.api.ConfigChange.Builder.class);
  }

  public static final int ELEMENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object element_;
  /**
   *
   *
   * <pre>
   * Object hierarchy path to the change, with levels separated by a '.'
   * character. For repeated fields, an applicable unique identifier field is
   * used for the index (usually selector, name, or id). For maps, the term
   * 'key' is used. If the field has no unique identifier, the numeric index
   * is used.
   * Examples:
   * - visibility.rules[selector=="google.LibraryService.ListBooks"].restriction
   * - quota.metric_rules[selector=="google"].metric_costs[key=="reads"].value
   * - logging.producer_destinations[0]
   * </pre>
   *
   * <code>string element = 1;</code>
   *
   * @return The element.
   */
  @java.lang.Override
  public java.lang.String getElement() {
    java.lang.Object ref = element_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      element_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Object hierarchy path to the change, with levels separated by a '.'
   * character. For repeated fields, an applicable unique identifier field is
   * used for the index (usually selector, name, or id). For maps, the term
   * 'key' is used. If the field has no unique identifier, the numeric index
   * is used.
   * Examples:
   * - visibility.rules[selector=="google.LibraryService.ListBooks"].restriction
   * - quota.metric_rules[selector=="google"].metric_costs[key=="reads"].value
   * - logging.producer_destinations[0]
   * </pre>
   *
   * <code>string element = 1;</code>
   *
   * @return The bytes for element.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getElementBytes() {
    java.lang.Object ref = element_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      element_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OLD_VALUE_FIELD_NUMBER = 2;
  private volatile java.lang.Object oldValue_;
  /**
   *
   *
   * <pre>
   * Value of the changed object in the old Service configuration,
   * in JSON format. This field will not be populated if ChangeType == ADDED.
   * </pre>
   *
   * <code>string old_value = 2;</code>
   *
   * @return The oldValue.
   */
  @java.lang.Override
  public java.lang.String getOldValue() {
    java.lang.Object ref = oldValue_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      oldValue_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Value of the changed object in the old Service configuration,
   * in JSON format. This field will not be populated if ChangeType == ADDED.
   * </pre>
   *
   * <code>string old_value = 2;</code>
   *
   * @return The bytes for oldValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOldValueBytes() {
    java.lang.Object ref = oldValue_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      oldValue_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEW_VALUE_FIELD_NUMBER = 3;
  private volatile java.lang.Object newValue_;
  /**
   *
   *
   * <pre>
   * Value of the changed object in the new Service configuration,
   * in JSON format. This field will not be populated if ChangeType == REMOVED.
   * </pre>
   *
   * <code>string new_value = 3;</code>
   *
   * @return The newValue.
   */
  @java.lang.Override
  public java.lang.String getNewValue() {
    java.lang.Object ref = newValue_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      newValue_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Value of the changed object in the new Service configuration,
   * in JSON format. This field will not be populated if ChangeType == REMOVED.
   * </pre>
   *
   * <code>string new_value = 3;</code>
   *
   * @return The bytes for newValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNewValueBytes() {
    java.lang.Object ref = newValue_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      newValue_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHANGE_TYPE_FIELD_NUMBER = 4;
  private int changeType_;
  /**
   *
   *
   * <pre>
   * The type for this change, either ADDED, REMOVED, or MODIFIED.
   * </pre>
   *
   * <code>.google.api.ChangeType change_type = 4;</code>
   *
   * @return The enum numeric value on the wire for changeType.
   */
  @java.lang.Override
  public int getChangeTypeValue() {
    return changeType_;
  }
  /**
   *
   *
   * <pre>
   * The type for this change, either ADDED, REMOVED, or MODIFIED.
   * </pre>
   *
   * <code>.google.api.ChangeType change_type = 4;</code>
   *
   * @return The changeType.
   */
  @java.lang.Override
  public com.google.api.ChangeType getChangeType() {
    @SuppressWarnings("deprecation")
    com.google.api.ChangeType result = com.google.api.ChangeType.valueOf(changeType_);
    return result == null ? com.google.api.ChangeType.UNRECOGNIZED : result;
  }

  public static final int ADVICES_FIELD_NUMBER = 5;
  private java.util.List<com.google.api.Advice> advices_;
  /**
   *
   *
   * <pre>
   * Collection of advice provided for this change, useful for determining the
   * possible impact of this change.
   * </pre>
   *
   * <code>repeated .google.api.Advice advices = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.Advice> getAdvicesList() {
    return advices_;
  }
  /**
   *
   *
   * <pre>
   * Collection of advice provided for this change, useful for determining the
   * possible impact of this change.
   * </pre>
   *
   * <code>repeated .google.api.Advice advices = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.AdviceOrBuilder> getAdvicesOrBuilderList() {
    return advices_;
  }
  /**
   *
   *
   * <pre>
   * Collection of advice provided for this change, useful for determining the
   * possible impact of this change.
   * </pre>
   *
   * <code>repeated .google.api.Advice advices = 5;</code>
   */
  @java.lang.Override
  public int getAdvicesCount() {
    return advices_.size();
  }
  /**
   *
   *
   * <pre>
   * Collection of advice provided for this change, useful for determining the
   * possible impact of this change.
   * </pre>
   *
   * <code>repeated .google.api.Advice advices = 5;</code>
   */
  @java.lang.Override
  public com.google.api.Advice getAdvices(int index) {
    return advices_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Collection of advice provided for this change, useful for determining the
   * possible impact of this change.
   * </pre>
   *
   * <code>repeated .google.api.Advice advices = 5;</code>
   */
  @java.lang.Override
  public com.google.api.AdviceOrBuilder getAdvicesOrBuilder(int index) {
    return advices_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(element_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, element_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oldValue_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, oldValue_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newValue_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, newValue_);
    }
    if (changeType_ != com.google.api.ChangeType.CHANGE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, changeType_);
    }
    for (int i = 0; i < advices_.size(); i++) {
      output.writeMessage(5, advices_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(element_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, element_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oldValue_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, oldValue_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newValue_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, newValue_);
    }
    if (changeType_ != com.google.api.ChangeType.CHANGE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, changeType_);
    }
    for (int i = 0; i < advices_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, advices_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.ConfigChange)) {
      return super.equals(obj);
    }
    com.google.api.ConfigChange other = (com.google.api.ConfigChange) obj;

    if (!getElement().equals(other.getElement())) return false;
    if (!getOldValue().equals(other.getOldValue())) return false;
    if (!getNewValue().equals(other.getNewValue())) return false;
    if (changeType_ != other.changeType_) return false;
    if (!getAdvicesList().equals(other.getAdvicesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ELEMENT_FIELD_NUMBER;
    hash = (53 * hash) + getElement().hashCode();
    hash = (37 * hash) + OLD_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + getOldValue().hashCode();
    hash = (37 * hash) + NEW_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + getNewValue().hashCode();
    hash = (37 * hash) + CHANGE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + changeType_;
    if (getAdvicesCount() > 0) {
      hash = (37 * hash) + ADVICES_FIELD_NUMBER;
      hash = (53 * hash) + getAdvicesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.ConfigChange parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.ConfigChange parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.ConfigChange parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.ConfigChange parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.ConfigChange parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.ConfigChange parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.ConfigChange parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.ConfigChange parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.ConfigChange parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.ConfigChange parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.ConfigChange parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.ConfigChange parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.ConfigChange prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Output generated from semantically comparing two versions of a service
   * configuration.
   * Includes detailed information about a field that have changed with
   * applicable advice about potential consequences for the change, such as
   * backwards-incompatibility.
   * </pre>
   *
   * Protobuf type {@code google.api.ConfigChange}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.ConfigChange)
      com.google.api.ConfigChangeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.ConfigChangeProto.internal_static_google_api_ConfigChange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.ConfigChangeProto
          .internal_static_google_api_ConfigChange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.ConfigChange.class, com.google.api.ConfigChange.Builder.class);
    }

    // Construct using com.google.api.ConfigChange.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAdvicesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      element_ = "";

      oldValue_ = "";

      newValue_ = "";

      changeType_ = 0;

      if (advicesBuilder_ == null) {
        advices_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        advicesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.ConfigChangeProto.internal_static_google_api_ConfigChange_descriptor;
    }

    @java.lang.Override
    public com.google.api.ConfigChange getDefaultInstanceForType() {
      return com.google.api.ConfigChange.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.ConfigChange build() {
      com.google.api.ConfigChange result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.ConfigChange buildPartial() {
      com.google.api.ConfigChange result = new com.google.api.ConfigChange(this);
      int from_bitField0_ = bitField0_;
      result.element_ = element_;
      result.oldValue_ = oldValue_;
      result.newValue_ = newValue_;
      result.changeType_ = changeType_;
      if (advicesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          advices_ = java.util.Collections.unmodifiableList(advices_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.advices_ = advices_;
      } else {
        result.advices_ = advicesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.ConfigChange) {
        return mergeFrom((com.google.api.ConfigChange) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.ConfigChange other) {
      if (other == com.google.api.ConfigChange.getDefaultInstance()) return this;
      if (!other.getElement().isEmpty()) {
        element_ = other.element_;
        onChanged();
      }
      if (!other.getOldValue().isEmpty()) {
        oldValue_ = other.oldValue_;
        onChanged();
      }
      if (!other.getNewValue().isEmpty()) {
        newValue_ = other.newValue_;
        onChanged();
      }
      if (other.changeType_ != 0) {
        setChangeTypeValue(other.getChangeTypeValue());
      }
      if (advicesBuilder_ == null) {
        if (!other.advices_.isEmpty()) {
          if (advices_.isEmpty()) {
            advices_ = other.advices_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAdvicesIsMutable();
            advices_.addAll(other.advices_);
          }
          onChanged();
        }
      } else {
        if (!other.advices_.isEmpty()) {
          if (advicesBuilder_.isEmpty()) {
            advicesBuilder_.dispose();
            advicesBuilder_ = null;
            advices_ = other.advices_;
            bitField0_ = (bitField0_ & ~0x00000001);
            advicesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAdvicesFieldBuilder()
                    : null;
          } else {
            advicesBuilder_.addAllMessages(other.advices_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.api.ConfigChange parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.api.ConfigChange) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object element_ = "";
    /**
     *
     *
     * <pre>
     * Object hierarchy path to the change, with levels separated by a '.'
     * character. For repeated fields, an applicable unique identifier field is
     * used for the index (usually selector, name, or id). For maps, the term
     * 'key' is used. If the field has no unique identifier, the numeric index
     * is used.
     * Examples:
     * - visibility.rules[selector=="google.LibraryService.ListBooks"].restriction
     * - quota.metric_rules[selector=="google"].metric_costs[key=="reads"].value
     * - logging.producer_destinations[0]
     * </pre>
     *
     * <code>string element = 1;</code>
     *
     * @return The element.
     */
    public java.lang.String getElement() {
      java.lang.Object ref = element_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        element_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Object hierarchy path to the change, with levels separated by a '.'
     * character. For repeated fields, an applicable unique identifier field is
     * used for the index (usually selector, name, or id). For maps, the term
     * 'key' is used. If the field has no unique identifier, the numeric index
     * is used.
     * Examples:
     * - visibility.rules[selector=="google.LibraryService.ListBooks"].restriction
     * - quota.metric_rules[selector=="google"].metric_costs[key=="reads"].value
     * - logging.producer_destinations[0]
     * </pre>
     *
     * <code>string element = 1;</code>
     *
     * @return The bytes for element.
     */
    public com.google.protobuf.ByteString getElementBytes() {
      java.lang.Object ref = element_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        element_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Object hierarchy path to the change, with levels separated by a '.'
     * character. For repeated fields, an applicable unique identifier field is
     * used for the index (usually selector, name, or id). For maps, the term
     * 'key' is used. If the field has no unique identifier, the numeric index
     * is used.
     * Examples:
     * - visibility.rules[selector=="google.LibraryService.ListBooks"].restriction
     * - quota.metric_rules[selector=="google"].metric_costs[key=="reads"].value
     * - logging.producer_destinations[0]
     * </pre>
     *
     * <code>string element = 1;</code>
     *
     * @param value The element to set.
     * @return This builder for chaining.
     */
    public Builder setElement(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      element_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Object hierarchy path to the change, with levels separated by a '.'
     * character. For repeated fields, an applicable unique identifier field is
     * used for the index (usually selector, name, or id). For maps, the term
     * 'key' is used. If the field has no unique identifier, the numeric index
     * is used.
     * Examples:
     * - visibility.rules[selector=="google.LibraryService.ListBooks"].restriction
     * - quota.metric_rules[selector=="google"].metric_costs[key=="reads"].value
     * - logging.producer_destinations[0]
     * </pre>
     *
     * <code>string element = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearElement() {

      element_ = getDefaultInstance().getElement();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Object hierarchy path to the change, with levels separated by a '.'
     * character. For repeated fields, an applicable unique identifier field is
     * used for the index (usually selector, name, or id). For maps, the term
     * 'key' is used. If the field has no unique identifier, the numeric index
     * is used.
     * Examples:
     * - visibility.rules[selector=="google.LibraryService.ListBooks"].restriction
     * - quota.metric_rules[selector=="google"].metric_costs[key=="reads"].value
     * - logging.producer_destinations[0]
     * </pre>
     *
     * <code>string element = 1;</code>
     *
     * @param value The bytes for element to set.
     * @return This builder for chaining.
     */
    public Builder setElementBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      element_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object oldValue_ = "";
    /**
     *
     *
     * <pre>
     * Value of the changed object in the old Service configuration,
     * in JSON format. This field will not be populated if ChangeType == ADDED.
     * </pre>
     *
     * <code>string old_value = 2;</code>
     *
     * @return The oldValue.
     */
    public java.lang.String getOldValue() {
      java.lang.Object ref = oldValue_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        oldValue_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value of the changed object in the old Service configuration,
     * in JSON format. This field will not be populated if ChangeType == ADDED.
     * </pre>
     *
     * <code>string old_value = 2;</code>
     *
     * @return The bytes for oldValue.
     */
    public com.google.protobuf.ByteString getOldValueBytes() {
      java.lang.Object ref = oldValue_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        oldValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value of the changed object in the old Service configuration,
     * in JSON format. This field will not be populated if ChangeType == ADDED.
     * </pre>
     *
     * <code>string old_value = 2;</code>
     *
     * @param value The oldValue to set.
     * @return This builder for chaining.
     */
    public Builder setOldValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      oldValue_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value of the changed object in the old Service configuration,
     * in JSON format. This field will not be populated if ChangeType == ADDED.
     * </pre>
     *
     * <code>string old_value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOldValue() {

      oldValue_ = getDefaultInstance().getOldValue();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value of the changed object in the old Service configuration,
     * in JSON format. This field will not be populated if ChangeType == ADDED.
     * </pre>
     *
     * <code>string old_value = 2;</code>
     *
     * @param value The bytes for oldValue to set.
     * @return This builder for chaining.
     */
    public Builder setOldValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      oldValue_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object newValue_ = "";
    /**
     *
     *
     * <pre>
     * Value of the changed object in the new Service configuration,
     * in JSON format. This field will not be populated if ChangeType == REMOVED.
     * </pre>
     *
     * <code>string new_value = 3;</code>
     *
     * @return The newValue.
     */
    public java.lang.String getNewValue() {
      java.lang.Object ref = newValue_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        newValue_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value of the changed object in the new Service configuration,
     * in JSON format. This field will not be populated if ChangeType == REMOVED.
     * </pre>
     *
     * <code>string new_value = 3;</code>
     *
     * @return The bytes for newValue.
     */
    public com.google.protobuf.ByteString getNewValueBytes() {
      java.lang.Object ref = newValue_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        newValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value of the changed object in the new Service configuration,
     * in JSON format. This field will not be populated if ChangeType == REMOVED.
     * </pre>
     *
     * <code>string new_value = 3;</code>
     *
     * @param value The newValue to set.
     * @return This builder for chaining.
     */
    public Builder setNewValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      newValue_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value of the changed object in the new Service configuration,
     * in JSON format. This field will not be populated if ChangeType == REMOVED.
     * </pre>
     *
     * <code>string new_value = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewValue() {

      newValue_ = getDefaultInstance().getNewValue();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value of the changed object in the new Service configuration,
     * in JSON format. This field will not be populated if ChangeType == REMOVED.
     * </pre>
     *
     * <code>string new_value = 3;</code>
     *
     * @param value The bytes for newValue to set.
     * @return This builder for chaining.
     */
    public Builder setNewValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      newValue_ = value;
      onChanged();
      return this;
    }

    private int changeType_ = 0;
    /**
     *
     *
     * <pre>
     * The type for this change, either ADDED, REMOVED, or MODIFIED.
     * </pre>
     *
     * <code>.google.api.ChangeType change_type = 4;</code>
     *
     * @return The enum numeric value on the wire for changeType.
     */
    @java.lang.Override
    public int getChangeTypeValue() {
      return changeType_;
    }
    /**
     *
     *
     * <pre>
     * The type for this change, either ADDED, REMOVED, or MODIFIED.
     * </pre>
     *
     * <code>.google.api.ChangeType change_type = 4;</code>
     *
     * @param value The enum numeric value on the wire for changeType to set.
     * @return This builder for chaining.
     */
    public Builder setChangeTypeValue(int value) {

      changeType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type for this change, either ADDED, REMOVED, or MODIFIED.
     * </pre>
     *
     * <code>.google.api.ChangeType change_type = 4;</code>
     *
     * @return The changeType.
     */
    @java.lang.Override
    public com.google.api.ChangeType getChangeType() {
      @SuppressWarnings("deprecation")
      com.google.api.ChangeType result = com.google.api.ChangeType.valueOf(changeType_);
      return result == null ? com.google.api.ChangeType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The type for this change, either ADDED, REMOVED, or MODIFIED.
     * </pre>
     *
     * <code>.google.api.ChangeType change_type = 4;</code>
     *
     * @param value The changeType to set.
     * @return This builder for chaining.
     */
    public Builder setChangeType(com.google.api.ChangeType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      changeType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type for this change, either ADDED, REMOVED, or MODIFIED.
     * </pre>
     *
     * <code>.google.api.ChangeType change_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChangeType() {

      changeType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.api.Advice> advices_ = java.util.Collections.emptyList();

    private void ensureAdvicesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        advices_ = new java.util.ArrayList<com.google.api.Advice>(advices_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Advice, com.google.api.Advice.Builder, com.google.api.AdviceOrBuilder>
        advicesBuilder_;

    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public java.util.List<com.google.api.Advice> getAdvicesList() {
      if (advicesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(advices_);
      } else {
        return advicesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public int getAdvicesCount() {
      if (advicesBuilder_ == null) {
        return advices_.size();
      } else {
        return advicesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public com.google.api.Advice getAdvices(int index) {
      if (advicesBuilder_ == null) {
        return advices_.get(index);
      } else {
        return advicesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public Builder setAdvices(int index, com.google.api.Advice value) {
      if (advicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvicesIsMutable();
        advices_.set(index, value);
        onChanged();
      } else {
        advicesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public Builder setAdvices(int index, com.google.api.Advice.Builder builderForValue) {
      if (advicesBuilder_ == null) {
        ensureAdvicesIsMutable();
        advices_.set(index, builderForValue.build());
        onChanged();
      } else {
        advicesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public Builder addAdvices(com.google.api.Advice value) {
      if (advicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvicesIsMutable();
        advices_.add(value);
        onChanged();
      } else {
        advicesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public Builder addAdvices(int index, com.google.api.Advice value) {
      if (advicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvicesIsMutable();
        advices_.add(index, value);
        onChanged();
      } else {
        advicesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public Builder addAdvices(com.google.api.Advice.Builder builderForValue) {
      if (advicesBuilder_ == null) {
        ensureAdvicesIsMutable();
        advices_.add(builderForValue.build());
        onChanged();
      } else {
        advicesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public Builder addAdvices(int index, com.google.api.Advice.Builder builderForValue) {
      if (advicesBuilder_ == null) {
        ensureAdvicesIsMutable();
        advices_.add(index, builderForValue.build());
        onChanged();
      } else {
        advicesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public Builder addAllAdvices(java.lang.Iterable<? extends com.google.api.Advice> values) {
      if (advicesBuilder_ == null) {
        ensureAdvicesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, advices_);
        onChanged();
      } else {
        advicesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public Builder clearAdvices() {
      if (advicesBuilder_ == null) {
        advices_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        advicesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public Builder removeAdvices(int index) {
      if (advicesBuilder_ == null) {
        ensureAdvicesIsMutable();
        advices_.remove(index);
        onChanged();
      } else {
        advicesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public com.google.api.Advice.Builder getAdvicesBuilder(int index) {
      return getAdvicesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public com.google.api.AdviceOrBuilder getAdvicesOrBuilder(int index) {
      if (advicesBuilder_ == null) {
        return advices_.get(index);
      } else {
        return advicesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public java.util.List<? extends com.google.api.AdviceOrBuilder> getAdvicesOrBuilderList() {
      if (advicesBuilder_ != null) {
        return advicesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(advices_);
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public com.google.api.Advice.Builder addAdvicesBuilder() {
      return getAdvicesFieldBuilder().addBuilder(com.google.api.Advice.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public com.google.api.Advice.Builder addAdvicesBuilder(int index) {
      return getAdvicesFieldBuilder().addBuilder(index, com.google.api.Advice.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Collection of advice provided for this change, useful for determining the
     * possible impact of this change.
     * </pre>
     *
     * <code>repeated .google.api.Advice advices = 5;</code>
     */
    public java.util.List<com.google.api.Advice.Builder> getAdvicesBuilderList() {
      return getAdvicesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Advice, com.google.api.Advice.Builder, com.google.api.AdviceOrBuilder>
        getAdvicesFieldBuilder() {
      if (advicesBuilder_ == null) {
        advicesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.Advice,
                com.google.api.Advice.Builder,
                com.google.api.AdviceOrBuilder>(
                advices_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        advices_ = null;
      }
      return advicesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.ConfigChange)
  }

  // @@protoc_insertion_point(class_scope:google.api.ConfigChange)
  private static final com.google.api.ConfigChange DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.ConfigChange();
  }

  public static com.google.api.ConfigChange getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConfigChange> PARSER =
      new com.google.protobuf.AbstractParser<ConfigChange>() {
        @java.lang.Override
        public ConfigChange parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ConfigChange(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ConfigChange> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConfigChange> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.ConfigChange getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
