/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This file was generated.
 *  with google-apis-code-generator 1.1.1 (build: 2012-06-25 20:14:04 UTC)
 *  on 2012-06-28 at 15:01:48 UTC 
 */

package com.google.api.services.drive;


import com.google.api.client.googleapis.services.GoogleClient;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonString;
import com.google.common.base.Preconditions;

import java.io.IOException;
import java.math.BigInteger;


/**
 * Service definition for Drive (v2).
 *
 * <p>
 * The API to interact with Drive.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/drive/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link JsonHttpRequestInitializer} to initialize global parameters via its
 * {@link Builder}. Sample usage:
 * </p>
 *
 * <pre>
  public class DriveRequestInitializer implements JsonHttpRequestInitializer {
      public void initialize(JsonHttpRequest request) {
        DriveRequest driveRequest = (DriveRequest)request;
        driveRequest.setPrettyPrint(true);
        driveRequest.setKey(ClientCredentials.KEY);
    }
  }
 * </pre>
 *
 * @since 1.3.0
 * @author Google, Inc.
 */
public class Drive extends GoogleClient {

  /**
   * The default encoded base path of the service. This is determined when the library is generated
   * and normally should not be changed.
   * @deprecated (scheduled to be removed in 1.8) Use "/" + {@link #DEFAULT_SERVICE_PATH}.
   */
  @Deprecated
  public static final String DEFAULT_BASE_PATH = "/drive/v2/";

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "drive/v2/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Construct a Drive instance to connect to the Drive service.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport The transport to use for requests
   * @param jsonFactory A factory for creating JSON parsers and serializers
   * @deprecated (scheduled to be removed in 1.8) Use
   *             {@link #Drive(HttpTransport, JsonFactory, HttpRequestInitializer)}.
   */
  @Deprecated
  public Drive(HttpTransport transport, JsonFactory jsonFactory) {
    super(transport, jsonFactory, DEFAULT_BASE_URL);
  }

  /**
   * Construct a Drive instance to connect to the Drive service.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport The transport to use for requests
   * @param jsonFactory A factory for creating JSON parsers and serializers
   * @param httpRequestInitializer The HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Drive(HttpTransport transport, JsonFactory jsonFactory,
      HttpRequestInitializer httpRequestInitializer) {
    super(transport, jsonFactory, DEFAULT_ROOT_URL, DEFAULT_SERVICE_PATH, httpRequestInitializer);
  }

  /**
   * Construct a Drive instance to connect to the Drive service.
   *
   * @param transport The transport to use for requests
   * @param jsonHttpRequestInitializer The initializer to use when creating an JSON HTTP request
   * @param httpRequestInitializer The initializer to use when creating an {@link HttpRequest}
   * @param jsonFactory A factory for creating JSON parsers and serializers
   * @param jsonObjectParser JSON parser to use or {@code null} if unused
   * @param baseUrl The base URL of the service on the server
   * @param applicationName The application name to be sent in the User-Agent header of requests
   */
  @Deprecated
  Drive(
      HttpTransport transport,
      JsonHttpRequestInitializer jsonHttpRequestInitializer,
      HttpRequestInitializer httpRequestInitializer,
      JsonFactory jsonFactory,
      JsonObjectParser jsonObjectParser,
      String baseUrl,
      String applicationName) {
      super(transport,
          jsonHttpRequestInitializer,
          httpRequestInitializer,
          jsonFactory,
          jsonObjectParser,
          baseUrl,
          applicationName);
  }

  /**
   * Construct a Drive instance to connect to the Drive service.
   *
   * @param transport The transport to use for requests
   * @param jsonHttpRequestInitializer The initializer to use when creating an JSON HTTP request
   * @param httpRequestInitializer The initializer to use when creating an {@link HttpRequest}
   * @param jsonFactory A factory for creating JSON parsers and serializers
   * @param jsonObjectParser JSON parser to use or {@code null} if unused
   * @param rootUrl The root URL of the service on the server
   * @param servicePath The service path of the service on the server
   * @param applicationName The application name to be sent in the User-Agent header of requests
   */
  Drive(
      HttpTransport transport,
      JsonHttpRequestInitializer jsonHttpRequestInitializer,
      HttpRequestInitializer httpRequestInitializer,
      JsonFactory jsonFactory,
      JsonObjectParser jsonObjectParser,
      String rootUrl,
      String servicePath,
      String applicationName) {
      super(transport,
          jsonHttpRequestInitializer,
          httpRequestInitializer,
          jsonFactory,
          jsonObjectParser,
          rootUrl,
          servicePath,
          applicationName);
  }

  @Override
  protected void initialize(JsonHttpRequest jsonHttpRequest) throws IOException {
    super.initialize(jsonHttpRequest);
  }


  /**
   * Returns an instance of a new builder.
   *
   * @param transport The transport to use for requests
   * @param jsonFactory A factory for creating JSON parsers and serializers
   * @deprecated (scheduled to removed in 1.8) Use
   *             {@link Builder#Builder(HttpTransport, JsonFactory, HttpRequestInitializer)}.
   */
   @Deprecated
   public static Builder builder(HttpTransport transport, JsonFactory jsonFactory) {
     return new Builder(transport, jsonFactory, new GenericUrl(DEFAULT_BASE_URL));
   }

  /**
   * An accessor for creating requests from the Files collection.
   *
   * The typical use is:<pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Files.List request = drive.files().list(parameters ...)}</pre>
   *
   * @return the resource collection
   */
  public Files files() {
    return new Files();
  }

  /**
   * The "files" collection of methods.
   */
  public class Files {

    /**
     * Insert a new file.
     *
     * Create a request for the method "files.insert".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Insert insert(com.google.api.services.drive.model.File content) throws IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    /**
     * Insert a new file.
     *
     * Create a request for the method "files.insert".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     *
     * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Insert insert(com.google.api.services.drive.model.File content,
        com.google.api.client.http.AbstractInputStreamContent mediaContent) throws IOException {
      Insert result = new Insert(content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends DriveRequest {

      private static final String REST_PATH = "files";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Insert(com.google.api.services.drive.model.File content) {
        super(Drive.this, HttpMethod.POST, REST_PATH, content);
        Preconditions.checkNotNull(content);
      }

      /**
       * Internal constructor for media upload.  Use the convenience method instead.
       */
      Insert(com.google.api.services.drive.model.File content,
          com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Drive.this, HttpMethod.POST,
            "/upload" + new GenericUrl(getBaseUrl()).getRawPath() + REST_PATH, content);
        this.uploader =
          new com.google.api.client.googleapis.media.MediaHttpUploader(mediaContent,
            getRequestFactory().getTransport(), getRequestFactory().getInitializer());
        this.uploader.setInitiationMethod(HttpMethod.POST);
        if (content != null) {
          this.uploader.setMetadata(Drive.this.createSerializer(content));
        }
      }
      @Override
      public HttpResponse executeUnparsed() throws IOException {
        if (this.uploader == null) {
          return super.executeUnparsed();
        }
        HttpResponse response = uploader.upload(buildHttpRequestUrl());
        if (!response.isSuccessStatusCode()) {
          throw com.google.api.client.googleapis.json.GoogleJsonResponseException.from(
              getJsonFactory(), response);
        }
        return response;
      }

      @Override
      public HttpRequest buildHttpRequest() throws IOException {
        if (this.uploader == null) {
          return super.buildHttpRequest();
        }
        throw new UnsupportedOperationException();
      }
      /**
       * Sends the "insert" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.File} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.File execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.File result = Drive.this.getJsonHttpParser().parse(response,
            com.google.api.services.drive.model.File.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "insert" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;File&gt;() {

           public void onSuccess(File content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.File> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.File.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Insert setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      @com.google.api.client.util.Key
      private Boolean convert;

      /** Whether to convert this file to the corresponding Google Docs format. [default: false]
       */
      public Boolean getConvert() {
        return convert;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      public Insert setConvert(Boolean convert) {
        this.convert = convert;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to convert this file to the corresponding Google Docs format.
       * </p>
       */
      public boolean isConvert() {
        if (convert == null || convert == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return convert;
      }

      /**
     * Target language to translate the file to. If no sourceLanguage is provided, the API will
     * attempt to detect the language.
     */
      @com.google.api.client.util.Key
      private String targetLanguage;

      /** Target language to translate the file to. If no sourceLanguage is provided, the API will attempt to
     detect the language.
       */
      public String getTargetLanguage() {
        return targetLanguage;
      }

      /**
     * Target language to translate the file to. If no sourceLanguage is provided, the API will
     * attempt to detect the language.
     */
      public Insert setTargetLanguage(String targetLanguage) {
        this.targetLanguage = targetLanguage;
        return this;
      }

      /** The language of the original file to be translated. */
      @com.google.api.client.util.Key
      private String sourceLanguage;

      /** The language of the original file to be translated.
       */
      public String getSourceLanguage() {
        return sourceLanguage;
      }

      /** The language of the original file to be translated. */
      public Insert setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
      }

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes. */
      @com.google.api.client.util.Key
      private String ocrLanguage;

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes.
       */
      public String getOcrLanguage() {
        return ocrLanguage;
      }

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes. */
      public Insert setOcrLanguage(String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** Whether to pin the head revision of the uploaded file. */
      @com.google.api.client.util.Key
      private Boolean pinned;

      /** Whether to pin the head revision of the uploaded file. [default: false]
       */
      public Boolean getPinned() {
        return pinned;
      }

      /** Whether to pin the head revision of the uploaded file. */
      public Insert setPinned(Boolean pinned) {
        this.pinned = pinned;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to pin the head revision of the uploaded file.
       * </p>
       */
      public boolean isPinned() {
        if (pinned == null || pinned == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return pinned;
      }

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. */
      @com.google.api.client.util.Key
      private Boolean ocr;

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. [default: false]
       */
      public Boolean getOcr() {
        return ocr;
      }

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. */
      public Insert setOcr(Boolean ocr) {
        this.ocr = ocr;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to attempt OCR on .jpg, .png, or .gif uploads.
       * </p>
       */
      public boolean isOcr() {
        if (ocr == null || ocr == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ocr;
      }

      /** The timed text track name. */
      @com.google.api.client.util.Key
      private String timedTextTrackName;

      /** The timed text track name.
       */
      public String getTimedTextTrackName() {
        return timedTextTrackName;
      }

      /** The timed text track name. */
      public Insert setTimedTextTrackName(String timedTextTrackName) {
        this.timedTextTrackName = timedTextTrackName;
        return this;
      }

      /** The language of the timed text. */
      @com.google.api.client.util.Key
      private String timedTextLanguage;

      /** The language of the timed text.
       */
      public String getTimedTextLanguage() {
        return timedTextLanguage;
      }

      /** The language of the timed text. */
      public Insert setTimedTextLanguage(String timedTextLanguage) {
        this.timedTextLanguage = timedTextLanguage;
        return this;
      }


      /**
       * Media HTTP uploader or {@code null} if there is no media HTTP content provided to be uploaded.
       */
      private com.google.api.client.googleapis.media.MediaHttpUploader uploader;

      /**
       * Returns the Media HTTP Uploader or {@code null} if there is no media HTTP content provided to
       * be uploaded.
       */
      public com.google.api.client.googleapis.media.MediaHttpUploader getMediaHttpUploader() {
        return uploader;
      }


    }
    /**
     * Restores a file from the trash.
     *
     * Create a request for the method "files.untrash".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Untrash#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to untrash.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Untrash untrash(String fileId) throws IOException {
      Untrash result = new Untrash(fileId);
      initialize(result);
      return result;
    }


    public class Untrash extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/untrash";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Untrash(String fileId) {
        super(Drive.this, HttpMethod.POST, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }



      /**
       * Sends the "untrash" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.File} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.File execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.File result = response.parseAs(
            com.google.api.services.drive.model.File.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "untrash" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;File&gt;() {

           public void onSuccess(File content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.File> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.File.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Untrash setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file to untrash. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file to untrash.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file to untrash. */
      public Untrash setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }



    }
    /**
     * Moves a file to the trash.
     *
     * Create a request for the method "files.trash".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Trash#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to trash.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Trash trash(String fileId) throws IOException {
      Trash result = new Trash(fileId);
      initialize(result);
      return result;
    }


    public class Trash extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/trash";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Trash(String fileId) {
        super(Drive.this, HttpMethod.POST, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }



      /**
       * Sends the "trash" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.File} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.File execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.File result = response.parseAs(
            com.google.api.services.drive.model.File.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "trash" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;File&gt;() {

           public void onSuccess(File content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.File> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.File.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Trash setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file to trash. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file to trash.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file to trash. */
      public Trash setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }



    }
    /**
     * Gets a file's metadata by ID.
     *
     * Create a request for the method "files.get".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file in question.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Get get(String fileId) throws IOException {
      Get result = new Get(fileId);
      initialize(result);
      return result;
    }


    public class Get extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Get(String fileId) {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      this.downloader =
          new com.google.api.client.googleapis.media.MediaHttpDownloader(
              getRequestFactory().getTransport(), getRequestFactory().getInitializer());
      }



      /**
       * Sends the "get" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.File} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.File execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.File result = response.parseAs(
            com.google.api.services.drive.model.File.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Sends the "get" request to the Drive server and returns the input stream of the downloaded
       * media content.
       *
       * <p>
       * Callers are responsible for closing the input stream.
       * </p>
       *
       * @return the input stream of the downloaded media content
       * @throws IOException if the request fails
       * @deprecated (scheduled to be removed in 1.7) Use {@link #download} to write to an output
       *             stream. If the downloaded stream needs to be parsed
       *             {@code request.setAlt("media").executeAsInputStream()} can be used instead.
       */
      @Deprecated
      public java.io.InputStream executeAsMedia() throws IOException {
        setAlt("media");
        HttpResponse response = executeUnparsed();
        return response.getContent();
      }

      /**
       * @since 1.6
       */
      @Override
      public void download(java.io.OutputStream outputStream) throws IOException {
        downloader.download(buildHttpRequestUrl(), outputStream);
      }

      /**
       * Queues the "get" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;File&gt;() {

           public void onSuccess(File content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.File> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.File.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Get setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID for the file in question. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID for the file in question.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID for the file in question. */
      public Get setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Whether to update the view date after successfully retrieving the file. */
      @com.google.api.client.util.Key
      private Boolean updateViewedDate;

      /** Whether to update the view date after successfully retrieving the file. [default: false]
       */
      public Boolean getUpdateViewedDate() {
        return updateViewedDate;
      }

      /** Whether to update the view date after successfully retrieving the file. */
      public Get setUpdateViewedDate(Boolean updateViewedDate) {
        this.updateViewedDate = updateViewedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to update the view date after successfully retrieving the file.
       * </p>
       */
      public boolean isUpdateViewedDate() {
        if (updateViewedDate == null || updateViewedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return updateViewedDate;
      }

      /** Restrict information returned for simplicity and optimization. */
      @com.google.api.client.util.Key
      private String projection;

      /** Restrict information returned for simplicity and optimization.
       */
      public String getProjection() {
        return projection;
      }

      /** Restrict information returned for simplicity and optimization. */
      public Get setProjection(String projection) {
        this.projection = projection;
        return this;
      }



      /**
       * Media HTTP downloader.
       */
      private com.google.api.client.googleapis.media.MediaHttpDownloader downloader;

      /**
       * Returns the Media HTTP downloader.
       *
       * @since 1.6
       */
      public com.google.api.client.googleapis.media.MediaHttpDownloader getMediaHttpDownloader() {
        return downloader;
      }

    }
    /**
     * Lists the user's files.
     *
     * Create a request for the method "files.list".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public List list() throws IOException {
      List result = new List();
      initialize(result);
      return result;
    }


    public class List extends DriveRequest {

      private static final String REST_PATH = "files";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      List() {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
      }



      /**
       * Sends the "list" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.FileList} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.FileList execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.FileList result = response.parseAs(
            com.google.api.services.drive.model.FileList.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "list" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;FileList&gt;() {

           public void onSuccess(FileList content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.FileList> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.FileList.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public List setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** Query string for searching files. */
      @com.google.api.client.util.Key
      private String q;

      /** Query string for searching files.
       */
      public String getQ() {
        return q;
      }

      /** Query string for searching files. */
      public List setQ(String q) {
        this.q = q;
        return this;
      }

      /** Page token for files. */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Page token for files.
       */
      public String getPageToken() {
        return pageToken;
      }

      /** Page token for files. */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Restrict information returned for simplicity and optimization. */
      @com.google.api.client.util.Key
      private String projection;

      /** Restrict information returned for simplicity and optimization.
       */
      public String getProjection() {
        return projection;
      }

      /** Restrict information returned for simplicity and optimization. */
      public List setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /** Maximum number of files to return. */
      @com.google.api.client.util.Key
      private Integer maxResults;

      /** Maximum number of files to return. [default: 100] [minimum: 0]
       */
      public Integer getMaxResults() {
        return maxResults;
      }

      /** Maximum number of files to return. */
      public List setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }



    }
    /**
     * Updates file metadata and/or content
     *
     * Create a request for the method "files.update".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to update.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Update update(String fileId, com.google.api.services.drive.model.File content) throws IOException {
      Update result = new Update(fileId, content);
      initialize(result);
      return result;
    }

    /**
     * Updates file metadata and/or content
     *
     * Create a request for the method "files.update".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param fileId The ID of the file to update.
     * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Update update(String fileId, com.google.api.services.drive.model.File content,
        com.google.api.client.http.AbstractInputStreamContent mediaContent) throws IOException {
      Update result = new Update(fileId, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Update(String fileId, com.google.api.services.drive.model.File content) {
        super(Drive.this, HttpMethod.PUT, REST_PATH, content);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        Preconditions.checkNotNull(content);
      }

      /**
       * Internal constructor for media upload.  Use the convenience method instead.
       */
      Update(String fileId, com.google.api.services.drive.model.File content,
          com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Drive.this, HttpMethod.PUT,
            "/upload" + new GenericUrl(getBaseUrl()).getRawPath() + REST_PATH, content);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.uploader =
          new com.google.api.client.googleapis.media.MediaHttpUploader(mediaContent,
            getRequestFactory().getTransport(), getRequestFactory().getInitializer());
        this.uploader.setInitiationMethod(HttpMethod.PUT);
        if (content != null) {
          this.uploader.setMetadata(Drive.this.createSerializer(content));
        }
      }
      @Override
      public HttpResponse executeUnparsed() throws IOException {
        if (this.uploader == null) {
          return super.executeUnparsed();
        }
        HttpResponse response = uploader.upload(buildHttpRequestUrl());
        if (!response.isSuccessStatusCode()) {
          throw com.google.api.client.googleapis.json.GoogleJsonResponseException.from(
              getJsonFactory(), response);
        }
        return response;
      }

      @Override
      public HttpRequest buildHttpRequest() throws IOException {
        if (this.uploader == null) {
          return super.buildHttpRequest();
        }
        throw new UnsupportedOperationException();
      }
      /**
       * Sends the "update" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.File} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.File execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.File result = Drive.this.getJsonHttpParser().parse(response,
            com.google.api.services.drive.model.File.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "update" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;File&gt;() {

           public void onSuccess(File content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.File> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.File.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Update setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file to update. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file to update.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file to update. */
      public Update setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      @com.google.api.client.util.Key
      private Boolean convert;

      /** Whether to convert this file to the corresponding Google Docs format. [default: false]
       */
      public Boolean getConvert() {
        return convert;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      public Update setConvert(Boolean convert) {
        this.convert = convert;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to convert this file to the corresponding Google Docs format.
       * </p>
       */
      public boolean isConvert() {
        if (convert == null || convert == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return convert;
      }

      /**
     * Target language to translate the file to. If no sourceLanguage is provided, the API will
     * attempt to detect the language.
     */
      @com.google.api.client.util.Key
      private String targetLanguage;

      /** Target language to translate the file to. If no sourceLanguage is provided, the API will attempt to
     detect the language.
       */
      public String getTargetLanguage() {
        return targetLanguage;
      }

      /**
     * Target language to translate the file to. If no sourceLanguage is provided, the API will
     * attempt to detect the language.
     */
      public Update setTargetLanguage(String targetLanguage) {
        this.targetLanguage = targetLanguage;
        return this;
      }

      /** Whether to set the modified date with the supplied modified date. */
      @com.google.api.client.util.Key
      private Boolean setModifiedDate;

      /** Whether to set the modified date with the supplied modified date. [default: false]
       */
      public Boolean getSetModifiedDate() {
        return setModifiedDate;
      }

      /** Whether to set the modified date with the supplied modified date. */
      public Update setSetModifiedDate(Boolean setModifiedDate) {
        this.setModifiedDate = setModifiedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to set the modified date with the supplied modified date.
       * </p>
       */
      public boolean isSetModifiedDate() {
        if (setModifiedDate == null || setModifiedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return setModifiedDate;
      }

      /** Whether to update the view date after successfully updating the file. */
      @com.google.api.client.util.Key
      private Boolean updateViewedDate;

      /** Whether to update the view date after successfully updating the file. [default: true]
       */
      public Boolean getUpdateViewedDate() {
        return updateViewedDate;
      }

      /** Whether to update the view date after successfully updating the file. */
      public Update setUpdateViewedDate(Boolean updateViewedDate) {
        this.updateViewedDate = updateViewedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to update the view date after successfully updating the file.
       * </p>
       */
      public boolean isUpdateViewedDate() {
        if (updateViewedDate == null || updateViewedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return updateViewedDate;
      }

      /** The language of the original file to be translated. */
      @com.google.api.client.util.Key
      private String sourceLanguage;

      /** The language of the original file to be translated.
       */
      public String getSourceLanguage() {
        return sourceLanguage;
      }

      /** The language of the original file to be translated. */
      public Update setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
      }

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes. */
      @com.google.api.client.util.Key
      private String ocrLanguage;

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes.
       */
      public String getOcrLanguage() {
        return ocrLanguage;
      }

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes. */
      public Update setOcrLanguage(String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** Whether to pin the new revision. */
      @com.google.api.client.util.Key
      private Boolean pinned;

      /** Whether to pin the new revision. [default: false]
       */
      public Boolean getPinned() {
        return pinned;
      }

      /** Whether to pin the new revision. */
      public Update setPinned(Boolean pinned) {
        this.pinned = pinned;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to pin the new revision.
       * </p>
       */
      public boolean isPinned() {
        if (pinned == null || pinned == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return pinned;
      }

      /**
     * Whether a blob upload should create a new revision. If false, the blob data in the current
     * head revision will be replaced.
     */
      @com.google.api.client.util.Key
      private Boolean newRevision;

      /** Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision will be replaced. [default: true]
       */
      public Boolean getNewRevision() {
        return newRevision;
      }

      /**
     * Whether a blob upload should create a new revision. If false, the blob data in the current
     * head revision will be replaced.
     */
      public Update setNewRevision(Boolean newRevision) {
        this.newRevision = newRevision;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision will be replaced.
       * </p>
       */
      public boolean isNewRevision() {
        if (newRevision == null || newRevision == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return newRevision;
      }

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. */
      @com.google.api.client.util.Key
      private Boolean ocr;

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. [default: false]
       */
      public Boolean getOcr() {
        return ocr;
      }

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. */
      public Update setOcr(Boolean ocr) {
        this.ocr = ocr;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to attempt OCR on .jpg, .png, or .gif uploads.
       * </p>
       */
      public boolean isOcr() {
        if (ocr == null || ocr == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ocr;
      }

      /** The language of the timed text. */
      @com.google.api.client.util.Key
      private String timedTextLanguage;

      /** The language of the timed text.
       */
      public String getTimedTextLanguage() {
        return timedTextLanguage;
      }

      /** The language of the timed text. */
      public Update setTimedTextLanguage(String timedTextLanguage) {
        this.timedTextLanguage = timedTextLanguage;
        return this;
      }

      /** The timed text track name. */
      @com.google.api.client.util.Key
      private String timedTextTrackName;

      /** The timed text track name.
       */
      public String getTimedTextTrackName() {
        return timedTextTrackName;
      }

      /** The timed text track name. */
      public Update setTimedTextTrackName(String timedTextTrackName) {
        this.timedTextTrackName = timedTextTrackName;
        return this;
      }


      /**
       * Media HTTP uploader or {@code null} if there is no media HTTP content provided to be uploaded.
       */
      private com.google.api.client.googleapis.media.MediaHttpUploader uploader;

      /**
       * Returns the Media HTTP Uploader or {@code null} if there is no media HTTP content provided to
       * be uploaded.
       */
      public com.google.api.client.googleapis.media.MediaHttpUploader getMediaHttpUploader() {
        return uploader;
      }


    }
    /**
     * Updates file metadata and/or content. This method supports patch semantics.
     *
     * Create a request for the method "files.patch".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to update.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Patch patch(String fileId, com.google.api.services.drive.model.File content) throws IOException {
      Patch result = new Patch(fileId, content);
      initialize(result);
      return result;
    }


    public class Patch extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Patch(String fileId, com.google.api.services.drive.model.File content) {
        super(Drive.this, HttpMethod.PATCH, REST_PATH, content);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        Preconditions.checkNotNull(content);
      }



      /**
       * Sends the "patch" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.File} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.File execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.File result = response.parseAs(
            com.google.api.services.drive.model.File.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "patch" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;File&gt;() {

           public void onSuccess(File content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.File> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.File.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Patch setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file to update. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file to update.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file to update. */
      public Patch setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      @com.google.api.client.util.Key
      private Boolean convert;

      /** Whether to convert this file to the corresponding Google Docs format. [default: false]
       */
      public Boolean getConvert() {
        return convert;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      public Patch setConvert(Boolean convert) {
        this.convert = convert;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to convert this file to the corresponding Google Docs format.
       * </p>
       */
      public boolean isConvert() {
        if (convert == null || convert == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return convert;
      }

      /**
     * Target language to translate the file to. If no sourceLanguage is provided, the API will
     * attempt to detect the language.
     */
      @com.google.api.client.util.Key
      private String targetLanguage;

      /** Target language to translate the file to. If no sourceLanguage is provided, the API will attempt to
     detect the language.
       */
      public String getTargetLanguage() {
        return targetLanguage;
      }

      /**
     * Target language to translate the file to. If no sourceLanguage is provided, the API will
     * attempt to detect the language.
     */
      public Patch setTargetLanguage(String targetLanguage) {
        this.targetLanguage = targetLanguage;
        return this;
      }

      /** Whether to set the modified date with the supplied modified date. */
      @com.google.api.client.util.Key
      private Boolean setModifiedDate;

      /** Whether to set the modified date with the supplied modified date. [default: false]
       */
      public Boolean getSetModifiedDate() {
        return setModifiedDate;
      }

      /** Whether to set the modified date with the supplied modified date. */
      public Patch setSetModifiedDate(Boolean setModifiedDate) {
        this.setModifiedDate = setModifiedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to set the modified date with the supplied modified date.
       * </p>
       */
      public boolean isSetModifiedDate() {
        if (setModifiedDate == null || setModifiedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return setModifiedDate;
      }

      /** Whether to update the view date after successfully updating the file. */
      @com.google.api.client.util.Key
      private Boolean updateViewedDate;

      /** Whether to update the view date after successfully updating the file. [default: true]
       */
      public Boolean getUpdateViewedDate() {
        return updateViewedDate;
      }

      /** Whether to update the view date after successfully updating the file. */
      public Patch setUpdateViewedDate(Boolean updateViewedDate) {
        this.updateViewedDate = updateViewedDate;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to update the view date after successfully updating the file.
       * </p>
       */
      public boolean isUpdateViewedDate() {
        if (updateViewedDate == null || updateViewedDate == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return updateViewedDate;
      }

      /** The language of the original file to be translated. */
      @com.google.api.client.util.Key
      private String sourceLanguage;

      /** The language of the original file to be translated.
       */
      public String getSourceLanguage() {
        return sourceLanguage;
      }

      /** The language of the original file to be translated. */
      public Patch setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
      }

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes. */
      @com.google.api.client.util.Key
      private String ocrLanguage;

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes.
       */
      public String getOcrLanguage() {
        return ocrLanguage;
      }

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes. */
      public Patch setOcrLanguage(String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** Whether to pin the new revision. */
      @com.google.api.client.util.Key
      private Boolean pinned;

      /** Whether to pin the new revision. [default: false]
       */
      public Boolean getPinned() {
        return pinned;
      }

      /** Whether to pin the new revision. */
      public Patch setPinned(Boolean pinned) {
        this.pinned = pinned;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to pin the new revision.
       * </p>
       */
      public boolean isPinned() {
        if (pinned == null || pinned == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return pinned;
      }

      /**
     * Whether a blob upload should create a new revision. If false, the blob data in the current
     * head revision will be replaced.
     */
      @com.google.api.client.util.Key
      private Boolean newRevision;

      /** Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision will be replaced. [default: true]
       */
      public Boolean getNewRevision() {
        return newRevision;
      }

      /**
     * Whether a blob upload should create a new revision. If false, the blob data in the current
     * head revision will be replaced.
     */
      public Patch setNewRevision(Boolean newRevision) {
        this.newRevision = newRevision;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether a blob upload should create a new revision. If false, the blob data in the current head
     revision will be replaced.
       * </p>
       */
      public boolean isNewRevision() {
        if (newRevision == null || newRevision == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return newRevision;
      }

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. */
      @com.google.api.client.util.Key
      private Boolean ocr;

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. [default: false]
       */
      public Boolean getOcr() {
        return ocr;
      }

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. */
      public Patch setOcr(Boolean ocr) {
        this.ocr = ocr;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to attempt OCR on .jpg, .png, or .gif uploads.
       * </p>
       */
      public boolean isOcr() {
        if (ocr == null || ocr == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ocr;
      }

      /** The language of the timed text. */
      @com.google.api.client.util.Key
      private String timedTextLanguage;

      /** The language of the timed text.
       */
      public String getTimedTextLanguage() {
        return timedTextLanguage;
      }

      /** The language of the timed text. */
      public Patch setTimedTextLanguage(String timedTextLanguage) {
        this.timedTextLanguage = timedTextLanguage;
        return this;
      }

      /** The timed text track name. */
      @com.google.api.client.util.Key
      private String timedTextTrackName;

      /** The timed text track name.
       */
      public String getTimedTextTrackName() {
        return timedTextTrackName;
      }

      /** The timed text track name. */
      public Patch setTimedTextTrackName(String timedTextTrackName) {
        this.timedTextTrackName = timedTextTrackName;
        return this;
      }



    }
    /**
     * Set the file's updated time to the current server time.
     *
     * Create a request for the method "files.touch".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Touch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to update.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Touch touch(String fileId) throws IOException {
      Touch result = new Touch(fileId);
      initialize(result);
      return result;
    }


    public class Touch extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/touch";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Touch(String fileId) {
        super(Drive.this, HttpMethod.POST, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }



      /**
       * Sends the "touch" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.File} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.File execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.File result = response.parseAs(
            com.google.api.services.drive.model.File.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "touch" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;File&gt;() {

           public void onSuccess(File content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.File> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.File.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Touch setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file to update. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file to update.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file to update. */
      public Touch setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }



    }
    /**
     * Creates a copy of the specified file.
     *
     * Create a request for the method "files.copy".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Copy#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to copy.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Copy copy(String fileId, com.google.api.services.drive.model.File content) throws IOException {
      Copy result = new Copy(fileId, content);
      initialize(result);
      return result;
    }


    public class Copy extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/copy";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Copy(String fileId, com.google.api.services.drive.model.File content) {
        super(Drive.this, HttpMethod.POST, REST_PATH, content);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        Preconditions.checkNotNull(content);
      }



      /**
       * Sends the "copy" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.File} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.File execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.File result = response.parseAs(
            com.google.api.services.drive.model.File.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "copy" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;File&gt;() {

           public void onSuccess(File content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.File> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.File.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Copy setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file to copy. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file to copy.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file to copy. */
      public Copy setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      @com.google.api.client.util.Key
      private Boolean convert;

      /** Whether to convert this file to the corresponding Google Docs format. [default: false]
       */
      public Boolean getConvert() {
        return convert;
      }

      /** Whether to convert this file to the corresponding Google Docs format. */
      public Copy setConvert(Boolean convert) {
        this.convert = convert;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to convert this file to the corresponding Google Docs format.
       * </p>
       */
      public boolean isConvert() {
        if (convert == null || convert == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return convert;
      }

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. */
      @com.google.api.client.util.Key
      private Boolean ocr;

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. [default: false]
       */
      public Boolean getOcr() {
        return ocr;
      }

      /** Whether to attempt OCR on .jpg, .png, or .gif uploads. */
      public Copy setOcr(Boolean ocr) {
        this.ocr = ocr;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to attempt OCR on .jpg, .png, or .gif uploads.
       * </p>
       */
      public boolean isOcr() {
        if (ocr == null || ocr == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ocr;
      }

      /** The language of the original file to be translated. */
      @com.google.api.client.util.Key
      private String sourceLanguage;

      /** The language of the original file to be translated.
       */
      public String getSourceLanguage() {
        return sourceLanguage;
      }

      /** The language of the original file to be translated. */
      public Copy setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
      }

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes. */
      @com.google.api.client.util.Key
      private String ocrLanguage;

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes.
       */
      public String getOcrLanguage() {
        return ocrLanguage;
      }

      /** If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes. */
      public Copy setOcrLanguage(String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** The language of the timed text. */
      @com.google.api.client.util.Key
      private String timedTextLanguage;

      /** The language of the timed text.
       */
      public String getTimedTextLanguage() {
        return timedTextLanguage;
      }

      /** The language of the timed text. */
      public Copy setTimedTextLanguage(String timedTextLanguage) {
        this.timedTextLanguage = timedTextLanguage;
        return this;
      }

      /**
     * Target language to translate the file to. If no sourceLanguage is provided, the API will
     * attempt to detect the language.
     */
      @com.google.api.client.util.Key
      private String targetLanguage;

      /** Target language to translate the file to. If no sourceLanguage is provided, the API will attempt to
     detect the language.
       */
      public String getTargetLanguage() {
        return targetLanguage;
      }

      /**
     * Target language to translate the file to. If no sourceLanguage is provided, the API will
     * attempt to detect the language.
     */
      public Copy setTargetLanguage(String targetLanguage) {
        this.targetLanguage = targetLanguage;
        return this;
      }

      /** The timed text track name. */
      @com.google.api.client.util.Key
      private String timedTextTrackName;

      /** The timed text track name.
       */
      public String getTimedTextTrackName() {
        return timedTextTrackName;
      }

      /** The timed text track name. */
      public Copy setTimedTextTrackName(String timedTextTrackName) {
        this.timedTextTrackName = timedTextTrackName;
        return this;
      }



    }
    /**
     * Permanently deletes a file by ID. Skips the trash.
     *
     * Create a request for the method "files.delete".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to delete.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Delete delete(String fileId) throws IOException {
      Delete result = new Delete(fileId);
      initialize(result);
      return result;
    }


    public class Delete extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Delete(String fileId) {
        super(Drive.this, HttpMethod.DELETE, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }



      /**
       * Sends the "delete" request to the Drive server.
       *
       * @throws IOException if the request fails
       */
      public void execute() throws IOException {
        HttpResponse response = executeUnparsed();
        response.ignore();
      }

      /**
       * Queues the "delete" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Void&gt;() {

           public void onSuccess(Void content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<Void> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), Void.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Delete setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file to delete. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file to delete.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file to delete. */
      public Delete setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }



    }

  }

  /**
   * An accessor for creating requests from the About collection.
   *
   * The typical use is:<pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.About.List request = drive.about().list(parameters ...)}</pre>
   *
   * @return the resource collection
   */
  public About about() {
    return new About();
  }

  /**
   * The "about" collection of methods.
   */
  public class About {

    /**
     * Gets the information about the current user along with Drive API settings
     *
     * Create a request for the method "about.get".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Get get() throws IOException {
      Get result = new Get();
      initialize(result);
      return result;
    }


    public class Get extends DriveRequest {

      private static final String REST_PATH = "about";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Get() {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
      }



      /**
       * Sends the "get" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.About} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.About execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.About result = response.parseAs(
            com.google.api.services.drive.model.About.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "get" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;About&gt;() {

           public void onSuccess(About content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.About> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.About.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Get setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** Whether to include subscribed items when calculating the number of remaining change IDs */
      @com.google.api.client.util.Key
      private Boolean includeSubscribed;

      /** Whether to include subscribed items when calculating the number of remaining change IDs [default:
     true]
       */
      public Boolean getIncludeSubscribed() {
        return includeSubscribed;
      }

      /** Whether to include subscribed items when calculating the number of remaining change IDs */
      public Get setIncludeSubscribed(Boolean includeSubscribed) {
        this.includeSubscribed = includeSubscribed;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include subscribed items when calculating the number of remaining change IDs
       * </p>
       */
      public boolean isIncludeSubscribed() {
        if (includeSubscribed == null || includeSubscribed == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeSubscribed;
      }

      /** Maximum number of remaining change IDs to count */
      @com.google.api.client.util.Key
      private BigInteger maxChangeIdCount;

      /** Maximum number of remaining change IDs to count [default: 1]
       */
      public BigInteger getMaxChangeIdCount() {
        return maxChangeIdCount;
      }

      /** Maximum number of remaining change IDs to count */
      public Get setMaxChangeIdCount(BigInteger maxChangeIdCount) {
        this.maxChangeIdCount = maxChangeIdCount;
        return this;
      }

      /** Change ID to start counting from when calculating number of remaining change IDs */
      @com.google.api.client.util.Key
      private BigInteger startChangeId;

      /** Change ID to start counting from when calculating number of remaining change IDs
       */
      public BigInteger getStartChangeId() {
        return startChangeId;
      }

      /** Change ID to start counting from when calculating number of remaining change IDs */
      public Get setStartChangeId(BigInteger startChangeId) {
        this.startChangeId = startChangeId;
        return this;
      }



    }

  }

  /**
   * An accessor for creating requests from the Apps collection.
   *
   * The typical use is:<pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Apps.List request = drive.apps().list(parameters ...)}</pre>
   *
   * @return the resource collection
   */
  public Apps apps() {
    return new Apps();
  }

  /**
   * The "apps" collection of methods.
   */
  public class Apps {

    /**
     * Lists a user's apps.
     *
     * Create a request for the method "apps.list".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public List list() throws IOException {
      List result = new List();
      initialize(result);
      return result;
    }


    public class List extends DriveRequest {

      private static final String REST_PATH = "apps";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      List() {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
      }



      /**
       * Sends the "list" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.AppList} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.AppList execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.AppList result = response.parseAs(
            com.google.api.services.drive.model.AppList.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "list" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;AppList&gt;() {

           public void onSuccess(AppList content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.AppList> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.AppList.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public List setFields(String fields) {
        super.setFields(fields);
        return this;
      }



    }

  }

  /**
   * An accessor for creating requests from the Parents collection.
   *
   * The typical use is:<pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Parents.List request = drive.parents().list(parameters ...)}</pre>
   *
   * @return the resource collection
   */
  public Parents parents() {
    return new Parents();
  }

  /**
   * The "parents" collection of methods.
   */
  public class Parents {

    /**
     * Adds a parent folder for a file.
     *
     * Create a request for the method "parents.insert".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.ParentReference}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Insert insert(String fileId, com.google.api.services.drive.model.ParentReference content) throws IOException {
      Insert result = new Insert(fileId, content);
      initialize(result);
      return result;
    }


    public class Insert extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/parents";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Insert(String fileId, com.google.api.services.drive.model.ParentReference content) {
        super(Drive.this, HttpMethod.POST, REST_PATH, content);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        Preconditions.checkNotNull(content);
      }



      /**
       * Sends the "insert" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.ParentReference} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.ParentReference execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.ParentReference result = response.parseAs(
            com.google.api.services.drive.model.ParentReference.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "insert" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;ParentReference&gt;() {

           public void onSuccess(ParentReference content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.ParentReference> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.ParentReference.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Insert setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Insert setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }



    }
    /**
     * Gets a specific parent reference.
     *
     * Create a request for the method "parents.get".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param parentId The ID of the parent.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Get get(String fileId, String parentId) throws IOException {
      Get result = new Get(fileId, parentId);
      initialize(result);
      return result;
    }


    public class Get extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/parents/{parentId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Get(String fileId, String parentId) {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.parentId = Preconditions.checkNotNull(parentId, "Required parameter parentId must be specified.");
      }



      /**
       * Sends the "get" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.ParentReference} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.ParentReference execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.ParentReference result = response.parseAs(
            com.google.api.services.drive.model.ParentReference.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "get" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;ParentReference&gt;() {

           public void onSuccess(ParentReference content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.ParentReference> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.ParentReference.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Get setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the parent. */
      @com.google.api.client.util.Key
      private String parentId;

      /** The ID of the parent.
       */
      public String getParentId() {
        return parentId;
      }

      /** The ID of the parent. */
      public Get setParentId(String parentId) {
        this.parentId = parentId;
        return this;
      }



    }
    /**
     * Lists a file's parents.
     *
     * Create a request for the method "parents.list".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public List list(String fileId) throws IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }


    public class List extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/parents";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      List(String fileId) {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }



      /**
       * Sends the "list" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.ParentList} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.ParentList execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.ParentList result = response.parseAs(
            com.google.api.services.drive.model.ParentList.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "list" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;ParentList&gt;() {

           public void onSuccess(ParentList content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.ParentList> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.ParentList.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public List setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }



    }
    /**
     * Removes a parent from a file.
     *
     * Create a request for the method "parents.delete".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param parentId The ID of the parent.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Delete delete(String fileId, String parentId) throws IOException {
      Delete result = new Delete(fileId, parentId);
      initialize(result);
      return result;
    }


    public class Delete extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/parents/{parentId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Delete(String fileId, String parentId) {
        super(Drive.this, HttpMethod.DELETE, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.parentId = Preconditions.checkNotNull(parentId, "Required parameter parentId must be specified.");
      }



      /**
       * Sends the "delete" request to the Drive server.
       *
       * @throws IOException if the request fails
       */
      public void execute() throws IOException {
        HttpResponse response = executeUnparsed();
        response.ignore();
      }

      /**
       * Queues the "delete" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Void&gt;() {

           public void onSuccess(Void content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<Void> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), Void.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Delete setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the parent. */
      @com.google.api.client.util.Key
      private String parentId;

      /** The ID of the parent.
       */
      public String getParentId() {
        return parentId;
      }

      /** The ID of the parent. */
      public Delete setParentId(String parentId) {
        this.parentId = parentId;
        return this;
      }



    }

  }

  /**
   * An accessor for creating requests from the Revisions collection.
   *
   * The typical use is:<pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Revisions.List request = drive.revisions().list(parameters ...)}</pre>
   *
   * @return the resource collection
   */
  public Revisions revisions() {
    return new Revisions();
  }

  /**
   * The "revisions" collection of methods.
   */
  public class Revisions {

    /**
     * Updates a revision. This method supports patch semantics.
     *
     * Create a request for the method "revisions.patch".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param revisionId The ID for the revision.
     * @param content the {@link com.google.api.services.drive.model.Revision}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Patch patch(String fileId, String revisionId, com.google.api.services.drive.model.Revision content) throws IOException {
      Patch result = new Patch(fileId, revisionId, content);
      initialize(result);
      return result;
    }


    public class Patch extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Patch(String fileId, String revisionId, com.google.api.services.drive.model.Revision content) {
        super(Drive.this, HttpMethod.PATCH, REST_PATH, content);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
        Preconditions.checkNotNull(content);
      }



      /**
       * Sends the "patch" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.Revision} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.Revision execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.Revision result = response.parseAs(
            com.google.api.services.drive.model.Revision.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "patch" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Revision&gt;() {

           public void onSuccess(Revision content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.Revision> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.Revision.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Patch setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID for the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Patch setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the revision. */
      @com.google.api.client.util.Key
      private String revisionId;

      /** The ID for the revision.
       */
      public String getRevisionId() {
        return revisionId;
      }

      /** The ID for the revision. */
      public Patch setRevisionId(String revisionId) {
        this.revisionId = revisionId;
        return this;
      }



    }
    /**
     * Gets a specific revision.
     *
     * Create a request for the method "revisions.get".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param revisionId The ID of the revision.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Get get(String fileId, String revisionId) throws IOException {
      Get result = new Get(fileId, revisionId);
      initialize(result);
      return result;
    }


    public class Get extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Get(String fileId, String revisionId) {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
      }



      /**
       * Sends the "get" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.Revision} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.Revision execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.Revision result = response.parseAs(
            com.google.api.services.drive.model.Revision.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "get" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Revision&gt;() {

           public void onSuccess(Revision content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.Revision> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.Revision.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Get setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the revision. */
      @com.google.api.client.util.Key
      private String revisionId;

      /** The ID of the revision.
       */
      public String getRevisionId() {
        return revisionId;
      }

      /** The ID of the revision. */
      public Get setRevisionId(String revisionId) {
        this.revisionId = revisionId;
        return this;
      }



    }
    /**
     * Lists a file's revisions.
     *
     * Create a request for the method "revisions.list".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public List list(String fileId) throws IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }


    public class List extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/revisions";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      List(String fileId) {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }



      /**
       * Sends the "list" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.RevisionList} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.RevisionList execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.RevisionList result = response.parseAs(
            com.google.api.services.drive.model.RevisionList.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "list" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;RevisionList&gt;() {

           public void onSuccess(RevisionList content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.RevisionList> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.RevisionList.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public List setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }



    }
    /**
     * Updates a revision.
     *
     * Create a request for the method "revisions.update".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param revisionId The ID for the revision.
     * @param content the {@link com.google.api.services.drive.model.Revision}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Update update(String fileId, String revisionId, com.google.api.services.drive.model.Revision content) throws IOException {
      Update result = new Update(fileId, revisionId, content);
      initialize(result);
      return result;
    }


    public class Update extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Update(String fileId, String revisionId, com.google.api.services.drive.model.Revision content) {
        super(Drive.this, HttpMethod.PUT, REST_PATH, content);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
        Preconditions.checkNotNull(content);
      }



      /**
       * Sends the "update" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.Revision} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.Revision execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.Revision result = response.parseAs(
            com.google.api.services.drive.model.Revision.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "update" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Revision&gt;() {

           public void onSuccess(Revision content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.Revision> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.Revision.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Update setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID for the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Update setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the revision. */
      @com.google.api.client.util.Key
      private String revisionId;

      /** The ID for the revision.
       */
      public String getRevisionId() {
        return revisionId;
      }

      /** The ID for the revision. */
      public Update setRevisionId(String revisionId) {
        this.revisionId = revisionId;
        return this;
      }



    }
    /**
     * Removes a revision.
     *
     * Create a request for the method "revisions.delete".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param revisionId The ID of the revision.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Delete delete(String fileId, String revisionId) throws IOException {
      Delete result = new Delete(fileId, revisionId);
      initialize(result);
      return result;
    }


    public class Delete extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Delete(String fileId, String revisionId) {
        super(Drive.this, HttpMethod.DELETE, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
      }



      /**
       * Sends the "delete" request to the Drive server.
       *
       * @throws IOException if the request fails
       */
      public void execute() throws IOException {
        HttpResponse response = executeUnparsed();
        response.ignore();
      }

      /**
       * Queues the "delete" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Void&gt;() {

           public void onSuccess(Void content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<Void> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), Void.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Delete setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID of the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the revision. */
      @com.google.api.client.util.Key
      private String revisionId;

      /** The ID of the revision.
       */
      public String getRevisionId() {
        return revisionId;
      }

      /** The ID of the revision. */
      public Delete setRevisionId(String revisionId) {
        this.revisionId = revisionId;
        return this;
      }



    }

  }

  /**
   * An accessor for creating requests from the Changes collection.
   *
   * The typical use is:<pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Changes.List request = drive.changes().list(parameters ...)}</pre>
   *
   * @return the resource collection
   */
  public Changes changes() {
    return new Changes();
  }

  /**
   * The "changes" collection of methods.
   */
  public class Changes {

    /**
     * Lists the changes for a user.
     *
     * Create a request for the method "changes.list".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public List list() throws IOException {
      List result = new List();
      initialize(result);
      return result;
    }


    public class List extends DriveRequest {

      private static final String REST_PATH = "changes";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      List() {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
      }



      /**
       * Sends the "list" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.ChangeList} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.ChangeList execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.ChangeList result = response.parseAs(
            com.google.api.services.drive.model.ChangeList.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "list" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;ChangeList&gt;() {

           public void onSuccess(ChangeList content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.ChangeList> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.ChangeList.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public List setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** Whether to include subscribed items. */
      @com.google.api.client.util.Key
      private Boolean includeSubscribed;

      /** Whether to include subscribed items. [default: true]
       */
      public Boolean getIncludeSubscribed() {
        return includeSubscribed;
      }

      /** Whether to include subscribed items. */
      public List setIncludeSubscribed(Boolean includeSubscribed) {
        this.includeSubscribed = includeSubscribed;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include subscribed items.
       * </p>
       */
      public boolean isIncludeSubscribed() {
        if (includeSubscribed == null || includeSubscribed == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeSubscribed;
      }

      /** Change ID to start listing changes from. */
      @com.google.api.client.util.Key
      private BigInteger startChangeId;

      /** Change ID to start listing changes from.
       */
      public BigInteger getStartChangeId() {
        return startChangeId;
      }

      /** Change ID to start listing changes from. */
      public List setStartChangeId(BigInteger startChangeId) {
        this.startChangeId = startChangeId;
        return this;
      }

      /** Whether to include deleted items. */
      @com.google.api.client.util.Key
      private Boolean includeDeleted;

      /** Whether to include deleted items. [default: true]
       */
      public Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /** Whether to include deleted items. */
      public List setIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include deleted items.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeDeleted;
      }

      /** Maximum number of changes to return. */
      @com.google.api.client.util.Key
      private Integer maxResults;

      /** Maximum number of changes to return. [default: 100] [minimum: 0]
       */
      public Integer getMaxResults() {
        return maxResults;
      }

      /** Maximum number of changes to return. */
      public List setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token for changes. */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Page token for changes.
       */
      public String getPageToken() {
        return pageToken;
      }

      /** Page token for changes. */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }



    }
    /**
     * Gets a specific change.
     *
     * Create a request for the method "changes.get".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param changeId The ID of the change.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Get get(String changeId) throws IOException {
      Get result = new Get(changeId);
      initialize(result);
      return result;
    }


    public class Get extends DriveRequest {

      private static final String REST_PATH = "changes/{changeId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Get(String changeId) {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
        this.changeId = Preconditions.checkNotNull(changeId, "Required parameter changeId must be specified.");
      }



      /**
       * Sends the "get" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.Change} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.Change execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.Change result = response.parseAs(
            com.google.api.services.drive.model.Change.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "get" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Change&gt;() {

           public void onSuccess(Change content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.Change> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.Change.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Get setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the change. */
      @com.google.api.client.util.Key
      private String changeId;

      /** The ID of the change.
       */
      public String getChangeId() {
        return changeId;
      }

      /** The ID of the change. */
      public Get setChangeId(String changeId) {
        this.changeId = changeId;
        return this;
      }



    }

  }

  /**
   * An accessor for creating requests from the Children collection.
   *
   * The typical use is:<pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Children.List request = drive.children().list(parameters ...)}</pre>
   *
   * @return the resource collection
   */
  public Children children() {
    return new Children();
  }

  /**
   * The "children" collection of methods.
   */
  public class Children {

    /**
     * Inserts a file into a folder.
     *
     * Create a request for the method "children.insert".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param folderId The ID of the folder.
     * @param content the {@link com.google.api.services.drive.model.ChildReference}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Insert insert(String folderId, com.google.api.services.drive.model.ChildReference content) throws IOException {
      Insert result = new Insert(folderId, content);
      initialize(result);
      return result;
    }


    public class Insert extends DriveRequest {

      private static final String REST_PATH = "files/{folderId}/children";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Insert(String folderId, com.google.api.services.drive.model.ChildReference content) {
        super(Drive.this, HttpMethod.POST, REST_PATH, content);
        this.folderId = Preconditions.checkNotNull(folderId, "Required parameter folderId must be specified.");
        Preconditions.checkNotNull(content);
      }



      /**
       * Sends the "insert" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.ChildReference} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.ChildReference execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.ChildReference result = response.parseAs(
            com.google.api.services.drive.model.ChildReference.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "insert" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;ChildReference&gt;() {

           public void onSuccess(ChildReference content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.ChildReference> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.ChildReference.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Insert setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the folder. */
      @com.google.api.client.util.Key
      private String folderId;

      /** The ID of the folder.
       */
      public String getFolderId() {
        return folderId;
      }

      /** The ID of the folder. */
      public Insert setFolderId(String folderId) {
        this.folderId = folderId;
        return this;
      }



    }
    /**
     * Gets a specific child reference.
     *
     * Create a request for the method "children.get".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param folderId The ID of the folder.
     * @param childId The ID of the child.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Get get(String folderId, String childId) throws IOException {
      Get result = new Get(folderId, childId);
      initialize(result);
      return result;
    }


    public class Get extends DriveRequest {

      private static final String REST_PATH = "files/{folderId}/children/{childId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Get(String folderId, String childId) {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
        this.folderId = Preconditions.checkNotNull(folderId, "Required parameter folderId must be specified.");
        this.childId = Preconditions.checkNotNull(childId, "Required parameter childId must be specified.");
      }



      /**
       * Sends the "get" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.ChildReference} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.ChildReference execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.ChildReference result = response.parseAs(
            com.google.api.services.drive.model.ChildReference.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "get" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;ChildReference&gt;() {

           public void onSuccess(ChildReference content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.ChildReference> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.ChildReference.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Get setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the folder. */
      @com.google.api.client.util.Key
      private String folderId;

      /** The ID of the folder.
       */
      public String getFolderId() {
        return folderId;
      }

      /** The ID of the folder. */
      public Get setFolderId(String folderId) {
        this.folderId = folderId;
        return this;
      }

      /** The ID of the child. */
      @com.google.api.client.util.Key
      private String childId;

      /** The ID of the child.
       */
      public String getChildId() {
        return childId;
      }

      /** The ID of the child. */
      public Get setChildId(String childId) {
        this.childId = childId;
        return this;
      }



    }
    /**
     * Lists a folder's children.
     *
     * Create a request for the method "children.list".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param folderId The ID of the folder.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public List list(String folderId) throws IOException {
      List result = new List(folderId);
      initialize(result);
      return result;
    }


    public class List extends DriveRequest {

      private static final String REST_PATH = "files/{folderId}/children";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      List(String folderId) {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
        this.folderId = Preconditions.checkNotNull(folderId, "Required parameter folderId must be specified.");
      }



      /**
       * Sends the "list" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.ChildList} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.ChildList execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.ChildList result = response.parseAs(
            com.google.api.services.drive.model.ChildList.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "list" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;ChildList&gt;() {

           public void onSuccess(ChildList content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.ChildList> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.ChildList.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public List setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the folder. */
      @com.google.api.client.util.Key
      private String folderId;

      /** The ID of the folder.
       */
      public String getFolderId() {
        return folderId;
      }

      /** The ID of the folder. */
      public List setFolderId(String folderId) {
        this.folderId = folderId;
        return this;
      }

      /** Query string for searching children. */
      @com.google.api.client.util.Key
      private String q;

      /** Query string for searching children.
       */
      public String getQ() {
        return q;
      }

      /** Query string for searching children. */
      public List setQ(String q) {
        this.q = q;
        return this;
      }

      /** Page token for children. */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Page token for children.
       */
      public String getPageToken() {
        return pageToken;
      }

      /** Page token for children. */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum number of children to return. */
      @com.google.api.client.util.Key
      private Integer maxResults;

      /** Maximum number of children to return. [default: 100] [minimum: 0]
       */
      public Integer getMaxResults() {
        return maxResults;
      }

      /** Maximum number of children to return. */
      public List setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }



    }
    /**
     * Removes a child from a folder.
     *
     * Create a request for the method "children.delete".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param folderId The ID of the folder.
     * @param childId The ID of the child.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Delete delete(String folderId, String childId) throws IOException {
      Delete result = new Delete(folderId, childId);
      initialize(result);
      return result;
    }


    public class Delete extends DriveRequest {

      private static final String REST_PATH = "files/{folderId}/children/{childId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Delete(String folderId, String childId) {
        super(Drive.this, HttpMethod.DELETE, REST_PATH, null);
        this.folderId = Preconditions.checkNotNull(folderId, "Required parameter folderId must be specified.");
        this.childId = Preconditions.checkNotNull(childId, "Required parameter childId must be specified.");
      }



      /**
       * Sends the "delete" request to the Drive server.
       *
       * @throws IOException if the request fails
       */
      public void execute() throws IOException {
        HttpResponse response = executeUnparsed();
        response.ignore();
      }

      /**
       * Queues the "delete" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Void&gt;() {

           public void onSuccess(Void content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<Void> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), Void.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Delete setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID of the folder. */
      @com.google.api.client.util.Key
      private String folderId;

      /** The ID of the folder.
       */
      public String getFolderId() {
        return folderId;
      }

      /** The ID of the folder. */
      public Delete setFolderId(String folderId) {
        this.folderId = folderId;
        return this;
      }

      /** The ID of the child. */
      @com.google.api.client.util.Key
      private String childId;

      /** The ID of the child.
       */
      public String getChildId() {
        return childId;
      }

      /** The ID of the child. */
      public Delete setChildId(String childId) {
        this.childId = childId;
        return this;
      }



    }

  }

  /**
   * An accessor for creating requests from the Permissions collection.
   *
   * The typical use is:<pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Permissions.List request = drive.permissions().list(parameters ...)}</pre>
   *
   * @return the resource collection
   */
  public Permissions permissions() {
    return new Permissions();
  }

  /**
   * The "permissions" collection of methods.
   */
  public class Permissions {

    /**
     * Inserts a permission for a file.
     *
     * Create a request for the method "permissions.insert".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param content the {@link com.google.api.services.drive.model.Permission}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Insert insert(String fileId, com.google.api.services.drive.model.Permission content) throws IOException {
      Insert result = new Insert(fileId, content);
      initialize(result);
      return result;
    }


    public class Insert extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/permissions";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Insert(String fileId, com.google.api.services.drive.model.Permission content) {
        super(Drive.this, HttpMethod.POST, REST_PATH, content);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        Preconditions.checkNotNull(content);
      }



      /**
       * Sends the "insert" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.Permission} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.Permission execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.Permission result = response.parseAs(
            com.google.api.services.drive.model.Permission.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "insert" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Permission&gt;() {

           public void onSuccess(Permission content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.Permission> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.Permission.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Insert setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID for the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Insert setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Whether to send notification emails. */
      @com.google.api.client.util.Key
      private Boolean sendNotificationEmails;

      /** Whether to send notification emails. [default: true]
       */
      public Boolean getSendNotificationEmails() {
        return sendNotificationEmails;
      }

      /** Whether to send notification emails. */
      public Insert setSendNotificationEmails(Boolean sendNotificationEmails) {
        this.sendNotificationEmails = sendNotificationEmails;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to send notification emails.
       * </p>
       */
      public boolean isSendNotificationEmails() {
        if (sendNotificationEmails == null || sendNotificationEmails == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return sendNotificationEmails;
      }



    }
    /**
     * Gets a permission by ID.
     *
     * Create a request for the method "permissions.get".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param permissionId The ID for the permission.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Get get(String fileId, String permissionId) throws IOException {
      Get result = new Get(fileId, permissionId);
      initialize(result);
      return result;
    }


    public class Get extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Get(String fileId, String permissionId) {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }



      /**
       * Sends the "get" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.Permission} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.Permission execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.Permission result = response.parseAs(
            com.google.api.services.drive.model.Permission.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "get" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Permission&gt;() {

           public void onSuccess(Permission content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.Permission> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.Permission.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Get setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID for the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Get setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the permission. */
      @com.google.api.client.util.Key
      private String permissionId;

      /** The ID for the permission.
       */
      public String getPermissionId() {
        return permissionId;
      }

      /** The ID for the permission. */
      public Get setPermissionId(String permissionId) {
        this.permissionId = permissionId;
        return this;
      }



    }
    /**
     * Lists a file's permissions.
     *
     * Create a request for the method "permissions.list".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public List list(String fileId) throws IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }


    public class List extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/permissions";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      List(String fileId) {
        super(Drive.this, HttpMethod.GET, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }



      /**
       * Sends the "list" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.PermissionList} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.PermissionList execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.PermissionList result = response.parseAs(
            com.google.api.services.drive.model.PermissionList.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "list" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;PermissionList&gt;() {

           public void onSuccess(PermissionList content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.PermissionList> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.PermissionList.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public List setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID for the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public List setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }



    }
    /**
     * Updates a permission.
     *
     * Create a request for the method "permissions.update".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param permissionId The ID for the permission.
     * @param content the {@link com.google.api.services.drive.model.Permission}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Update update(String fileId, String permissionId, com.google.api.services.drive.model.Permission content) throws IOException {
      Update result = new Update(fileId, permissionId, content);
      initialize(result);
      return result;
    }


    public class Update extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Update(String fileId, String permissionId, com.google.api.services.drive.model.Permission content) {
        super(Drive.this, HttpMethod.PUT, REST_PATH, content);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
        Preconditions.checkNotNull(content);
      }



      /**
       * Sends the "update" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.Permission} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.Permission execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.Permission result = response.parseAs(
            com.google.api.services.drive.model.Permission.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "update" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Permission&gt;() {

           public void onSuccess(Permission content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.Permission> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.Permission.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Update setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID for the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Update setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the permission. */
      @com.google.api.client.util.Key
      private String permissionId;

      /** The ID for the permission.
       */
      public String getPermissionId() {
        return permissionId;
      }

      /** The ID for the permission. */
      public Update setPermissionId(String permissionId) {
        this.permissionId = permissionId;
        return this;
      }



    }
    /**
     * Updates a permission. This method supports patch semantics.
     *
     * Create a request for the method "permissions.patch".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param permissionId The ID for the permission.
     * @param content the {@link com.google.api.services.drive.model.Permission}
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Patch patch(String fileId, String permissionId, com.google.api.services.drive.model.Permission content) throws IOException {
      Patch result = new Patch(fileId, permissionId, content);
      initialize(result);
      return result;
    }


    public class Patch extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Patch(String fileId, String permissionId, com.google.api.services.drive.model.Permission content) {
        super(Drive.this, HttpMethod.PATCH, REST_PATH, content);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
        Preconditions.checkNotNull(content);
      }



      /**
       * Sends the "patch" request to the Drive server.
       *
       * @return the {@link com.google.api.services.drive.model.Permission} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.drive.model.Permission execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.drive.model.Permission result = response.parseAs(
            com.google.api.services.drive.model.Permission.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "patch" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Permission&gt;() {

           public void onSuccess(Permission content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.drive.model.Permission> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.drive.model.Permission.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Patch setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID for the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Patch setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the permission. */
      @com.google.api.client.util.Key
      private String permissionId;

      /** The ID for the permission.
       */
      public String getPermissionId() {
        return permissionId;
      }

      /** The ID for the permission. */
      public Patch setPermissionId(String permissionId) {
        this.permissionId = permissionId;
        return this;
      }



    }
    /**
     * Deletes a permission from a file.
     *
     * Create a request for the method "permissions.delete".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @param permissionId The ID for the permission.
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Delete delete(String fileId, String permissionId) throws IOException {
      Delete result = new Delete(fileId, permissionId);
      initialize(result);
      return result;
    }


    public class Delete extends DriveRequest {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Delete(String fileId, String permissionId) {
        super(Drive.this, HttpMethod.DELETE, REST_PATH, null);
        this.fileId = Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }



      /**
       * Sends the "delete" request to the Drive server.
       *
       * @throws IOException if the request fails
       */
      public void execute() throws IOException {
        HttpResponse response = executeUnparsed();
        response.ignore();
      }

      /**
       * Queues the "delete" request to the Drive server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Void&gt;() {

           public void onSuccess(Void content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<Void> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), Void.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Delete setFields(String fields) {
        super.setFields(fields);
        return this;
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private String fileId;

      /** The ID for the file.
       */
      public String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public Delete setFileId(String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID for the permission. */
      @com.google.api.client.util.Key
      private String permissionId;

      /** The ID for the permission.
       */
      public String getPermissionId() {
        return permissionId;
      }

      /** The ID for the permission. */
      public Delete setPermissionId(String permissionId) {
        this.permissionId = permissionId;
        return this;
      }



    }

  }



  /**
   * Builder for {@link Drive}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends GoogleClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport The transport to use for requests
     * @param jsonFactory A factory for creating JSON parsers and serializers
     * @param baseUrl The base URL of the service. Must end with a "/"
     */
    @Deprecated
    Builder(HttpTransport transport, JsonFactory jsonFactory, GenericUrl baseUrl) {
      super(transport, jsonFactory, baseUrl);
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport The transport to use for requests
     * @param jsonFactory A factory for creating JSON parsers and serializers
     * @param httpRequestInitializer The HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(HttpTransport transport, JsonFactory jsonFactory,
        HttpRequestInitializer httpRequestInitializer) {
      super(transport, jsonFactory, DEFAULT_ROOT_URL, DEFAULT_SERVICE_PATH, httpRequestInitializer);
    }

    /** Builds a new instance of {@link Drive}. */
    @SuppressWarnings("deprecation")
    @Override
    public Drive build() {
      if (isBaseUrlUsed()) {
        return new Drive(
            getTransport(),
            getJsonHttpRequestInitializer(),
            getHttpRequestInitializer(),
            getJsonFactory(),
            getObjectParser(),
            getBaseUrl().build(),
            getApplicationName());
      }
      return new Drive(
          getTransport(),
          getJsonHttpRequestInitializer(),
          getHttpRequestInitializer(),
          getJsonFactory(),
          getObjectParser(),
          getRootUrl(),
          getServicePath(),
          getApplicationName());
    }

    @Override
    @Deprecated
    public Builder setBaseUrl(GenericUrl baseUrl) {
      super.setBaseUrl(baseUrl);
      return this;
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      super.setRootUrl(rootUrl);
      return this;
    }

    @Override
    public Builder setServicePath(String servicePath) {
      super.setServicePath(servicePath);
      return this;
    }

    @Override
    public Builder setJsonHttpRequestInitializer(
        JsonHttpRequestInitializer jsonHttpRequestInitializer) {
      super.setJsonHttpRequestInitializer(jsonHttpRequestInitializer);
      return this;
    }

    @Override
    public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
      super.setHttpRequestInitializer(httpRequestInitializer);
      return this;
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      super.setApplicationName(applicationName);
      return this;
    }

    @Override
    public Builder setObjectParser(JsonObjectParser parser) {
      super.setObjectParser(parser);
      return this;
    }
  }
}
