/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.drive.model;


import com.google.api.client.http.HttpHeaders;
import com.google.api.client.json.GenericJson;


/**
 * Information about a third-party application which the user has installed or given access to
 * Google Drive.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
public final class App extends GenericJson {


  /**
   * This is always drive#app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;



  /**
   * The list of primary file extensions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> primaryFileExtensions;



  /**
   * The name of the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;



  /**
   * The various icons for the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Icons> icons;

  static {
    // hack to force ProGuard to consider Icons used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Icons.class);
  }

  /**
   * The list of secondary file extensions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> secondaryFileExtensions;



  /**
   * Whether the app is installed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean installed;



  /**
   * The product URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String productUrl;



  /**
   * The list of secondary mime types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> secondaryMimeTypes;



  /**
   * Whether the app is authorized to access data on the user's Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean authorized;



  /**
   * Whether this app supports creating new objects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean supportsCreate;



  /**
   * Whether this app supports importing Google Docs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean supportsImport;



  /**
   * The list of primary mime types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> primaryMimeTypes;



  /**
   * The ID of the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;



  /**
   * The name of the type of object this app creates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String objectType;




  /**
   * This is always drive#app.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * This is always drive#app.
   * The value set may be {@code null}.
   */
  public App setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The list of primary file extensions.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getPrimaryFileExtensions() {
    return primaryFileExtensions;
  }

  /**
   * The list of primary file extensions.
   * The value set may be {@code null}.
   */
  public App setPrimaryFileExtensions(java.util.List<String> primaryFileExtensions) {
    this.primaryFileExtensions = primaryFileExtensions;
    return this;
  }

  /**
   * The name of the app.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * The name of the app.
   * The value set may be {@code null}.
   */
  public App setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * The various icons for the app.
   * The value returned may be {@code null}.
   */
  public java.util.List<Icons> getIcons() {
    return icons;
  }

  /**
   * The various icons for the app.
   * The value set may be {@code null}.
   */
  public App setIcons(java.util.List<Icons> icons) {
    this.icons = icons;
    return this;
  }

  /**
   * The list of secondary file extensions.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getSecondaryFileExtensions() {
    return secondaryFileExtensions;
  }

  /**
   * The list of secondary file extensions.
   * The value set may be {@code null}.
   */
  public App setSecondaryFileExtensions(java.util.List<String> secondaryFileExtensions) {
    this.secondaryFileExtensions = secondaryFileExtensions;
    return this;
  }

  /**
   * Whether the app is installed.
   * The value returned may be {@code null}.
   */
  public Boolean getInstalled() {
    return installed;
  }

  /**
   * Whether the app is installed.
   * The value set may be {@code null}.
   */
  public App setInstalled(Boolean installed) {
    this.installed = installed;
    return this;
  }

  /**
   * The product URL.
   * The value returned may be {@code null}.
   */
  public String getProductUrl() {
    return productUrl;
  }

  /**
   * The product URL.
   * The value set may be {@code null}.
   */
  public App setProductUrl(String productUrl) {
    this.productUrl = productUrl;
    return this;
  }

  /**
   * The list of secondary mime types.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getSecondaryMimeTypes() {
    return secondaryMimeTypes;
  }

  /**
   * The list of secondary mime types.
   * The value set may be {@code null}.
   */
  public App setSecondaryMimeTypes(java.util.List<String> secondaryMimeTypes) {
    this.secondaryMimeTypes = secondaryMimeTypes;
    return this;
  }

  /**
   * Whether the app is authorized to access data on the user's Drive.
   * The value returned may be {@code null}.
   */
  public Boolean getAuthorized() {
    return authorized;
  }

  /**
   * Whether the app is authorized to access data on the user's Drive.
   * The value set may be {@code null}.
   */
  public App setAuthorized(Boolean authorized) {
    this.authorized = authorized;
    return this;
  }

  /**
   * Whether this app supports creating new objects.
   * The value returned may be {@code null}.
   */
  public Boolean getSupportsCreate() {
    return supportsCreate;
  }

  /**
   * Whether this app supports creating new objects.
   * The value set may be {@code null}.
   */
  public App setSupportsCreate(Boolean supportsCreate) {
    this.supportsCreate = supportsCreate;
    return this;
  }

  /**
   * Whether this app supports importing Google Docs.
   * The value returned may be {@code null}.
   */
  public Boolean getSupportsImport() {
    return supportsImport;
  }

  /**
   * Whether this app supports importing Google Docs.
   * The value set may be {@code null}.
   */
  public App setSupportsImport(Boolean supportsImport) {
    this.supportsImport = supportsImport;
    return this;
  }

  /**
   * The list of primary mime types.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getPrimaryMimeTypes() {
    return primaryMimeTypes;
  }

  /**
   * The list of primary mime types.
   * The value set may be {@code null}.
   */
  public App setPrimaryMimeTypes(java.util.List<String> primaryMimeTypes) {
    this.primaryMimeTypes = primaryMimeTypes;
    return this;
  }

  /**
   * The ID of the app.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * The ID of the app.
   * The value set may be {@code null}.
   */
  public App setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The name of the type of object this app creates.
   * The value returned may be {@code null}.
   */
  public String getObjectType() {
    return objectType;
  }

  /**
   * The name of the type of object this app creates.
   * The value set may be {@code null}.
   */
  public App setObjectType(String objectType) {
    this.objectType = objectType;
    return this;
  }


  private HttpHeaders responseHeaders;

  /**
   * Sets the HTTP headers returned with the server response, or <code>null</code>.
   *
   * This member should only be non-null if this object was the top level element of a response. For
   * example, a request that returns a single {@link App} would include the response headers, while
   * a request which returns an array of {@link App}, would have a non-null response header in the
   * enclosing object only.
   */
  public void setResponseHeaders(HttpHeaders responseHeaders) {
    this.responseHeaders = responseHeaders;
  }

  /**
   * Returns the HTTP headers that were returned with the server response, or
   * <code>null</code>.
   */
  public HttpHeaders getResponseHeaders() {
    return responseHeaders;
  }




  /**
   * Model definition for AppIcons.
   */
  public static final class Icons extends GenericJson {


    /**
     * Category of the icon. Allowed values are: - application - icon for the application  - document
     * - icon for a file associated with the app  - documentShared - icon for a shared file associated
     * with the app
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String category;



    /**
     * URL for the icon.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String iconUrl;



    /**
     * Size of the icon. Represented as the maximum of the width and height.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Integer size;




    /**
     * Category of the icon. Allowed values are: - application - icon for the application  - document
     * - icon for a file associated with the app  - documentShared - icon for a shared file associated
     * with the app
     * The value returned may be {@code null}.
     */
    public String getCategory() {
      return category;
    }

    /**
     * Category of the icon. Allowed values are: - application - icon for the application  - document
     * - icon for a file associated with the app  - documentShared - icon for a shared file associated
     * with the app
     * The value set may be {@code null}.
     */
    public Icons setCategory(String category) {
      this.category = category;
      return this;
    }

    /**
     * URL for the icon.
     * The value returned may be {@code null}.
     */
    public String getIconUrl() {
      return iconUrl;
    }

    /**
     * URL for the icon.
     * The value set may be {@code null}.
     */
    public Icons setIconUrl(String iconUrl) {
      this.iconUrl = iconUrl;
      return this;
    }

    /**
     * Size of the icon. Represented as the maximum of the width and height.
     * The value returned may be {@code null}.
     */
    public Integer getSize() {
      return size;
    }

    /**
     * Size of the icon. Represented as the maximum of the width and height.
     * The value set may be {@code null}.
     */
    public Icons setSize(Integer size) {
      this.size = size;
      return this;
    }

  }











}
