/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.drive.model;


import com.google.api.client.http.HttpHeaders;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.api.client.util.DateTime;


/**
 * The metadata for a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
public final class File extends GenericJson {


  /**
   * The MIME type of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String mimeType;



  /**
   * A link to the file's thumbnail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String thumbnailLink;



  /**
   * A group of labels for the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Labels labels;



  /**
   * Indexable text attributes for the file (can only be written)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IndexableText indexableText;



  /**
   * ETag of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String etag;



  /**
   * Name of the last user to modify this file. This will only be populated if a user has edited
   * this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastModifyingUserName;



  /**
   * Whether writers can share the document with other users.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean writersCanShare;



  /**
   * The id of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;



  /**
   * The title of this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String title;



  /**
   * Name(s) of the owner(s) of this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> ownerNames;



  /**
   * Time at which this file was shared with the user (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime sharedWithMeDate;



  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime lastViewedByMeDate;



  /**
   * Collection of parent folders which contain this file. On insert, setting this field will put
   * the file in all of the provided folders. If no folders are provided, the file will be placed in
   * the default root folder. On update, this field is ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ParentReference> parents;

  static {
    // hack to force ProGuard to consider ParentReference used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ParentReference.class);
  }

  /**
   * Links for exporting Google Docs to specific formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, String> exportLinks;



  /**
   * The filename when uploading this file. This will only be populated on files with content stored
   * in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String originalFilename;



  /**
   * A short description of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;



  /**
   * Whether the file can be edited by the current user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean editable;



  /**
   * The type of file. This is always drive#file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;



  /**
   * The number of quota bytes used by this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private Long quotaBytesUsed;



  /**
   * The size of the file in bytes. This will only be populated on files with content stored in
   * Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private Long fileSize;



  /**
   * Create time for this file (formatted ISO8601 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime createdDate;



  /**
   * An MD5 checksum for the content of this file. This will only be populated on files with content
   * stored in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String md5Checksum;



  /**
   * A link for embedding the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String embedLink;



  /**
   * A link for opening the file in a browser.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String alternateLink;



  /**
   * A link to the permissions collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String permissionsLink;



  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime modifiedByMeDate;



  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String downloadUrl;



  /**
   * The permissions for the authenticated user on this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Permission userPermission;



  /**
   * The file extension used when downloading this file. This field is read only. To set the
   * extension, include it on title when creating the file. This will only be populated on files
   * with content stored in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fileExtension;



  /**
   * A link back to this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;



  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime modifiedDate;




  /**
   * The MIME type of the file.
   * The value returned may be {@code null}.
   */
  public String getMimeType() {
    return mimeType;
  }

  /**
   * The MIME type of the file.
   * The value set may be {@code null}.
   */
  public File setMimeType(String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * A link to the file's thumbnail.
   * The value returned may be {@code null}.
   */
  public String getThumbnailLink() {
    return thumbnailLink;
  }

  /**
   * A link to the file's thumbnail.
   * The value set may be {@code null}.
   */
  public File setThumbnailLink(String thumbnailLink) {
    this.thumbnailLink = thumbnailLink;
    return this;
  }

  /**
   * A group of labels for the file.
   * The value returned may be {@code null}.
   */
  public Labels getLabels() {
    return labels;
  }

  /**
   * A group of labels for the file.
   * The value set may be {@code null}.
   */
  public File setLabels(Labels labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Indexable text attributes for the file (can only be written)
   * The value returned may be {@code null}.
   */
  public IndexableText getIndexableText() {
    return indexableText;
  }

  /**
   * Indexable text attributes for the file (can only be written)
   * The value set may be {@code null}.
   */
  public File setIndexableText(IndexableText indexableText) {
    this.indexableText = indexableText;
    return this;
  }

  /**
   * ETag of the file.
   * The value returned may be {@code null}.
   */
  public String getEtag() {
    return etag;
  }

  /**
   * ETag of the file.
   * The value set may be {@code null}.
   */
  public File setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Name of the last user to modify this file. This will only be populated if a user has edited
   * this file.
   * The value returned may be {@code null}.
   */
  public String getLastModifyingUserName() {
    return lastModifyingUserName;
  }

  /**
   * Name of the last user to modify this file. This will only be populated if a user has edited
   * this file.
   * The value set may be {@code null}.
   */
  public File setLastModifyingUserName(String lastModifyingUserName) {
    this.lastModifyingUserName = lastModifyingUserName;
    return this;
  }

  /**
   * Whether writers can share the document with other users.
   * The value returned may be {@code null}.
   */
  public Boolean getWritersCanShare() {
    return writersCanShare;
  }

  /**
   * Whether writers can share the document with other users.
   * The value set may be {@code null}.
   */
  public File setWritersCanShare(Boolean writersCanShare) {
    this.writersCanShare = writersCanShare;
    return this;
  }

  /**
   * The id of the file.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * The id of the file.
   * The value set may be {@code null}.
   */
  public File setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The title of this file.
   * The value returned may be {@code null}.
   */
  public String getTitle() {
    return title;
  }

  /**
   * The title of this file.
   * The value set may be {@code null}.
   */
  public File setTitle(String title) {
    this.title = title;
    return this;
  }

  /**
   * Name(s) of the owner(s) of this file.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getOwnerNames() {
    return ownerNames;
  }

  /**
   * Name(s) of the owner(s) of this file.
   * The value set may be {@code null}.
   */
  public File setOwnerNames(java.util.List<String> ownerNames) {
    this.ownerNames = ownerNames;
    return this;
  }

  /**
   * Time at which this file was shared with the user (formatted RFC 3339 timestamp).
   * The value returned may be {@code null}.
   */
  public DateTime getSharedWithMeDate() {
    return sharedWithMeDate;
  }

  /**
   * Time at which this file was shared with the user (formatted RFC 3339 timestamp).
   * The value set may be {@code null}.
   */
  public File setSharedWithMeDate(DateTime sharedWithMeDate) {
    this.sharedWithMeDate = sharedWithMeDate;
    return this;
  }

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * The value returned may be {@code null}.
   */
  public DateTime getLastViewedByMeDate() {
    return lastViewedByMeDate;
  }

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * The value set may be {@code null}.
   */
  public File setLastViewedByMeDate(DateTime lastViewedByMeDate) {
    this.lastViewedByMeDate = lastViewedByMeDate;
    return this;
  }

  /**
   * Collection of parent folders which contain this file. On insert, setting this field will put
   * the file in all of the provided folders. If no folders are provided, the file will be placed in
   * the default root folder. On update, this field is ignored.
   * The value returned may be {@code null}.
   */
  public java.util.List<ParentReference> getParents() {
    return parents;
  }

  /**
   * Collection of parent folders which contain this file. On insert, setting this field will put
   * the file in all of the provided folders. If no folders are provided, the file will be placed in
   * the default root folder. On update, this field is ignored.
   * The value set may be {@code null}.
   */
  public File setParents(java.util.List<ParentReference> parents) {
    this.parents = parents;
    return this;
  }

  /**
   * Links for exporting Google Docs to specific formats.
   * The value returned may be {@code null}.
   */
  public java.util.Map<String, String> getExportLinks() {
    return exportLinks;
  }

  /**
   * Links for exporting Google Docs to specific formats.
   * The value set may be {@code null}.
   */
  public File setExportLinks(java.util.Map<String, String> exportLinks) {
    this.exportLinks = exportLinks;
    return this;
  }

  /**
   * The filename when uploading this file. This will only be populated on files with content stored
   * in Drive.
   * The value returned may be {@code null}.
   */
  public String getOriginalFilename() {
    return originalFilename;
  }

  /**
   * The filename when uploading this file. This will only be populated on files with content stored
   * in Drive.
   * The value set may be {@code null}.
   */
  public File setOriginalFilename(String originalFilename) {
    this.originalFilename = originalFilename;
    return this;
  }

  /**
   * A short description of the file.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * A short description of the file.
   * The value set may be {@code null}.
   */
  public File setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Whether the file can be edited by the current user.
   * The value returned may be {@code null}.
   */
  public Boolean getEditable() {
    return editable;
  }

  /**
   * Whether the file can be edited by the current user.
   * The value set may be {@code null}.
   */
  public File setEditable(Boolean editable) {
    this.editable = editable;
    return this;
  }

  /**
   * The type of file. This is always drive#file.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * The type of file. This is always drive#file.
   * The value set may be {@code null}.
   */
  public File setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The number of quota bytes used by this file.
   * The value returned may be {@code null}.
   */
  public Long getQuotaBytesUsed() {
    return quotaBytesUsed;
  }

  /**
   * The number of quota bytes used by this file.
   * The value set may be {@code null}.
   */
  public File setQuotaBytesUsed(Long quotaBytesUsed) {
    this.quotaBytesUsed = quotaBytesUsed;
    return this;
  }

  /**
   * The size of the file in bytes. This will only be populated on files with content stored in
   * Drive.
   * The value returned may be {@code null}.
   */
  public Long getFileSize() {
    return fileSize;
  }

  /**
   * The size of the file in bytes. This will only be populated on files with content stored in
   * Drive.
   * The value set may be {@code null}.
   */
  public File setFileSize(Long fileSize) {
    this.fileSize = fileSize;
    return this;
  }

  /**
   * Create time for this file (formatted ISO8601 timestamp).
   * The value returned may be {@code null}.
   */
  public DateTime getCreatedDate() {
    return createdDate;
  }

  /**
   * Create time for this file (formatted ISO8601 timestamp).
   * The value set may be {@code null}.
   */
  public File setCreatedDate(DateTime createdDate) {
    this.createdDate = createdDate;
    return this;
  }

  /**
   * An MD5 checksum for the content of this file. This will only be populated on files with content
   * stored in Drive.
   * The value returned may be {@code null}.
   */
  public String getMd5Checksum() {
    return md5Checksum;
  }

  /**
   * An MD5 checksum for the content of this file. This will only be populated on files with content
   * stored in Drive.
   * The value set may be {@code null}.
   */
  public File setMd5Checksum(String md5Checksum) {
    this.md5Checksum = md5Checksum;
    return this;
  }

  /**
   * A link for embedding the file.
   * The value returned may be {@code null}.
   */
  public String getEmbedLink() {
    return embedLink;
  }

  /**
   * A link for embedding the file.
   * The value set may be {@code null}.
   */
  public File setEmbedLink(String embedLink) {
    this.embedLink = embedLink;
    return this;
  }

  /**
   * A link for opening the file in a browser.
   * The value returned may be {@code null}.
   */
  public String getAlternateLink() {
    return alternateLink;
  }

  /**
   * A link for opening the file in a browser.
   * The value set may be {@code null}.
   */
  public File setAlternateLink(String alternateLink) {
    this.alternateLink = alternateLink;
    return this;
  }

  /**
   * A link to the permissions collection.
   * The value returned may be {@code null}.
   */
  public String getPermissionsLink() {
    return permissionsLink;
  }

  /**
   * A link to the permissions collection.
   * The value set may be {@code null}.
   */
  public File setPermissionsLink(String permissionsLink) {
    this.permissionsLink = permissionsLink;
    return this;
  }

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp).
   * The value returned may be {@code null}.
   */
  public DateTime getModifiedByMeDate() {
    return modifiedByMeDate;
  }

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp).
   * The value set may be {@code null}.
   */
  public File setModifiedByMeDate(DateTime modifiedByMeDate) {
    this.modifiedByMeDate = modifiedByMeDate;
    return this;
  }

  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * The value returned may be {@code null}.
   */
  public String getDownloadUrl() {
    return downloadUrl;
  }

  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * The value set may be {@code null}.
   */
  public File setDownloadUrl(String downloadUrl) {
    this.downloadUrl = downloadUrl;
    return this;
  }

  /**
   * The permissions for the authenticated user on this file.
   * The value returned may be {@code null}.
   */
  public Permission getUserPermission() {
    return userPermission;
  }

  /**
   * The permissions for the authenticated user on this file.
   * The value set may be {@code null}.
   */
  public File setUserPermission(Permission userPermission) {
    this.userPermission = userPermission;
    return this;
  }

  /**
   * The file extension used when downloading this file. This field is read only. To set the
   * extension, include it on title when creating the file. This will only be populated on files
   * with content stored in Drive.
   * The value returned may be {@code null}.
   */
  public String getFileExtension() {
    return fileExtension;
  }

  /**
   * The file extension used when downloading this file. This field is read only. To set the
   * extension, include it on title when creating the file. This will only be populated on files
   * with content stored in Drive.
   * The value set may be {@code null}.
   */
  public File setFileExtension(String fileExtension) {
    this.fileExtension = fileExtension;
    return this;
  }

  /**
   * A link back to this file.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * A link back to this file.
   * The value set may be {@code null}.
   */
  public File setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp).
   * The value returned may be {@code null}.
   */
  public DateTime getModifiedDate() {
    return modifiedDate;
  }

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp).
   * The value set may be {@code null}.
   */
  public File setModifiedDate(DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
    return this;
  }


  private HttpHeaders responseHeaders;

  /**
   * Sets the HTTP headers returned with the server response, or <code>null</code>.
   *
   * This member should only be non-null if this object was the top level element of a response. For
   * example, a request that returns a single {@link File} would include the response headers, while
   * a request which returns an array of {@link File}, would have a non-null response header in the
   * enclosing object only.
   */
  public void setResponseHeaders(HttpHeaders responseHeaders) {
    this.responseHeaders = responseHeaders;
  }

  /**
   * Returns the HTTP headers that were returned with the server response, or
   * <code>null</code>.
   */
  public HttpHeaders getResponseHeaders() {
    return responseHeaders;
  }



  /**
   * A group of labels for the file.
   */
  public static final class Labels extends GenericJson {


    /**
     * Whether viewers are prevented from downloading this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean restricted;



    /**
     * Whether this file is hidden from the user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean hidden;



    /**
     * Whether this file has been viewed by this user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean viewed;



    /**
     * Whether this file is starred by the user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean starred;



    /**
     * Whether this file has been trashed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean trashed;




    /**
     * Whether viewers are prevented from downloading this file.
     * The value returned may be {@code null}.
     */
    public Boolean getRestricted() {
      return restricted;
    }

    /**
     * Whether viewers are prevented from downloading this file.
     * The value set may be {@code null}.
     */
    public Labels setRestricted(Boolean restricted) {
      this.restricted = restricted;
      return this;
    }

    /**
     * Whether this file is hidden from the user.
     * The value returned may be {@code null}.
     */
    public Boolean getHidden() {
      return hidden;
    }

    /**
     * Whether this file is hidden from the user.
     * The value set may be {@code null}.
     */
    public Labels setHidden(Boolean hidden) {
      this.hidden = hidden;
      return this;
    }

    /**
     * Whether this file has been viewed by this user.
     * The value returned may be {@code null}.
     */
    public Boolean getViewed() {
      return viewed;
    }

    /**
     * Whether this file has been viewed by this user.
     * The value set may be {@code null}.
     */
    public Labels setViewed(Boolean viewed) {
      this.viewed = viewed;
      return this;
    }

    /**
     * Whether this file is starred by the user.
     * The value returned may be {@code null}.
     */
    public Boolean getStarred() {
      return starred;
    }

    /**
     * Whether this file is starred by the user.
     * The value set may be {@code null}.
     */
    public Labels setStarred(Boolean starred) {
      this.starred = starred;
      return this;
    }

    /**
     * Whether this file has been trashed.
     * The value returned may be {@code null}.
     */
    public Boolean getTrashed() {
      return trashed;
    }

    /**
     * Whether this file has been trashed.
     * The value set may be {@code null}.
     */
    public Labels setTrashed(Boolean trashed) {
      this.trashed = trashed;
      return this;
    }

  }

  /**
   * Indexable text attributes for the file (can only be written)
   */
  public static final class IndexableText extends GenericJson {


    /**
     * The text to be indexed for this file
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String text;




    /**
     * The text to be indexed for this file
     * The value returned may be {@code null}.
     */
    public String getText() {
      return text;
    }

    /**
     * The text to be indexed for this file
     * The value set may be {@code null}.
     */
    public IndexableText setText(String text) {
      this.text = text;
      return this;
    }

  }


























}
