/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.drive.model;


import com.google.api.client.http.HttpHeaders;
import com.google.api.client.json.GenericJson;


/**
 * A list of files.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
public final class FileList extends GenericJson {


  /**
   * The page token for the next page of files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextPageToken;



  /**
   * This is always drive#fileList.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;



  /**
   * The actual list of files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<File> items;

  static {
    // hack to force ProGuard to consider File used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(File.class);
  }

  /**
   * A link to the next page of files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextLink;



  /**
   * The ETag of the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String etag;



  /**
   * A link back to this list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;




  /**
   * The page token for the next page of files.
   * The value returned may be {@code null}.
   */
  public String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The page token for the next page of files.
   * The value set may be {@code null}.
   */
  public FileList setNextPageToken(String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * This is always drive#fileList.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * This is always drive#fileList.
   * The value set may be {@code null}.
   */
  public FileList setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The actual list of files.
   * The value returned may be {@code null}.
   */
  public java.util.List<File> getItems() {
    return items;
  }

  /**
   * The actual list of files.
   * The value set may be {@code null}.
   */
  public FileList setItems(java.util.List<File> items) {
    this.items = items;
    return this;
  }

  /**
   * A link to the next page of files.
   * The value returned may be {@code null}.
   */
  public String getNextLink() {
    return nextLink;
  }

  /**
   * A link to the next page of files.
   * The value set may be {@code null}.
   */
  public FileList setNextLink(String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * The ETag of the list.
   * The value returned may be {@code null}.
   */
  public String getEtag() {
    return etag;
  }

  /**
   * The ETag of the list.
   * The value set may be {@code null}.
   */
  public FileList setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * A link back to this list.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * A link back to this list.
   * The value set may be {@code null}.
   */
  public FileList setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }


  private HttpHeaders responseHeaders;

  /**
   * Sets the HTTP headers returned with the server response, or <code>null</code>.
   *
   * This member should only be non-null if this object was the top level element of a response. For
   * example, a request that returns a single {@link FileList} would include the response headers,
   * while a request which returns an array of {@link FileList}, would have a non-null response
   * header in the enclosing object only.
   */
  public void setResponseHeaders(HttpHeaders responseHeaders) {
    this.responseHeaders = responseHeaders;
  }

  /**
   * Returns the HTTP headers that were returned with the server response, or
   * <code>null</code>.
   */
  public HttpHeaders getResponseHeaders() {
    return responseHeaders;
  }






}
