/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.oauth2.model;

import com.google.api.client.json.GenericJson;

/**
 * Model definition for Tokeninfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google OAuth2 API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Tokeninfo extends GenericJson {

  /**
   * The access type granted with this token. It can be offline or online.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("access_type")
  private String accessType;

  /**
   * Who is the intended audience for this token. In general the same as issued_to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String audience;

  /**
   * The email address of the user. Present only if the email scope is present in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String email;

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("email_verified")
  private Boolean emailVerified;

  /**
   * The expiry time of the token, as number of seconds left until expiry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("expires_in")
  private Integer expiresIn;

  /**
   * The issue time of the token, as number of seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("issued_at")
  private Integer issuedAt;

  /**
   * To whom was the token issued to. In general the same as audience.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("issued_to")
  private String issuedTo;

  /**
   * Who issued the token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String issuer;

  /**
   * Nonce of the id token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nonce;

  /**
   * The space separated list of scopes granted to this token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String scope;

  /**
   * The Gaia obfuscated user id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("user_id")
  private String userId;

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("verified_email")
  private Boolean verifiedEmail;

  /**
   * The access type granted with this token. It can be offline or online.
   * The value returned may be {@code null}.
   */
  public String getAccessType() {
    return accessType;
  }

  /**
   * The access type granted with this token. It can be offline or online.
   * The value set may be {@code null}.
   */
  public Tokeninfo setAccessType(String accessType) {
    this.accessType = accessType;
    return this;
  }

  /**
   * Who is the intended audience for this token. In general the same as issued_to.
   * The value returned may be {@code null}.
   */
  public String getAudience() {
    return audience;
  }

  /**
   * Who is the intended audience for this token. In general the same as issued_to.
   * The value set may be {@code null}.
   */
  public Tokeninfo setAudience(String audience) {
    this.audience = audience;
    return this;
  }

  /**
   * The email address of the user. Present only if the email scope is present in the request.
   * The value returned may be {@code null}.
   */
  public String getEmail() {
    return email;
  }

  /**
   * The email address of the user. Present only if the email scope is present in the request.
   * The value set may be {@code null}.
   */
  public Tokeninfo setEmail(String email) {
    this.email = email;
    return this;
  }

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * The value returned may be {@code null}.
   */
  public Boolean getEmailVerified() {
    return emailVerified;
  }

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * The value set may be {@code null}.
   */
  public Tokeninfo setEmailVerified(Boolean emailVerified) {
    this.emailVerified = emailVerified;
    return this;
  }

  /**
   * The expiry time of the token, as number of seconds left until expiry.
   * The value returned may be {@code null}.
   */
  public Integer getExpiresIn() {
    return expiresIn;
  }

  /**
   * The expiry time of the token, as number of seconds left until expiry.
   * The value set may be {@code null}.
   */
  public Tokeninfo setExpiresIn(Integer expiresIn) {
    this.expiresIn = expiresIn;
    return this;
  }

  /**
   * The issue time of the token, as number of seconds.
   * The value returned may be {@code null}.
   */
  public Integer getIssuedAt() {
    return issuedAt;
  }

  /**
   * The issue time of the token, as number of seconds.
   * The value set may be {@code null}.
   */
  public Tokeninfo setIssuedAt(Integer issuedAt) {
    this.issuedAt = issuedAt;
    return this;
  }

  /**
   * To whom was the token issued to. In general the same as audience.
   * The value returned may be {@code null}.
   */
  public String getIssuedTo() {
    return issuedTo;
  }

  /**
   * To whom was the token issued to. In general the same as audience.
   * The value set may be {@code null}.
   */
  public Tokeninfo setIssuedTo(String issuedTo) {
    this.issuedTo = issuedTo;
    return this;
  }

  /**
   * Who issued the token.
   * The value returned may be {@code null}.
   */
  public String getIssuer() {
    return issuer;
  }

  /**
   * Who issued the token.
   * The value set may be {@code null}.
   */
  public Tokeninfo setIssuer(String issuer) {
    this.issuer = issuer;
    return this;
  }

  /**
   * Nonce of the id token.
   * The value returned may be {@code null}.
   */
  public String getNonce() {
    return nonce;
  }

  /**
   * Nonce of the id token.
   * The value set may be {@code null}.
   */
  public Tokeninfo setNonce(String nonce) {
    this.nonce = nonce;
    return this;
  }

  /**
   * The space separated list of scopes granted to this token.
   * The value returned may be {@code null}.
   */
  public String getScope() {
    return scope;
  }

  /**
   * The space separated list of scopes granted to this token.
   * The value set may be {@code null}.
   */
  public Tokeninfo setScope(String scope) {
    this.scope = scope;
    return this;
  }

  /**
   * The Gaia obfuscated user id.
   * The value returned may be {@code null}.
   */
  public String getUserId() {
    return userId;
  }

  /**
   * The Gaia obfuscated user id.
   * The value set may be {@code null}.
   */
  public Tokeninfo setUserId(String userId) {
    this.userId = userId;
    return this;
  }

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * The value returned may be {@code null}.
   */
  public Boolean getVerifiedEmail() {
    return verifiedEmail;
  }

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * The value set may be {@code null}.
   */
  public Tokeninfo setVerifiedEmail(Boolean verifiedEmail) {
    this.verifiedEmail = verifiedEmail;
    return this;
  }

}
